# coding: utf-8
"""
    Snowflake Notification Integration API.

    The Snowflake Notification Integration API is a REST API that you can use to access, update, and perform certain actions on Notification Integration resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, Field, field_validator

from typing import Any, ClassVar, Dict, List

from typing_extensions import Annotated


class WebhookSecret(BaseModel):
    """A model object representing the WebhookSecret resource.

    Constructs an object of type WebhookSecret with the provided properties.

    Parameters
    __________
    name : str
        The name of the secret.
    database_name : str
        The database which stores the secret.
    schema_name : str
        The schema which stores the secret.
    """

    name: Annotated[str, Field(strict=True)]

    database_name: Annotated[str, Field(strict=True)]

    schema_name: Annotated[str, Field(strict=True)]

    __properties = ["name", "database_name", "schema_name"]

    @field_validator('name')
    def name_validate_regular_expression(cls, v):

        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('database_name')
    def database_name_validate_regular_expression(cls, v):

        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('schema_name')
    def schema_name_validate_regular_expression(cls, v):

        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WebhookSecret:
        """Create an instance of WebhookSecret from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> WebhookSecret:
        """Create an instance of WebhookSecret from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return WebhookSecret.parse_obj(obj)

        _obj = WebhookSecret.parse_obj({
            "name":
            obj.get("name"),
            "database_name":
            obj.get("database_name"),
            "schema_name":
            obj.get("schema_name"),
        })

        return _obj


from typing import Optional, List, Dict


class WebhookSecretModel():

    def __init__(
        self,
        name: str,
        database_name: str,
        schema_name: str,
        # optional properties
    ):
        """A model object representing the WebhookSecret resource.

        Constructs an object of type WebhookSecret with the provided properties.

        Parameters
        __________
        name : str
            The name of the secret.
        database_name : str
            The database which stores the secret.
        schema_name : str
            The schema which stores the secret.
        """

        self.name = name
        self.database_name = database_name
        self.schema_name = schema_name

    __properties = ["name", "database_name", "schema_name"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return WebhookSecret(
            name=self.name,
            database_name=self.database_name,
            schema_name=self.schema_name,
        )

    @classmethod
    def _from_model(cls, model) -> WebhookSecretModel:
        return WebhookSecretModel(
            name=model.name,
            database_name=model.database_name,
            schema_name=model.schema_name,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a WebhookSecret.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the WebhookSecret object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> WebhookSecretModel:
        """Creates an instance of WebhookSecret from a dict.

        This method constructs a WebhookSecret object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        WebhookSecret
            A WebhookSecret object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(WebhookSecret.from_dict(obj))


WebhookSecret._model_class = WebhookSecretModel
