# coding: utf-8
"""
    Snowflake Procedure API.

    The Snowflake Procedure API is a REST API that you can use to access, update, and perform certain actions on Procedure resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import absolute_import

import logging
from pydantic import Field, StrictBool, StrictStr, field_validator
from typing import Any, List, Optional
from typing_extensions import Annotated
from snowflake.core.procedure._generated.models.call_argument_list import CallArgumentList
from snowflake.core.procedure._generated.models.procedure import Procedure
from snowflake.core.procedure._generated.models.success_response import SuccessResponse
from typing import Iterable

from snowflake.core.procedure._generated.api_client import ApiClient

from concurrent.futures import Future
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Literal, Optional, Tuple, Union, overload
from typing_extensions import Annotated

from snowflake.core._internal.utils import is_running_inside_stored_procedure

from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError, _APIValueError)

logger = logging.getLogger(__name__)


class ProcedureApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech.

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = 'procedure'
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default(self._root)

    @property
    def api_client(self):
        return self._api_client

    @overload
    def create_procedure(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            procedure: Procedure,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            copy_grants:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter to enable copy grants when creating the object."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def create_procedure(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            procedure: Procedure,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            copy_grants:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter to enable copy grants when creating the object."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def create_procedure(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            procedure: Procedure,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            copy_grants:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter to enable copy grants when creating the object."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def create_procedure(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        procedure: Procedure,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
        copy_grants: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter to enable copy grants when creating the object."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Create a procedure  # noqa: E501.

        Create a procedure  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_procedure(database, var_schema, procedure, create_mode, copy_grants, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param procedure: (required)
        :type procedure: Procedure
        :param create_mode: Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param copy_grants: Query parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.create_procedure_with_http_info(database, var_schema,
                                                    procedure, create_mode,
                                                    copy_grants,
                                                    **kwargs)  # noqa: E501

    @validate_call
    def create_procedure_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            procedure: Procedure,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            copy_grants:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter to enable copy grants when creating the object."
            )] = None,
            **kwargs):  # noqa: E501
        """Create a procedure  # noqa: E501.

        Create a procedure  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_procedure_with_http_info(database, var_schema, procedure, create_mode, copy_grants, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param procedure: (required)
        :type procedure: Procedure
        :param create_mode: Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param copy_grants: Query parameter to enable copy grants when creating the object.
        :type copy_grants: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'database', 'var_schema', 'procedure', 'create_mode', 'copy_grants'
        ]
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method create_procedure" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        # process the query parameters
        _query_params = []

        if _params.get('create_mode') is not None:  # noqa: E501
            _query_params.append(('createMode', _params['create_mode']))

        if _params.get('copy_grants') is not None:  # noqa: E501
            _query_params.append(('copyGrants', _params['copy_grants']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['procedure']:
            _body_params = _params['procedure']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/procedures',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def call_procedure(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
            call_argument_list: CallArgumentList,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[object]:
        ...

    @overload
    def call_procedure(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
            call_argument_list: CallArgumentList,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[object]]:
        ...

    @overload
    def call_procedure(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
            call_argument_list: CallArgumentList,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[object], Future[Iterable[object]]]:
        ...

    @validate_call
    def call_procedure(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
                       call_argument_list: CallArgumentList, **kwargs
                       ) -> Union[Iterable[object],
                                  Future[Iterable[object]]]:  # noqa: E501
        """Call a procedure  # noqa: E501.

        Call a procedure  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.call_procedure(database, var_schema, name_with_args, call_argument_list, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param call_argument_list: (required)
        :type call_argument_list: CallArgumentList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[object], Future[Iterable[object]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.call_procedure_with_http_info(database, var_schema,
                                                  name_with_args,
                                                  call_argument_list,
                                                  **kwargs)  # noqa: E501

    @validate_call
    def call_procedure_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
                                      call_argument_list: CallArgumentList,
                                      **kwargs):  # noqa: E501
        """Call a procedure  # noqa: E501.

        Call a procedure  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.call_procedure_with_http_info(database, var_schema, name_with_args, call_argument_list, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param call_argument_list: (required)
        :type call_argument_list: CallArgumentList
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[object], Future[Iterable[object]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'database', 'var_schema', 'name_with_args', 'call_argument_list'
        ]
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method call_procedure" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name_with_args']:
            _path_params['nameWithArgs'] = _params['name_with_args']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['call_argument_list']:
            _body_params = _params['call_argument_list']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[object]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/procedures/{nameWithArgs}:call',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def fetch_procedure(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
            async_req: Literal[False] = False,
            **kwargs) -> Procedure:
        ...

    @overload
    def fetch_procedure(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[Procedure]:
        ...

    @overload
    def fetch_procedure(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
            async_req: bool = False,
            **kwargs) -> Union[Procedure, Future[Procedure]]:
        ...

    @validate_call
    def fetch_procedure(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")], **kwargs
                        ) -> Union[Procedure, Future[Procedure]]:  # noqa: E501
        """Fetch a procedure  # noqa: E501.

        Fetch a procedure  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_procedure(database, var_schema, name_with_args, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Procedure, Future[Procedure]]
        """
        kwargs['_return_http_data_only'] = True
        return self.fetch_procedure_with_http_info(database, var_schema,
                                                   name_with_args,
                                                   **kwargs)  # noqa: E501

    @validate_call
    def fetch_procedure_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )], name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
                                       **kwargs):  # noqa: E501
        """Fetch a procedure  # noqa: E501.

        Fetch a procedure  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_procedure_with_http_info(database, var_schema, name_with_args, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Procedure, Future[Procedure]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name_with_args']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method fetch_procedure" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name_with_args']:
            _path_params['nameWithArgs'] = _params['name_with_args']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Procedure",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/procedures/{nameWithArgs}',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_procedures(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[Procedure]:
        ...

    @overload
    def list_procedures(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[Procedure]]:
        ...

    @overload
    def list_procedures(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            async_req: bool = False,
            **kwargs
    ) -> Union[Iterable[Procedure], Future[Iterable[Procedure]]]:
        ...

    @validate_call
    def list_procedures(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
        **kwargs
    ) -> Union[Iterable[Procedure], Future[Iterable[Procedure]]]:  # noqa: E501
        """List procedures  # noqa: E501.

        List procedures  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_procedures(database, var_schema, like, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param like: Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Procedure], Future[Iterable[Procedure]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_procedures_with_http_info(database, var_schema, like,
                                                   **kwargs)  # noqa: E501

    @validate_call
    def list_procedures_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            **kwargs):  # noqa: E501
        """List procedures  # noqa: E501.

        List procedures  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_procedures_with_http_info(database, var_schema, like, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param like: Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Procedure], Future[Iterable[Procedure]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'like']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_procedures" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        # process the query parameters
        _query_params = []

        if _params.get('like') is not None:  # noqa: E501
            _query_params.append(('like', _params['like']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[Procedure]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/procedures',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def delete_procedure(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def delete_procedure(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def delete_procedure(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def delete_procedure(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        var_schema: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
        name_with_args: Annotated[
            StrictStr,
            Field(description="Function's name with Args")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Delete a procedure  # noqa: E501.

        Delete a procedure  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_procedure(database, var_schema, name_with_args, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_procedure_with_http_info(database, var_schema,
                                                    name_with_args, if_exists,
                                                    **kwargs)  # noqa: E501

    @validate_call
    def delete_procedure_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            var_schema:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database."
            )],
            name_with_args: Annotated[
                StrictStr,
                Field(description="Function's name with Args")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            **kwargs):  # noqa: E501
        """Delete a procedure  # noqa: E501.

        Delete a procedure  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_procedure_with_http_info(database, var_schema, name_with_args, if_exists, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param var_schema: Identifier (i.e. name) for the schema to which the resource belongs. You can use the `/api/v2/databases/{database}/schemas` GET request to get a list of available schemas for the specified database. (required)
        :type var_schema: str
        :param name_with_args: Function's name with Args (required)
        :type name_with_args: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'var_schema', 'name_with_args', 'if_exists']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method delete_procedure" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['var_schema']:
            _path_params['schema'] = _params['var_schema']

        if _params['name_with_args']:
            _path_params['nameWithArgs'] = _params['name_with_args']

        # process the query parameters
        _query_params = []

        if _params.get('if_exists') is not None:  # noqa: E501
            _query_params.append(('ifExists', _params['if_exists']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{schema}/procedures/{nameWithArgs}',
            'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
