# coding: utf-8
"""
    Snowflake Procedure API.

    The Snowflake Procedure API is a REST API that you can use to access, update, and perform certain actions on Procedure resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List

from typing_extensions import Annotated


class ColumnType(BaseModel):
    """A model object representing the ColumnType resource.

    Constructs an object of type ColumnType with the provided properties.

    Parameters
    __________
    name : str
        Argument name
    datatype : str
        Argument data type
    """

    name: Annotated[str, Field(strict=True)]

    datatype: StrictStr

    __properties = ["name", "datatype"]

    @field_validator('name')
    def name_validate_regular_expression(cls, v):

        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('datatype')
    def datatype_validate_enum(cls, v):

        if v not in ('ARRAY', 'BIGINT', 'BINARY', 'BOOLEAN', 'BYTEINT', 'CHAR',
                     'CHARACTER', 'DATE', 'DATETIME', 'DECIMAL', 'DOUBLE',
                     'DOUBLE PRECISION', 'FLOAT', 'FLOAT4', 'FLOAT8',
                     'GEOGRAPHY', 'GEOMETRY', 'INT', 'INTEGER', 'NUMBER',
                     'NUMERIC', 'OBJECT', 'REAL', 'STRING', 'SMALLINT', 'TEXT',
                     'TIME', 'TIMESTAMP_LTZ', 'TIMESTAMP_NTZ', 'TIMESTAMP_TZ',
                     'TINYINT', 'VARBINARY', 'VARCHAR', 'VARIANT', 'VECTOR'):
            raise ValueError(
                "must validate the enum values ('ARRAY','BIGINT','BINARY','BOOLEAN','BYTEINT','CHAR','CHARACTER','DATE','DATETIME','DECIMAL','DOUBLE','DOUBLE PRECISION','FLOAT','FLOAT4','FLOAT8','GEOGRAPHY','GEOMETRY','INT','INTEGER','NUMBER','NUMERIC','OBJECT','REAL','STRING','SMALLINT','TEXT','TIME','TIMESTAMP_LTZ','TIMESTAMP_NTZ','TIMESTAMP_TZ','TINYINT','VARBINARY','VARCHAR','VARIANT','VECTOR')"
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ColumnType:
        """Create an instance of ColumnType from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ColumnType:
        """Create an instance of ColumnType from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ColumnType.parse_obj(obj)

        _obj = ColumnType.parse_obj({
            "name": obj.get("name"),
            "datatype": obj.get("datatype"),
        })

        return _obj


from typing import Optional, List, Dict


class ColumnTypeModel():

    def __init__(
        self,
        name: str,
        datatype: str,
        # optional properties
    ):
        """A model object representing the ColumnType resource.

        Constructs an object of type ColumnType with the provided properties.

        Parameters
        __________
        name : str
            Argument name
        datatype : str
            Argument data type
        """

        self.name = name
        self.datatype = datatype

    __properties = ["name", "datatype"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ColumnType(
            name=self.name,
            datatype=self.datatype,
        )

    @classmethod
    def _from_model(cls, model) -> ColumnTypeModel:
        return ColumnTypeModel(
            name=model.name,
            datatype=model.datatype,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a ColumnType.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ColumnType object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ColumnTypeModel:
        """Creates an instance of ColumnType from a dict.

        This method constructs a ColumnType object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ColumnType
            A ColumnType object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ColumnType.from_dict(obj))


ColumnType._model_class = ColumnTypeModel
