# coding: utf-8
"""
    Snowflake Role API.

    The Snowflake Role API is a REST API that you can use to access, update, and perform certain actions on Role resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import absolute_import

import logging
from pydantic import Field, StrictBool, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from snowflake.core.role._generated.models.grant import Grant
from snowflake.core.role._generated.models.grant_of import GrantOf
from snowflake.core.role._generated.models.grant_on import GrantOn
from snowflake.core.role._generated.models.role import Role
from snowflake.core.role._generated.models.success_response import SuccessResponse
from typing import Iterable

from snowflake.core.role._generated.api_client import ApiClient

from concurrent.futures import Future
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Literal, Optional, Tuple, Union, overload
from typing_extensions import Annotated

from snowflake.core._internal.utils import is_running_inside_stored_procedure

from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError, _APIValueError)

logger = logging.getLogger(__name__)


class RoleApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech.

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = 'role'
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default(self._root)

    @property
    def api_client(self):
        return self._api_client

    @overload
    def create_role(
            self,
            role: Role,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def create_role(
            self,
            role: Role,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def create_role(
            self,
            role: Role,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def create_role(
        self,
        role: Role,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Create a role  # noqa: E501.

        Create a role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_role(role, create_mode, async_req=True)
        >>> result = future.result()
        :param role: (required)
        :type role: Role
        :param create_mode: Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.create_role_with_http_info(role, create_mode,
                                               **kwargs)  # noqa: E501

    @validate_call
    def create_role_with_http_info(
            self,
            role: Role,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            **kwargs):  # noqa: E501
        """Create a role  # noqa: E501.

        Create a role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_role_with_http_info(role, create_mode, async_req=True)
        >>> result = future.result()
        :param role: (required)
        :type role: Role
        :param create_mode: Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['role', 'create_mode']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method create_role" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        if _params.get('create_mode') is not None:  # noqa: E501
            _query_params.append(('createMode', _params['create_mode']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['role']:
            _body_params = _params['role']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/roles',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def grant_future_privileges(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def grant_future_privileges(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def grant_future_privileges(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def grant_future_privileges(
        self, name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        grant: Grant, **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Grant future privileges to the role  # noqa: E501.

        Grant future privileges to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.grant_future_privileges(name, grant, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.grant_future_privileges_with_http_info(
            name, grant, **kwargs)  # noqa: E501

    @validate_call
    def grant_future_privileges_with_http_info(self, name: Annotated[
        str,
        Field(strict=True,
              description="Identifier (i.e. name) for the resource.")],
                                               grant: Grant,
                                               **kwargs):  # noqa: E501
        """Grant future privileges to the role  # noqa: E501.

        Grant future privileges to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.grant_future_privileges_with_http_info(name, grant, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['name', 'grant']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method grant_future_privileges" %
                                    _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['grant']:
            _body_params = _params['grant']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/roles/{name}/future-grants',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def grant_privileges(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def grant_privileges(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def grant_privileges(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def grant_privileges(
        self, name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        grant: Grant, **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Grant privileges to the role  # noqa: E501.

        Grant privileges to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.grant_privileges(name, grant, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.grant_privileges_with_http_info(name, grant,
                                                    **kwargs)  # noqa: E501

    @validate_call
    def grant_privileges_with_http_info(self, name: Annotated[
        str,
        Field(strict=True,
              description="Identifier (i.e. name) for the resource.")],
                                        grant: Grant, **kwargs):  # noqa: E501
        """Grant privileges to the role  # noqa: E501.

        Grant privileges to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.grant_privileges_with_http_info(name, grant, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['name', 'grant']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method grant_privileges" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['grant']:
            _body_params = _params['grant']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/roles/{name}/grants',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_future_grants(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[Grant]:
        ...

    @overload
    def list_future_grants(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[Grant]]:
        ...

    @overload
    def list_future_grants(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[Grant], Future[Iterable[Grant]]]:
        ...

    @validate_call
    def list_future_grants(
        self,
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
        **kwargs
    ) -> Union[Iterable[Grant], Future[Iterable[Grant]]]:  # noqa: E501
        """List all future grants to the role  # noqa: E501.

        List all future grants to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_future_grants(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Grant], Future[Iterable[Grant]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_future_grants_with_http_info(name, show_limit,
                                                      **kwargs)  # noqa: E501

    @validate_call
    def list_future_grants_with_http_info(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            **kwargs):  # noqa: E501
        """List all future grants to the role  # noqa: E501.

        List all future grants to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_future_grants_with_http_info(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Grant], Future[Iterable[Grant]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['name', 'show_limit']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_future_grants" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('show_limit') is not None:  # noqa: E501
            _query_params.append(('showLimit', _params['show_limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[Grant]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/roles/{name}/future-grants',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_grants(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[Grant]:
        ...

    @overload
    def list_grants(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[Grant]]:
        ...

    @overload
    def list_grants(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[Grant], Future[Iterable[Grant]]]:
        ...

    @validate_call
    def list_grants(
        self,
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
        **kwargs
    ) -> Union[Iterable[Grant], Future[Iterable[Grant]]]:  # noqa: E501
        """List all grants to the role  # noqa: E501.

        List all grants to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Grant], Future[Iterable[Grant]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_grants_with_http_info(name, show_limit,
                                               **kwargs)  # noqa: E501

    @validate_call
    def list_grants_with_http_info(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            **kwargs):  # noqa: E501
        """List all grants to the role  # noqa: E501.

        List all grants to the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants_with_http_info(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Grant], Future[Iterable[Grant]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['name', 'show_limit']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_grants" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('show_limit') is not None:  # noqa: E501
            _query_params.append(('showLimit', _params['show_limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[Grant]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/roles/{name}/grants',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_grants_of(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[GrantOf]:
        ...

    @overload
    def list_grants_of(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[GrantOf]]:
        ...

    @overload
    def list_grants_of(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[GrantOf], Future[Iterable[GrantOf]]]:
        ...

    @validate_call
    def list_grants_of(
        self,
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
        **kwargs
    ) -> Union[Iterable[GrantOf], Future[Iterable[GrantOf]]]:  # noqa: E501
        """List all grants of the role  # noqa: E501.

        List all grants of the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants_of(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[GrantOf], Future[Iterable[GrantOf]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_grants_of_with_http_info(name, show_limit,
                                                  **kwargs)  # noqa: E501

    @validate_call
    def list_grants_of_with_http_info(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            **kwargs):  # noqa: E501
        """List all grants of the role  # noqa: E501.

        List all grants of the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants_of_with_http_info(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[GrantOf], Future[Iterable[GrantOf]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['name', 'show_limit']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_grants_of" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('show_limit') is not None:  # noqa: E501
            _query_params.append(('showLimit', _params['show_limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[GrantOf]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/roles/{name}/grants-of',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_grants_on(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[GrantOn]:
        ...

    @overload
    def list_grants_on(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[GrantOn]]:
        ...

    @overload
    def list_grants_on(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[GrantOn], Future[Iterable[GrantOn]]]:
        ...

    @validate_call
    def list_grants_on(
        self,
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
        **kwargs
    ) -> Union[Iterable[GrantOn], Future[Iterable[GrantOn]]]:  # noqa: E501
        """List all grants on the role  # noqa: E501.

        List all grants on the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants_on(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[GrantOn], Future[Iterable[GrantOn]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_grants_on_with_http_info(name, show_limit,
                                                  **kwargs)  # noqa: E501

    @validate_call
    def list_grants_on_with_http_info(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            **kwargs):  # noqa: E501
        """List all grants on the role  # noqa: E501.

        List all grants on the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_grants_on_with_http_info(name, show_limit, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[GrantOn], Future[Iterable[GrantOn]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['name', 'show_limit']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_grants_on" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('show_limit') is not None:  # noqa: E501
            _query_params.append(('showLimit', _params['show_limit']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[GrantOn]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/roles/{name}/grants-on',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_roles(
            self,
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[Role]:
        ...

    @overload
    def list_roles(
            self,
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[Role]]:
        ...

    @overload
    def list_roles(
            self,
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[Iterable[Role], Future[Iterable[Role]]]:
        ...

    @validate_call
    def list_roles(
        self,
        like: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
        **kwargs
    ) -> Union[Iterable[Role], Future[Iterable[Role]]]:  # noqa: E501
        """List roles  # noqa: E501.

        List roles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_roles(like, starts_with, show_limit, from_name, async_req=True)
        >>> result = future.result()
        :param like: Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[Role], Future[Iterable[Role]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_roles_with_http_info(like, starts_with, show_limit,
                                              from_name,
                                              **kwargs)  # noqa: E501

    @validate_call
    def list_roles_with_http_info(
            self,
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            **kwargs):  # noqa: E501
        """List roles  # noqa: E501.

        List roles  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_roles_with_http_info(like, starts_with, show_limit, from_name, async_req=True)
        >>> result = future.result()
        :param like: Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[Role], Future[Iterable[Role]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['like', 'starts_with', 'show_limit', 'from_name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_roles" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        if _params.get('like') is not None:  # noqa: E501
            _query_params.append(('like', _params['like']))

        if _params.get('starts_with') is not None:  # noqa: E501
            _query_params.append(('startsWith', _params['starts_with']))

        if _params.get('show_limit') is not None:  # noqa: E501
            _query_params.append(('showLimit', _params['show_limit']))

        if _params.get('from_name') is not None:  # noqa: E501
            _query_params.append(('fromName', _params['from_name']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[Role]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/roles',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def revoke_future_grants(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def revoke_future_grants(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def revoke_future_grants(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def revoke_future_grants(
        self,
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        mode: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Revoke future grants from the role  # noqa: E501.

        Revoke future grants from the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_future_grants(name, grant, mode, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param mode: Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege.
        :type mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.revoke_future_grants_with_http_info(
            name, grant, mode, **kwargs)  # noqa: E501

    @validate_call
    def revoke_future_grants_with_http_info(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            )] = None,
            **kwargs):  # noqa: E501
        """Revoke future grants from the role  # noqa: E501.

        Revoke future grants from the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_future_grants_with_http_info(name, grant, mode, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param mode: Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege.
        :type mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['name', 'grant', 'mode']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method revoke_future_grants" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('mode') is not None:  # noqa: E501
            _query_params.append(('mode', _params['mode']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['grant']:
            _body_params = _params['grant']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/roles/{name}/future-grants:revoke',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def revoke_grants(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def revoke_grants(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def revoke_grants(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def revoke_grants(
        self,
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        grant: Grant,
        mode: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Revoke grants from the role  # noqa: E501.

        Revoke grants from the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_grants(name, grant, mode, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param mode: Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege.
        :type mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.revoke_grants_with_http_info(name, grant, mode,
                                                 **kwargs)  # noqa: E501

    @validate_call
    def revoke_grants_with_http_info(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            grant: Grant,
            mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege."
            )] = None,
            **kwargs):  # noqa: E501
        """Revoke grants from the role  # noqa: E501.

        Revoke grants from the role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.revoke_grants_with_http_info(name, grant, mode, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param grant: (required)
        :type grant: Grant
        :param mode: Query parameter determines whether the revoke operation succeeds or fails for the privileges, based on the whether the privileges had been re-granted to another role. - restrict: If the privilege being revoked has been re-granted to another role, the REVOKE command fails. - cascade: If the privilege being revoked has been re-granted, the REVOKE command recursively revokes these dependent grants. If the same privilege on an object has been granted to the target role by a different grantor (parallel grant), that grant is not affected and the target role retains the privilege.
        :type mode: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['name', 'grant', 'mode']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method revoke_grants" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('mode') is not None:  # noqa: E501
            _query_params.append(('mode', _params['mode']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['grant']:
            _body_params = _params['grant']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/roles/{name}/grants:revoke',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def delete_role(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def delete_role(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def delete_role(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def delete_role(
        self,
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Delete a role  # noqa: E501.

        Delete a role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_role(name, if_exists, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_role_with_http_info(name, if_exists,
                                               **kwargs)  # noqa: E501

    @validate_call
    def delete_role_with_http_info(
            self,
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            **kwargs):  # noqa: E501
        """Delete a role  # noqa: E501.

        Delete a role  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_role_with_http_info(name, if_exists, async_req=True)
        >>> result = future.result()
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['name', 'if_exists']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method delete_role" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('if_exists') is not None:  # noqa: E501
            _query_params.append(('ifExists', _params['if_exists']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/roles/{name}',
            'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
