# coding: utf-8
"""
    Snowflake Schema API.

    The Snowflake Schema API is a REST API that you can use to access, update, and perform certain actions on a Snowflake schema.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import absolute_import

import logging
from pydantic import Field, StrictBool, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from snowflake.core.schema._generated.models.model_schema import ModelSchema
from snowflake.core.schema._generated.models.schema_clone import SchemaClone
from snowflake.core.schema._generated.models.success_response import SuccessResponse
from typing import Iterable

from snowflake.core.schema._generated.api_client import ApiClient

from concurrent.futures import Future
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Literal, Optional, Tuple, Union, overload
from typing_extensions import Annotated

from snowflake.core._internal.utils import is_running_inside_stored_procedure

from snowflake.core.exceptions import (  # noqa: F401
    _APITypeError, _APIValueError)

logger = logging.getLogger(__name__)


class SchemaApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech.

    Do not edit the class manually.
    """

    def __init__(self, root, resource_class, sproc_client):
        self._root = root
        self._resource_name = 'schema'
        self._resource_class = resource_class

        if is_running_inside_stored_procedure():
            self._api_client = sproc_client
        else:
            self._api_client = ApiClient.get_default(self._root)

    @property
    def api_client(self):
        return self._api_client

    @overload
    def create_or_alter_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            model_schema: ModelSchema,
            kind:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def create_or_alter_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            model_schema: ModelSchema,
            kind:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def create_or_alter_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            model_schema: ModelSchema,
            kind:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def create_or_alter_schema(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        model_schema: ModelSchema,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Create a new, or alters an existing, schema.  # noqa: E501.

        Creates a new, or alters an existing, schema. You must provide the full schema definition even when altering an existing schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_or_alter_schema(database, name, model_schema, kind, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param model_schema: (required)
        :type model_schema: ModelSchema
        :param kind: Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string).
        :type kind: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.create_or_alter_schema_with_http_info(
            database, name, model_schema, kind, **kwargs)  # noqa: E501

    @validate_call
    def create_or_alter_schema_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            model_schema: ModelSchema,
            kind:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
            **kwargs):  # noqa: E501
        """Create a new, or alters an existing, schema.  # noqa: E501.

        Creates a new, or alters an existing, schema. You must provide the full schema definition even when altering an existing schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_or_alter_schema_with_http_info(database, name, model_schema, kind, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param model_schema: (required)
        :type model_schema: ModelSchema
        :param kind: Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string).
        :type kind: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'name', 'model_schema', 'kind']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method create_or_alter_schema" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('kind') is not None:  # noqa: E501
            _query_params.append(('kind', _params['kind']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['model_schema']:
            _body_params = _params['model_schema']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{name}',
            'PUT',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def create_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            model_schema: ModelSchema,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            kind:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def create_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            model_schema: ModelSchema,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            kind:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def create_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            model_schema: ModelSchema,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            kind:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def create_schema(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        model_schema: ModelSchema,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Create a schema.  # noqa: E501.

        Creates a schema, with modifiers as query parameters. You must provide the full schema definition when creating a schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_schema(database, model_schema, create_mode, kind, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param model_schema: (required)
        :type model_schema: ModelSchema
        :param create_mode: Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param kind: Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string).
        :type kind: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.create_schema_with_http_info(database, model_schema,
                                                 create_mode, kind,
                                                 **kwargs)  # noqa: E501

    @validate_call
    def create_schema_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            model_schema: ModelSchema,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            kind:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
            **kwargs):  # noqa: E501
        """Create a schema.  # noqa: E501.

        Creates a schema, with modifiers as query parameters. You must provide the full schema definition when creating a schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.create_schema_with_http_info(database, model_schema, create_mode, kind, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param model_schema: (required)
        :type model_schema: ModelSchema
        :param create_mode: Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param kind: Type of schema to create. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string).
        :type kind: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'model_schema', 'create_mode', 'kind']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method create_schema" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        # process the query parameters
        _query_params = []

        if _params.get('create_mode') is not None:  # noqa: E501
            _query_params.append(('createMode', _params['create_mode']))

        if _params.get('kind') is not None:  # noqa: E501
            _query_params.append(('kind', _params['kind']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['model_schema']:
            _body_params = _params['model_schema']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def clone_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            schema_clone: SchemaClone,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            kind:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to clone. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
            target_database:
        Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description=
                "Database of the newly created schema. Defaults to the source schema's database."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def clone_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            schema_clone: SchemaClone,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            kind:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to clone. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
            target_database:
        Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description=
                "Database of the newly created schema. Defaults to the source schema's database."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def clone_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            schema_clone: SchemaClone,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            kind:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to clone. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
            target_database:
        Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description=
                "Database of the newly created schema. Defaults to the source schema's database."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def clone_schema(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        schema_clone: SchemaClone,
        create_mode: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
        kind: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to clone. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
        target_database: Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description=
                "Database of the newly created schema. Defaults to the source schema's database."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Clone a schema.  # noqa: E501.

        Clones an existing schema, with modifiers as query parameters. You must provide the full schema definition when cloning an existing schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.clone_schema(database, name, schema_clone, create_mode, kind, target_database, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param schema_clone: (required)
        :type schema_clone: SchemaClone
        :param create_mode: Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param kind: Type of schema to clone. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string).
        :type kind: str
        :param target_database: Database of the newly created schema. Defaults to the source schema's database.
        :type target_database: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.clone_schema_with_http_info(database, name, schema_clone,
                                                create_mode, kind,
                                                target_database,
                                                **kwargs)  # noqa: E501

    @validate_call
    def clone_schema_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            schema_clone: SchemaClone,
            create_mode:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource."
            )] = None,
            kind:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Type of schema to clone. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string)."
            )] = None,
            target_database:
        Annotated[
            Optional[Annotated[str, Field(strict=True)]],
            Field(
                description=
                "Database of the newly created schema. Defaults to the source schema's database."
            )] = None,
            **kwargs):  # noqa: E501
        """Clone a schema.  # noqa: E501.

        Clones an existing schema, with modifiers as query parameters. You must provide the full schema definition when cloning an existing schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.clone_schema_with_http_info(database, name, schema_clone, create_mode, kind, target_database, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param schema_clone: (required)
        :type schema_clone: SchemaClone
        :param create_mode: Query parameter allowing support for different modes of resource creation. Possible values include: - `errorIfExists`: Throws an error if you try to create a resource that already exists. - `orReplace`: Automatically replaces the existing resource with the current one. - `ifNotExists`: Creates a new resource when an alter is requested for a non-existent resource.
        :type create_mode: str
        :param kind: Type of schema to clone. Currently, Snowflake supports only `transient` and `permanent` (also represented by the empty string).
        :type kind: str
        :param target_database: Database of the newly created schema. Defaults to the source schema's database.
        :type target_database: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'database', 'name', 'schema_clone', 'create_mode', 'kind',
            'target_database'
        ]
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method clone_schema" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('create_mode') is not None:  # noqa: E501
            _query_params.append(('createMode', _params['create_mode']))

        if _params.get('kind') is not None:  # noqa: E501
            _query_params.append(('kind', _params['kind']))

        if _params.get('target_database') is not None:  # noqa: E501
            _query_params.append(
                ('targetDatabase', _params['target_database']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        if _params['schema_clone']:
            _body_params = _params['schema_clone']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get(
            '_content_type',
            self.api_client.select_header_content_type(['application/json']))
        if _content_types_list:
            _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{name}:clone',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def fetch_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[False] = False,
            **kwargs) -> ModelSchema:
        ...

    @overload
    def fetch_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[ModelSchema]:
        ...

    @overload
    def fetch_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: bool = False,
            **kwargs) -> Union[ModelSchema, Future[ModelSchema]]:
        ...

    @validate_call
    def fetch_schema(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
                     **kwargs) -> Union[ModelSchema,
                                        Future[ModelSchema]]:  # noqa: E501
        """Fetch_schema  # noqa: E501.

        Fetches a schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_schema(database, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[ModelSchema, Future[ModelSchema]]
        """
        kwargs['_return_http_data_only'] = True
        return self.fetch_schema_with_http_info(database, name,
                                                **kwargs)  # noqa: E501

    @validate_call
    def fetch_schema_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
                                    **kwargs):  # noqa: E501
        """Fetch_schema  # noqa: E501.

        Fetches a schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.fetch_schema_with_http_info(database, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[ModelSchema, Future[ModelSchema]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method fetch_schema" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "ModelSchema",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{name}',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def list_schemas(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            history:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to include dropped schemas that have not yet been purged. Default: `false`."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> Iterable[ModelSchema]:
        ...

    @overload
    def list_schemas(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            history:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to include dropped schemas that have not yet been purged. Default: `false`."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[Iterable[ModelSchema]]:
        ...

    @overload
    def list_schemas(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
        history: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to include dropped schemas that have not yet been purged. Default: `false`."
            )] = None,
        async_req: bool = False,
        **kwargs
    ) -> Union[Iterable[ModelSchema], Future[Iterable[ModelSchema]]]:
        ...

    @validate_call
    def list_schemas(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        like: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
        starts_with: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
        show_limit: Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
        from_name: Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
        history: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to include dropped schemas that have not yet been purged. Default: `false`."
            )] = None,
        **kwargs
    ) -> Union[Iterable[ModelSchema],
               Future[Iterable[ModelSchema]]]:  # noqa: E501
        """List schemas.  # noqa: E501.

        Lists the accessible schemas.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_schemas(database, like, starts_with, show_limit, from_name, history, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param like: Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param history: Whether to include dropped schemas that have not yet been purged. Default: `false`.
        :type history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[Iterable[ModelSchema], Future[Iterable[ModelSchema]]]
        """
        kwargs['_return_http_data_only'] = True
        return self.list_schemas_with_http_info(database, like, starts_with,
                                                show_limit, from_name, history,
                                                **kwargs)  # noqa: E501

    @validate_call
    def list_schemas_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            like:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters."
            )] = None,
            starts_with:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching."
            )] = None,
            show_limit:
        Annotated[
            Optional[Annotated[int, Field(le=10000, strict=True, ge=1)]],
            Field(
                description=
                "Query parameter to limit the maximum number of rows returned by a command."
            )] = None,
            from_name:
        Annotated[
            Optional[StrictStr],
            Field(
                description=
                "Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name."
            )] = None,
            history:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to include dropped schemas that have not yet been purged. Default: `false`."
            )] = None,
            **kwargs):  # noqa: E501
        """List schemas.  # noqa: E501.

        Lists the accessible schemas.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.list_schemas_with_http_info(database, like, starts_with, show_limit, from_name, history, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param like: Query parameter to filter the command output by resource name. Uses case-insensitive pattern matching, with support for SQL wildcard characters.
        :type like: str
        :param starts_with: Query parameter to filter the command output based on the string of characters that appear at the beginning of the object name. Uses case-sensitive pattern matching.
        :type starts_with: str
        :param show_limit: Query parameter to limit the maximum number of rows returned by a command.
        :type show_limit: int
        :param from_name: Query parameter to enable fetching rows only following the first row whose object name matches the specified string. Case-sensitive and does not have to be the full name.
        :type from_name: str
        :param history: Whether to include dropped schemas that have not yet been purged. Default: `false`.
        :type history: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[Iterable[ModelSchema], Future[Iterable[ModelSchema]]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'database', 'like', 'starts_with', 'show_limit', 'from_name',
            'history'
        ]
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method list_schemas" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        # process the query parameters
        _query_params = []

        if _params.get('like') is not None:  # noqa: E501
            _query_params.append(('like', _params['like']))

        if _params.get('starts_with') is not None:  # noqa: E501
            _query_params.append(('startsWith', _params['starts_with']))

        if _params.get('show_limit') is not None:  # noqa: E501
            _query_params.append(('showLimit', _params['show_limit']))

        if _params.get('from_name') is not None:  # noqa: E501
            _query_params.append(('fromName', _params['from_name']))

        if _params.get('history') is not None:  # noqa: E501
            _query_params.append(('history', _params['history']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "Iterable[ModelSchema]",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas',
            'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def undrop_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def undrop_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def undrop_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def undrop_schema(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
                      **kwargs
                      ) -> Union[SuccessResponse,
                                 Future[SuccessResponse]]:  # noqa: E501
        """Undrop a schema.  # noqa: E501.

        Undrops schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.undrop_schema(database, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.undrop_schema_with_http_info(database, name,
                                                 **kwargs)  # noqa: E501

    @validate_call
    def undrop_schema_with_http_info(self, database: Annotated[
        str,
        Field(
            strict=True,
            description=
            "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
        )], name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
                                     **kwargs):  # noqa: E501
        """Undrop a schema.  # noqa: E501.

        Undrops schema.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.undrop_schema_with_http_info(database, name, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'name']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method undrop_schema" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{name}:undrop',
            'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @overload
    def delete_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            restrict:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to drop the schema if foreign keys exist that reference any tables in the schema. - `true`: Return a warning about existing foreign key references and don't drop the schema. - `false`: Drop the schema and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables. Default: `false`."
            )] = None,
            async_req: Literal[False] = False,
            **kwargs) -> SuccessResponse:
        ...

    @overload
    def delete_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            restrict:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to drop the schema if foreign keys exist that reference any tables in the schema. - `true`: Return a warning about existing foreign key references and don't drop the schema. - `false`: Drop the schema and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables. Default: `false`."
            )] = None,
            async_req: Literal[True] = True,
            **kwargs) -> Future[SuccessResponse]:
        ...

    @overload
    def delete_schema(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            restrict:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to drop the schema if foreign keys exist that reference any tables in the schema. - `true`: Return a warning about existing foreign key references and don't drop the schema. - `false`: Drop the schema and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables. Default: `false`."
            )] = None,
            async_req: bool = False,
            **kwargs) -> Union[SuccessResponse, Future[SuccessResponse]]:
        ...

    @validate_call
    def delete_schema(
        self,
        database: Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
        name: Annotated[
            str,
            Field(strict=True,
                  description="Identifier (i.e. name) for the resource.")],
        if_exists: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
        restrict: Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to drop the schema if foreign keys exist that reference any tables in the schema. - `true`: Return a warning about existing foreign key references and don't drop the schema. - `false`: Drop the schema and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables. Default: `false`."
            )] = None,
        **kwargs
    ) -> Union[SuccessResponse, Future[SuccessResponse]]:  # noqa: E501
        """Delete a schema.  # noqa: E501.

        Deletes the specified schema. If you enable the `ifExists` parameter, the operation succeeds even if the schema does not exist. Otherwise, a 404 failure is returned if the schema does not exist. if the drop is unsuccessful.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_schema(database, name, if_exists, restrict, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param restrict: Whether to drop the schema if foreign keys exist that reference any tables in the schema. - `true`: Return a warning about existing foreign key references and don't drop the schema. - `false`: Drop the schema and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables. Default: `false`.
        :type restrict: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: Union[SuccessResponse, Future[SuccessResponse]]
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_schema_with_http_info(database, name, if_exists,
                                                 restrict,
                                                 **kwargs)  # noqa: E501

    @validate_call
    def delete_schema_with_http_info(
            self,
            database:
        Annotated[
            str,
            Field(
                strict=True,
                description=
                "Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases."
            )],
            name: Annotated[
                str,
                Field(strict=True,
                      description="Identifier (i.e. name) for the resource.")],
            if_exists:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist."
            )] = None,
            restrict:
        Annotated[
            Optional[StrictBool],
            Field(
                description=
                "Whether to drop the schema if foreign keys exist that reference any tables in the schema. - `true`: Return a warning about existing foreign key references and don't drop the schema. - `false`: Drop the schema and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables. Default: `false`."
            )] = None,
            **kwargs):  # noqa: E501
        """Delete a schema.  # noqa: E501.

        Deletes the specified schema. If you enable the `ifExists` parameter, the operation succeeds even if the schema does not exist. Otherwise, a 404 failure is returned if the schema does not exist. if the drop is unsuccessful.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> future = api.delete_schema_with_http_info(database, name, if_exists, restrict, async_req=True)
        >>> result = future.result()
        :param database: Identifier (i.e. name) for the database to which the resource belongs. You can use the `/api/v2/databases` GET request to get a list of available databases. (required)
        :type database: str
        :param name: Identifier (i.e. name) for the resource. (required)
        :type name: str
        :param if_exists: Query parameter that specifies how to handle the request for a resource that does not exist: - `true`: The endpoint does not throw an error if the resource does not exist. It returns a 200 success response, but does not take any action on the resource. - `false`: The endpoint throws an error if the resource doesn't exist.
        :type if_exists: bool
        :param restrict: Whether to drop the schema if foreign keys exist that reference any tables in the schema. - `true`: Return a warning about existing foreign key references and don't drop the schema. - `false`: Drop the schema and all objects in the database, including tables with primary or unique keys that are referenced by foreign keys in other tables. Default: `false`.
        :type restrict: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns a Future object representing the execution of the method.
        :rtype: tuple(Union[SuccessResponse, Future[SuccessResponse]], status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = ['database', 'name', 'if_exists', 'restrict']
        _all_params.extend([
            'async_req', '_return_http_data_only', '_preload_content',
            '_request_timeout', '_request_auth', '_content_type', '_headers'
        ])

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise _APITypeError("Got an unexpected keyword argument '%s'"
                                    " to method delete_schema" % _key)
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        if _params['database']:
            _path_params['database'] = _params['database']

        if _params['name']:
            _path_params['name'] = _params['name']

        # process the query parameters
        _query_params = []

        if _params.get('if_exists') is not None:  # noqa: E501
            _query_params.append(('ifExists', _params['if_exists']))

        if _params.get('restrict') is not None:  # noqa: E501
            _query_params.append(('restrict', _params['restrict']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ExternalOAuth', 'KeyPair',
                          'SnowflakeOAuth']  # noqa: E501

        _response_types_map = {
            '200': "SuccessResponse",
            '202': "SuccessAcceptedResponse",
            '400': "ErrorResponse",
            '401': "ErrorResponse",
            '403': "ErrorResponse",
            '404': "ErrorResponse",
            '405': "ErrorResponse",
            '408': "ErrorResponse",
            '409': "ErrorResponse",
            '410': "ErrorResponse",
            '429': "ErrorResponse",
            '500': "ErrorResponse",
            '503': "ErrorResponse",
            '504': "ErrorResponse",
        }

        return self.api_client.call_api(
            self._root,
            '/api/v2/databases/{database}/schemas/{name}',
            'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get(
                '_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
