# coding: utf-8
"""
    Snowflake Services API.

    The Snowflake Services API is a REST API that you can use to access, update, and perform certain actions on Services resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.service._generated.models.service_spec import ServiceSpec

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional

from typing_extensions import Annotated


class JobService(BaseModel):
    """A model object representing the JobService resource.

    Constructs an object of type JobService with the provided properties.

    Parameters
    __________
    name : str
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    compute_pool : str
        Specifies the name of the compute pool in your account on which to run the service.
    spec : ServiceSpec

    status : str, optional
        The current status of the service.
    external_access_integrations : List[str], optional
        Specifies the names of the external access integrations that allow your service to access external sites.
    query_warehouse : str, optional
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    comment : str, optional
        Specifies a comment for the service.
    is_async_job : bool, optional
        True if the service is an async job service; false otherwise.
    """

    name: Annotated[str, Field(strict=True)]

    status: Optional[StrictStr] = None

    compute_pool: StrictStr

    spec: ServiceSpec

    external_access_integrations: Optional[List[StrictStr]] = None

    query_warehouse: Optional[Annotated[str, Field(strict=True)]] = None

    comment: Optional[StrictStr] = None

    is_async_job: Optional[StrictBool] = None

    __properties = [
        "name", "status", "compute_pool", "spec",
        "external_access_integrations", "query_warehouse", "comment",
        "is_async_job"
    ]

    @field_validator('name')
    def name_validate_regular_expression(cls, v):

        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('query_warehouse')
    def query_warehouse_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> JobService:
        """Create an instance of JobService from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of spec
        if self.spec:
            _dict['spec'] = self.spec.to_dict()

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> JobService:
        """Create an instance of JobService from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return JobService.parse_obj(obj)

        _obj = JobService.parse_obj({
            "name":
            obj.get("name"),
            "status":
            obj.get("status"),
            "compute_pool":
            obj.get("compute_pool"),
            "spec":
            ServiceSpec.from_dict(obj.get("spec"))
            if obj.get("spec") is not None else None,
            "external_access_integrations":
            obj.get("external_access_integrations"),
            "query_warehouse":
            obj.get("query_warehouse"),
            "comment":
            obj.get("comment"),
            "is_async_job":
            obj.get("is_async_job"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.service._generated.models.service_spec import ServiceSpec


class JobServiceModel():

    def __init__(
        self,
        name: str,
        compute_pool: str,
        spec: ServiceSpec,
        # optional properties
        status: Optional[str] = None,
        external_access_integrations: Optional[List[str]] = None,
        query_warehouse: Optional[str] = None,
        comment: Optional[str] = None,
        is_async_job: Optional[bool] = None,
    ):
        """A model object representing the JobService resource.

        Constructs an object of type JobService with the provided properties.

        Parameters
        __________
        name : str
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        compute_pool : str
            Specifies the name of the compute pool in your account on which to run the service.
        spec : ServiceSpec

        status : str, optional
            The current status of the service.
        external_access_integrations : List[str], optional
            Specifies the names of the external access integrations that allow your service to access external sites.
        query_warehouse : str, optional
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        comment : str, optional
            Specifies a comment for the service.
        is_async_job : bool, optional
            True if the service is an async job service; false otherwise.
        """

        self.name = name
        self.status = status
        self.compute_pool = compute_pool
        self.spec = spec
        self.external_access_integrations = external_access_integrations
        self.query_warehouse = query_warehouse
        self.comment = comment
        self.is_async_job = is_async_job

    __properties = [
        "name", "status", "compute_pool", "spec",
        "external_access_integrations", "query_warehouse", "comment",
        "is_async_job"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return JobService(
            name=self.name,
            status=self.status,
            compute_pool=self.compute_pool,
            spec=self.spec._to_model() if self.spec is not None else None,
            external_access_integrations=self.external_access_integrations,
            query_warehouse=self.query_warehouse,
            comment=self.comment,
            is_async_job=self.is_async_job,
        )

    @classmethod
    def _from_model(cls, model) -> JobServiceModel:
        return JobServiceModel(
            name=model.name,
            status=model.status,
            compute_pool=model.compute_pool,
            spec=ServiceSpecModel._from_model(model.spec)
            if model.spec is not None else None,
            external_access_integrations=model.external_access_integrations,
            query_warehouse=model.query_warehouse,
            comment=model.comment,
            is_async_job=model.is_async_job,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a JobService.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the JobService object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> JobServiceModel:
        """Creates an instance of JobService from a dict.

        This method constructs a JobService object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        JobService
            A JobService object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(JobService.from_dict(obj))


JobService._model_class = JobServiceModel
