# coding: utf-8
"""
    Snowflake Services API.

    The Snowflake Services API is a REST API that you can use to access, update, and perform certain actions on Services resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional

from typing_extensions import Annotated


class ServiceInstance(BaseModel):
    """A model object representing the ServiceInstance resource.

    Constructs an object of type ServiceInstance with the provided properties.

    Parameters
    __________
    database_name : str, optional
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    schema_name : str, optional
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    service_name : str, optional
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    service_status : str, optional
        The current status of the service.
    instance_id : str, optional
        ID of the service instance (this is the index of the service instance starting from 0).
    status : str, optional
        The current status of the service instance.
    spec_digest : str, optional
        The unique and immutable identifier that represents the service specification content.
    creation_time : str, optional
        The time when Snowflake started creating the service instance.
    start_time : str, optional
        The time when Snowflake acknowledged the service instance is running on a node.
    """

    database_name: Optional[Annotated[str, Field(strict=True)]] = None

    schema_name: Optional[Annotated[str, Field(strict=True)]] = None

    service_name: Optional[Annotated[str, Field(strict=True)]] = None

    service_status: Optional[StrictStr] = None

    instance_id: Optional[StrictStr] = None

    status: Optional[StrictStr] = None

    spec_digest: Optional[StrictStr] = None

    creation_time: Optional[StrictStr] = None

    start_time: Optional[StrictStr] = None

    __properties = [
        "database_name", "schema_name", "service_name", "service_status",
        "instance_id", "status", "spec_digest", "creation_time", "start_time"
    ]

    @field_validator('database_name')
    def database_name_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('schema_name')
    def schema_name_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    @field_validator('service_name')
    def service_name_validate_regular_expression(cls, v):

        if v is None:
            return v
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ServiceInstance:
        """Create an instance of ServiceInstance from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "service_status",
                "instance_id",
                "status",
                "spec_digest",
                "creation_time",
                "start_time",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceInstance:
        """Create an instance of ServiceInstance from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ServiceInstance.parse_obj(obj)

        _obj = ServiceInstance.parse_obj({
            "database_name":
            obj.get("database_name"),
            "schema_name":
            obj.get("schema_name"),
            "service_name":
            obj.get("service_name"),
            "service_status":
            obj.get("service_status"),
            "instance_id":
            obj.get("instance_id"),
            "status":
            obj.get("status"),
            "spec_digest":
            obj.get("spec_digest"),
            "creation_time":
            obj.get("creation_time"),
            "start_time":
            obj.get("start_time"),
        })

        return _obj


from typing import Optional, List, Dict


class ServiceInstanceModel():

    def __init__(
        self,  # optional properties
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        service_name: Optional[str] = None,
        service_status: Optional[str] = None,
        instance_id: Optional[str] = None,
        status: Optional[str] = None,
        spec_digest: Optional[str] = None,
        creation_time: Optional[str] = None,
        start_time: Optional[str] = None,
    ):
        """A model object representing the ServiceInstance resource.

        Constructs an object of type ServiceInstance with the provided properties.

        Parameters
        __________
        database_name : str, optional
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        schema_name : str, optional
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        service_name : str, optional
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        service_status : str, optional
            The current status of the service.
        instance_id : str, optional
            ID of the service instance (this is the index of the service instance starting from 0).
        status : str, optional
            The current status of the service instance.
        spec_digest : str, optional
            The unique and immutable identifier that represents the service specification content.
        creation_time : str, optional
            The time when Snowflake started creating the service instance.
        start_time : str, optional
            The time when Snowflake acknowledged the service instance is running on a node.
        """

        self.database_name = database_name
        self.schema_name = schema_name
        self.service_name = service_name
        self.service_status = service_status
        self.instance_id = instance_id
        self.status = status
        self.spec_digest = spec_digest
        self.creation_time = creation_time
        self.start_time = start_time

    __properties = [
        "database_name", "schema_name", "service_name", "service_status",
        "instance_id", "status", "spec_digest", "creation_time", "start_time"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ServiceInstance(
            database_name=self.database_name,
            schema_name=self.schema_name,
            service_name=self.service_name,
            service_status=self.service_status,
            instance_id=self.instance_id,
            status=self.status,
            spec_digest=self.spec_digest,
            creation_time=self.creation_time,
            start_time=self.start_time,
        )

    @classmethod
    def _from_model(cls, model) -> ServiceInstanceModel:
        return ServiceInstanceModel(
            database_name=model.database_name,
            schema_name=model.schema_name,
            service_name=model.service_name,
            service_status=model.service_status,
            instance_id=model.instance_id,
            status=model.status,
            spec_digest=model.spec_digest,
            creation_time=model.creation_time,
            start_time=model.start_time,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a ServiceInstance.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ServiceInstance object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceInstanceModel:
        """Creates an instance of ServiceInstance from a dict.

        This method constructs a ServiceInstance object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ServiceInstance
            A ServiceInstance object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ServiceInstance.from_dict(obj))


ServiceInstance._model_class = ServiceInstanceModel
