# coding: utf-8
"""
    Snowflake Services API.

    The Snowflake Services API is a REST API that you can use to access, update, and perform certain actions on Services resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.service._generated.models.service_spec import ServiceSpec

from pydantic import ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List


class ServiceSpecInlineText(ServiceSpec):
    """A model object representing the ServiceSpecInlineText resource.

    Constructs an object of type ServiceSpecInlineText with the provided properties.

    Parameters
    __________
    spec_text : str
        Specifies service specification. You can use a pair of dollar signs ($$) to delimit the beginning and ending of the specification string.
    """

    spec_text: StrictStr

    __properties = ["spec_type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ServiceSpecInlineText:
        """Create an instance of ServiceSpecInlineText from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict['spec_type'] = ServiceSpec.get_child_model_discriminator_value(
            'ServiceSpecInlineText')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceSpecInlineText:
        """Create an instance of ServiceSpecInlineText from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return ServiceSpecInlineText.parse_obj(obj)

        _obj = ServiceSpecInlineText.parse_obj({
            "spec_text":
            obj.get("spec_text"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.service._generated.models.service_spec import ServiceSpec


class ServiceSpecInlineTextModel(ServiceSpec):

    def __init__(
        self,
        spec_text: str,
        # optional properties
    ):
        """A model object representing the ServiceSpecInlineText resource.

        Constructs an object of type ServiceSpecInlineText with the provided properties.

        Parameters
        __________
        spec_text : str
            Specifies service specification. You can use a pair of dollar signs ($$) to delimit the beginning and ending of the specification string.
        """

        super().__init__()
        self.spec_text = spec_text

    __properties = ["spec_type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return ServiceSpecInlineText(spec_text=self.spec_text, )

    @classmethod
    def _from_model(cls, model) -> ServiceSpecInlineTextModel:
        return ServiceSpecInlineTextModel(spec_text=model.spec_text, )

    def to_dict(self):
        """Creates a dictionary of the properties from a ServiceSpecInlineText.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the ServiceSpecInlineText object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ServiceSpecInlineTextModel:
        """Creates an instance of ServiceSpecInlineText from a dict.

        This method constructs a ServiceSpecInlineText object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        ServiceSpecInlineText
            A ServiceSpecInlineText object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(ServiceSpecInlineText.from_dict(obj))


ServiceSpecInlineText._model_class = ServiceSpecInlineTextModel
