# coding: utf-8
"""
    Snowflake Session API.

    The Snowflake Session API is a REST API that you can use to query your current session properties.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class DefaultResult(BaseModel):
    """A model object representing the DefaultResult resource.

    Constructs an object of type DefaultResult with the provided properties.

    Parameters
    __________
    session_default : str, optional
    """

    session_default: Optional[StrictStr] = None

    __properties = ["session_default"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DefaultResult:
        """Create an instance of DefaultResult from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> DefaultResult:
        """Create an instance of DefaultResult from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return DefaultResult.parse_obj(obj)

        _obj = DefaultResult.parse_obj({
            "session_default":
            obj.get("session_default"),
        })

        return _obj


from typing import Optional, List, Dict


class DefaultResultModel():

    def __init__(
        self,  # optional properties
        session_default: Optional[str] = None,
    ):
        """A model object representing the DefaultResult resource.

        Constructs an object of type DefaultResult with the provided properties.

        Parameters
        __________
        session_default : str, optional
        """

        self.session_default = session_default

    __properties = ["session_default"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return DefaultResult(session_default=self.session_default, )

    @classmethod
    def _from_model(cls, model) -> DefaultResultModel:
        return DefaultResultModel(session_default=model.session_default, )

    def to_dict(self):
        """Creates a dictionary of the properties from a DefaultResult.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the DefaultResult object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> DefaultResultModel:
        """Creates an instance of DefaultResult from a dict.

        This method constructs a DefaultResult object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        DefaultResult
            A DefaultResult object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(DefaultResult.from_dict(obj))


DefaultResult._model_class = DefaultResultModel
