# coding: utf-8
"""
    Snowflake Stage API.

    The Snowflake Stage API is a REST API that you can use to access, update, and perform certain actions on stage resources in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.stage._generated.models.credentials import Credentials

from pydantic import ConfigDict, SecretStr, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class AwsCredentials(Credentials):
    """A model object representing the AwsCredentials resource.

    Constructs an object of type AwsCredentials with the provided properties.

    Parameters
    __________
    aws_key_id : str, optional
        Scoped credentials generated by AWS Security Token Service (STS).
    aws_secret_key : str, optional
        Scoped credentials generated by AWS Security Token Service (STS).
    aws_token : str, optional
        Scoped credentials generated by AWS Security Token Service (STS).
    aws_role : str, optional
        Omit the security credentials and access keys and, instead, identify the role using AWS_ROLE and specify the AWS role ARN (Amazon Resource Name).
    """

    aws_key_id: Optional[SecretStr] = None

    aws_secret_key: Optional[SecretStr] = None

    aws_token: Optional[SecretStr] = None

    aws_role: Optional[StrictStr] = None

    __properties = ["credential_type"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AwsCredentials:
        """Create an instance of AwsCredentials from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict[
            'credential_type'] = Credentials.get_child_model_discriminator_value(
                'AwsCredentials')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> AwsCredentials:
        """Create an instance of AwsCredentials from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return AwsCredentials.parse_obj(obj)

        _obj = AwsCredentials.parse_obj({
            "aws_key_id":
            obj.get("aws_key_id"),
            "aws_secret_key":
            obj.get("aws_secret_key"),
            "aws_token":
            obj.get("aws_token"),
            "aws_role":
            obj.get("aws_role"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.stage._generated.models.credentials import Credentials


class AwsCredentialsModel(Credentials):

    def __init__(
        self,  # optional properties
        aws_key_id: Optional[str] = None,
        aws_secret_key: Optional[str] = None,
        aws_token: Optional[str] = None,
        aws_role: Optional[str] = None,
    ):
        """A model object representing the AwsCredentials resource.

        Constructs an object of type AwsCredentials with the provided properties.

        Parameters
        __________
        aws_key_id : str, optional
            Scoped credentials generated by AWS Security Token Service (STS).
        aws_secret_key : str, optional
            Scoped credentials generated by AWS Security Token Service (STS).
        aws_token : str, optional
            Scoped credentials generated by AWS Security Token Service (STS).
        aws_role : str, optional
            Omit the security credentials and access keys and, instead, identify the role using AWS_ROLE and specify the AWS role ARN (Amazon Resource Name).
        """

        super().__init__()
        self.aws_key_id = aws_key_id
        self.aws_secret_key = aws_secret_key
        self.aws_token = aws_token
        self.aws_role = aws_role

    __properties = ["credential_type"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return AwsCredentials(
            aws_key_id=self.aws_key_id,
            aws_secret_key=self.aws_secret_key,
            aws_token=self.aws_token,
            aws_role=self.aws_role,
        )

    @classmethod
    def _from_model(cls, model) -> AwsCredentialsModel:
        return AwsCredentialsModel(
            aws_key_id=model.aws_key_id,
            aws_secret_key=model.aws_secret_key,
            aws_token=model.aws_token,
            aws_role=model.aws_role,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a AwsCredentials.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the AwsCredentials object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AwsCredentialsModel:
        """Creates an instance of AwsCredentials from a dict.

        This method constructs a AwsCredentials object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        AwsCredentials
            A AwsCredentials object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(AwsCredentials.from_dict(obj))


AwsCredentials._model_class = AwsCredentialsModel
