# coding: utf-8
"""
    Snowflake Stream API.

    The Snowflake Stream API is a REST API that you can use to access, update, and perform certain actions on Stream resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional

from typing_extensions import Annotated


class StreamClone(BaseModel):
    """A model object representing the StreamClone resource.

    Constructs an object of type StreamClone with the provided properties.

    Parameters
    __________
    name : str
        Name of the stream
    comment : str, optional
        user comment associated to an object in the dictionary
    """

    name: Annotated[str, Field(strict=True)]

    comment: Optional[StrictStr] = None

    __properties = ["name", "comment"]

    @field_validator('name')
    def name_validate_regular_expression(cls, v):

        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(
                r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/"""
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StreamClone:
        """Create an instance of StreamClone from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StreamClone:
        """Create an instance of StreamClone from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return StreamClone.parse_obj(obj)

        _obj = StreamClone.parse_obj({
            "name": obj.get("name"),
            "comment": obj.get("comment"),
        })

        return _obj


from typing import Optional, List, Dict


class StreamCloneModel():

    def __init__(
        self,
        name: str,
        # optional properties
        comment: Optional[str] = None,
    ):
        """A model object representing the StreamClone resource.

        Constructs an object of type StreamClone with the provided properties.

        Parameters
        __________
        name : str
            Name of the stream
        comment : str, optional
            user comment associated to an object in the dictionary
        """

        self.name = name
        self.comment = comment

    __properties = ["name", "comment"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StreamClone(
            name=self.name,
            comment=self.comment,
        )

    @classmethod
    def _from_model(cls, model) -> StreamCloneModel:
        return StreamCloneModel(
            name=model.name,
            comment=model.comment,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a StreamClone.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StreamClone object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StreamCloneModel:
        """Creates an instance of StreamClone from a dict.

        This method constructs a StreamClone object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StreamClone
            A StreamClone object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StreamClone.from_dict(obj))


StreamClone._model_class = StreamCloneModel
