# coding: utf-8
"""
    Snowflake Stream API.

    The Snowflake Stream API is a REST API that you can use to access, update, and perform certain actions on Stream resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.stream._generated.models.point_of_time import PointOfTime

from snowflake.core.stream._generated.models.stream_source import StreamSource

from pydantic import ConfigDict, StrictBool

from typing import Any, ClassVar, Dict, List, Optional


class StreamSourceExternalTable(StreamSource):
    """A model object representing the StreamSourceExternalTable resource.

    Constructs an object of type StreamSourceExternalTable with the provided properties.

    Parameters
    __________

    name : str
        Name of the source whose changes are tracked by the stream

    database_name : str, optional
        Database name to which stream source type belongs. If not provided, database  name provided in the path param will be used.

    schema_name : str, optional
        Schema name to which stream source type belongs. If not provided, schema name provided in the path param will be used.

    insert_only : bool, optional
        Whether this stream is an insert only stream or not
    point_of_time : PointOfTime, optional
    """

    insert_only: Optional[StrictBool] = None

    point_of_time: Optional[PointOfTime] = None

    __properties = ["src_type", "name", "database_name", "schema_name"]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> StreamSourceExternalTable:
        """Create an instance of StreamSourceExternalTable from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of point_of_time
        if self.point_of_time:
            _dict['point_of_time'] = self.point_of_time.to_dict()

        _dict['src_type'] = StreamSource.get_child_model_discriminator_value(
            'StreamSourceExternalTable')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> StreamSourceExternalTable:
        """Create an instance of StreamSourceExternalTable from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return StreamSourceExternalTable.parse_obj(obj)

        _obj = StreamSourceExternalTable.parse_obj({
            "name":
            obj.get("name"),
            "database_name":
            obj.get("database_name"),
            "schema_name":
            obj.get("schema_name"),
            "insert_only":
            obj.get("insert_only"),
            "point_of_time":
            PointOfTime.from_dict(obj.get("point_of_time"))
            if obj.get("point_of_time") is not None else None,
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.stream._generated.models.point_of_time import PointOfTime

from snowflake.core.stream._generated.models.stream_source import StreamSource


class StreamSourceExternalTableModel(StreamSource):

    def __init__(
        self,
        name: str,  # optional properties
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        insert_only: Optional[bool] = None,
        point_of_time: Optional[PointOfTime] = None,
    ):
        """A model object representing the StreamSourceExternalTable resource.

        Constructs an object of type StreamSourceExternalTable with the provided properties.

        Parameters
        __________

        name : str
            Name of the source whose changes are tracked by the stream

        database_name : str, optional
            Database name to which stream source type belongs. If not provided, database  name provided in the path param will be used.

        schema_name : str, optional
            Schema name to which stream source type belongs. If not provided, schema name provided in the path param will be used.

        insert_only : bool, optional
            Whether this stream is an insert only stream or not
        point_of_time : PointOfTime, optional
        """

        super().__init__(
            name=name,
            database_name=database_name,
            schema_name=schema_name,
        )
        self.insert_only = insert_only
        self.point_of_time = point_of_time

    __properties = ["src_type", "name", "database_name", "schema_name"]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return StreamSourceExternalTable(
            name=self.name,
            database_name=self.database_name,
            schema_name=self.schema_name,
            insert_only=self.insert_only,
            point_of_time=self.point_of_time._to_model()
            if self.point_of_time is not None else None,
        )

    @classmethod
    def _from_model(cls, model) -> StreamSourceExternalTableModel:
        return StreamSourceExternalTableModel(
            name=model.name,
            database_name=model.database_name,
            schema_name=model.schema_name,
            insert_only=model.insert_only,
            point_of_time=PointOfTimeModel._from_model(model.point_of_time)
            if model.point_of_time is not None else None,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a StreamSourceExternalTable.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the StreamSourceExternalTable object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> StreamSourceExternalTableModel:
        """Creates an instance of StreamSourceExternalTable from a dict.

        This method constructs a StreamSourceExternalTable object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        StreamSourceExternalTable
            A StreamSourceExternalTable object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(StreamSourceExternalTable.from_dict(obj))


StreamSourceExternalTable._model_class = StreamSourceExternalTableModel
