# coding: utf-8
"""
    Snowflake Table API.

    The Snowflake Table API is a REST API that you can use to access, update, and perform certain actions on Tables resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.table._generated.models.constraint import Constraint

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class TableColumn(BaseModel):
    """A model object representing the TableColumn resource.

    Constructs an object of type TableColumn with the provided properties.

    Parameters
    __________
    name : str
        Column name
    datatype : str
        The data type for the column
    nullable : bool,  default True
        Specifies that the column does allow NULL values or not.
    collate : str, optional
        Specifies the collation to use for column operations such as string comparison
    default : str, optional
        Specifies whether a default value is automatically inserted in the column if a value is not explicitly specified via an INSERT or CREATE TABLE AS SELECT statement
    autoincrement : bool, optional

    autoincrement_start : int, optional
        The default value for the column starts with the specified number
    autoincrement_increment : int, optional
        Each successive value for the column automatically increments by the specified amount
    constraints : List[Constraint], optional

    comment : str, optional
        Specifies a comment for the column
    """

    name: StrictStr

    datatype: StrictStr

    nullable: Optional[StrictBool] = True

    collate: Optional[StrictStr] = None

    default: Optional[StrictStr] = None

    autoincrement: Optional[StrictBool] = None

    autoincrement_start: Optional[StrictInt] = None

    autoincrement_increment: Optional[StrictInt] = None

    constraints: Optional[List[Constraint]] = None

    comment: Optional[StrictStr] = None

    __properties = [
        "name", "datatype", "nullable", "collate", "default", "autoincrement",
        "autoincrement_start", "autoincrement_increment", "constraints",
        "comment"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TableColumn:
        """Create an instance of TableColumn from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in constraints (list)
        _items = []
        if self.constraints:
            for _item in self.constraints:
                if _item:
                    _items.append(_item.to_dict())
            _dict['constraints'] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TableColumn:
        """Create an instance of TableColumn from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return TableColumn.parse_obj(obj)

        _obj = TableColumn.parse_obj({
            "name":
            obj.get("name"),
            "datatype":
            obj.get("datatype"),
            "nullable":
            obj.get("nullable") if obj.get("nullable") is not None else True,
            "collate":
            obj.get("collate"),
            "default":
            obj.get("default"),
            "autoincrement":
            obj.get("autoincrement"),
            "autoincrement_start":
            obj.get("autoincrement_start"),
            "autoincrement_increment":
            obj.get("autoincrement_increment"),
            "constraints":
            [Constraint.from_dict(_item) for _item in obj.get("constraints")]
            if obj.get("constraints") is not None else None,
            "comment":
            obj.get("comment"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.table._generated.models.constraint import Constraint


class TableColumnModel():

    def __init__(
        self,
        name: str,
        datatype: str,
        # optional properties
        nullable: Optional[bool] = True,
        collate: Optional[str] = None,
        default: Optional[str] = None,
        autoincrement: Optional[bool] = None,
        autoincrement_start: Optional[int] = None,
        autoincrement_increment: Optional[int] = None,
        constraints: Optional[List[Constraint]] = None,
        comment: Optional[str] = None,
    ):
        """A model object representing the TableColumn resource.

        Constructs an object of type TableColumn with the provided properties.

        Parameters
        __________
        name : str
            Column name
        datatype : str
            The data type for the column
        nullable : bool,  default True
            Specifies that the column does allow NULL values or not.
        collate : str, optional
            Specifies the collation to use for column operations such as string comparison
        default : str, optional
            Specifies whether a default value is automatically inserted in the column if a value is not explicitly specified via an INSERT or CREATE TABLE AS SELECT statement
        autoincrement : bool, optional

        autoincrement_start : int, optional
            The default value for the column starts with the specified number
        autoincrement_increment : int, optional
            Each successive value for the column automatically increments by the specified amount
        constraints : List[Constraint], optional

        comment : str, optional
            Specifies a comment for the column
        """

        self.name = name
        self.datatype = datatype
        self.nullable = nullable
        self.collate = collate
        self.default = default
        self.autoincrement = autoincrement
        self.autoincrement_start = autoincrement_start
        self.autoincrement_increment = autoincrement_increment
        self.constraints = constraints
        self.comment = comment

    __properties = [
        "name", "datatype", "nullable", "collate", "default", "autoincrement",
        "autoincrement_start", "autoincrement_increment", "constraints",
        "comment"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TableColumn(
            name=self.name,
            datatype=self.datatype,
            nullable=self.nullable,
            collate=self.collate,
            default=self.default,
            autoincrement=self.autoincrement,
            autoincrement_start=self.autoincrement_start,
            autoincrement_increment=self.autoincrement_increment,
            constraints=[x._to_model() for x in self.constraints]
            if self.constraints is not None else None,
            comment=self.comment,
        )

    @classmethod
    def _from_model(cls, model) -> TableColumnModel:
        return TableColumnModel(
            name=model.name,
            datatype=model.datatype,
            nullable=model.nullable,
            collate=model.collate,
            default=model.default,
            autoincrement=model.autoincrement,
            autoincrement_start=model.autoincrement_start,
            autoincrement_increment=model.autoincrement_increment,
            constraints=[
                ConstraintModel._from_model(x) for x in model.constraints
            ] if model.constraints is not None else None,
            comment=model.comment,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a TableColumn.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TableColumn object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TableColumnModel:
        """Creates an instance of TableColumn from a dict.

        This method constructs a TableColumn object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TableColumn
            A TableColumn object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TableColumn.from_dict(obj))


TableColumn._model_class = TableColumnModel
