# coding: utf-8
"""
    Snowflake Task API.

    The Snowflake Task API is a REST API that you can use to access, update, and perform certain actions on task resources in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from datetime import datetime

from pydantic import BaseModel, ConfigDict, StrictInt, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional


class TaskRun(BaseModel):
    """A model object representing the TaskRun resource.

    Constructs an object of type TaskRun with the provided properties.

    Parameters
    __________
    root_task_name : str
        The name of the root task in the current task run.
    database_name : str
        The name of the current database for the task run.
    schema_name : str
        The name of the current schema for the task run.
    state : str
        The current state of the task run.
    scheduled_time : datetime
        The scheduled time for the task run.
    next_scheduled_time : datetime
        The next upcoming time for the task run.
    root_task_id : str
        The unique task ID for the root task.
    graph_version : int
        The current version of the DAG on the task run.
    run_id : int
        The unique ID for the current task run.
    first_error_task_name : str, optional
        The name of the first task throwing an error in the task run.
    first_error_code : int, optional
        The first error code thrown in the task run.
    first_error_message : str, optional
        The first error message thrown in the task run.
    query_start_time : datetime, optional
        The start time for the task run query.
    completed_time : datetime, optional
        The time this task run was last completed.
    """

    root_task_name: StrictStr

    database_name: StrictStr

    schema_name: StrictStr

    state: StrictStr

    first_error_task_name: Optional[StrictStr] = None

    first_error_code: Optional[StrictInt] = None

    first_error_message: Optional[StrictStr] = None

    scheduled_time: datetime

    query_start_time: Optional[datetime] = None

    next_scheduled_time: datetime

    completed_time: Optional[datetime] = None

    root_task_id: StrictStr

    graph_version: StrictInt

    run_id: StrictInt

    __properties = [
        "root_task_name", "database_name", "schema_name", "state",
        "first_error_task_name", "first_error_code", "first_error_message",
        "scheduled_time", "query_start_time", "next_scheduled_time",
        "completed_time", "root_task_id", "graph_version", "run_id"
    ]

    @field_validator('state')
    def state_validate_enum(cls, v):

        if v not in ('SCHEDULED', 'EXECUTING', 'SUCCEEDED', 'FAILED',
                     'CANCELLED', 'SKIPPED'):
            raise ValueError(
                "must validate the enum values ('SCHEDULED','EXECUTING','SUCCEEDED','FAILED','CANCELLED','SKIPPED')"
            )
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TaskRun:
        """Create an instance of TaskRun from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "root_task_name",
                "database_name",
                "schema_name",
                "state",
                "first_error_task_name",
                "first_error_code",
                "first_error_message",
                "scheduled_time",
                "query_start_time",
                "next_scheduled_time",
                "completed_time",
                "root_task_id",
                "graph_version",
                "run_id",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> TaskRun:
        """Create an instance of TaskRun from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return TaskRun.parse_obj(obj)

        _obj = TaskRun.parse_obj({
            "root_task_name":
            obj.get("root_task_name"),
            "database_name":
            obj.get("database_name"),
            "schema_name":
            obj.get("schema_name"),
            "state":
            obj.get("state"),
            "first_error_task_name":
            obj.get("first_error_task_name"),
            "first_error_code":
            obj.get("first_error_code"),
            "first_error_message":
            obj.get("first_error_message"),
            "scheduled_time":
            obj.get("scheduled_time"),
            "query_start_time":
            obj.get("query_start_time"),
            "next_scheduled_time":
            obj.get("next_scheduled_time"),
            "completed_time":
            obj.get("completed_time"),
            "root_task_id":
            obj.get("root_task_id"),
            "graph_version":
            obj.get("graph_version"),
            "run_id":
            obj.get("run_id"),
        })

        return _obj


from typing import Optional, List, Dict


class TaskRunModel():

    def __init__(
        self,
        root_task_name: str,
        database_name: str,
        schema_name: str,
        state: str,
        scheduled_time: datetime,
        next_scheduled_time: datetime,
        root_task_id: str,
        graph_version: int,
        run_id: int,
        # optional properties
        first_error_task_name: Optional[str] = None,
        first_error_code: Optional[int] = None,
        first_error_message: Optional[str] = None,
        query_start_time: Optional[datetime] = None,
        completed_time: Optional[datetime] = None,
    ):
        """A model object representing the TaskRun resource.

        Constructs an object of type TaskRun with the provided properties.

        Parameters
        __________
        root_task_name : str
            The name of the root task in the current task run.
        database_name : str
            The name of the current database for the task run.
        schema_name : str
            The name of the current schema for the task run.
        state : str
            The current state of the task run.
        scheduled_time : datetime
            The scheduled time for the task run.
        next_scheduled_time : datetime
            The next upcoming time for the task run.
        root_task_id : str
            The unique task ID for the root task.
        graph_version : int
            The current version of the DAG on the task run.
        run_id : int
            The unique ID for the current task run.
        first_error_task_name : str, optional
            The name of the first task throwing an error in the task run.
        first_error_code : int, optional
            The first error code thrown in the task run.
        first_error_message : str, optional
            The first error message thrown in the task run.
        query_start_time : datetime, optional
            The start time for the task run query.
        completed_time : datetime, optional
            The time this task run was last completed.
        """

        self.root_task_name = root_task_name
        self.database_name = database_name
        self.schema_name = schema_name
        self.state = state
        self.first_error_task_name = first_error_task_name
        self.first_error_code = first_error_code
        self.first_error_message = first_error_message
        self.scheduled_time = scheduled_time
        self.query_start_time = query_start_time
        self.next_scheduled_time = next_scheduled_time
        self.completed_time = completed_time
        self.root_task_id = root_task_id
        self.graph_version = graph_version
        self.run_id = run_id

    __properties = [
        "root_task_name", "database_name", "schema_name", "state",
        "first_error_task_name", "first_error_code", "first_error_message",
        "scheduled_time", "query_start_time", "next_scheduled_time",
        "completed_time", "root_task_id", "graph_version", "run_id"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return TaskRun(
            root_task_name=self.root_task_name,
            database_name=self.database_name,
            schema_name=self.schema_name,
            state=self.state,
            first_error_task_name=self.first_error_task_name,
            first_error_code=self.first_error_code,
            first_error_message=self.first_error_message,
            scheduled_time=self.scheduled_time,
            query_start_time=self.query_start_time,
            next_scheduled_time=self.next_scheduled_time,
            completed_time=self.completed_time,
            root_task_id=self.root_task_id,
            graph_version=self.graph_version,
            run_id=self.run_id,
        )

    @classmethod
    def _from_model(cls, model) -> TaskRunModel:
        return TaskRunModel(
            root_task_name=model.root_task_name,
            database_name=model.database_name,
            schema_name=model.schema_name,
            state=model.state,
            first_error_task_name=model.first_error_task_name,
            first_error_code=model.first_error_code,
            first_error_message=model.first_error_message,
            scheduled_time=model.scheduled_time,
            query_start_time=model.query_start_time,
            next_scheduled_time=model.next_scheduled_time,
            completed_time=model.completed_time,
            root_task_id=model.root_task_id,
            graph_version=model.graph_version,
            run_id=model.run_id,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a TaskRun.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the TaskRun object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> TaskRunModel:
        """Creates an instance of TaskRun from a dict.

        This method constructs a TaskRun object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        TaskRun
            A TaskRun object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(TaskRun.from_dict(obj))


TaskRun._model_class = TaskRunModel
