# coding: utf-8
"""
    Snowflake User Defined Function API.

    The Snowflake User Defined Function API is a REST API that you can use to access, update, and perform certain actions on User Defined Function resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.user_defined_function._generated.models.base_language import BaseLanguage

from pydantic import ConfigDict, StrictStr

from typing import Any, ClassVar, Dict, List, Optional


class PythonFunction(BaseLanguage):
    """A model object representing the PythonFunction resource.

    Constructs an object of type PythonFunction with the provided properties.

    Parameters
    __________

    packages : List[str]
        Packages to include with the function/procedure

    handler : str
        Fully qualified method name including the package and the class
    runtime_version : str
        Specifies the Python version to use. The supported versions of Python are:
                                * 3.8
                                * 3.9
                                * 3.10
                                * 3.11

    imports : List[str], optional
        List of imports

    external_access_integrations : List[str], optional
        List of external access integrations attached to this function/procedure
    secrets : str, optional
        Secrets to be used with this function/procedure for external access
    """

    external_access_integrations: Optional[List[StrictStr]] = None

    secrets: Optional[Dict[str, StrictStr]] = None

    runtime_version: StrictStr

    __properties = [
        "packages", "imports", "handler", "language", "called_on_null_input",
        "is_volatile"
    ]

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PythonFunction:
        """Create an instance of PythonFunction from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({})

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        _dict['language'] = BaseLanguage.get_child_model_discriminator_value(
            'PythonFunction')

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> PythonFunction:
        """Create an instance of PythonFunction from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return PythonFunction.parse_obj(obj)

        _obj = PythonFunction.parse_obj({
            "packages":
            obj.get("packages"),
            "imports":
            obj.get("imports"),
            "handler":
            obj.get("handler"),
            "external_access_integrations":
            obj.get("external_access_integrations"),
            "secrets":
            obj.get("secrets"),
            "runtime_version":
            obj.get("runtime_version"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.user_defined_function._generated.models.base_language import BaseLanguage


class PythonFunctionModel(BaseLanguage):

    def __init__(
        self,
        packages: List[str],
        handler: str,
        runtime_version: str,
        # optional properties
        imports: Optional[List[str]] = None,
        external_access_integrations: Optional[List[str]] = None,
        secrets: Optional[str] = None,
    ):
        """A model object representing the PythonFunction resource.

        Constructs an object of type PythonFunction with the provided properties.

        Parameters
        __________

        packages : List[str]
            Packages to include with the function/procedure

        handler : str
            Fully qualified method name including the package and the class
        runtime_version : str
            Specifies the Python version to use. The supported versions of Python are:
                        * 3.8
                        * 3.9
                        * 3.10
                        * 3.11

        imports : List[str], optional
            List of imports

        external_access_integrations : List[str], optional
            List of external access integrations attached to this function/procedure
        secrets : str, optional
            Secrets to be used with this function/procedure for external access
        """

        super().__init__(
            called_on_null_input=called_on_null_input,
            is_volatile=is_volatile,
        )
        self.external_access_integrations = external_access_integrations
        self.secrets = secrets
        self.runtime_version = runtime_version

    __properties = [
        "packages", "imports", "handler", "language", "called_on_null_input",
        "is_volatile"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return PythonFunction(
            packages=self.packages,
            imports=self.imports,
            handler=self.handler,
            external_access_integrations=self.external_access_integrations,
            secrets=self.secrets,
            runtime_version=self.runtime_version,
        )

    @classmethod
    def _from_model(cls, model) -> PythonFunctionModel:
        return PythonFunctionModel(
            packages=model.packages,
            imports=model.imports,
            handler=model.handler,
            external_access_integrations=model.external_access_integrations,
            secrets=model.secrets,
            runtime_version=model.runtime_version,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a PythonFunction.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the PythonFunction object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> PythonFunctionModel:
        """Creates an instance of PythonFunction from a dict.

        This method constructs a PythonFunction object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        PythonFunction
            A PythonFunction object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(PythonFunction.from_dict(obj))


PythonFunction._model_class = PythonFunctionModel
