# coding: utf-8
"""
    Snowflake View API.

    The Snowflake View API is a REST API that you can use to access, update, and perform certain actions on View resource in a Snowflake database.  # noqa: E501

    The version of the OpenAPI document: 0.0.1
    Contact: support@snowflake.com
    Generated by: https://openapi-generator.tech

    Do not edit this file manually.
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from typing import Union

from snowflake.core.view._generated.models.view_column import ViewColumn

from datetime import datetime

from pydantic import BaseModel, ConfigDict, StrictBool, StrictStr, field_validator

from typing import Any, ClassVar, Dict, List, Optional


class View(BaseModel):
    """A model object representing the View resource.

    Constructs an object of type View with the provided properties.

    Parameters
    __________
    name : str
        Name of the view
    columns : List[ViewColumn]
        The columns of the view
    query : str
        Query used to create the view
    secure : bool, optional
        Whether or not this view is secure
    kind : str, optional
        Kind of the view, permanent (default) or temporary
    recursive : bool, optional
        Whether or not this view can refer to itself using recursive syntax withot requiring a CTE (common table expression)
    comment : str, optional
        user comment associated to an object in the dictionary
    created_on : datetime, optional
        Date and time when the view was created.
    database_name : str, optional
        Database in which the view is stored
    schema_name : str, optional
        Schema in which the view is stored
    owner : str, optional
        Role that owns the view
    owner_role_type : str, optional
        The type of role that owns the view
    """

    name: StrictStr

    secure: Optional[StrictBool] = None

    kind: Optional[StrictStr] = None

    recursive: Optional[StrictBool] = None

    columns: List[ViewColumn]

    comment: Optional[StrictStr] = None

    query: StrictStr

    created_on: Optional[datetime] = None

    database_name: Optional[StrictStr] = None

    schema_name: Optional[StrictStr] = None

    owner: Optional[StrictStr] = None

    owner_role_type: Optional[StrictStr] = None

    __properties = [
        "name", "secure", "kind", "recursive", "columns", "comment", "query",
        "created_on", "database_name", "schema_name", "owner",
        "owner_role_type"
    ]

    @field_validator('kind')
    def kind_validate_enum(cls, v):

        if v is None:
            return v
        if v not in ('PERMANENT', 'TEMPORARY'):
            raise ValueError(
                "must validate the enum values ('PERMANENT','TEMPORARY')")
        return v

    class Config:
        populate_by_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> View:
        """Create an instance of View from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""

        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update({
                "created_on",
                "database_name",
                "schema_name",
                "owner",
                "owner_role_type",
            })

        _dict = dict(
            self._iter(to_dict=True,
                       by_alias=True,
                       exclude=exclude_properties,
                       exclude_none=True))

        # override the default output from pydantic by calling `to_dict()` of each item in columns (list)
        _items = []
        if self.columns:
            for _item in self.columns:
                if _item:
                    _items.append(_item.to_dict())
            _dict['columns'] = _items

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> View:
        """Create an instance of View from a dict."""

        if obj is None:
            return None

        if type(obj) is not dict:
            return View.parse_obj(obj)

        _obj = View.parse_obj({
            "name":
            obj.get("name"),
            "secure":
            obj.get("secure"),
            "kind":
            obj.get("kind"),
            "recursive":
            obj.get("recursive"),
            "columns":
            [ViewColumn.from_dict(_item) for _item in obj.get("columns")]
            if obj.get("columns") is not None else None,
            "comment":
            obj.get("comment"),
            "query":
            obj.get("query"),
            "created_on":
            obj.get("created_on"),
            "database_name":
            obj.get("database_name"),
            "schema_name":
            obj.get("schema_name"),
            "owner":
            obj.get("owner"),
            "owner_role_type":
            obj.get("owner_role_type"),
        })

        return _obj


from typing import Optional, List, Dict

from snowflake.core.view._generated.models.view_column import ViewColumn


class ViewModel():

    def __init__(
        self,
        name: str,
        columns: List[ViewColumn],
        query: str,
        # optional properties
        secure: Optional[bool] = None,
        kind: Optional[str] = None,
        recursive: Optional[bool] = None,
        comment: Optional[str] = None,
        created_on: Optional[datetime] = None,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        owner: Optional[str] = None,
        owner_role_type: Optional[str] = None,
    ):
        """A model object representing the View resource.

        Constructs an object of type View with the provided properties.

        Parameters
        __________
        name : str
            Name of the view
        columns : List[ViewColumn]
            The columns of the view
        query : str
            Query used to create the view
        secure : bool, optional
            Whether or not this view is secure
        kind : str, optional
            Kind of the view, permanent (default) or temporary
        recursive : bool, optional
            Whether or not this view can refer to itself using recursive syntax withot requiring a CTE (common table expression)
        comment : str, optional
            user comment associated to an object in the dictionary
        created_on : datetime, optional
            Date and time when the view was created.
        database_name : str, optional
            Database in which the view is stored
        schema_name : str, optional
            Schema in which the view is stored
        owner : str, optional
            Role that owns the view
        owner_role_type : str, optional
            The type of role that owns the view
        """

        self.name = name
        self.secure = secure
        self.kind = kind
        self.recursive = recursive
        self.columns = columns
        self.comment = comment
        self.query = query
        self.created_on = created_on
        self.database_name = database_name
        self.schema_name = schema_name
        self.owner = owner
        self.owner_role_type = owner_role_type

    __properties = [
        "name", "secure", "kind", "recursive", "columns", "comment", "query",
        "created_on", "database_name", "schema_name", "owner",
        "owner_role_type"
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return View(
            name=self.name,
            secure=self.secure,
            kind=self.kind,
            recursive=self.recursive,
            columns=[x._to_model() for x in self.columns]
            if self.columns is not None else None,
            comment=self.comment,
            query=self.query,
            created_on=self.created_on,
            database_name=self.database_name,
            schema_name=self.schema_name,
            owner=self.owner,
            owner_role_type=self.owner_role_type,
        )

    @classmethod
    def _from_model(cls, model) -> ViewModel:
        return ViewModel(
            name=model.name,
            secure=model.secure,
            kind=model.kind,
            recursive=model.recursive,
            columns=[ViewColumnModel._from_model(x) for x in model.columns]
            if model.columns is not None else None,
            comment=model.comment,
            query=model.query,
            created_on=model.created_on,
            database_name=model.database_name,
            schema_name=model.schema_name,
            owner=model.owner,
            owner_role_type=model.owner_role_type,
        )

    def to_dict(self):
        """Creates a dictionary of the properties from a View.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the View object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> ViewModel:
        """Creates an instance of View from a dict.

        This method constructs a View object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        View
            A View object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(View.from_dict(obj))


View._model_class = ViewModel
