(self["webpackChunk_anaconda_panels"] = self["webpackChunk_anaconda_panels"] || []).push([["vendors-node_modules_jupyterlab_ui-components_lib_icon_iconimports_js-node_modules_date-fns_f-ad50a4"],{

/***/ "../../node_modules/@floating-ui/core/dist/floating-ui.core.mjs":
/*!**********************************************************************!*\
  !*** ../../node_modules/@floating-ui/core/dist/floating-ui.core.mjs ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrow: () => (/* binding */ arrow),
/* harmony export */   autoPlacement: () => (/* binding */ autoPlacement),
/* harmony export */   computePosition: () => (/* binding */ computePosition),
/* harmony export */   detectOverflow: () => (/* binding */ detectOverflow),
/* harmony export */   flip: () => (/* binding */ flip),
/* harmony export */   hide: () => (/* binding */ hide),
/* harmony export */   inline: () => (/* binding */ inline),
/* harmony export */   limitShift: () => (/* binding */ limitShift),
/* harmony export */   offset: () => (/* binding */ offset),
/* harmony export */   rectToClientRect: () => (/* reexport safe */ _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect),
/* harmony export */   shift: () => (/* binding */ shift),
/* harmony export */   size: () => (/* binding */ size)
/* harmony export */ });
/* harmony import */ var _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/utils */ "../../node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs");



function computeCoordsFromPlacement(_ref, placement, rtl) {
  let {
    reference,
    floating
  } = _ref;
  const sideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement);
  const alignmentAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentAxis)(placement);
  const alignLength = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAxisLength)(alignmentAxis);
  const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);
  const isVertical = sideAxis === 'y';
  const commonX = reference.x + reference.width / 2 - floating.width / 2;
  const commonY = reference.y + reference.height / 2 - floating.height / 2;
  const commonAlign = reference[alignLength] / 2 - floating[alignLength] / 2;
  let coords;
  switch (side) {
    case 'top':
      coords = {
        x: commonX,
        y: reference.y - floating.height
      };
      break;
    case 'bottom':
      coords = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;
    case 'right':
      coords = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;
    case 'left':
      coords = {
        x: reference.x - floating.width,
        y: commonY
      };
      break;
    default:
      coords = {
        x: reference.x,
        y: reference.y
      };
  }
  switch ((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement)) {
    case 'start':
      coords[alignmentAxis] -= commonAlign * (rtl && isVertical ? -1 : 1);
      break;
    case 'end':
      coords[alignmentAxis] += commonAlign * (rtl && isVertical ? -1 : 1);
      break;
  }
  return coords;
}

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a given reference element.
 *
 * This export does not have any `platform` interface logic. You will need to
 * write one for the platform you are using Floating UI with.
 */
const computePosition = async (reference, floating, config) => {
  const {
    placement = 'bottom',
    strategy = 'absolute',
    middleware = [],
    platform
  } = config;
  const validMiddleware = middleware.filter(Boolean);
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(floating));
  let rects = await platform.getElementRects({
    reference,
    floating,
    strategy
  });
  let {
    x,
    y
  } = computeCoordsFromPlacement(rects, placement, rtl);
  let statefulPlacement = placement;
  let middlewareData = {};
  let resetCount = 0;
  for (let i = 0; i < validMiddleware.length; i++) {
    const {
      name,
      fn
    } = validMiddleware[i];
    const {
      x: nextX,
      y: nextY,
      data,
      reset
    } = await fn({
      x,
      y,
      initialPlacement: placement,
      placement: statefulPlacement,
      strategy,
      middlewareData,
      rects,
      platform,
      elements: {
        reference,
        floating
      }
    });
    x = nextX != null ? nextX : x;
    y = nextY != null ? nextY : y;
    middlewareData = {
      ...middlewareData,
      [name]: {
        ...middlewareData[name],
        ...data
      }
    };
    if (reset && resetCount <= 50) {
      resetCount++;
      if (typeof reset === 'object') {
        if (reset.placement) {
          statefulPlacement = reset.placement;
        }
        if (reset.rects) {
          rects = reset.rects === true ? await platform.getElementRects({
            reference,
            floating,
            strategy
          }) : reset.rects;
        }
        ({
          x,
          y
        } = computeCoordsFromPlacement(rects, statefulPlacement, rtl));
      }
      i = -1;
    }
  }
  return {
    x,
    y,
    placement: statefulPlacement,
    strategy,
    middlewareData
  };
};

/**
 * Resolves with an object of overflow side offsets that determine how much the
 * element is overflowing a given clipping boundary on each side.
 * - positive = overflowing the boundary by that number of pixels
 * - negative = how many pixels left before it will overflow
 * - 0 = lies flush with the boundary
 * @see https://floating-ui.com/docs/detectOverflow
 */
async function detectOverflow(state, options) {
  var _await$platform$isEle;
  if (options === void 0) {
    options = {};
  }
  const {
    x,
    y,
    platform,
    rects,
    elements,
    strategy
  } = state;
  const {
    boundary = 'clippingAncestors',
    rootBoundary = 'viewport',
    elementContext = 'floating',
    altBoundary = false,
    padding = 0
  } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
  const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);
  const altContext = elementContext === 'floating' ? 'reference' : 'floating';
  const element = elements[altBoundary ? altContext : elementContext];
  const clippingClientRect = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(await platform.getClippingRect({
    element: ((_await$platform$isEle = await (platform.isElement == null ? void 0 : platform.isElement(element))) != null ? _await$platform$isEle : true) ? element : element.contextElement || (await (platform.getDocumentElement == null ? void 0 : platform.getDocumentElement(elements.floating))),
    boundary,
    rootBoundary,
    strategy
  }));
  const rect = elementContext === 'floating' ? {
    x,
    y,
    width: rects.floating.width,
    height: rects.floating.height
  } : rects.reference;
  const offsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(elements.floating));
  const offsetScale = (await (platform.isElement == null ? void 0 : platform.isElement(offsetParent))) ? (await (platform.getScale == null ? void 0 : platform.getScale(offsetParent))) || {
    x: 1,
    y: 1
  } : {
    x: 1,
    y: 1
  };
  const elementClientRect = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(platform.convertOffsetParentRelativeRectToViewportRelativeRect ? await platform.convertOffsetParentRelativeRectToViewportRelativeRect({
    elements,
    rect,
    offsetParent,
    strategy
  }) : rect);
  return {
    top: (clippingClientRect.top - elementClientRect.top + paddingObject.top) / offsetScale.y,
    bottom: (elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom) / offsetScale.y,
    left: (clippingClientRect.left - elementClientRect.left + paddingObject.left) / offsetScale.x,
    right: (elementClientRect.right - clippingClientRect.right + paddingObject.right) / offsetScale.x
  };
}

/**
 * Provides data to position an inner element of the floating element so that it
 * appears centered to the reference element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow = options => ({
  name: 'arrow',
  options,
  async fn(state) {
    const {
      x,
      y,
      placement,
      rects,
      platform,
      elements,
      middlewareData
    } = state;
    // Since `element` is required, we don't Partial<> the type.
    const {
      element,
      padding = 0
    } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state) || {};
    if (element == null) {
      return {};
    }
    const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);
    const coords = {
      x,
      y
    };
    const axis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentAxis)(placement);
    const length = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAxisLength)(axis);
    const arrowDimensions = await platform.getDimensions(element);
    const isYAxis = axis === 'y';
    const minProp = isYAxis ? 'top' : 'left';
    const maxProp = isYAxis ? 'bottom' : 'right';
    const clientProp = isYAxis ? 'clientHeight' : 'clientWidth';
    const endDiff = rects.reference[length] + rects.reference[axis] - coords[axis] - rects.floating[length];
    const startDiff = coords[axis] - rects.reference[axis];
    const arrowOffsetParent = await (platform.getOffsetParent == null ? void 0 : platform.getOffsetParent(element));
    let clientSize = arrowOffsetParent ? arrowOffsetParent[clientProp] : 0;

    // DOM platform can return `window` as the `offsetParent`.
    if (!clientSize || !(await (platform.isElement == null ? void 0 : platform.isElement(arrowOffsetParent)))) {
      clientSize = elements.floating[clientProp] || rects.floating[length];
    }
    const centerToReference = endDiff / 2 - startDiff / 2;

    // If the padding is large enough that it causes the arrow to no longer be
    // centered, modify the padding so that it is centered.
    const largestPossiblePadding = clientSize / 2 - arrowDimensions[length] / 2 - 1;
    const minPadding = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(paddingObject[minProp], largestPossiblePadding);
    const maxPadding = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(paddingObject[maxProp], largestPossiblePadding);

    // Make sure the arrow doesn't overflow the floating element if the center
    // point is outside the floating element's bounds.
    const min$1 = minPadding;
    const max = clientSize - arrowDimensions[length] - maxPadding;
    const center = clientSize / 2 - arrowDimensions[length] / 2 + centerToReference;
    const offset = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min$1, center, max);

    // If the reference is small enough that the arrow's padding causes it to
    // to point to nothing for an aligned placement, adjust the offset of the
    // floating element itself. To ensure `shift()` continues to take action,
    // a single reset is performed when this is true.
    const shouldAddOffset = !middlewareData.arrow && (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) != null && center !== offset && rects.reference[length] / 2 - (center < min$1 ? minPadding : maxPadding) - arrowDimensions[length] / 2 < 0;
    const alignmentOffset = shouldAddOffset ? center < min$1 ? center - min$1 : center - max : 0;
    return {
      [axis]: coords[axis] + alignmentOffset,
      data: {
        [axis]: offset,
        centerOffset: center - offset - alignmentOffset,
        ...(shouldAddOffset && {
          alignmentOffset
        })
      },
      reset: shouldAddOffset
    };
  }
});

function getPlacementList(alignment, autoAlignment, allowedPlacements) {
  const allowedPlacementsSortedByAlignment = alignment ? [...allowedPlacements.filter(placement => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) === alignment), ...allowedPlacements.filter(placement => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) !== alignment)] : allowedPlacements.filter(placement => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === placement);
  return allowedPlacementsSortedByAlignment.filter(placement => {
    if (alignment) {
      return (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement) === alignment || (autoAlignment ? (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAlignmentPlacement)(placement) !== placement : false);
    }
    return true;
  });
}
/**
 * Optimizes the visibility of the floating element by choosing the placement
 * that has the most space available automatically, without needing to specify a
 * preferred placement. Alternative to `flip`.
 * @see https://floating-ui.com/docs/autoPlacement
 */
const autoPlacement = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'autoPlacement',
    options,
    async fn(state) {
      var _middlewareData$autoP, _middlewareData$autoP2, _placementsThatFitOnE;
      const {
        rects,
        middlewareData,
        placement,
        platform,
        elements
      } = state;
      const {
        crossAxis = false,
        alignment,
        allowedPlacements = _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.placements,
        autoAlignment = true,
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const placements$1 = alignment !== undefined || allowedPlacements === _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.placements ? getPlacementList(alignment || null, autoAlignment, allowedPlacements) : allowedPlacements;
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const currentIndex = ((_middlewareData$autoP = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP.index) || 0;
      const currentPlacement = placements$1[currentIndex];
      if (currentPlacement == null) {
        return {};
      }
      const alignmentSides = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentSides)(currentPlacement, rects, await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating)));

      // Make `computeCoords` start from the right place.
      if (placement !== currentPlacement) {
        return {
          reset: {
            placement: placements$1[0]
          }
        };
      }
      const currentOverflows = [overflow[(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(currentPlacement)], overflow[alignmentSides[0]], overflow[alignmentSides[1]]];
      const allOverflows = [...(((_middlewareData$autoP2 = middlewareData.autoPlacement) == null ? void 0 : _middlewareData$autoP2.overflows) || []), {
        placement: currentPlacement,
        overflows: currentOverflows
      }];
      const nextPlacement = placements$1[currentIndex + 1];

      // There are more placements to check.
      if (nextPlacement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: nextPlacement
          }
        };
      }
      const placementsSortedByMostSpace = allOverflows.map(d => {
        const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(d.placement);
        return [d.placement, alignment && crossAxis ?
        // Check along the mainAxis and main crossAxis side.
        d.overflows.slice(0, 2).reduce((acc, v) => acc + v, 0) :
        // Check only the mainAxis.
        d.overflows[0], d.overflows];
      }).sort((a, b) => a[1] - b[1]);
      const placementsThatFitOnEachSide = placementsSortedByMostSpace.filter(d => d[2].slice(0,
      // Aligned placements should not check their opposite crossAxis
      // side.
      (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(d[0]) ? 2 : 3).every(v => v <= 0));
      const resetPlacement = ((_placementsThatFitOnE = placementsThatFitOnEachSide[0]) == null ? void 0 : _placementsThatFitOnE[0]) || placementsSortedByMostSpace[0][0];
      if (resetPlacement !== placement) {
        return {
          data: {
            index: currentIndex + 1,
            overflows: allOverflows
          },
          reset: {
            placement: resetPlacement
          }
        };
      }
      return {};
    }
  };
};

/**
 * Optimizes the visibility of the floating element by flipping the `placement`
 * in order to keep it in view when the preferred placement(s) will overflow the
 * clipping boundary. Alternative to `autoPlacement`.
 * @see https://floating-ui.com/docs/flip
 */
const flip = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'flip',
    options,
    async fn(state) {
      var _middlewareData$arrow, _middlewareData$flip;
      const {
        placement,
        middlewareData,
        rects,
        initialPlacement,
        platform,
        elements
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true,
        fallbackPlacements: specifiedFallbackPlacements,
        fallbackStrategy = 'bestFit',
        fallbackAxisSideDirection = 'none',
        flipAlignment = true,
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);

      // If a reset by the arrow was caused due to an alignment offset being
      // added, we should skip any logic now since `flip()` has already done its
      // work.
      // https://github.com/floating-ui/floating-ui/issues/2549#issuecomment-1719601643
      if ((_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);
      const initialSideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(initialPlacement);
      const isBasePlacement = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(initialPlacement) === initialPlacement;
      const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
      const fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipAlignment ? [(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositePlacement)(initialPlacement)] : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getExpandedPlacements)(initialPlacement));
      const hasFallbackAxisSideDirection = fallbackAxisSideDirection !== 'none';
      if (!specifiedFallbackPlacements && hasFallbackAxisSideDirection) {
        fallbackPlacements.push(...(0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxisPlacements)(initialPlacement, flipAlignment, fallbackAxisSideDirection, rtl));
      }
      const placements = [initialPlacement, ...fallbackPlacements];
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const overflows = [];
      let overflowsData = ((_middlewareData$flip = middlewareData.flip) == null ? void 0 : _middlewareData$flip.overflows) || [];
      if (checkMainAxis) {
        overflows.push(overflow[side]);
      }
      if (checkCrossAxis) {
        const sides = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignmentSides)(placement, rects, rtl);
        overflows.push(overflow[sides[0]], overflow[sides[1]]);
      }
      overflowsData = [...overflowsData, {
        placement,
        overflows
      }];

      // One or more sides is overflowing.
      if (!overflows.every(side => side <= 0)) {
        var _middlewareData$flip2, _overflowsData$filter;
        const nextIndex = (((_middlewareData$flip2 = middlewareData.flip) == null ? void 0 : _middlewareData$flip2.index) || 0) + 1;
        const nextPlacement = placements[nextIndex];
        if (nextPlacement) {
          const ignoreCrossAxisOverflow = checkCrossAxis === 'alignment' ? initialSideAxis !== (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(nextPlacement) : false;
          if (!ignoreCrossAxisOverflow ||
          // We leave the current main axis only if every placement on that axis
          // overflows the main axis.
          overflowsData.every(d => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(d.placement) === initialSideAxis ? d.overflows[0] > 0 : true)) {
            // Try next placement and re-run the lifecycle.
            return {
              data: {
                index: nextIndex,
                overflows: overflowsData
              },
              reset: {
                placement: nextPlacement
              }
            };
          }
        }

        // First, find the candidates that fit on the mainAxis side of overflow,
        // then find the placement that fits the best on the main crossAxis side.
        let resetPlacement = (_overflowsData$filter = overflowsData.filter(d => d.overflows[0] <= 0).sort((a, b) => a.overflows[1] - b.overflows[1])[0]) == null ? void 0 : _overflowsData$filter.placement;

        // Otherwise fallback.
        if (!resetPlacement) {
          switch (fallbackStrategy) {
            case 'bestFit':
              {
                var _overflowsData$filter2;
                const placement = (_overflowsData$filter2 = overflowsData.filter(d => {
                  if (hasFallbackAxisSideDirection) {
                    const currentSideAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(d.placement);
                    return currentSideAxis === initialSideAxis ||
                    // Create a bias to the `y` side axis due to horizontal
                    // reading directions favoring greater width.
                    currentSideAxis === 'y';
                  }
                  return true;
                }).map(d => [d.placement, d.overflows.filter(overflow => overflow > 0).reduce((acc, overflow) => acc + overflow, 0)]).sort((a, b) => a[1] - b[1])[0]) == null ? void 0 : _overflowsData$filter2[0];
                if (placement) {
                  resetPlacement = placement;
                }
                break;
              }
            case 'initialPlacement':
              resetPlacement = initialPlacement;
              break;
          }
        }
        if (placement !== resetPlacement) {
          return {
            reset: {
              placement: resetPlacement
            }
          };
        }
      }
      return {};
    }
  };
};

function getSideOffsets(overflow, rect) {
  return {
    top: overflow.top - rect.height,
    right: overflow.right - rect.width,
    bottom: overflow.bottom - rect.height,
    left: overflow.left - rect.width
  };
}
function isAnySideFullyClipped(overflow) {
  return _floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.sides.some(side => overflow[side] >= 0);
}
/**
 * Provides data to hide the floating element in applicable situations, such as
 * when it is not in the same clipping context as the reference element.
 * @see https://floating-ui.com/docs/hide
 */
const hide = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'hide',
    options,
    async fn(state) {
      const {
        rects
      } = state;
      const {
        strategy = 'referenceHidden',
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      switch (strategy) {
        case 'referenceHidden':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              elementContext: 'reference'
            });
            const offsets = getSideOffsets(overflow, rects.reference);
            return {
              data: {
                referenceHiddenOffsets: offsets,
                referenceHidden: isAnySideFullyClipped(offsets)
              }
            };
          }
        case 'escaped':
          {
            const overflow = await detectOverflow(state, {
              ...detectOverflowOptions,
              altBoundary: true
            });
            const offsets = getSideOffsets(overflow, rects.floating);
            return {
              data: {
                escapedOffsets: offsets,
                escaped: isAnySideFullyClipped(offsets)
              }
            };
          }
        default:
          {
            return {};
          }
      }
    }
  };
};

function getBoundingRect(rects) {
  const minX = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...rects.map(rect => rect.left));
  const minY = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...rects.map(rect => rect.top));
  const maxX = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...rects.map(rect => rect.right));
  const maxY = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...rects.map(rect => rect.bottom));
  return {
    x: minX,
    y: minY,
    width: maxX - minX,
    height: maxY - minY
  };
}
function getRectsByLine(rects) {
  const sortedRects = rects.slice().sort((a, b) => a.y - b.y);
  const groups = [];
  let prevRect = null;
  for (let i = 0; i < sortedRects.length; i++) {
    const rect = sortedRects[i];
    if (!prevRect || rect.y - prevRect.y > prevRect.height / 2) {
      groups.push([rect]);
    } else {
      groups[groups.length - 1].push(rect);
    }
    prevRect = rect;
  }
  return groups.map(rect => (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(getBoundingRect(rect)));
}
/**
 * Provides improved positioning for inline reference elements that can span
 * over multiple lines, such as hyperlinks or range selections.
 * @see https://floating-ui.com/docs/inline
 */
const inline = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'inline',
    options,
    async fn(state) {
      const {
        placement,
        elements,
        rects,
        platform,
        strategy
      } = state;
      // A MouseEvent's client{X,Y} coords can be up to 2 pixels off a
      // ClientRect's bounds, despite the event listener being triggered. A
      // padding of 2 seems to handle this issue.
      const {
        padding = 2,
        x,
        y
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const nativeClientRects = Array.from((await (platform.getClientRects == null ? void 0 : platform.getClientRects(elements.reference))) || []);
      const clientRects = getRectsByLine(nativeClientRects);
      const fallback = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(getBoundingRect(nativeClientRects));
      const paddingObject = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getPaddingObject)(padding);
      function getBoundingClientRect() {
        // There are two rects and they are disjoined.
        if (clientRects.length === 2 && clientRects[0].left > clientRects[1].right && x != null && y != null) {
          // Find the first rect in which the point is fully inside.
          return clientRects.find(rect => x > rect.left - paddingObject.left && x < rect.right + paddingObject.right && y > rect.top - paddingObject.top && y < rect.bottom + paddingObject.bottom) || fallback;
        }

        // There are 2 or more connected rects.
        if (clientRects.length >= 2) {
          if ((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === 'y') {
            const firstRect = clientRects[0];
            const lastRect = clientRects[clientRects.length - 1];
            const isTop = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === 'top';
            const top = firstRect.top;
            const bottom = lastRect.bottom;
            const left = isTop ? firstRect.left : lastRect.left;
            const right = isTop ? firstRect.right : lastRect.right;
            const width = right - left;
            const height = bottom - top;
            return {
              top,
              bottom,
              left,
              right,
              width,
              height,
              x: left,
              y: top
            };
          }
          const isLeftSide = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement) === 'left';
          const maxRight = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(...clientRects.map(rect => rect.right));
          const minLeft = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(...clientRects.map(rect => rect.left));
          const measureRects = clientRects.filter(rect => isLeftSide ? rect.left === minLeft : rect.right === maxRight);
          const top = measureRects[0].top;
          const bottom = measureRects[measureRects.length - 1].bottom;
          const left = minLeft;
          const right = maxRight;
          const width = right - left;
          const height = bottom - top;
          return {
            top,
            bottom,
            left,
            right,
            width,
            height,
            x: left,
            y: top
          };
        }
        return fallback;
      }
      const resetRects = await platform.getElementRects({
        reference: {
          getBoundingClientRect
        },
        floating: elements.floating,
        strategy
      });
      if (rects.reference.x !== resetRects.reference.x || rects.reference.y !== resetRects.reference.y || rects.reference.width !== resetRects.reference.width || rects.reference.height !== resetRects.reference.height) {
        return {
          reset: {
            rects: resetRects
          }
        };
      }
      return {};
    }
  };
};

const originSides = /*#__PURE__*/new Set(['left', 'top']);

// For type backwards-compatibility, the `OffsetOptions` type was also
// Derivable.

async function convertValueToCoords(state, options) {
  const {
    placement,
    platform,
    elements
  } = state;
  const rtl = await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating));
  const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);
  const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement);
  const isVertical = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === 'y';
  const mainAxisMulti = originSides.has(side) ? -1 : 1;
  const crossAxisMulti = rtl && isVertical ? -1 : 1;
  const rawValue = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);

  // eslint-disable-next-line prefer-const
  let {
    mainAxis,
    crossAxis,
    alignmentAxis
  } = typeof rawValue === 'number' ? {
    mainAxis: rawValue,
    crossAxis: 0,
    alignmentAxis: null
  } : {
    mainAxis: rawValue.mainAxis || 0,
    crossAxis: rawValue.crossAxis || 0,
    alignmentAxis: rawValue.alignmentAxis
  };
  if (alignment && typeof alignmentAxis === 'number') {
    crossAxis = alignment === 'end' ? alignmentAxis * -1 : alignmentAxis;
  }
  return isVertical ? {
    x: crossAxis * crossAxisMulti,
    y: mainAxis * mainAxisMulti
  } : {
    x: mainAxis * mainAxisMulti,
    y: crossAxis * crossAxisMulti
  };
}

/**
 * Modifies the placement by translating the floating element along the
 * specified axes.
 * A number (shorthand for `mainAxis` or distance), or an axes configuration
 * object may be passed.
 * @see https://floating-ui.com/docs/offset
 */
const offset = function (options) {
  if (options === void 0) {
    options = 0;
  }
  return {
    name: 'offset',
    options,
    async fn(state) {
      var _middlewareData$offse, _middlewareData$arrow;
      const {
        x,
        y,
        placement,
        middlewareData
      } = state;
      const diffCoords = await convertValueToCoords(state, options);

      // If the placement is the same and the arrow caused an alignment offset
      // then we don't need to change the positioning coordinates.
      if (placement === ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse.placement) && (_middlewareData$arrow = middlewareData.arrow) != null && _middlewareData$arrow.alignmentOffset) {
        return {};
      }
      return {
        x: x + diffCoords.x,
        y: y + diffCoords.y,
        data: {
          ...diffCoords,
          placement
        }
      };
    }
  };
};

/**
 * Optimizes the visibility of the floating element by shifting it in order to
 * keep it in view when it will overflow the clipping boundary.
 * @see https://floating-ui.com/docs/shift
 */
const shift = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'shift',
    options,
    async fn(state) {
      const {
        x,
        y,
        placement
      } = state;
      const {
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = false,
        limiter = {
          fn: _ref => {
            let {
              x,
              y
            } = _ref;
            return {
              x,
              y
            };
          }
        },
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const coords = {
        x,
        y
      };
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const crossAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement));
      const mainAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxis)(crossAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      if (checkMainAxis) {
        const minSide = mainAxis === 'y' ? 'top' : 'left';
        const maxSide = mainAxis === 'y' ? 'bottom' : 'right';
        const min = mainAxisCoord + overflow[minSide];
        const max = mainAxisCoord - overflow[maxSide];
        mainAxisCoord = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min, mainAxisCoord, max);
      }
      if (checkCrossAxis) {
        const minSide = crossAxis === 'y' ? 'top' : 'left';
        const maxSide = crossAxis === 'y' ? 'bottom' : 'right';
        const min = crossAxisCoord + overflow[minSide];
        const max = crossAxisCoord - overflow[maxSide];
        crossAxisCoord = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.clamp)(min, crossAxisCoord, max);
      }
      const limitedCoords = limiter.fn({
        ...state,
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      });
      return {
        ...limitedCoords,
        data: {
          x: limitedCoords.x - x,
          y: limitedCoords.y - y,
          enabled: {
            [mainAxis]: checkMainAxis,
            [crossAxis]: checkCrossAxis
          }
        }
      };
    }
  };
};
/**
 * Built-in `limiter` that will stop `shift()` at a certain point.
 */
const limitShift = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    options,
    fn(state) {
      const {
        x,
        y,
        placement,
        rects,
        middlewareData
      } = state;
      const {
        offset = 0,
        mainAxis: checkMainAxis = true,
        crossAxis: checkCrossAxis = true
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const coords = {
        x,
        y
      };
      const crossAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement);
      const mainAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getOppositeAxis)(crossAxis);
      let mainAxisCoord = coords[mainAxis];
      let crossAxisCoord = coords[crossAxis];
      const rawOffset = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(offset, state);
      const computedOffset = typeof rawOffset === 'number' ? {
        mainAxis: rawOffset,
        crossAxis: 0
      } : {
        mainAxis: 0,
        crossAxis: 0,
        ...rawOffset
      };
      if (checkMainAxis) {
        const len = mainAxis === 'y' ? 'height' : 'width';
        const limitMin = rects.reference[mainAxis] - rects.floating[len] + computedOffset.mainAxis;
        const limitMax = rects.reference[mainAxis] + rects.reference[len] - computedOffset.mainAxis;
        if (mainAxisCoord < limitMin) {
          mainAxisCoord = limitMin;
        } else if (mainAxisCoord > limitMax) {
          mainAxisCoord = limitMax;
        }
      }
      if (checkCrossAxis) {
        var _middlewareData$offse, _middlewareData$offse2;
        const len = mainAxis === 'y' ? 'width' : 'height';
        const isOriginSide = originSides.has((0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement));
        const limitMin = rects.reference[crossAxis] - rects.floating[len] + (isOriginSide ? ((_middlewareData$offse = middlewareData.offset) == null ? void 0 : _middlewareData$offse[crossAxis]) || 0 : 0) + (isOriginSide ? 0 : computedOffset.crossAxis);
        const limitMax = rects.reference[crossAxis] + rects.reference[len] + (isOriginSide ? 0 : ((_middlewareData$offse2 = middlewareData.offset) == null ? void 0 : _middlewareData$offse2[crossAxis]) || 0) - (isOriginSide ? computedOffset.crossAxis : 0);
        if (crossAxisCoord < limitMin) {
          crossAxisCoord = limitMin;
        } else if (crossAxisCoord > limitMax) {
          crossAxisCoord = limitMax;
        }
      }
      return {
        [mainAxis]: mainAxisCoord,
        [crossAxis]: crossAxisCoord
      };
    }
  };
};

/**
 * Provides data that allows you to change the size of the floating element —
 * for instance, prevent it from overflowing the clipping boundary or match the
 * width of the reference element.
 * @see https://floating-ui.com/docs/size
 */
const size = function (options) {
  if (options === void 0) {
    options = {};
  }
  return {
    name: 'size',
    options,
    async fn(state) {
      var _state$middlewareData, _state$middlewareData2;
      const {
        placement,
        rects,
        platform,
        elements
      } = state;
      const {
        apply = () => {},
        ...detectOverflowOptions
      } = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.evaluate)(options, state);
      const overflow = await detectOverflow(state, detectOverflowOptions);
      const side = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSide)(placement);
      const alignment = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getAlignment)(placement);
      const isYAxis = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.getSideAxis)(placement) === 'y';
      const {
        width,
        height
      } = rects.floating;
      let heightSide;
      let widthSide;
      if (side === 'top' || side === 'bottom') {
        heightSide = side;
        widthSide = alignment === ((await (platform.isRTL == null ? void 0 : platform.isRTL(elements.floating))) ? 'start' : 'end') ? 'left' : 'right';
      } else {
        widthSide = side;
        heightSide = alignment === 'end' ? 'top' : 'bottom';
      }
      const maximumClippingHeight = height - overflow.top - overflow.bottom;
      const maximumClippingWidth = width - overflow.left - overflow.right;
      const overflowAvailableHeight = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(height - overflow[heightSide], maximumClippingHeight);
      const overflowAvailableWidth = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.min)(width - overflow[widthSide], maximumClippingWidth);
      const noShift = !state.middlewareData.shift;
      let availableHeight = overflowAvailableHeight;
      let availableWidth = overflowAvailableWidth;
      if ((_state$middlewareData = state.middlewareData.shift) != null && _state$middlewareData.enabled.x) {
        availableWidth = maximumClippingWidth;
      }
      if ((_state$middlewareData2 = state.middlewareData.shift) != null && _state$middlewareData2.enabled.y) {
        availableHeight = maximumClippingHeight;
      }
      if (noShift && !alignment) {
        const xMin = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.left, 0);
        const xMax = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.right, 0);
        const yMin = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.top, 0);
        const yMax = (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.bottom, 0);
        if (isYAxis) {
          availableWidth = width - 2 * (xMin !== 0 || xMax !== 0 ? xMin + xMax : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.left, overflow.right));
        } else {
          availableHeight = height - 2 * (yMin !== 0 || yMax !== 0 ? yMin + yMax : (0,_floating_ui_utils__WEBPACK_IMPORTED_MODULE_0__.max)(overflow.top, overflow.bottom));
        }
      }
      await apply({
        ...state,
        availableWidth,
        availableHeight
      });
      const nextDimensions = await platform.getDimensions(elements.floating);
      if (width !== nextDimensions.width || height !== nextDimensions.height) {
        return {
          reset: {
            rects: true
          }
        };
      }
      return {};
    }
  };
};




/***/ }),

/***/ "../../node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs":
/*!********************************************************************!*\
  !*** ../../node_modules/@floating-ui/dom/dist/floating-ui.dom.mjs ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   arrow: () => (/* binding */ arrow),
/* harmony export */   autoPlacement: () => (/* binding */ autoPlacement),
/* harmony export */   autoUpdate: () => (/* binding */ autoUpdate),
/* harmony export */   computePosition: () => (/* binding */ computePosition),
/* harmony export */   detectOverflow: () => (/* binding */ detectOverflow),
/* harmony export */   flip: () => (/* binding */ flip),
/* harmony export */   getOverflowAncestors: () => (/* reexport safe */ _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getOverflowAncestors),
/* harmony export */   hide: () => (/* binding */ hide),
/* harmony export */   inline: () => (/* binding */ inline),
/* harmony export */   limitShift: () => (/* binding */ limitShift),
/* harmony export */   offset: () => (/* binding */ offset),
/* harmony export */   platform: () => (/* binding */ platform),
/* harmony export */   shift: () => (/* binding */ shift),
/* harmony export */   size: () => (/* binding */ size)
/* harmony export */ });
/* harmony import */ var _floating_ui_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @floating-ui/utils */ "../../node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs");
/* harmony import */ var _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @floating-ui/core */ "../../node_modules/@floating-ui/core/dist/floating-ui.core.mjs");
/* harmony import */ var _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @floating-ui/utils/dom */ "../../node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs");





function getCssDimensions(element) {
  const css = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element);
  // In testing environments, the `width` and `height` properties are empty
  // strings for SVG elements, returning NaN. Fallback to `0` in this case.
  let width = parseFloat(css.width) || 0;
  let height = parseFloat(css.height) || 0;
  const hasOffset = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(element);
  const offsetWidth = hasOffset ? element.offsetWidth : width;
  const offsetHeight = hasOffset ? element.offsetHeight : height;
  const shouldFallback = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.round)(width) !== offsetWidth || (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.round)(height) !== offsetHeight;
  if (shouldFallback) {
    width = offsetWidth;
    height = offsetHeight;
  }
  return {
    width,
    height,
    $: shouldFallback
  };
}

function unwrapElement(element) {
  return !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(element) ? element.contextElement : element;
}

function getScale(element) {
  const domElement = unwrapElement(element);
  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(domElement)) {
    return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(1);
  }
  const rect = domElement.getBoundingClientRect();
  const {
    width,
    height,
    $
  } = getCssDimensions(domElement);
  let x = ($ ? (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.round)(rect.width) : rect.width) / width;
  let y = ($ ? (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.round)(rect.height) : rect.height) / height;

  // 0, NaN, or Infinity should always fallback to 1.

  if (!x || !Number.isFinite(x)) {
    x = 1;
  }
  if (!y || !Number.isFinite(y)) {
    y = 1;
  }
  return {
    x,
    y
  };
}

const noOffsets = /*#__PURE__*/(0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);
function getVisualOffsets(element) {
  const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(element);
  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isWebKit)() || !win.visualViewport) {
    return noOffsets;
  }
  return {
    x: win.visualViewport.offsetLeft,
    y: win.visualViewport.offsetTop
  };
}
function shouldAddVisualOffsets(element, isFixed, floatingOffsetParent) {
  if (isFixed === void 0) {
    isFixed = false;
  }
  if (!floatingOffsetParent || isFixed && floatingOffsetParent !== (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(element)) {
    return false;
  }
  return isFixed;
}

function getBoundingClientRect(element, includeScale, isFixedStrategy, offsetParent) {
  if (includeScale === void 0) {
    includeScale = false;
  }
  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }
  const clientRect = element.getBoundingClientRect();
  const domElement = unwrapElement(element);
  let scale = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(1);
  if (includeScale) {
    if (offsetParent) {
      if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(offsetParent)) {
        scale = getScale(offsetParent);
      }
    } else {
      scale = getScale(element);
    }
  }
  const visualOffsets = shouldAddVisualOffsets(domElement, isFixedStrategy, offsetParent) ? getVisualOffsets(domElement) : (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);
  let x = (clientRect.left + visualOffsets.x) / scale.x;
  let y = (clientRect.top + visualOffsets.y) / scale.y;
  let width = clientRect.width / scale.x;
  let height = clientRect.height / scale.y;
  if (domElement) {
    const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(domElement);
    const offsetWin = offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(offsetParent) ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(offsetParent) : offsetParent;
    let currentWin = win;
    let currentIFrame = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getFrameElement)(currentWin);
    while (currentIFrame && offsetParent && offsetWin !== currentWin) {
      const iframeScale = getScale(currentIFrame);
      const iframeRect = currentIFrame.getBoundingClientRect();
      const css = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(currentIFrame);
      const left = iframeRect.left + (currentIFrame.clientLeft + parseFloat(css.paddingLeft)) * iframeScale.x;
      const top = iframeRect.top + (currentIFrame.clientTop + parseFloat(css.paddingTop)) * iframeScale.y;
      x *= iframeScale.x;
      y *= iframeScale.y;
      width *= iframeScale.x;
      height *= iframeScale.y;
      x += left;
      y += top;
      currentWin = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(currentIFrame);
      currentIFrame = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getFrameElement)(currentWin);
    }
  }
  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)({
    width,
    height,
    x,
    y
  });
}

// If <html> has a CSS width greater than the viewport, then this will be
// incorrect for RTL.
function getWindowScrollBarX(element, rect) {
  const leftScroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeScroll)(element).scrollLeft;
  if (!rect) {
    return getBoundingClientRect((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element)).left + leftScroll;
  }
  return rect.left + leftScroll;
}

function getHTMLOffset(documentElement, scroll, ignoreScrollbarX) {
  if (ignoreScrollbarX === void 0) {
    ignoreScrollbarX = false;
  }
  const htmlRect = documentElement.getBoundingClientRect();
  const x = htmlRect.left + scroll.scrollLeft - (ignoreScrollbarX ? 0 :
  // RTL <body> scrollbar.
  getWindowScrollBarX(documentElement, htmlRect));
  const y = htmlRect.top + scroll.scrollTop;
  return {
    x,
    y
  };
}

function convertOffsetParentRelativeRectToViewportRelativeRect(_ref) {
  let {
    elements,
    rect,
    offsetParent,
    strategy
  } = _ref;
  const isFixed = strategy === 'fixed';
  const documentElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(offsetParent);
  const topLayer = elements ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isTopLayer)(elements.floating) : false;
  if (offsetParent === documentElement || topLayer && isFixed) {
    return rect;
  }
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  let scale = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(1);
  const offsets = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);
  const isOffsetParentAnElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(offsetParent);
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeName)(offsetParent) !== 'body' || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isOverflowElement)(documentElement)) {
      scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeScroll)(offsetParent);
    }
    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(offsetParent)) {
      const offsetRect = getBoundingClientRect(offsetParent);
      scale = getScale(offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    }
  }
  const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll, true) : (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);
  return {
    width: rect.width * scale.x,
    height: rect.height * scale.y,
    x: rect.x * scale.x - scroll.scrollLeft * scale.x + offsets.x + htmlOffset.x,
    y: rect.y * scale.y - scroll.scrollTop * scale.y + offsets.y + htmlOffset.y
  };
}

function getClientRects(element) {
  return Array.from(element.getClientRects());
}

// Gets the entire size of the scrollable document area, even extending outside
// of the `<html>` and `<body>` rect bounds if horizontally scrollable.
function getDocumentRect(element) {
  const html = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element);
  const scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeScroll)(element);
  const body = element.ownerDocument.body;
  const width = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(html.scrollWidth, html.clientWidth, body.scrollWidth, body.clientWidth);
  const height = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(html.scrollHeight, html.clientHeight, body.scrollHeight, body.clientHeight);
  let x = -scroll.scrollLeft + getWindowScrollBarX(element);
  const y = -scroll.scrollTop;
  if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(body).direction === 'rtl') {
    x += (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(html.clientWidth, body.clientWidth) - width;
  }
  return {
    width,
    height,
    x,
    y
  };
}

function getViewportRect(element, strategy) {
  const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(element);
  const html = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element);
  const visualViewport = win.visualViewport;
  let width = html.clientWidth;
  let height = html.clientHeight;
  let x = 0;
  let y = 0;
  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    const visualViewportBased = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isWebKit)();
    if (!visualViewportBased || visualViewportBased && strategy === 'fixed') {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }
  return {
    width,
    height,
    x,
    y
  };
}

const absoluteOrFixed = /*#__PURE__*/new Set(['absolute', 'fixed']);
// Returns the inner client rect, subtracting scrollbars if present.
function getInnerBoundingClientRect(element, strategy) {
  const clientRect = getBoundingClientRect(element, true, strategy === 'fixed');
  const top = clientRect.top + element.clientTop;
  const left = clientRect.left + element.clientLeft;
  const scale = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(element) ? getScale(element) : (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(1);
  const width = element.clientWidth * scale.x;
  const height = element.clientHeight * scale.y;
  const x = left * scale.x;
  const y = top * scale.y;
  return {
    width,
    height,
    x,
    y
  };
}
function getClientRectFromClippingAncestor(element, clippingAncestor, strategy) {
  let rect;
  if (clippingAncestor === 'viewport') {
    rect = getViewportRect(element, strategy);
  } else if (clippingAncestor === 'document') {
    rect = getDocumentRect((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element));
  } else if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(clippingAncestor)) {
    rect = getInnerBoundingClientRect(clippingAncestor, strategy);
  } else {
    const visualOffsets = getVisualOffsets(element);
    rect = {
      x: clippingAncestor.x - visualOffsets.x,
      y: clippingAncestor.y - visualOffsets.y,
      width: clippingAncestor.width,
      height: clippingAncestor.height
    };
  }
  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.rectToClientRect)(rect);
}
function hasFixedPositionAncestor(element, stopNode) {
  const parentNode = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(element);
  if (parentNode === stopNode || !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(parentNode) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isLastTraversableNode)(parentNode)) {
    return false;
  }
  return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(parentNode).position === 'fixed' || hasFixedPositionAncestor(parentNode, stopNode);
}

// A "clipping ancestor" is an `overflow` element with the characteristic of
// clipping (or hiding) child elements. This returns all clipping ancestors
// of the given element up the tree.
function getClippingElementAncestors(element, cache) {
  const cachedResult = cache.get(element);
  if (cachedResult) {
    return cachedResult;
  }
  let result = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getOverflowAncestors)(element, [], false).filter(el => (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(el) && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeName)(el) !== 'body');
  let currentContainingBlockComputedStyle = null;
  const elementIsFixed = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element).position === 'fixed';
  let currentNode = elementIsFixed ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(element) : element;

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  while ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(currentNode) && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isLastTraversableNode)(currentNode)) {
    const computedStyle = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(currentNode);
    const currentNodeIsContaining = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isContainingBlock)(currentNode);
    if (!currentNodeIsContaining && computedStyle.position === 'fixed') {
      currentContainingBlockComputedStyle = null;
    }
    const shouldDropCurrentNode = elementIsFixed ? !currentNodeIsContaining && !currentContainingBlockComputedStyle : !currentNodeIsContaining && computedStyle.position === 'static' && !!currentContainingBlockComputedStyle && absoluteOrFixed.has(currentContainingBlockComputedStyle.position) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isOverflowElement)(currentNode) && !currentNodeIsContaining && hasFixedPositionAncestor(element, currentNode);
    if (shouldDropCurrentNode) {
      // Drop non-containing blocks.
      result = result.filter(ancestor => ancestor !== currentNode);
    } else {
      // Record last containing block for next iteration.
      currentContainingBlockComputedStyle = computedStyle;
    }
    currentNode = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(currentNode);
  }
  cache.set(element, result);
  return result;
}

// Gets the maximum area that the element is visible in due to any number of
// clipping ancestors.
function getClippingRect(_ref) {
  let {
    element,
    boundary,
    rootBoundary,
    strategy
  } = _ref;
  const elementClippingAncestors = boundary === 'clippingAncestors' ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isTopLayer)(element) ? [] : getClippingElementAncestors(element, this._c) : [].concat(boundary);
  const clippingAncestors = [...elementClippingAncestors, rootBoundary];
  const firstClippingAncestor = clippingAncestors[0];
  const clippingRect = clippingAncestors.reduce((accRect, clippingAncestor) => {
    const rect = getClientRectFromClippingAncestor(element, clippingAncestor, strategy);
    accRect.top = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(rect.top, accRect.top);
    accRect.right = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.min)(rect.right, accRect.right);
    accRect.bottom = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.min)(rect.bottom, accRect.bottom);
    accRect.left = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromClippingAncestor(element, firstClippingAncestor, strategy));
  return {
    width: clippingRect.right - clippingRect.left,
    height: clippingRect.bottom - clippingRect.top,
    x: clippingRect.left,
    y: clippingRect.top
  };
}

function getDimensions(element) {
  const {
    width,
    height
  } = getCssDimensions(element);
  return {
    width,
    height
  };
}

function getRectRelativeToOffsetParent(element, offsetParent, strategy) {
  const isOffsetParentAnElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(offsetParent);
  const documentElement = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(offsetParent);
  const isFixed = strategy === 'fixed';
  const rect = getBoundingClientRect(element, true, isFixed, offsetParent);
  let scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  const offsets = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);

  // If the <body> scrollbar appears on the left (e.g. RTL systems). Use
  // Firefox with layout.scrollbar.side = 3 in about:config to test this.
  function setLeftRTLScrollbarOffset() {
    offsets.x = getWindowScrollBarX(documentElement);
  }
  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeName)(offsetParent) !== 'body' || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isOverflowElement)(documentElement)) {
      scroll = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getNodeScroll)(offsetParent);
    }
    if (isOffsetParentAnElement) {
      const offsetRect = getBoundingClientRect(offsetParent, true, isFixed, offsetParent);
      offsets.x = offsetRect.x + offsetParent.clientLeft;
      offsets.y = offsetRect.y + offsetParent.clientTop;
    } else if (documentElement) {
      setLeftRTLScrollbarOffset();
    }
  }
  if (isFixed && !isOffsetParentAnElement && documentElement) {
    setLeftRTLScrollbarOffset();
  }
  const htmlOffset = documentElement && !isOffsetParentAnElement && !isFixed ? getHTMLOffset(documentElement, scroll) : (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.createCoords)(0);
  const x = rect.left + scroll.scrollLeft - offsets.x - htmlOffset.x;
  const y = rect.top + scroll.scrollTop - offsets.y - htmlOffset.y;
  return {
    x,
    y,
    width: rect.width,
    height: rect.height
  };
}

function isStaticPositioned(element) {
  return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element).position === 'static';
}

function getTrueOffsetParent(element, polyfill) {
  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(element) || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element).position === 'fixed') {
    return null;
  }
  if (polyfill) {
    return polyfill(element);
  }
  let rawOffsetParent = element.offsetParent;

  // Firefox returns the <html> element as the offsetParent if it's non-static,
  // while Chrome and Safari return the <body> element. The <body> element must
  // be used to perform the correct calculations even if the <html> element is
  // non-static.
  if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element) === rawOffsetParent) {
    rawOffsetParent = rawOffsetParent.ownerDocument.body;
  }
  return rawOffsetParent;
}

// Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.
function getOffsetParent(element, polyfill) {
  const win = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getWindow)(element);
  if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isTopLayer)(element)) {
    return win;
  }
  if (!(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(element)) {
    let svgOffsetParent = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(element);
    while (svgOffsetParent && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isLastTraversableNode)(svgOffsetParent)) {
      if ((0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement)(svgOffsetParent) && !isStaticPositioned(svgOffsetParent)) {
        return svgOffsetParent;
      }
      svgOffsetParent = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getParentNode)(svgOffsetParent);
    }
    return win;
  }
  let offsetParent = getTrueOffsetParent(element, polyfill);
  while (offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isTableElement)(offsetParent) && isStaticPositioned(offsetParent)) {
    offsetParent = getTrueOffsetParent(offsetParent, polyfill);
  }
  if (offsetParent && (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isLastTraversableNode)(offsetParent) && isStaticPositioned(offsetParent) && !(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isContainingBlock)(offsetParent)) {
    return win;
  }
  return offsetParent || (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getContainingBlock)(element) || win;
}

const getElementRects = async function (data) {
  const getOffsetParentFn = this.getOffsetParent || getOffsetParent;
  const getDimensionsFn = this.getDimensions;
  const floatingDimensions = await getDimensionsFn(data.floating);
  return {
    reference: getRectRelativeToOffsetParent(data.reference, await getOffsetParentFn(data.floating), data.strategy),
    floating: {
      x: 0,
      y: 0,
      width: floatingDimensions.width,
      height: floatingDimensions.height
    }
  };
};

function isRTL(element) {
  return (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getComputedStyle)(element).direction === 'rtl';
}

const platform = {
  convertOffsetParentRelativeRectToViewportRelativeRect,
  getDocumentElement: _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement,
  getClippingRect,
  getOffsetParent,
  getElementRects,
  getClientRects,
  getDimensions,
  getScale,
  isElement: _floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.isElement,
  isRTL
};

function rectsAreEqual(a, b) {
  return a.x === b.x && a.y === b.y && a.width === b.width && a.height === b.height;
}

// https://samthor.au/2021/observing-dom/
function observeMove(element, onMove) {
  let io = null;
  let timeoutId;
  const root = (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getDocumentElement)(element);
  function cleanup() {
    var _io;
    clearTimeout(timeoutId);
    (_io = io) == null || _io.disconnect();
    io = null;
  }
  function refresh(skip, threshold) {
    if (skip === void 0) {
      skip = false;
    }
    if (threshold === void 0) {
      threshold = 1;
    }
    cleanup();
    const elementRectForRootMargin = element.getBoundingClientRect();
    const {
      left,
      top,
      width,
      height
    } = elementRectForRootMargin;
    if (!skip) {
      onMove();
    }
    if (!width || !height) {
      return;
    }
    const insetTop = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.floor)(top);
    const insetRight = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.floor)(root.clientWidth - (left + width));
    const insetBottom = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.floor)(root.clientHeight - (top + height));
    const insetLeft = (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.floor)(left);
    const rootMargin = -insetTop + "px " + -insetRight + "px " + -insetBottom + "px " + -insetLeft + "px";
    const options = {
      rootMargin,
      threshold: (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.max)(0, (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_0__.min)(1, threshold)) || 1
    };
    let isFirstUpdate = true;
    function handleObserve(entries) {
      const ratio = entries[0].intersectionRatio;
      if (ratio !== threshold) {
        if (!isFirstUpdate) {
          return refresh();
        }
        if (!ratio) {
          // If the reference is clipped, the ratio is 0. Throttle the refresh
          // to prevent an infinite loop of updates.
          timeoutId = setTimeout(() => {
            refresh(false, 1e-7);
          }, 1000);
        } else {
          refresh(false, ratio);
        }
      }
      if (ratio === 1 && !rectsAreEqual(elementRectForRootMargin, element.getBoundingClientRect())) {
        // It's possible that even though the ratio is reported as 1, the
        // element is not actually fully within the IntersectionObserver's root
        // area anymore. This can happen under performance constraints. This may
        // be a bug in the browser's IntersectionObserver implementation. To
        // work around this, we compare the element's bounding rect now with
        // what it was at the time we created the IntersectionObserver. If they
        // are not equal then the element moved, so we refresh.
        refresh();
      }
      isFirstUpdate = false;
    }

    // Older browsers don't support a `document` as the root and will throw an
    // error.
    try {
      io = new IntersectionObserver(handleObserve, {
        ...options,
        // Handle <iframe>s
        root: root.ownerDocument
      });
    } catch (_e) {
      io = new IntersectionObserver(handleObserve, options);
    }
    io.observe(element);
  }
  refresh(true);
  return cleanup;
}

/**
 * Automatically updates the position of the floating element when necessary.
 * Should only be called when the floating element is mounted on the DOM or
 * visible on the screen.
 * @returns cleanup function that should be invoked when the floating element is
 * removed from the DOM or hidden from the screen.
 * @see https://floating-ui.com/docs/autoUpdate
 */
function autoUpdate(reference, floating, update, options) {
  if (options === void 0) {
    options = {};
  }
  const {
    ancestorScroll = true,
    ancestorResize = true,
    elementResize = typeof ResizeObserver === 'function',
    layoutShift = typeof IntersectionObserver === 'function',
    animationFrame = false
  } = options;
  const referenceEl = unwrapElement(reference);
  const ancestors = ancestorScroll || ancestorResize ? [...(referenceEl ? (0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getOverflowAncestors)(referenceEl) : []), ...(0,_floating_ui_utils_dom__WEBPACK_IMPORTED_MODULE_2__.getOverflowAncestors)(floating)] : [];
  ancestors.forEach(ancestor => {
    ancestorScroll && ancestor.addEventListener('scroll', update, {
      passive: true
    });
    ancestorResize && ancestor.addEventListener('resize', update);
  });
  const cleanupIo = referenceEl && layoutShift ? observeMove(referenceEl, update) : null;
  let reobserveFrame = -1;
  let resizeObserver = null;
  if (elementResize) {
    resizeObserver = new ResizeObserver(_ref => {
      let [firstEntry] = _ref;
      if (firstEntry && firstEntry.target === referenceEl && resizeObserver) {
        // Prevent update loops when using the `size` middleware.
        // https://github.com/floating-ui/floating-ui/issues/1740
        resizeObserver.unobserve(floating);
        cancelAnimationFrame(reobserveFrame);
        reobserveFrame = requestAnimationFrame(() => {
          var _resizeObserver;
          (_resizeObserver = resizeObserver) == null || _resizeObserver.observe(floating);
        });
      }
      update();
    });
    if (referenceEl && !animationFrame) {
      resizeObserver.observe(referenceEl);
    }
    resizeObserver.observe(floating);
  }
  let frameId;
  let prevRefRect = animationFrame ? getBoundingClientRect(reference) : null;
  if (animationFrame) {
    frameLoop();
  }
  function frameLoop() {
    const nextRefRect = getBoundingClientRect(reference);
    if (prevRefRect && !rectsAreEqual(prevRefRect, nextRefRect)) {
      update();
    }
    prevRefRect = nextRefRect;
    frameId = requestAnimationFrame(frameLoop);
  }
  update();
  return () => {
    var _resizeObserver2;
    ancestors.forEach(ancestor => {
      ancestorScroll && ancestor.removeEventListener('scroll', update);
      ancestorResize && ancestor.removeEventListener('resize', update);
    });
    cleanupIo == null || cleanupIo();
    (_resizeObserver2 = resizeObserver) == null || _resizeObserver2.disconnect();
    resizeObserver = null;
    if (animationFrame) {
      cancelAnimationFrame(frameId);
    }
  };
}

/**
 * Resolves with an object of overflow side offsets that determine how much the
 * element is overflowing a given clipping boundary on each side.
 * - positive = overflowing the boundary by that number of pixels
 * - negative = how many pixels left before it will overflow
 * - 0 = lies flush with the boundary
 * @see https://floating-ui.com/docs/detectOverflow
 */
const detectOverflow = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.detectOverflow;

/**
 * Modifies the placement by translating the floating element along the
 * specified axes.
 * A number (shorthand for `mainAxis` or distance), or an axes configuration
 * object may be passed.
 * @see https://floating-ui.com/docs/offset
 */
const offset = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.offset;

/**
 * Optimizes the visibility of the floating element by choosing the placement
 * that has the most space available automatically, without needing to specify a
 * preferred placement. Alternative to `flip`.
 * @see https://floating-ui.com/docs/autoPlacement
 */
const autoPlacement = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.autoPlacement;

/**
 * Optimizes the visibility of the floating element by shifting it in order to
 * keep it in view when it will overflow the clipping boundary.
 * @see https://floating-ui.com/docs/shift
 */
const shift = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.shift;

/**
 * Optimizes the visibility of the floating element by flipping the `placement`
 * in order to keep it in view when the preferred placement(s) will overflow the
 * clipping boundary. Alternative to `autoPlacement`.
 * @see https://floating-ui.com/docs/flip
 */
const flip = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.flip;

/**
 * Provides data that allows you to change the size of the floating element —
 * for instance, prevent it from overflowing the clipping boundary or match the
 * width of the reference element.
 * @see https://floating-ui.com/docs/size
 */
const size = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.size;

/**
 * Provides data to hide the floating element in applicable situations, such as
 * when it is not in the same clipping context as the reference element.
 * @see https://floating-ui.com/docs/hide
 */
const hide = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.hide;

/**
 * Provides data to position an inner element of the floating element so that it
 * appears centered to the reference element.
 * @see https://floating-ui.com/docs/arrow
 */
const arrow = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.arrow;

/**
 * Provides improved positioning for inline reference elements that can span
 * over multiple lines, such as hyperlinks or range selections.
 * @see https://floating-ui.com/docs/inline
 */
const inline = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.inline;

/**
 * Built-in `limiter` that will stop `shift()` at a certain point.
 */
const limitShift = _floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.limitShift;

/**
 * Computes the `x` and `y` coordinates that will place the floating element
 * next to a given reference element.
 */
const computePosition = (reference, floating, options) => {
  // This caches the expensive `getClippingElementAncestors` function so that
  // multiple lifecycle resets re-use the same result. It only lives for a
  // single call. If other functions become expensive, we can add them as well.
  const cache = new Map();
  const mergedOptions = {
    platform,
    ...options
  };
  const platformWithCache = {
    ...mergedOptions.platform,
    _c: cache
  };
  return (0,_floating_ui_core__WEBPACK_IMPORTED_MODULE_1__.computePosition)(reference, floating, {
    ...mergedOptions,
    platform: platformWithCache
  });
};




/***/ }),

/***/ "../../node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs":
/*!****************************************************************************!*\
  !*** ../../node_modules/@floating-ui/utils/dist/floating-ui.utils.dom.mjs ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getComputedStyle: () => (/* binding */ getComputedStyle),
/* harmony export */   getContainingBlock: () => (/* binding */ getContainingBlock),
/* harmony export */   getDocumentElement: () => (/* binding */ getDocumentElement),
/* harmony export */   getFrameElement: () => (/* binding */ getFrameElement),
/* harmony export */   getNearestOverflowAncestor: () => (/* binding */ getNearestOverflowAncestor),
/* harmony export */   getNodeName: () => (/* binding */ getNodeName),
/* harmony export */   getNodeScroll: () => (/* binding */ getNodeScroll),
/* harmony export */   getOverflowAncestors: () => (/* binding */ getOverflowAncestors),
/* harmony export */   getParentNode: () => (/* binding */ getParentNode),
/* harmony export */   getWindow: () => (/* binding */ getWindow),
/* harmony export */   isContainingBlock: () => (/* binding */ isContainingBlock),
/* harmony export */   isElement: () => (/* binding */ isElement),
/* harmony export */   isHTMLElement: () => (/* binding */ isHTMLElement),
/* harmony export */   isLastTraversableNode: () => (/* binding */ isLastTraversableNode),
/* harmony export */   isNode: () => (/* binding */ isNode),
/* harmony export */   isOverflowElement: () => (/* binding */ isOverflowElement),
/* harmony export */   isShadowRoot: () => (/* binding */ isShadowRoot),
/* harmony export */   isTableElement: () => (/* binding */ isTableElement),
/* harmony export */   isTopLayer: () => (/* binding */ isTopLayer),
/* harmony export */   isWebKit: () => (/* binding */ isWebKit)
/* harmony export */ });
function hasWindow() {
  return typeof window !== 'undefined';
}
function getNodeName(node) {
  if (isNode(node)) {
    return (node.nodeName || '').toLowerCase();
  }
  // Mocked nodes in testing environments may not be instances of Node. By
  // returning `#document` an infinite loop won't occur.
  // https://github.com/floating-ui/floating-ui/issues/2317
  return '#document';
}
function getWindow(node) {
  var _node$ownerDocument;
  return (node == null || (_node$ownerDocument = node.ownerDocument) == null ? void 0 : _node$ownerDocument.defaultView) || window;
}
function getDocumentElement(node) {
  var _ref;
  return (_ref = (isNode(node) ? node.ownerDocument : node.document) || window.document) == null ? void 0 : _ref.documentElement;
}
function isNode(value) {
  if (!hasWindow()) {
    return false;
  }
  return value instanceof Node || value instanceof getWindow(value).Node;
}
function isElement(value) {
  if (!hasWindow()) {
    return false;
  }
  return value instanceof Element || value instanceof getWindow(value).Element;
}
function isHTMLElement(value) {
  if (!hasWindow()) {
    return false;
  }
  return value instanceof HTMLElement || value instanceof getWindow(value).HTMLElement;
}
function isShadowRoot(value) {
  if (!hasWindow() || typeof ShadowRoot === 'undefined') {
    return false;
  }
  return value instanceof ShadowRoot || value instanceof getWindow(value).ShadowRoot;
}
const invalidOverflowDisplayValues = /*#__PURE__*/new Set(['inline', 'contents']);
function isOverflowElement(element) {
  const {
    overflow,
    overflowX,
    overflowY,
    display
  } = getComputedStyle(element);
  return /auto|scroll|overlay|hidden|clip/.test(overflow + overflowY + overflowX) && !invalidOverflowDisplayValues.has(display);
}
const tableElements = /*#__PURE__*/new Set(['table', 'td', 'th']);
function isTableElement(element) {
  return tableElements.has(getNodeName(element));
}
const topLayerSelectors = [':popover-open', ':modal'];
function isTopLayer(element) {
  return topLayerSelectors.some(selector => {
    try {
      return element.matches(selector);
    } catch (_e) {
      return false;
    }
  });
}
const transformProperties = ['transform', 'translate', 'scale', 'rotate', 'perspective'];
const willChangeValues = ['transform', 'translate', 'scale', 'rotate', 'perspective', 'filter'];
const containValues = ['paint', 'layout', 'strict', 'content'];
function isContainingBlock(elementOrCss) {
  const webkit = isWebKit();
  const css = isElement(elementOrCss) ? getComputedStyle(elementOrCss) : elementOrCss;

  // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
  // https://drafts.csswg.org/css-transforms-2/#individual-transforms
  return transformProperties.some(value => css[value] ? css[value] !== 'none' : false) || (css.containerType ? css.containerType !== 'normal' : false) || !webkit && (css.backdropFilter ? css.backdropFilter !== 'none' : false) || !webkit && (css.filter ? css.filter !== 'none' : false) || willChangeValues.some(value => (css.willChange || '').includes(value)) || containValues.some(value => (css.contain || '').includes(value));
}
function getContainingBlock(element) {
  let currentNode = getParentNode(element);
  while (isHTMLElement(currentNode) && !isLastTraversableNode(currentNode)) {
    if (isContainingBlock(currentNode)) {
      return currentNode;
    } else if (isTopLayer(currentNode)) {
      return null;
    }
    currentNode = getParentNode(currentNode);
  }
  return null;
}
function isWebKit() {
  if (typeof CSS === 'undefined' || !CSS.supports) return false;
  return CSS.supports('-webkit-backdrop-filter', 'none');
}
const lastTraversableNodeNames = /*#__PURE__*/new Set(['html', 'body', '#document']);
function isLastTraversableNode(node) {
  return lastTraversableNodeNames.has(getNodeName(node));
}
function getComputedStyle(element) {
  return getWindow(element).getComputedStyle(element);
}
function getNodeScroll(element) {
  if (isElement(element)) {
    return {
      scrollLeft: element.scrollLeft,
      scrollTop: element.scrollTop
    };
  }
  return {
    scrollLeft: element.scrollX,
    scrollTop: element.scrollY
  };
}
function getParentNode(node) {
  if (getNodeName(node) === 'html') {
    return node;
  }
  const result =
  // Step into the shadow DOM of the parent of a slotted node.
  node.assignedSlot ||
  // DOM Element detected.
  node.parentNode ||
  // ShadowRoot detected.
  isShadowRoot(node) && node.host ||
  // Fallback.
  getDocumentElement(node);
  return isShadowRoot(result) ? result.host : result;
}
function getNearestOverflowAncestor(node) {
  const parentNode = getParentNode(node);
  if (isLastTraversableNode(parentNode)) {
    return node.ownerDocument ? node.ownerDocument.body : node.body;
  }
  if (isHTMLElement(parentNode) && isOverflowElement(parentNode)) {
    return parentNode;
  }
  return getNearestOverflowAncestor(parentNode);
}
function getOverflowAncestors(node, list, traverseIframes) {
  var _node$ownerDocument2;
  if (list === void 0) {
    list = [];
  }
  if (traverseIframes === void 0) {
    traverseIframes = true;
  }
  const scrollableAncestor = getNearestOverflowAncestor(node);
  const isBody = scrollableAncestor === ((_node$ownerDocument2 = node.ownerDocument) == null ? void 0 : _node$ownerDocument2.body);
  const win = getWindow(scrollableAncestor);
  if (isBody) {
    const frameElement = getFrameElement(win);
    return list.concat(win, win.visualViewport || [], isOverflowElement(scrollableAncestor) ? scrollableAncestor : [], frameElement && traverseIframes ? getOverflowAncestors(frameElement) : []);
  }
  return list.concat(scrollableAncestor, getOverflowAncestors(scrollableAncestor, [], traverseIframes));
}
function getFrameElement(win) {
  return win.parent && Object.getPrototypeOf(win.parent) ? win.frameElement : null;
}




/***/ }),

/***/ "../../node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs":
/*!************************************************************************!*\
  !*** ../../node_modules/@floating-ui/utils/dist/floating-ui.utils.mjs ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   alignments: () => (/* binding */ alignments),
/* harmony export */   clamp: () => (/* binding */ clamp),
/* harmony export */   createCoords: () => (/* binding */ createCoords),
/* harmony export */   evaluate: () => (/* binding */ evaluate),
/* harmony export */   expandPaddingObject: () => (/* binding */ expandPaddingObject),
/* harmony export */   floor: () => (/* binding */ floor),
/* harmony export */   getAlignment: () => (/* binding */ getAlignment),
/* harmony export */   getAlignmentAxis: () => (/* binding */ getAlignmentAxis),
/* harmony export */   getAlignmentSides: () => (/* binding */ getAlignmentSides),
/* harmony export */   getAxisLength: () => (/* binding */ getAxisLength),
/* harmony export */   getExpandedPlacements: () => (/* binding */ getExpandedPlacements),
/* harmony export */   getOppositeAlignmentPlacement: () => (/* binding */ getOppositeAlignmentPlacement),
/* harmony export */   getOppositeAxis: () => (/* binding */ getOppositeAxis),
/* harmony export */   getOppositeAxisPlacements: () => (/* binding */ getOppositeAxisPlacements),
/* harmony export */   getOppositePlacement: () => (/* binding */ getOppositePlacement),
/* harmony export */   getPaddingObject: () => (/* binding */ getPaddingObject),
/* harmony export */   getSide: () => (/* binding */ getSide),
/* harmony export */   getSideAxis: () => (/* binding */ getSideAxis),
/* harmony export */   max: () => (/* binding */ max),
/* harmony export */   min: () => (/* binding */ min),
/* harmony export */   placements: () => (/* binding */ placements),
/* harmony export */   rectToClientRect: () => (/* binding */ rectToClientRect),
/* harmony export */   round: () => (/* binding */ round),
/* harmony export */   sides: () => (/* binding */ sides)
/* harmony export */ });
/**
 * Custom positioning reference element.
 * @see https://floating-ui.com/docs/virtual-elements
 */

const sides = ['top', 'right', 'bottom', 'left'];
const alignments = ['start', 'end'];
const placements = /*#__PURE__*/sides.reduce((acc, side) => acc.concat(side, side + "-" + alignments[0], side + "-" + alignments[1]), []);
const min = Math.min;
const max = Math.max;
const round = Math.round;
const floor = Math.floor;
const createCoords = v => ({
  x: v,
  y: v
});
const oppositeSideMap = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
const oppositeAlignmentMap = {
  start: 'end',
  end: 'start'
};
function clamp(start, value, end) {
  return max(start, min(value, end));
}
function evaluate(value, param) {
  return typeof value === 'function' ? value(param) : value;
}
function getSide(placement) {
  return placement.split('-')[0];
}
function getAlignment(placement) {
  return placement.split('-')[1];
}
function getOppositeAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}
function getAxisLength(axis) {
  return axis === 'y' ? 'height' : 'width';
}
const yAxisSides = /*#__PURE__*/new Set(['top', 'bottom']);
function getSideAxis(placement) {
  return yAxisSides.has(getSide(placement)) ? 'y' : 'x';
}
function getAlignmentAxis(placement) {
  return getOppositeAxis(getSideAxis(placement));
}
function getAlignmentSides(placement, rects, rtl) {
  if (rtl === void 0) {
    rtl = false;
  }
  const alignment = getAlignment(placement);
  const alignmentAxis = getAlignmentAxis(placement);
  const length = getAxisLength(alignmentAxis);
  let mainAlignmentSide = alignmentAxis === 'x' ? alignment === (rtl ? 'end' : 'start') ? 'right' : 'left' : alignment === 'start' ? 'bottom' : 'top';
  if (rects.reference[length] > rects.floating[length]) {
    mainAlignmentSide = getOppositePlacement(mainAlignmentSide);
  }
  return [mainAlignmentSide, getOppositePlacement(mainAlignmentSide)];
}
function getExpandedPlacements(placement) {
  const oppositePlacement = getOppositePlacement(placement);
  return [getOppositeAlignmentPlacement(placement), oppositePlacement, getOppositeAlignmentPlacement(oppositePlacement)];
}
function getOppositeAlignmentPlacement(placement) {
  return placement.replace(/start|end/g, alignment => oppositeAlignmentMap[alignment]);
}
const lrPlacement = ['left', 'right'];
const rlPlacement = ['right', 'left'];
const tbPlacement = ['top', 'bottom'];
const btPlacement = ['bottom', 'top'];
function getSideList(side, isStart, rtl) {
  switch (side) {
    case 'top':
    case 'bottom':
      if (rtl) return isStart ? rlPlacement : lrPlacement;
      return isStart ? lrPlacement : rlPlacement;
    case 'left':
    case 'right':
      return isStart ? tbPlacement : btPlacement;
    default:
      return [];
  }
}
function getOppositeAxisPlacements(placement, flipAlignment, direction, rtl) {
  const alignment = getAlignment(placement);
  let list = getSideList(getSide(placement), direction === 'start', rtl);
  if (alignment) {
    list = list.map(side => side + "-" + alignment);
    if (flipAlignment) {
      list = list.concat(list.map(getOppositeAlignmentPlacement));
    }
  }
  return list;
}
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, side => oppositeSideMap[side]);
}
function expandPaddingObject(padding) {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0,
    ...padding
  };
}
function getPaddingObject(padding) {
  return typeof padding !== 'number' ? expandPaddingObject(padding) : {
    top: padding,
    right: padding,
    bottom: padding,
    left: padding
  };
}
function rectToClientRect(rect) {
  const {
    x,
    y,
    width,
    height
  } = rect;
  return {
    width,
    height,
    top: y,
    left: x,
    right: x + width,
    bottom: y + height,
    x,
    y
  };
}




/***/ }),

/***/ "../../node_modules/@fortawesome/fontawesome-svg-core/index.es.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@fortawesome/fontawesome-svg-core/index.es.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   config: () => (/* binding */ config),
/* harmony export */   counter: () => (/* binding */ counter),
/* harmony export */   dom: () => (/* binding */ dom),
/* harmony export */   findIconDefinition: () => (/* binding */ findIconDefinition),
/* harmony export */   icon: () => (/* binding */ icon),
/* harmony export */   layer: () => (/* binding */ layer),
/* harmony export */   library: () => (/* binding */ library),
/* harmony export */   noAuto: () => (/* binding */ noAuto),
/* harmony export */   parse: () => (/* binding */ parse),
/* harmony export */   text: () => (/* binding */ text),
/* harmony export */   toHtml: () => (/* binding */ toHtml)
/* harmony export */ });
/*!
 * Font Awesome Free 5.15.4 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license/free (Icons: CC BY 4.0, Fonts: SIL OFL 1.1, Code: MIT License)
 */
function _typeof(obj) {
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function (obj) {
      return typeof obj;
    };
  } else {
    _typeof = function (obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  return Constructor;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    var ownKeys = Object.keys(source);

    if (typeof Object.getOwnPropertySymbols === 'function') {
      ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
        return Object.getOwnPropertyDescriptor(source, sym).enumerable;
      }));
    }

    ownKeys.forEach(function (key) {
      _defineProperty(target, key, source[key]);
    });
  }

  return target;
}

function _slicedToArray(arr, i) {
  return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  }
}

function _arrayWithHoles(arr) {
  if (Array.isArray(arr)) return arr;
}

function _iterableToArray(iter) {
  if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
}

function _iterableToArrayLimit(arr, i) {
  var _arr = [];
  var _n = true;
  var _d = false;
  var _e = undefined;

  try {
    for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
      _arr.push(_s.value);

      if (i && _arr.length === i) break;
    }
  } catch (err) {
    _d = true;
    _e = err;
  } finally {
    try {
      if (!_n && _i["return"] != null) _i["return"]();
    } finally {
      if (_d) throw _e;
    }
  }

  return _arr;
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}

function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance");
}

var noop = function noop() {};

var _WINDOW = {};
var _DOCUMENT = {};
var _MUTATION_OBSERVER = null;
var _PERFORMANCE = {
  mark: noop,
  measure: noop
};

try {
  if (typeof window !== 'undefined') _WINDOW = window;
  if (typeof document !== 'undefined') _DOCUMENT = document;
  if (typeof MutationObserver !== 'undefined') _MUTATION_OBSERVER = MutationObserver;
  if (typeof performance !== 'undefined') _PERFORMANCE = performance;
} catch (e) {}

var _ref = _WINDOW.navigator || {},
    _ref$userAgent = _ref.userAgent,
    userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;

var WINDOW = _WINDOW;
var DOCUMENT = _DOCUMENT;
var MUTATION_OBSERVER = _MUTATION_OBSERVER;
var PERFORMANCE = _PERFORMANCE;
var IS_BROWSER = !!WINDOW.document;
var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
var UNITS_IN_GRID = 16;
var DEFAULT_FAMILY_PREFIX = 'fa';
var DEFAULT_REPLACEMENT_CLASS = 'svg-inline--fa';
var DATA_FA_I2SVG = 'data-fa-i2svg';
var DATA_FA_PSEUDO_ELEMENT = 'data-fa-pseudo-element';
var DATA_FA_PSEUDO_ELEMENT_PENDING = 'data-fa-pseudo-element-pending';
var DATA_PREFIX = 'data-prefix';
var DATA_ICON = 'data-icon';
var HTML_CLASS_I2SVG_BASE_CLASS = 'fontawesome-i2svg';
var MUTATION_APPROACH_ASYNC = 'async';
var TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS = ['HTML', 'HEAD', 'STYLE', 'SCRIPT'];
var PRODUCTION = function () {
  try {
    return "development" === 'production';
  } catch (e) {
    return false;
  }
}();
var PREFIX_TO_STYLE = {
  'fas': 'solid',
  'far': 'regular',
  'fal': 'light',
  'fad': 'duotone',
  'fab': 'brands',
  'fak': 'kit',
  'fa': 'solid'
};
var STYLE_TO_PREFIX = {
  'solid': 'fas',
  'regular': 'far',
  'light': 'fal',
  'duotone': 'fad',
  'brands': 'fab',
  'kit': 'fak'
};
var LAYERS_TEXT_CLASSNAME = 'fa-layers-text';
var FONT_FAMILY_PATTERN = /Font Awesome ([5 ]*)(Solid|Regular|Light|Duotone|Brands|Free|Pro|Kit).*/i; // TODO: do we need to handle font-weight for kit SVG pseudo-elements?

var FONT_WEIGHT_TO_PREFIX = {
  '900': 'fas',
  '400': 'far',
  'normal': 'far',
  '300': 'fal'
};
var oneToTen = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
var oneToTwenty = oneToTen.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]);
var ATTRIBUTES_WATCHED_FOR_MUTATION = ['class', 'data-prefix', 'data-icon', 'data-fa-transform', 'data-fa-mask'];
var DUOTONE_CLASSES = {
  GROUP: 'group',
  SWAP_OPACITY: 'swap-opacity',
  PRIMARY: 'primary',
  SECONDARY: 'secondary'
};
var RESERVED_CLASSES = ['xs', 'sm', 'lg', 'fw', 'ul', 'li', 'border', 'pull-left', 'pull-right', 'spin', 'pulse', 'rotate-90', 'rotate-180', 'rotate-270', 'flip-horizontal', 'flip-vertical', 'flip-both', 'stack', 'stack-1x', 'stack-2x', 'inverse', 'layers', 'layers-text', 'layers-counter', DUOTONE_CLASSES.GROUP, DUOTONE_CLASSES.SWAP_OPACITY, DUOTONE_CLASSES.PRIMARY, DUOTONE_CLASSES.SECONDARY].concat(oneToTen.map(function (n) {
  return "".concat(n, "x");
})).concat(oneToTwenty.map(function (n) {
  return "w-".concat(n);
}));

var initial = WINDOW.FontAwesomeConfig || {};

function getAttrConfig(attr) {
  var element = DOCUMENT.querySelector('script[' + attr + ']');

  if (element) {
    return element.getAttribute(attr);
  }
}

function coerce(val) {
  // Getting an empty string will occur if the attribute is set on the HTML tag but without a value
  // We'll assume that this is an indication that it should be toggled to true
  // For example <script data-search-pseudo-elements src="..."></script>
  if (val === '') return true;
  if (val === 'false') return false;
  if (val === 'true') return true;
  return val;
}

if (DOCUMENT && typeof DOCUMENT.querySelector === 'function') {
  var attrs = [['data-family-prefix', 'familyPrefix'], ['data-replacement-class', 'replacementClass'], ['data-auto-replace-svg', 'autoReplaceSvg'], ['data-auto-add-css', 'autoAddCss'], ['data-auto-a11y', 'autoA11y'], ['data-search-pseudo-elements', 'searchPseudoElements'], ['data-observe-mutations', 'observeMutations'], ['data-mutate-approach', 'mutateApproach'], ['data-keep-original-source', 'keepOriginalSource'], ['data-measure-performance', 'measurePerformance'], ['data-show-missing-icons', 'showMissingIcons']];
  attrs.forEach(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        attr = _ref2[0],
        key = _ref2[1];

    var val = coerce(getAttrConfig(attr));

    if (val !== undefined && val !== null) {
      initial[key] = val;
    }
  });
}

var _default = {
  familyPrefix: DEFAULT_FAMILY_PREFIX,
  replacementClass: DEFAULT_REPLACEMENT_CLASS,
  autoReplaceSvg: true,
  autoAddCss: true,
  autoA11y: true,
  searchPseudoElements: false,
  observeMutations: true,
  mutateApproach: 'async',
  keepOriginalSource: true,
  measurePerformance: false,
  showMissingIcons: true
};

var _config = _objectSpread({}, _default, initial);

if (!_config.autoReplaceSvg) _config.observeMutations = false;

var config = _objectSpread({}, _config);

WINDOW.FontAwesomeConfig = config;

var w = WINDOW || {};
if (!w[NAMESPACE_IDENTIFIER]) w[NAMESPACE_IDENTIFIER] = {};
if (!w[NAMESPACE_IDENTIFIER].styles) w[NAMESPACE_IDENTIFIER].styles = {};
if (!w[NAMESPACE_IDENTIFIER].hooks) w[NAMESPACE_IDENTIFIER].hooks = {};
if (!w[NAMESPACE_IDENTIFIER].shims) w[NAMESPACE_IDENTIFIER].shims = [];
var namespace = w[NAMESPACE_IDENTIFIER];

var functions = [];

var listener = function listener() {
  DOCUMENT.removeEventListener('DOMContentLoaded', listener);
  loaded = 1;
  functions.map(function (fn) {
    return fn();
  });
};

var loaded = false;

if (IS_DOM) {
  loaded = (DOCUMENT.documentElement.doScroll ? /^loaded|^c/ : /^loaded|^i|^c/).test(DOCUMENT.readyState);
  if (!loaded) DOCUMENT.addEventListener('DOMContentLoaded', listener);
}

function domready (fn) {
  if (!IS_DOM) return;
  loaded ? setTimeout(fn, 0) : functions.push(fn);
}

var PENDING = 'pending';
var SETTLED = 'settled';
var FULFILLED = 'fulfilled';
var REJECTED = 'rejected';

var NOOP = function NOOP() {};

var isNode = typeof __webpack_require__.g !== 'undefined' && typeof __webpack_require__.g.process !== 'undefined' && typeof __webpack_require__.g.process.emit === 'function';
var asyncSetTimer = typeof setImmediate === 'undefined' ? setTimeout : setImmediate;
var asyncQueue = [];
var asyncTimer;

function asyncFlush() {
  // run promise callbacks
  for (var i = 0; i < asyncQueue.length; i++) {
    asyncQueue[i][0](asyncQueue[i][1]);
  } // reset async asyncQueue


  asyncQueue = [];
  asyncTimer = false;
}

function asyncCall(callback, arg) {
  asyncQueue.push([callback, arg]);

  if (!asyncTimer) {
    asyncTimer = true;
    asyncSetTimer(asyncFlush, 0);
  }
}

function invokeResolver(resolver, promise) {
  function resolvePromise(value) {
    resolve(promise, value);
  }

  function rejectPromise(reason) {
    reject(promise, reason);
  }

  try {
    resolver(resolvePromise, rejectPromise);
  } catch (e) {
    rejectPromise(e);
  }
}

function invokeCallback(subscriber) {
  var owner = subscriber.owner;
  var settled = owner._state;
  var value = owner._data;
  var callback = subscriber[settled];
  var promise = subscriber.then;

  if (typeof callback === 'function') {
    settled = FULFILLED;

    try {
      value = callback(value);
    } catch (e) {
      reject(promise, e);
    }
  }

  if (!handleThenable(promise, value)) {
    if (settled === FULFILLED) {
      resolve(promise, value);
    }

    if (settled === REJECTED) {
      reject(promise, value);
    }
  }
}

function handleThenable(promise, value) {
  var resolved;

  try {
    if (promise === value) {
      throw new TypeError('A promises callback cannot return that same promise.');
    }

    if (value && (typeof value === 'function' || _typeof(value) === 'object')) {
      // then should be retrieved only once
      var then = value.then;

      if (typeof then === 'function') {
        then.call(value, function (val) {
          if (!resolved) {
            resolved = true;

            if (value === val) {
              fulfill(promise, val);
            } else {
              resolve(promise, val);
            }
          }
        }, function (reason) {
          if (!resolved) {
            resolved = true;
            reject(promise, reason);
          }
        });
        return true;
      }
    }
  } catch (e) {
    if (!resolved) {
      reject(promise, e);
    }

    return true;
  }

  return false;
}

function resolve(promise, value) {
  if (promise === value || !handleThenable(promise, value)) {
    fulfill(promise, value);
  }
}

function fulfill(promise, value) {
  if (promise._state === PENDING) {
    promise._state = SETTLED;
    promise._data = value;
    asyncCall(publishFulfillment, promise);
  }
}

function reject(promise, reason) {
  if (promise._state === PENDING) {
    promise._state = SETTLED;
    promise._data = reason;
    asyncCall(publishRejection, promise);
  }
}

function publish(promise) {
  promise._then = promise._then.forEach(invokeCallback);
}

function publishFulfillment(promise) {
  promise._state = FULFILLED;
  publish(promise);
}

function publishRejection(promise) {
  promise._state = REJECTED;
  publish(promise);

  if (!promise._handled && isNode) {
    __webpack_require__.g.process.emit('unhandledRejection', promise._data, promise);
  }
}

function notifyRejectionHandled(promise) {
  __webpack_require__.g.process.emit('rejectionHandled', promise);
}
/**
 * @class
 */


function P(resolver) {
  if (typeof resolver !== 'function') {
    throw new TypeError('Promise resolver ' + resolver + ' is not a function');
  }

  if (this instanceof P === false) {
    throw new TypeError('Failed to construct \'Promise\': Please use the \'new\' operator, this object constructor cannot be called as a function.');
  }

  this._then = [];
  invokeResolver(resolver, this);
}

P.prototype = {
  constructor: P,
  _state: PENDING,
  _then: null,
  _data: undefined,
  _handled: false,
  then: function then(onFulfillment, onRejection) {
    var subscriber = {
      owner: this,
      then: new this.constructor(NOOP),
      fulfilled: onFulfillment,
      rejected: onRejection
    };

    if ((onRejection || onFulfillment) && !this._handled) {
      this._handled = true;

      if (this._state === REJECTED && isNode) {
        asyncCall(notifyRejectionHandled, this);
      }
    }

    if (this._state === FULFILLED || this._state === REJECTED) {
      // already resolved, call callback async
      asyncCall(invokeCallback, subscriber);
    } else {
      // subscribe
      this._then.push(subscriber);
    }

    return subscriber.then;
  },
  catch: function _catch(onRejection) {
    return this.then(null, onRejection);
  }
};

P.all = function (promises) {
  if (!Array.isArray(promises)) {
    throw new TypeError('You must pass an array to Promise.all().');
  }

  return new P(function (resolve, reject) {
    var results = [];
    var remaining = 0;

    function resolver(index) {
      remaining++;
      return function (value) {
        results[index] = value;

        if (! --remaining) {
          resolve(results);
        }
      };
    }

    for (var i = 0, promise; i < promises.length; i++) {
      promise = promises[i];

      if (promise && typeof promise.then === 'function') {
        promise.then(resolver(i), reject);
      } else {
        results[i] = promise;
      }
    }

    if (!remaining) {
      resolve(results);
    }
  });
};

P.race = function (promises) {
  if (!Array.isArray(promises)) {
    throw new TypeError('You must pass an array to Promise.race().');
  }

  return new P(function (resolve, reject) {
    for (var i = 0, promise; i < promises.length; i++) {
      promise = promises[i];

      if (promise && typeof promise.then === 'function') {
        promise.then(resolve, reject);
      } else {
        resolve(promise);
      }
    }
  });
};

P.resolve = function (value) {
  if (value && _typeof(value) === 'object' && value.constructor === P) {
    return value;
  }

  return new P(function (resolve) {
    resolve(value);
  });
};

P.reject = function (reason) {
  return new P(function (resolve, reject) {
    reject(reason);
  });
};

var picked = typeof Promise === 'function' ? Promise : P;

var d = UNITS_IN_GRID;
var meaninglessTransform = {
  size: 16,
  x: 0,
  y: 0,
  rotate: 0,
  flipX: false,
  flipY: false
};

function isReserved(name) {
  return ~RESERVED_CLASSES.indexOf(name);
}
function insertCss(css) {
  if (!css || !IS_DOM) {
    return;
  }

  var style = DOCUMENT.createElement('style');
  style.setAttribute('type', 'text/css');
  style.innerHTML = css;
  var headChildren = DOCUMENT.head.childNodes;
  var beforeChild = null;

  for (var i = headChildren.length - 1; i > -1; i--) {
    var child = headChildren[i];
    var tagName = (child.tagName || '').toUpperCase();

    if (['STYLE', 'LINK'].indexOf(tagName) > -1) {
      beforeChild = child;
    }
  }

  DOCUMENT.head.insertBefore(style, beforeChild);
  return css;
}
var idPool = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
function nextUniqueId() {
  var size = 12;
  var id = '';

  while (size-- > 0) {
    id += idPool[Math.random() * 62 | 0];
  }

  return id;
}
function toArray(obj) {
  var array = [];

  for (var i = (obj || []).length >>> 0; i--;) {
    array[i] = obj[i];
  }

  return array;
}
function classArray(node) {
  if (node.classList) {
    return toArray(node.classList);
  } else {
    return (node.getAttribute('class') || '').split(' ').filter(function (i) {
      return i;
    });
  }
}
function getIconName(familyPrefix, cls) {
  var parts = cls.split('-');
  var prefix = parts[0];
  var iconName = parts.slice(1).join('-');

  if (prefix === familyPrefix && iconName !== '' && !isReserved(iconName)) {
    return iconName;
  } else {
    return null;
  }
}
function htmlEscape(str) {
  return "".concat(str).replace(/&/g, '&amp;').replace(/"/g, '&quot;').replace(/'/g, '&#39;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
}
function joinAttributes(attributes) {
  return Object.keys(attributes || {}).reduce(function (acc, attributeName) {
    return acc + "".concat(attributeName, "=\"").concat(htmlEscape(attributes[attributeName]), "\" ");
  }, '').trim();
}
function joinStyles(styles) {
  return Object.keys(styles || {}).reduce(function (acc, styleName) {
    return acc + "".concat(styleName, ": ").concat(styles[styleName], ";");
  }, '');
}
function transformIsMeaningful(transform) {
  return transform.size !== meaninglessTransform.size || transform.x !== meaninglessTransform.x || transform.y !== meaninglessTransform.y || transform.rotate !== meaninglessTransform.rotate || transform.flipX || transform.flipY;
}
function transformForSvg(_ref) {
  var transform = _ref.transform,
      containerWidth = _ref.containerWidth,
      iconWidth = _ref.iconWidth;
  var outer = {
    transform: "translate(".concat(containerWidth / 2, " 256)")
  };
  var innerTranslate = "translate(".concat(transform.x * 32, ", ").concat(transform.y * 32, ") ");
  var innerScale = "scale(".concat(transform.size / 16 * (transform.flipX ? -1 : 1), ", ").concat(transform.size / 16 * (transform.flipY ? -1 : 1), ") ");
  var innerRotate = "rotate(".concat(transform.rotate, " 0 0)");
  var inner = {
    transform: "".concat(innerTranslate, " ").concat(innerScale, " ").concat(innerRotate)
  };
  var path = {
    transform: "translate(".concat(iconWidth / 2 * -1, " -256)")
  };
  return {
    outer: outer,
    inner: inner,
    path: path
  };
}
function transformForCss(_ref2) {
  var transform = _ref2.transform,
      _ref2$width = _ref2.width,
      width = _ref2$width === void 0 ? UNITS_IN_GRID : _ref2$width,
      _ref2$height = _ref2.height,
      height = _ref2$height === void 0 ? UNITS_IN_GRID : _ref2$height,
      _ref2$startCentered = _ref2.startCentered,
      startCentered = _ref2$startCentered === void 0 ? false : _ref2$startCentered;
  var val = '';

  if (startCentered && IS_IE) {
    val += "translate(".concat(transform.x / d - width / 2, "em, ").concat(transform.y / d - height / 2, "em) ");
  } else if (startCentered) {
    val += "translate(calc(-50% + ".concat(transform.x / d, "em), calc(-50% + ").concat(transform.y / d, "em)) ");
  } else {
    val += "translate(".concat(transform.x / d, "em, ").concat(transform.y / d, "em) ");
  }

  val += "scale(".concat(transform.size / d * (transform.flipX ? -1 : 1), ", ").concat(transform.size / d * (transform.flipY ? -1 : 1), ") ");
  val += "rotate(".concat(transform.rotate, "deg) ");
  return val;
}

var ALL_SPACE = {
  x: 0,
  y: 0,
  width: '100%',
  height: '100%'
};

function fillBlack(abstract) {
  var force = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

  if (abstract.attributes && (abstract.attributes.fill || force)) {
    abstract.attributes.fill = 'black';
  }

  return abstract;
}

function deGroup(abstract) {
  if (abstract.tag === 'g') {
    return abstract.children;
  } else {
    return [abstract];
  }
}

function makeIconMasking (_ref) {
  var children = _ref.children,
      attributes = _ref.attributes,
      main = _ref.main,
      mask = _ref.mask,
      explicitMaskId = _ref.maskId,
      transform = _ref.transform;
  var mainWidth = main.width,
      mainPath = main.icon;
  var maskWidth = mask.width,
      maskPath = mask.icon;
  var trans = transformForSvg({
    transform: transform,
    containerWidth: maskWidth,
    iconWidth: mainWidth
  });
  var maskRect = {
    tag: 'rect',
    attributes: _objectSpread({}, ALL_SPACE, {
      fill: 'white'
    })
  };
  var maskInnerGroupChildrenMixin = mainPath.children ? {
    children: mainPath.children.map(fillBlack)
  } : {};
  var maskInnerGroup = {
    tag: 'g',
    attributes: _objectSpread({}, trans.inner),
    children: [fillBlack(_objectSpread({
      tag: mainPath.tag,
      attributes: _objectSpread({}, mainPath.attributes, trans.path)
    }, maskInnerGroupChildrenMixin))]
  };
  var maskOuterGroup = {
    tag: 'g',
    attributes: _objectSpread({}, trans.outer),
    children: [maskInnerGroup]
  };
  var maskId = "mask-".concat(explicitMaskId || nextUniqueId());
  var clipId = "clip-".concat(explicitMaskId || nextUniqueId());
  var maskTag = {
    tag: 'mask',
    attributes: _objectSpread({}, ALL_SPACE, {
      id: maskId,
      maskUnits: 'userSpaceOnUse',
      maskContentUnits: 'userSpaceOnUse'
    }),
    children: [maskRect, maskOuterGroup]
  };
  var defs = {
    tag: 'defs',
    children: [{
      tag: 'clipPath',
      attributes: {
        id: clipId
      },
      children: deGroup(maskPath)
    }, maskTag]
  };
  children.push(defs, {
    tag: 'rect',
    attributes: _objectSpread({
      fill: 'currentColor',
      'clip-path': "url(#".concat(clipId, ")"),
      mask: "url(#".concat(maskId, ")")
    }, ALL_SPACE)
  });
  return {
    children: children,
    attributes: attributes
  };
}

function makeIconStandard (_ref) {
  var children = _ref.children,
      attributes = _ref.attributes,
      main = _ref.main,
      transform = _ref.transform,
      styles = _ref.styles;
  var styleString = joinStyles(styles);

  if (styleString.length > 0) {
    attributes['style'] = styleString;
  }

  if (transformIsMeaningful(transform)) {
    var trans = transformForSvg({
      transform: transform,
      containerWidth: main.width,
      iconWidth: main.width
    });
    children.push({
      tag: 'g',
      attributes: _objectSpread({}, trans.outer),
      children: [{
        tag: 'g',
        attributes: _objectSpread({}, trans.inner),
        children: [{
          tag: main.icon.tag,
          children: main.icon.children,
          attributes: _objectSpread({}, main.icon.attributes, trans.path)
        }]
      }]
    });
  } else {
    children.push(main.icon);
  }

  return {
    children: children,
    attributes: attributes
  };
}

function asIcon (_ref) {
  var children = _ref.children,
      main = _ref.main,
      mask = _ref.mask,
      attributes = _ref.attributes,
      styles = _ref.styles,
      transform = _ref.transform;

  if (transformIsMeaningful(transform) && main.found && !mask.found) {
    var width = main.width,
        height = main.height;
    var offset = {
      x: width / height / 2,
      y: 0.5
    };
    attributes['style'] = joinStyles(_objectSpread({}, styles, {
      'transform-origin': "".concat(offset.x + transform.x / 16, "em ").concat(offset.y + transform.y / 16, "em")
    }));
  }

  return [{
    tag: 'svg',
    attributes: attributes,
    children: children
  }];
}

function asSymbol (_ref) {
  var prefix = _ref.prefix,
      iconName = _ref.iconName,
      children = _ref.children,
      attributes = _ref.attributes,
      symbol = _ref.symbol;
  var id = symbol === true ? "".concat(prefix, "-").concat(config.familyPrefix, "-").concat(iconName) : symbol;
  return [{
    tag: 'svg',
    attributes: {
      style: 'display: none;'
    },
    children: [{
      tag: 'symbol',
      attributes: _objectSpread({}, attributes, {
        id: id
      }),
      children: children
    }]
  }];
}

function makeInlineSvgAbstract(params) {
  var _params$icons = params.icons,
      main = _params$icons.main,
      mask = _params$icons.mask,
      prefix = params.prefix,
      iconName = params.iconName,
      transform = params.transform,
      symbol = params.symbol,
      title = params.title,
      maskId = params.maskId,
      titleId = params.titleId,
      extra = params.extra,
      _params$watchable = params.watchable,
      watchable = _params$watchable === void 0 ? false : _params$watchable;

  var _ref = mask.found ? mask : main,
      width = _ref.width,
      height = _ref.height;

  var isUploadedIcon = prefix === 'fak';
  var widthClass = isUploadedIcon ? '' : "fa-w-".concat(Math.ceil(width / height * 16));
  var attrClass = [config.replacementClass, iconName ? "".concat(config.familyPrefix, "-").concat(iconName) : '', widthClass].filter(function (c) {
    return extra.classes.indexOf(c) === -1;
  }).filter(function (c) {
    return c !== '' || !!c;
  }).concat(extra.classes).join(' ');
  var content = {
    children: [],
    attributes: _objectSpread({}, extra.attributes, {
      'data-prefix': prefix,
      'data-icon': iconName,
      'class': attrClass,
      'role': extra.attributes.role || 'img',
      'xmlns': 'http://www.w3.org/2000/svg',
      'viewBox': "0 0 ".concat(width, " ").concat(height)
    })
  };
  var uploadedIconWidthStyle = isUploadedIcon && !~extra.classes.indexOf('fa-fw') ? {
    width: "".concat(width / height * 16 * 0.0625, "em")
  } : {};

  if (watchable) {
    content.attributes[DATA_FA_I2SVG] = '';
  }

  if (title) content.children.push({
    tag: 'title',
    attributes: {
      id: content.attributes['aria-labelledby'] || "title-".concat(titleId || nextUniqueId())
    },
    children: [title]
  });

  var args = _objectSpread({}, content, {
    prefix: prefix,
    iconName: iconName,
    main: main,
    mask: mask,
    maskId: maskId,
    transform: transform,
    symbol: symbol,
    styles: _objectSpread({}, uploadedIconWidthStyle, extra.styles)
  });

  var _ref2 = mask.found && main.found ? makeIconMasking(args) : makeIconStandard(args),
      children = _ref2.children,
      attributes = _ref2.attributes;

  args.children = children;
  args.attributes = attributes;

  if (symbol) {
    return asSymbol(args);
  } else {
    return asIcon(args);
  }
}
function makeLayersTextAbstract(params) {
  var content = params.content,
      width = params.width,
      height = params.height,
      transform = params.transform,
      title = params.title,
      extra = params.extra,
      _params$watchable2 = params.watchable,
      watchable = _params$watchable2 === void 0 ? false : _params$watchable2;

  var attributes = _objectSpread({}, extra.attributes, title ? {
    'title': title
  } : {}, {
    'class': extra.classes.join(' ')
  });

  if (watchable) {
    attributes[DATA_FA_I2SVG] = '';
  }

  var styles = _objectSpread({}, extra.styles);

  if (transformIsMeaningful(transform)) {
    styles['transform'] = transformForCss({
      transform: transform,
      startCentered: true,
      width: width,
      height: height
    });
    styles['-webkit-transform'] = styles['transform'];
  }

  var styleString = joinStyles(styles);

  if (styleString.length > 0) {
    attributes['style'] = styleString;
  }

  var val = [];
  val.push({
    tag: 'span',
    attributes: attributes,
    children: [content]
  });

  if (title) {
    val.push({
      tag: 'span',
      attributes: {
        class: 'sr-only'
      },
      children: [title]
    });
  }

  return val;
}
function makeLayersCounterAbstract(params) {
  var content = params.content,
      title = params.title,
      extra = params.extra;

  var attributes = _objectSpread({}, extra.attributes, title ? {
    'title': title
  } : {}, {
    'class': extra.classes.join(' ')
  });

  var styleString = joinStyles(extra.styles);

  if (styleString.length > 0) {
    attributes['style'] = styleString;
  }

  var val = [];
  val.push({
    tag: 'span',
    attributes: attributes,
    children: [content]
  });

  if (title) {
    val.push({
      tag: 'span',
      attributes: {
        class: 'sr-only'
      },
      children: [title]
    });
  }

  return val;
}

var noop$1 = function noop() {};

var p = config.measurePerformance && PERFORMANCE && PERFORMANCE.mark && PERFORMANCE.measure ? PERFORMANCE : {
  mark: noop$1,
  measure: noop$1
};
var preamble = "FA \"5.15.4\"";

var begin = function begin(name) {
  p.mark("".concat(preamble, " ").concat(name, " begins"));
  return function () {
    return end(name);
  };
};

var end = function end(name) {
  p.mark("".concat(preamble, " ").concat(name, " ends"));
  p.measure("".concat(preamble, " ").concat(name), "".concat(preamble, " ").concat(name, " begins"), "".concat(preamble, " ").concat(name, " ends"));
};

var perf = {
  begin: begin,
  end: end
};

/**
 * Internal helper to bind a function known to have 4 arguments
 * to a given context.
 */

var bindInternal4 = function bindInternal4(func, thisContext) {
  return function (a, b, c, d) {
    return func.call(thisContext, a, b, c, d);
  };
};

/**
 * # Reduce
 *
 * A fast object `.reduce()` implementation.
 *
 * @param  {Object}   subject      The object to reduce over.
 * @param  {Function} fn           The reducer function.
 * @param  {mixed}    initialValue The initial value for the reducer, defaults to subject[0].
 * @param  {Object}   thisContext  The context for the reducer.
 * @return {mixed}                 The final result.
 */


var reduce = function fastReduceObject(subject, fn, initialValue, thisContext) {
  var keys = Object.keys(subject),
      length = keys.length,
      iterator = thisContext !== undefined ? bindInternal4(fn, thisContext) : fn,
      i,
      key,
      result;

  if (initialValue === undefined) {
    i = 1;
    result = subject[keys[0]];
  } else {
    i = 0;
    result = initialValue;
  }

  for (; i < length; i++) {
    key = keys[i];
    result = iterator(result, subject[key], key, subject);
  }

  return result;
};

function toHex(unicode) {
  var result = '';

  for (var i = 0; i < unicode.length; i++) {
    var hex = unicode.charCodeAt(i).toString(16);
    result += ('000' + hex).slice(-4);
  }

  return result;
}

function defineIcons(prefix, icons) {
  var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var _params$skipHooks = params.skipHooks,
      skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
  var normalized = Object.keys(icons).reduce(function (acc, iconName) {
    var icon = icons[iconName];
    var expanded = !!icon.icon;

    if (expanded) {
      acc[icon.iconName] = icon.icon;
    } else {
      acc[iconName] = icon;
    }

    return acc;
  }, {});

  if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
    namespace.hooks.addPack(prefix, normalized);
  } else {
    namespace.styles[prefix] = _objectSpread({}, namespace.styles[prefix] || {}, normalized);
  }
  /**
   * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
   * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
   * for `fas` so we'll easy the upgrade process for our users by automatically defining
   * this as well.
   */


  if (prefix === 'fas') {
    defineIcons('fa', icons);
  }
}

var styles = namespace.styles,
    shims = namespace.shims;
var _byUnicode = {};
var _byLigature = {};
var _byOldName = {};
var build = function build() {
  var lookup = function lookup(reducer) {
    return reduce(styles, function (o, style, prefix) {
      o[prefix] = reduce(style, reducer, {});
      return o;
    }, {});
  };

  _byUnicode = lookup(function (acc, icon, iconName) {
    if (icon[3]) {
      acc[icon[3]] = iconName;
    }

    return acc;
  });
  _byLigature = lookup(function (acc, icon, iconName) {
    var ligatures = icon[2];
    acc[iconName] = iconName;
    ligatures.forEach(function (ligature) {
      acc[ligature] = iconName;
    });
    return acc;
  });
  var hasRegular = 'far' in styles;
  _byOldName = reduce(shims, function (acc, shim) {
    var oldName = shim[0];
    var prefix = shim[1];
    var iconName = shim[2];

    if (prefix === 'far' && !hasRegular) {
      prefix = 'fas';
    }

    acc[oldName] = {
      prefix: prefix,
      iconName: iconName
    };
    return acc;
  }, {});
};
build();
function byUnicode(prefix, unicode) {
  return (_byUnicode[prefix] || {})[unicode];
}
function byLigature(prefix, ligature) {
  return (_byLigature[prefix] || {})[ligature];
}
function byOldName(name) {
  return _byOldName[name] || {
    prefix: null,
    iconName: null
  };
}

var styles$1 = namespace.styles;
var emptyCanonicalIcon = function emptyCanonicalIcon() {
  return {
    prefix: null,
    iconName: null,
    rest: []
  };
};
function getCanonicalIcon(values) {
  return values.reduce(function (acc, cls) {
    var iconName = getIconName(config.familyPrefix, cls);

    if (styles$1[cls]) {
      acc.prefix = cls;
    } else if (config.autoFetchSvg && Object.keys(PREFIX_TO_STYLE).indexOf(cls) > -1) {
      acc.prefix = cls;
    } else if (iconName) {
      var shim = acc.prefix === 'fa' ? byOldName(iconName) : {};
      acc.iconName = shim.iconName || iconName;
      acc.prefix = shim.prefix || acc.prefix;
    } else if (cls !== config.replacementClass && cls.indexOf('fa-w-') !== 0) {
      acc.rest.push(cls);
    }

    return acc;
  }, emptyCanonicalIcon());
}
function iconFromMapping(mapping, prefix, iconName) {
  if (mapping && mapping[prefix] && mapping[prefix][iconName]) {
    return {
      prefix: prefix,
      iconName: iconName,
      icon: mapping[prefix][iconName]
    };
  }
}

function toHtml(abstractNodes) {
  var tag = abstractNodes.tag,
      _abstractNodes$attrib = abstractNodes.attributes,
      attributes = _abstractNodes$attrib === void 0 ? {} : _abstractNodes$attrib,
      _abstractNodes$childr = abstractNodes.children,
      children = _abstractNodes$childr === void 0 ? [] : _abstractNodes$childr;

  if (typeof abstractNodes === 'string') {
    return htmlEscape(abstractNodes);
  } else {
    return "<".concat(tag, " ").concat(joinAttributes(attributes), ">").concat(children.map(toHtml).join(''), "</").concat(tag, ">");
  }
}

var noop$2 = function noop() {};

function isWatched(node) {
  var i2svg = node.getAttribute ? node.getAttribute(DATA_FA_I2SVG) : null;
  return typeof i2svg === 'string';
}

function getMutator() {
  if (config.autoReplaceSvg === true) {
    return mutators.replace;
  }

  var mutator = mutators[config.autoReplaceSvg];
  return mutator || mutators.replace;
}

var mutators = {
  replace: function replace(mutation) {
    var node = mutation[0];
    var abstract = mutation[1];
    var newOuterHTML = abstract.map(function (a) {
      return toHtml(a);
    }).join('\n');

    if (node.parentNode && node.outerHTML) {
      node.outerHTML = newOuterHTML + (config.keepOriginalSource && node.tagName.toLowerCase() !== 'svg' ? "<!-- ".concat(node.outerHTML, " Font Awesome fontawesome.com -->") : '');
    } else if (node.parentNode) {
      var newNode = document.createElement('span');
      node.parentNode.replaceChild(newNode, node);
      newNode.outerHTML = newOuterHTML;
    }
  },
  nest: function nest(mutation) {
    var node = mutation[0];
    var abstract = mutation[1]; // If we already have a replaced node we do not want to continue nesting within it.
    // Short-circuit to the standard replacement

    if (~classArray(node).indexOf(config.replacementClass)) {
      return mutators.replace(mutation);
    }

    var forSvg = new RegExp("".concat(config.familyPrefix, "-.*"));
    delete abstract[0].attributes.style;
    delete abstract[0].attributes.id;
    var splitClasses = abstract[0].attributes.class.split(' ').reduce(function (acc, cls) {
      if (cls === config.replacementClass || cls.match(forSvg)) {
        acc.toSvg.push(cls);
      } else {
        acc.toNode.push(cls);
      }

      return acc;
    }, {
      toNode: [],
      toSvg: []
    });
    abstract[0].attributes.class = splitClasses.toSvg.join(' ');
    var newInnerHTML = abstract.map(function (a) {
      return toHtml(a);
    }).join('\n');
    node.setAttribute('class', splitClasses.toNode.join(' '));
    node.setAttribute(DATA_FA_I2SVG, '');
    node.innerHTML = newInnerHTML;
  }
};

function performOperationSync(op) {
  op();
}

function perform(mutations, callback) {
  var callbackFunction = typeof callback === 'function' ? callback : noop$2;

  if (mutations.length === 0) {
    callbackFunction();
  } else {
    var frame = performOperationSync;

    if (config.mutateApproach === MUTATION_APPROACH_ASYNC) {
      frame = WINDOW.requestAnimationFrame || performOperationSync;
    }

    frame(function () {
      var mutator = getMutator();
      var mark = perf.begin('mutate');
      mutations.map(mutator);
      mark();
      callbackFunction();
    });
  }
}
var disabled = false;
function disableObservation() {
  disabled = true;
}
function enableObservation() {
  disabled = false;
}
var mo = null;
function observe(options) {
  if (!MUTATION_OBSERVER) {
    return;
  }

  if (!config.observeMutations) {
    return;
  }

  var treeCallback = options.treeCallback,
      nodeCallback = options.nodeCallback,
      pseudoElementsCallback = options.pseudoElementsCallback,
      _options$observeMutat = options.observeMutationsRoot,
      observeMutationsRoot = _options$observeMutat === void 0 ? DOCUMENT : _options$observeMutat;
  mo = new MUTATION_OBSERVER(function (objects) {
    if (disabled) return;
    toArray(objects).forEach(function (mutationRecord) {
      if (mutationRecord.type === 'childList' && mutationRecord.addedNodes.length > 0 && !isWatched(mutationRecord.addedNodes[0])) {
        if (config.searchPseudoElements) {
          pseudoElementsCallback(mutationRecord.target);
        }

        treeCallback(mutationRecord.target);
      }

      if (mutationRecord.type === 'attributes' && mutationRecord.target.parentNode && config.searchPseudoElements) {
        pseudoElementsCallback(mutationRecord.target.parentNode);
      }

      if (mutationRecord.type === 'attributes' && isWatched(mutationRecord.target) && ~ATTRIBUTES_WATCHED_FOR_MUTATION.indexOf(mutationRecord.attributeName)) {
        if (mutationRecord.attributeName === 'class') {
          var _getCanonicalIcon = getCanonicalIcon(classArray(mutationRecord.target)),
              prefix = _getCanonicalIcon.prefix,
              iconName = _getCanonicalIcon.iconName;

          if (prefix) mutationRecord.target.setAttribute('data-prefix', prefix);
          if (iconName) mutationRecord.target.setAttribute('data-icon', iconName);
        } else {
          nodeCallback(mutationRecord.target);
        }
      }
    });
  });
  if (!IS_DOM) return;
  mo.observe(observeMutationsRoot, {
    childList: true,
    attributes: true,
    characterData: true,
    subtree: true
  });
}
function disconnect() {
  if (!mo) return;
  mo.disconnect();
}

function styleParser (node) {
  var style = node.getAttribute('style');
  var val = [];

  if (style) {
    val = style.split(';').reduce(function (acc, style) {
      var styles = style.split(':');
      var prop = styles[0];
      var value = styles.slice(1);

      if (prop && value.length > 0) {
        acc[prop] = value.join(':').trim();
      }

      return acc;
    }, {});
  }

  return val;
}

function classParser (node) {
  var existingPrefix = node.getAttribute('data-prefix');
  var existingIconName = node.getAttribute('data-icon');
  var innerText = node.innerText !== undefined ? node.innerText.trim() : '';
  var val = getCanonicalIcon(classArray(node));

  if (existingPrefix && existingIconName) {
    val.prefix = existingPrefix;
    val.iconName = existingIconName;
  }

  if (val.prefix && innerText.length > 1) {
    val.iconName = byLigature(val.prefix, node.innerText);
  } else if (val.prefix && innerText.length === 1) {
    val.iconName = byUnicode(val.prefix, toHex(node.innerText));
  }

  return val;
}

var parseTransformString = function parseTransformString(transformString) {
  var transform = {
    size: 16,
    x: 0,
    y: 0,
    flipX: false,
    flipY: false,
    rotate: 0
  };

  if (!transformString) {
    return transform;
  } else {
    return transformString.toLowerCase().split(' ').reduce(function (acc, n) {
      var parts = n.toLowerCase().split('-');
      var first = parts[0];
      var rest = parts.slice(1).join('-');

      if (first && rest === 'h') {
        acc.flipX = true;
        return acc;
      }

      if (first && rest === 'v') {
        acc.flipY = true;
        return acc;
      }

      rest = parseFloat(rest);

      if (isNaN(rest)) {
        return acc;
      }

      switch (first) {
        case 'grow':
          acc.size = acc.size + rest;
          break;

        case 'shrink':
          acc.size = acc.size - rest;
          break;

        case 'left':
          acc.x = acc.x - rest;
          break;

        case 'right':
          acc.x = acc.x + rest;
          break;

        case 'up':
          acc.y = acc.y - rest;
          break;

        case 'down':
          acc.y = acc.y + rest;
          break;

        case 'rotate':
          acc.rotate = acc.rotate + rest;
          break;
      }

      return acc;
    }, transform);
  }
};
function transformParser (node) {
  return parseTransformString(node.getAttribute('data-fa-transform'));
}

function symbolParser (node) {
  var symbol = node.getAttribute('data-fa-symbol');
  return symbol === null ? false : symbol === '' ? true : symbol;
}

function attributesParser (node) {
  var extraAttributes = toArray(node.attributes).reduce(function (acc, attr) {
    if (acc.name !== 'class' && acc.name !== 'style') {
      acc[attr.name] = attr.value;
    }

    return acc;
  }, {});
  var title = node.getAttribute('title');
  var titleId = node.getAttribute('data-fa-title-id');

  if (config.autoA11y) {
    if (title) {
      extraAttributes['aria-labelledby'] = "".concat(config.replacementClass, "-title-").concat(titleId || nextUniqueId());
    } else {
      extraAttributes['aria-hidden'] = 'true';
      extraAttributes['focusable'] = 'false';
    }
  }

  return extraAttributes;
}

function maskParser (node) {
  var mask = node.getAttribute('data-fa-mask');

  if (!mask) {
    return emptyCanonicalIcon();
  } else {
    return getCanonicalIcon(mask.split(' ').map(function (i) {
      return i.trim();
    }));
  }
}

function blankMeta() {
  return {
    iconName: null,
    title: null,
    titleId: null,
    prefix: null,
    transform: meaninglessTransform,
    symbol: false,
    mask: null,
    maskId: null,
    extra: {
      classes: [],
      styles: {},
      attributes: {}
    }
  };
}
function parseMeta(node) {
  var _classParser = classParser(node),
      iconName = _classParser.iconName,
      prefix = _classParser.prefix,
      extraClasses = _classParser.rest;

  var extraStyles = styleParser(node);
  var transform = transformParser(node);
  var symbol = symbolParser(node);
  var extraAttributes = attributesParser(node);
  var mask = maskParser(node);
  return {
    iconName: iconName,
    title: node.getAttribute('title'),
    titleId: node.getAttribute('data-fa-title-id'),
    prefix: prefix,
    transform: transform,
    symbol: symbol,
    mask: mask,
    maskId: node.getAttribute('data-fa-mask-id'),
    extra: {
      classes: extraClasses,
      styles: extraStyles,
      attributes: extraAttributes
    }
  };
}

function MissingIcon(error) {
  this.name = 'MissingIcon';
  this.message = error || 'Icon unavailable';
  this.stack = new Error().stack;
}
MissingIcon.prototype = Object.create(Error.prototype);
MissingIcon.prototype.constructor = MissingIcon;

var FILL = {
  fill: 'currentColor'
};
var ANIMATION_BASE = {
  attributeType: 'XML',
  repeatCount: 'indefinite',
  dur: '2s'
};
var RING = {
  tag: 'path',
  attributes: _objectSpread({}, FILL, {
    d: 'M156.5,447.7l-12.6,29.5c-18.7-9.5-35.9-21.2-51.5-34.9l22.7-22.7C127.6,430.5,141.5,440,156.5,447.7z M40.6,272H8.5 c1.4,21.2,5.4,41.7,11.7,61.1L50,321.2C45.1,305.5,41.8,289,40.6,272z M40.6,240c1.4-18.8,5.2-37,11.1-54.1l-29.5-12.6 C14.7,194.3,10,216.7,8.5,240H40.6z M64.3,156.5c7.8-14.9,17.2-28.8,28.1-41.5L69.7,92.3c-13.7,15.6-25.5,32.8-34.9,51.5 L64.3,156.5z M397,419.6c-13.9,12-29.4,22.3-46.1,30.4l11.9,29.8c20.7-9.9,39.8-22.6,56.9-37.6L397,419.6z M115,92.4 c13.9-12,29.4-22.3,46.1-30.4l-11.9-29.8c-20.7,9.9-39.8,22.6-56.8,37.6L115,92.4z M447.7,355.5c-7.8,14.9-17.2,28.8-28.1,41.5 l22.7,22.7c13.7-15.6,25.5-32.9,34.9-51.5L447.7,355.5z M471.4,272c-1.4,18.8-5.2,37-11.1,54.1l29.5,12.6 c7.5-21.1,12.2-43.5,13.6-66.8H471.4z M321.2,462c-15.7,5-32.2,8.2-49.2,9.4v32.1c21.2-1.4,41.7-5.4,61.1-11.7L321.2,462z M240,471.4c-18.8-1.4-37-5.2-54.1-11.1l-12.6,29.5c21.1,7.5,43.5,12.2,66.8,13.6V471.4z M462,190.8c5,15.7,8.2,32.2,9.4,49.2h32.1 c-1.4-21.2-5.4-41.7-11.7-61.1L462,190.8z M92.4,397c-12-13.9-22.3-29.4-30.4-46.1l-29.8,11.9c9.9,20.7,22.6,39.8,37.6,56.9 L92.4,397z M272,40.6c18.8,1.4,36.9,5.2,54.1,11.1l12.6-29.5C317.7,14.7,295.3,10,272,8.5V40.6z M190.8,50 c15.7-5,32.2-8.2,49.2-9.4V8.5c-21.2,1.4-41.7,5.4-61.1,11.7L190.8,50z M442.3,92.3L419.6,115c12,13.9,22.3,29.4,30.5,46.1 l29.8-11.9C470,128.5,457.3,109.4,442.3,92.3z M397,92.4l22.7-22.7c-15.6-13.7-32.8-25.5-51.5-34.9l-12.6,29.5 C370.4,72.1,384.4,81.5,397,92.4z'
  })
};

var OPACITY_ANIMATE = _objectSpread({}, ANIMATION_BASE, {
  attributeName: 'opacity'
});

var DOT = {
  tag: 'circle',
  attributes: _objectSpread({}, FILL, {
    cx: '256',
    cy: '364',
    r: '28'
  }),
  children: [{
    tag: 'animate',
    attributes: _objectSpread({}, ANIMATION_BASE, {
      attributeName: 'r',
      values: '28;14;28;28;14;28;'
    })
  }, {
    tag: 'animate',
    attributes: _objectSpread({}, OPACITY_ANIMATE, {
      values: '1;0;1;1;0;1;'
    })
  }]
};
var QUESTION = {
  tag: 'path',
  attributes: _objectSpread({}, FILL, {
    opacity: '1',
    d: 'M263.7,312h-16c-6.6,0-12-5.4-12-12c0-71,77.4-63.9,77.4-107.8c0-20-17.8-40.2-57.4-40.2c-29.1,0-44.3,9.6-59.2,28.7 c-3.9,5-11.1,6-16.2,2.4l-13.1-9.2c-5.6-3.9-6.9-11.8-2.6-17.2c21.2-27.2,46.4-44.7,91.2-44.7c52.3,0,97.4,29.8,97.4,80.2 c0,67.6-77.4,63.5-77.4,107.8C275.7,306.6,270.3,312,263.7,312z'
  }),
  children: [{
    tag: 'animate',
    attributes: _objectSpread({}, OPACITY_ANIMATE, {
      values: '1;0;0;0;0;1;'
    })
  }]
};
var EXCLAMATION = {
  tag: 'path',
  attributes: _objectSpread({}, FILL, {
    opacity: '0',
    d: 'M232.5,134.5l7,168c0.3,6.4,5.6,11.5,12,11.5h9c6.4,0,11.7-5.1,12-11.5l7-168c0.3-6.8-5.2-12.5-12-12.5h-23 C237.7,122,232.2,127.7,232.5,134.5z'
  }),
  children: [{
    tag: 'animate',
    attributes: _objectSpread({}, OPACITY_ANIMATE, {
      values: '0;0;1;1;0;0;'
    })
  }]
};
var missing = {
  tag: 'g',
  children: [RING, DOT, QUESTION, EXCLAMATION]
};

var styles$2 = namespace.styles;
function asFoundIcon(icon) {
  var width = icon[0];
  var height = icon[1];

  var _icon$slice = icon.slice(4),
      _icon$slice2 = _slicedToArray(_icon$slice, 1),
      vectorData = _icon$slice2[0];

  var element = null;

  if (Array.isArray(vectorData)) {
    element = {
      tag: 'g',
      attributes: {
        class: "".concat(config.familyPrefix, "-").concat(DUOTONE_CLASSES.GROUP)
      },
      children: [{
        tag: 'path',
        attributes: {
          class: "".concat(config.familyPrefix, "-").concat(DUOTONE_CLASSES.SECONDARY),
          fill: 'currentColor',
          d: vectorData[0]
        }
      }, {
        tag: 'path',
        attributes: {
          class: "".concat(config.familyPrefix, "-").concat(DUOTONE_CLASSES.PRIMARY),
          fill: 'currentColor',
          d: vectorData[1]
        }
      }]
    };
  } else {
    element = {
      tag: 'path',
      attributes: {
        fill: 'currentColor',
        d: vectorData
      }
    };
  }

  return {
    found: true,
    width: width,
    height: height,
    icon: element
  };
}
function findIcon(iconName, prefix) {
  return new picked(function (resolve, reject) {
    var val = {
      found: false,
      width: 512,
      height: 512,
      icon: missing
    };

    if (iconName && prefix && styles$2[prefix] && styles$2[prefix][iconName]) {
      var icon = styles$2[prefix][iconName];
      return resolve(asFoundIcon(icon));
    }

    if (iconName && prefix && !config.showMissingIcons) {
      reject(new MissingIcon("Icon is missing for prefix ".concat(prefix, " with icon name ").concat(iconName)));
    } else {
      resolve(val);
    }
  });
}

var styles$3 = namespace.styles;

function generateSvgReplacementMutation(node, nodeMeta) {
  var iconName = nodeMeta.iconName,
      title = nodeMeta.title,
      titleId = nodeMeta.titleId,
      prefix = nodeMeta.prefix,
      transform = nodeMeta.transform,
      symbol = nodeMeta.symbol,
      mask = nodeMeta.mask,
      maskId = nodeMeta.maskId,
      extra = nodeMeta.extra;
  return new picked(function (resolve, reject) {
    picked.all([findIcon(iconName, prefix), findIcon(mask.iconName, mask.prefix)]).then(function (_ref) {
      var _ref2 = _slicedToArray(_ref, 2),
          main = _ref2[0],
          mask = _ref2[1];

      resolve([node, makeInlineSvgAbstract({
        icons: {
          main: main,
          mask: mask
        },
        prefix: prefix,
        iconName: iconName,
        transform: transform,
        symbol: symbol,
        mask: mask,
        maskId: maskId,
        title: title,
        titleId: titleId,
        extra: extra,
        watchable: true
      })]);
    });
  });
}

function generateLayersText(node, nodeMeta) {
  var title = nodeMeta.title,
      transform = nodeMeta.transform,
      extra = nodeMeta.extra;
  var width = null;
  var height = null;

  if (IS_IE) {
    var computedFontSize = parseInt(getComputedStyle(node).fontSize, 10);
    var boundingClientRect = node.getBoundingClientRect();
    width = boundingClientRect.width / computedFontSize;
    height = boundingClientRect.height / computedFontSize;
  }

  if (config.autoA11y && !title) {
    extra.attributes['aria-hidden'] = 'true';
  }

  return picked.resolve([node, makeLayersTextAbstract({
    content: node.innerHTML,
    width: width,
    height: height,
    transform: transform,
    title: title,
    extra: extra,
    watchable: true
  })]);
}

function generateMutation(node) {
  var nodeMeta = parseMeta(node);

  if (~nodeMeta.extra.classes.indexOf(LAYERS_TEXT_CLASSNAME)) {
    return generateLayersText(node, nodeMeta);
  } else {
    return generateSvgReplacementMutation(node, nodeMeta);
  }
}

function onTree(root) {
  var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  if (!IS_DOM) return;
  var htmlClassList = DOCUMENT.documentElement.classList;

  var hclAdd = function hclAdd(suffix) {
    return htmlClassList.add("".concat(HTML_CLASS_I2SVG_BASE_CLASS, "-").concat(suffix));
  };

  var hclRemove = function hclRemove(suffix) {
    return htmlClassList.remove("".concat(HTML_CLASS_I2SVG_BASE_CLASS, "-").concat(suffix));
  };

  var prefixes = config.autoFetchSvg ? Object.keys(PREFIX_TO_STYLE) : Object.keys(styles$3);
  var prefixesDomQuery = [".".concat(LAYERS_TEXT_CLASSNAME, ":not([").concat(DATA_FA_I2SVG, "])")].concat(prefixes.map(function (p) {
    return ".".concat(p, ":not([").concat(DATA_FA_I2SVG, "])");
  })).join(', ');

  if (prefixesDomQuery.length === 0) {
    return;
  }

  var candidates = [];

  try {
    candidates = toArray(root.querySelectorAll(prefixesDomQuery));
  } catch (e) {// noop
  }

  if (candidates.length > 0) {
    hclAdd('pending');
    hclRemove('complete');
  } else {
    return;
  }

  var mark = perf.begin('onTree');
  var mutations = candidates.reduce(function (acc, node) {
    try {
      var mutation = generateMutation(node);

      if (mutation) {
        acc.push(mutation);
      }
    } catch (e) {
      if (!PRODUCTION) {
        if (e instanceof MissingIcon) {
          console.error(e);
        }
      }
    }

    return acc;
  }, []);
  return new picked(function (resolve, reject) {
    picked.all(mutations).then(function (resolvedMutations) {
      perform(resolvedMutations, function () {
        hclAdd('active');
        hclAdd('complete');
        hclRemove('pending');
        if (typeof callback === 'function') callback();
        mark();
        resolve();
      });
    }).catch(function () {
      mark();
      reject();
    });
  });
}
function onNode(node) {
  var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  generateMutation(node).then(function (mutation) {
    if (mutation) {
      perform([mutation], callback);
    }
  });
}

function replaceForPosition(node, position) {
  var pendingAttribute = "".concat(DATA_FA_PSEUDO_ELEMENT_PENDING).concat(position.replace(':', '-'));
  return new picked(function (resolve, reject) {
    if (node.getAttribute(pendingAttribute) !== null) {
      // This node is already being processed
      return resolve();
    }

    var children = toArray(node.children);
    var alreadyProcessedPseudoElement = children.filter(function (c) {
      return c.getAttribute(DATA_FA_PSEUDO_ELEMENT) === position;
    })[0];
    var styles = WINDOW.getComputedStyle(node, position);
    var fontFamily = styles.getPropertyValue('font-family').match(FONT_FAMILY_PATTERN);
    var fontWeight = styles.getPropertyValue('font-weight');
    var content = styles.getPropertyValue('content');

    if (alreadyProcessedPseudoElement && !fontFamily) {
      // If we've already processed it but the current computed style does not result in a font-family,
      // that probably means that a class name that was previously present to make the icon has been
      // removed. So we now should delete the icon.
      node.removeChild(alreadyProcessedPseudoElement);
      return resolve();
    } else if (fontFamily && content !== 'none' && content !== '') {
      var _content = styles.getPropertyValue('content');

      var prefix = ~['Solid', 'Regular', 'Light', 'Duotone', 'Brands', 'Kit'].indexOf(fontFamily[2]) ? STYLE_TO_PREFIX[fontFamily[2].toLowerCase()] : FONT_WEIGHT_TO_PREFIX[fontWeight];
      var hexValue = toHex(_content.length === 3 ? _content.substr(1, 1) : _content);
      var iconName = byUnicode(prefix, hexValue);
      var iconIdentifier = iconName; // Only convert the pseudo element in this :before/:after position into an icon if we haven't
      // already done so with the same prefix and iconName

      if (iconName && (!alreadyProcessedPseudoElement || alreadyProcessedPseudoElement.getAttribute(DATA_PREFIX) !== prefix || alreadyProcessedPseudoElement.getAttribute(DATA_ICON) !== iconIdentifier)) {
        node.setAttribute(pendingAttribute, iconIdentifier);

        if (alreadyProcessedPseudoElement) {
          // Delete the old one, since we're replacing it with a new one
          node.removeChild(alreadyProcessedPseudoElement);
        }

        var meta = blankMeta();
        var extra = meta.extra;
        extra.attributes[DATA_FA_PSEUDO_ELEMENT] = position;
        findIcon(iconName, prefix).then(function (main) {
          var abstract = makeInlineSvgAbstract(_objectSpread({}, meta, {
            icons: {
              main: main,
              mask: emptyCanonicalIcon()
            },
            prefix: prefix,
            iconName: iconIdentifier,
            extra: extra,
            watchable: true
          }));
          var element = DOCUMENT.createElement('svg');

          if (position === ':before') {
            node.insertBefore(element, node.firstChild);
          } else {
            node.appendChild(element);
          }

          element.outerHTML = abstract.map(function (a) {
            return toHtml(a);
          }).join('\n');
          node.removeAttribute(pendingAttribute);
          resolve();
        }).catch(reject);
      } else {
        resolve();
      }
    } else {
      resolve();
    }
  });
}

function replace(node) {
  return picked.all([replaceForPosition(node, ':before'), replaceForPosition(node, ':after')]);
}

function processable(node) {
  return node.parentNode !== document.head && !~TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS.indexOf(node.tagName.toUpperCase()) && !node.getAttribute(DATA_FA_PSEUDO_ELEMENT) && (!node.parentNode || node.parentNode.tagName !== 'svg');
}

function searchPseudoElements (root) {
  if (!IS_DOM) return;
  return new picked(function (resolve, reject) {
    var operations = toArray(root.querySelectorAll('*')).filter(processable).map(replace);
    var end = perf.begin('searchPseudoElements');
    disableObservation();
    picked.all(operations).then(function () {
      end();
      enableObservation();
      resolve();
    }).catch(function () {
      end();
      enableObservation();
      reject();
    });
  });
}

var baseStyles = "svg:not(:root).svg-inline--fa {\n  overflow: visible;\n}\n\n.svg-inline--fa {\n  display: inline-block;\n  font-size: inherit;\n  height: 1em;\n  overflow: visible;\n  vertical-align: -0.125em;\n}\n.svg-inline--fa.fa-lg {\n  vertical-align: -0.225em;\n}\n.svg-inline--fa.fa-w-1 {\n  width: 0.0625em;\n}\n.svg-inline--fa.fa-w-2 {\n  width: 0.125em;\n}\n.svg-inline--fa.fa-w-3 {\n  width: 0.1875em;\n}\n.svg-inline--fa.fa-w-4 {\n  width: 0.25em;\n}\n.svg-inline--fa.fa-w-5 {\n  width: 0.3125em;\n}\n.svg-inline--fa.fa-w-6 {\n  width: 0.375em;\n}\n.svg-inline--fa.fa-w-7 {\n  width: 0.4375em;\n}\n.svg-inline--fa.fa-w-8 {\n  width: 0.5em;\n}\n.svg-inline--fa.fa-w-9 {\n  width: 0.5625em;\n}\n.svg-inline--fa.fa-w-10 {\n  width: 0.625em;\n}\n.svg-inline--fa.fa-w-11 {\n  width: 0.6875em;\n}\n.svg-inline--fa.fa-w-12 {\n  width: 0.75em;\n}\n.svg-inline--fa.fa-w-13 {\n  width: 0.8125em;\n}\n.svg-inline--fa.fa-w-14 {\n  width: 0.875em;\n}\n.svg-inline--fa.fa-w-15 {\n  width: 0.9375em;\n}\n.svg-inline--fa.fa-w-16 {\n  width: 1em;\n}\n.svg-inline--fa.fa-w-17 {\n  width: 1.0625em;\n}\n.svg-inline--fa.fa-w-18 {\n  width: 1.125em;\n}\n.svg-inline--fa.fa-w-19 {\n  width: 1.1875em;\n}\n.svg-inline--fa.fa-w-20 {\n  width: 1.25em;\n}\n.svg-inline--fa.fa-pull-left {\n  margin-right: 0.3em;\n  width: auto;\n}\n.svg-inline--fa.fa-pull-right {\n  margin-left: 0.3em;\n  width: auto;\n}\n.svg-inline--fa.fa-border {\n  height: 1.5em;\n}\n.svg-inline--fa.fa-li {\n  width: 2em;\n}\n.svg-inline--fa.fa-fw {\n  width: 1.25em;\n}\n\n.fa-layers svg.svg-inline--fa {\n  bottom: 0;\n  left: 0;\n  margin: auto;\n  position: absolute;\n  right: 0;\n  top: 0;\n}\n\n.fa-layers {\n  display: inline-block;\n  height: 1em;\n  position: relative;\n  text-align: center;\n  vertical-align: -0.125em;\n  width: 1em;\n}\n.fa-layers svg.svg-inline--fa {\n  -webkit-transform-origin: center center;\n          transform-origin: center center;\n}\n\n.fa-layers-counter, .fa-layers-text {\n  display: inline-block;\n  position: absolute;\n  text-align: center;\n}\n\n.fa-layers-text {\n  left: 50%;\n  top: 50%;\n  -webkit-transform: translate(-50%, -50%);\n          transform: translate(-50%, -50%);\n  -webkit-transform-origin: center center;\n          transform-origin: center center;\n}\n\n.fa-layers-counter {\n  background-color: #ff253a;\n  border-radius: 1em;\n  -webkit-box-sizing: border-box;\n          box-sizing: border-box;\n  color: #fff;\n  height: 1.5em;\n  line-height: 1;\n  max-width: 5em;\n  min-width: 1.5em;\n  overflow: hidden;\n  padding: 0.25em;\n  right: 0;\n  text-overflow: ellipsis;\n  top: 0;\n  -webkit-transform: scale(0.25);\n          transform: scale(0.25);\n  -webkit-transform-origin: top right;\n          transform-origin: top right;\n}\n\n.fa-layers-bottom-right {\n  bottom: 0;\n  right: 0;\n  top: auto;\n  -webkit-transform: scale(0.25);\n          transform: scale(0.25);\n  -webkit-transform-origin: bottom right;\n          transform-origin: bottom right;\n}\n\n.fa-layers-bottom-left {\n  bottom: 0;\n  left: 0;\n  right: auto;\n  top: auto;\n  -webkit-transform: scale(0.25);\n          transform: scale(0.25);\n  -webkit-transform-origin: bottom left;\n          transform-origin: bottom left;\n}\n\n.fa-layers-top-right {\n  right: 0;\n  top: 0;\n  -webkit-transform: scale(0.25);\n          transform: scale(0.25);\n  -webkit-transform-origin: top right;\n          transform-origin: top right;\n}\n\n.fa-layers-top-left {\n  left: 0;\n  right: auto;\n  top: 0;\n  -webkit-transform: scale(0.25);\n          transform: scale(0.25);\n  -webkit-transform-origin: top left;\n          transform-origin: top left;\n}\n\n.fa-lg {\n  font-size: 1.3333333333em;\n  line-height: 0.75em;\n  vertical-align: -0.0667em;\n}\n\n.fa-xs {\n  font-size: 0.75em;\n}\n\n.fa-sm {\n  font-size: 0.875em;\n}\n\n.fa-1x {\n  font-size: 1em;\n}\n\n.fa-2x {\n  font-size: 2em;\n}\n\n.fa-3x {\n  font-size: 3em;\n}\n\n.fa-4x {\n  font-size: 4em;\n}\n\n.fa-5x {\n  font-size: 5em;\n}\n\n.fa-6x {\n  font-size: 6em;\n}\n\n.fa-7x {\n  font-size: 7em;\n}\n\n.fa-8x {\n  font-size: 8em;\n}\n\n.fa-9x {\n  font-size: 9em;\n}\n\n.fa-10x {\n  font-size: 10em;\n}\n\n.fa-fw {\n  text-align: center;\n  width: 1.25em;\n}\n\n.fa-ul {\n  list-style-type: none;\n  margin-left: 2.5em;\n  padding-left: 0;\n}\n.fa-ul > li {\n  position: relative;\n}\n\n.fa-li {\n  left: -2em;\n  position: absolute;\n  text-align: center;\n  width: 2em;\n  line-height: inherit;\n}\n\n.fa-border {\n  border: solid 0.08em #eee;\n  border-radius: 0.1em;\n  padding: 0.2em 0.25em 0.15em;\n}\n\n.fa-pull-left {\n  float: left;\n}\n\n.fa-pull-right {\n  float: right;\n}\n\n.fa.fa-pull-left,\n.fas.fa-pull-left,\n.far.fa-pull-left,\n.fal.fa-pull-left,\n.fab.fa-pull-left {\n  margin-right: 0.3em;\n}\n.fa.fa-pull-right,\n.fas.fa-pull-right,\n.far.fa-pull-right,\n.fal.fa-pull-right,\n.fab.fa-pull-right {\n  margin-left: 0.3em;\n}\n\n.fa-spin {\n  -webkit-animation: fa-spin 2s infinite linear;\n          animation: fa-spin 2s infinite linear;\n}\n\n.fa-pulse {\n  -webkit-animation: fa-spin 1s infinite steps(8);\n          animation: fa-spin 1s infinite steps(8);\n}\n\n@-webkit-keyframes fa-spin {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg);\n  }\n}\n\n@keyframes fa-spin {\n  0% {\n    -webkit-transform: rotate(0deg);\n            transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n            transform: rotate(360deg);\n  }\n}\n.fa-rotate-90 {\n  -ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=1)\";\n  -webkit-transform: rotate(90deg);\n          transform: rotate(90deg);\n}\n\n.fa-rotate-180 {\n  -ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=2)\";\n  -webkit-transform: rotate(180deg);\n          transform: rotate(180deg);\n}\n\n.fa-rotate-270 {\n  -ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=3)\";\n  -webkit-transform: rotate(270deg);\n          transform: rotate(270deg);\n}\n\n.fa-flip-horizontal {\n  -ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=0, mirror=1)\";\n  -webkit-transform: scale(-1, 1);\n          transform: scale(-1, 1);\n}\n\n.fa-flip-vertical {\n  -ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)\";\n  -webkit-transform: scale(1, -1);\n          transform: scale(1, -1);\n}\n\n.fa-flip-both, .fa-flip-horizontal.fa-flip-vertical {\n  -ms-filter: \"progid:DXImageTransform.Microsoft.BasicImage(rotation=2, mirror=1)\";\n  -webkit-transform: scale(-1, -1);\n          transform: scale(-1, -1);\n}\n\n:root .fa-rotate-90,\n:root .fa-rotate-180,\n:root .fa-rotate-270,\n:root .fa-flip-horizontal,\n:root .fa-flip-vertical,\n:root .fa-flip-both {\n  -webkit-filter: none;\n          filter: none;\n}\n\n.fa-stack {\n  display: inline-block;\n  height: 2em;\n  position: relative;\n  width: 2.5em;\n}\n\n.fa-stack-1x,\n.fa-stack-2x {\n  bottom: 0;\n  left: 0;\n  margin: auto;\n  position: absolute;\n  right: 0;\n  top: 0;\n}\n\n.svg-inline--fa.fa-stack-1x {\n  height: 1em;\n  width: 1.25em;\n}\n.svg-inline--fa.fa-stack-2x {\n  height: 2em;\n  width: 2.5em;\n}\n\n.fa-inverse {\n  color: #fff;\n}\n\n.sr-only {\n  border: 0;\n  clip: rect(0, 0, 0, 0);\n  height: 1px;\n  margin: -1px;\n  overflow: hidden;\n  padding: 0;\n  position: absolute;\n  width: 1px;\n}\n\n.sr-only-focusable:active, .sr-only-focusable:focus {\n  clip: auto;\n  height: auto;\n  margin: 0;\n  overflow: visible;\n  position: static;\n  width: auto;\n}\n\n.svg-inline--fa .fa-primary {\n  fill: var(--fa-primary-color, currentColor);\n  opacity: 1;\n  opacity: var(--fa-primary-opacity, 1);\n}\n\n.svg-inline--fa .fa-secondary {\n  fill: var(--fa-secondary-color, currentColor);\n  opacity: 0.4;\n  opacity: var(--fa-secondary-opacity, 0.4);\n}\n\n.svg-inline--fa.fa-swap-opacity .fa-primary {\n  opacity: 0.4;\n  opacity: var(--fa-secondary-opacity, 0.4);\n}\n\n.svg-inline--fa.fa-swap-opacity .fa-secondary {\n  opacity: 1;\n  opacity: var(--fa-primary-opacity, 1);\n}\n\n.svg-inline--fa mask .fa-primary,\n.svg-inline--fa mask .fa-secondary {\n  fill: black;\n}\n\n.fad.fa-inverse {\n  color: #fff;\n}";

function css () {
  var dfp = DEFAULT_FAMILY_PREFIX;
  var drc = DEFAULT_REPLACEMENT_CLASS;
  var fp = config.familyPrefix;
  var rc = config.replacementClass;
  var s = baseStyles;

  if (fp !== dfp || rc !== drc) {
    var dPatt = new RegExp("\\.".concat(dfp, "\\-"), 'g');
    var customPropPatt = new RegExp("\\--".concat(dfp, "\\-"), 'g');
    var rPatt = new RegExp("\\.".concat(drc), 'g');
    s = s.replace(dPatt, ".".concat(fp, "-")).replace(customPropPatt, "--".concat(fp, "-")).replace(rPatt, ".".concat(rc));
  }

  return s;
}

var Library =
/*#__PURE__*/
function () {
  function Library() {
    _classCallCheck(this, Library);

    this.definitions = {};
  }

  _createClass(Library, [{
    key: "add",
    value: function add() {
      var _this = this;

      for (var _len = arguments.length, definitions = new Array(_len), _key = 0; _key < _len; _key++) {
        definitions[_key] = arguments[_key];
      }

      var additions = definitions.reduce(this._pullDefinitions, {});
      Object.keys(additions).forEach(function (key) {
        _this.definitions[key] = _objectSpread({}, _this.definitions[key] || {}, additions[key]);
        defineIcons(key, additions[key]);
        build();
      });
    }
  }, {
    key: "reset",
    value: function reset() {
      this.definitions = {};
    }
  }, {
    key: "_pullDefinitions",
    value: function _pullDefinitions(additions, definition) {
      var normalized = definition.prefix && definition.iconName && definition.icon ? {
        0: definition
      } : definition;
      Object.keys(normalized).map(function (key) {
        var _normalized$key = normalized[key],
            prefix = _normalized$key.prefix,
            iconName = _normalized$key.iconName,
            icon = _normalized$key.icon;
        if (!additions[prefix]) additions[prefix] = {};
        additions[prefix][iconName] = icon;
      });
      return additions;
    }
  }]);

  return Library;
}();

function ensureCss() {
  if (config.autoAddCss && !_cssInserted) {
    insertCss(css());

    _cssInserted = true;
  }
}

function apiObject(val, abstractCreator) {
  Object.defineProperty(val, 'abstract', {
    get: abstractCreator
  });
  Object.defineProperty(val, 'html', {
    get: function get() {
      return val.abstract.map(function (a) {
        return toHtml(a);
      });
    }
  });
  Object.defineProperty(val, 'node', {
    get: function get() {
      if (!IS_DOM) return;
      var container = DOCUMENT.createElement('div');
      container.innerHTML = val.html;
      return container.children;
    }
  });
  return val;
}

function findIconDefinition(iconLookup) {
  var _iconLookup$prefix = iconLookup.prefix,
      prefix = _iconLookup$prefix === void 0 ? 'fa' : _iconLookup$prefix,
      iconName = iconLookup.iconName;
  if (!iconName) return;
  return iconFromMapping(library.definitions, prefix, iconName) || iconFromMapping(namespace.styles, prefix, iconName);
}

function resolveIcons(next) {
  return function (maybeIconDefinition) {
    var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var iconDefinition = (maybeIconDefinition || {}).icon ? maybeIconDefinition : findIconDefinition(maybeIconDefinition || {});
    var mask = params.mask;

    if (mask) {
      mask = (mask || {}).icon ? mask : findIconDefinition(mask || {});
    }

    return next(iconDefinition, _objectSpread({}, params, {
      mask: mask
    }));
  };
}

var library = new Library();
var noAuto = function noAuto() {
  config.autoReplaceSvg = false;
  config.observeMutations = false;
  disconnect();
};
var _cssInserted = false;
var dom = {
  i2svg: function i2svg() {
    var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    if (IS_DOM) {
      ensureCss();
      var _params$node = params.node,
          node = _params$node === void 0 ? DOCUMENT : _params$node,
          _params$callback = params.callback,
          callback = _params$callback === void 0 ? function () {} : _params$callback;

      if (config.searchPseudoElements) {
        searchPseudoElements(node);
      }

      return onTree(node, callback);
    } else {
      return picked.reject('Operation requires a DOM of some kind.');
    }
  },
  css: css,
  insertCss: function insertCss$$1() {
    if (!_cssInserted) {
      insertCss(css());

      _cssInserted = true;
    }
  },
  watch: function watch() {
    var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var autoReplaceSvgRoot = params.autoReplaceSvgRoot,
        observeMutationsRoot = params.observeMutationsRoot;

    if (config.autoReplaceSvg === false) {
      config.autoReplaceSvg = true;
    }

    config.observeMutations = true;
    domready(function () {
      autoReplace({
        autoReplaceSvgRoot: autoReplaceSvgRoot
      });
      observe({
        treeCallback: onTree,
        nodeCallback: onNode,
        pseudoElementsCallback: searchPseudoElements,
        observeMutationsRoot: observeMutationsRoot
      });
    });
  }
};
var parse = {
  transform: function transform(transformString) {
    return parseTransformString(transformString);
  }
};
var icon = resolveIcons(function (iconDefinition) {
  var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _params$transform = params.transform,
      transform = _params$transform === void 0 ? meaninglessTransform : _params$transform,
      _params$symbol = params.symbol,
      symbol = _params$symbol === void 0 ? false : _params$symbol,
      _params$mask = params.mask,
      mask = _params$mask === void 0 ? null : _params$mask,
      _params$maskId = params.maskId,
      maskId = _params$maskId === void 0 ? null : _params$maskId,
      _params$title = params.title,
      title = _params$title === void 0 ? null : _params$title,
      _params$titleId = params.titleId,
      titleId = _params$titleId === void 0 ? null : _params$titleId,
      _params$classes = params.classes,
      classes = _params$classes === void 0 ? [] : _params$classes,
      _params$attributes = params.attributes,
      attributes = _params$attributes === void 0 ? {} : _params$attributes,
      _params$styles = params.styles,
      styles = _params$styles === void 0 ? {} : _params$styles;
  if (!iconDefinition) return;
  var prefix = iconDefinition.prefix,
      iconName = iconDefinition.iconName,
      icon = iconDefinition.icon;
  return apiObject(_objectSpread({
    type: 'icon'
  }, iconDefinition), function () {
    ensureCss();

    if (config.autoA11y) {
      if (title) {
        attributes['aria-labelledby'] = "".concat(config.replacementClass, "-title-").concat(titleId || nextUniqueId());
      } else {
        attributes['aria-hidden'] = 'true';
        attributes['focusable'] = 'false';
      }
    }

    return makeInlineSvgAbstract({
      icons: {
        main: asFoundIcon(icon),
        mask: mask ? asFoundIcon(mask.icon) : {
          found: false,
          width: null,
          height: null,
          icon: {}
        }
      },
      prefix: prefix,
      iconName: iconName,
      transform: _objectSpread({}, meaninglessTransform, transform),
      symbol: symbol,
      title: title,
      maskId: maskId,
      titleId: titleId,
      extra: {
        attributes: attributes,
        styles: styles,
        classes: classes
      }
    });
  });
});
var text = function text(content) {
  var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _params$transform2 = params.transform,
      transform = _params$transform2 === void 0 ? meaninglessTransform : _params$transform2,
      _params$title2 = params.title,
      title = _params$title2 === void 0 ? null : _params$title2,
      _params$classes2 = params.classes,
      classes = _params$classes2 === void 0 ? [] : _params$classes2,
      _params$attributes2 = params.attributes,
      attributes = _params$attributes2 === void 0 ? {} : _params$attributes2,
      _params$styles2 = params.styles,
      styles = _params$styles2 === void 0 ? {} : _params$styles2;
  return apiObject({
    type: 'text',
    content: content
  }, function () {
    ensureCss();
    return makeLayersTextAbstract({
      content: content,
      transform: _objectSpread({}, meaninglessTransform, transform),
      title: title,
      extra: {
        attributes: attributes,
        styles: styles,
        classes: ["".concat(config.familyPrefix, "-layers-text")].concat(_toConsumableArray(classes))
      }
    });
  });
};
var counter = function counter(content) {
  var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _params$title3 = params.title,
      title = _params$title3 === void 0 ? null : _params$title3,
      _params$classes3 = params.classes,
      classes = _params$classes3 === void 0 ? [] : _params$classes3,
      _params$attributes3 = params.attributes,
      attributes = _params$attributes3 === void 0 ? {} : _params$attributes3,
      _params$styles3 = params.styles,
      styles = _params$styles3 === void 0 ? {} : _params$styles3;
  return apiObject({
    type: 'counter',
    content: content
  }, function () {
    ensureCss();
    return makeLayersCounterAbstract({
      content: content.toString(),
      title: title,
      extra: {
        attributes: attributes,
        styles: styles,
        classes: ["".concat(config.familyPrefix, "-layers-counter")].concat(_toConsumableArray(classes))
      }
    });
  });
};
var layer = function layer(assembler) {
  var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _params$classes4 = params.classes,
      classes = _params$classes4 === void 0 ? [] : _params$classes4;
  return apiObject({
    type: 'layer'
  }, function () {
    ensureCss();
    var children = [];
    assembler(function (args) {
      Array.isArray(args) ? args.map(function (a) {
        children = children.concat(a.abstract);
      }) : children = children.concat(args.abstract);
    });
    return [{
      tag: 'span',
      attributes: {
        class: ["".concat(config.familyPrefix, "-layers")].concat(_toConsumableArray(classes)).join(' ')
      },
      children: children
    }];
  });
};
var api = {
  noAuto: noAuto,
  config: config,
  dom: dom,
  library: library,
  parse: parse,
  findIconDefinition: findIconDefinition,
  icon: icon,
  text: text,
  counter: counter,
  layer: layer,
  toHtml: toHtml
};

var autoReplace = function autoReplace() {
  var params = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var _params$autoReplaceSv = params.autoReplaceSvgRoot,
      autoReplaceSvgRoot = _params$autoReplaceSv === void 0 ? DOCUMENT : _params$autoReplaceSv;
  if ((Object.keys(namespace.styles).length > 0 || config.autoFetchSvg) && IS_DOM && config.autoReplaceSvg) api.dom.i2svg({
    node: autoReplaceSvgRoot
  });
};




/***/ }),

/***/ "../../node_modules/@fortawesome/free-solid-svg-icons/faBell.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@fortawesome/free-solid-svg-icons/faBell.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'bell';
var width = 448;
var height = 512;
var ligatures = [];
var unicode = 'f0f3';
var svgPathData = 'M224 512c35.32 0 63.97-28.65 63.97-64H160.03c0 35.35 28.65 64 63.97 64zm215.39-149.71c-19.32-20.76-55.47-51.99-55.47-154.29 0-77.7-54.48-139.9-127.94-155.16V32c0-17.67-14.32-32-31.98-32s-31.98 14.33-31.98 32v20.84C118.56 68.1 64.08 130.3 64.08 208c0 102.3-36.15 133.53-55.47 154.29-6 6.45-8.66 14.16-8.61 21.71.11 16.4 12.98 32 32.1 32h383.8c19.12 0 32-15.6 32.1-32 .05-7.55-2.61-15.27-8.61-21.71z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faBell = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../../node_modules/@fortawesome/free-solid-svg-icons/faCheck.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@fortawesome/free-solid-svg-icons/faCheck.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'check';
var width = 512;
var height = 512;
var ligatures = [];
var unicode = 'f00c';
var svgPathData = 'M173.898 439.404l-166.4-166.4c-9.997-9.997-9.997-26.206 0-36.204l36.203-36.204c9.997-9.998 26.207-9.998 36.204 0L192 312.69 432.095 72.596c9.997-9.997 26.207-9.997 36.204 0l36.203 36.204c9.997 9.997 9.997 26.206 0 36.204l-294.4 294.401c-9.998 9.997-26.207 9.997-36.204-.001z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faCheck = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../../node_modules/@fortawesome/free-solid-svg-icons/faExclamationCircle.js":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@fortawesome/free-solid-svg-icons/faExclamationCircle.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'exclamation-circle';
var width = 512;
var height = 512;
var ligatures = [];
var unicode = 'f06a';
var svgPathData = 'M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zm-248 50c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faExclamationCircle = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../../node_modules/@fortawesome/free-solid-svg-icons/faExclamationTriangle.js":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@fortawesome/free-solid-svg-icons/faExclamationTriangle.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'exclamation-triangle';
var width = 576;
var height = 512;
var ligatures = [];
var unicode = 'f071';
var svgPathData = 'M569.517 440.013C587.975 472.007 564.806 512 527.94 512H48.054c-36.937 0-59.999-40.055-41.577-71.987L246.423 23.985c18.467-32.009 64.72-31.951 83.154 0l239.94 416.028zM288 354c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faExclamationTriangle = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../../node_modules/@fortawesome/free-solid-svg-icons/faSpinner.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@fortawesome/free-solid-svg-icons/faSpinner.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, exports) => {

"use strict";

Object.defineProperty(exports, "__esModule", ({ value: true }));
var prefix = 'fas';
var iconName = 'spinner';
var width = 512;
var height = 512;
var ligatures = [];
var unicode = 'f110';
var svgPathData = 'M304 48c0 26.51-21.49 48-48 48s-48-21.49-48-48 21.49-48 48-48 48 21.49 48 48zm-48 368c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zm208-208c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.49-48-48-48zM96 256c0-26.51-21.49-48-48-48S0 229.49 0 256s21.49 48 48 48 48-21.49 48-48zm12.922 99.078c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48c0-26.509-21.491-48-48-48zm294.156 0c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48c0-26.509-21.49-48-48-48zM108.922 60.922c-26.51 0-48 21.49-48 48s21.49 48 48 48 48-21.49 48-48-21.491-48-48-48z';

exports.definition = {
  prefix: prefix,
  iconName: iconName,
  icon: [
    width,
    height,
    ligatures,
    unicode,
    svgPathData
  ]};

exports.faSpinner = exports.definition;
exports.prefix = prefix;
exports.iconName = iconName;
exports.width = width;
exports.height = height;
exports.ligatures = ligatures;
exports.unicode = unicode;
exports.svgPathData = svgPathData;

/***/ }),

/***/ "../../node_modules/@fortawesome/react-fontawesome/index.es.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@fortawesome/react-fontawesome/index.es.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FontAwesomeIcon: () => (/* binding */ FontAwesomeIcon)
/* harmony export */ });
/* harmony import */ var _fortawesome_fontawesome_svg_core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @fortawesome/fontawesome-svg-core */ "../../node_modules/@fortawesome/fontawesome-svg-core/index.es.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "../../node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);




function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);

  if (Object.getOwnPropertySymbols) {
    var symbols = Object.getOwnPropertySymbols(object);
    enumerableOnly && (symbols = symbols.filter(function (sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    })), keys.push.apply(keys, symbols);
  }

  return keys;
}

function _objectSpread2(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = null != arguments[i] ? arguments[i] : {};
    i % 2 ? ownKeys(Object(source), !0).forEach(function (key) {
      _defineProperty(target, key, source[key]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) {
      Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
    });
  }

  return target;
}

function _typeof(obj) {
  "@babel/helpers - typeof";

  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  }, _typeof(obj);
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};

  var target = _objectWithoutPropertiesLoose(source, excluded);

  var key, i;

  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }

  return target;
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread();
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) return _arrayLikeToArray(arr);
}

function _iterableToArray(iter) {
  if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter);
}

function _unsupportedIterableToArray(o, minLen) {
  if (!o) return;
  if (typeof o === "string") return _arrayLikeToArray(o, minLen);
  var n = Object.prototype.toString.call(o).slice(8, -1);
  if (n === "Object" && o.constructor) n = o.constructor.name;
  if (n === "Map" || n === "Set") return Array.from(o);
  if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
}

function _arrayLikeToArray(arr, len) {
  if (len == null || len > arr.length) len = arr.length;

  for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i];

  return arr2;
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}

// Get CSS class list from a props object
function classList(props) {
  var _classes;

  var beat = props.beat,
      fade = props.fade,
      beatFade = props.beatFade,
      bounce = props.bounce,
      shake = props.shake,
      flash = props.flash,
      spin = props.spin,
      spinPulse = props.spinPulse,
      spinReverse = props.spinReverse,
      pulse = props.pulse,
      fixedWidth = props.fixedWidth,
      inverse = props.inverse,
      border = props.border,
      listItem = props.listItem,
      flip = props.flip,
      size = props.size,
      rotation = props.rotation,
      pull = props.pull; // map of CSS class names to properties

  var classes = (_classes = {
    'fa-beat': beat,
    'fa-fade': fade,
    'fa-beat-fade': beatFade,
    'fa-bounce': bounce,
    'fa-shake': shake,
    'fa-flash': flash,
    'fa-spin': spin,
    'fa-spin-reverse': spinReverse,
    'fa-spin-pulse': spinPulse,
    'fa-pulse': pulse,
    'fa-fw': fixedWidth,
    'fa-inverse': inverse,
    'fa-border': border,
    'fa-li': listItem,
    'fa-flip': flip === true,
    'fa-flip-horizontal': flip === 'horizontal' || flip === 'both',
    'fa-flip-vertical': flip === 'vertical' || flip === 'both'
  }, _defineProperty(_classes, "fa-".concat(size), typeof size !== 'undefined' && size !== null), _defineProperty(_classes, "fa-rotate-".concat(rotation), typeof rotation !== 'undefined' && rotation !== null && rotation !== 0), _defineProperty(_classes, "fa-pull-".concat(pull), typeof pull !== 'undefined' && pull !== null), _defineProperty(_classes, 'fa-swap-opacity', props.swapOpacity), _classes); // map over all the keys in the classes object
  // return an array of the keys where the value for the key is not null

  return Object.keys(classes).map(function (key) {
    return classes[key] ? key : null;
  }).filter(function (key) {
    return key;
  });
}

// Camelize taken from humps
// humps is copyright © 2012+ Dom Christie
// Released under the MIT license.
// Performant way to determine if object coerces to a number
function _isNumerical(obj) {
  obj = obj - 0; // eslint-disable-next-line no-self-compare

  return obj === obj;
}

function camelize(string) {
  if (_isNumerical(string)) {
    return string;
  } // eslint-disable-next-line no-useless-escape


  string = string.replace(/[\-_\s]+(.)?/g, function (match, chr) {
    return chr ? chr.toUpperCase() : '';
  }); // Ensure 1st char is always lowercase

  return string.substr(0, 1).toLowerCase() + string.substr(1);
}

var _excluded$1 = ["style"];

function capitalize(val) {
  return val.charAt(0).toUpperCase() + val.slice(1);
}

function styleToObject(style) {
  return style.split(';').map(function (s) {
    return s.trim();
  }).filter(function (s) {
    return s;
  }).reduce(function (acc, pair) {
    var i = pair.indexOf(':');
    var prop = camelize(pair.slice(0, i));
    var value = pair.slice(i + 1).trim();
    prop.startsWith('webkit') ? acc[capitalize(prop)] = value : acc[prop] = value;
    return acc;
  }, {});
}

function convert(createElement, element) {
  var extraProps = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

  if (typeof element === 'string') {
    return element;
  }

  var children = (element.children || []).map(function (child) {
    return convert(createElement, child);
  });
  /* eslint-disable dot-notation */

  var mixins = Object.keys(element.attributes || {}).reduce(function (acc, key) {
    var val = element.attributes[key];

    switch (key) {
      case 'class':
        acc.attrs['className'] = val;
        delete element.attributes['class'];
        break;

      case 'style':
        acc.attrs['style'] = styleToObject(val);
        break;

      default:
        if (key.indexOf('aria-') === 0 || key.indexOf('data-') === 0) {
          acc.attrs[key.toLowerCase()] = val;
        } else {
          acc.attrs[camelize(key)] = val;
        }

    }

    return acc;
  }, {
    attrs: {}
  });

  var _extraProps$style = extraProps.style,
      existingStyle = _extraProps$style === void 0 ? {} : _extraProps$style,
      remaining = _objectWithoutProperties(extraProps, _excluded$1);

  mixins.attrs['style'] = _objectSpread2(_objectSpread2({}, mixins.attrs['style']), existingStyle);
  /* eslint-enable */

  return createElement.apply(void 0, [element.tag, _objectSpread2(_objectSpread2({}, mixins.attrs), remaining)].concat(_toConsumableArray(children)));
}

var PRODUCTION = false;

try {
  PRODUCTION = "development" === 'production';
} catch (e) {}

function log () {
  if (!PRODUCTION && console && typeof console.error === 'function') {
    var _console;

    (_console = console).error.apply(_console, arguments);
  }
}

function normalizeIconArgs(icon) {
  // this has everything that it needs to be rendered which means it was probably imported
  // directly from an icon svg package
  if (icon && _typeof(icon) === 'object' && icon.prefix && icon.iconName && icon.icon) {
    return icon;
  }

  if (_fortawesome_fontawesome_svg_core__WEBPACK_IMPORTED_MODULE_0__.parse.icon) {
    return _fortawesome_fontawesome_svg_core__WEBPACK_IMPORTED_MODULE_0__.parse.icon(icon);
  } // if the icon is null, there's nothing to do


  if (icon === null) {
    return null;
  } // if the icon is an object and has a prefix and an icon name, return it


  if (icon && _typeof(icon) === 'object' && icon.prefix && icon.iconName) {
    return icon;
  } // if it's an array with length of two


  if (Array.isArray(icon) && icon.length === 2) {
    // use the first item as prefix, second as icon name
    return {
      prefix: icon[0],
      iconName: icon[1]
    };
  } // if it's a string, use it as the icon name


  if (typeof icon === 'string') {
    return {
      prefix: 'fas',
      iconName: icon
    };
  }
}

// creates an object with a key of key
// and a value of value
// if certain conditions are met
function objectWithKey(key, value) {
  // if the value is a non-empty array
  // or it's not an array but it is truthy
  // then create the object with the key and the value
  // if not, return an empty array
  return Array.isArray(value) && value.length > 0 || !Array.isArray(value) && value ? _defineProperty({}, key, value) : {};
}

var _excluded = ["forwardedRef"];
function FontAwesomeIcon(_ref) {
  var forwardedRef = _ref.forwardedRef,
      props = _objectWithoutProperties(_ref, _excluded);

  var iconArgs = props.icon,
      maskArgs = props.mask,
      symbol = props.symbol,
      className = props.className,
      title = props.title,
      titleId = props.titleId,
      maskId = props.maskId;
  var iconLookup = normalizeIconArgs(iconArgs);
  var classes = objectWithKey('classes', [].concat(_toConsumableArray(classList(props)), _toConsumableArray(className.split(' '))));
  var transform = objectWithKey('transform', typeof props.transform === 'string' ? _fortawesome_fontawesome_svg_core__WEBPACK_IMPORTED_MODULE_0__.parse.transform(props.transform) : props.transform);
  var mask = objectWithKey('mask', normalizeIconArgs(maskArgs));
  var renderedIcon = (0,_fortawesome_fontawesome_svg_core__WEBPACK_IMPORTED_MODULE_0__.icon)(iconLookup, _objectSpread2(_objectSpread2(_objectSpread2(_objectSpread2({}, classes), transform), mask), {}, {
    symbol: symbol,
    title: title,
    titleId: titleId,
    maskId: maskId
  }));

  if (!renderedIcon) {
    log('Could not find icon', iconLookup);
    return null;
  }

  var abstract = renderedIcon.abstract;
  var extraProps = {
    ref: forwardedRef
  };
  Object.keys(props).forEach(function (key) {
    // eslint-disable-next-line no-prototype-builtins
    if (!FontAwesomeIcon.defaultProps.hasOwnProperty(key)) {
      extraProps[key] = props[key];
    }
  });
  return convertCurry(abstract[0], extraProps);
}
FontAwesomeIcon.displayName = 'FontAwesomeIcon';
FontAwesomeIcon.propTypes = {
  beat: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  border: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  beatFade: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  bounce: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  className: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  fade: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  flash: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  mask: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().array), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)]),
  maskId: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  fixedWidth: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  inverse: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  flip: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf([true, false, 'horizontal', 'vertical', 'both']),
  icon: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().object), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().array), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)]),
  listItem: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  pull: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['right', 'left']),
  pulse: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  rotation: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf([0, 90, 180, 270]),
  shake: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  size: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOf(['2xs', 'xs', 'sm', 'lg', 'xl', '2xl', '1x', '2x', '3x', '4x', '5x', '6x', '7x', '8x', '9x', '10x']),
  spin: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  spinPulse: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  spinReverse: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool),
  symbol: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)]),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  titleId: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  transform: prop_types__WEBPACK_IMPORTED_MODULE_1___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_1___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_1___default().object)]),
  swapOpacity: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().bool)
};
FontAwesomeIcon.defaultProps = {
  border: false,
  className: '',
  mask: null,
  maskId: null,
  fixedWidth: false,
  inverse: false,
  flip: false,
  icon: null,
  listItem: false,
  pull: null,
  pulse: false,
  rotation: null,
  size: null,
  spin: false,
  spinPulse: false,
  spinReverse: false,
  beat: false,
  fade: false,
  beatFade: false,
  bounce: false,
  shake: false,
  symbol: false,
  title: '',
  titleId: null,
  transform: null,
  swapOpacity: false
};
var convertCurry = convert.bind(null, (react__WEBPACK_IMPORTED_MODULE_2___default().createElement));




/***/ }),

/***/ "../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/cjs.js!../../node_modules/jupyterlab_toastify/style/index.css":
/*!*****************************************************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/cjs.js!../../node_modules/jupyterlab_toastify/style/index.css ***!
  \*****************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../@jupyterlab/builder/node_modules/css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../@jupyterlab/builder/node_modules/css-loader/dist/runtime/api.js */ "../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_cjs_js_react_toastify_dist_ReactToastify_min_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! -!../../@jupyterlab/builder/node_modules/css-loader/dist/cjs.js!../../react-toastify/dist/ReactToastify.min.css */ "../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/cjs.js!../../node_modules/react-toastify/dist/ReactToastify.min.css");
// Imports



var ___CSS_LOADER_EXPORT___ = _jupyterlab_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_jupyterlab_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
___CSS_LOADER_EXPORT___.i(_jupyterlab_builder_node_modules_css_loader_dist_cjs_js_react_toastify_dist_ReactToastify_min_css__WEBPACK_IMPORTED_MODULE_2__["default"]);
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.Toastify__toast {
  min-height: unset;
  font-size: var(--jp-ui-font-size1);
  font-family: var(--jp-ui-font-family);
  color: var(--jp-ui-font-color1);
  border-width: var(--jp-border-width);
  border-radius: var(--jp-border-radius);
  border-color: var(--jp-border-color1);
  background: var(--jp-layout-color1);
  box-shadow: var(--jp-elevation-z4);
  cursor: default;
}

.Toastify__toast-body > svg.svg-inline--fa {
  margin-top: 0.2em;
}

.Toastify__toast--error {
  border-top: 5px solid var(--jp-error-color1);
}

.Toastify__toast--warning {
  border-top: 5px solid var(--jp-warn-color1);
}

.Toastify__toast--info {
  border-top: 5px solid var(--jp-info-color1);
}

.Toastify__toast--success {
  border-top: 5px solid var(--jp-success-color1);
}

.Toastify__toast--default.jp-toast-in-progress {
  border-top: 5px solid var(--jp-layout-color1);
}

.jp-toast-buttonBar {
  display: flex;
  flex-direction: row;
  flex-wrap: nowrap;
  flex: 0 0 auto;
}

.jp-toast-spacer {
  flex-grow: 1;
  flex-shrink: 1;
}

.jp-toast-button {
  border: solid var(--jp-border-width) var(--jp-border-color2);
  font-size: var(--jp-ui-font-size0);
  margin-top: 1px;
  margin-bottom: 1px;
  margin-right: 0px;
  margin-left: 3px;
  color: var(--jp-ui-font-color1);
  background-color: var(--jp-layout-color2);
}

.jp-toast-button:hover {
  background-color: var(--jp-layout-color3);
}
`, "",{"version":3,"sources":["webpack://./../../node_modules/jupyterlab_toastify/style/index.css"],"names":[],"mappings":"AAEA;EACE,iBAAiB;EACjB,kCAAkC;EAClC,qCAAqC;EACrC,+BAA+B;EAC/B,oCAAoC;EACpC,sCAAsC;EACtC,qCAAqC;EACrC,mCAAmC;EACnC,kCAAkC;EAClC,eAAe;AACjB;;AAEA;EACE,iBAAiB;AACnB;;AAEA;EACE,4CAA4C;AAC9C;;AAEA;EACE,2CAA2C;AAC7C;;AAEA;EACE,2CAA2C;AAC7C;;AAEA;EACE,8CAA8C;AAChD;;AAEA;EACE,6CAA6C;AAC/C;;AAEA;EACE,aAAa;EACb,mBAAmB;EACnB,iBAAiB;EACjB,cAAc;AAChB;;AAEA;EACE,YAAY;EACZ,cAAc;AAChB;;AAEA;EACE,4DAA4D;EAC5D,kCAAkC;EAClC,eAAe;EACf,kBAAkB;EAClB,iBAAiB;EACjB,gBAAgB;EAChB,+BAA+B;EAC/B,yCAAyC;AAC3C;;AAEA;EACE,yCAAyC;AAC3C","sourcesContent":["@import \"~react-toastify/dist/ReactToastify.min.css\";\n\n.Toastify__toast {\n  min-height: unset;\n  font-size: var(--jp-ui-font-size1);\n  font-family: var(--jp-ui-font-family);\n  color: var(--jp-ui-font-color1);\n  border-width: var(--jp-border-width);\n  border-radius: var(--jp-border-radius);\n  border-color: var(--jp-border-color1);\n  background: var(--jp-layout-color1);\n  box-shadow: var(--jp-elevation-z4);\n  cursor: default;\n}\n\n.Toastify__toast-body > svg.svg-inline--fa {\n  margin-top: 0.2em;\n}\n\n.Toastify__toast--error {\n  border-top: 5px solid var(--jp-error-color1);\n}\n\n.Toastify__toast--warning {\n  border-top: 5px solid var(--jp-warn-color1);\n}\n\n.Toastify__toast--info {\n  border-top: 5px solid var(--jp-info-color1);\n}\n\n.Toastify__toast--success {\n  border-top: 5px solid var(--jp-success-color1);\n}\n\n.Toastify__toast--default.jp-toast-in-progress {\n  border-top: 5px solid var(--jp-layout-color1);\n}\n\n.jp-toast-buttonBar {\n  display: flex;\n  flex-direction: row;\n  flex-wrap: nowrap;\n  flex: 0 0 auto;\n}\n\n.jp-toast-spacer {\n  flex-grow: 1;\n  flex-shrink: 1;\n}\n\n.jp-toast-button {\n  border: solid var(--jp-border-width) var(--jp-border-color2);\n  font-size: var(--jp-ui-font-size0);\n  margin-top: 1px;\n  margin-bottom: 1px;\n  margin-right: 0px;\n  margin-left: 3px;\n  color: var(--jp-ui-font-color1);\n  background-color: var(--jp-layout-color2);\n}\n\n.jp-toast-button:hover {\n  background-color: var(--jp-layout-color3);\n}\n"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/cjs.js!../../node_modules/react-toastify/dist/ReactToastify.min.css":
/*!***********************************************************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/cjs.js!../../node_modules/react-toastify/dist/ReactToastify.min.css ***!
  \***********************************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../@jupyterlab/builder/node_modules/css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../@jupyterlab/builder/node_modules/css-loader/dist/runtime/api.js */ "../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _jupyterlab_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_jupyterlab_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.Toastify__toast-container{z-index:9999;-webkit-transform:translateZ(9999px);position:fixed;padding:4px;width:320px;box-sizing:border-box;color:#fff}.Toastify__toast-container--top-left{top:1em;left:1em}.Toastify__toast-container--top-center{top:1em;left:50%;transform:translateX(-50%)}.Toastify__toast-container--top-right{top:1em;right:1em}.Toastify__toast-container--bottom-left{bottom:1em;left:1em}.Toastify__toast-container--bottom-center{bottom:1em;left:50%;transform:translateX(-50%)}.Toastify__toast-container--bottom-right{bottom:1em;right:1em}@media only screen and (max-width:480px){.Toastify__toast-container{width:100vw;padding:0;left:0;margin:0}.Toastify__toast-container--top-center,.Toastify__toast-container--top-left,.Toastify__toast-container--top-right{top:0;transform:translateX(0)}.Toastify__toast-container--bottom-center,.Toastify__toast-container--bottom-left,.Toastify__toast-container--bottom-right{bottom:0;transform:translateX(0)}.Toastify__toast-container--rtl{right:0;left:auto}}.Toastify__toast{position:relative;min-height:64px;box-sizing:border-box;margin-bottom:1rem;padding:8px;border-radius:4px;box-shadow:0 1px 10px 0 rgba(0,0,0,.1),0 2px 15px 0 rgba(0,0,0,.05);display:-ms-flexbox;display:flex;-ms-flex-pack:justify;justify-content:space-between;max-height:800px;overflow:hidden;font-family:sans-serif;cursor:pointer;direction:ltr}.Toastify__toast--rtl{direction:rtl}.Toastify__toast--dark{background:#121212;color:#fff}.Toastify__toast--default{background:#fff;color:#aaa}.Toastify__toast--info{background:#3498db}.Toastify__toast--success{background:#07bc0c}.Toastify__toast--warning{background:#f1c40f}.Toastify__toast--error{background:#e74c3c}.Toastify__toast-body{margin:auto 0;-ms-flex:1 1 auto;flex:1 1 auto;padding:6px}.Toastify--animate{animation-fill-mode:both;animation-duration:.7s}@media only screen and (max-width:480px){.Toastify__toast{margin-bottom:0;border-radius:0}}.Toastify__close-button{color:#fff;background:transparent;outline:none;border:none;padding:0;cursor:pointer;opacity:.7;transition:.3s ease;-ms-flex-item-align:start;align-self:flex-start}.Toastify__close-button--default{color:#000;opacity:.3}.Toastify__close-button>svg{fill:currentColor;height:16px;width:14px}.Toastify__close-button:focus,.Toastify__close-button:hover{opacity:1}@keyframes Toastify__trackProgress{0%{transform:scaleX(1)}to{transform:scaleX(0)}}.Toastify__progress-bar{position:absolute;bottom:0;left:0;width:100%;height:5px;z-index:9999;opacity:.7;background-color:hsla(0,0%,100%,.7);transform-origin:left}.Toastify__progress-bar--animated{animation:Toastify__trackProgress linear 1 forwards}.Toastify__progress-bar--controlled{transition:transform .2s}.Toastify__progress-bar--rtl{right:0;left:auto;transform-origin:right}.Toastify__progress-bar--default{background:linear-gradient(90deg,#4cd964,#5ac8fa,#007aff,#34aadc,#5856d6,#ff2d55)}.Toastify__progress-bar--dark{background:#bb86fc}@keyframes Toastify__bounceInRight{0%,60%,75%,90%,to{animation-timing-function:cubic-bezier(.215,.61,.355,1)}0%{opacity:0;transform:translate3d(3000px,0,0)}60%{opacity:1;transform:translate3d(-25px,0,0)}75%{transform:translate3d(10px,0,0)}90%{transform:translate3d(-5px,0,0)}to{transform:none}}@keyframes Toastify__bounceOutRight{20%{opacity:1;transform:translate3d(-20px,0,0)}to{opacity:0;transform:translate3d(2000px,0,0)}}@keyframes Toastify__bounceInLeft{0%,60%,75%,90%,to{animation-timing-function:cubic-bezier(.215,.61,.355,1)}0%{opacity:0;transform:translate3d(-3000px,0,0)}60%{opacity:1;transform:translate3d(25px,0,0)}75%{transform:translate3d(-10px,0,0)}90%{transform:translate3d(5px,0,0)}to{transform:none}}@keyframes Toastify__bounceOutLeft{20%{opacity:1;transform:translate3d(20px,0,0)}to{opacity:0;transform:translate3d(-2000px,0,0)}}@keyframes Toastify__bounceInUp{0%,60%,75%,90%,to{animation-timing-function:cubic-bezier(.215,.61,.355,1)}0%{opacity:0;transform:translate3d(0,3000px,0)}60%{opacity:1;transform:translate3d(0,-20px,0)}75%{transform:translate3d(0,10px,0)}90%{transform:translate3d(0,-5px,0)}to{transform:translateZ(0)}}@keyframes Toastify__bounceOutUp{20%{transform:translate3d(0,-10px,0)}40%,45%{opacity:1;transform:translate3d(0,20px,0)}to{opacity:0;transform:translate3d(0,-2000px,0)}}@keyframes Toastify__bounceInDown{0%,60%,75%,90%,to{animation-timing-function:cubic-bezier(.215,.61,.355,1)}0%{opacity:0;transform:translate3d(0,-3000px,0)}60%{opacity:1;transform:translate3d(0,25px,0)}75%{transform:translate3d(0,-10px,0)}90%{transform:translate3d(0,5px,0)}to{transform:none}}@keyframes Toastify__bounceOutDown{20%{transform:translate3d(0,10px,0)}40%,45%{opacity:1;transform:translate3d(0,-20px,0)}to{opacity:0;transform:translate3d(0,2000px,0)}}.Toastify__bounce-enter--bottom-left,.Toastify__bounce-enter--top-left{animation-name:Toastify__bounceInLeft}.Toastify__bounce-enter--bottom-right,.Toastify__bounce-enter--top-right{animation-name:Toastify__bounceInRight}.Toastify__bounce-enter--top-center{animation-name:Toastify__bounceInDown}.Toastify__bounce-enter--bottom-center{animation-name:Toastify__bounceInUp}.Toastify__bounce-exit--bottom-left,.Toastify__bounce-exit--top-left{animation-name:Toastify__bounceOutLeft}.Toastify__bounce-exit--bottom-right,.Toastify__bounce-exit--top-right{animation-name:Toastify__bounceOutRight}.Toastify__bounce-exit--top-center{animation-name:Toastify__bounceOutUp}.Toastify__bounce-exit--bottom-center{animation-name:Toastify__bounceOutDown}@keyframes Toastify__zoomIn{0%{opacity:0;transform:scale3d(.3,.3,.3)}50%{opacity:1}}@keyframes Toastify__zoomOut{0%{opacity:1}50%{opacity:0;transform:scale3d(.3,.3,.3)}to{opacity:0}}.Toastify__zoom-enter{animation-name:Toastify__zoomIn}.Toastify__zoom-exit{animation-name:Toastify__zoomOut}@keyframes Toastify__flipIn{0%{transform:perspective(400px) rotateX(90deg);animation-timing-function:ease-in;opacity:0}40%{transform:perspective(400px) rotateX(-20deg);animation-timing-function:ease-in}60%{transform:perspective(400px) rotateX(10deg);opacity:1}80%{transform:perspective(400px) rotateX(-5deg)}to{transform:perspective(400px)}}@keyframes Toastify__flipOut{0%{transform:perspective(400px)}30%{transform:perspective(400px) rotateX(-20deg);opacity:1}to{transform:perspective(400px) rotateX(90deg);opacity:0}}.Toastify__flip-enter{animation-name:Toastify__flipIn}.Toastify__flip-exit{animation-name:Toastify__flipOut}@keyframes Toastify__slideInRight{0%{transform:translate3d(110%,0,0);visibility:visible}to{transform:translateZ(0)}}@keyframes Toastify__slideInLeft{0%{transform:translate3d(-110%,0,0);visibility:visible}to{transform:translateZ(0)}}@keyframes Toastify__slideInUp{0%{transform:translate3d(0,110%,0);visibility:visible}to{transform:translateZ(0)}}@keyframes Toastify__slideInDown{0%{transform:translate3d(0,-110%,0);visibility:visible}to{transform:translateZ(0)}}@keyframes Toastify__slideOutRight{0%{transform:translateZ(0)}to{visibility:hidden;transform:translate3d(110%,0,0)}}@keyframes Toastify__slideOutLeft{0%{transform:translateZ(0)}to{visibility:hidden;transform:translate3d(-110%,0,0)}}@keyframes Toastify__slideOutDown{0%{transform:translateZ(0)}to{visibility:hidden;transform:translate3d(0,500px,0)}}@keyframes Toastify__slideOutUp{0%{transform:translateZ(0)}to{visibility:hidden;transform:translate3d(0,-500px,0)}}.Toastify__slide-enter--bottom-left,.Toastify__slide-enter--top-left{animation-name:Toastify__slideInLeft}.Toastify__slide-enter--bottom-right,.Toastify__slide-enter--top-right{animation-name:Toastify__slideInRight}.Toastify__slide-enter--top-center{animation-name:Toastify__slideInDown}.Toastify__slide-enter--bottom-center{animation-name:Toastify__slideInUp}.Toastify__slide-exit--bottom-left,.Toastify__slide-exit--top-left{animation-name:Toastify__slideOutLeft}.Toastify__slide-exit--bottom-right,.Toastify__slide-exit--top-right{animation-name:Toastify__slideOutRight}.Toastify__slide-exit--top-center{animation-name:Toastify__slideOutUp}.Toastify__slide-exit--bottom-center{animation-name:Toastify__slideOutDown}`, "",{"version":3,"sources":["webpack://./../../node_modules/react-toastify/dist/ReactToastify.min.css"],"names":[],"mappings":"AAAA,2BAA2B,YAAY,CAAC,oCAAoC,CAAC,cAAc,CAAC,WAAW,CAAC,WAAW,CAAC,qBAAqB,CAAC,UAAU,CAAC,qCAAqC,OAAO,CAAC,QAAQ,CAAC,uCAAuC,OAAO,CAAC,QAAQ,CAAC,0BAA0B,CAAC,sCAAsC,OAAO,CAAC,SAAS,CAAC,wCAAwC,UAAU,CAAC,QAAQ,CAAC,0CAA0C,UAAU,CAAC,QAAQ,CAAC,0BAA0B,CAAC,yCAAyC,UAAU,CAAC,SAAS,CAAC,yCAAyC,2BAA2B,WAAW,CAAC,SAAS,CAAC,MAAM,CAAC,QAAQ,CAAC,kHAAkH,KAAK,CAAC,uBAAuB,CAAC,2HAA2H,QAAQ,CAAC,uBAAuB,CAAC,gCAAgC,OAAO,CAAC,SAAS,CAAC,CAAC,iBAAiB,iBAAiB,CAAC,eAAe,CAAC,qBAAqB,CAAC,kBAAkB,CAAC,WAAW,CAAC,iBAAiB,CAAC,mEAAmE,CAAC,mBAAmB,CAAC,YAAY,CAAC,qBAAqB,CAAC,6BAA6B,CAAC,gBAAgB,CAAC,eAAe,CAAC,sBAAsB,CAAC,cAAc,CAAC,aAAa,CAAC,sBAAsB,aAAa,CAAC,uBAAuB,kBAAkB,CAAC,UAAU,CAAC,0BAA0B,eAAe,CAAC,UAAU,CAAC,uBAAuB,kBAAkB,CAAC,0BAA0B,kBAAkB,CAAC,0BAA0B,kBAAkB,CAAC,wBAAwB,kBAAkB,CAAC,sBAAsB,aAAa,CAAC,iBAAiB,CAAC,aAAa,CAAC,WAAW,CAAC,mBAAmB,wBAAwB,CAAC,sBAAsB,CAAC,yCAAyC,iBAAiB,eAAe,CAAC,eAAe,CAAC,CAAC,wBAAwB,UAAU,CAAC,sBAAsB,CAAC,YAAY,CAAC,WAAW,CAAC,SAAS,CAAC,cAAc,CAAC,UAAU,CAAC,mBAAmB,CAAC,yBAAyB,CAAC,qBAAqB,CAAC,iCAAiC,UAAU,CAAC,UAAU,CAAC,4BAA4B,iBAAiB,CAAC,WAAW,CAAC,UAAU,CAAC,4DAA4D,SAAS,CAAC,mCAAmC,GAAG,mBAAmB,CAAC,GAAG,mBAAmB,CAAC,CAAC,wBAAwB,iBAAiB,CAAC,QAAQ,CAAC,MAAM,CAAC,UAAU,CAAC,UAAU,CAAC,YAAY,CAAC,UAAU,CAAC,mCAAmC,CAAC,qBAAqB,CAAC,kCAAkC,mDAAmD,CAAC,oCAAoC,wBAAwB,CAAC,6BAA6B,OAAO,CAAC,SAAS,CAAC,sBAAsB,CAAC,iCAAiC,iFAAiF,CAAC,8BAA8B,kBAAkB,CAAC,mCAAmC,kBAAkB,uDAAuD,CAAC,GAAG,SAAS,CAAC,iCAAiC,CAAC,IAAI,SAAS,CAAC,gCAAgC,CAAC,IAAI,+BAA+B,CAAC,IAAI,+BAA+B,CAAC,GAAG,cAAc,CAAC,CAAC,oCAAoC,IAAI,SAAS,CAAC,gCAAgC,CAAC,GAAG,SAAS,CAAC,iCAAiC,CAAC,CAAC,kCAAkC,kBAAkB,uDAAuD,CAAC,GAAG,SAAS,CAAC,kCAAkC,CAAC,IAAI,SAAS,CAAC,+BAA+B,CAAC,IAAI,gCAAgC,CAAC,IAAI,8BAA8B,CAAC,GAAG,cAAc,CAAC,CAAC,mCAAmC,IAAI,SAAS,CAAC,+BAA+B,CAAC,GAAG,SAAS,CAAC,kCAAkC,CAAC,CAAC,gCAAgC,kBAAkB,uDAAuD,CAAC,GAAG,SAAS,CAAC,iCAAiC,CAAC,IAAI,SAAS,CAAC,gCAAgC,CAAC,IAAI,+BAA+B,CAAC,IAAI,+BAA+B,CAAC,GAAG,uBAAuB,CAAC,CAAC,iCAAiC,IAAI,gCAAgC,CAAC,QAAQ,SAAS,CAAC,+BAA+B,CAAC,GAAG,SAAS,CAAC,kCAAkC,CAAC,CAAC,kCAAkC,kBAAkB,uDAAuD,CAAC,GAAG,SAAS,CAAC,kCAAkC,CAAC,IAAI,SAAS,CAAC,+BAA+B,CAAC,IAAI,gCAAgC,CAAC,IAAI,8BAA8B,CAAC,GAAG,cAAc,CAAC,CAAC,mCAAmC,IAAI,+BAA+B,CAAC,QAAQ,SAAS,CAAC,gCAAgC,CAAC,GAAG,SAAS,CAAC,iCAAiC,CAAC,CAAC,uEAAuE,qCAAqC,CAAC,yEAAyE,sCAAsC,CAAC,oCAAoC,qCAAqC,CAAC,uCAAuC,mCAAmC,CAAC,qEAAqE,sCAAsC,CAAC,uEAAuE,uCAAuC,CAAC,mCAAmC,oCAAoC,CAAC,sCAAsC,sCAAsC,CAAC,4BAA4B,GAAG,SAAS,CAAC,2BAA2B,CAAC,IAAI,SAAS,CAAC,CAAC,6BAA6B,GAAG,SAAS,CAAC,IAAI,SAAS,CAAC,2BAA2B,CAAC,GAAG,SAAS,CAAC,CAAC,sBAAsB,+BAA+B,CAAC,qBAAqB,gCAAgC,CAAC,4BAA4B,GAAG,2CAA2C,CAAC,iCAAiC,CAAC,SAAS,CAAC,IAAI,4CAA4C,CAAC,iCAAiC,CAAC,IAAI,2CAA2C,CAAC,SAAS,CAAC,IAAI,2CAA2C,CAAC,GAAG,4BAA4B,CAAC,CAAC,6BAA6B,GAAG,4BAA4B,CAAC,IAAI,4CAA4C,CAAC,SAAS,CAAC,GAAG,2CAA2C,CAAC,SAAS,CAAC,CAAC,sBAAsB,+BAA+B,CAAC,qBAAqB,gCAAgC,CAAC,kCAAkC,GAAG,+BAA+B,CAAC,kBAAkB,CAAC,GAAG,uBAAuB,CAAC,CAAC,iCAAiC,GAAG,gCAAgC,CAAC,kBAAkB,CAAC,GAAG,uBAAuB,CAAC,CAAC,+BAA+B,GAAG,+BAA+B,CAAC,kBAAkB,CAAC,GAAG,uBAAuB,CAAC,CAAC,iCAAiC,GAAG,gCAAgC,CAAC,kBAAkB,CAAC,GAAG,uBAAuB,CAAC,CAAC,mCAAmC,GAAG,uBAAuB,CAAC,GAAG,iBAAiB,CAAC,+BAA+B,CAAC,CAAC,kCAAkC,GAAG,uBAAuB,CAAC,GAAG,iBAAiB,CAAC,gCAAgC,CAAC,CAAC,kCAAkC,GAAG,uBAAuB,CAAC,GAAG,iBAAiB,CAAC,gCAAgC,CAAC,CAAC,gCAAgC,GAAG,uBAAuB,CAAC,GAAG,iBAAiB,CAAC,iCAAiC,CAAC,CAAC,qEAAqE,oCAAoC,CAAC,uEAAuE,qCAAqC,CAAC,mCAAmC,oCAAoC,CAAC,sCAAsC,kCAAkC,CAAC,mEAAmE,qCAAqC,CAAC,qEAAqE,sCAAsC,CAAC,kCAAkC,mCAAmC,CAAC,qCAAqC,qCAAqC","sourcesContent":[".Toastify__toast-container{z-index:9999;-webkit-transform:translateZ(9999px);position:fixed;padding:4px;width:320px;box-sizing:border-box;color:#fff}.Toastify__toast-container--top-left{top:1em;left:1em}.Toastify__toast-container--top-center{top:1em;left:50%;transform:translateX(-50%)}.Toastify__toast-container--top-right{top:1em;right:1em}.Toastify__toast-container--bottom-left{bottom:1em;left:1em}.Toastify__toast-container--bottom-center{bottom:1em;left:50%;transform:translateX(-50%)}.Toastify__toast-container--bottom-right{bottom:1em;right:1em}@media only screen and (max-width:480px){.Toastify__toast-container{width:100vw;padding:0;left:0;margin:0}.Toastify__toast-container--top-center,.Toastify__toast-container--top-left,.Toastify__toast-container--top-right{top:0;transform:translateX(0)}.Toastify__toast-container--bottom-center,.Toastify__toast-container--bottom-left,.Toastify__toast-container--bottom-right{bottom:0;transform:translateX(0)}.Toastify__toast-container--rtl{right:0;left:auto}}.Toastify__toast{position:relative;min-height:64px;box-sizing:border-box;margin-bottom:1rem;padding:8px;border-radius:4px;box-shadow:0 1px 10px 0 rgba(0,0,0,.1),0 2px 15px 0 rgba(0,0,0,.05);display:-ms-flexbox;display:flex;-ms-flex-pack:justify;justify-content:space-between;max-height:800px;overflow:hidden;font-family:sans-serif;cursor:pointer;direction:ltr}.Toastify__toast--rtl{direction:rtl}.Toastify__toast--dark{background:#121212;color:#fff}.Toastify__toast--default{background:#fff;color:#aaa}.Toastify__toast--info{background:#3498db}.Toastify__toast--success{background:#07bc0c}.Toastify__toast--warning{background:#f1c40f}.Toastify__toast--error{background:#e74c3c}.Toastify__toast-body{margin:auto 0;-ms-flex:1 1 auto;flex:1 1 auto;padding:6px}.Toastify--animate{animation-fill-mode:both;animation-duration:.7s}@media only screen and (max-width:480px){.Toastify__toast{margin-bottom:0;border-radius:0}}.Toastify__close-button{color:#fff;background:transparent;outline:none;border:none;padding:0;cursor:pointer;opacity:.7;transition:.3s ease;-ms-flex-item-align:start;align-self:flex-start}.Toastify__close-button--default{color:#000;opacity:.3}.Toastify__close-button>svg{fill:currentColor;height:16px;width:14px}.Toastify__close-button:focus,.Toastify__close-button:hover{opacity:1}@keyframes Toastify__trackProgress{0%{transform:scaleX(1)}to{transform:scaleX(0)}}.Toastify__progress-bar{position:absolute;bottom:0;left:0;width:100%;height:5px;z-index:9999;opacity:.7;background-color:hsla(0,0%,100%,.7);transform-origin:left}.Toastify__progress-bar--animated{animation:Toastify__trackProgress linear 1 forwards}.Toastify__progress-bar--controlled{transition:transform .2s}.Toastify__progress-bar--rtl{right:0;left:auto;transform-origin:right}.Toastify__progress-bar--default{background:linear-gradient(90deg,#4cd964,#5ac8fa,#007aff,#34aadc,#5856d6,#ff2d55)}.Toastify__progress-bar--dark{background:#bb86fc}@keyframes Toastify__bounceInRight{0%,60%,75%,90%,to{animation-timing-function:cubic-bezier(.215,.61,.355,1)}0%{opacity:0;transform:translate3d(3000px,0,0)}60%{opacity:1;transform:translate3d(-25px,0,0)}75%{transform:translate3d(10px,0,0)}90%{transform:translate3d(-5px,0,0)}to{transform:none}}@keyframes Toastify__bounceOutRight{20%{opacity:1;transform:translate3d(-20px,0,0)}to{opacity:0;transform:translate3d(2000px,0,0)}}@keyframes Toastify__bounceInLeft{0%,60%,75%,90%,to{animation-timing-function:cubic-bezier(.215,.61,.355,1)}0%{opacity:0;transform:translate3d(-3000px,0,0)}60%{opacity:1;transform:translate3d(25px,0,0)}75%{transform:translate3d(-10px,0,0)}90%{transform:translate3d(5px,0,0)}to{transform:none}}@keyframes Toastify__bounceOutLeft{20%{opacity:1;transform:translate3d(20px,0,0)}to{opacity:0;transform:translate3d(-2000px,0,0)}}@keyframes Toastify__bounceInUp{0%,60%,75%,90%,to{animation-timing-function:cubic-bezier(.215,.61,.355,1)}0%{opacity:0;transform:translate3d(0,3000px,0)}60%{opacity:1;transform:translate3d(0,-20px,0)}75%{transform:translate3d(0,10px,0)}90%{transform:translate3d(0,-5px,0)}to{transform:translateZ(0)}}@keyframes Toastify__bounceOutUp{20%{transform:translate3d(0,-10px,0)}40%,45%{opacity:1;transform:translate3d(0,20px,0)}to{opacity:0;transform:translate3d(0,-2000px,0)}}@keyframes Toastify__bounceInDown{0%,60%,75%,90%,to{animation-timing-function:cubic-bezier(.215,.61,.355,1)}0%{opacity:0;transform:translate3d(0,-3000px,0)}60%{opacity:1;transform:translate3d(0,25px,0)}75%{transform:translate3d(0,-10px,0)}90%{transform:translate3d(0,5px,0)}to{transform:none}}@keyframes Toastify__bounceOutDown{20%{transform:translate3d(0,10px,0)}40%,45%{opacity:1;transform:translate3d(0,-20px,0)}to{opacity:0;transform:translate3d(0,2000px,0)}}.Toastify__bounce-enter--bottom-left,.Toastify__bounce-enter--top-left{animation-name:Toastify__bounceInLeft}.Toastify__bounce-enter--bottom-right,.Toastify__bounce-enter--top-right{animation-name:Toastify__bounceInRight}.Toastify__bounce-enter--top-center{animation-name:Toastify__bounceInDown}.Toastify__bounce-enter--bottom-center{animation-name:Toastify__bounceInUp}.Toastify__bounce-exit--bottom-left,.Toastify__bounce-exit--top-left{animation-name:Toastify__bounceOutLeft}.Toastify__bounce-exit--bottom-right,.Toastify__bounce-exit--top-right{animation-name:Toastify__bounceOutRight}.Toastify__bounce-exit--top-center{animation-name:Toastify__bounceOutUp}.Toastify__bounce-exit--bottom-center{animation-name:Toastify__bounceOutDown}@keyframes Toastify__zoomIn{0%{opacity:0;transform:scale3d(.3,.3,.3)}50%{opacity:1}}@keyframes Toastify__zoomOut{0%{opacity:1}50%{opacity:0;transform:scale3d(.3,.3,.3)}to{opacity:0}}.Toastify__zoom-enter{animation-name:Toastify__zoomIn}.Toastify__zoom-exit{animation-name:Toastify__zoomOut}@keyframes Toastify__flipIn{0%{transform:perspective(400px) rotateX(90deg);animation-timing-function:ease-in;opacity:0}40%{transform:perspective(400px) rotateX(-20deg);animation-timing-function:ease-in}60%{transform:perspective(400px) rotateX(10deg);opacity:1}80%{transform:perspective(400px) rotateX(-5deg)}to{transform:perspective(400px)}}@keyframes Toastify__flipOut{0%{transform:perspective(400px)}30%{transform:perspective(400px) rotateX(-20deg);opacity:1}to{transform:perspective(400px) rotateX(90deg);opacity:0}}.Toastify__flip-enter{animation-name:Toastify__flipIn}.Toastify__flip-exit{animation-name:Toastify__flipOut}@keyframes Toastify__slideInRight{0%{transform:translate3d(110%,0,0);visibility:visible}to{transform:translateZ(0)}}@keyframes Toastify__slideInLeft{0%{transform:translate3d(-110%,0,0);visibility:visible}to{transform:translateZ(0)}}@keyframes Toastify__slideInUp{0%{transform:translate3d(0,110%,0);visibility:visible}to{transform:translateZ(0)}}@keyframes Toastify__slideInDown{0%{transform:translate3d(0,-110%,0);visibility:visible}to{transform:translateZ(0)}}@keyframes Toastify__slideOutRight{0%{transform:translateZ(0)}to{visibility:hidden;transform:translate3d(110%,0,0)}}@keyframes Toastify__slideOutLeft{0%{transform:translateZ(0)}to{visibility:hidden;transform:translate3d(-110%,0,0)}}@keyframes Toastify__slideOutDown{0%{transform:translateZ(0)}to{visibility:hidden;transform:translate3d(0,500px,0)}}@keyframes Toastify__slideOutUp{0%{transform:translateZ(0)}to{visibility:hidden;transform:translate3d(0,-500px,0)}}.Toastify__slide-enter--bottom-left,.Toastify__slide-enter--top-left{animation-name:Toastify__slideInLeft}.Toastify__slide-enter--bottom-right,.Toastify__slide-enter--top-right{animation-name:Toastify__slideInRight}.Toastify__slide-enter--top-center{animation-name:Toastify__slideInDown}.Toastify__slide-enter--bottom-center{animation-name:Toastify__slideInUp}.Toastify__slide-exit--bottom-left,.Toastify__slide-exit--top-left{animation-name:Toastify__slideOutLeft}.Toastify__slide-exit--bottom-right,.Toastify__slide-exit--top-right{animation-name:Toastify__slideOutRight}.Toastify__slide-exit--top-center{animation-name:Toastify__slideOutUp}.Toastify__slide-exit--bottom-center{animation-name:Toastify__slideOutDown}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/cjs.js!../../node_modules/tippy.js/dist/tippy.css":
/*!*****************************************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/cjs.js!../../node_modules/tippy.js/dist/tippy.css ***!
  \*****************************************************************************************************************************/
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../@jupyterlab/builder/node_modules/css-loader/dist/runtime/sourceMaps.js */ "../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/runtime/sourceMaps.js");
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../@jupyterlab/builder/node_modules/css-loader/dist/runtime/api.js */ "../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/runtime/api.js");
/* harmony import */ var _jupyterlab_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);
// Imports


var ___CSS_LOADER_EXPORT___ = _jupyterlab_builder_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()((_jupyterlab_builder_node_modules_css_loader_dist_runtime_sourceMaps_js__WEBPACK_IMPORTED_MODULE_0___default()));
// Module
___CSS_LOADER_EXPORT___.push([module.id, `.tippy-box[data-animation=fade][data-state=hidden]{opacity:0}[data-tippy-root]{max-width:calc(100vw - 10px)}.tippy-box{position:relative;background-color:#333;color:#fff;border-radius:4px;font-size:14px;line-height:1.4;white-space:normal;outline:0;transition-property:transform,visibility,opacity}.tippy-box[data-placement^=top]>.tippy-arrow{bottom:0}.tippy-box[data-placement^=top]>.tippy-arrow:before{bottom:-7px;left:0;border-width:8px 8px 0;border-top-color:initial;transform-origin:center top}.tippy-box[data-placement^=bottom]>.tippy-arrow{top:0}.tippy-box[data-placement^=bottom]>.tippy-arrow:before{top:-7px;left:0;border-width:0 8px 8px;border-bottom-color:initial;transform-origin:center bottom}.tippy-box[data-placement^=left]>.tippy-arrow{right:0}.tippy-box[data-placement^=left]>.tippy-arrow:before{border-width:8px 0 8px 8px;border-left-color:initial;right:-7px;transform-origin:center left}.tippy-box[data-placement^=right]>.tippy-arrow{left:0}.tippy-box[data-placement^=right]>.tippy-arrow:before{left:-7px;border-width:8px 8px 8px 0;border-right-color:initial;transform-origin:center right}.tippy-box[data-inertia][data-state=visible]{transition-timing-function:cubic-bezier(.54,1.5,.38,1.11)}.tippy-arrow{width:16px;height:16px;color:#333}.tippy-arrow:before{content:"";position:absolute;border-color:transparent;border-style:solid}.tippy-content{position:relative;padding:5px 9px;z-index:1}`, "",{"version":3,"sources":["webpack://./../../node_modules/tippy.js/dist/tippy.css"],"names":[],"mappings":"AAAA,mDAAmD,SAAS,CAAC,kBAAkB,4BAA4B,CAAC,WAAW,iBAAiB,CAAC,qBAAqB,CAAC,UAAU,CAAC,iBAAiB,CAAC,cAAc,CAAC,eAAe,CAAC,kBAAkB,CAAC,SAAS,CAAC,gDAAgD,CAAC,6CAA6C,QAAQ,CAAC,oDAAoD,WAAW,CAAC,MAAM,CAAC,sBAAsB,CAAC,wBAAwB,CAAC,2BAA2B,CAAC,gDAAgD,KAAK,CAAC,uDAAuD,QAAQ,CAAC,MAAM,CAAC,sBAAsB,CAAC,2BAA2B,CAAC,8BAA8B,CAAC,8CAA8C,OAAO,CAAC,qDAAqD,0BAA0B,CAAC,yBAAyB,CAAC,UAAU,CAAC,4BAA4B,CAAC,+CAA+C,MAAM,CAAC,sDAAsD,SAAS,CAAC,0BAA0B,CAAC,0BAA0B,CAAC,6BAA6B,CAAC,6CAA6C,yDAAyD,CAAC,aAAa,UAAU,CAAC,WAAW,CAAC,UAAU,CAAC,oBAAoB,UAAU,CAAC,iBAAiB,CAAC,wBAAwB,CAAC,kBAAkB,CAAC,eAAe,iBAAiB,CAAC,eAAe,CAAC,SAAS","sourcesContent":[".tippy-box[data-animation=fade][data-state=hidden]{opacity:0}[data-tippy-root]{max-width:calc(100vw - 10px)}.tippy-box{position:relative;background-color:#333;color:#fff;border-radius:4px;font-size:14px;line-height:1.4;white-space:normal;outline:0;transition-property:transform,visibility,opacity}.tippy-box[data-placement^=top]>.tippy-arrow{bottom:0}.tippy-box[data-placement^=top]>.tippy-arrow:before{bottom:-7px;left:0;border-width:8px 8px 0;border-top-color:initial;transform-origin:center top}.tippy-box[data-placement^=bottom]>.tippy-arrow{top:0}.tippy-box[data-placement^=bottom]>.tippy-arrow:before{top:-7px;left:0;border-width:0 8px 8px;border-bottom-color:initial;transform-origin:center bottom}.tippy-box[data-placement^=left]>.tippy-arrow{right:0}.tippy-box[data-placement^=left]>.tippy-arrow:before{border-width:8px 0 8px 8px;border-left-color:initial;right:-7px;transform-origin:center left}.tippy-box[data-placement^=right]>.tippy-arrow{left:0}.tippy-box[data-placement^=right]>.tippy-arrow:before{left:-7px;border-width:8px 8px 8px 0;border-right-color:initial;transform-origin:center right}.tippy-box[data-inertia][data-state=visible]{transition-timing-function:cubic-bezier(.54,1.5,.38,1.11)}.tippy-arrow{width:16px;height:16px;color:#333}.tippy-arrow:before{content:\"\";position:absolute;border-color:transparent;border-style:solid}.tippy-content{position:relative;padding:5px 9px;z-index:1}"],"sourceRoot":""}]);
// Exports
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (___CSS_LOADER_EXPORT___);


/***/ }),

/***/ "../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/runtime/api.js":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/runtime/api.js ***!
  \******************************************************************************************/
/***/ ((module) => {

"use strict";


/*
  MIT License http://www.opensource.org/licenses/mit-license.php
  Author Tobias Koppers @sokra
*/
module.exports = function (cssWithMappingToString) {
  var list = [];

  // return the list of modules as css string
  list.toString = function toString() {
    return this.map(function (item) {
      var content = "";
      var needLayer = typeof item[5] !== "undefined";
      if (item[4]) {
        content += "@supports (".concat(item[4], ") {");
      }
      if (item[2]) {
        content += "@media ".concat(item[2], " {");
      }
      if (needLayer) {
        content += "@layer".concat(item[5].length > 0 ? " ".concat(item[5]) : "", " {");
      }
      content += cssWithMappingToString(item);
      if (needLayer) {
        content += "}";
      }
      if (item[2]) {
        content += "}";
      }
      if (item[4]) {
        content += "}";
      }
      return content;
    }).join("");
  };

  // import a list of modules into the list
  list.i = function i(modules, media, dedupe, supports, layer) {
    if (typeof modules === "string") {
      modules = [[null, modules, undefined]];
    }
    var alreadyImportedModules = {};
    if (dedupe) {
      for (var k = 0; k < this.length; k++) {
        var id = this[k][0];
        if (id != null) {
          alreadyImportedModules[id] = true;
        }
      }
    }
    for (var _k = 0; _k < modules.length; _k++) {
      var item = [].concat(modules[_k]);
      if (dedupe && alreadyImportedModules[item[0]]) {
        continue;
      }
      if (typeof layer !== "undefined") {
        if (typeof item[5] === "undefined") {
          item[5] = layer;
        } else {
          item[1] = "@layer".concat(item[5].length > 0 ? " ".concat(item[5]) : "", " {").concat(item[1], "}");
          item[5] = layer;
        }
      }
      if (media) {
        if (!item[2]) {
          item[2] = media;
        } else {
          item[1] = "@media ".concat(item[2], " {").concat(item[1], "}");
          item[2] = media;
        }
      }
      if (supports) {
        if (!item[4]) {
          item[4] = "".concat(supports);
        } else {
          item[1] = "@supports (".concat(item[4], ") {").concat(item[1], "}");
          item[4] = supports;
        }
      }
      list.push(item);
    }
  };
  return list;
};

/***/ }),

/***/ "../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/runtime/sourceMaps.js":
/*!*************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/builder/node_modules/css-loader/dist/runtime/sourceMaps.js ***!
  \*************************************************************************************************/
/***/ ((module) => {

"use strict";


module.exports = function (item) {
  var content = item[1];
  var cssMapping = item[3];
  if (!cssMapping) {
    return content;
  }
  if (typeof btoa === "function") {
    var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(cssMapping))));
    var data = "sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(base64);
    var sourceMapping = "/*# ".concat(data, " */");
    return [content].concat([sourceMapping]).join("\n");
  }
  return [content].join("\n");
};

/***/ }),

/***/ "../../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js":
/*!*****************************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js ***!
  \*****************************************************************************************************************/
/***/ ((module) => {

"use strict";


var stylesInDOM = [];
function getIndexByIdentifier(identifier) {
  var result = -1;
  for (var i = 0; i < stylesInDOM.length; i++) {
    if (stylesInDOM[i].identifier === identifier) {
      result = i;
      break;
    }
  }
  return result;
}
function modulesToDom(list, options) {
  var idCountMap = {};
  var identifiers = [];
  for (var i = 0; i < list.length; i++) {
    var item = list[i];
    var id = options.base ? item[0] + options.base : item[0];
    var count = idCountMap[id] || 0;
    var identifier = "".concat(id, " ").concat(count);
    idCountMap[id] = count + 1;
    var indexByIdentifier = getIndexByIdentifier(identifier);
    var obj = {
      css: item[1],
      media: item[2],
      sourceMap: item[3],
      supports: item[4],
      layer: item[5]
    };
    if (indexByIdentifier !== -1) {
      stylesInDOM[indexByIdentifier].references++;
      stylesInDOM[indexByIdentifier].updater(obj);
    } else {
      var updater = addElementStyle(obj, options);
      options.byIndex = i;
      stylesInDOM.splice(i, 0, {
        identifier: identifier,
        updater: updater,
        references: 1
      });
    }
    identifiers.push(identifier);
  }
  return identifiers;
}
function addElementStyle(obj, options) {
  var api = options.domAPI(options);
  api.update(obj);
  var updater = function updater(newObj) {
    if (newObj) {
      if (newObj.css === obj.css && newObj.media === obj.media && newObj.sourceMap === obj.sourceMap && newObj.supports === obj.supports && newObj.layer === obj.layer) {
        return;
      }
      api.update(obj = newObj);
    } else {
      api.remove();
    }
  };
  return updater;
}
module.exports = function (list, options) {
  options = options || {};
  list = list || [];
  var lastIdentifiers = modulesToDom(list, options);
  return function update(newList) {
    newList = newList || [];
    for (var i = 0; i < lastIdentifiers.length; i++) {
      var identifier = lastIdentifiers[i];
      var index = getIndexByIdentifier(identifier);
      stylesInDOM[index].references--;
    }
    var newLastIdentifiers = modulesToDom(newList, options);
    for (var _i = 0; _i < lastIdentifiers.length; _i++) {
      var _identifier = lastIdentifiers[_i];
      var _index = getIndexByIdentifier(_identifier);
      if (stylesInDOM[_index].references === 0) {
        stylesInDOM[_index].updater();
        stylesInDOM.splice(_index, 1);
      }
    }
    lastIdentifiers = newLastIdentifiers;
  };
};

/***/ }),

/***/ "../../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/insertBySelector.js":
/*!*********************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/insertBySelector.js ***!
  \*********************************************************************************************************/
/***/ ((module) => {

"use strict";


var memo = {};

/* istanbul ignore next  */
function getTarget(target) {
  if (typeof memo[target] === "undefined") {
    var styleTarget = document.querySelector(target);

    // Special case to return head of iframe instead of iframe itself
    if (window.HTMLIFrameElement && styleTarget instanceof window.HTMLIFrameElement) {
      try {
        // This will throw an exception if access to iframe is blocked
        // due to cross-origin restrictions
        styleTarget = styleTarget.contentDocument.head;
      } catch (e) {
        // istanbul ignore next
        styleTarget = null;
      }
    }
    memo[target] = styleTarget;
  }
  return memo[target];
}

/* istanbul ignore next  */
function insertBySelector(insert, style) {
  var target = getTarget(insert);
  if (!target) {
    throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");
  }
  target.appendChild(style);
}
module.exports = insertBySelector;

/***/ }),

/***/ "../../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/insertStyleElement.js":
/*!***********************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/insertStyleElement.js ***!
  \***********************************************************************************************************/
/***/ ((module) => {

"use strict";


/* istanbul ignore next  */
function insertStyleElement(options) {
  var element = document.createElement("style");
  options.setAttributes(element, options.attributes);
  options.insert(element, options.options);
  return element;
}
module.exports = insertStyleElement;

/***/ }),

/***/ "../../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js":
/*!***********************************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js ***!
  \***********************************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


/* istanbul ignore next  */
function setAttributesWithoutAttributes(styleElement) {
  var nonce =  true ? __webpack_require__.nc : 0;
  if (nonce) {
    styleElement.setAttribute("nonce", nonce);
  }
}
module.exports = setAttributesWithoutAttributes;

/***/ }),

/***/ "../../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/styleDomAPI.js":
/*!****************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/styleDomAPI.js ***!
  \****************************************************************************************************/
/***/ ((module) => {

"use strict";


/* istanbul ignore next  */
function apply(styleElement, options, obj) {
  var css = "";
  if (obj.supports) {
    css += "@supports (".concat(obj.supports, ") {");
  }
  if (obj.media) {
    css += "@media ".concat(obj.media, " {");
  }
  var needLayer = typeof obj.layer !== "undefined";
  if (needLayer) {
    css += "@layer".concat(obj.layer.length > 0 ? " ".concat(obj.layer) : "", " {");
  }
  css += obj.css;
  if (needLayer) {
    css += "}";
  }
  if (obj.media) {
    css += "}";
  }
  if (obj.supports) {
    css += "}";
  }
  var sourceMap = obj.sourceMap;
  if (sourceMap && typeof btoa !== "undefined") {
    css += "\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))), " */");
  }

  // For old IE
  /* istanbul ignore if  */
  options.styleTagTransform(css, styleElement, options.options);
}
function removeStyleElement(styleElement) {
  // istanbul ignore if
  if (styleElement.parentNode === null) {
    return false;
  }
  styleElement.parentNode.removeChild(styleElement);
}

/* istanbul ignore next  */
function domAPI(options) {
  if (typeof document === "undefined") {
    return {
      update: function update() {},
      remove: function remove() {}
    };
  }
  var styleElement = options.insertStyleElement(options);
  return {
    update: function update(obj) {
      apply(styleElement, options, obj);
    },
    remove: function remove() {
      removeStyleElement(styleElement);
    }
  };
}
module.exports = domAPI;

/***/ }),

/***/ "../../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/styleTagTransform.js":
/*!**********************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/builder/node_modules/style-loader/dist/runtime/styleTagTransform.js ***!
  \**********************************************************************************************************/
/***/ ((module) => {

"use strict";


/* istanbul ignore next  */
function styleTagTransform(css, styleElement) {
  if (styleElement.styleSheet) {
    styleElement.styleSheet.cssText = css;
  } else {
    while (styleElement.firstChild) {
      styleElement.removeChild(styleElement.firstChild);
    }
    styleElement.appendChild(document.createTextNode(css));
  }
}
module.exports = styleTagTransform;

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/lib/icon/iconimports.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/lib/icon/iconimports.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addAboveIcon: () => (/* binding */ addAboveIcon),
/* harmony export */   addBelowIcon: () => (/* binding */ addBelowIcon),
/* harmony export */   addIcon: () => (/* binding */ addIcon),
/* harmony export */   bellIcon: () => (/* binding */ bellIcon),
/* harmony export */   bugDotIcon: () => (/* binding */ bugDotIcon),
/* harmony export */   bugIcon: () => (/* binding */ bugIcon),
/* harmony export */   buildIcon: () => (/* binding */ buildIcon),
/* harmony export */   caretDownEmptyIcon: () => (/* binding */ caretDownEmptyIcon),
/* harmony export */   caretDownEmptyThinIcon: () => (/* binding */ caretDownEmptyThinIcon),
/* harmony export */   caretDownIcon: () => (/* binding */ caretDownIcon),
/* harmony export */   caretLeftIcon: () => (/* binding */ caretLeftIcon),
/* harmony export */   caretRightIcon: () => (/* binding */ caretRightIcon),
/* harmony export */   caretUpEmptyThinIcon: () => (/* binding */ caretUpEmptyThinIcon),
/* harmony export */   caretUpIcon: () => (/* binding */ caretUpIcon),
/* harmony export */   caseSensitiveIcon: () => (/* binding */ caseSensitiveIcon),
/* harmony export */   checkIcon: () => (/* binding */ checkIcon),
/* harmony export */   circleEmptyIcon: () => (/* binding */ circleEmptyIcon),
/* harmony export */   circleIcon: () => (/* binding */ circleIcon),
/* harmony export */   cleaningIcon: () => (/* binding */ cleaningIcon),
/* harmony export */   clearIcon: () => (/* binding */ clearIcon),
/* harmony export */   closeAllIcon: () => (/* binding */ closeAllIcon),
/* harmony export */   closeIcon: () => (/* binding */ closeIcon),
/* harmony export */   codeCheckIcon: () => (/* binding */ codeCheckIcon),
/* harmony export */   codeIcon: () => (/* binding */ codeIcon),
/* harmony export */   collapseAllIcon: () => (/* binding */ collapseAllIcon),
/* harmony export */   collapseIcon: () => (/* binding */ collapseIcon),
/* harmony export */   consoleIcon: () => (/* binding */ consoleIcon),
/* harmony export */   copyIcon: () => (/* binding */ copyIcon),
/* harmony export */   copyrightIcon: () => (/* binding */ copyrightIcon),
/* harmony export */   cutIcon: () => (/* binding */ cutIcon),
/* harmony export */   deleteIcon: () => (/* binding */ deleteIcon),
/* harmony export */   dockBottomIcon: () => (/* binding */ dockBottomIcon),
/* harmony export */   dockLeftIcon: () => (/* binding */ dockLeftIcon),
/* harmony export */   dockRightIcon: () => (/* binding */ dockRightIcon),
/* harmony export */   dockTopIcon: () => (/* binding */ dockTopIcon),
/* harmony export */   dotsIcon: () => (/* binding */ dotsIcon),
/* harmony export */   downloadIcon: () => (/* binding */ downloadIcon),
/* harmony export */   duplicateIcon: () => (/* binding */ duplicateIcon),
/* harmony export */   editIcon: () => (/* binding */ editIcon),
/* harmony export */   ellipsesIcon: () => (/* binding */ ellipsesIcon),
/* harmony export */   errorIcon: () => (/* binding */ errorIcon),
/* harmony export */   exceptionsIcon: () => (/* binding */ exceptionsIcon),
/* harmony export */   expandAllIcon: () => (/* binding */ expandAllIcon),
/* harmony export */   expandIcon: () => (/* binding */ expandIcon),
/* harmony export */   extensionIcon: () => (/* binding */ extensionIcon),
/* harmony export */   fastForwardIcon: () => (/* binding */ fastForwardIcon),
/* harmony export */   fileIcon: () => (/* binding */ fileIcon),
/* harmony export */   fileUploadIcon: () => (/* binding */ fileUploadIcon),
/* harmony export */   filterDotIcon: () => (/* binding */ filterDotIcon),
/* harmony export */   filterIcon: () => (/* binding */ filterIcon),
/* harmony export */   filterListIcon: () => (/* binding */ filterListIcon),
/* harmony export */   folderFavoriteIcon: () => (/* binding */ folderFavoriteIcon),
/* harmony export */   folderIcon: () => (/* binding */ folderIcon),
/* harmony export */   historyIcon: () => (/* binding */ historyIcon),
/* harmony export */   homeIcon: () => (/* binding */ homeIcon),
/* harmony export */   html5Icon: () => (/* binding */ html5Icon),
/* harmony export */   imageIcon: () => (/* binding */ imageIcon),
/* harmony export */   infoIcon: () => (/* binding */ infoIcon),
/* harmony export */   inspectorIcon: () => (/* binding */ inspectorIcon),
/* harmony export */   jsonIcon: () => (/* binding */ jsonIcon),
/* harmony export */   juliaIcon: () => (/* binding */ juliaIcon),
/* harmony export */   jupyterFaviconIcon: () => (/* binding */ jupyterFaviconIcon),
/* harmony export */   jupyterIcon: () => (/* binding */ jupyterIcon),
/* harmony export */   jupyterlabWordmarkIcon: () => (/* binding */ jupyterlabWordmarkIcon),
/* harmony export */   kernelIcon: () => (/* binding */ kernelIcon),
/* harmony export */   keyboardIcon: () => (/* binding */ keyboardIcon),
/* harmony export */   launchIcon: () => (/* binding */ launchIcon),
/* harmony export */   launcherIcon: () => (/* binding */ launcherIcon),
/* harmony export */   lineFormIcon: () => (/* binding */ lineFormIcon),
/* harmony export */   linkIcon: () => (/* binding */ linkIcon),
/* harmony export */   listIcon: () => (/* binding */ listIcon),
/* harmony export */   lockIcon: () => (/* binding */ lockIcon),
/* harmony export */   markdownIcon: () => (/* binding */ markdownIcon),
/* harmony export */   mermaidIcon: () => (/* binding */ mermaidIcon),
/* harmony export */   moveDownIcon: () => (/* binding */ moveDownIcon),
/* harmony export */   moveUpIcon: () => (/* binding */ moveUpIcon),
/* harmony export */   newFolderIcon: () => (/* binding */ newFolderIcon),
/* harmony export */   notTrustedIcon: () => (/* binding */ notTrustedIcon),
/* harmony export */   notebookIcon: () => (/* binding */ notebookIcon),
/* harmony export */   numberingIcon: () => (/* binding */ numberingIcon),
/* harmony export */   offlineBoltIcon: () => (/* binding */ offlineBoltIcon),
/* harmony export */   openKernelSourceIcon: () => (/* binding */ openKernelSourceIcon),
/* harmony export */   paletteIcon: () => (/* binding */ paletteIcon),
/* harmony export */   pasteIcon: () => (/* binding */ pasteIcon),
/* harmony export */   pauseIcon: () => (/* binding */ pauseIcon),
/* harmony export */   pdfIcon: () => (/* binding */ pdfIcon),
/* harmony export */   pythonIcon: () => (/* binding */ pythonIcon),
/* harmony export */   rKernelIcon: () => (/* binding */ rKernelIcon),
/* harmony export */   reactIcon: () => (/* binding */ reactIcon),
/* harmony export */   redoIcon: () => (/* binding */ redoIcon),
/* harmony export */   refreshIcon: () => (/* binding */ refreshIcon),
/* harmony export */   regexIcon: () => (/* binding */ regexIcon),
/* harmony export */   runIcon: () => (/* binding */ runIcon),
/* harmony export */   runningIcon: () => (/* binding */ runningIcon),
/* harmony export */   saveIcon: () => (/* binding */ saveIcon),
/* harmony export */   searchIcon: () => (/* binding */ searchIcon),
/* harmony export */   settingsIcon: () => (/* binding */ settingsIcon),
/* harmony export */   shareIcon: () => (/* binding */ shareIcon),
/* harmony export */   spreadsheetIcon: () => (/* binding */ spreadsheetIcon),
/* harmony export */   stepIntoIcon: () => (/* binding */ stepIntoIcon),
/* harmony export */   stepOutIcon: () => (/* binding */ stepOutIcon),
/* harmony export */   stepOverIcon: () => (/* binding */ stepOverIcon),
/* harmony export */   stopIcon: () => (/* binding */ stopIcon),
/* harmony export */   tabIcon: () => (/* binding */ tabIcon),
/* harmony export */   tableRowsIcon: () => (/* binding */ tableRowsIcon),
/* harmony export */   tagIcon: () => (/* binding */ tagIcon),
/* harmony export */   terminalIcon: () => (/* binding */ terminalIcon),
/* harmony export */   textEditorIcon: () => (/* binding */ textEditorIcon),
/* harmony export */   tocIcon: () => (/* binding */ tocIcon),
/* harmony export */   treeViewIcon: () => (/* binding */ treeViewIcon),
/* harmony export */   trustedIcon: () => (/* binding */ trustedIcon),
/* harmony export */   undoIcon: () => (/* binding */ undoIcon),
/* harmony export */   userIcon: () => (/* binding */ userIcon),
/* harmony export */   usersIcon: () => (/* binding */ usersIcon),
/* harmony export */   variableIcon: () => (/* binding */ variableIcon),
/* harmony export */   vegaIcon: () => (/* binding */ vegaIcon),
/* harmony export */   viewBreakpointIcon: () => (/* binding */ viewBreakpointIcon),
/* harmony export */   wordIcon: () => (/* binding */ wordIcon),
/* harmony export */   yamlIcon: () => (/* binding */ yamlIcon)
/* harmony export */ });
/* harmony import */ var _labicon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./labicon */ "../../node_modules/@jupyterlab/ui-components/lib/icon/labicon.js");
/* harmony import */ var _style_icons_toolbar_add_above_svg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../style/icons/toolbar/add-above.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/add-above.svg");
/* harmony import */ var _style_icons_toolbar_add_below_svg__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../style/icons/toolbar/add-below.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/add-below.svg");
/* harmony import */ var _style_icons_toolbar_add_svg__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../style/icons/toolbar/add.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/add.svg");
/* harmony import */ var _style_icons_statusbar_bell_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../style/icons/statusbar/bell.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/bell.svg");
/* harmony import */ var _style_icons_toolbar_bug_dot_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../style/icons/toolbar/bug-dot.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/bug-dot.svg");
/* harmony import */ var _style_icons_toolbar_bug_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../style/icons/toolbar/bug.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/bug.svg");
/* harmony import */ var _style_icons_sidebar_build_svg__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../style/icons/sidebar/build.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/build.svg");
/* harmony import */ var _style_icons_arrow_caret_down_empty_svg__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../style/icons/arrow/caret-down-empty.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-down-empty.svg");
/* harmony import */ var _style_icons_arrow_caret_down_empty_thin_svg__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../style/icons/arrow/caret-down-empty-thin.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-down-empty-thin.svg");
/* harmony import */ var _style_icons_arrow_caret_down_svg__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../style/icons/arrow/caret-down.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-down.svg");
/* harmony import */ var _style_icons_arrow_caret_left_svg__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../style/icons/arrow/caret-left.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-left.svg");
/* harmony import */ var _style_icons_arrow_caret_right_svg__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../style/icons/arrow/caret-right.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-right.svg");
/* harmony import */ var _style_icons_arrow_caret_up_empty_thin_svg__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../style/icons/arrow/caret-up-empty-thin.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-up-empty-thin.svg");
/* harmony import */ var _style_icons_arrow_caret_up_svg__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../style/icons/arrow/caret-up.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-up.svg");
/* harmony import */ var _style_icons_search_case_sensitive_svg__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../style/icons/search/case-sensitive.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/search/case-sensitive.svg");
/* harmony import */ var _style_icons_toolbar_check_svg__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../style/icons/toolbar/check.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/check.svg");
/* harmony import */ var _style_icons_toolbar_circle_empty_svg__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../style/icons/toolbar/circle-empty.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/circle-empty.svg");
/* harmony import */ var _style_icons_toolbar_circle_svg__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../style/icons/toolbar/circle.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/circle.svg");
/* harmony import */ var _style_icons_toolbar_cleaning_svg__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../style/icons/toolbar/cleaning.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/cleaning.svg");
/* harmony import */ var _style_icons_toolbar_clear_svg__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../style/icons/toolbar/clear.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/clear.svg");
/* harmony import */ var _style_icons_debugger_close_all_svg__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../style/icons/debugger/close-all.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/close-all.svg");
/* harmony import */ var _style_icons_toolbar_close_svg__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../style/icons/toolbar/close.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/close.svg");
/* harmony import */ var _style_icons_lsp_code_check_svg__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../style/icons/lsp/code-check.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/lsp/code-check.svg");
/* harmony import */ var _style_icons_toolbar_code_svg__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../style/icons/toolbar/code.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/code.svg");
/* harmony import */ var _style_icons_toolbar_collapse_all_svg__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../style/icons/toolbar/collapse-all.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/collapse-all.svg");
/* harmony import */ var _style_icons_output_collapse_svg__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../style/icons/output/collapse.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/output/collapse.svg");
/* harmony import */ var _style_icons_filetype_console_svg__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../style/icons/filetype/console.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/console.svg");
/* harmony import */ var _style_icons_toolbar_copy_svg__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../style/icons/toolbar/copy.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/copy.svg");
/* harmony import */ var _style_icons_licenses_copyright_svg__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../../style/icons/licenses/copyright.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/licenses/copyright.svg");
/* harmony import */ var _style_icons_toolbar_cut_svg__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../../style/icons/toolbar/cut.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/cut.svg");
/* harmony import */ var _style_icons_toolbar_delete_svg__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../../style/icons/toolbar/delete.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/delete.svg");
/* harmony import */ var _style_icons_toolbar_dock_bottom_svg__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../../style/icons/toolbar/dock-bottom.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dock-bottom.svg");
/* harmony import */ var _style_icons_toolbar_dock_left_svg__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../../style/icons/toolbar/dock-left.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dock-left.svg");
/* harmony import */ var _style_icons_toolbar_dock_right_svg__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../../style/icons/toolbar/dock-right.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dock-right.svg");
/* harmony import */ var _style_icons_toolbar_dock_top_svg__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ../../style/icons/toolbar/dock-top.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dock-top.svg");
/* harmony import */ var _style_icons_toolbar_dots_svg__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ../../style/icons/toolbar/dots.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dots.svg");
/* harmony import */ var _style_icons_toolbar_download_svg__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ../../style/icons/toolbar/download.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/download.svg");
/* harmony import */ var _style_icons_toolbar_duplicate_svg__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ../../style/icons/toolbar/duplicate.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/duplicate.svg");
/* harmony import */ var _style_icons_toolbar_edit_svg__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ../../style/icons/toolbar/edit.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/edit.svg");
/* harmony import */ var _style_icons_toolbar_ellipses_svg__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ../../style/icons/toolbar/ellipses.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/ellipses.svg");
/* harmony import */ var _style_icons_error_svg__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ../../style/icons/error.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/error.svg");
/* harmony import */ var _style_icons_debugger_exceptions_svg__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ../../style/icons/debugger/exceptions.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/exceptions.svg");
/* harmony import */ var _style_icons_toolbar_expand_all_svg__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ../../style/icons/toolbar/expand-all.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/expand-all.svg");
/* harmony import */ var _style_icons_output_expand_svg__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ../../style/icons/output/expand.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/output/expand.svg");
/* harmony import */ var _style_icons_sidebar_extension_svg__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ../../style/icons/sidebar/extension.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/extension.svg");
/* harmony import */ var _style_icons_toolbar_fast_forward_svg__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ../../style/icons/toolbar/fast-forward.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/fast-forward.svg");
/* harmony import */ var _style_icons_filetype_file_svg__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ../../style/icons/filetype/file.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/file.svg");
/* harmony import */ var _style_icons_toolbar_file_upload_svg__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ../../style/icons/toolbar/file-upload.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/file-upload.svg");
/* harmony import */ var _style_icons_search_filter_dot_svg__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ../../style/icons/search/filter-dot.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/search/filter-dot.svg");
/* harmony import */ var _style_icons_toolbar_filter_list_svg__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ../../style/icons/toolbar/filter-list.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/filter-list.svg");
/* harmony import */ var _style_icons_search_filter_svg__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ../../style/icons/search/filter.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/search/filter.svg");
/* harmony import */ var _style_icons_filetype_folder_favorite_svg__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ../../style/icons/filetype/folder-favorite.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/folder-favorite.svg");
/* harmony import */ var _style_icons_filetype_folder_svg__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ../../style/icons/filetype/folder.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/folder.svg");
/* harmony import */ var _style_icons_history_svg__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ../../style/icons/history.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/history.svg");
/* harmony import */ var _style_icons_filetype_home_svg__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ../../style/icons/filetype/home.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/home.svg");
/* harmony import */ var _style_icons_filetype_html5_svg__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ../../style/icons/filetype/html5.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/html5.svg");
/* harmony import */ var _style_icons_filetype_image_svg__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ../../style/icons/filetype/image.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/image.svg");
/* harmony import */ var _style_icons_info_svg__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ../../style/icons/info.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/info.svg");
/* harmony import */ var _style_icons_filetype_inspector_svg__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ../../style/icons/filetype/inspector.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/inspector.svg");
/* harmony import */ var _style_icons_filetype_json_svg__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ../../style/icons/filetype/json.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/json.svg");
/* harmony import */ var _style_icons_filetype_julia_svg__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ../../style/icons/filetype/julia.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/julia.svg");
/* harmony import */ var _style_icons_jupyter_jupyter_favicon_svg__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ../../style/icons/jupyter/jupyter-favicon.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/jupyter/jupyter-favicon.svg");
/* harmony import */ var _style_icons_jupyter_jupyter_svg__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ../../style/icons/jupyter/jupyter.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/jupyter/jupyter.svg");
/* harmony import */ var _style_icons_jupyter_jupyterlab_wordmark_svg__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ../../style/icons/jupyter/jupyterlab-wordmark.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/jupyter/jupyterlab-wordmark.svg");
/* harmony import */ var _style_icons_statusbar_kernel_svg__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ../../style/icons/statusbar/kernel.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/kernel.svg");
/* harmony import */ var _style_icons_filetype_keyboard_svg__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! ../../style/icons/filetype/keyboard.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/keyboard.svg");
/* harmony import */ var _style_icons_toolbar_launch_svg__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! ../../style/icons/toolbar/launch.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/launch.svg");
/* harmony import */ var _style_icons_filetype_launcher_svg__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! ../../style/icons/filetype/launcher.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/launcher.svg");
/* harmony import */ var _style_icons_statusbar_line_form_svg__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! ../../style/icons/statusbar/line-form.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/line-form.svg");
/* harmony import */ var _style_icons_toolbar_link_svg__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! ../../style/icons/toolbar/link.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/link.svg");
/* harmony import */ var _style_icons_statusbar_list_svg__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! ../../style/icons/statusbar/list.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/list.svg");
/* harmony import */ var _style_icons_lock_svg__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! ../../style/icons/lock.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/lock.svg");
/* harmony import */ var _style_icons_filetype_markdown_svg__WEBPACK_IMPORTED_MODULE_73__ = __webpack_require__(/*! ../../style/icons/filetype/markdown.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/markdown.svg");
/* harmony import */ var _style_icons_filetype_mermaid_svg__WEBPACK_IMPORTED_MODULE_74__ = __webpack_require__(/*! ../../style/icons/filetype/mermaid.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/mermaid.svg");
/* harmony import */ var _style_icons_toolbar_move_down_svg__WEBPACK_IMPORTED_MODULE_75__ = __webpack_require__(/*! ../../style/icons/toolbar/move-down.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/move-down.svg");
/* harmony import */ var _style_icons_toolbar_move_up_svg__WEBPACK_IMPORTED_MODULE_76__ = __webpack_require__(/*! ../../style/icons/toolbar/move-up.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/move-up.svg");
/* harmony import */ var _style_icons_toolbar_new_folder_svg__WEBPACK_IMPORTED_MODULE_77__ = __webpack_require__(/*! ../../style/icons/toolbar/new-folder.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/new-folder.svg");
/* harmony import */ var _style_icons_statusbar_not_trusted_svg__WEBPACK_IMPORTED_MODULE_78__ = __webpack_require__(/*! ../../style/icons/statusbar/not-trusted.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/not-trusted.svg");
/* harmony import */ var _style_icons_filetype_notebook_svg__WEBPACK_IMPORTED_MODULE_79__ = __webpack_require__(/*! ../../style/icons/filetype/notebook.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/notebook.svg");
/* harmony import */ var _style_icons_toolbar_numbering_svg__WEBPACK_IMPORTED_MODULE_80__ = __webpack_require__(/*! ../../style/icons/toolbar/numbering.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/numbering.svg");
/* harmony import */ var _style_icons_toolbar_offline_bolt_svg__WEBPACK_IMPORTED_MODULE_81__ = __webpack_require__(/*! ../../style/icons/toolbar/offline-bolt.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/offline-bolt.svg");
/* harmony import */ var _style_icons_debugger_open_kernel_source_svg__WEBPACK_IMPORTED_MODULE_82__ = __webpack_require__(/*! ../../style/icons/debugger/open-kernel-source.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/open-kernel-source.svg");
/* harmony import */ var _style_icons_sidebar_palette_svg__WEBPACK_IMPORTED_MODULE_83__ = __webpack_require__(/*! ../../style/icons/sidebar/palette.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/palette.svg");
/* harmony import */ var _style_icons_toolbar_paste_svg__WEBPACK_IMPORTED_MODULE_84__ = __webpack_require__(/*! ../../style/icons/toolbar/paste.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/paste.svg");
/* harmony import */ var _style_icons_debugger_pause_svg__WEBPACK_IMPORTED_MODULE_85__ = __webpack_require__(/*! ../../style/icons/debugger/pause.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/pause.svg");
/* harmony import */ var _style_icons_filetype_pdf_svg__WEBPACK_IMPORTED_MODULE_86__ = __webpack_require__(/*! ../../style/icons/filetype/pdf.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/pdf.svg");
/* harmony import */ var _style_icons_filetype_python_svg__WEBPACK_IMPORTED_MODULE_87__ = __webpack_require__(/*! ../../style/icons/filetype/python.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/python.svg");
/* harmony import */ var _style_icons_filetype_r_kernel_svg__WEBPACK_IMPORTED_MODULE_88__ = __webpack_require__(/*! ../../style/icons/filetype/r-kernel.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/r-kernel.svg");
/* harmony import */ var _style_icons_filetype_react_svg__WEBPACK_IMPORTED_MODULE_89__ = __webpack_require__(/*! ../../style/icons/filetype/react.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/react.svg");
/* harmony import */ var _style_icons_toolbar_redo_svg__WEBPACK_IMPORTED_MODULE_90__ = __webpack_require__(/*! ../../style/icons/toolbar/redo.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/redo.svg");
/* harmony import */ var _style_icons_toolbar_refresh_svg__WEBPACK_IMPORTED_MODULE_91__ = __webpack_require__(/*! ../../style/icons/toolbar/refresh.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/refresh.svg");
/* harmony import */ var _style_icons_search_regex_svg__WEBPACK_IMPORTED_MODULE_92__ = __webpack_require__(/*! ../../style/icons/search/regex.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/search/regex.svg");
/* harmony import */ var _style_icons_toolbar_run_svg__WEBPACK_IMPORTED_MODULE_93__ = __webpack_require__(/*! ../../style/icons/toolbar/run.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/run.svg");
/* harmony import */ var _style_icons_sidebar_running_svg__WEBPACK_IMPORTED_MODULE_94__ = __webpack_require__(/*! ../../style/icons/sidebar/running.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/running.svg");
/* harmony import */ var _style_icons_toolbar_save_svg__WEBPACK_IMPORTED_MODULE_95__ = __webpack_require__(/*! ../../style/icons/toolbar/save.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/save.svg");
/* harmony import */ var _style_icons_toolbar_search_svg__WEBPACK_IMPORTED_MODULE_96__ = __webpack_require__(/*! ../../style/icons/toolbar/search.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/search.svg");
/* harmony import */ var _style_icons_filetype_settings_svg__WEBPACK_IMPORTED_MODULE_97__ = __webpack_require__(/*! ../../style/icons/filetype/settings.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/settings.svg");
/* harmony import */ var _style_icons_sidebar_share_svg__WEBPACK_IMPORTED_MODULE_98__ = __webpack_require__(/*! ../../style/icons/sidebar/share.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/share.svg");
/* harmony import */ var _style_icons_filetype_spreadsheet_svg__WEBPACK_IMPORTED_MODULE_99__ = __webpack_require__(/*! ../../style/icons/filetype/spreadsheet.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/spreadsheet.svg");
/* harmony import */ var _style_icons_debugger_step_into_svg__WEBPACK_IMPORTED_MODULE_100__ = __webpack_require__(/*! ../../style/icons/debugger/step-into.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/step-into.svg");
/* harmony import */ var _style_icons_debugger_step_out_svg__WEBPACK_IMPORTED_MODULE_101__ = __webpack_require__(/*! ../../style/icons/debugger/step-out.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/step-out.svg");
/* harmony import */ var _style_icons_debugger_step_over_svg__WEBPACK_IMPORTED_MODULE_102__ = __webpack_require__(/*! ../../style/icons/debugger/step-over.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/step-over.svg");
/* harmony import */ var _style_icons_toolbar_stop_svg__WEBPACK_IMPORTED_MODULE_103__ = __webpack_require__(/*! ../../style/icons/toolbar/stop.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/stop.svg");
/* harmony import */ var _style_icons_sidebar_tab_svg__WEBPACK_IMPORTED_MODULE_104__ = __webpack_require__(/*! ../../style/icons/sidebar/tab.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/tab.svg");
/* harmony import */ var _style_icons_toolbar_table_rows_svg__WEBPACK_IMPORTED_MODULE_105__ = __webpack_require__(/*! ../../style/icons/toolbar/table-rows.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/table-rows.svg");
/* harmony import */ var _style_icons_toolbar_tag_svg__WEBPACK_IMPORTED_MODULE_106__ = __webpack_require__(/*! ../../style/icons/toolbar/tag.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/tag.svg");
/* harmony import */ var _style_icons_statusbar_terminal_svg__WEBPACK_IMPORTED_MODULE_107__ = __webpack_require__(/*! ../../style/icons/statusbar/terminal.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/terminal.svg");
/* harmony import */ var _style_icons_filetype_text_editor_svg__WEBPACK_IMPORTED_MODULE_108__ = __webpack_require__(/*! ../../style/icons/filetype/text-editor.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/text-editor.svg");
/* harmony import */ var _style_icons_sidebar_toc_svg__WEBPACK_IMPORTED_MODULE_109__ = __webpack_require__(/*! ../../style/icons/sidebar/toc.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/toc.svg");
/* harmony import */ var _style_icons_toolbar_tree_view_svg__WEBPACK_IMPORTED_MODULE_110__ = __webpack_require__(/*! ../../style/icons/toolbar/tree-view.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/tree-view.svg");
/* harmony import */ var _style_icons_statusbar_trusted_svg__WEBPACK_IMPORTED_MODULE_111__ = __webpack_require__(/*! ../../style/icons/statusbar/trusted.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/trusted.svg");
/* harmony import */ var _style_icons_toolbar_undo_svg__WEBPACK_IMPORTED_MODULE_112__ = __webpack_require__(/*! ../../style/icons/toolbar/undo.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/undo.svg");
/* harmony import */ var _style_icons_sidebar_user_svg__WEBPACK_IMPORTED_MODULE_113__ = __webpack_require__(/*! ../../style/icons/sidebar/user.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/user.svg");
/* harmony import */ var _style_icons_sidebar_users_svg__WEBPACK_IMPORTED_MODULE_114__ = __webpack_require__(/*! ../../style/icons/sidebar/users.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/users.svg");
/* harmony import */ var _style_icons_debugger_variable_svg__WEBPACK_IMPORTED_MODULE_115__ = __webpack_require__(/*! ../../style/icons/debugger/variable.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/variable.svg");
/* harmony import */ var _style_icons_filetype_vega_svg__WEBPACK_IMPORTED_MODULE_116__ = __webpack_require__(/*! ../../style/icons/filetype/vega.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/vega.svg");
/* harmony import */ var _style_icons_debugger_view_breakpoint_svg__WEBPACK_IMPORTED_MODULE_117__ = __webpack_require__(/*! ../../style/icons/debugger/view-breakpoint.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/view-breakpoint.svg");
/* harmony import */ var _style_icons_search_word_svg__WEBPACK_IMPORTED_MODULE_118__ = __webpack_require__(/*! ../../style/icons/search/word.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/search/word.svg");
/* harmony import */ var _style_icons_filetype_yaml_svg__WEBPACK_IMPORTED_MODULE_119__ = __webpack_require__(/*! ../../style/icons/filetype/yaml.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/yaml.svg");
/*-----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
/* This file was auto-generated by ensureUiComponents() in @jupyterlab/buildutils */

// icon svg import statements























































































































// LabIcon instance construction
const addAboveIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:add-above', svgstr: _style_icons_toolbar_add_above_svg__WEBPACK_IMPORTED_MODULE_1__ });
const addBelowIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:add-below', svgstr: _style_icons_toolbar_add_below_svg__WEBPACK_IMPORTED_MODULE_2__ });
const addIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:add', svgstr: _style_icons_toolbar_add_svg__WEBPACK_IMPORTED_MODULE_3__ });
const bellIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:bell', svgstr: _style_icons_statusbar_bell_svg__WEBPACK_IMPORTED_MODULE_4__ });
const bugDotIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:bug-dot', svgstr: _style_icons_toolbar_bug_dot_svg__WEBPACK_IMPORTED_MODULE_5__ });
const bugIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:bug', svgstr: _style_icons_toolbar_bug_svg__WEBPACK_IMPORTED_MODULE_6__ });
const buildIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:build', svgstr: _style_icons_sidebar_build_svg__WEBPACK_IMPORTED_MODULE_7__ });
const caretDownEmptyIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:caret-down-empty', svgstr: _style_icons_arrow_caret_down_empty_svg__WEBPACK_IMPORTED_MODULE_8__ });
const caretDownEmptyThinIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:caret-down-empty-thin', svgstr: _style_icons_arrow_caret_down_empty_thin_svg__WEBPACK_IMPORTED_MODULE_9__ });
const caretDownIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:caret-down', svgstr: _style_icons_arrow_caret_down_svg__WEBPACK_IMPORTED_MODULE_10__ });
const caretLeftIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:caret-left', svgstr: _style_icons_arrow_caret_left_svg__WEBPACK_IMPORTED_MODULE_11__ });
const caretRightIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:caret-right', svgstr: _style_icons_arrow_caret_right_svg__WEBPACK_IMPORTED_MODULE_12__ });
const caretUpEmptyThinIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:caret-up-empty-thin', svgstr: _style_icons_arrow_caret_up_empty_thin_svg__WEBPACK_IMPORTED_MODULE_13__ });
const caretUpIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:caret-up', svgstr: _style_icons_arrow_caret_up_svg__WEBPACK_IMPORTED_MODULE_14__ });
const caseSensitiveIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:case-sensitive', svgstr: _style_icons_search_case_sensitive_svg__WEBPACK_IMPORTED_MODULE_15__ });
const checkIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:check', svgstr: _style_icons_toolbar_check_svg__WEBPACK_IMPORTED_MODULE_16__ });
const circleEmptyIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:circle-empty', svgstr: _style_icons_toolbar_circle_empty_svg__WEBPACK_IMPORTED_MODULE_17__ });
const circleIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:circle', svgstr: _style_icons_toolbar_circle_svg__WEBPACK_IMPORTED_MODULE_18__ });
const cleaningIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:cleaning', svgstr: _style_icons_toolbar_cleaning_svg__WEBPACK_IMPORTED_MODULE_19__ });
const clearIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:clear', svgstr: _style_icons_toolbar_clear_svg__WEBPACK_IMPORTED_MODULE_20__ });
const closeAllIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:close-all', svgstr: _style_icons_debugger_close_all_svg__WEBPACK_IMPORTED_MODULE_21__ });
const closeIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:close', svgstr: _style_icons_toolbar_close_svg__WEBPACK_IMPORTED_MODULE_22__ });
const codeCheckIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:code-check', svgstr: _style_icons_lsp_code_check_svg__WEBPACK_IMPORTED_MODULE_23__ });
const codeIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:code', svgstr: _style_icons_toolbar_code_svg__WEBPACK_IMPORTED_MODULE_24__ });
const collapseAllIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:collapse-all', svgstr: _style_icons_toolbar_collapse_all_svg__WEBPACK_IMPORTED_MODULE_25__ });
const collapseIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:collapse', svgstr: _style_icons_output_collapse_svg__WEBPACK_IMPORTED_MODULE_26__ });
const consoleIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:console', svgstr: _style_icons_filetype_console_svg__WEBPACK_IMPORTED_MODULE_27__ });
const copyIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:copy', svgstr: _style_icons_toolbar_copy_svg__WEBPACK_IMPORTED_MODULE_28__ });
const copyrightIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:copyright', svgstr: _style_icons_licenses_copyright_svg__WEBPACK_IMPORTED_MODULE_29__ });
const cutIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:cut', svgstr: _style_icons_toolbar_cut_svg__WEBPACK_IMPORTED_MODULE_30__ });
const deleteIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:delete', svgstr: _style_icons_toolbar_delete_svg__WEBPACK_IMPORTED_MODULE_31__ });
const dockBottomIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:dock-bottom', svgstr: _style_icons_toolbar_dock_bottom_svg__WEBPACK_IMPORTED_MODULE_32__ });
const dockLeftIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:dock-left', svgstr: _style_icons_toolbar_dock_left_svg__WEBPACK_IMPORTED_MODULE_33__ });
const dockRightIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:dock-right', svgstr: _style_icons_toolbar_dock_right_svg__WEBPACK_IMPORTED_MODULE_34__ });
const dockTopIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:dock-top', svgstr: _style_icons_toolbar_dock_top_svg__WEBPACK_IMPORTED_MODULE_35__ });
const dotsIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:dots', svgstr: _style_icons_toolbar_dots_svg__WEBPACK_IMPORTED_MODULE_36__ });
const downloadIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:download', svgstr: _style_icons_toolbar_download_svg__WEBPACK_IMPORTED_MODULE_37__ });
const duplicateIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:duplicate', svgstr: _style_icons_toolbar_duplicate_svg__WEBPACK_IMPORTED_MODULE_38__ });
const editIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:edit', svgstr: _style_icons_toolbar_edit_svg__WEBPACK_IMPORTED_MODULE_39__ });
const ellipsesIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:ellipses', svgstr: _style_icons_toolbar_ellipses_svg__WEBPACK_IMPORTED_MODULE_40__ });
const errorIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:error', svgstr: _style_icons_error_svg__WEBPACK_IMPORTED_MODULE_41__ });
const exceptionsIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:exceptions', svgstr: _style_icons_debugger_exceptions_svg__WEBPACK_IMPORTED_MODULE_42__ });
const expandAllIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:expand-all', svgstr: _style_icons_toolbar_expand_all_svg__WEBPACK_IMPORTED_MODULE_43__ });
const expandIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:expand', svgstr: _style_icons_output_expand_svg__WEBPACK_IMPORTED_MODULE_44__ });
const extensionIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:extension', svgstr: _style_icons_sidebar_extension_svg__WEBPACK_IMPORTED_MODULE_45__ });
const fastForwardIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:fast-forward', svgstr: _style_icons_toolbar_fast_forward_svg__WEBPACK_IMPORTED_MODULE_46__ });
const fileIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:file', svgstr: _style_icons_filetype_file_svg__WEBPACK_IMPORTED_MODULE_47__ });
const fileUploadIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:file-upload', svgstr: _style_icons_toolbar_file_upload_svg__WEBPACK_IMPORTED_MODULE_48__ });
const filterDotIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:filter-dot', svgstr: _style_icons_search_filter_dot_svg__WEBPACK_IMPORTED_MODULE_49__ });
const filterIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:filter', svgstr: _style_icons_search_filter_svg__WEBPACK_IMPORTED_MODULE_51__ });
const filterListIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:filter-list', svgstr: _style_icons_toolbar_filter_list_svg__WEBPACK_IMPORTED_MODULE_50__ });
const folderFavoriteIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:folder-favorite', svgstr: _style_icons_filetype_folder_favorite_svg__WEBPACK_IMPORTED_MODULE_52__ });
const folderIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:folder', svgstr: _style_icons_filetype_folder_svg__WEBPACK_IMPORTED_MODULE_53__ });
const historyIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:history', svgstr: _style_icons_history_svg__WEBPACK_IMPORTED_MODULE_54__ });
const homeIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:home', svgstr: _style_icons_filetype_home_svg__WEBPACK_IMPORTED_MODULE_55__ });
const html5Icon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:html5', svgstr: _style_icons_filetype_html5_svg__WEBPACK_IMPORTED_MODULE_56__ });
const imageIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:image', svgstr: _style_icons_filetype_image_svg__WEBPACK_IMPORTED_MODULE_57__ });
const infoIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:info', svgstr: _style_icons_info_svg__WEBPACK_IMPORTED_MODULE_58__ });
const inspectorIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:inspector', svgstr: _style_icons_filetype_inspector_svg__WEBPACK_IMPORTED_MODULE_59__ });
const jsonIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:json', svgstr: _style_icons_filetype_json_svg__WEBPACK_IMPORTED_MODULE_60__ });
const juliaIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:julia', svgstr: _style_icons_filetype_julia_svg__WEBPACK_IMPORTED_MODULE_61__ });
const jupyterFaviconIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:jupyter-favicon', svgstr: _style_icons_jupyter_jupyter_favicon_svg__WEBPACK_IMPORTED_MODULE_62__ });
const jupyterIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:jupyter', svgstr: _style_icons_jupyter_jupyter_svg__WEBPACK_IMPORTED_MODULE_63__ });
const jupyterlabWordmarkIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:jupyterlab-wordmark', svgstr: _style_icons_jupyter_jupyterlab_wordmark_svg__WEBPACK_IMPORTED_MODULE_64__ });
const kernelIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:kernel', svgstr: _style_icons_statusbar_kernel_svg__WEBPACK_IMPORTED_MODULE_65__ });
const keyboardIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:keyboard', svgstr: _style_icons_filetype_keyboard_svg__WEBPACK_IMPORTED_MODULE_66__ });
const launchIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:launch', svgstr: _style_icons_toolbar_launch_svg__WEBPACK_IMPORTED_MODULE_67__ });
const launcherIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:launcher', svgstr: _style_icons_filetype_launcher_svg__WEBPACK_IMPORTED_MODULE_68__ });
const lineFormIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:line-form', svgstr: _style_icons_statusbar_line_form_svg__WEBPACK_IMPORTED_MODULE_69__ });
const linkIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:link', svgstr: _style_icons_toolbar_link_svg__WEBPACK_IMPORTED_MODULE_70__ });
const listIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:list', svgstr: _style_icons_statusbar_list_svg__WEBPACK_IMPORTED_MODULE_71__ });
const lockIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:lock', svgstr: _style_icons_lock_svg__WEBPACK_IMPORTED_MODULE_72__ });
const markdownIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:markdown', svgstr: _style_icons_filetype_markdown_svg__WEBPACK_IMPORTED_MODULE_73__ });
const mermaidIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:mermaid', svgstr: _style_icons_filetype_mermaid_svg__WEBPACK_IMPORTED_MODULE_74__ });
const moveDownIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:move-down', svgstr: _style_icons_toolbar_move_down_svg__WEBPACK_IMPORTED_MODULE_75__ });
const moveUpIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:move-up', svgstr: _style_icons_toolbar_move_up_svg__WEBPACK_IMPORTED_MODULE_76__ });
const newFolderIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:new-folder', svgstr: _style_icons_toolbar_new_folder_svg__WEBPACK_IMPORTED_MODULE_77__ });
const notTrustedIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:not-trusted', svgstr: _style_icons_statusbar_not_trusted_svg__WEBPACK_IMPORTED_MODULE_78__ });
const notebookIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:notebook', svgstr: _style_icons_filetype_notebook_svg__WEBPACK_IMPORTED_MODULE_79__ });
const numberingIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:numbering', svgstr: _style_icons_toolbar_numbering_svg__WEBPACK_IMPORTED_MODULE_80__ });
const offlineBoltIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:offline-bolt', svgstr: _style_icons_toolbar_offline_bolt_svg__WEBPACK_IMPORTED_MODULE_81__ });
const openKernelSourceIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:open-kernel-source', svgstr: _style_icons_debugger_open_kernel_source_svg__WEBPACK_IMPORTED_MODULE_82__ });
const paletteIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:palette', svgstr: _style_icons_sidebar_palette_svg__WEBPACK_IMPORTED_MODULE_83__ });
const pasteIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:paste', svgstr: _style_icons_toolbar_paste_svg__WEBPACK_IMPORTED_MODULE_84__ });
const pauseIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:pause', svgstr: _style_icons_debugger_pause_svg__WEBPACK_IMPORTED_MODULE_85__ });
const pdfIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:pdf', svgstr: _style_icons_filetype_pdf_svg__WEBPACK_IMPORTED_MODULE_86__ });
const pythonIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:python', svgstr: _style_icons_filetype_python_svg__WEBPACK_IMPORTED_MODULE_87__ });
const rKernelIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:r-kernel', svgstr: _style_icons_filetype_r_kernel_svg__WEBPACK_IMPORTED_MODULE_88__ });
const reactIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:react', svgstr: _style_icons_filetype_react_svg__WEBPACK_IMPORTED_MODULE_89__ });
const redoIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:redo', svgstr: _style_icons_toolbar_redo_svg__WEBPACK_IMPORTED_MODULE_90__ });
const refreshIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:refresh', svgstr: _style_icons_toolbar_refresh_svg__WEBPACK_IMPORTED_MODULE_91__ });
const regexIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:regex', svgstr: _style_icons_search_regex_svg__WEBPACK_IMPORTED_MODULE_92__ });
const runIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:run', svgstr: _style_icons_toolbar_run_svg__WEBPACK_IMPORTED_MODULE_93__ });
const runningIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:running', svgstr: _style_icons_sidebar_running_svg__WEBPACK_IMPORTED_MODULE_94__ });
const saveIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:save', svgstr: _style_icons_toolbar_save_svg__WEBPACK_IMPORTED_MODULE_95__ });
const searchIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:search', svgstr: _style_icons_toolbar_search_svg__WEBPACK_IMPORTED_MODULE_96__ });
const settingsIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:settings', svgstr: _style_icons_filetype_settings_svg__WEBPACK_IMPORTED_MODULE_97__ });
const shareIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:share', svgstr: _style_icons_sidebar_share_svg__WEBPACK_IMPORTED_MODULE_98__ });
const spreadsheetIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:spreadsheet', svgstr: _style_icons_filetype_spreadsheet_svg__WEBPACK_IMPORTED_MODULE_99__ });
const stepIntoIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:step-into', svgstr: _style_icons_debugger_step_into_svg__WEBPACK_IMPORTED_MODULE_100__ });
const stepOutIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:step-out', svgstr: _style_icons_debugger_step_out_svg__WEBPACK_IMPORTED_MODULE_101__ });
const stepOverIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:step-over', svgstr: _style_icons_debugger_step_over_svg__WEBPACK_IMPORTED_MODULE_102__ });
const stopIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:stop', svgstr: _style_icons_toolbar_stop_svg__WEBPACK_IMPORTED_MODULE_103__ });
const tabIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:tab', svgstr: _style_icons_sidebar_tab_svg__WEBPACK_IMPORTED_MODULE_104__ });
const tableRowsIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:table-rows', svgstr: _style_icons_toolbar_table_rows_svg__WEBPACK_IMPORTED_MODULE_105__ });
const tagIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:tag', svgstr: _style_icons_toolbar_tag_svg__WEBPACK_IMPORTED_MODULE_106__ });
const terminalIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:terminal', svgstr: _style_icons_statusbar_terminal_svg__WEBPACK_IMPORTED_MODULE_107__ });
const textEditorIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:text-editor', svgstr: _style_icons_filetype_text_editor_svg__WEBPACK_IMPORTED_MODULE_108__ });
const tocIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:toc', svgstr: _style_icons_sidebar_toc_svg__WEBPACK_IMPORTED_MODULE_109__ });
const treeViewIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:tree-view', svgstr: _style_icons_toolbar_tree_view_svg__WEBPACK_IMPORTED_MODULE_110__ });
const trustedIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:trusted', svgstr: _style_icons_statusbar_trusted_svg__WEBPACK_IMPORTED_MODULE_111__ });
const undoIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:undo', svgstr: _style_icons_toolbar_undo_svg__WEBPACK_IMPORTED_MODULE_112__ });
const userIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:user', svgstr: _style_icons_sidebar_user_svg__WEBPACK_IMPORTED_MODULE_113__ });
const usersIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:users', svgstr: _style_icons_sidebar_users_svg__WEBPACK_IMPORTED_MODULE_114__ });
const variableIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:variable', svgstr: _style_icons_debugger_variable_svg__WEBPACK_IMPORTED_MODULE_115__ });
const vegaIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:vega', svgstr: _style_icons_filetype_vega_svg__WEBPACK_IMPORTED_MODULE_116__ });
const viewBreakpointIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:view-breakpoint', svgstr: _style_icons_debugger_view_breakpoint_svg__WEBPACK_IMPORTED_MODULE_117__ });
const wordIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:word', svgstr: _style_icons_search_word_svg__WEBPACK_IMPORTED_MODULE_118__ });
const yamlIcon = new _labicon__WEBPACK_IMPORTED_MODULE_0__.LabIcon({ name: 'ui-components:yaml', svgstr: _style_icons_filetype_yaml_svg__WEBPACK_IMPORTED_MODULE_119__ });


/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/lib/icon/labicon.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/lib/icon/labicon.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LabIcon: () => (/* binding */ LabIcon),
/* harmony export */   badIcon: () => (/* binding */ badIcon),
/* harmony export */   blankIcon: () => (/* binding */ blankIcon)
/* harmony export */ });
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @lumino/coreutils */ "webpack/sharing/consume/default/@lumino/coreutils");
/* harmony import */ var _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @lumino/signaling */ "webpack/sharing/consume/default/@lumino/signaling");
/* harmony import */ var _lumino_signaling__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_lumino_signaling__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_dom_client__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-dom/client */ "../../node_modules/react-dom/client.js");
/* harmony import */ var _style_debug_bad_svg__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../style/debug/bad.svg */ "../../node_modules/@jupyterlab/ui-components/style/debug/bad.svg");
/* harmony import */ var _style_debug_blank_svg__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../style/debug/blank.svg */ "../../node_modules/@jupyterlab/ui-components/style/debug/blank.svg");
/* harmony import */ var _style_icons_toolbar_refresh_svg__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../style/icons/toolbar/refresh.svg */ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/refresh.svg");
/* harmony import */ var _style__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../style */ "../../node_modules/@jupyterlab/ui-components/lib/style/icon.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils */ "../../node_modules/@jupyterlab/ui-components/lib/utils.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.









class LabIcon {
    /** *********
     * statics *
     ***********/
    /**
     * Remove any rendered icon from the element that contains it
     *
     * @param container - a DOM node into which an icon was
     * previously rendered
     *
     * @returns the cleaned container
     */
    static remove(container) {
        // clean up all children
        while (container.firstChild) {
            container.firstChild.remove();
        }
        // remove all classes
        container.className = '';
        return container;
    }
    /**
     * Resolve an icon name or a \{name, svgstr\} pair into an
     * actual LabIcon.
     *
     * @param options - icon: either a string with the name of an existing icon
     * or an object with \{name: string, svgstr: string\} fields.
     *
     * @returns a LabIcon instance
     */
    static resolve({ icon }) {
        if (icon instanceof LabIcon) {
            // icon already is a LabIcon; nothing to do here
            return icon;
        }
        if (typeof icon === 'string') {
            // do a dynamic lookup of existing icon by name
            const resolved = LabIcon._instances.get(icon);
            if (resolved) {
                return resolved;
            }
            // lookup failed
            if (LabIcon._debug) {
                // fail noisily
                console.warn(`Lookup failed for icon, creating loading icon. icon: ${icon}`);
            }
            // no matching icon currently registered, create a new loading icon
            // TODO: find better icon (maybe animate?) for loading icon
            return new LabIcon({ name: icon, svgstr: _style_icons_toolbar_refresh_svg__WEBPACK_IMPORTED_MODULE_6__, _loading: true });
        }
        // icon was provided as a non-LabIcon \{name, svgstr\} pair, communicating
        // an intention to create a new icon
        return new LabIcon(icon);
    }
    /**
     * Resolve an icon name or a \{name, svgstr\} pair into a DOM element.
     * If icon arg is undefined, the function will fall back to trying to render
     * the icon as a CSS background image, via the iconClass arg.
     * If both icon and iconClass are undefined, this function will return
     * an empty div.
     *
     * @param icon - optional, either a string with the name of an existing icon
     * or an object with \{name: string, svgstr: string\} fields
     *
     * @param iconClass - optional, if the icon arg is not set, the iconClass arg
     * should be a CSS class associated with an existing CSS background-image
     *
     * @param fallback - DEPRECATED, optional, a LabIcon instance that will
     * be used if neither icon nor iconClass are defined
     *
     * @param props - any additional args are passed though to the element method
     * of the resolved icon on render
     *
     * @returns a DOM node with the resolved icon rendered into it
     */
    static resolveElement({ icon, iconClass, fallback, ...props }) {
        if (!Private.isResolvable(icon)) {
            if (!iconClass && fallback) {
                // if neither icon nor iconClass are defined/resolvable, use fallback
                return fallback.element(props);
            }
            // set the icon's class to iconClass plus props.className
            props.className = (0,_utils__WEBPACK_IMPORTED_MODULE_8__.classes)(iconClass, props.className);
            // render icon as css background image, assuming one is set on iconClass
            return Private.blankElement(props);
        }
        return LabIcon.resolve({ icon }).element(props);
    }
    /**
     * Resolve an icon name or a \{name, svgstr\} pair into a React component.
     * If icon arg is undefined, the function will fall back to trying to render
     * the icon as a CSS background image, via the iconClass arg.
     * If both icon and iconClass are undefined, the returned component
     * will simply render an empty div.
     *
     * @param icon - optional, either a string with the name of an existing icon
     * or an object with \{name: string, svgstr: string\} fields
     *
     * @param iconClass - optional, if the icon arg is not set, the iconClass arg
     * should be a CSS class associated with an existing CSS background-image
     *
     * @param fallback - DEPRECATED, optional, a LabIcon instance that will
     * be used if neither icon nor iconClass are defined
     *
     * @param props - any additional args are passed though to the React component
     * of the resolved icon on render
     *
     * @returns a React component that will render the resolved icon
     */
    static resolveReact({ icon, iconClass, fallback, ...props }) {
        if (!Private.isResolvable(icon)) {
            if (!iconClass && fallback) {
                // if neither icon nor iconClass are defined/resolvable, use fallback
                return react__WEBPACK_IMPORTED_MODULE_2___default().createElement(fallback.react, { ...props });
            }
            // set the icon's class to iconClass plus props.className
            props.className = (0,_utils__WEBPACK_IMPORTED_MODULE_8__.classes)(iconClass, props.className);
            // render icon as css background image, assuming one is set on iconClass
            return react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Private.blankReact, { ...props });
        }
        const resolved = LabIcon.resolve({ icon });
        return react__WEBPACK_IMPORTED_MODULE_2___default().createElement(resolved.react, { ...props });
    }
    /**
     * Resolve a \{name, svgstr\} pair into an actual svg node.
     */
    static resolveSvg({ name, svgstr }) {
        const svgDoc = new DOMParser().parseFromString(Private.svgstrShim(svgstr), 'image/svg+xml');
        const svgError = svgDoc.querySelector('parsererror');
        // structure of error element varies by browser, search at top level
        if (svgError) {
            // parse failed, svgElement will be an error box
            const errmsg = `SVG HTML was malformed for LabIcon instance.\nname: ${name}, svgstr: ${svgstr}`;
            if (LabIcon._debug) {
                // fail noisily, render the error box
                console.error(errmsg);
                return svgError;
            }
            else {
                // bad svg is always a real error, fail silently but warn
                console.warn(errmsg);
                return null;
            }
        }
        else {
            // parse succeeded
            return svgDoc.documentElement;
        }
    }
    /**
     * Toggle icon debug from off-to-on, or vice-versa.
     *
     * @param debug - optional boolean to force debug on or off
     */
    static toggleDebug(debug) {
        LabIcon._debug = debug !== null && debug !== void 0 ? debug : !LabIcon._debug;
    }
    /** *********
     * members *
     ***********/
    constructor({ name, svgstr, render, unrender, _loading = false }) {
        this._props = {};
        this._svgReplaced = new _lumino_signaling__WEBPACK_IMPORTED_MODULE_1__.Signal(this);
        /**
         * Cache for svg parsing intermediates
         *   - undefined: the cache has not yet been populated
         *   - null: a valid, but empty, value
         */
        this._svgElement = undefined;
        this._svgInnerHTML = undefined;
        this._svgReactAttrs = undefined;
        if (!(name && svgstr)) {
            // sanity check failed
            console.error(`When defining a new LabIcon, name and svgstr must both be non-empty strings. name: ${name}, svgstr: ${svgstr}`);
            return badIcon;
        }
        // currently this needs to be set early, before checks for existing icons
        this._loading = _loading;
        // check to see if this is a redefinition of an existing icon
        if (LabIcon._instances.has(name)) {
            // fetch the existing icon, replace its svg, then return it
            const icon = LabIcon._instances.get(name);
            if (this._loading) {
                // replace the placeholder svg in icon
                icon.svgstr = svgstr;
                this._loading = false;
                return icon;
            }
            else {
                // already loaded icon svg exists; replace it and warn
                if (LabIcon._debug) {
                    console.warn(`Redefining previously loaded icon svgstr. name: ${name}, svgstrOld: ${icon.svgstr}, svgstr: ${svgstr}`);
                }
                icon.svgstr = svgstr;
                return icon;
            }
        }
        this.name = name;
        this.react = this._initReact(name);
        this.svgstr = svgstr;
        // setup custom render/unrender methods, if passed in
        this._initRender({ render, unrender });
        LabIcon._instances.set(this.name, this);
    }
    /**
     * Get a view of this icon that is bound to the specified icon/style props
     *
     * @param optional icon/style props (same as args for .element
     * and .react methods). These will be bound to the resulting view
     *
     * @returns a view of this LabIcon instance
     */
    bindprops(props) {
        const view = Object.create(this);
        view._props = props;
        view.react = view._initReact(view.name + '_bind');
        return view;
    }
    /**
     * Create an icon as a DOM element
     *
     * @param className - a string that will be used as the class
     * of the container element. Overrides any existing class
     *
     * @param container - a preexisting DOM element that
     * will be used as the container for the svg element
     *
     * @param label - text that will be displayed adjacent
     * to the icon
     *
     * @param title - a tooltip for the icon
     *
     * @param tag - if container is not explicitly
     * provided, this tag will be used when creating the container
     *
     * @param stylesheet - optional string naming a builtin icon
     * stylesheet, for example 'menuItem' or `statusBar`. Can also be an
     * object defining a custom icon stylesheet, or a list of builtin
     * stylesheet names and/or custom stylesheet objects. If array,
     * the given stylesheets will be merged.
     *
     *   See @jupyterlab/ui-components/src/style/icon.ts for details
     *
     * @param elementPosition - optional position for the inner svg element
     *
     * @param elementSize - optional size for the inner svg element.
     * Set to 'normal' to get a standard 16px x 16px icon
     *
     * @param ...elementCSS - all additional args are treated as
     * overrides for the CSS props applied to the inner svg element
     *
     * @returns A DOM element that contains an (inline) svg element
     * that displays an icon
     */
    element(props = {}) {
        var _a;
        let { className, container, label, title, tag = 'div', ...styleProps } = { ...this._props, ...props };
        // check if icon element is already set
        const maybeSvgElement = container === null || container === void 0 ? void 0 : container.firstChild;
        if (((_a = maybeSvgElement === null || maybeSvgElement === void 0 ? void 0 : maybeSvgElement.dataset) === null || _a === void 0 ? void 0 : _a.iconId) === this._uuid) {
            // return the existing icon element
            return maybeSvgElement;
        }
        // ensure that svg html is valid
        if (!this.svgElement) {
            // bail if failing silently, return blank element
            return document.createElement('div');
        }
        if (container) {
            // take ownership by removing any existing children
            while (container.firstChild) {
                container.firstChild.remove();
            }
        }
        else if (tag) {
            // create a container if needed
            container = document.createElement(tag);
        }
        const svgElement = this.svgElement.cloneNode(true);
        if (!container) {
            if (label) {
                console.warn();
            }
            return svgElement;
        }
        if (label != null) {
            container.textContent = label;
        }
        Private.initContainer({
            container: container,
            className,
            styleProps,
            title
        });
        // add the svg node to the container
        container.appendChild(svgElement);
        return container;
    }
    render(container, options) {
        var _a;
        let label = (_a = options === null || options === void 0 ? void 0 : options.children) === null || _a === void 0 ? void 0 : _a[0];
        // narrow type of label
        if (typeof label !== 'string') {
            label = undefined;
        }
        this.element({
            container,
            label,
            ...options === null || options === void 0 ? void 0 : options.props
        });
    }
    get svgElement() {
        if (this._svgElement === undefined) {
            this._svgElement = this._initSvg({ uuid: this._uuid });
        }
        return this._svgElement;
    }
    get svgInnerHTML() {
        if (this._svgInnerHTML === undefined) {
            if (this.svgElement === null) {
                // the svg element resolved to null, mark this null too
                this._svgInnerHTML = null;
            }
            else {
                this._svgInnerHTML = this.svgElement.innerHTML;
            }
        }
        return this._svgInnerHTML;
    }
    get svgReactAttrs() {
        if (this._svgReactAttrs === undefined) {
            if (this.svgElement === null) {
                // the svg element resolved to null, mark this null too
                this._svgReactAttrs = null;
            }
            else {
                this._svgReactAttrs = (0,_utils__WEBPACK_IMPORTED_MODULE_8__.getReactAttrs)(this.svgElement, {
                    ignore: ['data-icon-id']
                });
            }
        }
        return this._svgReactAttrs;
    }
    get svgstr() {
        return this._svgstr;
    }
    set svgstr(svgstr) {
        this._svgstr = svgstr;
        // associate a new unique id with this particular svgstr
        const uuid = _lumino_coreutils__WEBPACK_IMPORTED_MODULE_0__.UUID.uuid4();
        const uuidOld = this._uuid;
        this._uuid = uuid;
        // empty the svg parsing intermediates cache
        this._svgElement = undefined;
        this._svgInnerHTML = undefined;
        this._svgReactAttrs = undefined;
        // update icon elements created using .element method
        document
            .querySelectorAll(`[data-icon-id="${uuidOld}"]`)
            .forEach(oldSvgElement => {
            if (this.svgElement) {
                oldSvgElement.replaceWith(this.svgElement.cloneNode(true));
            }
        });
        // trigger update of icon elements created using other methods
        this._svgReplaced.emit();
    }
    _initReact(displayName) {
        const component = react__WEBPACK_IMPORTED_MODULE_2___default().forwardRef((props = {}, ref) => {
            const { className, container, label, title, slot, tag = 'div', ...styleProps } = { ...this._props, ...props };
            // set up component state via useState hook
            const [, setId] = react__WEBPACK_IMPORTED_MODULE_2___default().useState(this._uuid);
            // subscribe to svg replacement via useEffect hook
            react__WEBPACK_IMPORTED_MODULE_2___default().useEffect(() => {
                const onSvgReplaced = () => {
                    setId(this._uuid);
                };
                this._svgReplaced.connect(onSvgReplaced);
                // specify cleanup callback as hook return
                return () => {
                    this._svgReplaced.disconnect(onSvgReplaced);
                };
            });
            // make it so that tag can be used as a jsx component
            const Tag = tag !== null && tag !== void 0 ? tag : (react__WEBPACK_IMPORTED_MODULE_2___default().Fragment);
            // ensure that svg html is valid
            if (!(this.svgInnerHTML && this.svgReactAttrs)) {
                // bail if failing silently
                return react__WEBPACK_IMPORTED_MODULE_2___default().createElement((react__WEBPACK_IMPORTED_MODULE_2___default().Fragment), null);
            }
            const svgProps = { ...this.svgReactAttrs };
            if (!tag) {
                Object.assign(svgProps, {
                    className: className || styleProps
                        ? (0,_utils__WEBPACK_IMPORTED_MODULE_8__.classes)(className, _style__WEBPACK_IMPORTED_MODULE_7__.LabIconStyle.styleClass(styleProps))
                        : undefined,
                    title: title,
                    slot: slot
                });
            }
            const svgComponent = (react__WEBPACK_IMPORTED_MODULE_2___default().createElement("svg", { ...svgProps, ...this.svgReactAttrs, dangerouslySetInnerHTML: { __html: this.svgInnerHTML }, ref: ref }));
            if (container) {
                Private.initContainer({ container, className, styleProps, title });
                return (react__WEBPACK_IMPORTED_MODULE_2___default().createElement((react__WEBPACK_IMPORTED_MODULE_2___default().Fragment), null,
                    svgComponent,
                    label));
            }
            else {
                let attributes = {};
                if (Tag !== (react__WEBPACK_IMPORTED_MODULE_2___default().Fragment)) {
                    attributes = {
                        className: className || styleProps
                            ? (0,_utils__WEBPACK_IMPORTED_MODULE_8__.classes)(className, _style__WEBPACK_IMPORTED_MODULE_7__.LabIconStyle.styleClass(styleProps))
                            : undefined,
                        title: title,
                        slot: slot
                    };
                }
                return (react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Tag, { ...attributes },
                    svgComponent,
                    label));
            }
        });
        component.displayName = `LabIcon_${displayName}`;
        return component;
    }
    _initRender({ render, unrender }) {
        if (render) {
            this.render = render;
            if (unrender) {
                this.unrender = unrender;
            }
        }
        else if (unrender) {
            console.warn('In _initRender, ignoring unrender arg since render is undefined');
        }
    }
    _initSvg({ title, uuid } = {}) {
        const svgElement = LabIcon.resolveSvg(this);
        if (!svgElement) {
            // bail on null svg element
            return svgElement;
        }
        if (svgElement.tagName !== 'parsererror') {
            // svgElement is an actual svg node, augment it
            svgElement.dataset.icon = this.name;
            if (uuid) {
                svgElement.dataset.iconId = uuid;
            }
            if (title) {
                Private.setTitleSvg(svgElement, title);
            }
            else {
                // mark as a decorative
                svgElement.setAttribute('aria-hidden', 'true');
            }
        }
        return svgElement;
    }
}
LabIcon._debug = false;
LabIcon._instances = new Map();
var Private;
(function (Private) {
    function blankElement({ className = '', container, label, title, tag = 'div', slot, ...styleProps }) {
        if ((container === null || container === void 0 ? void 0 : container.className) === className) {
            // nothing needs doing, return the icon node
            return container;
        }
        if (container) {
            // take ownership by removing any existing children
            while (container.firstChild) {
                container.firstChild.remove();
            }
        }
        else {
            // create a container if needed
            container = document.createElement(tag !== null && tag !== void 0 ? tag : 'div');
        }
        if (label != null) {
            container.textContent = label;
        }
        Private.initContainer({ container, className, styleProps, title });
        return container;
    }
    Private.blankElement = blankElement;
    Private.blankReact = react__WEBPACK_IMPORTED_MODULE_2___default().forwardRef(({ className = '', container, label, title, tag = 'div', ...styleProps }, ref) => {
        // make it so that tag can be used as a jsx component
        const Tag = tag !== null && tag !== void 0 ? tag : 'div';
        if (container) {
            initContainer({ container, className, styleProps, title });
            return react__WEBPACK_IMPORTED_MODULE_2___default().createElement((react__WEBPACK_IMPORTED_MODULE_2___default().Fragment), null);
        }
        else {
            // if ref is defined, we create a blank svg node and point ref to it
            return (react__WEBPACK_IMPORTED_MODULE_2___default().createElement(Tag, { className: (0,_utils__WEBPACK_IMPORTED_MODULE_8__.classes)(className, _style__WEBPACK_IMPORTED_MODULE_7__.LabIconStyle.styleClass(styleProps)) },
                ref && blankIcon.react({ ref }),
                label));
        }
    });
    Private.blankReact.displayName = 'BlankReact';
    function initContainer({ container, className, styleProps, title }) {
        if (title != null) {
            container.title = title;
        }
        const styleClass = _style__WEBPACK_IMPORTED_MODULE_7__.LabIconStyle.styleClass(styleProps);
        if (className != null) {
            // override the container class with explicitly passed-in class + style class
            const classResolved = (0,_utils__WEBPACK_IMPORTED_MODULE_8__.classes)(className, styleClass);
            container.className = classResolved;
            return classResolved;
        }
        else if (styleClass) {
            // add the style class to the container class
            container.classList.add(styleClass);
            return styleClass;
        }
        else {
            return '';
        }
    }
    Private.initContainer = initContainer;
    function isResolvable(icon) {
        return !!(icon &&
            (typeof icon === 'string' ||
                (icon.name && icon.svgstr)));
    }
    Private.isResolvable = isResolvable;
    function setTitleSvg(svgNode, title) {
        // add a title node to the top level svg node
        const titleNodes = svgNode.getElementsByTagName('title');
        if (titleNodes.length) {
            titleNodes[0].textContent = title;
        }
        else {
            const titleNode = document.createElement('title');
            titleNode.textContent = title;
            svgNode.appendChild(titleNode);
        }
    }
    Private.setTitleSvg = setTitleSvg;
    /**
     * A shim for svgstrs loaded using any loader other than raw-loader.
     * This function assumes that svgstr will look like one of:
     *
     * - the raw contents of an .svg file:
     *   <svg...</svg>
     *
     * - a data URL:
     *   data:[<mediatype>][;base64],<svg...</svg>
     *
     * See https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/Data_URIs
     */
    function svgstrShim(svgstr, strict = true) {
        // decode any uri escaping, condense leading/lagging whitespace,
        // then match to raw svg string
        const [, base64, raw] = decodeURIComponent(svgstr)
            .replace(/>\s*\n\s*</g, '><')
            .replace(/\s*\n\s*/g, ' ')
            .match(strict
            ? // match based on data url schema
                /^(?:data:.*?(;base64)?,)?(.*)/
            : // match based on open of svg tag
                /(?:(base64).*)?(<svg.*)/);
        // decode from base64, if needed
        return base64 ? atob(raw) : raw;
    }
    Private.svgstrShim = svgstrShim;
    /**
     * TODO: figure out story for independent Renderers.
     * Base implementation of IRenderer.
     */
    class Renderer {
        constructor(_icon, _rendererOptions) {
            this._icon = _icon;
            this._rendererOptions = _rendererOptions;
        }
        // eslint-disable-next-line
        render(container, options) { }
    }
    Private.Renderer = Renderer;
    /**
     * TODO: figure out story for independent Renderers.
     * Implementation of IRenderer that creates the icon svg node
     * as a DOM element.
     */
    class ElementRenderer extends Renderer {
        render(container, options) {
            var _a, _b;
            let label = (_a = options === null || options === void 0 ? void 0 : options.children) === null || _a === void 0 ? void 0 : _a[0];
            // narrow type of label
            if (typeof label !== 'string') {
                label = undefined;
            }
            this._icon.element({
                container,
                label,
                ...(_b = this._rendererOptions) === null || _b === void 0 ? void 0 : _b.props,
                ...options === null || options === void 0 ? void 0 : options.props
            });
        }
    }
    Private.ElementRenderer = ElementRenderer;
    /**
     * TODO: figure out story for independent Renderers.
     * Implementation of IRenderer that creates the icon svg node
     * as a React component.
     */
    class ReactRenderer extends Renderer {
        constructor() {
            super(...arguments);
            this._rootDOM = null;
        }
        render(container, options) {
            var _a, _b;
            let label = (_a = options === null || options === void 0 ? void 0 : options.children) === null || _a === void 0 ? void 0 : _a[0];
            // narrow type of label
            if (typeof label !== 'string') {
                label = undefined;
            }
            const icon = this._icon;
            if (this._rootDOM !== null) {
                this._rootDOM.unmount();
            }
            this._rootDOM = (0,react_dom_client__WEBPACK_IMPORTED_MODULE_3__.createRoot)(container);
            this._rootDOM.render(react__WEBPACK_IMPORTED_MODULE_2___default().createElement(icon.react, { container: container, label: label, ...(_b = this._rendererOptions) === null || _b === void 0 ? void 0 : _b.props, ...options === null || options === void 0 ? void 0 : options.props }));
        }
        unrender(container) {
            if (this._rootDOM !== null) {
                this._rootDOM.unmount();
                this._rootDOM = null;
            }
        }
    }
    Private.ReactRenderer = ReactRenderer;
})(Private || (Private = {}));
// need to be at the bottom since constructor depends on Private
const badIcon = new LabIcon({
    name: 'ui-components:bad',
    svgstr: _style_debug_bad_svg__WEBPACK_IMPORTED_MODULE_4__
});
const blankIcon = new LabIcon({
    name: 'ui-components:blank',
    svgstr: _style_debug_blank_svg__WEBPACK_IMPORTED_MODULE_5__
});


/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/lib/style/icon.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/lib/style/icon.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LabIconStyle: () => (/* binding */ LabIconStyle)
/* harmony export */ });
/* harmony import */ var typestyle_lib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! typestyle/lib */ "../../node_modules/typestyle/lib/index.js");
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

var LabIconStyle;
(function (LabIconStyle) {
    /**
     * The builtin stylesheets
     */
    const builtinSheets = {
        breadCrumb: {
            container: {
                $nest: {
                    // `&` will be substituted for the generated classname (interpolation)
                    '&:first-child svg': {
                        bottom: '1px',
                        marginLeft: '0px',
                        position: 'relative'
                    },
                    '&:hover': {
                        backgroundColor: 'var(--jp-layout-color2)'
                    },
                    ['.jp-mod-dropTarget&']: {
                        backgroundColor: 'var(--jp-brand-color2)',
                        opacity: 0.7
                    }
                }
            },
            element: {
                borderRadius: 'var(--jp-border-radius)',
                cursor: 'pointer',
                margin: '0px 2px',
                padding: '0px 2px',
                height: '16px',
                width: '16px',
                verticalAlign: 'middle'
            }
        },
        commandPaletteHeader: {
            container: {
                height: '14px',
                margin: '0 14px 0 auto'
            },
            element: {
                height: '14px',
                width: '14px'
            },
            options: {
                elementPosition: 'center'
            }
        },
        commandPaletteItem: {
            element: {
                height: '16px',
                width: '16px'
            },
            options: {
                elementPosition: 'center'
            }
        },
        launcherCard: {
            container: {
                height: '52px',
                width: '52px'
            },
            element: {
                height: '52px',
                width: '52px'
            },
            options: {
                elementPosition: 'center'
            }
        },
        launcherSection: {
            container: {
                boxSizing: 'border-box',
                marginRight: '12px',
                height: '32px',
                width: '32px'
            },
            element: {
                height: '32px',
                width: '32px'
            },
            options: {
                elementPosition: 'center'
            }
        },
        listing: {
            container: {
                flex: '0 0 20px',
                marginRight: '4px',
                position: 'relative'
            },
            element: {
                height: '16px',
                width: '16px'
            },
            options: {
                elementPosition: 'center'
            }
        },
        listingHeaderItem: {
            container: {
                display: 'inline',
                height: '16px',
                width: '16px'
            },
            element: {
                height: 'auto',
                margin: '-2px 0 0 0',
                width: '20px'
            },
            options: {
                elementPosition: 'center'
            }
        },
        mainAreaTab: {
            container: {
                $nest: {
                    '.lm-DockPanel-tabBar &': {
                        marginRight: '4px'
                    }
                }
            },
            element: {
                $nest: {
                    '.lm-DockPanel-tabBar &': {
                        height: '14px',
                        width: '14px'
                    }
                }
            },
            options: {
                elementPosition: 'center'
            }
        },
        menuItem: {
            container: {
                display: 'inline-block',
                verticalAlign: 'middle'
            },
            element: {
                height: '16px',
                width: '16px'
            },
            options: {
                elementPosition: 'center'
            }
        },
        runningItem: {
            container: {
                margin: '0px 4px 0px 4px'
            },
            element: {
                height: '16px',
                width: '16px'
            },
            options: {
                elementPosition: 'center'
            }
        },
        select: {
            container: {
                pointerEvents: 'none'
            },
            element: {
                position: 'absolute',
                height: 'auto',
                width: '16px'
            }
        },
        settingsEditor: {
            container: {
                display: 'flex',
                flex: '0 0 20px',
                margin: '0 3px 0 0',
                position: 'relative',
                height: '20px',
                width: '20px'
            },
            element: {
                height: '16px',
                width: '16px'
            },
            options: {
                elementPosition: 'center'
            }
        },
        sideBar: {
            element: {
                height: 'auto',
                width: '20px'
            },
            options: {
                elementPosition: 'center'
            }
        },
        splash: {
            container: {
                animation: '0.3s fade-in linear forwards',
                height: '100%',
                width: '100%',
                zIndex: 1
            },
            element: {
                // width no height
                width: '100px'
            },
            options: {
                elementPosition: 'center'
            }
        },
        statusBar: {
            element: {
                left: '0px',
                top: '0px',
                height: '18px',
                width: '20px',
                position: 'relative'
            }
        },
        toolbarButton: {
            container: {
                display: 'inline-block',
                verticalAlign: 'middle'
            },
            element: {
                height: '16px',
                width: '16px'
            },
            options: {
                elementPosition: 'center'
            }
        }
    };
    function _elementPositionFactory(extra) {
        return {
            container: {
                alignItems: 'center',
                display: 'flex'
            },
            element: {
                display: 'block',
                ...extra
            }
        };
    }
    /**
     * Styles to help with positioning
     */
    const positionSheets = {
        center: _elementPositionFactory({ margin: '0 auto', width: '100%' }),
        top: _elementPositionFactory({ margin: '0 0 auto 0' }),
        right: _elementPositionFactory({ margin: '0 0 0 auto' }),
        bottom: _elementPositionFactory({ margin: 'auto 0 0 0' }),
        left: _elementPositionFactory({ margin: '0 auto 0 0' }),
        'top right': _elementPositionFactory({ margin: '0 0 auto auto' }),
        'bottom right': _elementPositionFactory({ margin: 'auto 0 0 auto' }),
        'bottom left': _elementPositionFactory({ margin: 'auto auto 0 0' }),
        'top left': _elementPositionFactory({ margin: '0 auto 0 auto' })
    };
    function _elementSizeFactory(size) {
        return {
            element: {
                height: size,
                width: size
            }
        };
    }
    /**
     * sheets that establish some default sizes
     */
    const sizeSheets = {
        small: _elementSizeFactory('14px'),
        normal: _elementSizeFactory('16px'),
        large: _elementSizeFactory('20px'),
        xlarge: _elementSizeFactory('24px')
    };
    /**
     * Merge two or more icon sheets into a single "pure"
     * icon style (ie collections of CSS props only)
     */
    function mergeSheets(sheets) {
        return {
            container: Object.assign({}, ...sheets.map(s => s.container)),
            element: Object.assign({}, ...sheets.map(s => s.element))
        };
    }
    /**
     * Resolve one or more stylesheets that may just be a string naming
     * one of the builtin stylesheets to an array of proper ISheet objects
     */
    function resolveSheet(stylesheet) {
        if (!stylesheet) {
            return [];
        }
        if (!Array.isArray(stylesheet)) {
            // wrap in array
            stylesheet = [stylesheet];
        }
        return stylesheet.map(k => (typeof k === 'string' ? builtinSheets[k] : k));
    }
    /**
     * Resolve and merge multiple icon stylesheets
     */
    function applySheetOptions(sheets) {
        const options = Object.assign({}, ...sheets.map(s => s.options));
        if (options.elementPosition) {
            sheets.unshift(positionSheets[options.elementPosition]);
        }
        if (options.elementSize) {
            sheets.unshift(sizeSheets[options.elementSize]);
        }
        return mergeSheets(sheets);
    }
    /**
     * Resolve a pure icon stylesheet into a typestyle class
     */
    function resolveStyleClass(stylesheet) {
        var _a;
        return (0,typestyle_lib__WEBPACK_IMPORTED_MODULE_0__.style)({
            ...stylesheet.container,
            $nest: {
                ...(_a = stylesheet.container) === null || _a === void 0 ? void 0 : _a.$nest,
                ['svg']: stylesheet.element
            }
        });
    }
    // cache style classes for builtin stylesheets
    const _styleClassCache = new Map();
    /**
     * Get a typestyle class, given a set of icon styling props
     */
    function styleClass(props) {
        if (!props || Object.keys(props).length === 0) {
            // props is empty
            return '';
        }
        let { elementPosition, elementSize, stylesheet, ...elementCSS } = props;
        // add option args with defined values to overrides
        const options = {
            ...(elementPosition && { elementPosition }),
            ...(elementSize && { elementSize })
        };
        // try to look up the style class in the cache
        const cacheable = typeof stylesheet === 'string' && Object.keys(elementCSS).length === 0;
        const cacheKey = cacheable
            ? [stylesheet, elementPosition, elementSize].join(',')
            : '';
        if (cacheable && _styleClassCache.has(cacheKey)) {
            return _styleClassCache.get(cacheKey);
        }
        // resolve kind to an array of sheets, then stick overrides on the end
        const sheets = resolveSheet(stylesheet);
        sheets.push({ element: elementCSS, options });
        // apply style options/merge sheets, then convert to typestyle class
        const cls = resolveStyleClass(applySheetOptions(sheets));
        if (cacheable) {
            // store in cache for later reuse
            _styleClassCache.set(cacheKey, cls);
        }
        return cls;
    }
    LabIconStyle.styleClass = styleClass;
})(LabIconStyle || (LabIconStyle = {}));


/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/lib/utils.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/lib/utils.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   classes: () => (/* binding */ classes),
/* harmony export */   classesDedupe: () => (/* binding */ classesDedupe),
/* harmony export */   getReactAttrs: () => (/* binding */ getReactAttrs),
/* harmony export */   getTreeItemElement: () => (/* binding */ getTreeItemElement)
/* harmony export */ });
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyterlab/coreutils */ "webpack/sharing/consume/default/@jupyterlab/coreutils");
/* harmony import */ var _jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.

/**
 * Inner works of class combining functions
 */
function _classes(classes) {
    return classes
        .map(c => c && typeof c === 'object'
        ? Object.keys(c).map(key => !!c[key] && key)
        : typeof c === 'string'
            ? c.split(/\s+/)
            : [])
        .reduce((flattened, c) => flattened.concat(c), [])
        .filter(c => !!c);
}
/**
 * Combines classNames.
 *
 * @param classes - A list of classNames
 *
 * @returns A single string with the combined className
 */
function classes(...classes) {
    return _classes(classes).join(' ');
}
/**
 * Combines classNames. Removes all duplicates
 *
 * @param classes - A list of classNames
 *
 * @returns A single string with the combined className
 */
function classesDedupe(...classes) {
    return [...new Set(_classes(classes))].join(' ');
}
/**
 * Translates the attributes of a DOM element into attributes that can
 * be understood by React. Currently not comprehensive, we will add special
 * cases as they become relevant.
 *
 * @param elem - A DOM element
 *
 * @param ignore - An optional list of attribute names to ignore
 *
 * @returns An object with key:value pairs that are the React-friendly
 * translation of elem's attributes
 */
function getReactAttrs(elem, { ignore = [] } = {}) {
    return elem
        .getAttributeNames()
        .reduce((d, name) => {
        if (name === 'style' || ignore.includes(name)) {
            void 0;
        }
        else if (name.startsWith('data') || name.startsWith('aria')) {
            d[name] = elem.getAttribute(name);
        }
        else {
            d[_jupyterlab_coreutils__WEBPACK_IMPORTED_MODULE_0__.Text.camelCase(name)] = elem.getAttribute(name);
        }
        return d;
    }, {});
}
// Toolkit helpers
/**
 * Test whether an object is a tree item or not.
 * @param el Element to test
 * @returns Result
 */
function isTreeItemElement(el) {
    return el instanceof HTMLElement && el.getAttribute('role') === 'treeitem';
}
/**
 * Find the tree item encapsulating the element.
 *
 * @param el Starting element
 * @returns The tree item
 */
function getTreeItemElement(el) {
    let item = el;
    while (item && !isTreeItemElement(item)) {
        item = item.parentElement;
    }
    return isTreeItemElement(item) ? item : null;
}


/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/debug/bad.svg":
/*!************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/debug/bad.svg ***!
  \************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n    <path\n        class=\"jp-icon0\"\n        fill=\"#000\"\n        d=\"M24 20.188l-8.315-8.209 8.2-8.282-3.697-3.697-8.212 8.318-8.31-8.203-3.666 3.666 8.321 8.24-8.206 8.313 3.666 3.666 8.237-8.318 8.285 8.203z\"\n    />\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/debug/blank.svg":
/*!**************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/debug/blank.svg ***!
  \**************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n    <path\n        fill=\"#000\"\n        fill-opacity=\"0.0\"\n        d=\"M24 20.188l-8.315-8.209 8.2-8.282-3.697-3.697-8.212 8.318-8.31-8.203-3.666 3.666 8.321 8.24-8.206 8.313 3.666 3.666 8.237-8.318 8.285 8.203z\"\n    />\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-down-empty-thin.svg":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-down-empty-thin.svg ***!
  \************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 20 20\">\n  <path fill=\"#616161\" d=\"M9.9 13.6 3.6 7.4l.8-.8 5.5 5.6 5.5-5.5.7.7z\" class=\"jp-icon3\" shape-rendering=\"geometricPrecision\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-down-empty.svg":
/*!*******************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-down-empty.svg ***!
  \*******************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 18 18\">\n  <path fill=\"#616161\" d=\"M5.2 5.9 9 9.7l3.8-3.8L14 7.1l-4.9 5-4.9-5z\" class=\"jp-icon3\" shape-rendering=\"geometricPrecision\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-down.svg":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-down.svg ***!
  \*************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 18 18\">\n  <path fill=\"#616161\" d=\"M5.2 7.5 9 11.2l3.8-3.8H5.2z\" class=\"jp-icon3\" shape-rendering=\"geometricPrecision\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-left.svg":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-left.svg ***!
  \*************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 18 18\">\n  <path fill=\"#616161\" d=\"M10.8 12.8 7.1 9l3.8-3.8v7.6z\" class=\"jp-icon3\" shape-rendering=\"geometricPrecision\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-right.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-right.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 18 18\">\n  <path fill=\"#616161\" d=\"M7.2 5.2 10.9 9l-3.8 3.8V5.2z\" class=\"jp-icon3\" shape-rendering=\"geometricPrecision\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-up-empty-thin.svg":
/*!**********************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-up-empty-thin.svg ***!
  \**********************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 20 20\">\n  <path fill=\"#616161\" d=\"M15.4 13.3 9.9 7.7l-5.5 5.5-.8-.7 6.3-6.2 6.2 6.3z\" class=\"jp-icon3\" shape-rendering=\"geometricPrecision\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-up.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/arrow/caret-up.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 18 18\">\n  <path fill=\"#616161\" d=\"M5.2 10.5 9 6.8l3.8 3.8H5.2z\" class=\"jp-icon3\" shape-rendering=\"geometricPrecision\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/close-all.svg":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/debugger/close-all.svg ***!
  \***************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <g fill=\"#616161\" class=\"jp-icon3\">\n    <path d=\"M16.48 17.248A7.5 7.5 0 0 0 6.32 7.706a7 7 0 1 1 10.16 9.542\"/>\n    <path d=\"M19.16 14.248A7.5 7.5 0 0 0 9 4.706a7 7 0 1 1 10.16 9.542M16 15a7 7 0 1 1-14 0 7 7 0 0 1 14 0m-4.209-4L13 12.209 10.209 15 13 17.791 11.791 19 9 16.209 6.209 19 5 17.791 7.791 15 5 12.209 6.209 11 9 13.791z\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/exceptions.svg":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/debugger/exceptions.svg ***!
  \****************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <g fill=\"#616161\" class=\"jp-icon3\">\n    <path d=\"m12.039.5-.753 1.506L.5 23.576l23.082-.001zm.001 4.017 8.528 17.05-17.055.001z\"/>\n    <path d=\"M11 8h2v10h-2zm0 11h2v2h-2z\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/open-kernel-source.svg":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/debugger/open-kernel-source.svg ***!
  \************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M5 2h10l5 5v13a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-6h1v2l4-3-4-3v2H3V4a2 2 0 0 1 2-2m7 16h4v-2h-4zm0-4h6v-2h-6zm0-4h6V8h-6zm-2 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2m-7-2v2H1v-2z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/pause.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/debugger/pause.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M7 6h4v12H7Zm6 0h4v12h-4z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/step-into.svg":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/debugger/step-into.svg ***!
  \***************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 16 16\">\n  <path fill=\"#616161\" d=\"M8 9.532h.542l3.905-3.905-1.061-1.06-2.637 2.61V1H7.251v6.177l-2.637-2.61-1.061 1.06 3.905 3.905zm1.956 3.481a2 2 0 1 1-4 0 2 2 0 0 1 4 0\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/step-out.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/debugger/step-out.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 16 16\">\n  <path fill=\"#616161\" d=\"M8 1h-.542L3.553 4.905l1.061 1.06 2.637-2.61v6.177h1.498V3.355l2.637 2.61 1.061-1.06L8.542 1zm1.956 12.013a2 2 0 1 1-4 0 2 2 0 0 1 4 0\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/step-over.svg":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/debugger/step-over.svg ***!
  \***************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 16 16\">\n  <path fill=\"#616161\" d=\"M14.25 5.75v-4h-1.5v2.542c-1.145-1.359-2.911-2.209-4.84-2.209-3.177 0-5.92 2.307-6.16 5.398l-.02.269h1.5l.022-.226c.212-2.195 2.202-3.94 4.656-3.94 1.736 0 3.244.875 4.05 2.166h-2.83v1.5h4.163l.962-.975V5.75zM8 14a2 2 0 1 0 0-4 2 2 0 0 0 0 4\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/variable.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/debugger/variable.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" fill=\"none\" viewBox=\"0 0 16 16\">\n  <path fill=\"#007ACC\" fill-rule=\"evenodd\" d=\"m1.5 4-.5.5v8l.5.5H4v-1H2V5h2V4zm13 9 .5-.5v-8l-.5-.5H12v1h2v7h-2v1zM8.797 5l-4.5 2L4 7.457v2.5l.243.429 2.5 1.5.46.028 4.5-2L12 9.457v-2.5l-.243-.429-2.5-1.5zM5 8.34v1.334l1.5.9V9.24zm2.5.942v1.406L11 9.131V7.726zm2.918-2.391-1.452-.872-3.384 1.504 1.452.871z\" clip-rule=\"evenodd\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/debugger/view-breakpoint.svg":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/debugger/view-breakpoint.svg ***!
  \*********************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M5 2h10l5 5v13a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-6h1v2l4-3-4-3v2H3V4a2 2 0 0 1 2-2m7 16h4v-2h-4zm0-4h6v-2h-6zm0-4h6V8h-6zm-2 4a1 1 0 1 0 0-2 1 1 0 0 0 0 2m-7-2v2H1v-2z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/error.svg":
/*!**************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/error.svg ***!
  \**************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <g fill=\"#616161\" class=\"jp-icon3\">\n    <circle cx=\"12\" cy=\"19\" r=\"2\"/>\n    <path d=\"M10 3h4v12h-4z\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/console.svg":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/console.svg ***!
  \*************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 200 200\">\n  <path fill=\"#0288D1\" d=\"M20 19.8h160v159.9H20z\" class=\"jp-console-icon-background-color jp-icon-selectable\"/>\n  <path fill=\"#fff\" d=\"M105 127.3h40v12.8h-40zM51.1 77 74 99.9l-23.3 23.3 10.5 10.5 23.3-23.3L95 99.9 84.5 89.4 61.6 66.5z\" class=\"jp-console-icon-color jp-icon-selectable-inverse\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/file.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/file.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 22 22\">\n  <path fill=\"#616161\" d=\"m19.3 8.2-5.5-5.5c-.3-.3-.7-.5-1.2-.5H3.9c-.8.1-1.6.9-1.6 1.8v14.1c0 .9.7 1.6 1.6 1.6h14.2c.9 0 1.6-.7 1.6-1.6V9.4c.1-.5-.1-.9-.4-1.2m-5.8-3.3 3.4 3.6h-3.4zm3.9 12.7H4.7c-.1 0-.2 0-.2-.2V4.7c0-.2.1-.3.2-.3h7.2v4.4s0 .8.3 1.1 1.1.3 1.1.3h4.3v7.2s-.1.2-.2.2\" class=\"jp-icon3 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/folder-favorite.svg":
/*!*********************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/folder-favorite.svg ***!
  \*********************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" fill=\"#000\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M20 6h-8l-2-2H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2m-2.06 11L15 15.28 12.06 17l.78-3.33-2.59-2.24 3.41-.29L15 8l1.34 3.14 3.41.29-2.59 2.24z\" class=\"jp-icon3 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/folder.svg":
/*!************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/folder.svg ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M10 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2h-8z\" class=\"jp-icon3 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/home.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/home.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" fill=\"#000\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z\" class=\"jp-icon3 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/html5.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/html5.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 512 512\">\n  <path fill=\"#000\" d=\"M108.4 0h23v22.8h21.2V0h23v69h-23V46h-21v23h-23.2M206 23h-20.3V0h63.7v23H229v46h-23m53.5-69h24.1l14.8 24.3L313.2 0h24.1v69h-23V34.8l-16.1 24.8-16.1-24.8V69h-22.6m89.2-69h23v46.2h32.6V69h-55.6\" class=\"jp-icon0 jp-icon-selectable\"/>\n  <path fill=\"#e44d26\" d=\"m107.6 471-33-370.4h362.8l-33 370.2L255.7 512\" class=\"jp-icon-selectable\"/>\n  <path fill=\"#f16529\" d=\"M256 480.5V131h148.3L376 447\" class=\"jp-icon-selectable\"/>\n  <path fill=\"#ebebeb\" d=\"M142 176.3h114v45.4h-64.2l4.2 46.5h60v45.3H154.4m2 22.8H202l3.2 36.3 50.8 13.6v47.4l-93.2-26\" class=\"jp-icon-selectable-inverse\"/>\n  <path fill=\"#fff\" d=\"M369.6 176.3H255.8v45.4h109.6m-4.1 46.5H255.8v45.4h56l-5.3 59-50.7 13.6v47.2l93-25.8\" class=\"jp-icon-selectable-inverse\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/image.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/image.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 22 22\">\n  <path fill=\"#FFF\" d=\"M2.2 2.2h17.5v17.5H2.2z\" class=\"jp-icon-brand4 jp-icon-selectable-inverse\"/>\n  <path fill=\"#3F51B5\" d=\"M2.2 2.2v17.5h17.5l.1-17.5zm12.1 2.2c1.2 0 2.2 1 2.2 2.2s-1 2.2-2.2 2.2-2.2-1-2.2-2.2 1-2.2 2.2-2.2M4.4 17.6l3.3-8.8 3.3 6.6 2.2-3.2 4.4 5.4z\" class=\"jp-icon-brand0 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/inspector.svg":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/inspector.svg ***!
  \***************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2m-5 14H4v-4h11zm0-5H4V9h11zm5 5h-4V9h4z\" class=\"jp-inspector-icon-color jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/json.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/json.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 22 22\">\n  <g fill=\"#F9A825\" class=\"jp-json-icon-color jp-icon-selectable\">\n    <path d=\"M20.2 11.8c-1.6 0-1.7.5-1.7 1 0 .4.1.9.1 1.3.1.5.1.9.1 1.3 0 1.7-1.4 2.3-3.5 2.3h-.9v-1.9h.5c1.1 0 1.4 0 1.4-.8 0-.3 0-.6-.1-1 0-.4-.1-.8-.1-1.2 0-1.3 0-1.8 1.3-2-1.3-.2-1.3-.7-1.3-2 0-.4.1-.8.1-1.2.1-.4.1-.7.1-1 0-.8-.4-.7-1.4-.8h-.5V4.1h.9c2.2 0 3.5.7 3.5 2.3 0 .4-.1.9-.1 1.3-.1.5-.1.9-.1 1.3 0 .5.2 1 1.7 1zM1.8 10.1c1.6 0 1.7-.5 1.7-1 0-.4-.1-.9-.1-1.3-.1-.5-.1-.9-.1-1.3 0-1.6 1.4-2.3 3.5-2.3h.9v1.9h-.5c-1 0-1.4 0-1.4.8 0 .3 0 .6.1 1 0 .2.1.6.1 1 0 1.3 0 1.8-1.3 2C6 11.2 6 11.7 6 13c0 .4-.1.8-.1 1.2-.1.3-.1.7-.1 1 0 .8.3.8 1.4.8h.5v1.9h-.9c-2.1 0-3.5-.6-3.5-2.3 0-.4.1-.9.1-1.3.1-.5.1-.9.1-1.3 0-.5-.2-1-1.7-1z\"/>\n    <circle cx=\"11\" cy=\"13.8\" r=\"2.1\"/>\n    <circle cx=\"11\" cy=\"8.2\" r=\"2.1\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/julia.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/julia.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 325 300\">\n  <path fill=\"#cb3c33\" d=\"M150.898 225c0 41.422-33.578 75-75 75s-75-33.578-75-75 33.579-75 75-75 75 33.578 75 75\" class=\"jp-brand0 jp-icon-selectable\"/>\n  <path fill=\"#389826\" d=\"M237.5 75c0 41.422-33.578 75-75 75s-75-33.578-75-75 33.578-75 75-75 75 33.578 75 75\" class=\"jp-brand0 jp-icon-selectable\"/>\n  <path fill=\"#9558b2\" d=\"M324.102 225c0 41.422-33.579 75-75 75s-75-33.578-75-75 33.578-75 75-75 75 33.578 75 75\" class=\"jp-brand0 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/keyboard.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/keyboard.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M20 5H4c-1.1 0-1.99.9-1.99 2L2 17c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2m-9 3h2v2h-2zm0 3h2v2h-2zM8 8h2v2H8zm0 3h2v2H8zm-1 2H5v-2h2zm0-3H5V8h2zm9 7H8v-2h8zm0-4h-2v-2h2zm0-3h-2V8h2zm3 3h-2v-2h2zm0-3h-2V8h2z\" class=\"jp-icon3 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/launcher.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/launcher.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M19 19H5V5h7V3H5a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14c1.1 0 2-.9 2-2v-7h-2zM14 3v2h3.59l-9.83 9.83 1.41 1.41L19 6.41V10h2V3z\" class=\"jp-icon3 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/markdown.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/markdown.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 22 22\">\n  <path fill=\"#7B1FA2\" d=\"M5 14.9h12l-6.1 6zm9.4-6.8c0-1.3-.1-2.9-.1-4.5-.4 1.4-.9 2.9-1.3 4.3l-1.3 4.3h-2L8.5 7.9c-.4-1.3-.7-2.9-1-4.3-.1 1.6-.1 3.2-.2 4.6L7 12.4H4.8l.7-11h3.3L10 5c.4 1.2.7 2.7 1 3.9.3-1.2.7-2.6 1-3.9l1.2-3.7h3.3l.6 11h-2.4z\" class=\"jp-icon-contrast0 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/mermaid.svg":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/mermaid.svg ***!
  \*************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" version=\"1.1\" viewBox=\"0 0 491 675\">\n  <path fill=\"#ff3670\" d=\"M85 92c-46 0-85 37-85 85v321c0 46 37 85 85 85h321c46 0 85-37 85-85V177c0-46-37-85-85-85zm-2 111c72-3.1 139 41 162 109 25-67 91-112 162-109 2.4 57-25 111-72 144-24 16-39 44-39 74v51H192v-51c.08-29-15-57-39-74-47-32-75-86-72-144z\" class=\"jp-icon-contrast2 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/notebook.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/notebook.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 22 22\">\n  <g fill=\"#EF6C00\" class=\"jp-notebook-icon-color jp-icon-selectable\">\n    <path d=\"M18.7 3.3v15.4H3.3V3.3zm1.5-1.5H1.8v18.3h18.3z\"/>\n    <path d=\"m16.5 16.5-5.4-4.3-5.6 4.3v-11h11z\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/pdf.svg":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/pdf.svg ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 22 22\">\n  <path fill=\"#FF2A2A\" d=\"m17.933 13.667 3.987 3.987-1.117 1.117-2.51-2.51-1.066 1.067 2.36 2.36-1.117 1.117-2.36-2.36-2.43 2.429-1.477-1.478zm-6.163-3.93-3.496 3.496.53.53q.905.906 1.83.932.929.031 1.784-.825.852-.852.822-1.773t-.94-1.83zm-.36-2.594 1.557 1.558q1.305 1.305 1.754 2.13.456.825.468 1.727.015.79-.296 1.493-.31.702-.951 1.343-.649.648-1.355.963-.702.31-1.493.295-.905-.015-1.738-.472-.829-.46-2.118-1.75L5.68 12.874zm-5.76-5.76L8.1 3.835Q9.195 4.93 9.291 6q.103 1.07-.795 1.968-.901.902-1.976.802-1.067-.1-2.16-1.193l-.975-.975L1.397 8.59-.08 7.113Zm.406 2.548-1.6 1.6.817.818q.43.43.871.457.445.023.829-.361t.357-.825-.457-.871z\" class=\"jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/python.svg":
/*!************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/python.svg ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"-10 -10 131.161 132.389\">\n  <path fill=\"#306998\" d=\"M54.919 0c-4.584.022-8.961.413-12.813 1.095C30.76 3.099 28.7 7.295 28.7 15.032v10.219h26.813v3.406H18.638c-7.793 0-14.616 4.684-16.75 13.594-2.462 10.213-2.571 16.586 0 27.25 1.905 7.938 6.457 13.594 14.25 13.594h9.218v-12.25c0-8.85 7.657-16.657 16.75-16.657h26.782c7.454 0 13.406-6.138 13.406-13.625v-25.53c0-7.267-6.13-12.726-13.406-13.938C64.282.328 59.502-.02 54.918 0m-14.5 8.22c2.77 0 5.031 2.298 5.031 5.125 0 2.816-2.262 5.093-5.031 5.093-2.78 0-5.031-2.277-5.031-5.093 0-2.827 2.251-5.125 5.03-5.125\" class=\"jp-icon-selectable\"/>\n  <path fill=\"#ffd43b\" d=\"M85.638 28.657v11.906c0 9.231-7.826 17-16.75 17H42.106c-7.336 0-13.406 6.279-13.406 13.625V96.72c0 7.266 6.319 11.54 13.406 13.625 8.488 2.495 16.627 2.946 26.782 0 6.75-1.955 13.406-5.888 13.406-13.625V86.5H55.513v-3.405H95.7c7.793 0 10.696-5.436 13.406-13.594 2.8-8.399 2.68-16.476 0-27.25-1.925-7.758-5.604-13.594-13.406-13.594zM70.575 93.313c2.78 0 5.031 2.278 5.031 5.094 0 2.827-2.251 5.125-5.031 5.125-2.77 0-5.031-2.298-5.031-5.125 0-2.816 2.261-5.094 5.031-5.094\" class=\"jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/r-kernel.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/r-kernel.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\"  preserveAspectRatio=\"xMidYMid\" width=\"16\" height=\"16\" viewBox=\"0 0 724 561\">\n  <path class=\"jp-icon-selectable\" d=\"M361.453,485.937 C162.329,485.937 0.906,377.828 0.906,244.469 C0.906,111.109 162.329,3.000 361.453,3.000 C560.578,3.000 722.000,111.109 722.000,244.469 C722.000,377.828 560.578,485.937 361.453,485.937 ZM416.641,97.406 C265.289,97.406 142.594,171.314 142.594,262.484 C142.594,353.654 265.289,427.562 416.641,427.562 C567.992,427.562 679.687,377.033 679.687,262.484 C679.687,147.971 567.992,97.406 416.641,97.406 Z\" fill=\"rgb(179,179,179)\" fill-rule=\"evenodd\"/>\n  <path class=\"jp-icon-selectable\" d=\"M550.000,377.000 C550.000,377.000 571.822,383.585 584.500,390.000 C588.899,392.226 596.510,396.668 602.000,402.500 C607.378,408.212 610.000,414.000 610.000,414.000 L696.000,559.000 L557.000,559.062 L492.000,437.000 C492.000,437.000 478.690,414.131 470.500,407.500 C463.668,401.969 460.755,400.000 454.000,400.000 C449.298,400.000 420.974,400.000 420.974,400.000 L421.000,558.974 L298.000,559.026 L298.000,152.938 L545.000,152.938 C545.000,152.938 657.500,154.967 657.500,262.000 C657.500,369.033 550.000,377.000 550.000,377.000 ZM496.500,241.024 L422.037,240.976 L422.000,310.026 L496.500,310.002 C496.500,310.002 531.000,309.895 531.000,274.877 C531.000,239.155 496.500,241.024 496.500,241.024 Z\" fill=\"rgb(52,101,176)\" fill-rule=\"evenodd\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/react.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/react.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"150 150 541.9 295.3\">\n  <g fill=\"#61DAFB\" class=\"jp-icon-brand2 jp-icon-selectable\">\n    <path d=\"M666.3 296.5c0-32.5-40.7-63.3-103.1-82.4 14.4-63.6 8-114.2-20.2-130.4-6.5-3.8-14.1-5.6-22.4-5.6v22.3c4.6 0 8.3.9 11.4 2.6 13.6 7.8 19.5 37.5 14.9 75.7-1.1 9.4-2.9 19.3-5.1 29.4-19.6-4.8-41-8.5-63.5-10.9-13.5-18.5-27.5-35.3-41.6-50 32.6-30.3 63.2-46.9 84-46.9V78c-27.5 0-63.5 19.6-99.9 53.6-36.4-33.8-72.4-53.2-99.9-53.2v22.3c20.7 0 51.4 16.5 84 46.6-14 14.7-28 31.4-41.3 49.9-22.6 2.4-44 6.1-63.6 11-2.3-10-4-19.7-5.2-29-4.7-38.2 1.1-67.9 14.6-75.8 3-1.8 6.9-2.6 11.5-2.6V78.5c-8.4 0-16 1.8-22.6 5.6-28.1 16.2-34.4 66.7-19.9 130.1-62.2 19.2-102.7 49.9-102.7 82.3 0 32.5 40.7 63.3 103.1 82.4-14.4 63.6-8 114.2 20.2 130.4 6.5 3.8 14.1 5.6 22.5 5.6 27.5 0 63.5-19.6 99.9-53.6 36.4 33.8 72.4 53.2 99.9 53.2 8.4 0 16-1.8 22.6-5.6 28.1-16.2 34.4-66.7 19.9-130.1 62-19.1 102.5-49.9 102.5-82.3m-130.2-66.7c-3.7 12.9-8.3 26.2-13.5 39.5-4.1-8-8.4-16-13.1-24-4.6-8-9.5-15.8-14.4-23.4 14.2 2.1 27.9 4.7 41 7.9m-45.8 106.5c-7.8 13.5-15.8 26.3-24.1 38.2-14.9 1.3-30 2-45.2 2-15.1 0-30.2-.7-45-1.9-8.3-11.9-16.4-24.6-24.2-38-7.6-13.1-14.5-26.4-20.8-39.8 6.2-13.4 13.2-26.8 20.7-39.9 7.8-13.5 15.8-26.3 24.1-38.2 14.9-1.3 30-2 45.2-2 15.1 0 30.2.7 45 1.9 8.3 11.9 16.4 24.6 24.2 38 7.6 13.1 14.5 26.4 20.8 39.8-6.3 13.4-13.2 26.8-20.7 39.9m32.3-13c5.4 13.4 10 26.8 13.8 39.8-13.1 3.2-26.9 5.9-41.2 8 4.9-7.7 9.8-15.6 14.4-23.7 4.6-8 8.9-16.1 13-24.1M421.2 430c-9.3-9.6-18.6-20.3-27.8-32 9 .4 18.2.7 27.5.7 9.4 0 18.7-.2 27.8-.7-9 11.7-18.3 22.4-27.5 32m-74.4-58.9c-14.2-2.1-27.9-4.7-41-7.9 3.7-12.9 8.3-26.2 13.5-39.5 4.1 8 8.4 16 13.1 24q7.05 12 14.4 23.4M420.7 163c9.3 9.6 18.6 20.3 27.8 32-9-.4-18.2-.7-27.5-.7-9.4 0-18.7.2-27.8.7 9-11.7 18.3-22.4 27.5-32m-74 58.9c-4.9 7.7-9.8 15.6-14.4 23.7-4.6 8-8.9 16-13 24-5.4-13.4-10-26.8-13.8-39.8 13.1-3.1 26.9-5.8 41.2-7.9m-90.5 125.2c-35.4-15.1-58.3-34.9-58.3-50.6s22.9-35.6 58.3-50.6c8.6-3.7 18-7 27.7-10.1 5.7 19.6 13.2 40 22.5 60.9-9.2 20.8-16.6 41.1-22.2 60.6-9.9-3.1-19.3-6.5-28-10.2M310 490c-13.6-7.8-19.5-37.5-14.9-75.7 1.1-9.4 2.9-19.3 5.1-29.4 19.6 4.8 41 8.5 63.5 10.9 13.5 18.5 27.5 35.3 41.6 50-32.6 30.3-63.2 46.9-84 46.9-4.5-.1-8.3-1-11.3-2.7m237.2-76.2c4.7 38.2-1.1 67.9-14.6 75.8-3 1.8-6.9 2.6-11.5 2.6-20.7 0-51.4-16.5-84-46.6 14-14.7 28-31.4 41.3-49.9 22.6-2.4 44-6.1 63.6-11 2.3 10.1 4.1 19.8 5.2 29.1m38.5-66.7c-8.6 3.7-18 7-27.7 10.1-5.7-19.6-13.2-40-22.5-60.9 9.2-20.8 16.6-41.1 22.2-60.6 9.9 3.1 19.3 6.5 28.1 10.2 35.4 15.1 58.3 34.9 58.3 50.6-.1 15.7-23 35.6-58.4 50.6M320.8 78.4\"/>\n    <circle cx=\"420.9\" cy=\"296.5\" r=\"45.7\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/settings.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/settings.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65A.49.49 0 0 0 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5\" class=\"jp-icon3 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/spreadsheet.svg":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/spreadsheet.svg ***!
  \*****************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 22 22\">\n  <path fill=\"#4CAF50\" d=\"M2.2 2.2v17.6h17.6V2.2zm15.4 7.7h-5.5V4.4h5.5zM9.9 4.4v5.5H4.4V4.4zm-5.5 7.7h5.5v5.5H4.4zm7.7 5.5v-5.5h5.5v5.5z\" class=\"jp-icon-contrast1 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/text-editor.svg":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/text-editor.svg ***!
  \*****************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M15 15H3v2h12zm0-8H3v2h12zM3 13h18v-2H3zm0 8h18v-2H3zM3 3v2h18V3z\" class=\"jp-text-editor-icon-color jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/vega.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/vega.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 22 22\">\n  <g fill=\"#212121\" class=\"jp-icon1 jp-icon-selectable\">\n    <path d=\"m10.6 5.4 2.2-3.2H2.2v7.3l4-6.6z\"/>\n    <path d=\"m15.8 2.2-4.4 6.6L7 6.3l-4.8 8v5.5h17.6V2.2zm-7 15.4H5.5v-4.4h3.3zm4.4 0H9.8V9.8h3.4zm4.4 0h-3.4V6.5h3.4z\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/filetype/yaml.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/filetype/yaml.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 22 22\">\n  <g fill=\"#D81B60\" class=\"jp-icon-contrast2 jp-icon-selectable\">\n    <path d=\"M7.2 18.6v-5.4L3 5.6h3.3l1.4 3.1c.3.9.6 1.6 1 2.5.3-.8.6-1.6 1-2.5l1.4-3.1h3.4l-4.4 7.6v5.5z\"/>\n    <circle cx=\"17.6\" cy=\"16.5\" r=\"2.1\"/>\n    <circle cx=\"17.6\" cy=\"11\" r=\"2.1\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/history.svg":
/*!****************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/history.svg ***!
  \****************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M13.5 8H12v5l4.28 2.54.72-1.21-3.5-2.08zM13 3a9 9 0 0 0-9 9H1l3.96 4.03L9 12H6a7 7 0 0 1 7-7 7 7 0 0 1 7 7 7 7 0 0 1-7 7c-1.93 0-3.68-.79-4.94-2.06l-1.42 1.42A8.9 8.9 0 0 0 13 21a9 9 0 0 0 9-9 9 9 0 0 0-9-9\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/info.svg":
/*!*************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/info.svg ***!
  \*************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 50.978 50.978\">\n  <g fill=\"#616161\" class=\"jp-icon3\">\n    <path d=\"M43.52 7.458C38.711 2.648 32.307 0 25.489 0 18.67 0 12.266 2.648 7.458 7.458c-9.943 9.941-9.943 26.119 0 36.062 4.809 4.809 11.212 7.456 18.031 7.458h.002c6.816 0 13.221-2.648 18.029-7.458 4.809-4.809 7.457-11.212 7.457-18.03 0-6.82-2.649-13.224-7.457-18.032m-1.414 34.647c-4.432 4.431-10.332 6.872-16.615 6.872h-.002c-6.285-.001-12.187-2.441-16.617-6.872-9.162-9.163-9.162-24.071 0-33.233C13.303 4.44 19.204 2 25.489 2c6.284 0 12.186 2.44 16.617 6.872 4.431 4.431 6.871 10.332 6.871 16.617 0 6.283-2.441 12.186-6.871 16.616\"/>\n    <path d=\"M23.578 32.218q-.034-2.602.496-3.972t2.272-3.253q.702-.805 1.367-1.575.939-1.13 1.436-2.175.496-1.061.495-2.5 0-1.643-.779-2.979-.848-1.319-2.806-1.369-2.703.085-3.55 1.832a5.3 5.3 0 0 0-.607 1.814 11.3 11.3 0 0 0-.207 2.174h-2.937q-.136-3.312 1.493-5.719 1.593-2.459 5.378-2.527 3.24.034 5.141 1.758 1.918 1.74 1.95 4.811 0 1.712-.41 2.911a7.6 7.6 0 0 1-1.268 2.243 22 22 0 0 1-1.73 2.002 34 34 0 0 0-1.987 2.346 5.2 5.2 0 0 0-.565 1.199q-.24 1.438-.171 2.979zm0 6.002v-3.484h3.076v3.484z\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/jupyter/jupyter-favicon.svg":
/*!********************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/jupyter/jupyter-favicon.svg ***!
  \********************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"152\" height=\"165\" version=\"1.1\" viewBox=\"0 0 152 165\">\n  <path fill=\"#F37726\" d=\"M76.021 140.163c-32.64 0-61.145-11.927-75.942-29.58 5.51 15.84 15.781 29.567 29.39 39.278a80.17 80.17 0 0 0 46.57 14.929 80.17 80.17 0 0 0 46.57-14.929c13.61-9.711 23.88-23.437 29.391-39.278-14.833 17.653-43.338 29.58-75.979 29.58m-.005-114.832c32.64 0 61.146 11.927 75.943 29.58a80.9 80.9 0 0 0-29.391-39.278A80.16 80.16 0 0 0 75.998.705a80.16 80.16 0 0 0-46.57 14.928A80.9 80.9 0 0 0 .038 54.912c14.832-17.617 43.338-29.58 75.978-29.58\" class=\"jp-jupyter-icon-color\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/jupyter/jupyter.svg":
/*!************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/jupyter/jupyter.svg ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"39\" height=\"51\" viewBox=\"0 0 39 51\">\n  <path fill=\"#F37726\" d=\"M20.005 38.114c-7.85 0-14.706-2.876-18.265-7.134a19.5 19.5 0 0 0 7.069 9.473 19.24 19.24 0 0 0 11.2 3.6c4.013 0 7.927-1.258 11.2-3.6a19.5 19.5 0 0 0 7.069-9.473c-3.567 4.258-10.423 7.134-18.273 7.134m-.002-27.694c7.85 0 14.706 2.876 18.265 7.133a19.5 19.5 0 0 0-7.069-9.473A19.24 19.24 0 0 0 20 4.48a19.24 19.24 0 0 0-11.2 3.6 19.5 19.5 0 0 0-7.069 9.473c3.567-4.248 10.423-7.134 18.273-7.134\" class=\"jp-jupyter-icon-color\"/>\n  <path fill=\"#616161\" d=\"M37.194 3.154a3 3 0 0 1-.426 1.672 2.96 2.96 0 0 1-1.275 1.153 2.93 2.93 0 0 1-3.238-.505 3 3 0 0 1-.776-3.21c.2-.553.558-1.033 1.029-1.38a2.93 2.93 0 0 1 3.733.209c.576.532.919 1.274.953 2.061M9.228 46.393a3.77 3.77 0 0 1-.536 2.11 3.73 3.73 0 0 1-1.608 1.452 3.69 3.69 0 0 1-4.082-.638 3.75 3.75 0 0 1-1.097-1.875 3.8 3.8 0 0 1 .122-2.173 3.74 3.74 0 0 1 1.299-1.739 3.696 3.696 0 0 1 4.704.268 3.76 3.76 0 0 1 1.198 2.595M2.635 9.456a2.17 2.17 0 0 1-1.227-.318 2.2 2.2 0 0 1-.845-.951A2.22 2.22 0 0 1 .935 5.77a2.16 2.16 0 0 1 2.356-.577c.405.15.757.418 1.011.77a2.21 2.21 0 0 1-.156 2.783 2.17 2.17 0 0 1-1.511.71\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/jupyter/jupyterlab-wordmark.svg":
/*!************************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/jupyter/jupyterlab-wordmark.svg ***!
  \************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"200\" viewBox=\"0 0 1860.8 475\">\n  <path fill=\"#4E4E4E\" d=\"M53.324 293.087c0 48.7-3.7 64.7-13.6 76.4-10.8 10-25 15.5-39.7 15.5l3.7 29c22.8.3 44.8-7.9 61.9-23.1 17.8-18.5 24-44.1 24-83.3v-184.3h-36.4v170.1zm271.42-22.179c0 21 0 39.5 1.7 55.4h-31.8l-2.1-33.3h-.8c-6.7 11.6-16.4 21.3-28 27.9s-24.8 10-38.2 9.8c-31.4 0-69-17.7-69-89v-118.8h36.4v112.7c0 38.7 11.6 64.7 44.6 64.7 10.3-.2 20.4-3.5 28.9-9.4s15.1-14.3 18.9-23.9c2.2-6.1 3.3-12.5 3.3-18.9v-125h36.4v147.8zm68.512-81.525c0-26-.8-47-1.7-66.7h32.7l1.7 34.8h.8c7.1-12.5 17.5-22.8 30.1-29.7 12.5-7 26.7-10.3 41-9.8 48.3 0 84.7 41.7 84.7 103.3 0 73.1-43.7 109.2-91 109.2-12.1.5-24.2-2.2-35-7.8s-19.9-13.9-26.6-24.2h-.8v110.5h-36v-220zm36 54.2c.1 5.1.6 10.1 1.7 15.1 3 12.3 9.9 23.3 19.8 31.1s22.1 12.1 34.7 12.1c38.5 0 60.7-31.9 60.7-78.5 0-40.7-21.1-75.6-59.5-75.6-12.9.4-25.3 5.1-35.3 13.4-9.9 8.3-16.9 19.7-19.6 32.4-1.5 4.9-2.3 10-2.5 15.1zm217.572-120.485 43.7 120.1c4.5 13.4 9.5 29.4 12.8 41.7h.8c3.7-12.2 7.9-27.7 12.8-42.4l39.7-119.2h38.5l-54.4 144.8c-26 69.7-43.7 105.4-68.6 127.2-12.5 11.7-27.9 20-44.6 23.9l-9.1-31.1c11.7-3.9 22.5-10.1 31.8-18.1 13.2-11.1 23.7-25.2 30.6-41.2 1.5-2.8 2.5-5.7 2.9-8.8-.3-3.3-1.2-6.6-2.5-9.7l-73.8-187.1h39.7zM890.649 64.65v58.3h52v28.2h-52v109.5c0 25 7 39.5 27.3 39.5 7.1.1 14.2-.7 21.1-2.5l1.7 27.7c-10.3 3.7-21.3 5.4-32.2 5-7.3.4-14.6-.7-21.3-3.4-6.8-2.7-12.9-6.8-17.9-12.1-10.3-10.9-14.1-29-14.1-52.9v-110.8h-31v-28.2h31v-48.7zm119.111 166.711c.8 50 32.2 70.6 68.6 70.6 19 .6 37.9-3 55.3-10.5l6.2 26.4c-20.9 8.9-43.5 13.1-66.2 12.6-61.5 0-98.3-41.2-98.3-102.5 0-61.4 35.5-109.6 93.7-109.6 65.2 0 82.7 58.3 82.7 95.7-.1 5.8-.5 11.5-1.2 17.2h-140.8zm106.6-26.4c.4-23.5-9.5-60.1-50.4-60.1-36.8 0-52.8 34.4-55.7 60.1zm88.317-18.505c0-23.9-.4-44.5-1.7-63.4h31.8l1.2 39.9h1.7c9.1-27.3 31-44.5 55.3-44.5 3.5-.1 7 .4 10.3 1.2v34.8c-4.1-.9-8.2-1.3-12.4-1.2-25.6 0-43.7 19.7-48.7 47.4-1 5.7-1.6 11.5-1.7 17.2v108.3h-36v-139.7z\" class=\"jp-icon2\"/>\n  <path fill=\"#F37726\" d=\"M1352.3 326.2h37V28h-37zm252.5 0c-2.5-13.9-3.4-31.1-3.4-48.7v-76c0-40.7-15.1-83.1-77.3-83.1-25.6 0-50 7.1-66.8 18.1l8.4 24.4c14.3-9.2 34-15.1 53-15.1 41.6 0 46.2 30.2 46.2 47v4.2c-78.6-.4-122.3 26.5-122.3 75.6 0 29.4 21 58.4 62.2 58.4 29 0 50.9-14.3 62.2-30.2h1.3l2.9 25.6h33.6zm-39.1-68.5c0 3.8-.8 8-2.1 11.8-5.9 17.2-22.7 34-49.2 34-18.9 0-34.9-11.3-34.9-35.3 0-39.5 45.8-46.6 86.2-45.8zm132.8 68.5 1.7-33.6h1.3c15.1 26.9 38.7 38.2 68.1 38.2 45.4 0 91.2-36.1 91.2-108.8.4-61.7-35.3-103.7-85.7-103.7-32.8 0-56.3 14.7-69.3 37.4h-.8V28h-36.6v245.7c0 18.1-.8 38.6-1.7 52.5zm6.3-118c0-5.9 1.3-10.9 2.1-15.1 7.6-28.1 31.1-45.4 56.3-45.4 39.5 0 60.5 34.9 60.5 75.6 0 46.6-23.1 78.1-61.8 78.1-26.9 0-48.3-17.6-55.5-43.3-.8-4.2-1.7-8.8-1.7-13.4v-36.5z\" class=\"jp-jupyter-icon-color\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/licenses/copyright.svg":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/licenses/copyright.svg ***!
  \***************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M11.88 9.14c1.28.06 1.61 1.15 1.63 1.66h1.79c-.08-1.98-1.49-3.19-3.45-3.19C9.64 7.61 8 9 8 12.14c0 1.94.93 4.24 3.84 4.24 2.22 0 3.41-1.65 3.44-2.95h-1.79c-.03.59-.45 1.38-1.63 1.44-1.31-.04-1.86-1.06-1.86-2.73 0-2.89 1.28-2.98 1.88-3M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2m0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/lock.svg":
/*!*************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/lock.svg ***!
  \*************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 23\">\n  <path fill=\"#333\" d=\"M12 17a2 2 0 0 0 2-2 2 2 0 0 0-2-2 2 2 0 0 0-2 2 2 2 0 0 0 2 2m6-9a2 2 0 0 1 2 2v10a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V10a2 2 0 0 1 2-2h1V6a5 5 0 0 1 5-5 5 5 0 0 1 5 5v2zm-6-5a3 3 0 0 0-3 3v2h6V6a3 3 0 0 0-3-3\" class=\"jp-icon4\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/lsp/code-check.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/lsp/code-check.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M6.59 3.41 2 8l4.59 4.6L8 11.18 4.82 8 8 4.82zm5.82 0L11 4.82 14.18 8 11 11.18l1.41 1.42L17 8zm9.18 8.18-8.09 8.09L9.83 16l-1.41 1.41 5.08 5.09L23 13z\" class=\"jp-icon3 jp-icon-selectable\" shape-rendering=\"geometricPrecision\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/output/collapse.svg":
/*!************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/output/collapse.svg ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 8.5 10.5\">\n  <g fill=\"#BDBDBD\" class=\"jp-icon-output\">\n    <path d=\"M.019 0h8.458v1.064H.019zM0 9.52h8.491v1.059H0zm4.776-6.608H3.72V1.323h1.056z\"/>\n    <path d=\"m4.244 5.243-1.06-1.167-1.06-1.167h4.24l-1.06 1.167zm.528 4.014H3.716V7.665h1.056z\"/>\n    <path d=\"M4.242 5.332 5.302 6.5l1.06 1.167h-4.24L3.182 6.5z\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/output/expand.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/output/expand.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 8.5 10.5\">\n  <g fill=\"#BDBDBD\" class=\"jp-icon-output\">\n    <path d=\"M.019 0h8.458v1.064H.019zM0 9.521h8.491v1.059H0zm3.712-5.822h1.056v1.589H3.712z\"/>\n    <path d=\"m4.244 1.368 1.06 1.167 1.06 1.167h-4.24l1.06-1.167zm-.532 3.92h1.056V6.88H3.712z\"/>\n    <path d=\"m4.242 9.213-1.06-1.167-1.06-1.167h4.24l-1.06 1.167z\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/search/case-sensitive.svg":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/search/case-sensitive.svg ***!
  \******************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 20 20\">\n  <path fill=\"#414141\" d=\"M2 2h16v16H2z\" class=\"jp-icon2\"/>\n  <path fill=\"#FFF\" d=\"M7.6 8h.9l3.5 8h-1.1l-.9-2H6l-.9 2H4zM8 9.1 6.4 13h3.2zm8.6.7c-.2.1-.4.1-.7.1-.2 0-.4-.1-.6-.2-.1-.1-.2-.4-.2-.7-.3.3-.6.5-.9.7-.3.1-.7.2-1.1.2-.3 0-.5 0-.7-.1l-.6-.3c-.2-.1-.3-.3-.4-.5s-.1-.4-.1-.7.1-.6.2-.8.3-.4.4-.5c.1 0 .3-.1.6-.2.2-.1.5-.1.7-.2.3-.1.5-.1.7-.1s.4-.1.6-.1.3-.1.4-.2.2-.2.2-.4c0-1-1.1-1-1.3-1-.4 0-1.4 0-1.4 1.2h-.9c0-.4.1-.7.2-1 .1-.2.3-.4.5-.6s.5-.3.8-.3c.3-.1.6-.1.9-.1s.5 0 .8.1c.3 0 .5.1.7.2s.4.3.5.5.1.4.1.8V9c0 .1.1.2.3.2h.3zm-1.4-2.9c-1.2.6-3.1.2-3.1 1.4 0 1.4 3.1 1 3.1-.5z\" class=\"jp-icon-accent2\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/search/filter-dot.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/search/filter-dot.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#FFF\" d=\"M14 12v7.88c.04.3-.06.62-.29.83a.996.996 0 0 1-1.41 0l-2.01-2.01a.99.99 0 0 1-.29-.83V12h-.03L4.21 4.62a1 1 0 0 1 .17-1.4c.19-.14.4-.22.62-.22h14c.22 0 .43.08.62.22a1 1 0 0 1 .17 1.4L14.03 12z\" class=\"jp-icon3\"/>\n  <circle cx=\"18\" cy=\"17\" r=\"3\" fill=\"#FFF\" class=\"jp-icon-dot\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/search/filter.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/search/filter.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#FFF\" d=\"M14 12v7.88c.04.3-.06.62-.29.83a.996.996 0 0 1-1.41 0l-2.01-2.01a.99.99 0 0 1-.29-.83V12h-.03L4.21 4.62a1 1 0 0 1 .17-1.4c.19-.14.4-.22.62-.22h14c.22 0 .43.08.62.22a1 1 0 0 1 .17 1.4L14.03 12z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/search/regex.svg":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/search/regex.svg ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 20 20\">\n  <path fill=\"#414141\" d=\"M2 2h16v16H2z\" class=\"jp-icon2\"/>\n  <g fill=\"#FFF\" class=\"jp-icon-accent2\">\n    <circle cx=\"5.5\" cy=\"14.5\" r=\"1.5\"/>\n    <path d=\"M12 4h1v8h-1z\"/>\n    <path d=\"m8.786 9.567 6.928-4 .5.866-6.928 4z\"/>\n    <path d=\"m8.786 6.433.5-.866 6.928 4-.5.866z\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/search/word.svg":
/*!********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/search/word.svg ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 20 20\">\n  <path fill=\"#414141\" d=\"M2 2h16v16H2z\" class=\"jp-icon2\"/>\n  <path fill=\"#fff\" d=\"M4.57 8.8q.068-1.89 2.42-1.89 1.16 0 1.68.42.567.41.567 1.16v3.47q0 .462.514.462.103 0 .2-.023v.714q-.399.103-.651.103-.452 0-.693-.22-.231-.2-.284-.662-.956.872-2 .872-.903 0-1.47-.472-.525-.472-.525-1.26 0-.262.045-.472.057-.22.116-.378.068-.168.231-.304l.262-.242q.116-.091.368-.168.262-.091.4-.126.135-.045.471-.103t.504-.08l.567-.08q.556-.068.777-.22.22-.153.22-.442v-.252q0-.43-.357-.662-.336-.23-.976-.23-.662 0-.998.261-.336.252-.399.798zm1.89 3.68q.788 0 1.26-.41.504-.42.504-.903v-1.05q-.284.136-.861.231l-.987.158q-.42.068-.766.326-.336.252-.336.704t.304.704.861.252zm3.97-7.88h.945v3.15q.651-.976 1.89-.976 1.16 0 1.89.84.682.84.682 2.31t-.704 2.42q-.704.882-1.89.882-1.26 0-1.89-1.02v.766h-.85zm2.62 3.04q-.746 0-1.16.64-.452.63-.452 1.68t.452 1.68 1.16.63q.777 0 1.26-.63.494-.64.494-1.68 0-1.05-.472-1.68-.462-.64-1.26-.64zm-9.89 8.2 13.6.008c.007 0 0-2.6 0-2.6 0-.008-1.15 0-1.15 0-.007 0-.008 1.5-.008 1.5l-11.3-.001-.006-1.5c0-.008-1.17.001-1.17.001z\" class=\"jp-icon-accent2\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/build.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/build.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M14.9 17.45c1.35 0 2.45-1.1 2.45-2.45s-1.1-2.45-2.45-2.45c-1.36 0-2.45 1.1-2.45 2.45s1.09 2.45 2.45 2.45m5.2-1.77 1.48 1.16c.13.11.17.29.08.45l-1.4 2.42a.35.35 0 0 1-.43.15l-1.74-.7c-.36.28-.76.51-1.18.69l-.27 1.85c-.02.17-.17.3-.34.3h-2.8c-.18 0-.32-.13-.35-.3l-.26-1.85c-.43-.18-.82-.41-1.18-.69l-1.75.7c-.15.06-.34 0-.42-.15l-1.4-2.42a.35.35 0 0 1 .08-.45l1.48-1.16-.05-.68.05-.69-1.48-1.15a.35.35 0 0 1-.08-.45l1.4-2.42c.08-.16.27-.22.42-.16l1.75.71c.36-.28.75-.52 1.18-.69l.26-1.86c.03-.16.17-.29.35-.29h2.8c.17 0 .32.13.34.29l.27 1.86c.42.17.82.41 1.18.69l1.74-.71c.17-.06.34 0 .43.16l1.4 2.42c.09.15.05.34-.08.45l-1.48 1.15.05.69zM7.33 7.445A1.566 1.566 0 0 0 7.904 5.3a1.575 1.575 0 1 0-.574 2.145m2.327-2.65 1.21.157c.096.025.173.12.171.236v1.8a.214.214 0 0 1-.183.223l-1.195.17-.42.75.43 1.126c.037.106 0 .22-.096.275l-1.559.9a.23.23 0 0 1-.294-.05l-.734-.95-.878-.001-.762.96c-.058.08-.173.1-.275.043l-1.56-.901a.23.23 0 0 1-.101-.276l.452-1.116-.246-.366-.194-.396-1.192-.166a.23.23 0 0 1-.189-.226V5.186c.002-.117.077-.206.175-.217l1.204-.175.446-.766-.456-1.11a.23.23 0 0 1 .104-.28l1.56-.9a.225.225 0 0 1 .285.054l.76.936.86.01.745-.949a.214.214 0 0 1 .284-.048l1.56.9a.24.24 0 0 1 .118.267l-.47 1.126.246.366z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/extension.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/extension.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M20.5 11H19V7c0-1.1-.9-2-2-2h-4V3.5a2.5 2.5 0 0 0-5 0V5H4c-1.1 0-1.99.9-1.99 2v3.8H3.5c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7H2V20c0 1.1.9 2 2 2h3.8v-1.5c0-1.49 1.21-2.7 2.7-2.7s2.7 1.21 2.7 2.7V22H17c1.1 0 2-.9 2-2v-4h1.5a2.5 2.5 0 0 0 0-5\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/palette.svg":
/*!************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/palette.svg ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <g fill=\"#616161\" class=\"jp-icon3\">\n    <path d=\"M18 13v7H4V6h5.02c.05-.71.22-1.38.48-2H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-5zm1.3-4.11c.44-.7.7-1.51.7-2.39C20 4.01 17.99 2 15.5 2S11 4.01 11 6.5s2.01 4.5 4.49 4.5c.88 0 1.7-.26 2.39-.7L21 13.42 22.42 12zM15.5 9a2.5 2.5 0 0 1 0-5 2.5 2.5 0 0 1 0 5\"/>\n    <path fill-rule=\"evenodd\" d=\"M4 6h5.019a6.5 6.5 0 0 0 3.015 6H9v2h7v-1.019c.57-.043 1.12-.16 1.64-.341L18 13v7H4zm4 2H6v2h2zm-2 4h2v2H6zm2 4H6v2h2zm1 0h7v2H9z\" clip-rule=\"evenodd\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/running.svg":
/*!************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/running.svg ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 512 512\">\n  <path fill=\"#616161\" d=\"M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8m96 328c0 8.8-7.2 16-16 16H176c-8.8 0-16-7.2-16-16V176c0-8.8 7.2-16 16-16h160c8.8 0 16 7.2 16 16z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/share.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/share.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M18 2c-1.645 0-3 1.355-3 3 0 .191.022.377.057.559L7.922 9.72A2.97 2.97 0 0 0 6 9c-1.645 0-3 1.355-3 3s1.355 3 3 3c.732 0 1.399-.278 1.922-.72l7.135 4.16A3 3 0 0 0 15 19c0 1.645 1.355 3 3 3s3-1.355 3-3-1.355-3-3-3a2.97 2.97 0 0 0-1.922.723l-7.135-4.164C8.978 12.377 9 12.19 9 12s-.022-.377-.057-.559l7.135-4.162C16.601 7.722 17.268 8 18 8c1.645 0 3-1.355 3-3s-1.355-3-3-3m0 2c.564 0 1 .436 1 1s-.436 1-1 1-1-.436-1-1 .436-1 1-1M6 11c.564 0 1 .436 1 1s-.436 1-1 1-1-.436-1-1 .436-1 1-1m12 7c.564 0 1 .436 1 1s-.436 1-1 1-1-.436-1-1 .436-1 1-1\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/tab.svg":
/*!********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/tab.svg ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2m0 16H3V5h10v4h8z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/toc.svg":
/*!********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/toc.svg ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M7 5h14v2H7zm0 8v-2h14v2zM4 4.5A1.5 1.5 0 0 1 5.5 6 1.5 1.5 0 0 1 4 7.5 1.5 1.5 0 0 1 2.5 6 1.5 1.5 0 0 1 4 4.5m0 6A1.5 1.5 0 0 1 5.5 12 1.5 1.5 0 0 1 4 13.5 1.5 1.5 0 0 1 2.5 12 1.5 1.5 0 0 1 4 10.5M7 19v-2h14v2zm-3-2.5A1.5 1.5 0 0 1 5.5 18 1.5 1.5 0 0 1 4 19.5 1.5 1.5 0 0 1 2.5 18 1.5 1.5 0 0 1 4 16.5\" class=\"jp-icon3 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/user.svg":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/user.svg ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M16 7a4 4 0 1 1-8 0 4 4 0 0 1 8 0m-4 7a7 7 0 0 0-7 7h14a7 7 0 0 0-7-7\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/users.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/sidebar/users.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" version=\"1.1\" viewBox=\"0 0 36 24\">\n  <g fill=\"#616161\" class=\"jp-icon3\" transform=\"translate(-3.628 .1)scale(1.7327)\">\n    <path d=\"M18.279 5.265c-1.58 0-2.964.85-3.718 2.115a6.7 6.7 0 0 1 2.81 2.21h5.23a4.32 4.32 0 0 0-4.322-4.325m2.186-2.875a2.19 2.19 0 0 1-2.188 2.188 2.19 2.19 0 0 1-2.189-2.189A2.19 2.19 0 0 1 18.277.201a2.19 2.19 0 0 1 2.188 2.188M5.385 6.633a3.02 3.02 0 0 0-3.02 3.02h4.22a6.7 6.7 0 0 1 1.44-1.467 3.02 3.02 0 0 0-2.64-1.553m1.53-2.01a1.53 1.53 0 0 1-1.529 1.53 1.53 1.53 0 0 1-1.53-1.53 1.53 1.53 0 0 1 1.53-1.53 1.53 1.53 0 0 1 1.53 1.53m-.781 8.912a5.865 5.865 0 0 1 11.73 0z\"/>\n    <circle cx=\"12\" cy=\"3.768\" r=\"2.969\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/bell.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/bell.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" version=\"1.1\" viewBox=\"0 0 16 16\">\n  <path fill=\"#333\" d=\"M8 .29c-1.4 0-2.7.73-3.6 1.8-1.2 1.5-1.4 3.4-1.5 5.2-.18 2.2-.44 4-2.3 5.3l.28 1.3h5c.026.66.32 1.1.71 1.5.84.61 2 .61 2.8 0 .52-.4.6-1 .71-1.5h5l.28-1.3c-1.9-.97-2.2-3.3-2.3-5.3-.13-1.8-.26-3.7-1.5-5.2-.85-1-2.2-1.8-3.6-1.8zm0 1.4c.88 0 1.9.55 2.5 1.3.88 1.1 1.1 2.7 1.2 4.4.13 1.7.23 3.6 1.3 5.2H3c1.1-1.6 1.2-3.4 1.3-5.2.13-1.7.3-3.3 1.2-4.4.59-.72 1.6-1.3 2.5-1.3m-.74 12h1.5c-.001.28.015.79-.74.79-.73.002-.72-.53-.74-.79z\" class=\"jp-icon2 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/kernel.svg":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/kernel.svg ***!
  \*************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M15 9H9v6h6zm-2 4h-2v-2h2zm8-2V9h-2V7c0-1.1-.9-2-2-2h-2V3h-2v2h-2V3H9v2H7c-1.1 0-2 .9-2 2v2H3v2h2v2H3v2h2v2c0 1.1.9 2 2 2h2v2h2v-2h2v2h2v-2h2c1.1 0 2-.9 2-2v-2h2v-2h-2v-2zm-4 6H7V7h10z\" class=\"jp-icon2\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/line-form.svg":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/line-form.svg ***!
  \****************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#fff\" d=\"M5.88 4.12 13.76 12l-7.88 7.88L8 22l10-10L8 2z\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/list.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/list.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M19 5v14H5V5zm1.1-2H3.9c-.5 0-.9.4-.9.9v16.2c0 .4.4.9.9.9h16.2c.4 0 .9-.5.9-.9V3.9c0-.5-.5-.9-.9-.9M11 7h6v2h-6zm0 4h6v2h-6zm0 4h6v2h-6zM7 7h2v2H7zm0 4h2v2H7zm0 4h2v2H7z\" class=\"jp-icon2 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/not-trusted.svg":
/*!******************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/not-trusted.svg ***!
  \******************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" fill=\"none\" viewBox=\"0 0 25 25\">\n  <path stroke=\"#333\" stroke-width=\"2\" d=\"M4.86 14.44c-1.034-2.67-.996-5.382-.61-7.24 1.232-.267 2.83-.797 4.351-1.355a92 92 0 0 0 4.387-1.75 68 68 0 0 0 4.23 1.748c1.532.57 3.182 1.11 4.536 1.37.382 1.859.417 4.564-.615 7.228-1.109 2.862-3.472 5.743-8.139 7.494-4.667-1.75-7.03-4.632-8.14-7.494Zm11.824-5.12-7.368 7.365m7.368-.001L9.316 9.319\" class=\"jp-icon2\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/terminal.svg":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/terminal.svg ***!
  \***************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#333\" d=\"M2 2h20v20H2z\" class=\"jp-terminal-icon-background-color jp-icon-selectable\"/>\n  <path fill=\"#fff\" d=\"M9.01 14.762q0-.246-.077-.434a.9.9 0 0 0-.234-.351 1.6 1.6 0 0 0-.422-.288 5 5 0 0 0-.627-.263q-.592-.211-1.078-.446a3.5 3.5 0 0 1-.832-.544 2.2 2.2 0 0 1-.528-.721 2.4 2.4 0 0 1-.187-.985q0-.498.17-.908a2.1 2.1 0 0 1 .48-.72q.31-.306.75-.493.44-.188.979-.24V7.11h.937v1.272q.527.07.95.287.421.217.714.568.3.345.457.82.165.47.164 1.055H8.998q0-.709-.323-1.072-.322-.37-.873-.37-.299 0-.521.083a.9.9 0 0 0-.358.223.9.9 0 0 0-.21.334q-.066.194-.065.421 0 .23.064.41a.9.9 0 0 0 .229.329q.165.152.428.293.263.134.656.275.591.223 1.072.463.48.235.82.55.346.312.528.727.187.41.187.973 0 .515-.17.932-.17.41-.486.709t-.762.48a3.7 3.7 0 0 1-.996.229v1.148h-.931V17.1a4 4 0 0 1-.967-.217 2.6 2.6 0 0 1-.832-.504 2.4 2.4 0 0 1-.574-.826q-.217-.505-.217-1.207h1.635q0 .421.123.709.123.281.316.45.2.165.451.235.252.07.516.07.627 0 .949-.292a.98.98 0 0 0 .322-.756m8.36 3.51h-5.343V17h5.344z\" class=\"jp-terminal-icon-color jp-icon-selectable-inverse\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/trusted.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/statusbar/trusted.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" fill=\"none\" viewBox=\"0 0 24 25\">\n  <path stroke=\"#333\" stroke-width=\"2\" d=\"M3.86 14.44c-1.034-2.67-.996-5.382-.61-7.24 1.232-.267 2.83-.797 4.351-1.355a92 92 0 0 0 4.387-1.75 68 68 0 0 0 4.23 1.748c1.532.57 3.182 1.11 4.536 1.37.382 1.859.417 4.564-.615 7.228-1.109 2.862-3.472 5.743-8.139 7.494-4.667-1.75-7.03-4.632-8.14-7.494Z\" class=\"jp-icon2\"/>\n  <path fill=\"#333\" stroke=\"#333\" d=\"m10.86 14.733-2.133-1.866-.727.63L10.86 16 16 10.5l-.721-.632z\" class=\"jp-icon2\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/add-above.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/add-above.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"14\" height=\"14\" fill=\"none\" viewBox=\"0 0 14 14\">\n  <g clip-path=\"url(#addabovea)\">\n    <path fill=\"#616161\" stroke=\"#616161\" stroke-width=\".7\" d=\"M4.75 4.93h1.875v1.876c0 .206.169.375.375.375a.376.376 0 0 0 .375-.375V4.93H9.25a.376.376 0 0 0 .375-.375.376.376 0 0 0-.375-.375H7.375V2.306A.376.376 0 0 0 7 1.93a.376.376 0 0 0-.375.375V4.18H4.75a.376.376 0 0 0-.375.375c0 .206.169.375.375.375Z\" class=\"jp-icon3\"/>\n  </g>\n  <path fill=\"#616161\" fill-rule=\"evenodd\" d=\"M11.5 9.5v2h-9v-2zM12 8a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V9a1 1 0 0 1 1-1z\" class=\"jp-icon3\" clip-rule=\"evenodd\"/>\n  <defs>\n    <clipPath id=\"addabovea\">\n      <path fill=\"#fff\" d=\"M10 1.556H4v6h6z\" class=\"jp-icon3\"/>\n    </clipPath>\n  </defs>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/add-below.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/add-below.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"14\" height=\"14\" fill=\"none\" viewBox=\"0 0 14 14\">\n  <g clip-path=\"url(#addbelowa)\">\n    <path fill=\"#616161\" stroke=\"#616161\" stroke-width=\".7\" d=\"M9.25 10.07H7.375V8.193A.376.376 0 0 0 7 7.82a.376.376 0 0 0-.375.375v1.875H4.75a.376.376 0 0 0-.375.375c0 .207.169.375.375.375h1.875v1.875c0 .207.169.375.375.375a.376.376 0 0 0 .375-.375V10.82H9.25a.376.376 0 0 0 .375-.375.376.376 0 0 0-.375-.375Z\" class=\"jp-icon3\"/>\n  </g>\n  <path fill=\"#616161\" fill-rule=\"evenodd\" d=\"M2.5 5.5v-2h9v2zM2 7a1 1 0 0 1-1-1V3a1 1 0 0 1 1-1h10a1 1 0 0 1 1 1v3a1 1 0 0 1-1 1z\" class=\"jp-icon3\" clip-rule=\"evenodd\"/>\n  <defs>\n    <clipPath id=\"addbelowa\">\n      <path fill=\"#fff\" d=\"M4 13.444h6v-6H4z\" class=\"jp-icon3\"/>\n    </clipPath>\n  </defs>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/add.svg":
/*!********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/add.svg ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/bug-dot.svg":
/*!************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/bug-dot.svg ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" fill=\"none\" viewBox=\"0 0 24 24\">\n  <g fill=\"#616161\" class=\"jp-icon3 jp-icon-selectable\">\n    <path fill-rule=\"evenodd\" d=\"M17.19 8H20v2h-2.09c.05.33.09.66.09 1v1h2v2h-2v.027a4.5 4.5 0 0 0-3.545 6.447A5.997 5.997 0 0 1 6.81 18H4v-2h2.09c-.05-.33-.09-.66-.09-1v-1H4v-2h2v-1c0-.34.04-.67.09-1H4V8h2.81c.45-.78 1.07-1.45 1.81-1.96L7 4.41 8.41 3l2.18 2.17c.45-.11.92-.17 1.41-.17s.96.06 1.42.17L15.59 3 17 4.41l-1.63 1.63c.75.51 1.37 1.18 1.82 1.96M10 16h4v-2h-4zm0-4h4v-2h-4z\" clip-rule=\"evenodd\"/>\n    <path d=\"M22 18.5a3.5 3.5 0 1 1-7 0 3.5 3.5 0 0 1 7 0\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/bug.svg":
/*!********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/bug.svg ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M20 8h-2.81a6 6 0 0 0-1.82-1.96L17 4.41 15.59 3l-2.17 2.17C12.96 5.06 12.49 5 12 5s-.96.06-1.41.17L8.41 3 7 4.41l1.62 1.63C7.88 6.55 7.26 7.22 6.81 8H4v2h2.09c-.05.33-.09.66-.09 1v1H4v2h2v1c0 .34.04.67.09 1H4v2h2.81c1.04 1.79 2.97 3 5.19 3s4.15-1.21 5.19-3H20v-2h-2.09c.05-.33.09-.66.09-1v-1h2v-2h-2v-1c0-.34-.04-.67-.09-1H20zm-6 8h-4v-2h4zm0-4h-4v-2h4z\" class=\"jp-icon3 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/check.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/check.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M9 16.17 4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z\" class=\"jp-icon3 jp-icon-selectable\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/circle-empty.svg":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/circle-empty.svg ***!
  \*****************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2m0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/circle.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/circle.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 18 18\">\n  <circle cx=\"9\" cy=\"9\" r=\"8\" fill=\"#616161\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/cleaning.svg":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/cleaning.svg ***!
  \*************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M16 11h-1V3c0-1.1-.9-2-2-2h-2c-1.1 0-2 .9-2 2v8H8c-2.76 0-5 2.24-5 5v7h18v-7c0-2.76-2.24-5-5-5m3 10h-2v-3c0-.55-.45-1-1-1s-1 .45-1 1v3h-2v-3c0-.55-.45-1-1-1s-1 .45-1 1v3H9v-3c0-.55-.45-1-1-1s-1 .45-1 1v3H5v-5c0-1.65 1.35-3 3-3h8c1.65 0 3 1.35 3 3z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/clear.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/clear.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <mask id=\"cleara\">\n    <path fill=\"#fff\" d=\"M0 0h24v24H0z\"/>\n    <circle cx=\"12\" cy=\"12\" r=\"8\" fill=\"#000\"/>\n  </mask>\n  <g fill=\"#616161\" class=\"jp-icon3\">\n    <path d=\"M4.929 6.343 6.343 4.93l12.728 12.728-1.414 1.414z\"/>\n    <circle cx=\"12\" cy=\"12\" r=\"10\" mask=\"url(#cleara)\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/close.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/close.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <circle cx=\"12\" cy=\"12\" r=\"11\" fill=\"none\" class=\"jp-icon-none jp-icon-selectable-inverse jp-icon3-hover\"/>\n  <path fill=\"#616161\" d=\"M19 6.41 17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z\" class=\"jp-icon3 jp-icon-selectable jp-icon-accent2-hover\"/>\n  <circle cx=\"12\" cy=\"12\" r=\"7\" fill=\"none\" class=\"jp-icon-none jp-icon-busy\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/code.svg":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/code.svg ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"22\" height=\"22\" viewBox=\"0 0 28 28\">\n  <path fill=\"#616161\" d=\"M11.4 18.6 6.8 14l4.6-4.6L10 8l-6 6 6 6zm5.2 0 4.6-4.6-4.6-4.6L18 8l6 6-6 6z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/collapse-all.svg":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/collapse-all.svg ***!
  \*****************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <g fill=\"#616161\" class=\"jp-icon3\">\n    <path d=\"M8 2h12c1 0 2 1 2 2v12c0 1 0 2-2 2V4H6c0-2 1-2 2-2\"/>\n    <path d=\"M18 8c0-1-1-2-2-2H4C3 6 2 7 2 8v12c0 1 1 2 2 2h12c1 0 2-1 2-2zm-2 0v12H4V8z\"/>\n    <path d=\"M6 13v2h8v-2z\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/copy.svg":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/copy.svg ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 18 18\">\n  <path fill=\"#616161\" d=\"M11.9 1H3.2c-.8 0-1.5.7-1.5 1.5v10.2h1.5V2.5h8.7zm2.2 2.9h-8c-.8 0-1.5.7-1.5 1.5v10.2c0 .8.7 1.5 1.5 1.5h8c.8 0 1.5-.7 1.5-1.5V5.4c-.1-.8-.7-1.5-1.5-1.5m0 11.6h-8V5.4h8z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/cut.svg":
/*!********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/cut.svg ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M9.64 7.64c.23-.5.36-1.05.36-1.64 0-2.21-1.79-4-4-4S2 3.79 2 6s1.79 4 4 4c.59 0 1.14-.13 1.64-.36L10 12l-2.36 2.36C7.14 14.13 6.59 14 6 14c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4c0-.59-.13-1.14-.36-1.64L12 14l7 7h3v-1zM6 8c-1.1 0-2-.89-2-2s.9-2 2-2 2 .89 2 2-.9 2-2 2m0 12c-1.1 0-2-.89-2-2s.9-2 2-2 2 .89 2 2-.9 2-2 2m6-7.5c-.28 0-.5-.22-.5-.5s.22-.5.5-.5.5.22.5.5-.22.5-.5.5M19 3l-6 6 2 2 7-7V3z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/delete.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/delete.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#626262\" d=\"M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6zM19 4h-3.5l-1-1h-5l-1 1H5v2h14z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dock-bottom.svg":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dock-bottom.svg ***!
  \****************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg width=\"16\" version=\"1.1\" viewBox=\"0 0 22 22\" xmlns=\"http://www.w3.org/2000/svg\">\n <path class=\"jp-icon3\" d=\"m19.8 19.8v-17.6h-17.6v17.6zm-15.408-2.2v-3.8027h13.208v3.8027zm13.208-5.5301h-13.218v-7.6699h13.218z\" fill=\"#616161\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dock-left.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dock-left.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg width=\"16\" version=\"1.1\" viewBox=\"0 0 22 22\" xmlns=\"http://www.w3.org/2000/svg\">\n <path class=\"jp-icon3\" d=\"m2.2 19.8h17.6v-17.6h-17.6zm2.2-15.408h3.8027v13.208h-3.8027zm5.5301 13.208v-13.218h7.6699v13.218z\" fill=\"#616161\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dock-right.svg":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dock-right.svg ***!
  \***************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg width=\"16\" version=\"1.1\" viewBox=\"0 0 22 22\" xmlns=\"http://www.w3.org/2000/svg\">\n <path class=\"jp-icon3\" d=\"m19.8 2.2h-17.6v17.6h17.6zm-2.2 15.408h-3.8027v-13.208h3.8027zm-5.5301-13.208v13.218h-7.6699v-13.218z\" fill=\"#616161\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dock-top.svg":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dock-top.svg ***!
  \*************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg width=\"16\" version=\"1.1\" viewBox=\"0 0 22 22\" xmlns=\"http://www.w3.org/2000/svg\">\n <path class=\"jp-icon3\" d=\"m2.2 2.2v17.6h17.6v-17.6zm15.408 2.2v3.8027h-13.208v-3.8027zm-13.208 5.5301h13.218v7.6699h-13.218z\" fill=\"#616161\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dots.svg":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/dots.svg ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<svg width=\"16\" version=\"1.1\" viewBox=\"0 0 24 24\" xmlns=\"http://www.w3.org/2000/svg\">\n <g class=\"jp-icon3\" transform=\"rotate(90,12,12)\" fill=\"#616161\">\n  <circle cx=\"5\" cy=\"12\" r=\"2\"/>\n  <circle cx=\"12\" cy=\"12\" r=\"2\"/>\n  <circle cx=\"19\" cy=\"12\" r=\"2\"/>\n </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/download.svg":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/download.svg ***!
  \*************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M19 9h-4V3H9v6H5l7 7zM5 18v2h14v-2z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/duplicate.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/duplicate.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"14\" height=\"14\" fill=\"none\" viewBox=\"0 0 14 14\">\n  <path fill=\"#616161\" fill-rule=\"evenodd\" d=\"M2.8.875h6.096c.305 0 .554.264.554.587s-.25.587-.554.587H3.354c-.305 0-.554.264-.554.587V9.68c0 .322-.25.587-.554.587s-.554-.264-.554-.587V2.049c0-.646.498-1.174 1.108-1.174M5.367 11.9V4.55h5.716v7.35zM4.142 4.142c0-.451.365-.817.816-.817h6.534c.45 0 .816.366.816.817v8.166a.817.817 0 0 1-.816.817H4.958a.817.817 0 0 1-.816-.817z\" class=\"jp-icon3\" clip-rule=\"evenodd\"/>\n  <path fill=\"#616161\" stroke=\"#616161\" stroke-width=\".5\" d=\"M9.436 8.265H8.364v1.071a.215.215 0 0 1-.214.215.215.215 0 0 1-.214-.215v-1.07H6.864a.215.215 0 0 1-.214-.215c0-.118.096-.215.214-.215h1.072v-1.07a.214.214 0 1 1 .428-.001v1.072h1.072c.118 0 .214.096.214.214a.215.215 0 0 1-.214.214Z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/edit.svg":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/edit.svg ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M3 17.25V21h3.75L17.81 9.94l-3.75-3.75zM20.71 7.04a.996.996 0 0 0 0-1.41l-2.34-2.34a.996.996 0 0 0-1.41 0l-1.83 1.83 3.75 3.75z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/ellipses.svg":
/*!*************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/ellipses.svg ***!
  \*************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <g fill=\"#616161\" class=\"jp-icon3\">\n    <circle cx=\"5\" cy=\"12\" r=\"2\"/>\n    <circle cx=\"12\" cy=\"12\" r=\"2\"/>\n    <circle cx=\"19\" cy=\"12\" r=\"2\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/expand-all.svg":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/expand-all.svg ***!
  \***************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <g fill=\"#616161\" class=\"jp-icon3\">\n    <path d=\"M8 2h12c1 0 2 1 2 2v12c0 1 0 2-2 2V4H6c0-2 1-2 2-2\"/>\n    <path d=\"M18 8c0-1-1-2-2-2H4C3 6 2 7 2 8v12c0 1 1 2 2 2h12c1 0 2-1 2-2zm-2 0v12H4V8z\"/>\n    <path d=\"M11 10H9v3H6v2h3v3h2v-3h3v-2h-3z\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/fast-forward.svg":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/fast-forward.svg ***!
  \*****************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"m4 18 8.5-6L4 6zm9-12v12l8.5-6z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/file-upload.svg":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/file-upload.svg ***!
  \****************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M9 16h6v-6h4l-7-7-7 7h4zm-4 2h14v2H5z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/filter-list.svg":
/*!****************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/filter-list.svg ***!
  \****************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M10 18h4v-2h-4zM3 6v2h18V6zm3 7h12v-2H6z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/launch.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/launch.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"32\" viewBox=\"0 0 32 32\">\n  <g fill=\"#616161\" class=\"jp-icon3 jp-icon-selectable\">\n    <path d=\"M26 28H6a2.003 2.003 0 0 1-2-2V6a2.003 2.003 0 0 1 2-2h10v2H6v20h20V16h2v10a2.003 2.003 0 0 1-2 2\"/>\n    <path d=\"M20 2v2h6.586L18 12.586 19.414 14 28 5.414V12h2V2z\"/>\n  </g>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/link.svg":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/link.svg ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M3.9 12c0-1.71 1.39-3.1 3.1-3.1h4V7H7c-2.76 0-5 2.24-5 5s2.24 5 5 5h4v-1.9H7c-1.71 0-3.1-1.39-3.1-3.1M8 13h8v-2H8zm9-6h-4v1.9h4c1.71 0 3.1 1.39 3.1 3.1s-1.39 3.1-3.1 3.1h-4V17h4c2.76 0 5-2.24 5-5s-2.24-5-5-5\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/move-down.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/move-down.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"14\" height=\"14\" fill=\"none\" viewBox=\"0 0 14 14\">\n  <path fill=\"#616161\" d=\"M12.471 7.529a.748.748 0 0 0-1.057-1.058L7.75 10.127V1.75a.75.75 0 0 0-1.5 0v8.378l-3.653-3.66a.753.753 0 1 0-1.065 1.064l4.76 4.76a1 1 0 0 0 1.415 0z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/move-up.svg":
/*!************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/move-up.svg ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"14\" height=\"14\" fill=\"none\" viewBox=\"0 0 14 14\">\n  <path fill=\"#616161\" d=\"M1.529 6.471a.748.748 0 0 0 1.057 1.058L6.25 3.873v8.377a.75.75 0 0 0 1.5 0V3.873l3.653 3.659a.753.753 0 1 0 1.065-1.064l-4.76-4.76a1 1 0 0 0-1.415 0z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/new-folder.svg":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/new-folder.svg ***!
  \***************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M20 6h-8l-2-2H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2m-1 8h-3v3h-2v-3h-3v-2h3V9h2v3h3z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/numbering.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/numbering.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"22\" height=\"22\" viewBox=\"0 0 28 28\">\n  <path fill=\"#616161\" d=\"M4 19h2v.5H5v1h1v.5H4v1h3v-4H4zm1-9h1V6H4v1h1zm-1 3h1.8L4 15.1v.9h3v-1H5.2L7 12.9V12H4zm5-6v2h14V7zm0 14h14v-2H9zm0-6h14v-2H9z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/offline-bolt.svg":
/*!*****************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/offline-bolt.svg ***!
  \*****************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M12 2.02c-5.51 0-9.98 4.47-9.98 9.98s4.47 9.98 9.98 9.98 9.98-4.47 9.98-9.98S17.51 2.02 12 2.02M11.48 20v-6.26H8L13 4v6.26h3.35z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/paste.svg":
/*!**********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/paste.svg ***!
  \**********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M19 2h-4.18C14.4.84 13.3 0 12 0S9.6.84 9.18 2H5c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2m-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1m7 18H5V4h2v3h10V4h2z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/redo.svg":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/redo.svg ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M18.4 10.6C16.55 8.99 14.15 8 11.5 8c-4.65 0-8.58 3.03-9.96 7.22L3.9 16a8 8 0 0 1 7.6-5.5c1.95 0 3.73.72 5.12 1.88L13 16h9V7z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/refresh.svg":
/*!************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/refresh.svg ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 18 18\">\n  <path fill=\"#616161\" d=\"M9 13.5c-2.49 0-4.5-2.01-4.5-4.5S6.51 4.5 9 4.5c1.24 0 2.36.52 3.17 1.33L10 8h5V3l-1.76 1.76A6 6 0 0 0 9 3C5.69 3 3.01 5.69 3.01 9S5.69 15 9 15a5.98 5.98 0 0 0 5.9-5h-1.52c-.46 2-2.24 3.5-4.38 3.5\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/run.svg":
/*!********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/run.svg ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M8 5v14l11-7z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/save.svg":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/save.svg ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M17 3H5a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14c1.1 0 2-.9 2-2V7zm-5 16c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3m3-10H5V5h10z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/search.svg":
/*!***********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/search.svg ***!
  \***********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 18 18\">\n  <path fill=\"#616161\" d=\"M12.1 10.9h-.7l-.2-.2c.8-.9 1.3-2.2 1.3-3.5 0-3-2.4-5.4-5.4-5.4S1.8 4.2 1.8 7.1s2.4 5.4 5.4 5.4c1.3 0 2.5-.5 3.5-1.3l.2.2v.7l4.1 4.1 1.2-1.2zm-5 0c-2.1 0-3.7-1.7-3.7-3.7s1.7-3.7 3.7-3.7 3.7 1.7 3.7 3.7-1.6 3.7-3.7 3.7\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/stop.svg":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/stop.svg ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M6 6h12v12H6z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/table-rows.svg":
/*!***************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/table-rows.svg ***!
  \***************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M21 8H3V4h18zm0 2H3v4h18zm0 6H3v4h18z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/tag.svg":
/*!********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/tag.svg ***!
  \********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"28\" height=\"28\" viewBox=\"0 0 43 28\">\n  <path fill=\"#616161\" d=\"M28.833 12.334 33 16.501l4.166-4.167zM16.21 21.61c-.523.52-1.366.52-1.885 0l-7.342-6.885c-.41-.386-.9-1.115-.935-1.677-.095-1.52-.028-4.429.018-5.971A1.093 1.093 0 0 1 7.118 6.03c1.97-.046 6.146-.095 6.534.293l8.085 7.315c.519.52.048 1.833-.475 2.356zM9.775 8.265a1.126 1.126 0 1 0-1.593 1.592 1.126 1.126 0 0 0 1.593-1.592\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/tree-view.svg":
/*!**************************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/tree-view.svg ***!
  \**************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"24\" height=\"24\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M22 11V3h-7v3H9V3H2v8h7V8h2v10h4v3h7v-8h-7v3h-2V8h2v3z\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/undo.svg":
/*!*********************************************************************************!*\
  !*** ../../node_modules/@jupyterlab/ui-components/style/icons/toolbar/undo.svg ***!
  \*********************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"16\" viewBox=\"0 0 24 24\">\n  <path fill=\"#616161\" d=\"M12.5 8c-2.65 0-5.05.99-6.9 2.6L2 7v9h9l-3.62-3.62c1.39-1.16 3.16-1.88 5.12-1.88 3.54 0 6.55 2.31 7.6 5.5l2.37-.78C21.08 11.03 17.15 8 12.5 8\" class=\"jp-icon3\"/>\n</svg>\n";

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/createPopper.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/createPopper.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPopper: () => (/* binding */ createPopper),
/* harmony export */   detectOverflow: () => (/* reexport safe */ _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   popperGenerator: () => (/* binding */ popperGenerator)
/* harmony export */ });
/* harmony import */ var _dom_utils_getCompositeRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dom-utils/getCompositeRect.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js");
/* harmony import */ var _dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dom-utils/getLayoutRect.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js");
/* harmony import */ var _dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dom-utils/listScrollParents.js */ "../../node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dom-utils/getOffsetParent.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _utils_orderModifiers_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils/orderModifiers.js */ "../../node_modules/@popperjs/core/lib/utils/orderModifiers.js");
/* harmony import */ var _utils_debounce_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils/debounce.js */ "../../node_modules/@popperjs/core/lib/utils/debounce.js");
/* harmony import */ var _utils_mergeByName_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./utils/mergeByName.js */ "../../node_modules/@popperjs/core/lib/utils/mergeByName.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./utils/detectOverflow.js */ "../../node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dom-utils/instanceOf.js */ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");









var DEFAULT_OPTIONS = {
  placement: 'bottom',
  modifiers: [],
  strategy: 'absolute'
};

function areValidElements() {
  for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
    args[_key] = arguments[_key];
  }

  return !args.some(function (element) {
    return !(element && typeof element.getBoundingClientRect === 'function');
  });
}

function popperGenerator(generatorOptions) {
  if (generatorOptions === void 0) {
    generatorOptions = {};
  }

  var _generatorOptions = generatorOptions,
      _generatorOptions$def = _generatorOptions.defaultModifiers,
      defaultModifiers = _generatorOptions$def === void 0 ? [] : _generatorOptions$def,
      _generatorOptions$def2 = _generatorOptions.defaultOptions,
      defaultOptions = _generatorOptions$def2 === void 0 ? DEFAULT_OPTIONS : _generatorOptions$def2;
  return function createPopper(reference, popper, options) {
    if (options === void 0) {
      options = defaultOptions;
    }

    var state = {
      placement: 'bottom',
      orderedModifiers: [],
      options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions),
      modifiersData: {},
      elements: {
        reference: reference,
        popper: popper
      },
      attributes: {},
      styles: {}
    };
    var effectCleanupFns = [];
    var isDestroyed = false;
    var instance = {
      state: state,
      setOptions: function setOptions(setOptionsAction) {
        var options = typeof setOptionsAction === 'function' ? setOptionsAction(state.options) : setOptionsAction;
        cleanupModifierEffects();
        state.options = Object.assign({}, defaultOptions, state.options, options);
        state.scrollParents = {
          reference: (0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_8__.isElement)(reference) ? (0,_dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_2__["default"])(reference) : reference.contextElement ? (0,_dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_2__["default"])(reference.contextElement) : [],
          popper: (0,_dom_utils_listScrollParents_js__WEBPACK_IMPORTED_MODULE_2__["default"])(popper)
        }; // Orders the modifiers based on their dependencies and `phase`
        // properties

        var orderedModifiers = (0,_utils_orderModifiers_js__WEBPACK_IMPORTED_MODULE_4__["default"])((0,_utils_mergeByName_js__WEBPACK_IMPORTED_MODULE_6__["default"])([].concat(defaultModifiers, state.options.modifiers))); // Strip out disabled modifiers

        state.orderedModifiers = orderedModifiers.filter(function (m) {
          return m.enabled;
        });
        runModifierEffects();
        return instance.update();
      },
      // Sync update – it will always be executed, even if not necessary. This
      // is useful for low frequency updates where sync behavior simplifies the
      // logic.
      // For high frequency updates (e.g. `resize` and `scroll` events), always
      // prefer the async Popper#update method
      forceUpdate: function forceUpdate() {
        if (isDestroyed) {
          return;
        }

        var _state$elements = state.elements,
            reference = _state$elements.reference,
            popper = _state$elements.popper; // Don't proceed if `reference` or `popper` are not valid elements
        // anymore

        if (!areValidElements(reference, popper)) {
          return;
        } // Store the reference and popper rects to be read by modifiers


        state.rects = {
          reference: (0,_dom_utils_getCompositeRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])(reference, (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_3__["default"])(popper), state.options.strategy === 'fixed'),
          popper: (0,_dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_1__["default"])(popper)
        }; // Modifiers have the ability to reset the current update cycle. The
        // most common use case for this is the `flip` modifier changing the
        // placement, which then needs to re-run all the modifiers, because the
        // logic was previously ran for the previous placement and is therefore
        // stale/incorrect

        state.reset = false;
        state.placement = state.options.placement; // On each update cycle, the `modifiersData` property for each modifier
        // is filled with the initial data specified by the modifier. This means
        // it doesn't persist and is fresh on each update.
        // To ensure persistent data, use `${name}#persistent`

        state.orderedModifiers.forEach(function (modifier) {
          return state.modifiersData[modifier.name] = Object.assign({}, modifier.data);
        });

        for (var index = 0; index < state.orderedModifiers.length; index++) {
          if (state.reset === true) {
            state.reset = false;
            index = -1;
            continue;
          }

          var _state$orderedModifie = state.orderedModifiers[index],
              fn = _state$orderedModifie.fn,
              _state$orderedModifie2 = _state$orderedModifie.options,
              _options = _state$orderedModifie2 === void 0 ? {} : _state$orderedModifie2,
              name = _state$orderedModifie.name;

          if (typeof fn === 'function') {
            state = fn({
              state: state,
              options: _options,
              name: name,
              instance: instance
            }) || state;
          }
        }
      },
      // Async and optimistically optimized update – it will not be executed if
      // not necessary (debounced to run at most once-per-tick)
      update: (0,_utils_debounce_js__WEBPACK_IMPORTED_MODULE_5__["default"])(function () {
        return new Promise(function (resolve) {
          instance.forceUpdate();
          resolve(state);
        });
      }),
      destroy: function destroy() {
        cleanupModifierEffects();
        isDestroyed = true;
      }
    };

    if (!areValidElements(reference, popper)) {
      return instance;
    }

    instance.setOptions(options).then(function (state) {
      if (!isDestroyed && options.onFirstUpdate) {
        options.onFirstUpdate(state);
      }
    }); // Modifiers have the ability to execute arbitrary code before the first
    // update cycle runs. They will be executed in the same order as the update
    // cycle. This is useful when a modifier adds some persistent data that
    // other modifiers need to use, but the modifier is run after the dependent
    // one.

    function runModifierEffects() {
      state.orderedModifiers.forEach(function (_ref) {
        var name = _ref.name,
            _ref$options = _ref.options,
            options = _ref$options === void 0 ? {} : _ref$options,
            effect = _ref.effect;

        if (typeof effect === 'function') {
          var cleanupFn = effect({
            state: state,
            name: name,
            instance: instance,
            options: options
          });

          var noopFn = function noopFn() {};

          effectCleanupFns.push(cleanupFn || noopFn);
        }
      });
    }

    function cleanupModifierEffects() {
      effectCleanupFns.forEach(function (fn) {
        return fn();
      });
      effectCleanupFns = [];
    }

    return instance;
  };
}
var createPopper = /*#__PURE__*/popperGenerator(); // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/contains.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/contains.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ contains)
/* harmony export */ });
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");

function contains(parent, child) {
  var rootNode = child.getRootNode && child.getRootNode(); // First, attempt with faster native method

  if (parent.contains(child)) {
    return true;
  } // then fallback to custom implementation with Shadow DOM support
  else if (rootNode && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isShadowRoot)(rootNode)) {
      var next = child;

      do {
        if (next && parent.isSameNode(next)) {
          return true;
        } // $FlowFixMe[prop-missing]: need a better way to handle this...


        next = next.parentNode || next.host;
      } while (next);
    } // Give up, the result is false


  return false;
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js":
/*!********************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getBoundingClientRect)
/* harmony export */ });
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/math.js */ "../../node_modules/@popperjs/core/lib/utils/math.js");
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindow.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _isLayoutViewport_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./isLayoutViewport.js */ "../../node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js");




function getBoundingClientRect(element, includeScale, isFixedStrategy) {
  if (includeScale === void 0) {
    includeScale = false;
  }

  if (isFixedStrategy === void 0) {
    isFixedStrategy = false;
  }

  var clientRect = element.getBoundingClientRect();
  var scaleX = 1;
  var scaleY = 1;

  if (includeScale && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isHTMLElement)(element)) {
    scaleX = element.offsetWidth > 0 ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_1__.round)(clientRect.width) / element.offsetWidth || 1 : 1;
    scaleY = element.offsetHeight > 0 ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_1__.round)(clientRect.height) / element.offsetHeight || 1 : 1;
  }

  var _ref = (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isElement)(element) ? (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element) : window,
      visualViewport = _ref.visualViewport;

  var addVisualOffsets = !(0,_isLayoutViewport_js__WEBPACK_IMPORTED_MODULE_3__["default"])() && isFixedStrategy;
  var x = (clientRect.left + (addVisualOffsets && visualViewport ? visualViewport.offsetLeft : 0)) / scaleX;
  var y = (clientRect.top + (addVisualOffsets && visualViewport ? visualViewport.offsetTop : 0)) / scaleY;
  var width = clientRect.width / scaleX;
  var height = clientRect.height / scaleY;
  return {
    width: width,
    height: height,
    top: y,
    right: x + width,
    bottom: y + height,
    left: x,
    x: x,
    y: y
  };
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getClippingRect)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "../../node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _getViewportRect_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getViewportRect.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js");
/* harmony import */ var _getDocumentRect_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getDocumentRect.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js");
/* harmony import */ var _listScrollParents_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./listScrollParents.js */ "../../node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js");
/* harmony import */ var _getOffsetParent_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getOffsetParent.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./getDocumentElement.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./getComputedStyle.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./instanceOf.js */ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./getParentNode.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _contains_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./contains.js */ "../../node_modules/@popperjs/core/lib/dom-utils/contains.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./getNodeName.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _utils_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../utils/rectToClientRect.js */ "../../node_modules/@popperjs/core/lib/utils/rectToClientRect.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils/math.js */ "../../node_modules/@popperjs/core/lib/utils/math.js");















function getInnerBoundingClientRect(element, strategy) {
  var rect = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_8__["default"])(element, false, strategy === 'fixed');
  rect.top = rect.top + element.clientTop;
  rect.left = rect.left + element.clientLeft;
  rect.bottom = rect.top + element.clientHeight;
  rect.right = rect.left + element.clientWidth;
  rect.width = element.clientWidth;
  rect.height = element.clientHeight;
  rect.x = rect.left;
  rect.y = rect.top;
  return rect;
}

function getClientRectFromMixedType(element, clippingParent, strategy) {
  return clippingParent === _enums_js__WEBPACK_IMPORTED_MODULE_0__.viewport ? (0,_utils_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_12__["default"])((0,_getViewportRect_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element, strategy)) : (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_7__.isElement)(clippingParent) ? getInnerBoundingClientRect(clippingParent, strategy) : (0,_utils_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_12__["default"])((0,_getDocumentRect_js__WEBPACK_IMPORTED_MODULE_2__["default"])((0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_5__["default"])(element)));
} // A "clipping parent" is an overflowable container with the characteristic of
// clipping (or hiding) overflowing elements with a position different from
// `initial`


function getClippingParents(element) {
  var clippingParents = (0,_listScrollParents_js__WEBPACK_IMPORTED_MODULE_3__["default"])((0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_9__["default"])(element));
  var canEscapeClipping = ['absolute', 'fixed'].indexOf((0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_6__["default"])(element).position) >= 0;
  var clipperElement = canEscapeClipping && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_7__.isHTMLElement)(element) ? (0,_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_4__["default"])(element) : element;

  if (!(0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_7__.isElement)(clipperElement)) {
    return [];
  } // $FlowFixMe[incompatible-return]: https://github.com/facebook/flow/issues/1414


  return clippingParents.filter(function (clippingParent) {
    return (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_7__.isElement)(clippingParent) && (0,_contains_js__WEBPACK_IMPORTED_MODULE_10__["default"])(clippingParent, clipperElement) && (0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_11__["default"])(clippingParent) !== 'body';
  });
} // Gets the maximum area that the element is visible in due to any number of
// clipping parents


function getClippingRect(element, boundary, rootBoundary, strategy) {
  var mainClippingParents = boundary === 'clippingParents' ? getClippingParents(element) : [].concat(boundary);
  var clippingParents = [].concat(mainClippingParents, [rootBoundary]);
  var firstClippingParent = clippingParents[0];
  var clippingRect = clippingParents.reduce(function (accRect, clippingParent) {
    var rect = getClientRectFromMixedType(element, clippingParent, strategy);
    accRect.top = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.max)(rect.top, accRect.top);
    accRect.right = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.min)(rect.right, accRect.right);
    accRect.bottom = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.min)(rect.bottom, accRect.bottom);
    accRect.left = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_13__.max)(rect.left, accRect.left);
    return accRect;
  }, getClientRectFromMixedType(element, firstClippingParent, strategy));
  clippingRect.width = clippingRect.right - clippingRect.left;
  clippingRect.height = clippingRect.bottom - clippingRect.top;
  clippingRect.x = clippingRect.left;
  clippingRect.y = clippingRect.top;
  return clippingRect;
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getCompositeRect.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getCompositeRect)
/* harmony export */ });
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _getNodeScroll_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getNodeScroll.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getNodeName.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./instanceOf.js */ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./getWindowScrollBarX.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./getDocumentElement.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _isScrollParent_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./isScrollParent.js */ "../../node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/math.js */ "../../node_modules/@popperjs/core/lib/utils/math.js");









function isElementScaled(element) {
  var rect = element.getBoundingClientRect();
  var scaleX = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_7__.round)(rect.width) / element.offsetWidth || 1;
  var scaleY = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_7__.round)(rect.height) / element.offsetHeight || 1;
  return scaleX !== 1 || scaleY !== 1;
} // Returns the composite rect of an element relative to its offsetParent.
// Composite means it takes into account transforms as well as layout.


function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
  if (isFixed === void 0) {
    isFixed = false;
  }

  var isOffsetParentAnElement = (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_3__.isHTMLElement)(offsetParent);
  var offsetParentIsScaled = (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_3__.isHTMLElement)(offsetParent) && isElementScaled(offsetParent);
  var documentElement = (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_5__["default"])(offsetParent);
  var rect = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])(elementOrVirtualElement, offsetParentIsScaled, isFixed);
  var scroll = {
    scrollLeft: 0,
    scrollTop: 0
  };
  var offsets = {
    x: 0,
    y: 0
  };

  if (isOffsetParentAnElement || !isOffsetParentAnElement && !isFixed) {
    if ((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_2__["default"])(offsetParent) !== 'body' || // https://github.com/popperjs/popper-core/issues/1078
    (0,_isScrollParent_js__WEBPACK_IMPORTED_MODULE_6__["default"])(documentElement)) {
      scroll = (0,_getNodeScroll_js__WEBPACK_IMPORTED_MODULE_1__["default"])(offsetParent);
    }

    if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_3__.isHTMLElement)(offsetParent)) {
      offsets = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])(offsetParent, true);
      offsets.x += offsetParent.clientLeft;
      offsets.y += offsetParent.clientTop;
    } else if (documentElement) {
      offsets.x = (0,_getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_4__["default"])(documentElement);
    }
  }

  return {
    x: rect.left + scroll.scrollLeft - offsets.x,
    y: rect.top + scroll.scrollTop - offsets.y,
    width: rect.width,
    height: rect.height
  };
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getComputedStyle)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindow.js");

function getComputedStyle(element) {
  return (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element).getComputedStyle(element);
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js":
/*!*****************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDocumentElement)
/* harmony export */ });
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./instanceOf.js */ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");

function getDocumentElement(element) {
  // $FlowFixMe[incompatible-return]: assume body is always available
  return (((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_0__.isElement)(element) ? element.ownerDocument : // $FlowFixMe[prop-missing]
  element.document) || window.document).documentElement;
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getDocumentRect.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getDocumentRect)
/* harmony export */ });
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getDocumentElement.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getComputedStyle.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindowScrollBarX.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js");
/* harmony import */ var _getWindowScroll_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getWindowScroll.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/math.js */ "../../node_modules/@popperjs/core/lib/utils/math.js");




 // Gets the entire size of the scrollable document area, even extending outside
// of the `<html>` and `<body>` rect bounds if horizontally scrollable

function getDocumentRect(element) {
  var _element$ownerDocumen;

  var html = (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var winScroll = (0,_getWindowScroll_js__WEBPACK_IMPORTED_MODULE_3__["default"])(element);
  var body = (_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body;
  var width = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_4__.max)(html.scrollWidth, html.clientWidth, body ? body.scrollWidth : 0, body ? body.clientWidth : 0);
  var height = (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_4__.max)(html.scrollHeight, html.clientHeight, body ? body.scrollHeight : 0, body ? body.clientHeight : 0);
  var x = -winScroll.scrollLeft + (0,_getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element);
  var y = -winScroll.scrollTop;

  if ((0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_1__["default"])(body || html).direction === 'rtl') {
    x += (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_4__.max)(html.clientWidth, body ? body.clientWidth : 0) - width;
  }

  return {
    width: width,
    height: height,
    x: x,
    y: y
  };
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getHTMLElementScroll)
/* harmony export */ });
function getHTMLElementScroll(element) {
  return {
    scrollLeft: element.scrollLeft,
    scrollTop: element.scrollTop
  };
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getLayoutRect)
/* harmony export */ });
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
 // Returns the layout rect of an element relative to its offsetParent. Layout
// means it doesn't take into account transforms.

function getLayoutRect(element) {
  var clientRect = (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element); // Use the clientRect sizes if it's not been transformed.
  // Fixes https://github.com/popperjs/popper-core/issues/1223

  var width = element.offsetWidth;
  var height = element.offsetHeight;

  if (Math.abs(clientRect.width - width) <= 1) {
    width = clientRect.width;
  }

  if (Math.abs(clientRect.height - height) <= 1) {
    height = clientRect.height;
  }

  return {
    x: element.offsetLeft,
    y: element.offsetTop,
    width: width,
    height: height
  };
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getNodeName.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getNodeName.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getNodeName)
/* harmony export */ });
function getNodeName(element) {
  return element ? (element.nodeName || '').toLowerCase() : null;
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getNodeScroll.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getNodeScroll)
/* harmony export */ });
/* harmony import */ var _getWindowScroll_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindowScroll.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js");
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getWindow.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./instanceOf.js */ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _getHTMLElementScroll_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getHTMLElementScroll.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getHTMLElementScroll.js");




function getNodeScroll(node) {
  if (node === (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_1__["default"])(node) || !(0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_2__.isHTMLElement)(node)) {
    return (0,_getWindowScroll_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node);
  } else {
    return (0,_getHTMLElementScroll_js__WEBPACK_IMPORTED_MODULE_3__["default"])(node);
  }
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOffsetParent)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getNodeName.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getComputedStyle.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./instanceOf.js */ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _isTableElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./isTableElement.js */ "../../node_modules/@popperjs/core/lib/dom-utils/isTableElement.js");
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./getParentNode.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _utils_userAgent_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/userAgent.js */ "../../node_modules/@popperjs/core/lib/utils/userAgent.js");








function getTrueOffsetParent(element) {
  if (!(0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_3__.isHTMLElement)(element) || // https://github.com/popperjs/popper-core/issues/837
  (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element).position === 'fixed') {
    return null;
  }

  return element.offsetParent;
} // `.offsetParent` reports `null` for fixed elements, while absolute elements
// return the containing block


function getContainingBlock(element) {
  var isFirefox = /firefox/i.test((0,_utils_userAgent_js__WEBPACK_IMPORTED_MODULE_6__["default"])());
  var isIE = /Trident/i.test((0,_utils_userAgent_js__WEBPACK_IMPORTED_MODULE_6__["default"])());

  if (isIE && (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_3__.isHTMLElement)(element)) {
    // In IE 9, 10 and 11 fixed elements containing block is always established by the viewport
    var elementCss = (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element);

    if (elementCss.position === 'fixed') {
      return null;
    }
  }

  var currentNode = (0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_5__["default"])(element);

  if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_3__.isShadowRoot)(currentNode)) {
    currentNode = currentNode.host;
  }

  while ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_3__.isHTMLElement)(currentNode) && ['html', 'body'].indexOf((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(currentNode)) < 0) {
    var css = (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_2__["default"])(currentNode); // This is non-exhaustive but covers the most common CSS properties that
    // create a containing block.
    // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block

    if (css.transform !== 'none' || css.perspective !== 'none' || css.contain === 'paint' || ['transform', 'perspective'].indexOf(css.willChange) !== -1 || isFirefox && css.willChange === 'filter' || isFirefox && css.filter && css.filter !== 'none') {
      return currentNode;
    } else {
      currentNode = currentNode.parentNode;
    }
  }

  return null;
} // Gets the closest ancestor positioned element. Handles some edge cases,
// such as table ancestors and cross browser bugs.


function getOffsetParent(element) {
  var window = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var offsetParent = getTrueOffsetParent(element);

  while (offsetParent && (0,_isTableElement_js__WEBPACK_IMPORTED_MODULE_4__["default"])(offsetParent) && (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_2__["default"])(offsetParent).position === 'static') {
    offsetParent = getTrueOffsetParent(offsetParent);
  }

  if (offsetParent && ((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(offsetParent) === 'html' || (0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_1__["default"])(offsetParent) === 'body' && (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_2__["default"])(offsetParent).position === 'static')) {
    return window;
  }

  return offsetParent || getContainingBlock(element) || window;
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getParentNode.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getParentNode.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getParentNode)
/* harmony export */ });
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getNodeName.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getDocumentElement.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./instanceOf.js */ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");



function getParentNode(element) {
  if ((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element) === 'html') {
    return element;
  }

  return (// this is a quicker (but less type safe) way to save quite some bytes from the bundle
    // $FlowFixMe[incompatible-return]
    // $FlowFixMe[prop-missing]
    element.assignedSlot || // step into the shadow DOM of the parent of a slotted node
    element.parentNode || ( // DOM Element detected
    (0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_2__.isShadowRoot)(element) ? element.host : null) || // ShadowRoot detected
    // $FlowFixMe[incompatible-call]: HTMLElement is a Node
    (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element) // fallback

  );
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getScrollParent)
/* harmony export */ });
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getParentNode.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _isScrollParent_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isScrollParent.js */ "../../node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js");
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getNodeName.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _instanceOf_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./instanceOf.js */ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");




function getScrollParent(node) {
  if (['html', 'body', '#document'].indexOf((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_2__["default"])(node)) >= 0) {
    // $FlowFixMe[incompatible-return]: assume body is always available
    return node.ownerDocument.body;
  }

  if ((0,_instanceOf_js__WEBPACK_IMPORTED_MODULE_3__.isHTMLElement)(node) && (0,_isScrollParent_js__WEBPACK_IMPORTED_MODULE_1__["default"])(node)) {
    return node;
  }

  return getScrollParent((0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node));
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getViewportRect.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getViewportRect)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getDocumentElement.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindowScrollBarX.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js");
/* harmony import */ var _isLayoutViewport_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./isLayoutViewport.js */ "../../node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js");




function getViewportRect(element, strategy) {
  var win = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var html = (0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element);
  var visualViewport = win.visualViewport;
  var width = html.clientWidth;
  var height = html.clientHeight;
  var x = 0;
  var y = 0;

  if (visualViewport) {
    width = visualViewport.width;
    height = visualViewport.height;
    var layoutViewport = (0,_isLayoutViewport_js__WEBPACK_IMPORTED_MODULE_3__["default"])();

    if (layoutViewport || !layoutViewport && strategy === 'fixed') {
      x = visualViewport.offsetLeft;
      y = visualViewport.offsetTop;
    }
  }

  return {
    width: width,
    height: height,
    x: x + (0,_getWindowScrollBarX_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element),
    y: y
  };
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getWindow.js":
/*!********************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getWindow.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWindow)
/* harmony export */ });
function getWindow(node) {
  if (node == null) {
    return window;
  }

  if (node.toString() !== '[object Window]') {
    var ownerDocument = node.ownerDocument;
    return ownerDocument ? ownerDocument.defaultView || window : window;
  }

  return node;
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWindowScroll)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindow.js");

function getWindowScroll(node) {
  var win = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node);
  var scrollLeft = win.pageXOffset;
  var scrollTop = win.pageYOffset;
  return {
    scrollLeft: scrollLeft,
    scrollTop: scrollTop
  };
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js":
/*!******************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/getWindowScrollBarX.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getWindowScrollBarX)
/* harmony export */ });
/* harmony import */ var _getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBoundingClientRect.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getDocumentElement.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindowScroll.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindowScroll.js");



function getWindowScrollBarX(element) {
  // If <html> has a CSS width greater than the viewport, then this will be
  // incorrect for RTL.
  // Popper 1 is broken in this case and never had a bug report so let's assume
  // it's not an issue. I don't think anyone ever specifies width on <html>
  // anyway.
  // Browsers where the left scrollbar doesn't cause an issue report `0` for
  // this (e.g. Edge 2019, IE11, Safari)
  return (0,_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(element)).left + (0,_getWindowScroll_js__WEBPACK_IMPORTED_MODULE_2__["default"])(element).scrollLeft;
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isElement: () => (/* binding */ isElement),
/* harmony export */   isHTMLElement: () => (/* binding */ isHTMLElement),
/* harmony export */   isShadowRoot: () => (/* binding */ isShadowRoot)
/* harmony export */ });
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getWindow.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindow.js");


function isElement(node) {
  var OwnElement = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node).Element;
  return node instanceof OwnElement || node instanceof Element;
}

function isHTMLElement(node) {
  var OwnElement = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node).HTMLElement;
  return node instanceof OwnElement || node instanceof HTMLElement;
}

function isShadowRoot(node) {
  // IE 11 has no ShadowRoot
  if (typeof ShadowRoot === 'undefined') {
    return false;
  }

  var OwnElement = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(node).ShadowRoot;
  return node instanceof OwnElement || node instanceof ShadowRoot;
}



/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/isLayoutViewport.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isLayoutViewport)
/* harmony export */ });
/* harmony import */ var _utils_userAgent_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/userAgent.js */ "../../node_modules/@popperjs/core/lib/utils/userAgent.js");

function isLayoutViewport() {
  return !/^((?!chrome|android).)*safari/i.test((0,_utils_userAgent_js__WEBPACK_IMPORTED_MODULE_0__["default"])());
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isScrollParent)
/* harmony export */ });
/* harmony import */ var _getComputedStyle_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getComputedStyle.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");

function isScrollParent(element) {
  // Firefox wants us to check `-x` and `-y` variations as well
  var _getComputedStyle = (0,_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element),
      overflow = _getComputedStyle.overflow,
      overflowX = _getComputedStyle.overflowX,
      overflowY = _getComputedStyle.overflowY;

  return /auto|scroll|overlay|hidden/.test(overflow + overflowY + overflowX);
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/isTableElement.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/isTableElement.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isTableElement)
/* harmony export */ });
/* harmony import */ var _getNodeName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getNodeName.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");

function isTableElement(element) {
  return ['table', 'td', 'th'].indexOf((0,_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element)) >= 0;
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js":
/*!****************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/dom-utils/listScrollParents.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ listScrollParents)
/* harmony export */ });
/* harmony import */ var _getScrollParent_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getScrollParent.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getScrollParent.js");
/* harmony import */ var _getParentNode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getParentNode.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getParentNode.js");
/* harmony import */ var _getWindow_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getWindow.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _isScrollParent_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./isScrollParent.js */ "../../node_modules/@popperjs/core/lib/dom-utils/isScrollParent.js");




/*
given a DOM element, return the list of all scroll parents, up the list of ancesors
until we get to the top window object. This list is what we attach scroll listeners
to, because if any of these parent elements scroll, we'll need to re-calculate the
reference element's position.
*/

function listScrollParents(element, list) {
  var _element$ownerDocumen;

  if (list === void 0) {
    list = [];
  }

  var scrollParent = (0,_getScrollParent_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element);
  var isBody = scrollParent === ((_element$ownerDocumen = element.ownerDocument) == null ? void 0 : _element$ownerDocumen.body);
  var win = (0,_getWindow_js__WEBPACK_IMPORTED_MODULE_2__["default"])(scrollParent);
  var target = isBody ? [win].concat(win.visualViewport || [], (0,_isScrollParent_js__WEBPACK_IMPORTED_MODULE_3__["default"])(scrollParent) ? scrollParent : []) : scrollParent;
  var updatedList = list.concat(target);
  return isBody ? updatedList : // $FlowFixMe[incompatible-call]: isBody tells us target will be an HTMLElement here
  updatedList.concat(listScrollParents((0,_getParentNode_js__WEBPACK_IMPORTED_MODULE_1__["default"])(target)));
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/enums.js":
/*!******************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/enums.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   afterMain: () => (/* binding */ afterMain),
/* harmony export */   afterRead: () => (/* binding */ afterRead),
/* harmony export */   afterWrite: () => (/* binding */ afterWrite),
/* harmony export */   auto: () => (/* binding */ auto),
/* harmony export */   basePlacements: () => (/* binding */ basePlacements),
/* harmony export */   beforeMain: () => (/* binding */ beforeMain),
/* harmony export */   beforeRead: () => (/* binding */ beforeRead),
/* harmony export */   beforeWrite: () => (/* binding */ beforeWrite),
/* harmony export */   bottom: () => (/* binding */ bottom),
/* harmony export */   clippingParents: () => (/* binding */ clippingParents),
/* harmony export */   end: () => (/* binding */ end),
/* harmony export */   left: () => (/* binding */ left),
/* harmony export */   main: () => (/* binding */ main),
/* harmony export */   modifierPhases: () => (/* binding */ modifierPhases),
/* harmony export */   placements: () => (/* binding */ placements),
/* harmony export */   popper: () => (/* binding */ popper),
/* harmony export */   read: () => (/* binding */ read),
/* harmony export */   reference: () => (/* binding */ reference),
/* harmony export */   right: () => (/* binding */ right),
/* harmony export */   start: () => (/* binding */ start),
/* harmony export */   top: () => (/* binding */ top),
/* harmony export */   variationPlacements: () => (/* binding */ variationPlacements),
/* harmony export */   viewport: () => (/* binding */ viewport),
/* harmony export */   write: () => (/* binding */ write)
/* harmony export */ });
var top = 'top';
var bottom = 'bottom';
var right = 'right';
var left = 'left';
var auto = 'auto';
var basePlacements = [top, bottom, right, left];
var start = 'start';
var end = 'end';
var clippingParents = 'clippingParents';
var viewport = 'viewport';
var popper = 'popper';
var reference = 'reference';
var variationPlacements = /*#__PURE__*/basePlacements.reduce(function (acc, placement) {
  return acc.concat([placement + "-" + start, placement + "-" + end]);
}, []);
var placements = /*#__PURE__*/[].concat(basePlacements, [auto]).reduce(function (acc, placement) {
  return acc.concat([placement, placement + "-" + start, placement + "-" + end]);
}, []); // modifiers that need to read the DOM

var beforeRead = 'beforeRead';
var read = 'read';
var afterRead = 'afterRead'; // pure-logic modifiers

var beforeMain = 'beforeMain';
var main = 'main';
var afterMain = 'afterMain'; // modifier with the purpose to write to the DOM (or write into a framework state)

var beforeWrite = 'beforeWrite';
var write = 'write';
var afterWrite = 'afterWrite';
var modifierPhases = [beforeRead, read, afterRead, beforeMain, main, afterMain, beforeWrite, write, afterWrite];

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/modifiers/applyStyles.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/modifiers/applyStyles.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _dom_utils_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../dom-utils/getNodeName.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getNodeName.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dom-utils/instanceOf.js */ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");

 // This modifier takes the styles prepared by the `computeStyles` modifier
// and applies them to the HTMLElements such as popper and arrow

function applyStyles(_ref) {
  var state = _ref.state;
  Object.keys(state.elements).forEach(function (name) {
    var style = state.styles[name] || {};
    var attributes = state.attributes[name] || {};
    var element = state.elements[name]; // arrow is optional + virtual elements

    if (!(0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(element) || !(0,_dom_utils_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element)) {
      return;
    } // Flow doesn't support to extend this property, but it's the most
    // effective way to apply styles to an HTMLElement
    // $FlowFixMe[cannot-write]


    Object.assign(element.style, style);
    Object.keys(attributes).forEach(function (name) {
      var value = attributes[name];

      if (value === false) {
        element.removeAttribute(name);
      } else {
        element.setAttribute(name, value === true ? '' : value);
      }
    });
  });
}

function effect(_ref2) {
  var state = _ref2.state;
  var initialStyles = {
    popper: {
      position: state.options.strategy,
      left: '0',
      top: '0',
      margin: '0'
    },
    arrow: {
      position: 'absolute'
    },
    reference: {}
  };
  Object.assign(state.elements.popper.style, initialStyles.popper);
  state.styles = initialStyles;

  if (state.elements.arrow) {
    Object.assign(state.elements.arrow.style, initialStyles.arrow);
  }

  return function () {
    Object.keys(state.elements).forEach(function (name) {
      var element = state.elements[name];
      var attributes = state.attributes[name] || {};
      var styleProperties = Object.keys(state.styles.hasOwnProperty(name) ? state.styles[name] : initialStyles[name]); // Set all values to an empty string to unset them

      var style = styleProperties.reduce(function (style, property) {
        style[property] = '';
        return style;
      }, {}); // arrow is optional + virtual elements

      if (!(0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_1__.isHTMLElement)(element) || !(0,_dom_utils_getNodeName_js__WEBPACK_IMPORTED_MODULE_0__["default"])(element)) {
        return;
      }

      Object.assign(element.style, style);
      Object.keys(attributes).forEach(function (attribute) {
        element.removeAttribute(attribute);
      });
    });
  };
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'applyStyles',
  enabled: true,
  phase: 'write',
  fn: applyStyles,
  effect: effect,
  requires: ['computeStyles']
});

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/modifiers/arrow.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/modifiers/arrow.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "../../node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dom-utils/getLayoutRect.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js");
/* harmony import */ var _dom_utils_contains_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dom-utils/contains.js */ "../../node_modules/@popperjs/core/lib/dom-utils/contains.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dom-utils/getOffsetParent.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/getMainAxisFromPlacement.js */ "../../node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js");
/* harmony import */ var _utils_within_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/within.js */ "../../node_modules/@popperjs/core/lib/utils/within.js");
/* harmony import */ var _utils_mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/mergePaddingObject.js */ "../../node_modules/@popperjs/core/lib/utils/mergePaddingObject.js");
/* harmony import */ var _utils_expandToHashMap_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/expandToHashMap.js */ "../../node_modules/@popperjs/core/lib/utils/expandToHashMap.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../enums.js */ "../../node_modules/@popperjs/core/lib/enums.js");








 // eslint-disable-next-line import/no-unused-modules

var toPaddingObject = function toPaddingObject(padding, state) {
  padding = typeof padding === 'function' ? padding(Object.assign({}, state.rects, {
    placement: state.placement
  })) : padding;
  return (0,_utils_mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_6__["default"])(typeof padding !== 'number' ? padding : (0,_utils_expandToHashMap_js__WEBPACK_IMPORTED_MODULE_7__["default"])(padding, _enums_js__WEBPACK_IMPORTED_MODULE_8__.basePlacements));
};

function arrow(_ref) {
  var _state$modifiersData$;

  var state = _ref.state,
      name = _ref.name,
      options = _ref.options;
  var arrowElement = state.elements.arrow;
  var popperOffsets = state.modifiersData.popperOffsets;
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(state.placement);
  var axis = (0,_utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_4__["default"])(basePlacement);
  var isVertical = [_enums_js__WEBPACK_IMPORTED_MODULE_8__.left, _enums_js__WEBPACK_IMPORTED_MODULE_8__.right].indexOf(basePlacement) >= 0;
  var len = isVertical ? 'height' : 'width';

  if (!arrowElement || !popperOffsets) {
    return;
  }

  var paddingObject = toPaddingObject(options.padding, state);
  var arrowRect = (0,_dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_1__["default"])(arrowElement);
  var minProp = axis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_8__.top : _enums_js__WEBPACK_IMPORTED_MODULE_8__.left;
  var maxProp = axis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_8__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_8__.right;
  var endDiff = state.rects.reference[len] + state.rects.reference[axis] - popperOffsets[axis] - state.rects.popper[len];
  var startDiff = popperOffsets[axis] - state.rects.reference[axis];
  var arrowOffsetParent = (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_3__["default"])(arrowElement);
  var clientSize = arrowOffsetParent ? axis === 'y' ? arrowOffsetParent.clientHeight || 0 : arrowOffsetParent.clientWidth || 0 : 0;
  var centerToReference = endDiff / 2 - startDiff / 2; // Make sure the arrow doesn't overflow the popper if the center point is
  // outside of the popper bounds

  var min = paddingObject[minProp];
  var max = clientSize - arrowRect[len] - paddingObject[maxProp];
  var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
  var offset = (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_5__.within)(min, center, max); // Prevents breaking syntax highlighting...

  var axisProp = axis;
  state.modifiersData[name] = (_state$modifiersData$ = {}, _state$modifiersData$[axisProp] = offset, _state$modifiersData$.centerOffset = offset - center, _state$modifiersData$);
}

function effect(_ref2) {
  var state = _ref2.state,
      options = _ref2.options;
  var _options$element = options.element,
      arrowElement = _options$element === void 0 ? '[data-popper-arrow]' : _options$element;

  if (arrowElement == null) {
    return;
  } // CSS selector


  if (typeof arrowElement === 'string') {
    arrowElement = state.elements.popper.querySelector(arrowElement);

    if (!arrowElement) {
      return;
    }
  }

  if (!(0,_dom_utils_contains_js__WEBPACK_IMPORTED_MODULE_2__["default"])(state.elements.popper, arrowElement)) {
    return;
  }

  state.elements.arrow = arrowElement;
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'arrow',
  enabled: true,
  phase: 'main',
  fn: arrow,
  effect: effect,
  requires: ['popperOffsets'],
  requiresIfExists: ['preventOverflow']
});

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/modifiers/computeStyles.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/modifiers/computeStyles.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   mapToStyles: () => (/* binding */ mapToStyles)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "../../node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dom-utils/getOffsetParent.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dom-utils/getWindow.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
/* harmony import */ var _dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dom-utils/getDocumentElement.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dom-utils/getComputedStyle.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getComputedStyle.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "../../node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_getVariation_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/getVariation.js */ "../../node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/math.js */ "../../node_modules/@popperjs/core/lib/utils/math.js");







 // eslint-disable-next-line import/no-unused-modules

var unsetSides = {
  top: 'auto',
  right: 'auto',
  bottom: 'auto',
  left: 'auto'
}; // Round the offsets to the nearest suitable subpixel based on the DPR.
// Zooming can change the DPR, but it seems to report a value that will
// cleanly divide the values into the appropriate subpixels.

function roundOffsetsByDPR(_ref, win) {
  var x = _ref.x,
      y = _ref.y;
  var dpr = win.devicePixelRatio || 1;
  return {
    x: (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_7__.round)(x * dpr) / dpr || 0,
    y: (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_7__.round)(y * dpr) / dpr || 0
  };
}

function mapToStyles(_ref2) {
  var _Object$assign2;

  var popper = _ref2.popper,
      popperRect = _ref2.popperRect,
      placement = _ref2.placement,
      variation = _ref2.variation,
      offsets = _ref2.offsets,
      position = _ref2.position,
      gpuAcceleration = _ref2.gpuAcceleration,
      adaptive = _ref2.adaptive,
      roundOffsets = _ref2.roundOffsets,
      isFixed = _ref2.isFixed;
  var _offsets$x = offsets.x,
      x = _offsets$x === void 0 ? 0 : _offsets$x,
      _offsets$y = offsets.y,
      y = _offsets$y === void 0 ? 0 : _offsets$y;

  var _ref3 = typeof roundOffsets === 'function' ? roundOffsets({
    x: x,
    y: y
  }) : {
    x: x,
    y: y
  };

  x = _ref3.x;
  y = _ref3.y;
  var hasX = offsets.hasOwnProperty('x');
  var hasY = offsets.hasOwnProperty('y');
  var sideX = _enums_js__WEBPACK_IMPORTED_MODULE_0__.left;
  var sideY = _enums_js__WEBPACK_IMPORTED_MODULE_0__.top;
  var win = window;

  if (adaptive) {
    var offsetParent = (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_1__["default"])(popper);
    var heightProp = 'clientHeight';
    var widthProp = 'clientWidth';

    if (offsetParent === (0,_dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_2__["default"])(popper)) {
      offsetParent = (0,_dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(popper);

      if ((0,_dom_utils_getComputedStyle_js__WEBPACK_IMPORTED_MODULE_4__["default"])(offsetParent).position !== 'static' && position === 'absolute') {
        heightProp = 'scrollHeight';
        widthProp = 'scrollWidth';
      }
    } // $FlowFixMe[incompatible-cast]: force type refinement, we compare offsetParent with window above, but Flow doesn't detect it


    offsetParent = offsetParent;

    if (placement === _enums_js__WEBPACK_IMPORTED_MODULE_0__.top || (placement === _enums_js__WEBPACK_IMPORTED_MODULE_0__.left || placement === _enums_js__WEBPACK_IMPORTED_MODULE_0__.right) && variation === _enums_js__WEBPACK_IMPORTED_MODULE_0__.end) {
      sideY = _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom;
      var offsetY = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.height : // $FlowFixMe[prop-missing]
      offsetParent[heightProp];
      y -= offsetY - popperRect.height;
      y *= gpuAcceleration ? 1 : -1;
    }

    if (placement === _enums_js__WEBPACK_IMPORTED_MODULE_0__.left || (placement === _enums_js__WEBPACK_IMPORTED_MODULE_0__.top || placement === _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom) && variation === _enums_js__WEBPACK_IMPORTED_MODULE_0__.end) {
      sideX = _enums_js__WEBPACK_IMPORTED_MODULE_0__.right;
      var offsetX = isFixed && offsetParent === win && win.visualViewport ? win.visualViewport.width : // $FlowFixMe[prop-missing]
      offsetParent[widthProp];
      x -= offsetX - popperRect.width;
      x *= gpuAcceleration ? 1 : -1;
    }
  }

  var commonStyles = Object.assign({
    position: position
  }, adaptive && unsetSides);

  var _ref4 = roundOffsets === true ? roundOffsetsByDPR({
    x: x,
    y: y
  }, (0,_dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_2__["default"])(popper)) : {
    x: x,
    y: y
  };

  x = _ref4.x;
  y = _ref4.y;

  if (gpuAcceleration) {
    var _Object$assign;

    return Object.assign({}, commonStyles, (_Object$assign = {}, _Object$assign[sideY] = hasY ? '0' : '', _Object$assign[sideX] = hasX ? '0' : '', _Object$assign.transform = (win.devicePixelRatio || 1) <= 1 ? "translate(" + x + "px, " + y + "px)" : "translate3d(" + x + "px, " + y + "px, 0)", _Object$assign));
  }

  return Object.assign({}, commonStyles, (_Object$assign2 = {}, _Object$assign2[sideY] = hasY ? y + "px" : '', _Object$assign2[sideX] = hasX ? x + "px" : '', _Object$assign2.transform = '', _Object$assign2));
}

function computeStyles(_ref5) {
  var state = _ref5.state,
      options = _ref5.options;
  var _options$gpuAccelerat = options.gpuAcceleration,
      gpuAcceleration = _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat,
      _options$adaptive = options.adaptive,
      adaptive = _options$adaptive === void 0 ? true : _options$adaptive,
      _options$roundOffsets = options.roundOffsets,
      roundOffsets = _options$roundOffsets === void 0 ? true : _options$roundOffsets;
  var commonStyles = {
    placement: (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_5__["default"])(state.placement),
    variation: (0,_utils_getVariation_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state.placement),
    popper: state.elements.popper,
    popperRect: state.rects.popper,
    gpuAcceleration: gpuAcceleration,
    isFixed: state.options.strategy === 'fixed'
  };

  if (state.modifiersData.popperOffsets != null) {
    state.styles.popper = Object.assign({}, state.styles.popper, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.popperOffsets,
      position: state.options.strategy,
      adaptive: adaptive,
      roundOffsets: roundOffsets
    })));
  }

  if (state.modifiersData.arrow != null) {
    state.styles.arrow = Object.assign({}, state.styles.arrow, mapToStyles(Object.assign({}, commonStyles, {
      offsets: state.modifiersData.arrow,
      position: 'absolute',
      adaptive: false,
      roundOffsets: roundOffsets
    })));
  }

  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    'data-popper-placement': state.placement
  });
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'computeStyles',
  enabled: true,
  phase: 'beforeWrite',
  fn: computeStyles,
  data: {}
});

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/modifiers/eventListeners.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/modifiers/eventListeners.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../dom-utils/getWindow.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getWindow.js");
 // eslint-disable-next-line import/no-unused-modules

var passive = {
  passive: true
};

function effect(_ref) {
  var state = _ref.state,
      instance = _ref.instance,
      options = _ref.options;
  var _options$scroll = options.scroll,
      scroll = _options$scroll === void 0 ? true : _options$scroll,
      _options$resize = options.resize,
      resize = _options$resize === void 0 ? true : _options$resize;
  var window = (0,_dom_utils_getWindow_js__WEBPACK_IMPORTED_MODULE_0__["default"])(state.elements.popper);
  var scrollParents = [].concat(state.scrollParents.reference, state.scrollParents.popper);

  if (scroll) {
    scrollParents.forEach(function (scrollParent) {
      scrollParent.addEventListener('scroll', instance.update, passive);
    });
  }

  if (resize) {
    window.addEventListener('resize', instance.update, passive);
  }

  return function () {
    if (scroll) {
      scrollParents.forEach(function (scrollParent) {
        scrollParent.removeEventListener('scroll', instance.update, passive);
      });
    }

    if (resize) {
      window.removeEventListener('resize', instance.update, passive);
    }
  };
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'eventListeners',
  enabled: true,
  phase: 'write',
  fn: function fn() {},
  effect: effect,
  data: {}
});

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/modifiers/flip.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/modifiers/flip.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/getOppositePlacement.js */ "../../node_modules/@popperjs/core/lib/utils/getOppositePlacement.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "../../node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_getOppositeVariationPlacement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/getOppositeVariationPlacement.js */ "../../node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/detectOverflow.js */ "../../node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _utils_computeAutoPlacement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/computeAutoPlacement.js */ "../../node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../enums.js */ "../../node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _utils_getVariation_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/getVariation.js */ "../../node_modules/@popperjs/core/lib/utils/getVariation.js");






 // eslint-disable-next-line import/no-unused-modules

function getExpandedFallbackPlacements(placement) {
  if ((0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement) === _enums_js__WEBPACK_IMPORTED_MODULE_5__.auto) {
    return [];
  }

  var oppositePlacement = (0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement);
  return [(0,_utils_getOppositeVariationPlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(placement), oppositePlacement, (0,_utils_getOppositeVariationPlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(oppositePlacement)];
}

function flip(_ref) {
  var state = _ref.state,
      options = _ref.options,
      name = _ref.name;

  if (state.modifiersData[name]._skip) {
    return;
  }

  var _options$mainAxis = options.mainAxis,
      checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
      _options$altAxis = options.altAxis,
      checkAltAxis = _options$altAxis === void 0 ? true : _options$altAxis,
      specifiedFallbackPlacements = options.fallbackPlacements,
      padding = options.padding,
      boundary = options.boundary,
      rootBoundary = options.rootBoundary,
      altBoundary = options.altBoundary,
      _options$flipVariatio = options.flipVariations,
      flipVariations = _options$flipVariatio === void 0 ? true : _options$flipVariatio,
      allowedAutoPlacements = options.allowedAutoPlacements;
  var preferredPlacement = state.options.placement;
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(preferredPlacement);
  var isBasePlacement = basePlacement === preferredPlacement;
  var fallbackPlacements = specifiedFallbackPlacements || (isBasePlacement || !flipVariations ? [(0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(preferredPlacement)] : getExpandedFallbackPlacements(preferredPlacement));
  var placements = [preferredPlacement].concat(fallbackPlacements).reduce(function (acc, placement) {
    return acc.concat((0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement) === _enums_js__WEBPACK_IMPORTED_MODULE_5__.auto ? (0,_utils_computeAutoPlacement_js__WEBPACK_IMPORTED_MODULE_4__["default"])(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding,
      flipVariations: flipVariations,
      allowedAutoPlacements: allowedAutoPlacements
    }) : placement);
  }, []);
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var checksMap = new Map();
  var makeFallbackChecks = true;
  var firstFittingPlacement = placements[0];

  for (var i = 0; i < placements.length; i++) {
    var placement = placements[i];

    var _basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement);

    var isStartVariation = (0,_utils_getVariation_js__WEBPACK_IMPORTED_MODULE_6__["default"])(placement) === _enums_js__WEBPACK_IMPORTED_MODULE_5__.start;
    var isVertical = [_enums_js__WEBPACK_IMPORTED_MODULE_5__.top, _enums_js__WEBPACK_IMPORTED_MODULE_5__.bottom].indexOf(_basePlacement) >= 0;
    var len = isVertical ? 'width' : 'height';
    var overflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_3__["default"])(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      altBoundary: altBoundary,
      padding: padding
    });
    var mainVariationSide = isVertical ? isStartVariation ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.right : _enums_js__WEBPACK_IMPORTED_MODULE_5__.left : isStartVariation ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_5__.top;

    if (referenceRect[len] > popperRect[len]) {
      mainVariationSide = (0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(mainVariationSide);
    }

    var altVariationSide = (0,_utils_getOppositePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(mainVariationSide);
    var checks = [];

    if (checkMainAxis) {
      checks.push(overflow[_basePlacement] <= 0);
    }

    if (checkAltAxis) {
      checks.push(overflow[mainVariationSide] <= 0, overflow[altVariationSide] <= 0);
    }

    if (checks.every(function (check) {
      return check;
    })) {
      firstFittingPlacement = placement;
      makeFallbackChecks = false;
      break;
    }

    checksMap.set(placement, checks);
  }

  if (makeFallbackChecks) {
    // `2` may be desired in some cases – research later
    var numberOfChecks = flipVariations ? 3 : 1;

    var _loop = function _loop(_i) {
      var fittingPlacement = placements.find(function (placement) {
        var checks = checksMap.get(placement);

        if (checks) {
          return checks.slice(0, _i).every(function (check) {
            return check;
          });
        }
      });

      if (fittingPlacement) {
        firstFittingPlacement = fittingPlacement;
        return "break";
      }
    };

    for (var _i = numberOfChecks; _i > 0; _i--) {
      var _ret = _loop(_i);

      if (_ret === "break") break;
    }
  }

  if (state.placement !== firstFittingPlacement) {
    state.modifiersData[name]._skip = true;
    state.placement = firstFittingPlacement;
    state.reset = true;
  }
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'flip',
  enabled: true,
  phase: 'main',
  fn: flip,
  requiresIfExists: ['offset'],
  data: {
    _skip: false
  }
});

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/modifiers/hide.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/modifiers/hide.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "../../node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/detectOverflow.js */ "../../node_modules/@popperjs/core/lib/utils/detectOverflow.js");



function getSideOffsets(overflow, rect, preventedOffsets) {
  if (preventedOffsets === void 0) {
    preventedOffsets = {
      x: 0,
      y: 0
    };
  }

  return {
    top: overflow.top - rect.height - preventedOffsets.y,
    right: overflow.right - rect.width + preventedOffsets.x,
    bottom: overflow.bottom - rect.height + preventedOffsets.y,
    left: overflow.left - rect.width - preventedOffsets.x
  };
}

function isAnySideFullyClipped(overflow) {
  return [_enums_js__WEBPACK_IMPORTED_MODULE_0__.top, _enums_js__WEBPACK_IMPORTED_MODULE_0__.right, _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom, _enums_js__WEBPACK_IMPORTED_MODULE_0__.left].some(function (side) {
    return overflow[side] >= 0;
  });
}

function hide(_ref) {
  var state = _ref.state,
      name = _ref.name;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var preventedOffsets = state.modifiersData.preventOverflow;
  var referenceOverflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state, {
    elementContext: 'reference'
  });
  var popperAltOverflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state, {
    altBoundary: true
  });
  var referenceClippingOffsets = getSideOffsets(referenceOverflow, referenceRect);
  var popperEscapeOffsets = getSideOffsets(popperAltOverflow, popperRect, preventedOffsets);
  var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
  var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
  state.modifiersData[name] = {
    referenceClippingOffsets: referenceClippingOffsets,
    popperEscapeOffsets: popperEscapeOffsets,
    isReferenceHidden: isReferenceHidden,
    hasPopperEscaped: hasPopperEscaped
  };
  state.attributes.popper = Object.assign({}, state.attributes.popper, {
    'data-popper-reference-hidden': isReferenceHidden,
    'data-popper-escaped': hasPopperEscaped
  });
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'hide',
  enabled: true,
  phase: 'main',
  requiresIfExists: ['preventOverflow'],
  fn: hide
});

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/modifiers/index.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/modifiers/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applyStyles: () => (/* reexport safe */ _applyStyles_js__WEBPACK_IMPORTED_MODULE_0__["default"]),
/* harmony export */   arrow: () => (/* reexport safe */ _arrow_js__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   computeStyles: () => (/* reexport safe */ _computeStyles_js__WEBPACK_IMPORTED_MODULE_2__["default"]),
/* harmony export */   eventListeners: () => (/* reexport safe */ _eventListeners_js__WEBPACK_IMPORTED_MODULE_3__["default"]),
/* harmony export */   flip: () => (/* reexport safe */ _flip_js__WEBPACK_IMPORTED_MODULE_4__["default"]),
/* harmony export */   hide: () => (/* reexport safe */ _hide_js__WEBPACK_IMPORTED_MODULE_5__["default"]),
/* harmony export */   offset: () => (/* reexport safe */ _offset_js__WEBPACK_IMPORTED_MODULE_6__["default"]),
/* harmony export */   popperOffsets: () => (/* reexport safe */ _popperOffsets_js__WEBPACK_IMPORTED_MODULE_7__["default"]),
/* harmony export */   preventOverflow: () => (/* reexport safe */ _preventOverflow_js__WEBPACK_IMPORTED_MODULE_8__["default"])
/* harmony export */ });
/* harmony import */ var _applyStyles_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./applyStyles.js */ "../../node_modules/@popperjs/core/lib/modifiers/applyStyles.js");
/* harmony import */ var _arrow_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./arrow.js */ "../../node_modules/@popperjs/core/lib/modifiers/arrow.js");
/* harmony import */ var _computeStyles_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./computeStyles.js */ "../../node_modules/@popperjs/core/lib/modifiers/computeStyles.js");
/* harmony import */ var _eventListeners_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./eventListeners.js */ "../../node_modules/@popperjs/core/lib/modifiers/eventListeners.js");
/* harmony import */ var _flip_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./flip.js */ "../../node_modules/@popperjs/core/lib/modifiers/flip.js");
/* harmony import */ var _hide_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./hide.js */ "../../node_modules/@popperjs/core/lib/modifiers/hide.js");
/* harmony import */ var _offset_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./offset.js */ "../../node_modules/@popperjs/core/lib/modifiers/offset.js");
/* harmony import */ var _popperOffsets_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./popperOffsets.js */ "../../node_modules/@popperjs/core/lib/modifiers/popperOffsets.js");
/* harmony import */ var _preventOverflow_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./preventOverflow.js */ "../../node_modules/@popperjs/core/lib/modifiers/preventOverflow.js");










/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/modifiers/offset.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/modifiers/offset.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   distanceAndSkiddingToXY: () => (/* binding */ distanceAndSkiddingToXY)
/* harmony export */ });
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "../../node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "../../node_modules/@popperjs/core/lib/enums.js");

 // eslint-disable-next-line import/no-unused-modules

function distanceAndSkiddingToXY(placement, rects, offset) {
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement);
  var invertDistance = [_enums_js__WEBPACK_IMPORTED_MODULE_1__.left, _enums_js__WEBPACK_IMPORTED_MODULE_1__.top].indexOf(basePlacement) >= 0 ? -1 : 1;

  var _ref = typeof offset === 'function' ? offset(Object.assign({}, rects, {
    placement: placement
  })) : offset,
      skidding = _ref[0],
      distance = _ref[1];

  skidding = skidding || 0;
  distance = (distance || 0) * invertDistance;
  return [_enums_js__WEBPACK_IMPORTED_MODULE_1__.left, _enums_js__WEBPACK_IMPORTED_MODULE_1__.right].indexOf(basePlacement) >= 0 ? {
    x: distance,
    y: skidding
  } : {
    x: skidding,
    y: distance
  };
}

function offset(_ref2) {
  var state = _ref2.state,
      options = _ref2.options,
      name = _ref2.name;
  var _options$offset = options.offset,
      offset = _options$offset === void 0 ? [0, 0] : _options$offset;
  var data = _enums_js__WEBPACK_IMPORTED_MODULE_1__.placements.reduce(function (acc, placement) {
    acc[placement] = distanceAndSkiddingToXY(placement, state.rects, offset);
    return acc;
  }, {});
  var _data$state$placement = data[state.placement],
      x = _data$state$placement.x,
      y = _data$state$placement.y;

  if (state.modifiersData.popperOffsets != null) {
    state.modifiersData.popperOffsets.x += x;
    state.modifiersData.popperOffsets.y += y;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'offset',
  enabled: true,
  phase: 'main',
  requires: ['popperOffsets'],
  fn: offset
});

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/modifiers/popperOffsets.js":
/*!************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/modifiers/popperOffsets.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_computeOffsets_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/computeOffsets.js */ "../../node_modules/@popperjs/core/lib/utils/computeOffsets.js");


function popperOffsets(_ref) {
  var state = _ref.state,
      name = _ref.name;
  // Offsets are the actual position the popper needs to have to be
  // properly positioned near its reference element
  // This is the most basic placement, and will be adjusted by
  // the modifiers in the next step
  state.modifiersData[name] = (0,_utils_computeOffsets_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    reference: state.rects.reference,
    element: state.rects.popper,
    strategy: 'absolute',
    placement: state.placement
  });
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'popperOffsets',
  enabled: true,
  phase: 'read',
  fn: popperOffsets,
  data: {}
});

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/modifiers/preventOverflow.js":
/*!**************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/modifiers/preventOverflow.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "../../node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/getBasePlacement.js */ "../../node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/getMainAxisFromPlacement.js */ "../../node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js");
/* harmony import */ var _utils_getAltAxis_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/getAltAxis.js */ "../../node_modules/@popperjs/core/lib/utils/getAltAxis.js");
/* harmony import */ var _utils_within_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/within.js */ "../../node_modules/@popperjs/core/lib/utils/within.js");
/* harmony import */ var _dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dom-utils/getLayoutRect.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getLayoutRect.js");
/* harmony import */ var _dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dom-utils/getOffsetParent.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getOffsetParent.js");
/* harmony import */ var _utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/detectOverflow.js */ "../../node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _utils_getVariation_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/getVariation.js */ "../../node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _utils_getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/getFreshSideObject.js */ "../../node_modules/@popperjs/core/lib/utils/getFreshSideObject.js");
/* harmony import */ var _utils_math_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/math.js */ "../../node_modules/@popperjs/core/lib/utils/math.js");












function preventOverflow(_ref) {
  var state = _ref.state,
      options = _ref.options,
      name = _ref.name;
  var _options$mainAxis = options.mainAxis,
      checkMainAxis = _options$mainAxis === void 0 ? true : _options$mainAxis,
      _options$altAxis = options.altAxis,
      checkAltAxis = _options$altAxis === void 0 ? false : _options$altAxis,
      boundary = options.boundary,
      rootBoundary = options.rootBoundary,
      altBoundary = options.altBoundary,
      padding = options.padding,
      _options$tether = options.tether,
      tether = _options$tether === void 0 ? true : _options$tether,
      _options$tetherOffset = options.tetherOffset,
      tetherOffset = _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
  var overflow = (0,_utils_detectOverflow_js__WEBPACK_IMPORTED_MODULE_7__["default"])(state, {
    boundary: boundary,
    rootBoundary: rootBoundary,
    padding: padding,
    altBoundary: altBoundary
  });
  var basePlacement = (0,_utils_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state.placement);
  var variation = (0,_utils_getVariation_js__WEBPACK_IMPORTED_MODULE_8__["default"])(state.placement);
  var isBasePlacement = !variation;
  var mainAxis = (0,_utils_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(basePlacement);
  var altAxis = (0,_utils_getAltAxis_js__WEBPACK_IMPORTED_MODULE_3__["default"])(mainAxis);
  var popperOffsets = state.modifiersData.popperOffsets;
  var referenceRect = state.rects.reference;
  var popperRect = state.rects.popper;
  var tetherOffsetValue = typeof tetherOffset === 'function' ? tetherOffset(Object.assign({}, state.rects, {
    placement: state.placement
  })) : tetherOffset;
  var normalizedTetherOffsetValue = typeof tetherOffsetValue === 'number' ? {
    mainAxis: tetherOffsetValue,
    altAxis: tetherOffsetValue
  } : Object.assign({
    mainAxis: 0,
    altAxis: 0
  }, tetherOffsetValue);
  var offsetModifierState = state.modifiersData.offset ? state.modifiersData.offset[state.placement] : null;
  var data = {
    x: 0,
    y: 0
  };

  if (!popperOffsets) {
    return;
  }

  if (checkMainAxis) {
    var _offsetModifierState$;

    var mainSide = mainAxis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.top : _enums_js__WEBPACK_IMPORTED_MODULE_0__.left;
    var altSide = mainAxis === 'y' ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_0__.right;
    var len = mainAxis === 'y' ? 'height' : 'width';
    var offset = popperOffsets[mainAxis];
    var min = offset + overflow[mainSide];
    var max = offset - overflow[altSide];
    var additive = tether ? -popperRect[len] / 2 : 0;
    var minLen = variation === _enums_js__WEBPACK_IMPORTED_MODULE_0__.start ? referenceRect[len] : popperRect[len];
    var maxLen = variation === _enums_js__WEBPACK_IMPORTED_MODULE_0__.start ? -popperRect[len] : -referenceRect[len]; // We need to include the arrow in the calculation so the arrow doesn't go
    // outside the reference bounds

    var arrowElement = state.elements.arrow;
    var arrowRect = tether && arrowElement ? (0,_dom_utils_getLayoutRect_js__WEBPACK_IMPORTED_MODULE_5__["default"])(arrowElement) : {
      width: 0,
      height: 0
    };
    var arrowPaddingObject = state.modifiersData['arrow#persistent'] ? state.modifiersData['arrow#persistent'].padding : (0,_utils_getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_9__["default"])();
    var arrowPaddingMin = arrowPaddingObject[mainSide];
    var arrowPaddingMax = arrowPaddingObject[altSide]; // If the reference length is smaller than the arrow length, we don't want
    // to include its full size in the calculation. If the reference is small
    // and near the edge of a boundary, the popper can overflow even if the
    // reference is not overflowing as well (e.g. virtual elements with no
    // width or height)

    var arrowLen = (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_4__.within)(0, referenceRect[len], arrowRect[len]);
    var minOffset = isBasePlacement ? referenceRect[len] / 2 - additive - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis : minLen - arrowLen - arrowPaddingMin - normalizedTetherOffsetValue.mainAxis;
    var maxOffset = isBasePlacement ? -referenceRect[len] / 2 + additive + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis : maxLen + arrowLen + arrowPaddingMax + normalizedTetherOffsetValue.mainAxis;
    var arrowOffsetParent = state.elements.arrow && (0,_dom_utils_getOffsetParent_js__WEBPACK_IMPORTED_MODULE_6__["default"])(state.elements.arrow);
    var clientOffset = arrowOffsetParent ? mainAxis === 'y' ? arrowOffsetParent.clientTop || 0 : arrowOffsetParent.clientLeft || 0 : 0;
    var offsetModifierValue = (_offsetModifierState$ = offsetModifierState == null ? void 0 : offsetModifierState[mainAxis]) != null ? _offsetModifierState$ : 0;
    var tetherMin = offset + minOffset - offsetModifierValue - clientOffset;
    var tetherMax = offset + maxOffset - offsetModifierValue;
    var preventedOffset = (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_4__.within)(tether ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_10__.min)(min, tetherMin) : min, offset, tether ? (0,_utils_math_js__WEBPACK_IMPORTED_MODULE_10__.max)(max, tetherMax) : max);
    popperOffsets[mainAxis] = preventedOffset;
    data[mainAxis] = preventedOffset - offset;
  }

  if (checkAltAxis) {
    var _offsetModifierState$2;

    var _mainSide = mainAxis === 'x' ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.top : _enums_js__WEBPACK_IMPORTED_MODULE_0__.left;

    var _altSide = mainAxis === 'x' ? _enums_js__WEBPACK_IMPORTED_MODULE_0__.bottom : _enums_js__WEBPACK_IMPORTED_MODULE_0__.right;

    var _offset = popperOffsets[altAxis];

    var _len = altAxis === 'y' ? 'height' : 'width';

    var _min = _offset + overflow[_mainSide];

    var _max = _offset - overflow[_altSide];

    var isOriginSide = [_enums_js__WEBPACK_IMPORTED_MODULE_0__.top, _enums_js__WEBPACK_IMPORTED_MODULE_0__.left].indexOf(basePlacement) !== -1;

    var _offsetModifierValue = (_offsetModifierState$2 = offsetModifierState == null ? void 0 : offsetModifierState[altAxis]) != null ? _offsetModifierState$2 : 0;

    var _tetherMin = isOriginSide ? _min : _offset - referenceRect[_len] - popperRect[_len] - _offsetModifierValue + normalizedTetherOffsetValue.altAxis;

    var _tetherMax = isOriginSide ? _offset + referenceRect[_len] + popperRect[_len] - _offsetModifierValue - normalizedTetherOffsetValue.altAxis : _max;

    var _preventedOffset = tether && isOriginSide ? (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_4__.withinMaxClamp)(_tetherMin, _offset, _tetherMax) : (0,_utils_within_js__WEBPACK_IMPORTED_MODULE_4__.within)(tether ? _tetherMin : _min, _offset, tether ? _tetherMax : _max);

    popperOffsets[altAxis] = _preventedOffset;
    data[altAxis] = _preventedOffset - _offset;
  }

  state.modifiersData[name] = data;
} // eslint-disable-next-line import/no-unused-modules


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  name: 'preventOverflow',
  enabled: true,
  phase: 'main',
  fn: preventOverflow,
  requiresIfExists: ['offset']
});

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/popper-lite.js":
/*!************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/popper-lite.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createPopper: () => (/* binding */ createPopper),
/* harmony export */   defaultModifiers: () => (/* binding */ defaultModifiers),
/* harmony export */   detectOverflow: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   popperGenerator: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_0__.popperGenerator)
/* harmony export */ });
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createPopper.js */ "../../node_modules/@popperjs/core/lib/createPopper.js");
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createPopper.js */ "../../node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modifiers/eventListeners.js */ "../../node_modules/@popperjs/core/lib/modifiers/eventListeners.js");
/* harmony import */ var _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modifiers/popperOffsets.js */ "../../node_modules/@popperjs/core/lib/modifiers/popperOffsets.js");
/* harmony import */ var _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modifiers/computeStyles.js */ "../../node_modules/@popperjs/core/lib/modifiers/computeStyles.js");
/* harmony import */ var _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./modifiers/applyStyles.js */ "../../node_modules/@popperjs/core/lib/modifiers/applyStyles.js");





var defaultModifiers = [_modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_2__["default"], _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_3__["default"], _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_4__["default"], _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_5__["default"]];
var createPopper = /*#__PURE__*/(0,_createPopper_js__WEBPACK_IMPORTED_MODULE_0__.popperGenerator)({
  defaultModifiers: defaultModifiers
}); // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/popper.js":
/*!*******************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/popper.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applyStyles: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.applyStyles),
/* harmony export */   arrow: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.arrow),
/* harmony export */   computeStyles: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.computeStyles),
/* harmony export */   createPopper: () => (/* binding */ createPopper),
/* harmony export */   createPopperLite: () => (/* reexport safe */ _popper_lite_js__WEBPACK_IMPORTED_MODULE_11__.createPopper),
/* harmony export */   defaultModifiers: () => (/* binding */ defaultModifiers),
/* harmony export */   detectOverflow: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_1__["default"]),
/* harmony export */   eventListeners: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.eventListeners),
/* harmony export */   flip: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.flip),
/* harmony export */   hide: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.hide),
/* harmony export */   offset: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.offset),
/* harmony export */   popperGenerator: () => (/* reexport safe */ _createPopper_js__WEBPACK_IMPORTED_MODULE_0__.popperGenerator),
/* harmony export */   popperOffsets: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.popperOffsets),
/* harmony export */   preventOverflow: () => (/* reexport safe */ _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__.preventOverflow)
/* harmony export */ });
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./createPopper.js */ "../../node_modules/@popperjs/core/lib/createPopper.js");
/* harmony import */ var _createPopper_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./createPopper.js */ "../../node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./modifiers/eventListeners.js */ "../../node_modules/@popperjs/core/lib/modifiers/eventListeners.js");
/* harmony import */ var _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./modifiers/popperOffsets.js */ "../../node_modules/@popperjs/core/lib/modifiers/popperOffsets.js");
/* harmony import */ var _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./modifiers/computeStyles.js */ "../../node_modules/@popperjs/core/lib/modifiers/computeStyles.js");
/* harmony import */ var _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./modifiers/applyStyles.js */ "../../node_modules/@popperjs/core/lib/modifiers/applyStyles.js");
/* harmony import */ var _modifiers_offset_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./modifiers/offset.js */ "../../node_modules/@popperjs/core/lib/modifiers/offset.js");
/* harmony import */ var _modifiers_flip_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./modifiers/flip.js */ "../../node_modules/@popperjs/core/lib/modifiers/flip.js");
/* harmony import */ var _modifiers_preventOverflow_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./modifiers/preventOverflow.js */ "../../node_modules/@popperjs/core/lib/modifiers/preventOverflow.js");
/* harmony import */ var _modifiers_arrow_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./modifiers/arrow.js */ "../../node_modules/@popperjs/core/lib/modifiers/arrow.js");
/* harmony import */ var _modifiers_hide_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./modifiers/hide.js */ "../../node_modules/@popperjs/core/lib/modifiers/hide.js");
/* harmony import */ var _popper_lite_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./popper-lite.js */ "../../node_modules/@popperjs/core/lib/popper-lite.js");
/* harmony import */ var _modifiers_index_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./modifiers/index.js */ "../../node_modules/@popperjs/core/lib/modifiers/index.js");










var defaultModifiers = [_modifiers_eventListeners_js__WEBPACK_IMPORTED_MODULE_2__["default"], _modifiers_popperOffsets_js__WEBPACK_IMPORTED_MODULE_3__["default"], _modifiers_computeStyles_js__WEBPACK_IMPORTED_MODULE_4__["default"], _modifiers_applyStyles_js__WEBPACK_IMPORTED_MODULE_5__["default"], _modifiers_offset_js__WEBPACK_IMPORTED_MODULE_6__["default"], _modifiers_flip_js__WEBPACK_IMPORTED_MODULE_7__["default"], _modifiers_preventOverflow_js__WEBPACK_IMPORTED_MODULE_8__["default"], _modifiers_arrow_js__WEBPACK_IMPORTED_MODULE_9__["default"], _modifiers_hide_js__WEBPACK_IMPORTED_MODULE_10__["default"]];
var createPopper = /*#__PURE__*/(0,_createPopper_js__WEBPACK_IMPORTED_MODULE_0__.popperGenerator)({
  defaultModifiers: defaultModifiers
}); // eslint-disable-next-line import/no-unused-modules

 // eslint-disable-next-line import/no-unused-modules

 // eslint-disable-next-line import/no-unused-modules



/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/computeAutoPlacement.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ computeAutoPlacement)
/* harmony export */ });
/* harmony import */ var _getVariation_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getVariation.js */ "../../node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../enums.js */ "../../node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _detectOverflow_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./detectOverflow.js */ "../../node_modules/@popperjs/core/lib/utils/detectOverflow.js");
/* harmony import */ var _getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./getBasePlacement.js */ "../../node_modules/@popperjs/core/lib/utils/getBasePlacement.js");




function computeAutoPlacement(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
      placement = _options.placement,
      boundary = _options.boundary,
      rootBoundary = _options.rootBoundary,
      padding = _options.padding,
      flipVariations = _options.flipVariations,
      _options$allowedAutoP = _options.allowedAutoPlacements,
      allowedAutoPlacements = _options$allowedAutoP === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_1__.placements : _options$allowedAutoP;
  var variation = (0,_getVariation_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement);
  var placements = variation ? flipVariations ? _enums_js__WEBPACK_IMPORTED_MODULE_1__.variationPlacements : _enums_js__WEBPACK_IMPORTED_MODULE_1__.variationPlacements.filter(function (placement) {
    return (0,_getVariation_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement) === variation;
  }) : _enums_js__WEBPACK_IMPORTED_MODULE_1__.basePlacements;
  var allowedPlacements = placements.filter(function (placement) {
    return allowedAutoPlacements.indexOf(placement) >= 0;
  });

  if (allowedPlacements.length === 0) {
    allowedPlacements = placements;
  } // $FlowFixMe[incompatible-type]: Flow seems to have problems with two array unions...


  var overflows = allowedPlacements.reduce(function (acc, placement) {
    acc[placement] = (0,_detectOverflow_js__WEBPACK_IMPORTED_MODULE_2__["default"])(state, {
      placement: placement,
      boundary: boundary,
      rootBoundary: rootBoundary,
      padding: padding
    })[(0,_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_3__["default"])(placement)];
    return acc;
  }, {});
  return Object.keys(overflows).sort(function (a, b) {
    return overflows[a] - overflows[b];
  });
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/computeOffsets.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/computeOffsets.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ computeOffsets)
/* harmony export */ });
/* harmony import */ var _getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getBasePlacement.js */ "../../node_modules/@popperjs/core/lib/utils/getBasePlacement.js");
/* harmony import */ var _getVariation_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./getVariation.js */ "../../node_modules/@popperjs/core/lib/utils/getVariation.js");
/* harmony import */ var _getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./getMainAxisFromPlacement.js */ "../../node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../enums.js */ "../../node_modules/@popperjs/core/lib/enums.js");




function computeOffsets(_ref) {
  var reference = _ref.reference,
      element = _ref.element,
      placement = _ref.placement;
  var basePlacement = placement ? (0,_getBasePlacement_js__WEBPACK_IMPORTED_MODULE_0__["default"])(placement) : null;
  var variation = placement ? (0,_getVariation_js__WEBPACK_IMPORTED_MODULE_1__["default"])(placement) : null;
  var commonX = reference.x + reference.width / 2 - element.width / 2;
  var commonY = reference.y + reference.height / 2 - element.height / 2;
  var offsets;

  switch (basePlacement) {
    case _enums_js__WEBPACK_IMPORTED_MODULE_3__.top:
      offsets = {
        x: commonX,
        y: reference.y - element.height
      };
      break;

    case _enums_js__WEBPACK_IMPORTED_MODULE_3__.bottom:
      offsets = {
        x: commonX,
        y: reference.y + reference.height
      };
      break;

    case _enums_js__WEBPACK_IMPORTED_MODULE_3__.right:
      offsets = {
        x: reference.x + reference.width,
        y: commonY
      };
      break;

    case _enums_js__WEBPACK_IMPORTED_MODULE_3__.left:
      offsets = {
        x: reference.x - element.width,
        y: commonY
      };
      break;

    default:
      offsets = {
        x: reference.x,
        y: reference.y
      };
  }

  var mainAxis = basePlacement ? (0,_getMainAxisFromPlacement_js__WEBPACK_IMPORTED_MODULE_2__["default"])(basePlacement) : null;

  if (mainAxis != null) {
    var len = mainAxis === 'y' ? 'height' : 'width';

    switch (variation) {
      case _enums_js__WEBPACK_IMPORTED_MODULE_3__.start:
        offsets[mainAxis] = offsets[mainAxis] - (reference[len] / 2 - element[len] / 2);
        break;

      case _enums_js__WEBPACK_IMPORTED_MODULE_3__.end:
        offsets[mainAxis] = offsets[mainAxis] + (reference[len] / 2 - element[len] / 2);
        break;

      default:
    }
  }

  return offsets;
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/debounce.js":
/*!***************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/debounce.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ debounce)
/* harmony export */ });
function debounce(fn) {
  var pending;
  return function () {
    if (!pending) {
      pending = new Promise(function (resolve) {
        Promise.resolve().then(function () {
          pending = undefined;
          resolve(fn());
        });
      });
    }

    return pending;
  };
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/detectOverflow.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/detectOverflow.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ detectOverflow)
/* harmony export */ });
/* harmony import */ var _dom_utils_getClippingRect_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../dom-utils/getClippingRect.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getClippingRect.js");
/* harmony import */ var _dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dom-utils/getDocumentElement.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getDocumentElement.js");
/* harmony import */ var _dom_utils_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dom-utils/getBoundingClientRect.js */ "../../node_modules/@popperjs/core/lib/dom-utils/getBoundingClientRect.js");
/* harmony import */ var _computeOffsets_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./computeOffsets.js */ "../../node_modules/@popperjs/core/lib/utils/computeOffsets.js");
/* harmony import */ var _rectToClientRect_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./rectToClientRect.js */ "../../node_modules/@popperjs/core/lib/utils/rectToClientRect.js");
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../enums.js */ "../../node_modules/@popperjs/core/lib/enums.js");
/* harmony import */ var _dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dom-utils/instanceOf.js */ "../../node_modules/@popperjs/core/lib/dom-utils/instanceOf.js");
/* harmony import */ var _mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./mergePaddingObject.js */ "../../node_modules/@popperjs/core/lib/utils/mergePaddingObject.js");
/* harmony import */ var _expandToHashMap_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./expandToHashMap.js */ "../../node_modules/@popperjs/core/lib/utils/expandToHashMap.js");








 // eslint-disable-next-line import/no-unused-modules

function detectOverflow(state, options) {
  if (options === void 0) {
    options = {};
  }

  var _options = options,
      _options$placement = _options.placement,
      placement = _options$placement === void 0 ? state.placement : _options$placement,
      _options$strategy = _options.strategy,
      strategy = _options$strategy === void 0 ? state.strategy : _options$strategy,
      _options$boundary = _options.boundary,
      boundary = _options$boundary === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.clippingParents : _options$boundary,
      _options$rootBoundary = _options.rootBoundary,
      rootBoundary = _options$rootBoundary === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.viewport : _options$rootBoundary,
      _options$elementConte = _options.elementContext,
      elementContext = _options$elementConte === void 0 ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.popper : _options$elementConte,
      _options$altBoundary = _options.altBoundary,
      altBoundary = _options$altBoundary === void 0 ? false : _options$altBoundary,
      _options$padding = _options.padding,
      padding = _options$padding === void 0 ? 0 : _options$padding;
  var paddingObject = (0,_mergePaddingObject_js__WEBPACK_IMPORTED_MODULE_7__["default"])(typeof padding !== 'number' ? padding : (0,_expandToHashMap_js__WEBPACK_IMPORTED_MODULE_8__["default"])(padding, _enums_js__WEBPACK_IMPORTED_MODULE_5__.basePlacements));
  var altContext = elementContext === _enums_js__WEBPACK_IMPORTED_MODULE_5__.popper ? _enums_js__WEBPACK_IMPORTED_MODULE_5__.reference : _enums_js__WEBPACK_IMPORTED_MODULE_5__.popper;
  var popperRect = state.rects.popper;
  var element = state.elements[altBoundary ? altContext : elementContext];
  var clippingClientRect = (0,_dom_utils_getClippingRect_js__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_dom_utils_instanceOf_js__WEBPACK_IMPORTED_MODULE_6__.isElement)(element) ? element : element.contextElement || (0,_dom_utils_getDocumentElement_js__WEBPACK_IMPORTED_MODULE_1__["default"])(state.elements.popper), boundary, rootBoundary, strategy);
  var referenceClientRect = (0,_dom_utils_getBoundingClientRect_js__WEBPACK_IMPORTED_MODULE_2__["default"])(state.elements.reference);
  var popperOffsets = (0,_computeOffsets_js__WEBPACK_IMPORTED_MODULE_3__["default"])({
    reference: referenceClientRect,
    element: popperRect,
    strategy: 'absolute',
    placement: placement
  });
  var popperClientRect = (0,_rectToClientRect_js__WEBPACK_IMPORTED_MODULE_4__["default"])(Object.assign({}, popperRect, popperOffsets));
  var elementClientRect = elementContext === _enums_js__WEBPACK_IMPORTED_MODULE_5__.popper ? popperClientRect : referenceClientRect; // positive = overflowing the clipping rect
  // 0 or negative = within the clipping rect

  var overflowOffsets = {
    top: clippingClientRect.top - elementClientRect.top + paddingObject.top,
    bottom: elementClientRect.bottom - clippingClientRect.bottom + paddingObject.bottom,
    left: clippingClientRect.left - elementClientRect.left + paddingObject.left,
    right: elementClientRect.right - clippingClientRect.right + paddingObject.right
  };
  var offsetData = state.modifiersData.offset; // Offsets can be applied only to the popper element

  if (elementContext === _enums_js__WEBPACK_IMPORTED_MODULE_5__.popper && offsetData) {
    var offset = offsetData[placement];
    Object.keys(overflowOffsets).forEach(function (key) {
      var multiply = [_enums_js__WEBPACK_IMPORTED_MODULE_5__.right, _enums_js__WEBPACK_IMPORTED_MODULE_5__.bottom].indexOf(key) >= 0 ? 1 : -1;
      var axis = [_enums_js__WEBPACK_IMPORTED_MODULE_5__.top, _enums_js__WEBPACK_IMPORTED_MODULE_5__.bottom].indexOf(key) >= 0 ? 'y' : 'x';
      overflowOffsets[key] += offset[axis] * multiply;
    });
  }

  return overflowOffsets;
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/expandToHashMap.js":
/*!**********************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/expandToHashMap.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ expandToHashMap)
/* harmony export */ });
function expandToHashMap(value, keys) {
  return keys.reduce(function (hashMap, key) {
    hashMap[key] = value;
    return hashMap;
  }, {});
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/getAltAxis.js":
/*!*****************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/getAltAxis.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getAltAxis)
/* harmony export */ });
function getAltAxis(axis) {
  return axis === 'x' ? 'y' : 'x';
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/getBasePlacement.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/getBasePlacement.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getBasePlacement)
/* harmony export */ });

function getBasePlacement(placement) {
  return placement.split('-')[0];
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/getFreshSideObject.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/getFreshSideObject.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getFreshSideObject)
/* harmony export */ });
function getFreshSideObject() {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  };
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js":
/*!*******************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/getMainAxisFromPlacement.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getMainAxisFromPlacement)
/* harmony export */ });
function getMainAxisFromPlacement(placement) {
  return ['top', 'bottom'].indexOf(placement) >= 0 ? 'x' : 'y';
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/getOppositePlacement.js":
/*!***************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/getOppositePlacement.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOppositePlacement)
/* harmony export */ });
var hash = {
  left: 'right',
  right: 'left',
  bottom: 'top',
  top: 'bottom'
};
function getOppositePlacement(placement) {
  return placement.replace(/left|right|bottom|top/g, function (matched) {
    return hash[matched];
  });
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js":
/*!************************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/getOppositeVariationPlacement.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getOppositeVariationPlacement)
/* harmony export */ });
var hash = {
  start: 'end',
  end: 'start'
};
function getOppositeVariationPlacement(placement) {
  return placement.replace(/start|end/g, function (matched) {
    return hash[matched];
  });
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/getVariation.js":
/*!*******************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/getVariation.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getVariation)
/* harmony export */ });
function getVariation(placement) {
  return placement.split('-')[1];
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/math.js":
/*!***********************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/math.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   max: () => (/* binding */ max),
/* harmony export */   min: () => (/* binding */ min),
/* harmony export */   round: () => (/* binding */ round)
/* harmony export */ });
var max = Math.max;
var min = Math.min;
var round = Math.round;

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/mergeByName.js":
/*!******************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/mergeByName.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergeByName)
/* harmony export */ });
function mergeByName(modifiers) {
  var merged = modifiers.reduce(function (merged, current) {
    var existing = merged[current.name];
    merged[current.name] = existing ? Object.assign({}, existing, current, {
      options: Object.assign({}, existing.options, current.options),
      data: Object.assign({}, existing.data, current.data)
    }) : current;
    return merged;
  }, {}); // IE11 does not support Object.values

  return Object.keys(merged).map(function (key) {
    return merged[key];
  });
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/mergePaddingObject.js":
/*!*************************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/mergePaddingObject.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ mergePaddingObject)
/* harmony export */ });
/* harmony import */ var _getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./getFreshSideObject.js */ "../../node_modules/@popperjs/core/lib/utils/getFreshSideObject.js");

function mergePaddingObject(paddingObject) {
  return Object.assign({}, (0,_getFreshSideObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(), paddingObject);
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/orderModifiers.js":
/*!*********************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/orderModifiers.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ orderModifiers)
/* harmony export */ });
/* harmony import */ var _enums_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../enums.js */ "../../node_modules/@popperjs/core/lib/enums.js");
 // source: https://stackoverflow.com/questions/49875255

function order(modifiers) {
  var map = new Map();
  var visited = new Set();
  var result = [];
  modifiers.forEach(function (modifier) {
    map.set(modifier.name, modifier);
  }); // On visiting object, check for its dependencies and visit them recursively

  function sort(modifier) {
    visited.add(modifier.name);
    var requires = [].concat(modifier.requires || [], modifier.requiresIfExists || []);
    requires.forEach(function (dep) {
      if (!visited.has(dep)) {
        var depModifier = map.get(dep);

        if (depModifier) {
          sort(depModifier);
        }
      }
    });
    result.push(modifier);
  }

  modifiers.forEach(function (modifier) {
    if (!visited.has(modifier.name)) {
      // check for visited object
      sort(modifier);
    }
  });
  return result;
}

function orderModifiers(modifiers) {
  // order based on dependencies
  var orderedModifiers = order(modifiers); // order based on phase

  return _enums_js__WEBPACK_IMPORTED_MODULE_0__.modifierPhases.reduce(function (acc, phase) {
    return acc.concat(orderedModifiers.filter(function (modifier) {
      return modifier.phase === phase;
    }));
  }, []);
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/rectToClientRect.js":
/*!***********************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/rectToClientRect.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ rectToClientRect)
/* harmony export */ });
function rectToClientRect(rect) {
  return Object.assign({}, rect, {
    left: rect.x,
    top: rect.y,
    right: rect.x + rect.width,
    bottom: rect.y + rect.height
  });
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/userAgent.js":
/*!****************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/userAgent.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ getUAString)
/* harmony export */ });
function getUAString() {
  var uaData = navigator.userAgentData;

  if (uaData != null && uaData.brands && Array.isArray(uaData.brands)) {
    return uaData.brands.map(function (item) {
      return item.brand + "/" + item.version;
    }).join(' ');
  }

  return navigator.userAgent;
}

/***/ }),

/***/ "../../node_modules/@popperjs/core/lib/utils/within.js":
/*!*************************************************************!*\
  !*** ../../node_modules/@popperjs/core/lib/utils/within.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   within: () => (/* binding */ within),
/* harmony export */   withinMaxClamp: () => (/* binding */ withinMaxClamp)
/* harmony export */ });
/* harmony import */ var _math_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math.js */ "../../node_modules/@popperjs/core/lib/utils/math.js");

function within(min, value, max) {
  return (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.max)(min, (0,_math_js__WEBPACK_IMPORTED_MODULE_0__.min)(value, max));
}
function withinMaxClamp(min, value, max) {
  var v = within(min, value, max);
  return v > max ? max : v;
}

/***/ }),

/***/ "../../node_modules/ag-grid-community/dist/package/main.esm.mjs":
/*!**********************************************************************!*\
  !*** ../../node_modules/ag-grid-community/dist/package/main.esm.mjs ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ALWAYS_SYNC_GLOBAL_EVENTS: () => (/* binding */ ALWAYS_SYNC_GLOBAL_EVENTS),
/* harmony export */   AbstractClientSideNodeManager: () => (/* binding */ AbstractClientSideNodeManager),
/* harmony export */   AgAbstractCellEditor: () => (/* binding */ AgAbstractCellEditor),
/* harmony export */   AgAbstractInputField: () => (/* binding */ AgAbstractInputField),
/* harmony export */   AgAbstractLabel: () => (/* binding */ AgAbstractLabel),
/* harmony export */   AgCheckbox: () => (/* binding */ AgCheckbox),
/* harmony export */   AgCheckboxSelector: () => (/* binding */ AgCheckboxSelector),
/* harmony export */   AgColumn: () => (/* binding */ AgColumn),
/* harmony export */   AgColumnGroup: () => (/* binding */ AgColumnGroup),
/* harmony export */   AgFilterButtonSelector: () => (/* binding */ AgFilterButtonSelector),
/* harmony export */   AgInputDateField: () => (/* binding */ AgInputDateField),
/* harmony export */   AgInputNumberField: () => (/* binding */ AgInputNumberField),
/* harmony export */   AgInputNumberFieldSelector: () => (/* binding */ AgInputNumberFieldSelector),
/* harmony export */   AgInputTextArea: () => (/* binding */ AgInputTextArea),
/* harmony export */   AgInputTextField: () => (/* binding */ AgInputTextField),
/* harmony export */   AgInputTextFieldSelector: () => (/* binding */ AgInputTextFieldSelector),
/* harmony export */   AgPickerField: () => (/* binding */ AgPickerField),
/* harmony export */   AgPromise: () => (/* binding */ AgPromise),
/* harmony export */   AgProvidedColumnGroup: () => (/* binding */ AgProvidedColumnGroup),
/* harmony export */   AgRadioButton: () => (/* binding */ AgRadioButton),
/* harmony export */   AgSelect: () => (/* binding */ AgSelect),
/* harmony export */   AgSelectSelector: () => (/* binding */ AgSelectSelector),
/* harmony export */   AgToggleButton: () => (/* binding */ AgToggleButton),
/* harmony export */   AgToggleButtonSelector: () => (/* binding */ AgToggleButtonSelector),
/* harmony export */   AlignedGridsModule: () => (/* binding */ AlignedGridsModule),
/* harmony export */   AllCommunityModule: () => (/* binding */ AllCommunityModule),
/* harmony export */   AutoScrollService: () => (/* binding */ AutoScrollService),
/* harmony export */   BaseColsService: () => (/* binding */ BaseColsService),
/* harmony export */   BaseComponentWrapper: () => (/* binding */ BaseComponentWrapper),
/* harmony export */   BaseCreator: () => (/* binding */ BaseCreator),
/* harmony export */   BaseGridSerializingSession: () => (/* binding */ BaseGridSerializingSession),
/* harmony export */   BaseSelectionService: () => (/* binding */ BaseSelectionService),
/* harmony export */   BeanStub: () => (/* binding */ BeanStub),
/* harmony export */   CellApiModule: () => (/* binding */ CellApiModule),
/* harmony export */   CellRangeType: () => (/* binding */ CellRangeType),
/* harmony export */   CellSpanModule: () => (/* binding */ CellSpanModule),
/* harmony export */   CellStyleModule: () => (/* binding */ CellStyleModule),
/* harmony export */   ChangedPath: () => (/* binding */ ChangedPath),
/* harmony export */   CheckboxEditorModule: () => (/* binding */ CheckboxEditorModule),
/* harmony export */   ClientSideRowModelApiModule: () => (/* binding */ ClientSideRowModelApiModule),
/* harmony export */   ClientSideRowModelModule: () => (/* binding */ ClientSideRowModelModule),
/* harmony export */   ColumnApiModule: () => (/* binding */ ColumnApiModule),
/* harmony export */   ColumnAutoSizeModule: () => (/* binding */ ColumnAutoSizeModule),
/* harmony export */   ColumnHoverModule: () => (/* binding */ ColumnHoverModule),
/* harmony export */   ColumnKeyCreator: () => (/* binding */ ColumnKeyCreator),
/* harmony export */   Component: () => (/* binding */ Component),
/* harmony export */   CssClassManager: () => (/* binding */ CssClassManager),
/* harmony export */   CsvExportModule: () => (/* binding */ CsvExportModule),
/* harmony export */   CustomEditorModule: () => (/* binding */ CustomEditorModule),
/* harmony export */   CustomFilterModule: () => (/* binding */ CustomFilterModule),
/* harmony export */   DateEditorModule: () => (/* binding */ DateEditorModule),
/* harmony export */   DateFilterModule: () => (/* binding */ DateFilterModule),
/* harmony export */   Direction: () => (/* binding */ Direction),
/* harmony export */   DragAndDropModule: () => (/* binding */ DragAndDropModule),
/* harmony export */   DragSourceType: () => (/* binding */ DragSourceType),
/* harmony export */   EventApiModule: () => (/* binding */ EventApiModule),
/* harmony export */   ExternalFilterModule: () => (/* binding */ ExternalFilterModule),
/* harmony export */   FakeHScrollComp: () => (/* binding */ FakeHScrollComp),
/* harmony export */   FakeVScrollComp: () => (/* binding */ FakeVScrollComp),
/* harmony export */   FilterButtonComp: () => (/* binding */ FilterButtonComp),
/* harmony export */   FilterComp: () => (/* binding */ FilterComp),
/* harmony export */   FilterWrapperComp: () => (/* binding */ FilterWrapperComp),
/* harmony export */   GROUP_AUTO_COLUMN_ID: () => (/* binding */ GROUP_AUTO_COLUMN_ID),
/* harmony export */   GridBodyCtrl: () => (/* binding */ GridBodyCtrl),
/* harmony export */   GridCoreCreator: () => (/* binding */ GridCoreCreator),
/* harmony export */   GridCtrl: () => (/* binding */ GridCtrl),
/* harmony export */   GridHeaderCtrl: () => (/* binding */ GridHeaderCtrl),
/* harmony export */   GridStateModule: () => (/* binding */ GridStateModule),
/* harmony export */   GroupInstanceIdCreator: () => (/* binding */ GroupInstanceIdCreator),
/* harmony export */   HeaderRowContainerCtrl: () => (/* binding */ HeaderRowContainerCtrl),
/* harmony export */   HighlightChangesModule: () => (/* binding */ HighlightChangesModule),
/* harmony export */   InfiniteRowModelModule: () => (/* binding */ InfiniteRowModelModule),
/* harmony export */   KeyCode: () => (/* binding */ KeyCode),
/* harmony export */   LargeTextEditorModule: () => (/* binding */ LargeTextEditorModule),
/* harmony export */   LocalEventService: () => (/* binding */ LocalEventService),
/* harmony export */   LocaleModule: () => (/* binding */ LocaleModule),
/* harmony export */   LocaleService: () => (/* binding */ LocaleService),
/* harmony export */   ManagedFocusFeature: () => (/* binding */ ManagedFocusFeature),
/* harmony export */   ModuleRegistry: () => (/* binding */ ModuleRegistry),
/* harmony export */   NumberEditorModule: () => (/* binding */ NumberEditorModule),
/* harmony export */   NumberFilterModule: () => (/* binding */ NumberFilterModule),
/* harmony export */   PaginationModule: () => (/* binding */ PaginationModule),
/* harmony export */   PinnedRowModel: () => (/* binding */ PinnedRowModel),
/* harmony export */   PinnedRowModule: () => (/* binding */ PinnedRowModule),
/* harmony export */   PopupComponent: () => (/* binding */ PopupComponent),
/* harmony export */   PositionableFeature: () => (/* binding */ PositionableFeature),
/* harmony export */   ProvidedFilter: () => (/* binding */ ProvidedFilter),
/* harmony export */   QuickFilterModule: () => (/* binding */ QuickFilterModule),
/* harmony export */   ROW_NUMBERS_COLUMN_ID: () => (/* binding */ ROW_NUMBERS_COLUMN_ID),
/* harmony export */   RefPlaceholder: () => (/* binding */ RefPlaceholder),
/* harmony export */   RenderApiModule: () => (/* binding */ RenderApiModule),
/* harmony export */   RowApiModule: () => (/* binding */ RowApiModule),
/* harmony export */   RowAutoHeightModule: () => (/* binding */ RowAutoHeightModule),
/* harmony export */   RowContainerCtrl: () => (/* binding */ RowContainerCtrl),
/* harmony export */   RowDragModule: () => (/* binding */ RowDragModule),
/* harmony export */   RowNode: () => (/* binding */ RowNode),
/* harmony export */   RowSelectionModule: () => (/* binding */ RowSelectionModule),
/* harmony export */   RowStyleModule: () => (/* binding */ RowStyleModule),
/* harmony export */   SELECTION_COLUMN_ID: () => (/* binding */ SELECTION_COLUMN_ID),
/* harmony export */   ScrollApiModule: () => (/* binding */ ScrollApiModule),
/* harmony export */   SelectEditorModule: () => (/* binding */ SelectEditorModule),
/* harmony export */   ServerSideTransactionResultStatus: () => (/* binding */ ServerSideTransactionResultStatus),
/* harmony export */   TabGuardClassNames: () => (/* binding */ TabGuardClassNames),
/* harmony export */   TabGuardComp: () => (/* binding */ TabGuardComp),
/* harmony export */   TabGuardCtrl: () => (/* binding */ TabGuardCtrl),
/* harmony export */   TabGuardFeature: () => (/* binding */ TabGuardFeature),
/* harmony export */   TextEditorModule: () => (/* binding */ TextEditorModule),
/* harmony export */   TextFilterModule: () => (/* binding */ TextFilterModule),
/* harmony export */   TooltipFeature: () => (/* binding */ TooltipFeature),
/* harmony export */   TooltipModule: () => (/* binding */ TooltipModule),
/* harmony export */   TouchListener: () => (/* binding */ TouchListener),
/* harmony export */   UndoRedoEditModule: () => (/* binding */ UndoRedoEditModule),
/* harmony export */   ValidationModule: () => (/* binding */ ValidationModule),
/* harmony export */   ValueCacheModule: () => (/* binding */ ValueCacheModule),
/* harmony export */   VanillaFrameworkOverrides: () => (/* binding */ VanillaFrameworkOverrides),
/* harmony export */   _BOOLEAN_MIXED_GRID_OPTIONS: () => (/* binding */ _BOOLEAN_MIXED_GRID_OPTIONS),
/* harmony export */   _ColumnFilterModule: () => (/* binding */ ColumnFilterModule),
/* harmony export */   _ColumnGroupModule: () => (/* binding */ ColumnGroupModule),
/* harmony export */   _ColumnMoveModule: () => (/* binding */ ColumnMoveModule),
/* harmony export */   _CsrmSsrmSharedApiModule: () => (/* binding */ CsrmSsrmSharedApiModule),
/* harmony export */   _DragModule: () => (/* binding */ DragModule),
/* harmony export */   _EditCoreModule: () => (/* binding */ EditCoreModule),
/* harmony export */   _EmptyArray: () => (/* binding */ _EmptyArray),
/* harmony export */   _EmptyBean: () => (/* binding */ EmptyBean),
/* harmony export */   _FOCUS_MANAGED_CLASS: () => (/* binding */ FOCUS_MANAGED_CLASS),
/* harmony export */   _FilterCoreModule: () => (/* binding */ FilterCoreModule),
/* harmony export */   _FilterValueModule: () => (/* binding */ FilterValueModule),
/* harmony export */   _GET_ALL_EVENTS: () => (/* binding */ _GET_ALL_EVENTS),
/* harmony export */   _GET_ALL_GRID_OPTIONS: () => (/* binding */ _GET_ALL_GRID_OPTIONS),
/* harmony export */   _HeaderComp: () => (/* binding */ HeaderComp),
/* harmony export */   _HorizontalResizeModule: () => (/* binding */ HorizontalResizeModule),
/* harmony export */   _KeyboardNavigationModule: () => (/* binding */ KeyboardNavigationModule),
/* harmony export */   _PUBLIC_EVENTS: () => (/* binding */ _PUBLIC_EVENTS),
/* harmony export */   _PUBLIC_EVENT_HANDLERS_MAP: () => (/* binding */ _PUBLIC_EVENT_HANDLERS_MAP),
/* harmony export */   _PopupModule: () => (/* binding */ PopupModule),
/* harmony export */   _ROW_ID_PREFIX_BOTTOM_PINNED: () => (/* binding */ ROW_ID_PREFIX_BOTTOM_PINNED),
/* harmony export */   _ROW_ID_PREFIX_ROW_GROUP: () => (/* binding */ ROW_ID_PREFIX_ROW_GROUP),
/* harmony export */   _ROW_ID_PREFIX_TOP_PINNED: () => (/* binding */ ROW_ID_PREFIX_TOP_PINNED),
/* harmony export */   _SharedDragAndDropModule: () => (/* binding */ SharedDragAndDropModule),
/* harmony export */   _SharedExportModule: () => (/* binding */ SharedExportModule),
/* harmony export */   _SharedMenuModule: () => (/* binding */ SharedMenuModule),
/* harmony export */   _SharedRowSelectionModule: () => (/* binding */ SharedRowSelectionModule),
/* harmony export */   _SortModule: () => (/* binding */ SortModule),
/* harmony export */   _SsrmInfiniteSharedApiModule: () => (/* binding */ SsrmInfiniteSharedApiModule),
/* harmony export */   _addColumnDefaultAndTypes: () => (/* binding */ _addColumnDefaultAndTypes),
/* harmony export */   _addFocusableContainerListener: () => (/* binding */ _addFocusableContainerListener),
/* harmony export */   _addGridCommonParams: () => (/* binding */ _addGridCommonParams),
/* harmony export */   _anchorElementToMouseMoveEvent: () => (/* binding */ _anchorElementToMouseMoveEvent),
/* harmony export */   _applyColumnState: () => (/* binding */ _applyColumnState),
/* harmony export */   _areCellsEqual: () => (/* binding */ _areCellsEqual),
/* harmony export */   _areColIdsEqual: () => (/* binding */ _areColIdsEqual),
/* harmony export */   _areEqual: () => (/* binding */ _areEqual),
/* harmony export */   _asThemeImpl: () => (/* binding */ _asThemeImpl),
/* harmony export */   _batchCall: () => (/* binding */ _batchCall),
/* harmony export */   _canSkipShowingRowGroup: () => (/* binding */ _canSkipShowingRowGroup),
/* harmony export */   _clearElement: () => (/* binding */ _clearElement),
/* harmony export */   _columnsMatch: () => (/* binding */ _columnsMatch),
/* harmony export */   _combineAttributesAndGridOptions: () => (/* binding */ _combineAttributesAndGridOptions),
/* harmony export */   _convertColumnEventSourceType: () => (/* binding */ _convertColumnEventSourceType),
/* harmony export */   _createCellId: () => (/* binding */ _createCellId),
/* harmony export */   _createColumnTree: () => (/* binding */ _createColumnTree),
/* harmony export */   _createColumnTreeWithIds: () => (/* binding */ _createColumnTreeWithIds),
/* harmony export */   _createElement: () => (/* binding */ _createElement),
/* harmony export */   _createGlobalRowEvent: () => (/* binding */ _createGlobalRowEvent),
/* harmony export */   _createIcon: () => (/* binding */ _createIcon),
/* harmony export */   _createIconNoSpan: () => (/* binding */ _createIconNoSpan),
/* harmony export */   _createRowNodeSibling: () => (/* binding */ _createRowNodeSibling),
/* harmony export */   _debounce: () => (/* binding */ _debounce),
/* harmony export */   _defaultComparator: () => (/* binding */ _defaultComparator),
/* harmony export */   _destroyColumnTree: () => (/* binding */ _destroyColumnTree),
/* harmony export */   _doOnce: () => (/* binding */ _doOnce),
/* harmony export */   _downloadFile: () => (/* binding */ _downloadFile),
/* harmony export */   _errMsg: () => (/* binding */ _errMsg),
/* harmony export */   _error: () => (/* binding */ _error),
/* harmony export */   _escapeString: () => (/* binding */ _escapeString),
/* harmony export */   _exists: () => (/* binding */ _exists),
/* harmony export */   _findFocusableElements: () => (/* binding */ _findFocusableElements),
/* harmony export */   _findNextFocusableElement: () => (/* binding */ _findNextFocusableElement),
/* harmony export */   _findTabbableParent: () => (/* binding */ _findTabbableParent),
/* harmony export */   _flatten: () => (/* binding */ _flatten),
/* harmony export */   _focusGridInnerElement: () => (/* binding */ _focusGridInnerElement),
/* harmony export */   _focusInto: () => (/* binding */ _focusInto),
/* harmony export */   _focusNextGridCoreContainer: () => (/* binding */ _focusNextGridCoreContainer),
/* harmony export */   _formatNumberCommas: () => (/* binding */ _formatNumberCommas),
/* harmony export */   _fuzzySuggestions: () => (/* binding */ _fuzzySuggestions),
/* harmony export */   _getAbsoluteHeight: () => (/* binding */ _getAbsoluteHeight),
/* harmony export */   _getAbsoluteWidth: () => (/* binding */ _getAbsoluteWidth),
/* harmony export */   _getActiveDomElement: () => (/* binding */ _getActiveDomElement),
/* harmony export */   _getAriaPosInSet: () => (/* binding */ _getAriaPosInSet),
/* harmony export */   _getCallbackForEvent: () => (/* binding */ _getCallbackForEvent),
/* harmony export */   _getCellByPosition: () => (/* binding */ _getCellByPosition),
/* harmony export */   _getCellCtrlForEventTarget: () => (/* binding */ _getCellCtrlForEventTarget),
/* harmony export */   _getCellPositionForEvent: () => (/* binding */ _getCellPositionForEvent),
/* harmony export */   _getCellRendererDetails: () => (/* binding */ _getCellRendererDetails),
/* harmony export */   _getCheckboxLocation: () => (/* binding */ _getCheckboxLocation),
/* harmony export */   _getCheckboxes: () => (/* binding */ _getCheckboxes),
/* harmony export */   _getClientSideRowModel: () => (/* binding */ _getClientSideRowModel),
/* harmony export */   _getColumnState: () => (/* binding */ _getColumnState),
/* harmony export */   _getColumnsFromTree: () => (/* binding */ _getColumnsFromTree),
/* harmony export */   _getDateParts: () => (/* binding */ _getDateParts),
/* harmony export */   _getDefaultFloatingFilterType: () => (/* binding */ _getDefaultFloatingFilterType),
/* harmony export */   _getDefaultSimpleFilter: () => (/* binding */ _getDefaultSimpleFilter),
/* harmony export */   _getDocument: () => (/* binding */ _getDocument),
/* harmony export */   _getEditorRendererDetails: () => (/* binding */ _getEditorRendererDetails),
/* harmony export */   _getFillHandle: () => (/* binding */ _getFillHandle),
/* harmony export */   _getFilterDetails: () => (/* binding */ _getFilterDetails),
/* harmony export */   _getFilterModel: () => (/* binding */ _getFilterModel),
/* harmony export */   _getFilterParamsForDataType: () => (/* binding */ _getFilterParamsForDataType),
/* harmony export */   _getFloatingFilterCompDetails: () => (/* binding */ _getFloatingFilterCompDetails),
/* harmony export */   _getFloatingFiltersHeight: () => (/* binding */ getFloatingFiltersHeight),
/* harmony export */   _getGlobalGridOption: () => (/* binding */ _getGlobalGridOption),
/* harmony export */   _getGrandTotalRow: () => (/* binding */ _getGrandTotalRow),
/* harmony export */   _getGridOption: () => (/* binding */ _getGridOption),
/* harmony export */   _getGridRegisteredModules: () => (/* binding */ _getGridRegisteredModules),
/* harmony export */   _getGroupAggFiltering: () => (/* binding */ _getGroupAggFiltering),
/* harmony export */   _getGroupSelection: () => (/* binding */ _getGroupSelection),
/* harmony export */   _getGroupSelectsDescendants: () => (/* binding */ _getGroupSelectsDescendants),
/* harmony export */   _getGroupTotalRowCallback: () => (/* binding */ _getGroupTotalRowCallback),
/* harmony export */   _getGroupingApproach: () => (/* binding */ _getGroupingApproach),
/* harmony export */   _getHeaderCheckbox: () => (/* binding */ _getHeaderCheckbox),
/* harmony export */   _getHeaderClassesFromColDef: () => (/* binding */ _getHeaderClassesFromColDef),
/* harmony export */   _getHeaderRowCount: () => (/* binding */ getHeaderRowCount),
/* harmony export */   _getInnerCellRendererDetails: () => (/* binding */ _getInnerCellRendererDetails),
/* harmony export */   _getInnerHeight: () => (/* binding */ _getInnerHeight),
/* harmony export */   _getInnerWidth: () => (/* binding */ _getInnerWidth),
/* harmony export */   _getIsRowSelectable: () => (/* binding */ _getIsRowSelectable),
/* harmony export */   _getLastRow: () => (/* binding */ _getLastRow),
/* harmony export */   _getLocaleTextFunc: () => (/* binding */ _getLocaleTextFunc),
/* harmony export */   _getMaxConcurrentDatasourceRequests: () => (/* binding */ _getMaxConcurrentDatasourceRequests),
/* harmony export */   _getNormalisedMousePosition: () => (/* binding */ _getNormalisedMousePosition),
/* harmony export */   _getPageBody: () => (/* binding */ _getPageBody),
/* harmony export */   _getRootNode: () => (/* binding */ _getRootNode),
/* harmony export */   _getRowAbove: () => (/* binding */ _getRowAbove),
/* harmony export */   _getRowBelow: () => (/* binding */ _getRowBelow),
/* harmony export */   _getRowContainerClass: () => (/* binding */ _getRowContainerClass),
/* harmony export */   _getRowContainerOptions: () => (/* binding */ _getRowContainerOptions),
/* harmony export */   _getRowHeightAsNumber: () => (/* binding */ _getRowHeightAsNumber),
/* harmony export */   _getRowHeightForNode: () => (/* binding */ _getRowHeightForNode),
/* harmony export */   _getRowIdCallback: () => (/* binding */ _getRowIdCallback),
/* harmony export */   _getRowNode: () => (/* binding */ _getRowNode),
/* harmony export */   _getRowSelectionMode: () => (/* binding */ _getRowSelectionMode),
/* harmony export */   _getRowSpanContainerClass: () => (/* binding */ _getRowSpanContainerClass),
/* harmony export */   _getRowViewportClass: () => (/* binding */ _getRowViewportClass),
/* harmony export */   _getServerSideRowModel: () => (/* binding */ _getServerSideRowModel),
/* harmony export */   _getShouldDisplayTooltip: () => (/* binding */ _getShouldDisplayTooltip),
/* harmony export */   _getSuppressMultiRanges: () => (/* binding */ _getSuppressMultiRanges),
/* harmony export */   _getToolPanelClassesFromColDef: () => (/* binding */ _getToolPanelClassesFromColDef),
/* harmony export */   _interpretAsRightClick: () => (/* binding */ _interpretAsRightClick),
/* harmony export */   _isAnimateRows: () => (/* binding */ _isAnimateRows),
/* harmony export */   _isCellSelectionEnabled: () => (/* binding */ _isCellSelectionEnabled),
/* harmony export */   _isClientSideRowModel: () => (/* binding */ _isClientSideRowModel),
/* harmony export */   _isColumnMenuAnchoringEnabled: () => (/* binding */ _isColumnMenuAnchoringEnabled),
/* harmony export */   _isColumnsSortingCoupledToGroup: () => (/* binding */ _isColumnsSortingCoupledToGroup),
/* harmony export */   _isDomLayout: () => (/* binding */ _isDomLayout),
/* harmony export */   _isElementInEventPath: () => (/* binding */ _isElementInEventPath),
/* harmony export */   _isElementOverflowingCallback: () => (/* binding */ _isElementOverflowingCallback),
/* harmony export */   _isEventFromPrintableCharacter: () => (/* binding */ _isEventFromPrintableCharacter),
/* harmony export */   _isFullWidthGroupRow: () => (/* binding */ _isFullWidthGroupRow),
/* harmony export */   _isGetRowHeightFunction: () => (/* binding */ _isGetRowHeightFunction),
/* harmony export */   _isGroupMultiAutoColumn: () => (/* binding */ _isGroupMultiAutoColumn),
/* harmony export */   _isGroupRowsSticky: () => (/* binding */ _isGroupRowsSticky),
/* harmony export */   _isGroupUseEntireRow: () => (/* binding */ _isGroupUseEntireRow),
/* harmony export */   _isIOSUserAgent: () => (/* binding */ _isIOSUserAgent),
/* harmony export */   _isKeyboardMode: () => (/* binding */ _isKeyboardMode),
/* harmony export */   _isLegacyMenuEnabled: () => (/* binding */ _isLegacyMenuEnabled),
/* harmony export */   _isMultiRowSelection: () => (/* binding */ _isMultiRowSelection),
/* harmony export */   _isNodeOrElement: () => (/* binding */ _isNodeOrElement),
/* harmony export */   _isNothingFocused: () => (/* binding */ _isNothingFocused),
/* harmony export */   _isPromise: () => (/* binding */ _isPromise),
/* harmony export */   _isRowBefore: () => (/* binding */ _isRowBefore),
/* harmony export */   _isRowSelection: () => (/* binding */ _isRowSelection),
/* harmony export */   _isSameRow: () => (/* binding */ _isSameRow),
/* harmony export */   _isServerSideRowModel: () => (/* binding */ _isServerSideRowModel),
/* harmony export */   _isSetFilterByDefault: () => (/* binding */ _isSetFilterByDefault),
/* harmony export */   _isShowTooltipWhenTruncated: () => (/* binding */ _isShowTooltipWhenTruncated),
/* harmony export */   _isStopPropagationForAgGrid: () => (/* binding */ _isStopPropagationForAgGrid),
/* harmony export */   _isUseApplyButton: () => (/* binding */ _isUseApplyButton),
/* harmony export */   _isUsingNewCellSelectionAPI: () => (/* binding */ _isUsingNewCellSelectionAPI),
/* harmony export */   _isUsingNewRowSelectionAPI: () => (/* binding */ _isUsingNewRowSelectionAPI),
/* harmony export */   _isVisible: () => (/* binding */ _isVisible),
/* harmony export */   _jsonEquals: () => (/* binding */ _jsonEquals),
/* harmony export */   _last: () => (/* binding */ _last),
/* harmony export */   _loadTemplate: () => (/* binding */ _loadTemplate),
/* harmony export */   _makeNull: () => (/* binding */ _makeNull),
/* harmony export */   _mergeDeep: () => (/* binding */ _mergeDeep),
/* harmony export */   _missing: () => (/* binding */ _missing),
/* harmony export */   _observeResize: () => (/* binding */ _observeResize),
/* harmony export */   _parseDateTimeFromString: () => (/* binding */ _parseDateTimeFromString),
/* harmony export */   _preInitErrMsg: () => (/* binding */ _preInitErrMsg),
/* harmony export */   _preserveRangesWhile: () => (/* binding */ _preserveRangesWhile),
/* harmony export */   _processOnChange: () => (/* binding */ _processOnChange),
/* harmony export */   _radioCssClass: () => (/* binding */ _radioCssClass),
/* harmony export */   _refreshFilterUi: () => (/* binding */ _refreshFilterUi),
/* harmony export */   _refreshHandlerAndUi: () => (/* binding */ _refreshHandlerAndUi),
/* harmony export */   _registerModule: () => (/* binding */ _registerModule),
/* harmony export */   _removeAriaExpanded: () => (/* binding */ _removeAriaExpanded),
/* harmony export */   _removeAriaSort: () => (/* binding */ _removeAriaSort),
/* harmony export */   _removeFromArray: () => (/* binding */ _removeFromArray),
/* harmony export */   _removeFromParent: () => (/* binding */ _removeFromParent),
/* harmony export */   _requestAnimationFrame: () => (/* binding */ _requestAnimationFrame),
/* harmony export */   _resetColumnState: () => (/* binding */ _resetColumnState),
/* harmony export */   _selectAllCells: () => (/* binding */ _selectAllCells),
/* harmony export */   _serialiseDate: () => (/* binding */ _serialiseDate),
/* harmony export */   _setAriaActiveDescendant: () => (/* binding */ _setAriaActiveDescendant),
/* harmony export */   _setAriaChecked: () => (/* binding */ _setAriaChecked),
/* harmony export */   _setAriaColCount: () => (/* binding */ _setAriaColCount),
/* harmony export */   _setAriaColIndex: () => (/* binding */ _setAriaColIndex),
/* harmony export */   _setAriaColSpan: () => (/* binding */ _setAriaColSpan),
/* harmony export */   _setAriaControls: () => (/* binding */ _setAriaControls),
/* harmony export */   _setAriaControlsAndLabel: () => (/* binding */ _setAriaControlsAndLabel),
/* harmony export */   _setAriaDescribedBy: () => (/* binding */ _setAriaDescribedBy),
/* harmony export */   _setAriaDisabled: () => (/* binding */ _setAriaDisabled),
/* harmony export */   _setAriaExpanded: () => (/* binding */ _setAriaExpanded),
/* harmony export */   _setAriaHasPopup: () => (/* binding */ _setAriaHasPopup),
/* harmony export */   _setAriaHidden: () => (/* binding */ _setAriaHidden),
/* harmony export */   _setAriaInvalid: () => (/* binding */ _setAriaInvalid),
/* harmony export */   _setAriaLabel: () => (/* binding */ _setAriaLabel),
/* harmony export */   _setAriaLabelledBy: () => (/* binding */ _setAriaLabelledBy),
/* harmony export */   _setAriaLevel: () => (/* binding */ _setAriaLevel),
/* harmony export */   _setAriaPosInSet: () => (/* binding */ _setAriaPosInSet),
/* harmony export */   _setAriaRole: () => (/* binding */ _setAriaRole),
/* harmony export */   _setAriaRowCount: () => (/* binding */ _setAriaRowCount),
/* harmony export */   _setAriaRowIndex: () => (/* binding */ _setAriaRowIndex),
/* harmony export */   _setAriaSelected: () => (/* binding */ _setAriaSelected),
/* harmony export */   _setAriaSetSize: () => (/* binding */ _setAriaSetSize),
/* harmony export */   _setAriaSort: () => (/* binding */ _setAriaSort),
/* harmony export */   _setColMenuVisible: () => (/* binding */ _setColMenuVisible),
/* harmony export */   _setDisabled: () => (/* binding */ _setDisabled),
/* harmony export */   _setDisplayed: () => (/* binding */ _setDisplayed),
/* harmony export */   _setFixedWidth: () => (/* binding */ _setFixedWidth),
/* harmony export */   _setUmd: () => (/* binding */ _setUmd),
/* harmony export */   _setVisible: () => (/* binding */ _setVisible),
/* harmony export */   _shouldUpdateColVisibilityAfterGroup: () => (/* binding */ _shouldUpdateColVisibilityAfterGroup),
/* harmony export */   _stopPropagationForAgGrid: () => (/* binding */ _stopPropagationForAgGrid),
/* harmony export */   _toString: () => (/* binding */ _toString),
/* harmony export */   _toStringOrNull: () => (/* binding */ _toStringOrNull),
/* harmony export */   _translate: () => (/* binding */ _translate),
/* harmony export */   _translateForFilter: () => (/* binding */ translateForFilter),
/* harmony export */   _unwrapUserComp: () => (/* binding */ _unwrapUserComp),
/* harmony export */   _updateColsMap: () => (/* binding */ _updateColsMap),
/* harmony export */   _updateColumnState: () => (/* binding */ _updateColumnState),
/* harmony export */   _updateFilterModel: () => (/* binding */ _updateFilterModel),
/* harmony export */   _waitUntil: () => (/* binding */ _waitUntil),
/* harmony export */   _warn: () => (/* binding */ _warn),
/* harmony export */   _warnOnce: () => (/* binding */ _warnOnce),
/* harmony export */   agTestIdFor: () => (/* binding */ agTestIdFor),
/* harmony export */   buttonStyleAlpine: () => (/* binding */ buttonStyleAlpine),
/* harmony export */   buttonStyleBalham: () => (/* binding */ buttonStyleBalham),
/* harmony export */   buttonStyleBase: () => (/* binding */ buttonStyleBase),
/* harmony export */   buttonStyleQuartz: () => (/* binding */ buttonStyleQuartz),
/* harmony export */   checkboxStyleDefault: () => (/* binding */ checkboxStyleDefault),
/* harmony export */   colorSchemeDark: () => (/* binding */ colorSchemeDark),
/* harmony export */   colorSchemeDarkBlue: () => (/* binding */ colorSchemeDarkBlue),
/* harmony export */   colorSchemeDarkWarm: () => (/* binding */ colorSchemeDarkWarm),
/* harmony export */   colorSchemeLight: () => (/* binding */ colorSchemeLight),
/* harmony export */   colorSchemeLightCold: () => (/* binding */ colorSchemeLightCold),
/* harmony export */   colorSchemeLightWarm: () => (/* binding */ colorSchemeLightWarm),
/* harmony export */   colorSchemeVariable: () => (/* binding */ colorSchemeVariable),
/* harmony export */   columnDropStyleBordered: () => (/* binding */ columnDropStyleBordered),
/* harmony export */   columnDropStylePlain: () => (/* binding */ columnDropStylePlain),
/* harmony export */   convertColumnGroupState: () => (/* binding */ convertColumnGroupState),
/* harmony export */   convertColumnState: () => (/* binding */ convertColumnState),
/* harmony export */   createGrid: () => (/* binding */ createGrid),
/* harmony export */   createPart: () => (/* binding */ createPart),
/* harmony export */   createTheme: () => (/* binding */ createTheme),
/* harmony export */   getGridApi: () => (/* binding */ getGridApi),
/* harmony export */   getGridElement: () => (/* binding */ getGridElement),
/* harmony export */   iconOverrides: () => (/* binding */ iconOverrides),
/* harmony export */   iconSetAlpine: () => (/* binding */ iconSetAlpine),
/* harmony export */   iconSetMaterial: () => (/* binding */ iconSetMaterial),
/* harmony export */   iconSetQuartz: () => (/* binding */ iconSetQuartz),
/* harmony export */   iconSetQuartzBold: () => (/* binding */ iconSetQuartzBold),
/* harmony export */   iconSetQuartzLight: () => (/* binding */ iconSetQuartzLight),
/* harmony export */   iconSetQuartzRegular: () => (/* binding */ iconSetQuartzRegular),
/* harmony export */   inputStyleBase: () => (/* binding */ inputStyleBase),
/* harmony export */   inputStyleBordered: () => (/* binding */ inputStyleBordered),
/* harmony export */   inputStyleUnderlined: () => (/* binding */ inputStyleUnderlined),
/* harmony export */   isColumn: () => (/* binding */ isColumn),
/* harmony export */   isColumnGroup: () => (/* binding */ isColumnGroup),
/* harmony export */   isColumnGroupAutoCol: () => (/* binding */ isColumnGroupAutoCol),
/* harmony export */   isColumnSelectionCol: () => (/* binding */ isColumnSelectionCol),
/* harmony export */   isCombinedFilterModel: () => (/* binding */ isCombinedFilterModel),
/* harmony export */   isProvidedColumnGroup: () => (/* binding */ isProvidedColumnGroup),
/* harmony export */   isRowNumberCol: () => (/* binding */ isRowNumberCol),
/* harmony export */   isSpecialCol: () => (/* binding */ isSpecialCol),
/* harmony export */   provideGlobalGridOptions: () => (/* binding */ provideGlobalGridOptions),
/* harmony export */   setupAgTestIds: () => (/* binding */ setupAgTestIds),
/* harmony export */   styleMaterial: () => (/* binding */ styleMaterial),
/* harmony export */   tabStyleAlpine: () => (/* binding */ tabStyleAlpine),
/* harmony export */   tabStyleBase: () => (/* binding */ tabStyleBase),
/* harmony export */   tabStyleMaterial: () => (/* binding */ tabStyleMaterial),
/* harmony export */   tabStyleQuartz: () => (/* binding */ tabStyleQuartz),
/* harmony export */   tabStyleRolodex: () => (/* binding */ tabStyleRolodex),
/* harmony export */   themeAlpine: () => (/* binding */ themeAlpine),
/* harmony export */   themeBalham: () => (/* binding */ themeBalham),
/* harmony export */   themeMaterial: () => (/* binding */ themeMaterial),
/* harmony export */   themeQuartz: () => (/* binding */ themeQuartz),
/* harmony export */   wrapAgTestIdFor: () => (/* binding */ wrapAgTestIdFor)
/* harmony export */ });
// packages/ag-grid-community/src/localEventService.ts
var LocalEventService = class {
  constructor() {
    this.allSyncListeners = /* @__PURE__ */ new Map();
    this.allAsyncListeners = /* @__PURE__ */ new Map();
    this.globalSyncListeners = /* @__PURE__ */ new Set();
    this.globalAsyncListeners = /* @__PURE__ */ new Set();
    this.asyncFunctionsQueue = [];
    this.scheduled = false;
    // using an object performs better than a Set for the number of different events we have
    this.firedEvents = {};
  }
  setFrameworkOverrides(frameworkOverrides) {
    this.frameworkOverrides = frameworkOverrides;
  }
  getListeners(eventType, async, autoCreateListenerCollection) {
    const listenerMap = async ? this.allAsyncListeners : this.allSyncListeners;
    let listeners = listenerMap.get(eventType);
    if (!listeners && autoCreateListenerCollection) {
      listeners = /* @__PURE__ */ new Set();
      listenerMap.set(eventType, listeners);
    }
    return listeners;
  }
  noRegisteredListenersExist() {
    return this.allSyncListeners.size === 0 && this.allAsyncListeners.size === 0 && this.globalSyncListeners.size === 0 && this.globalAsyncListeners.size === 0;
  }
  addEventListener(eventType, listener, async = false) {
    this.getListeners(eventType, async, true).add(listener);
  }
  removeEventListener(eventType, listener, async = false) {
    const listeners = this.getListeners(eventType, async, false);
    if (!listeners) {
      return;
    }
    listeners.delete(listener);
    if (listeners.size === 0) {
      (async ? this.allAsyncListeners : this.allSyncListeners).delete(eventType);
    }
  }
  addGlobalListener(listener, async = false) {
    this.getGlobalListeners(async).add(listener);
  }
  removeGlobalListener(listener, async = false) {
    this.getGlobalListeners(async).delete(listener);
  }
  dispatchEvent(event) {
    this.dispatchToListeners(event, true);
    this.dispatchToListeners(event, false);
    this.firedEvents[event.type] = true;
  }
  dispatchEventOnce(event) {
    if (!this.firedEvents[event.type]) {
      this.dispatchEvent(event);
    }
  }
  dispatchToListeners(event, async) {
    const eventType = event.type;
    if (async && "event" in event) {
      const browserEvent = event.event;
      if (browserEvent instanceof Event) {
        event.eventPath = browserEvent.composedPath();
      }
    }
    const { frameworkOverrides } = this;
    const runCallback = (func) => {
      const callback = frameworkOverrides ? () => frameworkOverrides.wrapIncoming(func) : func;
      if (async) {
        this.dispatchAsync(callback);
      } else {
        callback();
      }
    };
    const originalListeners = this.getListeners(eventType, async, false);
    if ((originalListeners?.size ?? 0) > 0) {
      const listeners = new Set(originalListeners);
      for (const listener of listeners) {
        if (!originalListeners?.has(listener)) {
          continue;
        }
        runCallback(() => listener(event));
      }
    }
    const globalListenersSrc = this.getGlobalListeners(async);
    if (globalListenersSrc.size > 0) {
      const globalListeners = new Set(globalListenersSrc);
      for (const listener of globalListeners) {
        runCallback(() => listener(eventType, event));
      }
    }
  }
  getGlobalListeners(async) {
    return async ? this.globalAsyncListeners : this.globalSyncListeners;
  }
  // this gets called inside the grid's thread, for each event that it
  // wants to set async. the grid then batches the events into one setTimeout()
  // because setTimeout() is an expensive operation. ideally we would have
  // each event in it's own setTimeout(), but we batch for performance.
  dispatchAsync(func) {
    this.asyncFunctionsQueue.push(func);
    if (!this.scheduled) {
      const flush = () => {
        window.setTimeout(this.flushAsyncQueue.bind(this), 0);
      };
      this.frameworkOverrides ? this.frameworkOverrides.wrapIncoming(flush) : flush();
      this.scheduled = true;
    }
  }
  // this happens in the next VM turn only, and empties the queue of events
  flushAsyncQueue() {
    this.scheduled = false;
    const queueCopy = this.asyncFunctionsQueue.slice();
    this.asyncFunctionsQueue = [];
    queueCopy.forEach((func) => func());
  }
};

// packages/ag-grid-community/src/misc/locale/localeUtils.ts
function defaultLocaleTextFunc(_key, defaultValue) {
  return defaultValue;
}
function _getLocaleTextFunc(localeSvc) {
  return localeSvc?.getLocaleTextFunc() ?? defaultLocaleTextFunc;
}
function _translate(bean, localeValues, key, variableValues) {
  const defaultValue = localeValues[key];
  return bean.getLocaleTextFunc()(
    key,
    typeof defaultValue === "function" ? defaultValue(variableValues) : defaultValue,
    variableValues
  );
}

// packages/ag-grid-community/src/utils/generic.ts
function _makeNull(value) {
  if (value == null || value === "") {
    return null;
  }
  return value;
}
function _exists(value) {
  return value != null && value !== "";
}
function _missing(value) {
  return !_exists(value);
}
function _toStringOrNull(value) {
  return value != null && typeof value.toString === "function" ? value.toString() : null;
}
function _jsonEquals(val1, val2) {
  const val1Json = val1 ? JSON.stringify(val1) : null;
  const val2Json = val2 ? JSON.stringify(val2) : null;
  return val1Json === val2Json;
}
function _defaultComparator(valueA, valueB, accentedCompare = false) {
  const valueAMissing = valueA == null;
  const valueBMissing = valueB == null;
  if (valueA && valueA.toNumber) {
    valueA = valueA.toNumber();
  }
  if (valueB && valueB.toNumber) {
    valueB = valueB.toNumber();
  }
  if (valueAMissing && valueBMissing) {
    return 0;
  }
  if (valueAMissing) {
    return -1;
  }
  if (valueBMissing) {
    return 1;
  }
  function doQuickCompare(a, b) {
    return a > b ? 1 : a < b ? -1 : 0;
  }
  if (typeof valueA !== "string") {
    return doQuickCompare(valueA, valueB);
  }
  if (!accentedCompare) {
    return doQuickCompare(valueA, valueB);
  }
  try {
    return valueA.localeCompare(valueB);
  } catch (e) {
    return doQuickCompare(valueA, valueB);
  }
}

// packages/ag-grid-community/src/utils/object.ts
var SKIP_JS_BUILTINS = /* @__PURE__ */ new Set(["__proto__", "constructor", "prototype"]);
function _iterateObject(object, callback) {
  if (object == null) {
    return;
  }
  if (Array.isArray(object)) {
    for (let i = 0; i < object.length; i++) {
      callback(i.toString(), object[i]);
    }
    return;
  }
  for (const key of Object.keys(object).filter((key2) => !SKIP_JS_BUILTINS.has(key2))) {
    callback(key, object[key]);
  }
}
function _mergeDeep(dest, source, copyUndefined = true, makeCopyOfSimpleObjects = false) {
  if (!_exists(source)) {
    return;
  }
  _iterateObject(source, (key, sourceValue) => {
    let destValue = dest[key];
    if (destValue === sourceValue) {
      return;
    }
    if (makeCopyOfSimpleObjects) {
      const objectIsDueToBeCopied = destValue == null && sourceValue != null;
      if (objectIsDueToBeCopied) {
        const doNotCopyAsSourceIsSimpleObject = typeof sourceValue === "object" && sourceValue.constructor === Object;
        if (doNotCopyAsSourceIsSimpleObject) {
          destValue = {};
          dest[key] = destValue;
        }
      }
    }
    if (_isNonNullObject(sourceValue) && _isNonNullObject(destValue) && !Array.isArray(destValue)) {
      _mergeDeep(destValue, sourceValue, copyUndefined, makeCopyOfSimpleObjects);
    } else if (copyUndefined || sourceValue !== void 0) {
      dest[key] = sourceValue;
    }
  });
}
function _getValueUsingField(data, field, fieldContainsDots) {
  if (!field || !data) {
    return;
  }
  if (!fieldContainsDots) {
    return data[field];
  }
  const fields = field.split(".");
  let currentObject = data;
  for (let i = 0; i < fields.length; i++) {
    if (currentObject == null) {
      return void 0;
    }
    currentObject = currentObject[fields[i]];
  }
  return currentObject;
}
function _isNonNullObject(value) {
  return typeof value === "object" && value !== null;
}

// packages/ag-grid-community/src/globalGridOptions.ts
var _GlobalGridOptions = class _GlobalGridOptions {
  /**
   * @param providedOptions
   * @returns Shallow copy of the provided options with global options merged in.
   */
  static applyGlobalGridOptions(providedOptions) {
    if (!_GlobalGridOptions.gridOptions) {
      return { ...providedOptions };
    }
    let mergedGridOps = {};
    _mergeDeep(mergedGridOps, _GlobalGridOptions.gridOptions, true, true);
    if (_GlobalGridOptions.mergeStrategy === "deep") {
      _mergeDeep(mergedGridOps, providedOptions, true, true);
    } else {
      mergedGridOps = { ...mergedGridOps, ...providedOptions };
    }
    if (_GlobalGridOptions.gridOptions.context) {
      mergedGridOps.context = _GlobalGridOptions.gridOptions.context;
    }
    if (providedOptions.context) {
      if (_GlobalGridOptions.mergeStrategy === "deep" && mergedGridOps.context) {
        _mergeDeep(providedOptions.context, mergedGridOps.context, true, true);
      }
      mergedGridOps.context = providedOptions.context;
    }
    return mergedGridOps;
  }
};
_GlobalGridOptions.gridOptions = void 0;
_GlobalGridOptions.mergeStrategy = "shallow";
var GlobalGridOptions = _GlobalGridOptions;
function provideGlobalGridOptions(gridOptions, mergeStrategy = "shallow") {
  GlobalGridOptions.gridOptions = gridOptions;
  GlobalGridOptions.mergeStrategy = mergeStrategy;
}
function _getGlobalGridOption(gridOption) {
  return GlobalGridOptions.gridOptions?.[gridOption];
}

// packages/ag-grid-community/src/gridOptionsDefault.ts
var GRID_OPTION_DEFAULTS = {
  suppressContextMenu: false,
  preventDefaultOnContextMenu: false,
  allowContextMenuWithControlKey: false,
  suppressMenuHide: true,
  enableBrowserTooltips: false,
  tooltipTrigger: "hover",
  tooltipShowDelay: 2e3,
  tooltipHideDelay: 1e4,
  tooltipMouseTrack: false,
  tooltipShowMode: "standard",
  tooltipInteraction: false,
  copyHeadersToClipboard: false,
  copyGroupHeadersToClipboard: false,
  clipboardDelimiter: "	",
  suppressCopyRowsToClipboard: false,
  suppressCopySingleCellRanges: false,
  suppressLastEmptyLineOnPaste: false,
  suppressClipboardPaste: false,
  suppressClipboardApi: false,
  suppressCutToClipboard: false,
  maintainColumnOrder: false,
  enableStrictPivotColumnOrder: false,
  suppressFieldDotNotation: false,
  allowDragFromColumnsToolPanel: false,
  suppressMovableColumns: false,
  suppressColumnMoveAnimation: false,
  suppressMoveWhenColumnDragging: false,
  suppressDragLeaveHidesColumns: false,
  suppressRowGroupHidesColumns: false,
  suppressAutoSize: false,
  autoSizePadding: 20,
  skipHeaderOnAutoSize: false,
  singleClickEdit: false,
  suppressClickEdit: false,
  readOnlyEdit: false,
  stopEditingWhenCellsLoseFocus: false,
  enterNavigatesVertically: false,
  enterNavigatesVerticallyAfterEdit: false,
  enableCellEditingOnBackspace: false,
  undoRedoCellEditing: false,
  undoRedoCellEditingLimit: 10,
  suppressCsvExport: false,
  suppressExcelExport: false,
  cacheQuickFilter: false,
  includeHiddenColumnsInQuickFilter: false,
  excludeChildrenWhenTreeDataFiltering: false,
  enableAdvancedFilter: false,
  includeHiddenColumnsInAdvancedFilter: false,
  enableCharts: false,
  masterDetail: false,
  keepDetailRows: false,
  keepDetailRowsCount: 10,
  detailRowAutoHeight: false,
  tabIndex: 0,
  rowBuffer: 10,
  valueCache: false,
  valueCacheNeverExpires: false,
  enableCellExpressions: false,
  suppressTouch: false,
  suppressFocusAfterRefresh: false,
  suppressBrowserResizeObserver: false,
  suppressPropertyNamesCheck: false,
  suppressChangeDetection: false,
  debug: false,
  suppressLoadingOverlay: false,
  suppressNoRowsOverlay: false,
  pagination: false,
  paginationPageSize: 100,
  paginationPageSizeSelector: true,
  paginationAutoPageSize: false,
  paginateChildRows: false,
  suppressPaginationPanel: false,
  pivotMode: false,
  pivotPanelShow: "never",
  pivotDefaultExpanded: 0,
  pivotSuppressAutoColumn: false,
  suppressExpandablePivotGroups: false,
  functionsReadOnly: false,
  suppressAggFuncInHeader: false,
  alwaysAggregateAtRootLevel: false,
  aggregateOnlyChangedColumns: false,
  suppressAggFilteredOnly: false,
  removePivotHeaderRowWhenSingleValueColumn: false,
  animateRows: true,
  cellFlashDuration: 500,
  cellFadeDuration: 1e3,
  allowShowChangeAfterFilter: false,
  domLayout: "normal",
  ensureDomOrder: false,
  enableRtl: false,
  suppressColumnVirtualisation: false,
  suppressMaxRenderedRowRestriction: false,
  suppressRowVirtualisation: false,
  rowDragManaged: false,
  rowDragInsertDelay: 500,
  suppressRowDrag: false,
  suppressMoveWhenRowDragging: false,
  rowDragEntireRow: false,
  rowDragMultiRow: false,
  embedFullWidthRows: false,
  groupDisplayType: "singleColumn",
  groupDefaultExpanded: 0,
  groupMaintainOrder: false,
  groupSelectsChildren: false,
  groupSuppressBlankHeader: false,
  groupSelectsFiltered: false,
  showOpenedGroup: false,
  groupRemoveSingleChildren: false,
  groupRemoveLowestSingleChildren: false,
  groupHideOpenParents: false,
  groupAllowUnbalanced: false,
  rowGroupPanelShow: "never",
  suppressMakeColumnVisibleAfterUnGroup: false,
  treeData: false,
  rowGroupPanelSuppressSort: false,
  suppressGroupRowsSticky: false,
  rowModelType: "clientSide",
  asyncTransactionWaitMillis: 50,
  suppressModelUpdateAfterUpdateTransaction: false,
  cacheOverflowSize: 1,
  infiniteInitialRowCount: 1,
  serverSideInitialRowCount: 1,
  cacheBlockSize: 100,
  maxBlocksInCache: -1,
  maxConcurrentDatasourceRequests: 2,
  blockLoadDebounceMillis: 0,
  purgeClosedRowNodes: false,
  serverSideSortAllLevels: false,
  serverSideOnlyRefreshFilteredGroups: false,
  serverSidePivotResultFieldSeparator: "_",
  viewportRowModelPageSize: 5,
  viewportRowModelBufferSize: 5,
  alwaysShowHorizontalScroll: false,
  alwaysShowVerticalScroll: false,
  debounceVerticalScrollbar: false,
  suppressHorizontalScroll: false,
  suppressScrollOnNewData: false,
  suppressScrollWhenPopupsAreOpen: false,
  suppressAnimationFrame: false,
  suppressMiddleClickScrolls: false,
  suppressPreventDefaultOnMouseWheel: false,
  rowMultiSelectWithClick: false,
  suppressRowDeselection: false,
  suppressRowClickSelection: false,
  suppressCellFocus: false,
  suppressHeaderFocus: false,
  suppressMultiRangeSelection: false,
  enableCellTextSelection: false,
  enableRangeSelection: false,
  enableRangeHandle: false,
  enableFillHandle: false,
  fillHandleDirection: "xy",
  suppressClearOnFillReduction: false,
  accentedSort: false,
  unSortIcon: false,
  suppressMultiSort: false,
  alwaysMultiSort: false,
  suppressMaintainUnsortedOrder: false,
  suppressRowHoverHighlight: false,
  suppressRowTransform: false,
  columnHoverHighlight: false,
  deltaSort: false,
  enableGroupEdit: false,
  groupLockGroupColumns: 0,
  serverSideEnableClientSideSort: false,
  suppressServerSideFullWidthLoadingRow: false,
  pivotMaxGeneratedColumns: -1,
  columnMenu: "new",
  reactiveCustomComponents: true,
  suppressSetFilterByDefault: false,
  rowNumbers: false,
  enableFilterHandlers: false
};

// packages/ag-grid-community/src/utils/aria.ts
function _toggleAriaAttribute(element, attribute, value) {
  if (value == null || typeof value === "string" && value == "") {
    _removeAriaAttribute(element, attribute);
  } else {
    _setAriaAttribute(element, attribute, value);
  }
}
function _setAriaAttribute(element, attribute, value) {
  element.setAttribute(_ariaAttributeName(attribute), value.toString());
}
function _removeAriaAttribute(element, attribute) {
  element.removeAttribute(_ariaAttributeName(attribute));
}
function _ariaAttributeName(attribute) {
  return `aria-${attribute}`;
}
function _setAriaRole(element, role) {
  if (role) {
    element.setAttribute("role", role);
  } else {
    element.removeAttribute("role");
  }
}
function _getAriaSortState(sortDirection) {
  let sort;
  if (sortDirection === "asc") {
    sort = "ascending";
  } else if (sortDirection === "desc") {
    sort = "descending";
  } else if (sortDirection === "mixed") {
    sort = "other";
  } else {
    sort = "none";
  }
  return sort;
}
function _getAriaPosInSet(element) {
  return parseInt(element.getAttribute("aria-posinset"), 10);
}
function _getAriaLabel(element) {
  return element.getAttribute("aria-label");
}
function _setAriaLabel(element, label) {
  _toggleAriaAttribute(element, "label", label);
}
function _setAriaLabelledBy(element, labelledBy) {
  _toggleAriaAttribute(element, "labelledby", labelledBy);
}
function _setAriaDescribedBy(element, describedby) {
  _toggleAriaAttribute(element, "describedby", describedby);
}
function _setAriaLive(element, live) {
  _toggleAriaAttribute(element, "live", live);
}
function _setAriaAtomic(element, atomic) {
  _toggleAriaAttribute(element, "atomic", atomic);
}
function _setAriaRelevant(element, relevant) {
  _toggleAriaAttribute(element, "relevant", relevant);
}
function _setAriaInvalid(element, invalid) {
  _toggleAriaAttribute(element, "invalid", invalid);
}
function _setAriaLevel(element, level) {
  _toggleAriaAttribute(element, "level", level);
}
function _setAriaDisabled(element, disabled) {
  _toggleAriaAttribute(element, "disabled", disabled);
}
function _setAriaHidden(element, hidden) {
  _toggleAriaAttribute(element, "hidden", hidden);
}
function _setAriaActiveDescendant(element, descendantId) {
  _toggleAriaAttribute(element, "activedescendant", descendantId);
}
function _setAriaExpanded(element, expanded) {
  _setAriaAttribute(element, "expanded", expanded);
}
function _removeAriaExpanded(element) {
  _removeAriaAttribute(element, "expanded");
}
function _setAriaSetSize(element, setsize) {
  _setAriaAttribute(element, "setsize", setsize);
}
function _setAriaPosInSet(element, position) {
  _setAriaAttribute(element, "posinset", position);
}
function _setAriaMultiSelectable(element, multiSelectable) {
  _setAriaAttribute(element, "multiselectable", multiSelectable);
}
function _setAriaRowCount(element, rowCount) {
  _setAriaAttribute(element, "rowcount", rowCount);
}
function _setAriaRowIndex(element, rowIndex) {
  _setAriaAttribute(element, "rowindex", rowIndex);
}
function _setAriaRowSpan(element, spanCount) {
  _setAriaAttribute(element, "rowspan", spanCount);
}
function _setAriaColCount(element, colCount) {
  _setAriaAttribute(element, "colcount", colCount);
}
function _setAriaColIndex(element, colIndex) {
  _setAriaAttribute(element, "colindex", colIndex);
}
function _setAriaColSpan(element, colSpan) {
  _setAriaAttribute(element, "colspan", colSpan);
}
function _setAriaSort(element, sort) {
  _setAriaAttribute(element, "sort", sort);
}
function _removeAriaSort(element) {
  _removeAriaAttribute(element, "sort");
}
function _setAriaSelected(element, selected) {
  _toggleAriaAttribute(element, "selected", selected);
}
function _setAriaChecked(element, checked) {
  _setAriaAttribute(element, "checked", checked === void 0 ? "mixed" : checked);
}
function _setAriaControls(controllerElement, controlledId) {
  _toggleAriaAttribute(controllerElement, "controls", controlledId);
}
function _setAriaControlsAndLabel(controllerElement, controlledElement) {
  _setAriaControls(controllerElement, controlledElement.id);
  _setAriaLabelledBy(controlledElement, controllerElement.id);
}
function _setAriaOwns(ownerElement, ownedId) {
  _toggleAriaAttribute(ownerElement, "owns", ownedId);
}
function _setAriaHasPopup(element, hasPopup) {
  _toggleAriaAttribute(element, "haspopup", hasPopup === false ? null : hasPopup);
}
function _getAriaCheckboxStateName(translate, state) {
  return state === void 0 ? translate("ariaIndeterminate", "indeterminate") : state === true ? translate("ariaChecked", "checked") : translate("ariaUnchecked", "unchecked");
}

// packages/ag-grid-community/src/utils/browser.ts
var isSafari;
var isFirefox;
var isMacOs;
var isIOS;
var invisibleScrollbar;
var browserScrollbarWidth;
var maxDivHeight;
function _isBrowserSafari() {
  if (isSafari === void 0) {
    isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);
  }
  return isSafari;
}
function _isBrowserFirefox() {
  if (isFirefox === void 0) {
    isFirefox = /(firefox)/i.test(navigator.userAgent);
  }
  return isFirefox;
}
function _isMacOsUserAgent() {
  if (isMacOs === void 0) {
    isMacOs = /(Mac|iPhone|iPod|iPad)/i.test(navigator.platform);
  }
  return isMacOs;
}
function _isIOSUserAgent() {
  if (isIOS === void 0) {
    isIOS = /iPad|iPhone|iPod/.test(navigator.platform) || navigator.platform === "MacIntel" && navigator.maxTouchPoints > 1;
  }
  return isIOS;
}
function _getTabIndex(el) {
  if (!el) {
    return null;
  }
  const numberTabIndex = el.tabIndex;
  const tabIndex = el.getAttribute("tabIndex");
  if (numberTabIndex === -1 && (tabIndex === null || tabIndex === "" && !_isBrowserFirefox())) {
    return null;
  }
  return numberTabIndex.toString();
}
function _getMaxDivHeight() {
  if (maxDivHeight !== void 0) {
    return maxDivHeight;
  }
  if (!document.body) {
    return -1;
  }
  let res = 1e6;
  const testUpTo = _isBrowserFirefox() ? 6e6 : 1e9;
  const div = document.createElement("div");
  document.body.appendChild(div);
  while (true) {
    const test = res * 2;
    div.style.height = test + "px";
    if (test > testUpTo || div.clientHeight !== test) {
      break;
    } else {
      res = test;
    }
  }
  document.body.removeChild(div);
  maxDivHeight = res;
  return res;
}
function _getScrollbarWidth() {
  if (browserScrollbarWidth == null) {
    initScrollbarWidthAndVisibility();
  }
  return browserScrollbarWidth;
}
function initScrollbarWidthAndVisibility() {
  const body = document.body;
  const div = document.createElement("div");
  div.style.width = div.style.height = "100px";
  div.style.opacity = "0";
  div.style.overflow = "scroll";
  div.style.msOverflowStyle = "scrollbar";
  div.style.position = "absolute";
  body.appendChild(div);
  let width = div.offsetWidth - div.clientWidth;
  if (width === 0 && div.clientWidth === 0) {
    width = null;
  }
  if (div.parentNode) {
    div.parentNode.removeChild(div);
  }
  if (width != null) {
    browserScrollbarWidth = width;
    invisibleScrollbar = width === 0;
  }
}
function _isInvisibleScrollbar() {
  if (invisibleScrollbar == null) {
    initScrollbarWidthAndVisibility();
  }
  return invisibleScrollbar;
}

// packages/ag-grid-community/src/utils/dom.ts
function _radioCssClass(element, elementClass, otherElementClass) {
  const parent = element.parentElement;
  let sibling = parent && parent.firstChild;
  while (sibling) {
    if (elementClass) {
      sibling.classList.toggle(elementClass, sibling === element);
    }
    if (otherElementClass) {
      sibling.classList.toggle(otherElementClass, sibling !== element);
    }
    sibling = sibling.nextSibling;
  }
}
var FOCUSABLE_SELECTOR = "[tabindex], input, select, button, textarea, [href]";
var FOCUSABLE_EXCLUDE = "[disabled], .ag-disabled:not(.ag-button), .ag-disabled *";
function _isFocusableFormField(element) {
  const matches = Element.prototype.matches || Element.prototype.msMatchesSelector;
  const inputSelector = "input, select, button, textarea";
  const isFocusable = matches.call(element, inputSelector);
  const isNotFocusable = matches.call(element, FOCUSABLE_EXCLUDE);
  const isElementVisible = _isVisible(element);
  const focusable = isFocusable && !isNotFocusable && isElementVisible;
  return focusable;
}
function _setDisplayed(element, displayed, options = {}) {
  const { skipAriaHidden } = options;
  element.classList.toggle("ag-hidden", !displayed);
  if (!skipAriaHidden) {
    _setAriaHidden(element, !displayed);
  }
}
function _setVisible(element, visible, options = {}) {
  const { skipAriaHidden } = options;
  element.classList.toggle("ag-invisible", !visible);
  if (!skipAriaHidden) {
    _setAriaHidden(element, !visible);
  }
}
function _setDisabled(element, disabled) {
  const attributeName = "disabled";
  const addOrRemoveDisabledAttribute = disabled ? (e) => e.setAttribute(attributeName, "") : (e) => e.removeAttribute(attributeName);
  addOrRemoveDisabledAttribute(element);
  const inputs = element.querySelectorAll("input") ?? [];
  for (const input of inputs) {
    addOrRemoveDisabledAttribute(input);
  }
}
function _isElementChildOfClass(element, cls, maxNest) {
  let counter = 0;
  while (element) {
    if (element.classList.contains(cls)) {
      return true;
    }
    element = element.parentElement;
    if (typeof maxNest == "number") {
      if (++counter > maxNest) {
        break;
      }
    } else if (element === maxNest) {
      break;
    }
  }
  return false;
}
function _getElementSize(el) {
  const {
    height,
    width,
    borderTopWidth,
    borderRightWidth,
    borderBottomWidth,
    borderLeftWidth,
    paddingTop,
    paddingRight,
    paddingBottom,
    paddingLeft,
    marginTop,
    marginRight,
    marginBottom,
    marginLeft,
    boxSizing
  } = window.getComputedStyle(el);
  return {
    height: parseFloat(height || "0"),
    width: parseFloat(width || "0"),
    borderTopWidth: parseFloat(borderTopWidth || "0"),
    borderRightWidth: parseFloat(borderRightWidth || "0"),
    borderBottomWidth: parseFloat(borderBottomWidth || "0"),
    borderLeftWidth: parseFloat(borderLeftWidth || "0"),
    paddingTop: parseFloat(paddingTop || "0"),
    paddingRight: parseFloat(paddingRight || "0"),
    paddingBottom: parseFloat(paddingBottom || "0"),
    paddingLeft: parseFloat(paddingLeft || "0"),
    marginTop: parseFloat(marginTop || "0"),
    marginRight: parseFloat(marginRight || "0"),
    marginBottom: parseFloat(marginBottom || "0"),
    marginLeft: parseFloat(marginLeft || "0"),
    boxSizing
  };
}
function _getInnerHeight(el) {
  const size = _getElementSize(el);
  if (size.boxSizing === "border-box") {
    return size.height - size.paddingTop - size.paddingBottom;
  }
  return size.height;
}
function _getInnerWidth(el) {
  const size = _getElementSize(el);
  if (size.boxSizing === "border-box") {
    return size.width - size.paddingLeft - size.paddingRight;
  }
  return size.width;
}
function _getAbsoluteHeight(el) {
  const { height, marginBottom, marginTop } = _getElementSize(el);
  return Math.floor(height + marginBottom + marginTop);
}
function _getAbsoluteWidth(el) {
  const { width, marginLeft, marginRight } = _getElementSize(el);
  return Math.floor(width + marginLeft + marginRight);
}
function _getElementRectWithOffset(el) {
  const offsetElementRect = el.getBoundingClientRect();
  const { borderTopWidth, borderLeftWidth, borderRightWidth, borderBottomWidth } = _getElementSize(el);
  return {
    top: offsetElementRect.top + (borderTopWidth || 0),
    left: offsetElementRect.left + (borderLeftWidth || 0),
    right: offsetElementRect.right + (borderRightWidth || 0),
    bottom: offsetElementRect.bottom + (borderBottomWidth || 0)
  };
}
function _getScrollLeft(element, rtl) {
  let scrollLeft = element.scrollLeft;
  if (rtl) {
    scrollLeft = Math.abs(scrollLeft);
  }
  return scrollLeft;
}
function _setScrollLeft(element, value, rtl) {
  if (rtl) {
    value *= -1;
  }
  element.scrollLeft = value;
}
function _clearElement(el) {
  while (el && el.firstChild) {
    el.removeChild(el.firstChild);
  }
}
function _removeFromParent(node) {
  if (node && node.parentNode) {
    node.parentNode.removeChild(node);
  }
}
function _isInDOM(element) {
  return !!element.offsetParent;
}
function _isVisible(element) {
  const el = element;
  if (el.checkVisibility) {
    return el.checkVisibility({ checkVisibilityCSS: true });
  }
  const isHidden = !_isInDOM(element) || window.getComputedStyle(element).visibility !== "visible";
  return !isHidden;
}
function _loadTemplate(template) {
  const tempDiv = document.createElement("div");
  tempDiv.innerHTML = (template || "").trim();
  return tempDiv.firstChild;
}
function _ensureDomOrder(eContainer, eChild, eChildBefore) {
  if (eChildBefore && eChildBefore.nextSibling === eChild) {
    return;
  }
  if (!eContainer.firstChild) {
    eContainer.appendChild(eChild);
  } else if (eChildBefore) {
    if (eChildBefore.nextSibling) {
      eContainer.insertBefore(eChild, eChildBefore.nextSibling);
    } else {
      eContainer.appendChild(eChild);
    }
  } else if (eContainer.firstChild && eContainer.firstChild !== eChild) {
    eContainer.insertAdjacentElement("afterbegin", eChild);
  }
}
function _setDomChildOrder(eContainer, orderedChildren) {
  for (let i = 0; i < orderedChildren.length; i++) {
    const correctCellAtIndex = orderedChildren[i];
    const actualCellAtIndex = eContainer.children[i];
    if (actualCellAtIndex !== correctCellAtIndex) {
      eContainer.insertBefore(correctCellAtIndex, actualCellAtIndex);
    }
  }
}
function _camelCaseToHyphenated(camelCase) {
  return camelCase.replace(/[A-Z]/g, (s) => `-${s.toLocaleLowerCase()}`);
}
function _addStylesToElement(eElement, styles) {
  if (!styles) {
    return;
  }
  for (const key of Object.keys(styles)) {
    const value = styles[key];
    if (!key || !key.length || value == null) {
      continue;
    }
    const parsedKey = _camelCaseToHyphenated(key);
    const valueAsString = value.toString();
    const parsedValue = valueAsString.replace(/\s*!important/g, "");
    const priority = parsedValue.length != valueAsString.length ? "important" : void 0;
    eElement.style.setProperty(parsedKey, parsedValue, priority);
  }
}
function _isElementOverflowingCallback(getElement2) {
  return () => {
    const element = getElement2();
    if (!element) {
      return true;
    }
    return _isHorizontalScrollShowing(element) || _isVerticalScrollShowing(element);
  };
}
function _isHorizontalScrollShowing(element) {
  return element.clientWidth < element.scrollWidth;
}
function _isVerticalScrollShowing(element) {
  return element.clientHeight < element.scrollHeight;
}
function _setElementWidth(element, width) {
  if (width === "flex") {
    element.style.removeProperty("width");
    element.style.removeProperty("minWidth");
    element.style.removeProperty("maxWidth");
    element.style.flex = "1 1 auto";
  } else {
    _setFixedWidth(element, width);
  }
}
function _setFixedWidth(element, width) {
  width = _formatSize(width);
  element.style.width = width;
  element.style.maxWidth = width;
  element.style.minWidth = width;
}
function _setFixedHeight(element, height) {
  height = _formatSize(height);
  element.style.height = height;
  element.style.maxHeight = height;
  element.style.minHeight = height;
}
function _formatSize(size) {
  return typeof size === "number" ? `${size}px` : size;
}
function _isNodeOrElement(o) {
  return o instanceof Node || o instanceof HTMLElement;
}
function _addOrRemoveAttribute(element, name, value) {
  if (value == null || value === "") {
    element.removeAttribute(name);
  } else {
    element.setAttribute(name, value.toString());
  }
}
function _observeResize(beans, element, callback) {
  const win = _getWindow(beans);
  const ResizeObserverImpl = win.ResizeObserver;
  const resizeObserver = ResizeObserverImpl ? new ResizeObserverImpl(callback) : null;
  resizeObserver?.observe(element);
  return () => resizeObserver?.disconnect();
}
function _getTextSelectionRanges(beans) {
  const rootNode = _getRootNode(beans);
  const selection = "getSelection" in rootNode ? rootNode.getSelection() : null;
  const ranges = [];
  for (let i = 0; i < (selection?.rangeCount ?? 0); i++) {
    const range = selection?.getRangeAt(i);
    if (range) {
      ranges.push(range);
    }
  }
  return { selection, ranges };
}
function _preserveRangesWhile(beans, fn) {
  const enableCellTextSelection = beans.gos.get("enableCellTextSelection");
  if (!enableCellTextSelection) {
    return fn();
  }
  if (!_isBrowserFirefox() && !_isBrowserSafari()) {
    return fn();
  }
  const { selection, ranges } = _getTextSelectionRanges(beans);
  fn();
  selection?.removeAllRanges();
  for (const range of ranges) {
    selection?.addRange(range);
  }
}
function _requestAnimationFrame(beans, callback) {
  const win = _getWindow(beans);
  if (win.requestAnimationFrame) {
    win.requestAnimationFrame(callback);
  } else if (win.webkitRequestAnimationFrame) {
    win.webkitRequestAnimationFrame(callback);
  } else {
    win.setTimeout(callback, 0);
  }
}
var DataRefAttribute = "data-ref";
var whitespaceNode;
function getWhitespaceNode() {
  whitespaceNode ?? (whitespaceNode = document.createTextNode(" "));
  return whitespaceNode.cloneNode();
}
function _createElement(params) {
  const { attrs, children, cls, ref, role, tag } = params;
  const element = document.createElement(tag);
  if (cls) {
    element.className = cls;
  }
  if (ref) {
    element.setAttribute(DataRefAttribute, ref);
  }
  if (role) {
    element.setAttribute("role", role);
  }
  if (attrs) {
    for (const key of Object.keys(attrs)) {
      element.setAttribute(key, attrs[key]);
    }
  }
  if (children) {
    if (typeof children === "string") {
      element.textContent = children;
    } else {
      let addFirstWhitespace = true;
      for (const child of children) {
        if (child) {
          if (typeof child === "string") {
            element.appendChild(document.createTextNode(child));
            addFirstWhitespace = false;
          } else if (typeof child === "function") {
            element.appendChild(child());
          } else {
            if (addFirstWhitespace) {
              element.appendChild(getWhitespaceNode());
              addFirstWhitespace = false;
            }
            element.append(_createElement(child));
            element.appendChild(getWhitespaceNode());
          }
        }
      }
    }
  }
  return element;
}

// packages/ag-grid-community/src/utils/function.ts
var doOnceFlags = {};
function _doOnce(func, key) {
  if (doOnceFlags[key]) {
    return;
  }
  func();
  doOnceFlags[key] = true;
}
function _logIfDebug(gos, message, ...args) {
  if (gos.get("debug")) {
    console.log("AG Grid: " + message, ...args);
  }
}
function _warnOnce(msg, ...args) {
  _doOnce(() => console.warn("AG Grid: " + msg, ...args), msg + args?.join(""));
}
function _errorOnce(msg, ...args) {
  _doOnce(() => console.error("AG Grid: " + msg, ...args), msg + args?.join(""));
}
var batchedCallsSetTimeout = {
  pending: false,
  funcs: []
};
var batchedCallsRaf = {
  pending: false,
  funcs: []
};
function _batchCall(func, mode = "setTimeout", beans) {
  const batch = mode === "raf" ? batchedCallsRaf : batchedCallsSetTimeout;
  batch.funcs.push(func);
  if (batch.pending) {
    return;
  }
  batch.pending = true;
  const runBatch = () => {
    const funcsCopy = batch.funcs.slice();
    batch.funcs.length = 0;
    batch.pending = false;
    funcsCopy.forEach((func2) => func2());
  };
  if (mode === "raf") {
    _requestAnimationFrame(beans, runBatch);
  } else {
    window.setTimeout(runBatch, 0);
  }
}
function _debounce(bean, func, delay) {
  let timeout;
  return function(...args) {
    const context = this;
    window.clearTimeout(timeout);
    timeout = window.setTimeout(function() {
      if (bean.isAlive()) {
        func.apply(context, args);
      }
    }, delay);
  };
}
function _throttle(func, wait) {
  let previousCall = 0;
  return function(...args) {
    const context = this;
    const currentCall = Date.now();
    if (currentCall - previousCall < wait) {
      return;
    }
    previousCall = currentCall;
    func.apply(context, args);
  };
}
function _waitUntil(condition, callback, timeout = 100, timeoutMessage) {
  const timeStamp = Date.now();
  let interval = null;
  let executed = false;
  const internalCallback = () => {
    const reachedTimeout = Date.now() - timeStamp > timeout;
    if (condition() || reachedTimeout) {
      callback();
      executed = true;
      if (interval != null) {
        window.clearInterval(interval);
        interval = null;
      }
      if (reachedTimeout && timeoutMessage) {
        _warnOnce(timeoutMessage);
      }
    }
  };
  internalCallback();
  if (!executed) {
    interval = window.setInterval(internalCallback, 10);
  }
}

// packages/ag-grid-community/src/baseUrl.ts
var BASE_URL = "https://www.ag-grid.com";

// packages/ag-grid-community/src/version.ts
var VERSION = "34.1.1";

// packages/ag-grid-community/src/validation/logging.ts
var MAX_URL_LENGTH = 2e3;
var MIN_PARAM_LENGTH = 100;
var VERSION_PARAM_NAME = "_version_";
var validation = null;
var baseDocLink = `${BASE_URL}/javascript-data-grid`;
function provideValidationServiceLogger(logger) {
  validation = logger;
}
function setValidationDocLink(docLink) {
  baseDocLink = docLink;
}
function getErrorParts(id, args, defaultMessage) {
  return validation?.getConsoleMessage(id, args) ?? [minifiedLog(id, args, defaultMessage)];
}
function getMsgOrDefault(logger, id, args, defaultMessage) {
  logger(`error #${id}`, ...getErrorParts(id, args, defaultMessage));
}
function stringifyObject(inputObj) {
  if (!inputObj)
    return String(inputObj);
  const object = {};
  for (const prop of Object.keys(inputObj)) {
    if (typeof inputObj[prop] !== "object" && typeof inputObj[prop] !== "function") {
      object[prop] = inputObj[prop];
    }
  }
  return JSON.stringify(object);
}
function stringifyValue(value) {
  let output = value;
  if (value instanceof Error) {
    output = value.toString();
  } else if (typeof value === "object") {
    output = stringifyObject(value);
  }
  return output;
}
function toStringWithNullUndefined(str) {
  return str === void 0 ? "undefined" : str === null ? "null" : str;
}
function getParamsUrl(baseUrl, params) {
  return `${baseUrl}?${params.toString()}`;
}
function truncateUrl(baseUrl, params, maxLength) {
  const sortedParams = Array.from(params.entries()).sort((a, b) => b[1].length - a[1].length);
  let url = getParamsUrl(baseUrl, params);
  for (const [key, value] of sortedParams) {
    if (key === VERSION_PARAM_NAME) {
      continue;
    }
    const excessLength = url.length - maxLength;
    if (excessLength <= 0) {
      break;
    }
    const ellipse = "...";
    const truncateAmount = excessLength + ellipse.length;
    const truncatedValue = value.length - truncateAmount > MIN_PARAM_LENGTH ? value.slice(0, value.length - truncateAmount) + ellipse : value.slice(0, MIN_PARAM_LENGTH) + ellipse;
    params.set(key, truncatedValue);
    url = getParamsUrl(baseUrl, params);
  }
  return url;
}
function getErrorLink(errorNum, args) {
  const params = new URLSearchParams();
  params.append(VERSION_PARAM_NAME, VERSION);
  if (args) {
    for (const key of Object.keys(args)) {
      params.append(key, stringifyValue(args[key]));
    }
  }
  const baseUrl = `${baseDocLink}/errors/${errorNum}`;
  const url = getParamsUrl(baseUrl, params);
  return url.length <= MAX_URL_LENGTH ? url : truncateUrl(baseUrl, params, MAX_URL_LENGTH);
}
var minifiedLog = (errorNum, args, defaultMessage) => {
  const errorLink = getErrorLink(errorNum, args);
  return `${defaultMessage ? defaultMessage + " \n" : ""}Visit ${errorLink}${defaultMessage ? "" : " \n  Alternatively register the ValidationModule to see the full message in the console."}`;
};
function _warn(...args) {
  getMsgOrDefault(_warnOnce, args[0], args[1]);
}
function _error(...args) {
  getMsgOrDefault(_errorOnce, args[0], args[1]);
}
function _logPreInitErr(id, args, defaultMessage) {
  getMsgOrDefault(_errorOnce, id, args, defaultMessage);
}
function getErrMsg(defaultMessage, args) {
  const id = args[0];
  return `error #${id} ` + getErrorParts(id, args[1], defaultMessage).join(" ");
}
function _errMsg(...args) {
  return getErrMsg(void 0, args);
}
function _preInitErrMsg(...args) {
  return getErrMsg("\n", args);
}

// packages/ag-grid-community/src/gridOptionsUtils.ts
function isRowModelType(gos, rowModelType) {
  return gos.get("rowModelType") === rowModelType;
}
function _isClientSideRowModel(gos, rowModel) {
  return isRowModelType(gos, "clientSide");
}
function _isServerSideRowModel(gos, rowModel) {
  return isRowModelType(gos, "serverSide");
}
function _isDomLayout(gos, domLayout) {
  return gos.get("domLayout") === domLayout;
}
function _isRowSelection(gos) {
  return _getRowSelectionMode(gos) !== void 0;
}
function _isGetRowHeightFunction(gos) {
  return typeof gos.get("getRowHeight") === "function";
}
function _shouldMaintainColumnOrder(gos, isPivotColumns) {
  if (isPivotColumns) {
    return !gos.get("enableStrictPivotColumnOrder");
  }
  return gos.get("maintainColumnOrder");
}
function _getRowHeightForNode(beans, rowNode, allowEstimate = false, defaultRowHeight) {
  const { gos, environment } = beans;
  if (defaultRowHeight == null) {
    defaultRowHeight = environment.getDefaultRowHeight();
  }
  if (_isGetRowHeightFunction(gos)) {
    if (allowEstimate) {
      return { height: defaultRowHeight, estimated: true };
    }
    const params = {
      node: rowNode,
      data: rowNode.data
    };
    const height = gos.getCallback("getRowHeight")(params);
    if (isNumeric(height)) {
      if (height === 0) {
        _warn(23);
      }
      return { height: Math.max(1, height), estimated: false };
    }
  }
  if (rowNode.detail && gos.get("masterDetail")) {
    return getMasterDetailRowHeight(gos);
  }
  const gridOptionsRowHeight = gos.get("rowHeight");
  const rowHeight = gridOptionsRowHeight && isNumeric(gridOptionsRowHeight) ? gridOptionsRowHeight : defaultRowHeight;
  return { height: rowHeight, estimated: false };
}
function getMasterDetailRowHeight(gos) {
  if (gos.get("detailRowAutoHeight")) {
    return { height: 1, estimated: false };
  }
  const defaultRowHeight = gos.get("detailRowHeight");
  if (isNumeric(defaultRowHeight)) {
    return { height: defaultRowHeight, estimated: false };
  }
  return { height: 300, estimated: false };
}
function _getRowHeightAsNumber(beans) {
  const { environment, gos } = beans;
  const gridOptionsRowHeight = gos.get("rowHeight");
  if (!gridOptionsRowHeight || _missing(gridOptionsRowHeight)) {
    return environment.getDefaultRowHeight();
  }
  const rowHeight = environment.refreshRowHeightVariable();
  if (rowHeight !== -1) {
    return rowHeight;
  }
  _warn(24);
  return environment.getDefaultRowHeight();
}
function isNumeric(value) {
  return !isNaN(value) && typeof value === "number" && isFinite(value);
}
function _getDomData(gos, element, key) {
  const domData = element[gos.getDomDataKey()];
  return domData ? domData[key] : void 0;
}
function _setDomData(gos, element, key, value) {
  const domDataKey = gos.getDomDataKey();
  let domData = element[domDataKey];
  if (_missing(domData)) {
    domData = {};
    element[domDataKey] = domData;
  }
  domData[key] = value;
}
function _getDocument(beans) {
  const { gos, eGridDiv } = beans;
  let result = null;
  const gridOptionsGetDocument = gos.get("getDocument");
  if (gridOptionsGetDocument && _exists(gridOptionsGetDocument)) {
    result = gridOptionsGetDocument();
  } else if (eGridDiv) {
    result = eGridDiv.ownerDocument;
  }
  if (result && _exists(result)) {
    return result;
  }
  return document;
}
function _getWindow(beans) {
  const eDocument = _getDocument(beans);
  return eDocument.defaultView || window;
}
function _getRootNode(beans) {
  return beans.eGridDiv.getRootNode();
}
function _getActiveDomElement(beans) {
  return _getRootNode(beans).activeElement;
}
function _getPageBody(beans) {
  let rootNode = null;
  let targetEl = null;
  try {
    rootNode = _getDocument(beans).fullscreenElement;
  } catch (e) {
  } finally {
    if (!rootNode) {
      rootNode = _getRootNode(beans);
    }
    const body = rootNode.querySelector("body");
    if (body) {
      targetEl = body;
    } else if (rootNode instanceof ShadowRoot) {
      targetEl = rootNode;
    } else if (rootNode instanceof Document) {
      targetEl = rootNode?.documentElement;
    } else {
      targetEl = rootNode;
    }
  }
  return targetEl;
}
function _getBodyWidth(beans) {
  const body = _getPageBody(beans);
  return body?.clientWidth ?? (window.innerWidth || -1);
}
function _getBodyHeight(beans) {
  const body = _getPageBody(beans);
  return body?.clientHeight ?? (window.innerHeight || -1);
}
function _anchorElementToMouseMoveEvent(element, mouseMoveEvent, beans) {
  const eRect = element.getBoundingClientRect();
  const height = eRect.height;
  const browserWidth = _getBodyWidth(beans) - 2;
  const browserHeight = _getBodyHeight(beans) - 2;
  const offsetParent = element.offsetParent;
  if (!offsetParent) {
    return;
  }
  const offsetParentSize = _getElementRectWithOffset(element.offsetParent);
  const { clientY, clientX } = mouseMoveEvent;
  let top = clientY - offsetParentSize.top - height / 2;
  let left = clientX - offsetParentSize.left - 10;
  const eDocument = _getDocument(beans);
  const win = eDocument.defaultView || window;
  const windowScrollY = win.pageYOffset || eDocument.documentElement.scrollTop;
  const windowScrollX = win.pageXOffset || eDocument.documentElement.scrollLeft;
  if (browserWidth > 0 && left + element.clientWidth > browserWidth + windowScrollX) {
    left = browserWidth + windowScrollX - element.clientWidth;
  }
  if (left < 0) {
    left = 0;
  }
  if (browserHeight > 0 && top + element.clientHeight > browserHeight + windowScrollY) {
    top = browserHeight + windowScrollY - element.clientHeight;
  }
  if (top < 0) {
    top = 0;
  }
  element.style.left = `${left}px`;
  element.style.top = `${top}px`;
}
function _isNothingFocused(beans) {
  const activeEl = _getActiveDomElement(beans);
  return activeEl === null || activeEl === _getDocument(beans).body;
}
function _isAnimateRows(gos) {
  if (gos.get("ensureDomOrder")) {
    return false;
  }
  return gos.get("animateRows");
}
function _isGroupRowsSticky(gos) {
  if (gos.get("paginateChildRows") || gos.get("groupHideOpenParents") || _isDomLayout(gos, "print")) {
    return false;
  }
  return true;
}
function _isColumnsSortingCoupledToGroup(gos) {
  const autoGroupColumnDef = gos.get("autoGroupColumnDef");
  return !autoGroupColumnDef?.comparator && !gos.get("treeData");
}
function _getGroupAggFiltering(gos) {
  const userValue = gos.get("groupAggFiltering");
  if (typeof userValue === "function") {
    return gos.getCallback("groupAggFiltering");
  }
  if (userValue === true) {
    return () => true;
  }
  return void 0;
}
function _getGrandTotalRow(gos) {
  return gos.get("grandTotalRow");
}
function _getGroupTotalRowCallback(gos) {
  const userValue = gos.get("groupTotalRow");
  if (typeof userValue === "function") {
    return gos.getCallback("groupTotalRow");
  }
  return () => userValue ?? void 0;
}
function _isGroupMultiAutoColumn(gos) {
  const isHideOpenParents = !!gos.get("groupHideOpenParents");
  if (isHideOpenParents) {
    return true;
  }
  return gos.get("groupDisplayType") === "multipleColumns";
}
function _isGroupUseEntireRow(gos, pivotMode) {
  if (pivotMode) {
    return false;
  }
  return gos.get("groupDisplayType") === "groupRows";
}
function _isFullWidthGroupRow(gos, node, pivotMode) {
  return !!node.group && !node.footer && _isGroupUseEntireRow(gos, pivotMode);
}
function _getRowIdCallback(gos) {
  const getRowId = gos.getCallback("getRowId");
  if (getRowId === void 0) {
    return getRowId;
  }
  return (params) => {
    let id = getRowId(params);
    if (typeof id !== "string") {
      _doOnce(() => _warn(25, { id }), "getRowIdString");
      id = String(id);
    }
    return id;
  };
}
function _canSkipShowingRowGroup(gos, node) {
  const isSkippingGroups = gos.get("groupHideParentOfSingleChild");
  if (isSkippingGroups === true) {
    return true;
  }
  if (isSkippingGroups === "leafGroupsOnly" && node.leafGroup) {
    return true;
  }
  if (gos.get("groupRemoveSingleChildren")) {
    return true;
  }
  if (gos.get("groupRemoveLowestSingleChildren") && node.leafGroup) {
    return true;
  }
  return false;
}
function _getMaxConcurrentDatasourceRequests(gos) {
  const res = gos.get("maxConcurrentDatasourceRequests");
  return res > 0 ? res : void 0;
}
function _shouldUpdateColVisibilityAfterGroup(gos, isGrouped) {
  const preventVisibilityChanges = gos.get("suppressGroupChangesColumnVisibility");
  if (preventVisibilityChanges === true) {
    return false;
  }
  if (isGrouped && preventVisibilityChanges === "suppressHideOnGroup") {
    return false;
  }
  if (!isGrouped && preventVisibilityChanges === "suppressShowOnUngroup") {
    return false;
  }
  const legacySuppressOnGroup = gos.get("suppressRowGroupHidesColumns");
  if (isGrouped && legacySuppressOnGroup === true) {
    return false;
  }
  const legacySuppressOnUngroup = gos.get("suppressMakeColumnVisibleAfterUnGroup");
  if (!isGrouped && legacySuppressOnUngroup === true) {
    return false;
  }
  return true;
}
function _getCheckboxes(selection) {
  return selection?.checkboxes ?? true;
}
function _getHeaderCheckbox(selection) {
  return selection?.mode === "multiRow" && (selection.headerCheckbox ?? true);
}
function _getCheckboxLocation(rowSelection) {
  if (typeof rowSelection !== "object") {
    return void 0;
  }
  return rowSelection.checkboxLocation ?? "selectionColumn";
}
function _getHideDisabledCheckboxes(selection) {
  return selection?.hideDisabledCheckboxes ?? false;
}
function _isUsingNewRowSelectionAPI(gos) {
  const rowSelection = gos.get("rowSelection");
  return typeof rowSelection !== "string";
}
function _isUsingNewCellSelectionAPI(gos) {
  return gos.get("cellSelection") !== void 0;
}
function _getSuppressMultiRanges(gos) {
  const selection = gos.get("cellSelection");
  const useNewAPI = selection !== void 0;
  if (!useNewAPI) {
    return gos.get("suppressMultiRangeSelection");
  }
  return typeof selection !== "boolean" ? selection?.suppressMultiRanges ?? false : false;
}
function _isCellSelectionEnabled(gos) {
  const selection = gos.get("cellSelection");
  const useNewAPI = selection !== void 0;
  return useNewAPI ? !!selection : gos.get("enableRangeSelection");
}
function _getFillHandle(gos) {
  const selection = gos.get("cellSelection");
  const useNewAPI = selection !== void 0;
  if (!useNewAPI) {
    return {
      mode: "fill",
      setFillValue: gos.get("fillOperation"),
      direction: gos.get("fillHandleDirection"),
      suppressClearOnFillReduction: gos.get("suppressClearOnFillReduction")
    };
  }
  return typeof selection !== "boolean" && selection.handle?.mode === "fill" ? selection.handle : void 0;
}
function _getEnableClickSelection(gos) {
  const selection = gos.get("rowSelection") ?? "single";
  if (typeof selection === "string") {
    const suppressRowClickSelection = gos.get("suppressRowClickSelection");
    const suppressRowDeselection = gos.get("suppressRowDeselection");
    if (suppressRowClickSelection && suppressRowDeselection) {
      return false;
    } else if (suppressRowClickSelection) {
      return "enableDeselection";
    } else if (suppressRowDeselection) {
      return "enableSelection";
    } else {
      return true;
    }
  }
  return selection.mode === "singleRow" || selection.mode === "multiRow" ? selection.enableClickSelection ?? false : false;
}
function _getEnableSelection(gos) {
  const enableClickSelection = _getEnableClickSelection(gos);
  return enableClickSelection === true || enableClickSelection === "enableSelection";
}
function _getEnableDeselection(gos) {
  const enableClickSelection = _getEnableClickSelection(gos);
  return enableClickSelection === true || enableClickSelection === "enableDeselection";
}
function _getIsRowSelectable(gos) {
  const selection = gos.get("rowSelection");
  if (typeof selection === "string") {
    return gos.get("isRowSelectable");
  }
  return selection?.isRowSelectable;
}
function _getRowSelectionMode(arg) {
  const selection = "beanName" in arg && arg.beanName === "gos" ? arg.get("rowSelection") : arg.rowSelection;
  if (typeof selection === "string") {
    switch (selection) {
      case "multiple":
        return "multiRow";
      case "single":
        return "singleRow";
      default:
        return;
    }
  }
  switch (selection?.mode) {
    case "multiRow":
    case "singleRow":
      return selection.mode;
    default:
      return;
  }
}
function _isMultiRowSelection(arg) {
  const mode = _getRowSelectionMode(arg);
  return mode === "multiRow";
}
function _getEnableSelectionWithoutKeys(gos) {
  const selection = gos.get("rowSelection");
  if (typeof selection === "string") {
    return gos.get("rowMultiSelectWithClick");
  }
  return selection?.enableSelectionWithoutKeys ?? false;
}
function _getGroupSelection(gos) {
  const selection = gos.get("rowSelection");
  if (typeof selection === "string") {
    const groupSelectsChildren = gos.get("groupSelectsChildren");
    const groupSelectsFiltered = gos.get("groupSelectsFiltered");
    if (groupSelectsChildren && groupSelectsFiltered) {
      return "filteredDescendants";
    } else if (groupSelectsChildren) {
      return "descendants";
    } else {
      return "self";
    }
  }
  return selection?.mode === "multiRow" ? selection.groupSelects : void 0;
}
function _getSelectAll(gos, defaultValue = true) {
  const rowSelection = gos.get("rowSelection");
  if (typeof rowSelection !== "object") {
    return defaultValue ? "all" : void 0;
  }
  return rowSelection.mode === "multiRow" ? rowSelection.selectAll : "all";
}
function _getGroupSelectsDescendants(gos) {
  const groupSelection = _getGroupSelection(gos);
  return groupSelection === "descendants" || groupSelection === "filteredDescendants";
}
function _getMasterSelects(gos) {
  const rowSelection = gos.get("rowSelection");
  return typeof rowSelection === "object" && rowSelection.masterSelects || "self";
}
function _isSetFilterByDefault(gos) {
  return gos.isModuleRegistered("SetFilter") && !gos.get("suppressSetFilterByDefault");
}
function _isLegacyMenuEnabled(gos) {
  return gos.get("columnMenu") === "legacy";
}
function _isColumnMenuAnchoringEnabled(gos) {
  return !_isLegacyMenuEnabled(gos);
}
function _getCallbackForEvent(eventName) {
  if (!eventName || eventName.length < 2) {
    return eventName;
  }
  return "on" + eventName[0].toUpperCase() + eventName.substring(1);
}
function _combineAttributesAndGridOptions(gridOptions, component, gridOptionsKeys) {
  if (typeof gridOptions !== "object") {
    gridOptions = {};
  }
  const mergedOptions = { ...gridOptions };
  gridOptionsKeys.forEach((key) => {
    const value = component[key];
    if (typeof value !== "undefined") {
      mergedOptions[key] = value;
    }
  });
  return mergedOptions;
}
function _processOnChange(changes, api) {
  if (!changes) {
    return;
  }
  const gridChanges = {};
  let hasChanges = false;
  Object.keys(changes).forEach((key) => {
    gridChanges[key] = changes[key];
    hasChanges = true;
  });
  if (!hasChanges) {
    return;
  }
  const internalUpdateEvent = {
    type: "gridOptionsChanged",
    options: gridChanges
  };
  api.dispatchEvent(internalUpdateEvent);
  const event = {
    type: "componentStateChanged",
    ...gridChanges
  };
  api.dispatchEvent(event);
}
function _addGridCommonParams(gos, params) {
  return gos.addGridCommonParams(params);
}
function _getGroupingApproach(gos) {
  if (gos.get("treeData")) {
    if (gos.get("treeDataParentIdField")) {
      return "treeSelfRef";
    }
    if (gos.get("treeDataChildrenField")) {
      return "treeNested";
    }
    return "treePath";
  }
  return "group";
}
function _getGridOption(providedGridOptions, gridOption) {
  return providedGridOptions[gridOption] ?? providedGridOptions[`gridOptions`]?.[gridOption] ?? _getGlobalGridOption(gridOption) ?? GRID_OPTION_DEFAULTS[gridOption];
}

// packages/ag-grid-community/src/utils/event.ts
var AG_GRID_STOP_PROPAGATION = "__ag_Grid_Stop_Propagation";
var PASSIVE_EVENTS = ["touchstart", "touchend", "touchmove", "touchcancel", "scroll"];
var NON_PASSIVE_EVENTS = ["wheel"];
var supports = {};
function _stopPropagationForAgGrid(event) {
  event[AG_GRID_STOP_PROPAGATION] = true;
}
function _isStopPropagationForAgGrid(event) {
  return event[AG_GRID_STOP_PROPAGATION] === true;
}
var _isEventSupported = /* @__PURE__ */ (() => {
  const tags = {
    select: "input",
    change: "input",
    submit: "form",
    reset: "form",
    error: "img",
    load: "img",
    abort: "img"
  };
  const eventChecker = (eventName) => {
    if (typeof supports[eventName] === "boolean") {
      return supports[eventName];
    }
    const el = document.createElement(tags[eventName] || "div");
    eventName = "on" + eventName;
    return supports[eventName] = eventName in el;
  };
  return eventChecker;
})();
function _getCtrlForEventTarget(gos, eventTarget, type) {
  let sourceElement = eventTarget;
  while (sourceElement) {
    const renderedComp = _getDomData(gos, sourceElement, type);
    if (renderedComp) {
      return renderedComp;
    }
    sourceElement = sourceElement.parentElement;
  }
  return null;
}
function _isElementInEventPath(element, event) {
  if (!event || !element) {
    return false;
  }
  return _getEventPath(event).indexOf(element) >= 0;
}
function _createEventPath(event) {
  const res = [];
  let pointer = event.target;
  while (pointer) {
    res.push(pointer);
    pointer = pointer.parentElement;
  }
  return res;
}
function _getEventPath(event) {
  const eventNoType = event;
  if (eventNoType.path) {
    return eventNoType.path;
  }
  if (eventNoType.composedPath) {
    return eventNoType.composedPath();
  }
  return _createEventPath(eventNoType);
}
function _addSafePassiveEventListener(frameworkOverrides, eElement, event, listener) {
  const passive = getPassiveStateForEvent(event);
  let options;
  if (passive != null) {
    options = { passive };
  }
  if (frameworkOverrides && frameworkOverrides.addEventListener) {
    frameworkOverrides.addEventListener(eElement, event, listener, options);
  }
}
var getPassiveStateForEvent = (event) => {
  const isPassive = PASSIVE_EVENTS.includes(event);
  const isNonPassive = NON_PASSIVE_EVENTS.includes(event);
  if (isPassive) {
    return true;
  }
  if (isNonPassive) {
    return false;
  }
};

// packages/ag-grid-community/src/context/beanStub.ts
var BeanStub = class {
  constructor() {
    // not named context to allow children to use 'context' as a variable name
    this.destroyFunctions = [];
    this.destroyed = false;
    // for vue 3 - prevents Vue from trying to make this (and obviously any sub classes) from being reactive
    // prevents vue from creating proxies for created objects and prevents identity related issues
    this.__v_skip = true;
    this.propertyListenerId = 0;
    // Enable multiple grid properties to be updated together by the user but only trigger shared logic once.
    // Closely related to logic in GridOptionsUtils.ts _processOnChange
    this.lastChangeSetIdLookup = {};
    this.isAlive = () => !this.destroyed;
  }
  preWireBeans(beans) {
    this.beans = beans;
    this.stubContext = beans.context;
    this.eventSvc = beans.eventSvc;
    this.gos = beans.gos;
  }
  // this was a test constructor niall built, when active, it prints after 5 seconds all beans/components that are
  // not destroyed. to use, create a new grid, then api.destroy() before 5 seconds. then anything that gets printed
  // points to a bean or component that was not properly disposed of.
  // constructor() {
  //     setTimeout(()=> {
  //         if (this.isAlive()) {
  //             let prototype: any = Object.getPrototypeOf(this);
  //             const constructor: any = prototype.constructor;
  //             const constructorString = constructor.toString();
  //             const beanName = constructorString.substring(9, constructorString.indexOf("("));
  //             console.log('is alive ' + beanName);
  //         }
  //     }, 5000);
  // }
  destroy() {
    const { destroyFunctions } = this;
    for (let i = 0; i < destroyFunctions.length; i++) {
      destroyFunctions[i]();
    }
    destroyFunctions.length = 0;
    this.destroyed = true;
    this.dispatchLocalEvent({ type: "destroyed" });
  }
  // The typing of AgEventListener<any, any, any> is not ideal, but it's the best we can do at the moment to enable
  // eventSvc to have the best typing at the expense of BeanStub local events
  /** Add a local event listener against this BeanStub */
  addEventListener(eventType, listener, async) {
    if (!this.localEventService) {
      this.localEventService = new LocalEventService();
    }
    this.localEventService.addEventListener(eventType, listener, async);
  }
  /** Remove a local event listener from this BeanStub */
  removeEventListener(eventType, listener, async) {
    this.localEventService?.removeEventListener(eventType, listener, async);
  }
  dispatchLocalEvent(event) {
    this.localEventService?.dispatchEvent(event);
  }
  addManagedElementListeners(object, handlers) {
    return this._setupListeners(object, handlers);
  }
  addManagedEventListeners(handlers) {
    return this._setupListeners(this.eventSvc, handlers);
  }
  addManagedListeners(object, handlers) {
    return this._setupListeners(object, handlers);
  }
  _setupListeners(object, handlers) {
    const destroyFuncs = [];
    for (const k of Object.keys(handlers)) {
      const handler = handlers[k];
      if (handler) {
        destroyFuncs.push(this._setupListener(object, k, handler));
      }
    }
    return destroyFuncs;
  }
  _setupListener(object, event, listener) {
    if (this.destroyed) {
      return () => null;
    }
    let destroyFunc;
    if (isAgEventEmitter(object)) {
      object.__addEventListener(event, listener);
      destroyFunc = () => {
        object.__removeEventListener(event, listener);
        return null;
      };
    } else {
      if (object instanceof HTMLElement) {
        _addSafePassiveEventListener(this.beans.frameworkOverrides, object, event, listener);
      } else {
        object.addEventListener(event, listener);
      }
      destroyFunc = () => {
        object.removeEventListener(event, listener);
        return null;
      };
    }
    this.destroyFunctions.push(destroyFunc);
    return () => {
      destroyFunc();
      this.destroyFunctions = this.destroyFunctions.filter((fn) => fn !== destroyFunc);
      return null;
    };
  }
  /**
   * Setup a managed property listener for the given GridOption property.
   * However, stores the destroy function in the beanStub so that if this bean
   * is a component the destroy function will be called when the component is destroyed
   * as opposed to being cleaned up only when the GridOptionsService is destroyed.
   */
  setupGridOptionListener(event, listener) {
    const { gos } = this;
    gos.addPropertyEventListener(event, listener);
    const destroyFunc = () => {
      gos.removePropertyEventListener(event, listener);
      return null;
    };
    this.destroyFunctions.push(destroyFunc);
    return () => {
      destroyFunc();
      this.destroyFunctions = this.destroyFunctions.filter((fn) => fn !== destroyFunc);
      return null;
    };
  }
  /**
   * Setup a managed property listener for the given GridOption property.
   * @param event GridOption property to listen to changes for.
   * @param listener Listener to run when property value changes
   */
  addManagedPropertyListener(event, listener) {
    if (this.destroyed) {
      return () => null;
    }
    return this.setupGridOptionListener(event, listener);
  }
  /**
   * Setup managed property listeners for the given set of GridOption properties.
   * The listener will be run if any of the property changes but will only run once if
   * multiple of the properties change within the same framework lifecycle event.
   * Works on the basis that GridOptionsService updates all properties *before* any property change events are fired.
   * @param events Array of GridOption properties to listen for changes too.
   * @param listener Shared listener to run if any of the properties change
   */
  addManagedPropertyListeners(events, listener) {
    if (this.destroyed) {
      return;
    }
    const eventsKey = events.join("-") + this.propertyListenerId++;
    const wrappedListener = (event) => {
      if (event.changeSet) {
        if (event.changeSet && event.changeSet.id === this.lastChangeSetIdLookup[eventsKey]) {
          return;
        }
        this.lastChangeSetIdLookup[eventsKey] = event.changeSet.id;
      }
      const propertiesChangeEvent = {
        type: "gridPropertyChanged",
        changeSet: event.changeSet,
        source: event.source
      };
      listener(propertiesChangeEvent);
    };
    events.forEach((event) => this.setupGridOptionListener(event, wrappedListener));
  }
  getLocaleTextFunc() {
    return _getLocaleTextFunc(this.beans.localeSvc);
  }
  addDestroyFunc(func) {
    if (this.isAlive()) {
      this.destroyFunctions.push(func);
    } else {
      func();
    }
  }
  /** doesn't throw an error if `bean` is undefined */
  createOptionalManagedBean(bean, context) {
    return bean ? this.createManagedBean(bean, context) : void 0;
  }
  createManagedBean(bean, context) {
    const res = this.createBean(bean, context);
    this.addDestroyFunc(this.destroyBean.bind(this, bean, context));
    return res;
  }
  createBean(bean, context, afterPreCreateCallback) {
    return (context || this.stubContext).createBean(bean, afterPreCreateCallback);
  }
  /**
   * Destroys a bean and returns undefined to support destruction and clean up in a single line.
   * this.dateComp = this.context.destroyBean(this.dateComp);
   */
  destroyBean(bean, context) {
    return (context || this.stubContext).destroyBean(bean);
  }
  /**
   * Destroys an array of beans and returns an empty array to support destruction and clean up in a single line.
   * this.dateComps = this.context.destroyBeans(this.dateComps);
   */
  destroyBeans(beans, context) {
    return (context || this.stubContext).destroyBeans(beans);
  }
};
function isAgEventEmitter(object) {
  return object.__addEventListener !== void 0;
}

// packages/ag-grid-community/src/utils/string.ts
var reUnescapedHtml = /[&<>"']/g;
var HTML_ESCAPES = {
  "&": "&amp;",
  "<": "&lt;",
  ">": "&gt;",
  '"': "&quot;",
  "'": "&#39;"
};
function _toString(toEscape) {
  return toEscape?.toString().toString() ?? null;
}
function _escapeString(toEscape) {
  return _toString(toEscape)?.replace(reUnescapedHtml, (chr) => HTML_ESCAPES[chr]) ?? null;
}

// packages/ag-grid-community/src/entities/agColumn.ts
var COL_DEF_DEFAULTS = {
  resizable: true,
  sortable: true
};
var instanceIdSequence = 0;
function getNextColInstanceId() {
  return instanceIdSequence++;
}
function isColumn(col) {
  return col instanceof AgColumn;
}
var AgColumn = class extends BeanStub {
  constructor(colDef, userProvidedColDef, colId, primary) {
    super();
    this.colDef = colDef;
    this.userProvidedColDef = userProvidedColDef;
    this.colId = colId;
    this.primary = primary;
    this.isColumn = true;
    // used by React (and possibly other frameworks) as key for rendering. also used to
    // identify old vs new columns for destroying cols when no longer used.
    this.instanceId = getNextColInstanceId();
    // The measured height of this column's header when autoHeaderHeight is enabled
    this.autoHeaderHeight = null;
    this.moving = false;
    this.resizing = false;
    this.menuVisible = false;
    this.lastLeftPinned = false;
    this.firstRightPinned = false;
    this.filterActive = false;
    this.colEventSvc = new LocalEventService();
    this.tooltipEnabled = false;
    this.rowGroupActive = false;
    this.pivotActive = false;
    this.aggregationActive = false;
    this.flex = null;
    this.colIdSanitised = _escapeString(colId);
  }
  destroy() {
    super.destroy();
    this.beans.rowSpanSvc?.deregister(this);
  }
  getInstanceId() {
    return this.instanceId;
  }
  setState() {
    const {
      colDef,
      beans: { sortSvc, pinnedCols, colFlex }
    } = this;
    sortSvc?.initCol(this);
    const hide = colDef.hide;
    if (hide !== void 0) {
      this.visible = !hide;
    } else {
      this.visible = !colDef.initialHide;
    }
    pinnedCols?.initCol(this);
    colFlex?.initCol(this);
  }
  // gets called when user provides an alternative colDef, eg
  setColDef(colDef, userProvidedColDef, source) {
    const colSpanChanged = colDef.spanRows !== this.colDef.spanRows;
    this.colDef = colDef;
    this.userProvidedColDef = userProvidedColDef;
    this.initMinAndMaxWidths();
    this.initDotNotation();
    this.initTooltip();
    if (colSpanChanged) {
      this.beans.rowSpanSvc?.deregister(this);
      this.initRowSpan();
    }
    this.dispatchColEvent("colDefChanged", source);
  }
  getUserProvidedColDef() {
    return this.userProvidedColDef;
  }
  getParent() {
    return this.parent;
  }
  getOriginalParent() {
    return this.originalParent;
  }
  // this is done after constructor as it uses gridOptionsService
  postConstruct() {
    this.setState();
    this.initMinAndMaxWidths();
    this.resetActualWidth("gridInitializing");
    this.initDotNotation();
    this.initTooltip();
    this.initRowSpan();
    this.addPivotListener();
  }
  initDotNotation() {
    const {
      gos,
      colDef: { field, tooltipField }
    } = this;
    const suppressDotNotation = gos.get("suppressFieldDotNotation");
    this.fieldContainsDots = _exists(field) && field.indexOf(".") >= 0 && !suppressDotNotation;
    this.tooltipFieldContainsDots = _exists(tooltipField) && tooltipField.indexOf(".") >= 0 && !suppressDotNotation;
  }
  initMinAndMaxWidths() {
    const colDef = this.colDef;
    this.minWidth = colDef.minWidth ?? this.beans.environment.getDefaultColumnMinWidth();
    this.maxWidth = colDef.maxWidth ?? Number.MAX_SAFE_INTEGER;
  }
  initTooltip() {
    this.beans.tooltipSvc?.initCol(this);
  }
  initRowSpan() {
    if (this.colDef.spanRows) {
      this.beans.rowSpanSvc?.register(this);
    }
  }
  addPivotListener() {
    const pivotColDefSvc = this.beans.pivotColDefSvc;
    const pivotValueColumn = this.colDef.pivotValueColumn;
    if (!pivotColDefSvc || !pivotValueColumn) {
      return;
    }
    this.addManagedListeners(pivotValueColumn, {
      colDefChanged: (evt) => {
        const colDef = pivotColDefSvc.recreateColDef(this.colDef);
        this.setColDef(colDef, colDef, evt.source);
      }
    });
  }
  resetActualWidth(source) {
    const initialWidth = this.calculateColInitialWidth(this.colDef);
    this.setActualWidth(initialWidth, source, true);
  }
  calculateColInitialWidth(colDef) {
    let width;
    const colDefWidth = colDef.width;
    const colDefInitialWidth = colDef.initialWidth;
    if (colDefWidth != null) {
      width = colDefWidth;
    } else if (colDefInitialWidth != null) {
      width = colDefInitialWidth;
    } else {
      width = 200;
    }
    return Math.max(Math.min(width, this.maxWidth), this.minWidth);
  }
  isEmptyGroup() {
    return false;
  }
  isRowGroupDisplayed(colId) {
    return this.beans.showRowGroupCols?.isRowGroupDisplayed(this, colId) ?? false;
  }
  isPrimary() {
    return this.primary;
  }
  isFilterAllowed() {
    const filterDefined = !!this.colDef.filter;
    return filterDefined;
  }
  isFieldContainsDots() {
    return this.fieldContainsDots;
  }
  isTooltipEnabled() {
    return this.tooltipEnabled;
  }
  isTooltipFieldContainsDots() {
    return this.tooltipFieldContainsDots;
  }
  getHighlighted() {
    return this.highlighted;
  }
  __addEventListener(eventType, listener) {
    this.colEventSvc.addEventListener(eventType, listener);
  }
  __removeEventListener(eventType, listener) {
    this.colEventSvc.removeEventListener(eventType, listener);
  }
  /**
   * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
   */
  addEventListener(eventType, userListener) {
    this.frameworkEventListenerService = this.beans.frameworkOverrides.createLocalEventListenerWrapper?.(
      this.frameworkEventListenerService,
      this.colEventSvc
    );
    const listener = this.frameworkEventListenerService?.wrap(eventType, userListener) ?? userListener;
    this.colEventSvc.addEventListener(eventType, listener);
  }
  /**
   * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
   */
  removeEventListener(eventType, userListener) {
    const listener = this.frameworkEventListenerService?.unwrap(eventType, userListener) ?? userListener;
    this.colEventSvc.removeEventListener(eventType, listener);
  }
  createColumnFunctionCallbackParams(rowNode) {
    return _addGridCommonParams(this.gos, {
      node: rowNode,
      data: rowNode.data,
      column: this,
      colDef: this.colDef
    });
  }
  isSuppressNavigable(rowNode) {
    return this.beans.cellNavigation?.isSuppressNavigable(this, rowNode) ?? false;
  }
  isCellEditable(rowNode) {
    return this.beans.editSvc?.isCellEditable({ rowNode, column: this }) ?? false;
  }
  isSuppressFillHandle() {
    return !!this.colDef.suppressFillHandle;
  }
  isAutoHeight() {
    return !!this.colDef.autoHeight;
  }
  isAutoHeaderHeight() {
    return !!this.colDef.autoHeaderHeight;
  }
  isRowDrag(rowNode) {
    return this.isColumnFunc(rowNode, this.colDef.rowDrag);
  }
  isDndSource(rowNode) {
    return this.isColumnFunc(rowNode, this.colDef.dndSource);
  }
  isCellCheckboxSelection(rowNode) {
    return this.beans.selectionSvc?.isCellCheckboxSelection(this, rowNode) ?? false;
  }
  isSuppressPaste(rowNode) {
    return this.isColumnFunc(rowNode, this.colDef?.suppressPaste ?? null);
  }
  isResizable() {
    return !!this.getColDefValue("resizable");
  }
  /** Get value from ColDef or default if it exists. */
  getColDefValue(key) {
    return this.colDef[key] ?? COL_DEF_DEFAULTS[key];
  }
  isColumnFunc(rowNode, value) {
    if (typeof value === "boolean") {
      return value;
    }
    if (typeof value === "function") {
      const params = this.createColumnFunctionCallbackParams(rowNode);
      const editableFunc = value;
      return editableFunc(params);
    }
    return false;
  }
  createColumnEvent(type, source) {
    return _addGridCommonParams(this.gos, {
      type,
      column: this,
      columns: [this],
      source
    });
  }
  isMoving() {
    return this.moving;
  }
  getSort() {
    return this.sort;
  }
  isSortable() {
    return !!this.getColDefValue("sortable");
  }
  /** @deprecated v32 use col.getSort() === 'asc */
  isSortAscending() {
    return this.sort === "asc";
  }
  /** @deprecated v32 use col.getSort() === 'desc */
  isSortDescending() {
    return this.sort === "desc";
  }
  /** @deprecated v32 use col.getSort() === undefined */
  isSortNone() {
    return _missing(this.sort);
  }
  /** @deprecated v32 use col.getSort() !== undefined */
  isSorting() {
    return _exists(this.sort);
  }
  getSortIndex() {
    return this.sortIndex;
  }
  isMenuVisible() {
    return this.menuVisible;
  }
  getAggFunc() {
    return this.aggFunc;
  }
  getLeft() {
    return this.left;
  }
  getOldLeft() {
    return this.oldLeft;
  }
  getRight() {
    return this.left + this.actualWidth;
  }
  setLeft(left, source) {
    this.oldLeft = this.left;
    if (this.left !== left) {
      this.left = left;
      this.dispatchColEvent("leftChanged", source);
    }
  }
  isFilterActive() {
    return this.filterActive;
  }
  /** @deprecated v33 Use `api.isColumnHovered(column)` instead. */
  isHovered() {
    _warn(261);
    return !!this.beans.colHover?.isHovered(this);
  }
  setFirstRightPinned(firstRightPinned, source) {
    if (this.firstRightPinned !== firstRightPinned) {
      this.firstRightPinned = firstRightPinned;
      this.dispatchColEvent("firstRightPinnedChanged", source);
    }
  }
  setLastLeftPinned(lastLeftPinned, source) {
    if (this.lastLeftPinned !== lastLeftPinned) {
      this.lastLeftPinned = lastLeftPinned;
      this.dispatchColEvent("lastLeftPinnedChanged", source);
    }
  }
  isFirstRightPinned() {
    return this.firstRightPinned;
  }
  isLastLeftPinned() {
    return this.lastLeftPinned;
  }
  isPinned() {
    return this.pinned === "left" || this.pinned === "right";
  }
  isPinnedLeft() {
    return this.pinned === "left";
  }
  isPinnedRight() {
    return this.pinned === "right";
  }
  getPinned() {
    return this.pinned;
  }
  setVisible(visible, source) {
    const newValue = visible === true;
    if (this.visible !== newValue) {
      this.visible = newValue;
      this.dispatchColEvent("visibleChanged", source);
    }
    this.dispatchStateUpdatedEvent("hide");
  }
  isVisible() {
    return this.visible;
  }
  isSpanHeaderHeight() {
    const colDef = this.getColDef();
    return !colDef.suppressSpanHeaderHeight;
  }
  /**
   * Returns the first parent that is not a padding group.
   */
  getFirstRealParent() {
    let parent = this.getOriginalParent();
    while (parent && parent.isPadding()) {
      parent = parent.getOriginalParent();
    }
    return parent;
  }
  getColumnGroupPaddingInfo() {
    let parent = this.getParent();
    if (!parent || !parent.isPadding()) {
      return { numberOfParents: 0, isSpanningTotal: false };
    }
    const numberOfParents = parent.getPaddingLevel() + 1;
    let isSpanningTotal = true;
    while (parent) {
      if (!parent.isPadding()) {
        isSpanningTotal = false;
        break;
      }
      parent = parent.getParent();
    }
    return { numberOfParents, isSpanningTotal };
  }
  getColDef() {
    return this.colDef;
  }
  getDefinition() {
    return this.colDef;
  }
  getColumnGroupShow() {
    return this.colDef.columnGroupShow;
  }
  getColId() {
    return this.colId;
  }
  getId() {
    return this.colId;
  }
  getUniqueId() {
    return this.colId;
  }
  getActualWidth() {
    return this.actualWidth;
  }
  getAutoHeaderHeight() {
    return this.autoHeaderHeight;
  }
  /** Returns true if the header height has changed */
  setAutoHeaderHeight(height) {
    const changed = height !== this.autoHeaderHeight;
    this.autoHeaderHeight = height;
    return changed;
  }
  createBaseColDefParams(rowNode) {
    const params = _addGridCommonParams(this.gos, {
      node: rowNode,
      data: rowNode.data,
      colDef: this.colDef,
      column: this
    });
    return params;
  }
  getColSpan(rowNode) {
    if (_missing(this.colDef.colSpan)) {
      return 1;
    }
    const params = this.createBaseColDefParams(rowNode);
    const colSpan = this.colDef.colSpan(params);
    return Math.max(colSpan, 1);
  }
  getRowSpan(rowNode) {
    if (_missing(this.colDef.rowSpan)) {
      return 1;
    }
    const params = this.createBaseColDefParams(rowNode);
    const rowSpan = this.colDef.rowSpan(params);
    return Math.max(rowSpan, 1);
  }
  setActualWidth(actualWidth, source, silent = false) {
    actualWidth = Math.max(actualWidth, this.minWidth);
    actualWidth = Math.min(actualWidth, this.maxWidth);
    if (this.actualWidth !== actualWidth) {
      this.actualWidth = actualWidth;
      if (this.flex != null && source !== "flex" && source !== "gridInitializing") {
        this.flex = null;
      }
      if (!silent) {
        this.fireColumnWidthChangedEvent(source);
      }
    }
    this.dispatchStateUpdatedEvent("width");
  }
  fireColumnWidthChangedEvent(source) {
    this.dispatchColEvent("widthChanged", source);
  }
  isGreaterThanMax(width) {
    return width > this.maxWidth;
  }
  getMinWidth() {
    return this.minWidth;
  }
  getMaxWidth() {
    return this.maxWidth;
  }
  getFlex() {
    return this.flex;
  }
  isRowGroupActive() {
    return this.rowGroupActive;
  }
  isPivotActive() {
    return this.pivotActive;
  }
  isAnyFunctionActive() {
    return this.isPivotActive() || this.isRowGroupActive() || this.isValueActive();
  }
  isAnyFunctionAllowed() {
    return this.isAllowPivot() || this.isAllowRowGroup() || this.isAllowValue();
  }
  isValueActive() {
    return this.aggregationActive;
  }
  isAllowPivot() {
    return this.colDef.enablePivot === true;
  }
  isAllowValue() {
    return this.colDef.enableValue === true;
  }
  isAllowRowGroup() {
    return this.colDef.enableRowGroup === true;
  }
  dispatchColEvent(type, source, additionalEventAttributes) {
    const colEvent = this.createColumnEvent(type, source);
    if (additionalEventAttributes) {
      _mergeDeep(colEvent, additionalEventAttributes);
    }
    this.colEventSvc.dispatchEvent(colEvent);
  }
  dispatchStateUpdatedEvent(key) {
    this.colEventSvc.dispatchEvent({
      type: "columnStateUpdated",
      key
    });
  }
};

// packages/ag-grid-community/src/entities/agProvidedColumnGroup.ts
function isProvidedColumnGroup(col) {
  return col instanceof AgProvidedColumnGroup;
}
var AgProvidedColumnGroup = class extends BeanStub {
  constructor(colGroupDef, groupId, padding, level) {
    super();
    this.colGroupDef = colGroupDef;
    this.groupId = groupId;
    this.padding = padding;
    this.level = level;
    this.isColumn = false;
    this.expandable = false;
    // used by React (and possibly other frameworks) as key for rendering. also used to
    // identify old vs new columns for destroying cols when no longer used.
    this.instanceId = getNextColInstanceId();
    this.expandableListenerRemoveCallback = null;
    this.expanded = !!colGroupDef?.openByDefault;
  }
  destroy() {
    if (this.expandableListenerRemoveCallback) {
      this.reset(null, void 0);
    }
    super.destroy();
  }
  reset(colGroupDef, level) {
    this.colGroupDef = colGroupDef;
    this.level = level;
    this.originalParent = null;
    if (this.expandableListenerRemoveCallback) {
      this.expandableListenerRemoveCallback();
    }
    this.children = void 0;
    this.expandable = void 0;
  }
  getInstanceId() {
    return this.instanceId;
  }
  getOriginalParent() {
    return this.originalParent;
  }
  getLevel() {
    return this.level;
  }
  isVisible() {
    if (this.children) {
      return this.children.some((child) => child.isVisible());
    }
    return false;
  }
  isPadding() {
    return this.padding;
  }
  setExpanded(expanded) {
    this.expanded = expanded === void 0 ? false : expanded;
    this.dispatchLocalEvent({ type: "expandedChanged" });
  }
  isExpandable() {
    return this.expandable;
  }
  isExpanded() {
    return this.expanded;
  }
  getGroupId() {
    return this.groupId;
  }
  getId() {
    return this.getGroupId();
  }
  setChildren(children) {
    this.children = children;
  }
  getChildren() {
    return this.children;
  }
  getColGroupDef() {
    return this.colGroupDef;
  }
  getLeafColumns() {
    const result = [];
    this.addLeafColumns(result);
    return result;
  }
  forEachLeafColumn(callback) {
    if (!this.children) {
      return;
    }
    for (const child of this.children) {
      if (isColumn(child)) {
        callback(child);
      } else if (isProvidedColumnGroup(child)) {
        child.forEachLeafColumn(callback);
      }
    }
  }
  addLeafColumns(leafColumns) {
    if (!this.children) {
      return;
    }
    this.children.forEach((child) => {
      if (isColumn(child)) {
        leafColumns.push(child);
      } else if (isProvidedColumnGroup(child)) {
        child.addLeafColumns(leafColumns);
      }
    });
  }
  getColumnGroupShow() {
    const colGroupDef = this.colGroupDef;
    if (!colGroupDef) {
      return;
    }
    return colGroupDef.columnGroupShow;
  }
  // need to check that this group has at least one col showing when both expanded and contracted.
  // if not, then we don't allow expanding and contracting on this group
  setupExpandable() {
    this.setExpandable();
    if (this.expandableListenerRemoveCallback) {
      this.expandableListenerRemoveCallback();
    }
    const listener = this.onColumnVisibilityChanged.bind(this);
    this.getLeafColumns().forEach((col) => col.__addEventListener("visibleChanged", listener));
    this.expandableListenerRemoveCallback = () => {
      this.getLeafColumns().forEach((col) => col.__removeEventListener("visibleChanged", listener));
      this.expandableListenerRemoveCallback = null;
    };
  }
  setExpandable() {
    if (this.isPadding()) {
      return;
    }
    let atLeastOneShowingWhenOpen = false;
    let atLeastOneShowingWhenClosed = false;
    let atLeastOneChangeable = false;
    const children = this.findChildrenRemovingPadding();
    for (let i = 0, j = children.length; i < j; i++) {
      const abstractColumn = children[i];
      if (!abstractColumn.isVisible()) {
        continue;
      }
      const headerGroupShow = abstractColumn.getColumnGroupShow();
      if (headerGroupShow === "open") {
        atLeastOneShowingWhenOpen = true;
        atLeastOneChangeable = true;
      } else if (headerGroupShow === "closed") {
        atLeastOneShowingWhenClosed = true;
        atLeastOneChangeable = true;
      } else {
        atLeastOneShowingWhenOpen = true;
        atLeastOneShowingWhenClosed = true;
      }
    }
    const expandable = atLeastOneShowingWhenOpen && atLeastOneShowingWhenClosed && atLeastOneChangeable;
    if (this.expandable !== expandable) {
      this.expandable = expandable;
      this.dispatchLocalEvent({ type: "expandableChanged" });
    }
  }
  findChildrenRemovingPadding() {
    const res = [];
    const process = (items) => {
      items.forEach((item) => {
        const skipBecausePadding = isProvidedColumnGroup(item) && item.isPadding();
        if (skipBecausePadding) {
          process(item.children);
        } else {
          res.push(item);
        }
      });
    };
    process(this.children);
    return res;
  }
  onColumnVisibilityChanged() {
    this.setExpandable();
  }
};

// packages/ag-grid-community/src/entities/defaultColumnTypes.ts
var DefaultColumnTypes = {
  numericColumn: {
    headerClass: "ag-right-aligned-header",
    cellClass: "ag-right-aligned-cell"
  },
  rightAligned: {
    headerClass: "ag-right-aligned-header",
    cellClass: "ag-right-aligned-cell"
  }
};

// packages/ag-grid-community/src/columns/columnGroups/columnGroupUtils.ts
function createMergedColGroupDef(beans, colGroupDef, groupId) {
  const colGroupDefMerged = {};
  const gos = beans.gos;
  Object.assign(colGroupDefMerged, gos.get("defaultColGroupDef"));
  Object.assign(colGroupDefMerged, colGroupDef);
  gos.validateColDef(colGroupDefMerged, groupId);
  return colGroupDefMerged;
}

// packages/ag-grid-community/src/columns/columnKeyCreator.ts
var ColumnKeyCreator = class {
  constructor() {
    this.existingKeys = {};
  }
  addExistingKeys(keys) {
    for (let i = 0; i < keys.length; i++) {
      this.existingKeys[keys[i]] = true;
    }
  }
  getUniqueKey(colId, colField) {
    colId = _toStringOrNull(colId);
    let count = 0;
    while (true) {
      let idToTry = colId ?? colField;
      if (idToTry) {
        if (count !== 0) {
          idToTry += "_" + count;
        }
      } else {
        idToTry = count;
      }
      if (!this.existingKeys[idToTry]) {
        const usedId = String(idToTry);
        if (colId && count > 0) {
          _warn(273, { providedId: colId, usedId });
        }
        this.existingKeys[usedId] = true;
        return usedId;
      }
      count++;
    }
  }
};

// packages/ag-grid-community/src/utils/array.ts
var _EmptyArray = Object.freeze([]);
function _last(arr) {
  if (!arr?.length) {
    return;
  }
  return arr[arr.length - 1];
}
function _areEqual(a, b, comparator) {
  if (a == null && b == null) {
    return true;
  }
  return a != null && b != null && a.length === b.length && a.every((value, index) => comparator ? comparator(value, b[index]) : b[index] === value);
}
function _forAll(array, callback) {
  if (!array) {
    return;
  }
  for (const value of array) {
    callback(value);
  }
}
function _removeFromArray(array, object) {
  const index = array.indexOf(object);
  if (index >= 0) {
    array.splice(index, 1);
  }
}
function _moveInArray(array, objectsToMove, toIndex) {
  for (let i = 0; i < objectsToMove.length; i++) {
    _removeFromArray(array, objectsToMove[i]);
  }
  for (let i = objectsToMove.length - 1; i >= 0; i--) {
    array.splice(toIndex, 0, objectsToMove[i]);
  }
}
function _flatten(arrays) {
  return [].concat.apply([], arrays);
}

// packages/ag-grid-community/src/columns/columnUtils.ts
var GROUP_AUTO_COLUMN_ID = "ag-Grid-AutoColumn";
var SELECTION_COLUMN_ID = "ag-Grid-SelectionColumn";
var ROW_NUMBERS_COLUMN_ID = "ag-Grid-RowNumbersColumn";
function _getColumnsFromTree(rootColumns) {
  const result = [];
  const recursiveFindColumns = (childColumns) => {
    for (let i = 0; i < childColumns.length; i++) {
      const child = childColumns[i];
      if (isColumn(child)) {
        result.push(child);
      } else if (isProvidedColumnGroup(child)) {
        recursiveFindColumns(child.getChildren());
      }
    }
  };
  recursiveFindColumns(rootColumns);
  return result;
}
function getWidthOfColsInList(columnList) {
  return columnList.reduce((width, col) => width + col.getActualWidth(), 0);
}
function _destroyColumnTree(beans, oldTree, newTree) {
  const oldObjectsById = {};
  if (!oldTree) {
    return;
  }
  depthFirstOriginalTreeSearch(null, oldTree, (child) => {
    oldObjectsById[child.getInstanceId()] = child;
  });
  if (newTree) {
    depthFirstOriginalTreeSearch(null, newTree, (child) => {
      oldObjectsById[child.getInstanceId()] = null;
    });
  }
  const colsToDestroy = Object.values(oldObjectsById).filter((item) => item != null);
  beans.context.destroyBeans(colsToDestroy);
}
function isColumnGroupAutoCol(col) {
  const colId = col.getId();
  return colId.startsWith(GROUP_AUTO_COLUMN_ID);
}
function isColumnSelectionCol(col) {
  const id = typeof col === "string" ? col : "getColId" in col ? col.getColId() : col.colId;
  return id?.startsWith(SELECTION_COLUMN_ID) ?? false;
}
function isRowNumberCol(col) {
  const id = typeof col === "string" ? col : "getColId" in col ? col.getColId() : col.colId;
  return id?.startsWith(ROW_NUMBERS_COLUMN_ID) ?? false;
}
function isSpecialCol(col) {
  return isColumnSelectionCol(col) || isRowNumberCol(col);
}
function convertColumnTypes(type) {
  let typeKeys = [];
  if (type instanceof Array) {
    typeKeys = type;
  } else if (typeof type === "string") {
    typeKeys = type.split(",");
  }
  return typeKeys;
}
function _areColIdsEqual(colsA, colsB) {
  return _areEqual(colsA, colsB, (a, b) => a.getColId() === b.getColId());
}
function _updateColsMap(cols) {
  cols.map = {};
  cols.list.forEach((col) => cols.map[col.getId()] = col);
}
function _convertColumnEventSourceType(source) {
  return source === "gridOptionsUpdated" ? "gridOptionsChanged" : source;
}
function _columnsMatch(column, key) {
  const columnMatches = column === key;
  const colDefMatches = column.getColDef() === key;
  const idMatches = column.getColId() == key;
  return columnMatches || colDefMatches || idMatches;
}
var getValueFactory = (stateItem, defaultState) => (key1, key2) => {
  const obj = {
    value1: void 0,
    value2: void 0
  };
  let calculated = false;
  if (stateItem) {
    if (stateItem[key1] !== void 0) {
      obj.value1 = stateItem[key1];
      calculated = true;
    }
    if (_exists(key2) && stateItem[key2] !== void 0) {
      obj.value2 = stateItem[key2];
      calculated = true;
    }
  }
  if (!calculated && defaultState) {
    if (defaultState[key1] !== void 0) {
      obj.value1 = defaultState[key1];
    }
    if (_exists(key2) && defaultState[key2] !== void 0) {
      obj.value2 = defaultState[key2];
    }
  }
  return obj;
};

// packages/ag-grid-community/src/columns/columnFactoryUtils.ts
function _createColumnTreeWithIds(beans, defs = null, primaryColumns, existingTree, source) {
  const { existingCols, existingGroups } = extractExistingTreeData(existingTree);
  const colIdMap = new Map(existingCols.map((col) => [col.getId(), col]));
  const colGroupIdMap = new Map(existingGroups.map((group) => [group.getId(), group]));
  let maxDepth = 0;
  const recursivelyProcessColDef = (def, level) => {
    maxDepth = Math.max(maxDepth, level);
    if (isColumnGroupDef(def)) {
      if (!beans.colGroupSvc) {
        return null;
      }
      const groupId = def.groupId;
      const group = colGroupIdMap.get(groupId);
      const colGroupDef = createMergedColGroupDef(beans, def, groupId);
      const newGroup = new AgProvidedColumnGroup(colGroupDef, groupId, false, level);
      beans.context.createBean(newGroup);
      if (group) {
        newGroup.setExpanded(group.isExpanded());
      }
      newGroup.setChildren(def.children.map((child) => recursivelyProcessColDef(child, level + 1)));
      return newGroup;
    }
    const colId = def.colId;
    let column = colIdMap.get(colId);
    const colDefMerged = _addColumnDefaultAndTypes(beans, def, column?.getColId() ?? colId);
    if (!column) {
      column = new AgColumn(colDefMerged, def, colId, primaryColumns);
      beans.context.createBean(column);
    } else {
      column.setColDef(colDefMerged, def, source);
      _updateColumnState(beans, column, colDefMerged, source);
    }
    beans.dataTypeSvc?.addColumnListeners(column);
    return column;
  };
  const root = defs?.map((def) => recursivelyProcessColDef(def, 0)) ?? [];
  let counter = 0;
  const keyCreator = {
    getUniqueKey: (_colId, _field) => String(++counter)
  };
  const columnTree = beans.colGroupSvc ? beans.colGroupSvc.balanceColumnTree(root, 0, maxDepth, keyCreator) : root;
  const depthFirstCallback = (child, parent) => {
    if (isProvidedColumnGroup(child)) {
      child.setupExpandable();
    }
    child.originalParent = parent;
  };
  depthFirstOriginalTreeSearch(null, columnTree, depthFirstCallback);
  return {
    columnTree,
    treeDepth: maxDepth
  };
}
function _createColumnTree(beans, defs = null, primaryColumns, existingTree, source) {
  const columnKeyCreator = new ColumnKeyCreator();
  const { existingCols, existingGroups, existingColKeys } = extractExistingTreeData(existingTree);
  columnKeyCreator.addExistingKeys(existingColKeys);
  const unbalancedTree = _recursivelyCreateColumns(
    beans,
    defs,
    0,
    primaryColumns,
    existingCols,
    columnKeyCreator,
    existingGroups,
    source
  );
  const { colGroupSvc } = beans;
  const treeDepth = colGroupSvc?.findMaxDepth(unbalancedTree, 0) ?? 0;
  const columnTree = colGroupSvc ? colGroupSvc.balanceColumnTree(unbalancedTree, 0, treeDepth, columnKeyCreator) : unbalancedTree;
  const depthFirstCallback = (child, parent) => {
    if (isProvidedColumnGroup(child)) {
      child.setupExpandable();
    }
    child.originalParent = parent;
  };
  depthFirstOriginalTreeSearch(null, columnTree, depthFirstCallback);
  return {
    columnTree,
    treeDepth
  };
}
function extractExistingTreeData(existingTree) {
  const existingCols = [];
  const existingGroups = [];
  const existingColKeys = [];
  if (existingTree) {
    depthFirstOriginalTreeSearch(null, existingTree, (item) => {
      if (isProvidedColumnGroup(item)) {
        const group = item;
        existingGroups.push(group);
      } else {
        const col = item;
        existingColKeys.push(col.getId());
        existingCols.push(col);
      }
    });
  }
  return { existingCols, existingGroups, existingColKeys };
}
function _recursivelyCreateColumns(beans, defs, level, primaryColumns, existingColsCopy, columnKeyCreator, existingGroups, source) {
  if (!defs)
    return [];
  const { colGroupSvc } = beans;
  const result = new Array(defs.length);
  for (let i = 0; i < result.length; i++) {
    const def = defs[i];
    if (colGroupSvc && isColumnGroupDef(def)) {
      result[i] = colGroupSvc.createProvidedColumnGroup(
        primaryColumns,
        def,
        level,
        existingColsCopy,
        columnKeyCreator,
        existingGroups,
        source
      );
    } else {
      result[i] = createColumn(beans, primaryColumns, def, existingColsCopy, columnKeyCreator, source);
    }
  }
  return result;
}
function createColumn(beans, primaryColumns, colDef, existingColsCopy, columnKeyCreator, source) {
  const existingColAndIndex = findExistingColumn(colDef, existingColsCopy);
  if (existingColAndIndex) {
    existingColsCopy?.splice(existingColAndIndex.idx, 1);
  }
  let column = existingColAndIndex?.column;
  if (!column) {
    const colId = columnKeyCreator.getUniqueKey(colDef.colId, colDef.field);
    const colDefMerged = _addColumnDefaultAndTypes(beans, colDef, colId);
    column = new AgColumn(colDefMerged, colDef, colId, primaryColumns);
    beans.context.createBean(column);
  } else {
    const colDefMerged = _addColumnDefaultAndTypes(beans, colDef, column.getColId());
    column.setColDef(colDefMerged, colDef, source);
    _updateColumnState(beans, column, colDefMerged, source);
  }
  beans.dataTypeSvc?.addColumnListeners(column);
  return column;
}
function updateSomeColumnState(beans, column, hide, sort, sortIndex, pinned, flex, source) {
  const { sortSvc, pinnedCols, colFlex } = beans;
  if (hide !== void 0) {
    column.setVisible(!hide, source);
  }
  if (sortSvc) {
    sortSvc.updateColSort(column, sort, source);
    if (sortIndex !== void 0) {
      sortSvc.setColSortIndex(column, sortIndex);
    }
  }
  if (pinned !== void 0) {
    pinnedCols?.setColPinned(column, pinned);
  }
  if (flex !== void 0) {
    colFlex?.setColFlex(column, flex);
  }
}
function _updateColumnState(beans, column, colDef, source) {
  updateSomeColumnState(
    beans,
    column,
    colDef.hide,
    colDef.sort,
    colDef.sortIndex,
    colDef.pinned,
    colDef.flex,
    source
  );
  const colFlex = column.getFlex();
  if (colFlex != null && colFlex > 0) {
    return;
  }
  if (colDef.width != null) {
    column.setActualWidth(colDef.width, source);
  } else {
    const widthBeforeUpdate = column.getActualWidth();
    column.setActualWidth(widthBeforeUpdate, source);
  }
}
function findExistingColumn(newColDef, existingColsCopy) {
  if (!existingColsCopy)
    return void 0;
  for (let i = 0; i < existingColsCopy.length; i++) {
    const def = existingColsCopy[i].getUserProvidedColDef();
    if (!def)
      continue;
    const newHasId = newColDef.colId != null;
    if (newHasId) {
      if (existingColsCopy[i].getId() === newColDef.colId) {
        return { idx: i, column: existingColsCopy[i] };
      }
      continue;
    }
    const newHasField = newColDef.field != null;
    if (newHasField) {
      if (def.field === newColDef.field) {
        return { idx: i, column: existingColsCopy[i] };
      }
      continue;
    }
    if (def === newColDef) {
      return { idx: i, column: existingColsCopy[i] };
    }
  }
  return void 0;
}
function _addColumnDefaultAndTypes(beans, colDef, colId, isAutoCol) {
  const { gos, dataTypeSvc } = beans;
  const res = {};
  const defaultColDef = gos.get("defaultColDef");
  _mergeDeep(res, defaultColDef, false, true);
  const columnType = updateColDefAndGetColumnType(beans, res, colDef, colId);
  if (columnType) {
    assignColumnTypes(beans, columnType, res);
  }
  const cellDataType = res.cellDataType;
  _mergeDeep(res, colDef, false, true);
  if (cellDataType !== void 0) {
    res.cellDataType = cellDataType;
  }
  const autoGroupColDef = gos.get("autoGroupColumnDef");
  const isSortingCoupled = _isColumnsSortingCoupledToGroup(gos);
  if (colDef.rowGroup && autoGroupColDef && isSortingCoupled) {
    _mergeDeep(
      res,
      { sort: autoGroupColDef.sort, initialSort: autoGroupColDef.initialSort },
      false,
      true
    );
  }
  if (dataTypeSvc) {
    dataTypeSvc.postProcess(res);
    dataTypeSvc.validateColDef(res);
  }
  gos.validateColDef(res, colId, isAutoCol);
  return res;
}
function updateColDefAndGetColumnType(beans, colDef, userColDef, colId) {
  const dataTypeDefinitionColumnType = beans.dataTypeSvc?.updateColDefAndGetColumnType(colDef, userColDef, colId);
  const columnTypes = userColDef.type ?? dataTypeDefinitionColumnType ?? colDef.type;
  colDef.type = columnTypes;
  return columnTypes ? convertColumnTypes(columnTypes) : void 0;
}
function assignColumnTypes(beans, typeKeys, colDefMerged) {
  if (!typeKeys.length) {
    return;
  }
  const allColumnTypes = Object.assign({}, DefaultColumnTypes);
  const userTypes = beans.gos.get("columnTypes") || {};
  for (const key of Object.keys(userTypes)) {
    const value = userTypes[key];
    if (key in allColumnTypes) {
      _warn(34, { key });
    } else {
      const colType = value;
      if (colType.type) {
        _warn(35);
      }
      allColumnTypes[key] = value;
    }
  }
  typeKeys.forEach((t) => {
    const typeColDef = allColumnTypes[t.trim()];
    if (typeColDef) {
      _mergeDeep(colDefMerged, typeColDef, false, true);
    } else {
      _warn(36, { t });
    }
  });
}
function isColumnGroupDef(abstractColDef) {
  return abstractColDef.children !== void 0;
}
function depthFirstOriginalTreeSearch(parent, tree, callback) {
  if (!tree) {
    return;
  }
  for (let i = 0; i < tree.length; i++) {
    const child = tree[i];
    if (isProvidedColumnGroup(child)) {
      depthFirstOriginalTreeSearch(child, child.getChildren(), callback);
    }
    callback(child, parent);
  }
}

// packages/ag-grid-community/src/columnMove/columnMoveUtils.ts
function placeLockedColumns(cols, gos) {
  const left = [];
  const normal = [];
  const right = [];
  cols.forEach((col) => {
    const position = col.getColDef().lockPosition;
    if (position === "right") {
      right.push(col);
    } else if (position === "left" || position === true) {
      left.push(col);
    } else {
      normal.push(col);
    }
  });
  const isRtl = gos.get("enableRtl");
  if (isRtl) {
    return [...right, ...normal, ...left];
  }
  return [...left, ...normal, ...right];
}
function doesMovePassMarryChildren(allColumnsCopy, gridBalancedTree) {
  let rulePassed = true;
  depthFirstOriginalTreeSearch(null, gridBalancedTree, (child) => {
    if (!isProvidedColumnGroup(child)) {
      return;
    }
    const columnGroup = child;
    const colGroupDef = columnGroup.getColGroupDef();
    const marryChildren = colGroupDef && colGroupDef.marryChildren;
    if (!marryChildren) {
      return;
    }
    const newIndexes = [];
    columnGroup.getLeafColumns().forEach((col) => {
      const newColIndex = allColumnsCopy.indexOf(col);
      newIndexes.push(newColIndex);
    });
    const maxIndex = Math.max.apply(Math, newIndexes);
    const minIndex = Math.min.apply(Math, newIndexes);
    const spread = maxIndex - minIndex;
    const maxSpread = columnGroup.getLeafColumns().length - 1;
    if (spread > maxSpread) {
      rulePassed = false;
    }
  });
  return rulePassed;
}

// packages/ag-grid-community/src/columns/columnEventUtils.ts
function getCommonValue(cols, valueGetter) {
  if (!cols || cols.length == 0) {
    return void 0;
  }
  const firstValue = valueGetter(cols[0]);
  for (let i = 1; i < cols.length; i++) {
    if (firstValue !== valueGetter(cols[i])) {
      return void 0;
    }
  }
  return firstValue;
}
function dispatchColumnPinnedEvent(eventSvc, changedColumns, source) {
  if (!changedColumns.length) {
    return;
  }
  const column = changedColumns.length === 1 ? changedColumns[0] : null;
  const pinned = getCommonValue(changedColumns, (col) => col.getPinned());
  eventSvc.dispatchEvent({
    type: "columnPinned",
    // mistake in typing, 'undefined' should be allowed, as 'null' means 'not pinned'
    pinned: pinned != null ? pinned : null,
    columns: changedColumns,
    column,
    source
  });
}
function dispatchColumnVisibleEvent(eventSvc, changedColumns, source) {
  if (!changedColumns.length) {
    return;
  }
  const column = changedColumns.length === 1 ? changedColumns[0] : null;
  const visible = getCommonValue(changedColumns, (col) => col.isVisible());
  eventSvc.dispatchEvent({
    type: "columnVisible",
    visible,
    columns: changedColumns,
    column,
    source
  });
}
function dispatchColumnChangedEvent(eventSvc, type, columns, source) {
  eventSvc.dispatchEvent({
    type,
    columns,
    column: columns && columns.length == 1 ? columns[0] : null,
    source
  });
}
function dispatchColumnResizedEvent(eventSvc, columns, finished, source, flexColumns = null) {
  if (columns?.length) {
    eventSvc.dispatchEvent({
      type: "columnResized",
      columns,
      column: columns.length === 1 ? columns[0] : null,
      flexColumns,
      finished,
      source
    });
  }
}

// packages/ag-grid-community/src/columns/columnStateUtils.ts
function _applyColumnState(beans, params, source) {
  const {
    colModel,
    rowGroupColsSvc,
    pivotColsSvc,
    autoColSvc,
    selectionColSvc,
    colAnimation,
    visibleCols,
    pivotResultCols,
    environment,
    valueColsSvc,
    eventSvc,
    gos
  } = beans;
  const providedCols = colModel.getColDefCols() ?? [];
  const selectionCols = selectionColSvc?.getColumns();
  if (!providedCols?.length && !selectionCols?.length) {
    return false;
  }
  if (params?.state && !params.state.forEach) {
    _warn(32);
    return false;
  }
  const syncColumnWithStateItem = (column, stateItem, rowGroupIndexes, pivotIndexes, autoCol) => {
    if (!column) {
      return;
    }
    const getValue = getValueFactory(stateItem, params.defaultState);
    const flex = getValue("flex").value1;
    updateSomeColumnState(
      beans,
      column,
      getValue("hide").value1,
      getValue("sort").value1,
      getValue("sortIndex").value1,
      getValue("pinned").value1,
      flex,
      source
    );
    if (flex == null) {
      const width = getValue("width").value1;
      if (width != null) {
        const minColWidth = column.getColDef().minWidth ?? environment.getDefaultColumnMinWidth();
        if (minColWidth != null && width >= minColWidth) {
          column.setActualWidth(width, source);
        }
      }
    }
    if (autoCol || !column.isPrimary()) {
      return;
    }
    valueColsSvc?.syncColumnWithState(column, source, getValue);
    rowGroupColsSvc?.syncColumnWithState(column, source, getValue, rowGroupIndexes);
    pivotColsSvc?.syncColumnWithState(column, source, getValue, pivotIndexes);
  };
  const applyStates = (states, existingColumns, getById2) => {
    const dispatchEventsFunc = _compareColumnStatesAndDispatchEvents(beans, source);
    const columnsWithNoState = existingColumns.slice();
    const rowGroupIndexes = {};
    const pivotIndexes = {};
    const autoColStates = [];
    const selectionColStates = [];
    const unmatchedAndAutoStates2 = [];
    let unmatchedCount2 = 0;
    const previousRowGroupCols = rowGroupColsSvc?.columns.slice() ?? [];
    const previousPivotCols = pivotColsSvc?.columns.slice() ?? [];
    states.forEach((state) => {
      const colId = state.colId;
      const isAutoGroupColumn = colId.startsWith(GROUP_AUTO_COLUMN_ID);
      if (isAutoGroupColumn) {
        autoColStates.push(state);
        unmatchedAndAutoStates2.push(state);
        return;
      }
      if (isColumnSelectionCol(colId)) {
        selectionColStates.push(state);
        unmatchedAndAutoStates2.push(state);
        return;
      }
      const column = getById2(colId);
      if (!column) {
        unmatchedAndAutoStates2.push(state);
        unmatchedCount2 += 1;
      } else {
        syncColumnWithStateItem(column, state, rowGroupIndexes, pivotIndexes, false);
        _removeFromArray(columnsWithNoState, column);
      }
    });
    const applyDefaultsFunc = (col) => syncColumnWithStateItem(col, null, rowGroupIndexes, pivotIndexes, false);
    columnsWithNoState.forEach(applyDefaultsFunc);
    rowGroupColsSvc?.sortColumns(comparatorByIndex.bind(rowGroupColsSvc, rowGroupIndexes, previousRowGroupCols));
    pivotColsSvc?.sortColumns(comparatorByIndex.bind(pivotColsSvc, pivotIndexes, previousPivotCols));
    colModel.refreshCols(false);
    const syncColStates = (getCol, colStates, columns = []) => {
      colStates.forEach((stateItem) => {
        const col = getCol(stateItem.colId);
        _removeFromArray(columns, col);
        syncColumnWithStateItem(col, stateItem, null, null, true);
      });
      columns.forEach(applyDefaultsFunc);
    };
    syncColStates(
      (colId) => autoColSvc?.getColumn(colId) ?? null,
      autoColStates,
      autoColSvc?.getColumns()?.slice()
    );
    syncColStates(
      (colId) => selectionColSvc?.getColumn(colId) ?? null,
      selectionColStates,
      selectionColSvc?.getColumns()?.slice()
    );
    orderLiveColsLikeState(params, colModel, gos);
    visibleCols.refresh(source);
    eventSvc.dispatchEvent({
      type: "columnEverythingChanged",
      source
    });
    dispatchEventsFunc();
    return { unmatchedAndAutoStates: unmatchedAndAutoStates2, unmatchedCount: unmatchedCount2 };
  };
  colAnimation?.start();
  let { unmatchedAndAutoStates, unmatchedCount } = applyStates(
    params.state || [],
    providedCols,
    (id) => colModel.getColDefCol(id)
  );
  if (unmatchedAndAutoStates.length > 0 || _exists(params.defaultState)) {
    const pivotResultColsList = pivotResultCols?.getPivotResultCols()?.list ?? [];
    unmatchedCount = applyStates(
      unmatchedAndAutoStates,
      pivotResultColsList,
      (id) => pivotResultCols?.getPivotResultCol(id) ?? null
    ).unmatchedCount;
  }
  colAnimation?.finish();
  return unmatchedCount === 0;
}
function _resetColumnState(beans, source) {
  const { colModel, autoColSvc, selectionColSvc, eventSvc, gos } = beans;
  const primaryCols = colModel.getColDefCols();
  if (!primaryCols?.length) {
    return;
  }
  const primaryColumnTree = colModel.getColDefColTree();
  const primaryColumns = _getColumnsFromTree(primaryColumnTree);
  const columnStates = [];
  let letRowGroupIndex = 1e3;
  let letPivotIndex = 1e3;
  const addColState = (col) => {
    const stateItem = getColumnStateFromColDef(col);
    if (_missing(stateItem.rowGroupIndex) && stateItem.rowGroup) {
      stateItem.rowGroupIndex = letRowGroupIndex++;
    }
    if (_missing(stateItem.pivotIndex) && stateItem.pivot) {
      stateItem.pivotIndex = letPivotIndex++;
    }
    columnStates.push(stateItem);
  };
  autoColSvc?.getColumns()?.forEach(addColState);
  selectionColSvc?.getColumns()?.forEach(addColState);
  primaryColumns?.forEach(addColState);
  _applyColumnState(beans, { state: columnStates }, source);
  const autoCols = autoColSvc?.getColumns() ?? [];
  const selectionCols = selectionColSvc?.getColumns() ?? [];
  const orderedCols = [...selectionCols, ...autoCols, ...primaryCols];
  const orderedColState = orderedCols.map((col) => ({ colId: col.colId }));
  _applyColumnState(beans, { state: orderedColState, applyOrder: true }, source);
  eventSvc.dispatchEvent(_addGridCommonParams(gos, { type: "columnsReset", source }));
}
function _compareColumnStatesAndDispatchEvents(beans, source) {
  const { rowGroupColsSvc, pivotColsSvc, valueColsSvc, colModel, sortSvc, eventSvc } = beans;
  const startState = {
    rowGroupColumns: rowGroupColsSvc?.columns.slice() ?? [],
    pivotColumns: pivotColsSvc?.columns.slice() ?? [],
    valueColumns: valueColsSvc?.columns.slice() ?? []
  };
  const columnStateBefore = _getColumnState(beans);
  const columnStateBeforeMap = {};
  columnStateBefore.forEach((col) => {
    columnStateBeforeMap[col.colId] = col;
  });
  return () => {
    const dispatchWhenListsDifferent = (eventType, colsBefore, colsAfter, idMapper) => {
      const beforeList = colsBefore.map(idMapper);
      const afterList = colsAfter.map(idMapper);
      const unchanged = _areEqual(beforeList, afterList);
      if (unchanged) {
        return;
      }
      const changes = new Set(colsBefore);
      colsAfter.forEach((id) => {
        if (!changes.delete(id)) {
          changes.add(id);
        }
      });
      const changesArr = [...changes];
      eventSvc.dispatchEvent({
        type: eventType,
        columns: changesArr,
        column: changesArr.length === 1 ? changesArr[0] : null,
        source
      });
    };
    const getChangedColumns = (changedPredicate) => {
      const changedColumns2 = [];
      colModel.forAllCols((column) => {
        const colStateBefore = columnStateBeforeMap[column.getColId()];
        if (colStateBefore && changedPredicate(colStateBefore, column)) {
          changedColumns2.push(column);
        }
      });
      return changedColumns2;
    };
    const columnIdMapper = (c) => c.getColId();
    dispatchWhenListsDifferent(
      "columnRowGroupChanged",
      startState.rowGroupColumns,
      rowGroupColsSvc?.columns ?? [],
      columnIdMapper
    );
    dispatchWhenListsDifferent(
      "columnPivotChanged",
      startState.pivotColumns,
      pivotColsSvc?.columns ?? [],
      columnIdMapper
    );
    const valueChangePredicate = (cs, c) => {
      const oldActive = cs.aggFunc != null;
      const activeChanged = oldActive != c.isValueActive();
      const aggFuncChanged = oldActive && cs.aggFunc != c.getAggFunc();
      return activeChanged || aggFuncChanged;
    };
    const changedValues = getChangedColumns(valueChangePredicate);
    if (changedValues.length > 0) {
      dispatchColumnChangedEvent(eventSvc, "columnValueChanged", changedValues, source);
    }
    const resizeChangePredicate = (cs, c) => cs.width != c.getActualWidth();
    dispatchColumnResizedEvent(eventSvc, getChangedColumns(resizeChangePredicate), true, source);
    const pinnedChangePredicate = (cs, c) => cs.pinned != c.getPinned();
    dispatchColumnPinnedEvent(eventSvc, getChangedColumns(pinnedChangePredicate), source);
    const visibilityChangePredicate = (cs, c) => cs.hide == c.isVisible();
    dispatchColumnVisibleEvent(eventSvc, getChangedColumns(visibilityChangePredicate), source);
    const sortChangePredicate = (cs, c) => cs.sort != c.getSort() || cs.sortIndex != c.getSortIndex();
    const changedColumns = getChangedColumns(sortChangePredicate);
    if (changedColumns.length > 0) {
      sortSvc?.dispatchSortChangedEvents(source, changedColumns);
    }
    const colStateAfter = _getColumnState(beans);
    normaliseColumnMovedEventForColumnState(columnStateBefore, colStateAfter, source, colModel, eventSvc);
  };
}
function _getColumnState(beans) {
  const { colModel, rowGroupColsSvc, pivotColsSvc } = beans;
  const primaryCols = colModel.getColDefCols();
  if (_missing(primaryCols) || !colModel.isAlive()) {
    return [];
  }
  const rowGroupColumns = rowGroupColsSvc?.columns;
  const pivotColumns = pivotColsSvc?.columns;
  const res = [];
  const createStateItemFromColumn = (column) => {
    const rowGroupIndex = column.isRowGroupActive() && rowGroupColumns ? rowGroupColumns.indexOf(column) : null;
    const pivotIndex = column.isPivotActive() && pivotColumns ? pivotColumns.indexOf(column) : null;
    const aggFunc = column.isValueActive() ? column.getAggFunc() : null;
    const sort = column.getSort() != null ? column.getSort() : null;
    const sortIndex = column.getSortIndex() != null ? column.getSortIndex() : null;
    res.push({
      colId: column.getColId(),
      width: column.getActualWidth(),
      hide: !column.isVisible(),
      pinned: column.getPinned(),
      sort,
      sortIndex,
      aggFunc,
      rowGroup: column.isRowGroupActive(),
      rowGroupIndex,
      pivot: column.isPivotActive(),
      pivotIndex,
      flex: column.getFlex() ?? null
    });
  };
  colModel.forAllCols((col) => createStateItemFromColumn(col));
  const colIdToGridIndexMap = new Map(
    colModel.getCols().map((col, index) => [col.getColId(), index])
  );
  res.sort((itemA, itemB) => {
    const posA = colIdToGridIndexMap.has(itemA.colId) ? colIdToGridIndexMap.get(itemA.colId) : -1;
    const posB = colIdToGridIndexMap.has(itemB.colId) ? colIdToGridIndexMap.get(itemB.colId) : -1;
    return posA - posB;
  });
  return res;
}
function getColumnStateFromColDef(column) {
  const getValueOrNull = (a, b) => a != null ? a : b != null ? b : null;
  const colDef = column.getColDef();
  const sort = getValueOrNull(colDef.sort, colDef.initialSort);
  const sortIndex = getValueOrNull(colDef.sortIndex, colDef.initialSortIndex);
  const hide = getValueOrNull(colDef.hide, colDef.initialHide);
  const pinned = getValueOrNull(colDef.pinned, colDef.initialPinned);
  const width = getValueOrNull(colDef.width, colDef.initialWidth);
  const flex = getValueOrNull(colDef.flex, colDef.initialFlex);
  let rowGroupIndex = getValueOrNull(colDef.rowGroupIndex, colDef.initialRowGroupIndex);
  let rowGroup = getValueOrNull(colDef.rowGroup, colDef.initialRowGroup);
  if (rowGroupIndex == null && (rowGroup == null || rowGroup == false)) {
    rowGroupIndex = null;
    rowGroup = null;
  }
  let pivotIndex = getValueOrNull(colDef.pivotIndex, colDef.initialPivotIndex);
  let pivot = getValueOrNull(colDef.pivot, colDef.initialPivot);
  if (pivotIndex == null && (pivot == null || pivot == false)) {
    pivotIndex = null;
    pivot = null;
  }
  const aggFunc = getValueOrNull(colDef.aggFunc, colDef.initialAggFunc);
  return {
    colId: column.getColId(),
    sort,
    sortIndex,
    hide,
    pinned,
    width,
    flex,
    rowGroup,
    rowGroupIndex,
    pivot,
    pivotIndex,
    aggFunc
  };
}
function orderLiveColsLikeState(params, colModel, gos) {
  if (!params.applyOrder || !params.state) {
    return;
  }
  const colIds = [];
  params.state.forEach((item) => {
    if (item.colId != null) {
      colIds.push(item.colId);
    }
  });
  sortColsLikeKeys(colModel.cols, colIds, colModel, gos);
}
function sortColsLikeKeys(cols, colIds, colModel, gos) {
  if (cols == null) {
    return;
  }
  let newOrder = [];
  const processedColIds = {};
  colIds.forEach((colId) => {
    if (processedColIds[colId]) {
      return;
    }
    const col = cols.map[colId];
    if (col) {
      newOrder.push(col);
      processedColIds[colId] = true;
    }
  });
  let autoGroupInsertIndex = 0;
  cols.list.forEach((col) => {
    const colId = col.getColId();
    const alreadyProcessed = processedColIds[colId] != null;
    if (alreadyProcessed) {
      return;
    }
    const isAutoGroupCol = colId.startsWith(GROUP_AUTO_COLUMN_ID);
    if (isAutoGroupCol) {
      newOrder.splice(autoGroupInsertIndex++, 0, col);
    } else {
      newOrder.push(col);
    }
  });
  newOrder = placeLockedColumns(newOrder, gos);
  if (!doesMovePassMarryChildren(newOrder, colModel.getColTree())) {
    _warn(39);
    return;
  }
  cols.list = newOrder;
}
function normaliseColumnMovedEventForColumnState(colStateBefore, colStateAfter, source, colModel, eventSvc) {
  const colStateAfterMapped = {};
  colStateAfter.forEach((s) => colStateAfterMapped[s.colId] = s);
  const colsIntersectIds = {};
  colStateBefore.forEach((s) => {
    if (colStateAfterMapped[s.colId]) {
      colsIntersectIds[s.colId] = true;
    }
  });
  const beforeFiltered = colStateBefore.filter((c) => colsIntersectIds[c.colId]);
  const afterFiltered = colStateAfter.filter((c) => colsIntersectIds[c.colId]);
  const movedColumns = [];
  afterFiltered.forEach((csAfter, index) => {
    const csBefore = beforeFiltered && beforeFiltered[index];
    if (csBefore && csBefore.colId !== csAfter.colId) {
      const gridCol = colModel.getCol(csBefore.colId);
      if (gridCol) {
        movedColumns.push(gridCol);
      }
    }
  });
  if (!movedColumns.length) {
    return;
  }
  eventSvc.dispatchEvent({
    type: "columnMoved",
    columns: movedColumns,
    column: movedColumns.length === 1 ? movedColumns[0] : null,
    finished: true,
    source
  });
}
var comparatorByIndex = (indexes, oldList, colA, colB) => {
  const indexA = indexes[colA.getId()];
  const indexB = indexes[colB.getId()];
  const aHasIndex = indexA != null;
  const bHasIndex = indexB != null;
  if (aHasIndex && bHasIndex) {
    return indexA - indexB;
  }
  if (aHasIndex) {
    return -1;
  }
  if (bHasIndex) {
    return 1;
  }
  const oldIndexA = oldList.indexOf(colA);
  const oldIndexB = oldList.indexOf(colB);
  const aHasOldIndex = oldIndexA >= 0;
  const bHasOldIndex = oldIndexB >= 0;
  if (aHasOldIndex && bHasOldIndex) {
    return oldIndexA - oldIndexB;
  }
  if (aHasOldIndex) {
    return -1;
  }
  return 1;
};

// packages/ag-grid-community/src/columns/columnModel.ts
var ColumnModel = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "colModel";
    // if pivotMode is on, however pivot results are NOT shown if no pivot columns are set
    this.pivotMode = false;
    this.ready = false;
    this.changeEventsDispatching = false;
  }
  postConstruct() {
    this.pivotMode = this.gos.get("pivotMode");
    this.addManagedPropertyListeners(
      [
        "groupDisplayType",
        "treeData",
        "treeDataDisplayType",
        "groupHideOpenParents",
        "rowNumbers",
        "hidePaddedHeaderRows"
      ],
      (event) => this.refreshAll(_convertColumnEventSourceType(event.source))
    );
    this.addManagedPropertyListeners(
      ["defaultColDef", "defaultColGroupDef", "columnTypes", "suppressFieldDotNotation"],
      this.recreateColumnDefs.bind(this)
    );
    this.addManagedPropertyListener(
      "pivotMode",
      (event) => this.setPivotMode(this.gos.get("pivotMode"), _convertColumnEventSourceType(event.source))
    );
  }
  // called from SyncService, when grid has finished initialising
  createColsFromColDefs(source) {
    const { beans } = this;
    const { valueCache, colAutosize, rowGroupColsSvc, pivotColsSvc, valueColsSvc, visibleCols, eventSvc } = beans;
    const dispatchEventsFunc = this.colDefs ? _compareColumnStatesAndDispatchEvents(beans, source) : void 0;
    valueCache?.expire();
    const oldCols = this.colDefCols?.list;
    const oldTree = this.colDefCols?.tree;
    const newTree = _createColumnTree(beans, this.colDefs, true, oldTree, source);
    _destroyColumnTree(beans, this.colDefCols?.tree, newTree.columnTree);
    const tree = newTree.columnTree;
    const treeDepth = newTree.treeDepth;
    const list = _getColumnsFromTree(tree);
    const map = {};
    list.forEach((col) => map[col.getId()] = col);
    this.colDefCols = { tree, treeDepth, list, map };
    rowGroupColsSvc?.extractCols(source, oldCols);
    pivotColsSvc?.extractCols(source, oldCols);
    valueColsSvc?.extractCols(source, oldCols);
    this.ready = true;
    this.refreshCols(true);
    visibleCols.refresh(source);
    eventSvc.dispatchEvent({
      type: "columnEverythingChanged",
      source
    });
    if (dispatchEventsFunc) {
      this.changeEventsDispatching = true;
      dispatchEventsFunc();
      this.changeEventsDispatching = false;
    }
    eventSvc.dispatchEvent({
      type: "newColumnsLoaded",
      source
    });
    if (source === "gridInitializing") {
      colAutosize?.applyAutosizeStrategy();
    }
  }
  // called from: buildAutoGroupColumns (events 'groupDisplayType', 'treeData', 'treeDataDisplayType', 'groupHideOpenParents')
  // createColsFromColDefs (recreateColumnDefs, setColumnsDefs),
  // setPivotMode, applyColumnState,
  // functionColsService.setPrimaryColList, functionColsService.updatePrimaryColList,
  // pivotResultCols.setPivotResultCols
  refreshCols(newColDefs) {
    if (!this.colDefCols) {
      return;
    }
    const prevColTree = this.cols?.tree;
    this.saveColOrder();
    const {
      autoColSvc,
      selectionColSvc,
      rowNumbersSvc,
      quickFilter,
      pivotResultCols,
      showRowGroupCols,
      rowAutoHeight,
      visibleCols,
      colViewport,
      eventSvc
    } = this.beans;
    const cols = this.selectCols(pivotResultCols, this.colDefCols);
    this.createColumnsForService([autoColSvc, selectionColSvc, rowNumbersSvc], cols);
    const shouldSortNewColDefs = _shouldMaintainColumnOrder(this.gos, this.showingPivotResult);
    if (!newColDefs || shouldSortNewColDefs) {
      this.restoreColOrder(cols);
    }
    this.positionLockedCols(cols);
    showRowGroupCols?.refresh();
    quickFilter?.refreshCols();
    this.setColSpanActive();
    rowAutoHeight?.setAutoHeightActive(cols);
    visibleCols.clear();
    colViewport.clear();
    const dispatchChangedEvent = !_areEqual(prevColTree, this.cols.tree);
    if (dispatchChangedEvent) {
      eventSvc.dispatchEvent({
        type: "gridColumnsChanged"
      });
    }
  }
  createColumnsForService(services, cols) {
    for (const service of services) {
      if (!service) {
        continue;
      }
      service.createColumns(cols, (updateOrder) => {
        this.lastOrder = updateOrder(this.lastOrder);
        this.lastPivotOrder = updateOrder(this.lastPivotOrder);
      });
      service.addColumns(cols);
    }
  }
  selectCols(pivotResultColsSvc, colDefCols) {
    const pivotResultCols = pivotResultColsSvc?.getPivotResultCols() ?? null;
    this.showingPivotResult = pivotResultCols != null;
    const { map, list, tree, treeDepth } = pivotResultCols ?? colDefCols;
    this.cols = {
      list: list.slice(),
      map: { ...map },
      tree: tree.slice(),
      treeDepth
    };
    if (pivotResultCols) {
      const hasSameColumns = pivotResultCols.list.some((col) => this.cols?.map[col.getColId()] !== void 0);
      if (!hasSameColumns) {
        this.lastPivotOrder = null;
      }
    }
    return this.cols;
  }
  getColsToShow() {
    if (!this.cols) {
      return [];
    }
    const { valueColsSvc, selectionColSvc, gos } = this.beans;
    const showAutoGroupAndValuesOnly = this.isPivotMode() && !this.showingPivotResult;
    const showSelectionColumn = selectionColSvc?.isSelectionColumnEnabled();
    const showRowNumbers = gos.get("rowNumbers");
    const valueColumns = valueColsSvc?.columns;
    const res = this.cols.list.filter((col) => {
      const isAutoGroupCol = isColumnGroupAutoCol(col);
      if (showAutoGroupAndValuesOnly) {
        const isValueCol = valueColumns?.includes(col);
        return isAutoGroupCol || isValueCol || showSelectionColumn && isColumnSelectionCol(col) || showRowNumbers && isRowNumberCol(col);
      } else {
        return isAutoGroupCol || col.isVisible();
      }
    });
    return res;
  }
  // on events 'groupDisplayType', 'treeData', 'treeDataDisplayType', 'groupHideOpenParents'
  refreshAll(source) {
    if (!this.ready) {
      return;
    }
    this.refreshCols(false);
    this.beans.visibleCols.refresh(source);
  }
  setColsVisible(keys, visible = false, source) {
    _applyColumnState(
      this.beans,
      {
        state: keys.map((key) => ({
          colId: typeof key === "string" ? key : key.getColId(),
          hide: !visible
        }))
      },
      source
    );
  }
  /**
   * Restores provided columns order to the previous order in this.lastPivotOrder / this.lastOrder
   * If columns are not in the last order:
   *  - Check column groups, and apply column after the last column in the lowest shared group
   *  - If no sibling is found, apply the column at the end of the cols
   */
  restoreColOrder(cols) {
    const lastOrder = this.showingPivotResult ? this.lastPivotOrder : this.lastOrder;
    if (!lastOrder) {
      return;
    }
    const preservedOrder = lastOrder.filter((col) => cols.map[col.getId()] != null);
    if (preservedOrder.length === 0) {
      return;
    }
    if (preservedOrder.length === cols.list.length) {
      cols.list = preservedOrder;
      return;
    }
    const hasSiblings = (col) => {
      const ancestor = col.getOriginalParent();
      if (!ancestor) {
        return false;
      }
      const children = ancestor.getChildren();
      if (children.length > 1) {
        return true;
      }
      return hasSiblings(ancestor);
    };
    if (!preservedOrder.some((col) => hasSiblings(col))) {
      const preservedOrderSet = new Set(preservedOrder);
      for (const col of cols.list) {
        if (!preservedOrderSet.has(col)) {
          preservedOrder.push(col);
        }
      }
      cols.list = preservedOrder;
      return;
    }
    const colPositionMap = /* @__PURE__ */ new Map();
    for (let i = 0; i < preservedOrder.length; i++) {
      const col = preservedOrder[i];
      colPositionMap.set(col, i);
    }
    const additionalCols = cols.list.filter((col) => !colPositionMap.has(col));
    if (additionalCols.length === 0) {
      cols.list = preservedOrder;
      return;
    }
    const getPreviousSibling = (col, group) => {
      const parent = group ? group.getOriginalParent() : col.getOriginalParent();
      if (!parent) {
        return null;
      }
      let highestIdx = null;
      let highestSibling = null;
      for (const child of parent.getChildren()) {
        if (child === group || child === col) {
          continue;
        }
        if (child instanceof AgColumn) {
          const colIdx = colPositionMap.get(child);
          if (colIdx == null) {
            continue;
          }
          if (highestIdx == null || highestIdx < colIdx) {
            highestIdx = colIdx;
            highestSibling = child;
          }
          continue;
        }
        child.forEachLeafColumn((leafCol) => {
          const colIdx = colPositionMap.get(leafCol);
          if (colIdx == null) {
            return;
          }
          if (highestIdx == null || highestIdx < colIdx) {
            highestIdx = colIdx;
            highestSibling = leafCol;
          }
        });
      }
      if (highestSibling == null) {
        return getPreviousSibling(col, parent);
      }
      return highestSibling;
    };
    const noSiblingsAvailable = [];
    const previousSiblingPosMap = /* @__PURE__ */ new Map();
    for (const col of additionalCols) {
      const prevSiblingIdx = getPreviousSibling(col, null);
      if (prevSiblingIdx == null) {
        noSiblingsAvailable.push(col);
        continue;
      }
      const prev = previousSiblingPosMap.get(prevSiblingIdx);
      if (prev === void 0) {
        previousSiblingPosMap.set(prevSiblingIdx, col);
      } else if (Array.isArray(prev)) {
        prev.push(col);
      } else {
        previousSiblingPosMap.set(prevSiblingIdx, [prev, col]);
      }
    }
    const result = new Array(cols.list.length);
    let resultPointer = result.length - 1;
    for (let i = noSiblingsAvailable.length - 1; i >= 0; i--) {
      result[resultPointer--] = noSiblingsAvailable[i];
    }
    for (let i = preservedOrder.length - 1; i >= 0; i--) {
      const nextCol = preservedOrder[i];
      const extraCols = previousSiblingPosMap.get(nextCol);
      if (extraCols) {
        if (Array.isArray(extraCols)) {
          for (let x = extraCols.length - 1; x >= 0; x--) {
            const col = extraCols[x];
            result[resultPointer--] = col;
          }
        } else {
          result[resultPointer--] = extraCols;
        }
      }
      result[resultPointer--] = nextCol;
    }
    cols.list = result;
  }
  positionLockedCols(cols) {
    cols.list = placeLockedColumns(cols.list, this.gos);
  }
  saveColOrder() {
    if (this.showingPivotResult) {
      this.lastPivotOrder = this.cols?.list ?? null;
    } else {
      this.lastOrder = this.cols?.list ?? null;
    }
  }
  getColumnDefs() {
    return this.colDefCols ? this.beans.colDefFactory?.getColumnDefs(
      this.colDefCols.list,
      this.showingPivotResult,
      this.lastOrder,
      this.cols?.list ?? []
    ) : void 0;
  }
  setColSpanActive() {
    this.colSpanActive = !!this.cols?.list.some((col) => col.getColDef().colSpan != null);
  }
  isPivotMode() {
    return this.pivotMode;
  }
  setPivotMode(pivotMode, source) {
    if (pivotMode === this.pivotMode) {
      return;
    }
    this.pivotMode = pivotMode;
    if (!this.ready) {
      return;
    }
    this.refreshCols(false);
    const { visibleCols, eventSvc } = this.beans;
    visibleCols.refresh(source);
    eventSvc.dispatchEvent({
      type: "columnPivotModeChanged"
    });
  }
  // + clientSideRowModel
  isPivotActive() {
    const pivotColumns = this.beans.pivotColsSvc?.columns;
    return this.pivotMode && !!pivotColumns?.length;
  }
  // called when dataTypes change
  recreateColumnDefs(e) {
    if (!this.cols) {
      return;
    }
    this.beans.autoColSvc?.updateColumns(e);
    const source = _convertColumnEventSourceType(e.source);
    this.createColsFromColDefs(source);
  }
  setColumnDefs(columnDefs, source) {
    this.colDefs = columnDefs;
    this.createColsFromColDefs(source);
  }
  destroy() {
    _destroyColumnTree(this.beans, this.colDefCols?.tree);
    super.destroy();
  }
  getColTree() {
    return this.cols?.tree ?? [];
  }
  // + columnSelectPanel
  getColDefColTree() {
    return this.colDefCols?.tree ?? [];
  }
  // + clientSideRowController -> sorting, building quick filter text
  // + headerRenderer -> sorting (clearing icon)
  getColDefCols() {
    return this.colDefCols?.list ?? null;
  }
  // + moveColumnController
  getCols() {
    return this.cols?.list ?? [];
  }
  forAllCols(callback) {
    const { pivotResultCols, autoColSvc, selectionColSvc } = this.beans;
    _forAll(this.colDefCols?.list, callback);
    _forAll(autoColSvc?.columns?.list, callback);
    _forAll(selectionColSvc?.columns?.list, callback);
    _forAll(pivotResultCols?.getPivotResultCols()?.list, callback);
  }
  getColsForKeys(keys) {
    if (!keys) {
      return [];
    }
    return keys.map((key) => this.getCol(key)).filter((col) => col != null);
  }
  getColDefCol(key) {
    if (!this.colDefCols?.list) {
      return null;
    }
    return this.getColFromCollection(key, this.colDefCols);
  }
  getCol(key) {
    if (key == null) {
      return null;
    }
    return this.getColFromCollection(key, this.cols);
  }
  /**
   * Get column exclusively by ID.
   *
   * Note getCol/getColFromCollection have poor performance when col has been removed.
   */
  getColById(key) {
    return this.cols?.map[key] ?? null;
  }
  getColFromCollection(key, cols) {
    if (cols == null) {
      return null;
    }
    const { map, list } = cols;
    if (typeof key == "string" && map[key]) {
      return map[key];
    }
    for (let i = 0; i < list.length; i++) {
      if (_columnsMatch(list[i], key)) {
        return list[i];
      }
    }
    return this.beans.autoColSvc?.getColumn(key) ?? this.beans.selectionColSvc?.getColumn(key) ?? null;
  }
};

// packages/ag-grid-community/src/columns/baseColsService.ts
var BaseColsService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.dispatchColumnChangedEvent = dispatchColumnChangedEvent;
    this.columns = [];
    this.columnIndexMap = {};
    this.updateIndexMap = () => {
      this.columnIndexMap = {};
      this.columns.forEach((col, index) => this.columnIndexMap[col.getId()] = index);
    };
  }
  wireBeans(beans) {
    this.colModel = beans.colModel;
    this.aggFuncSvc = beans.aggFuncSvc;
    this.visibleCols = beans.visibleCols;
  }
  sortColumns(compareFn) {
    this.columns.sort(compareFn);
    this.updateIndexMap();
  }
  setColumns(colKeys, source) {
    this.setColList(colKeys, this.columns, this.eventName, true, true, this.columnProcessors.set, source);
  }
  addColumns(colKeys, source) {
    this.updateColList(colKeys, this.columns, true, true, this.columnProcessors.add, this.eventName, source);
  }
  removeColumns(colKeys, source) {
    this.updateColList(colKeys, this.columns, false, true, this.columnProcessors.remove, this.eventName, source);
  }
  getColumnIndex(colId) {
    return this.columnIndexMap[colId];
  }
  setColList(colKeys = [], masterList, eventName, detectOrderChange, autoGroupsNeedBuilding, columnCallback, source) {
    const gridColumns = this.colModel.getCols();
    if (!gridColumns || gridColumns.length === 0) {
      return;
    }
    const changes = /* @__PURE__ */ new Map();
    masterList.forEach((col, idx) => changes.set(col, idx));
    masterList.length = 0;
    if (_exists(colKeys)) {
      colKeys.forEach((key) => {
        const column = this.colModel.getColDefCol(key);
        if (column) {
          masterList.push(column);
        }
      });
    }
    masterList.forEach((col, idx) => {
      const oldIndex = changes.get(col);
      if (oldIndex === void 0) {
        changes.set(col, 0);
        return;
      }
      if (detectOrderChange && oldIndex !== idx) {
        return;
      }
      changes.delete(col);
    });
    this.updateIndexMap();
    const primaryCols = this.colModel.getColDefCols();
    (primaryCols || []).forEach((column) => {
      const added = masterList.indexOf(column) >= 0;
      columnCallback(column, added, source);
    });
    autoGroupsNeedBuilding && this.colModel.refreshCols(false);
    this.visibleCols.refresh(source);
    this.dispatchColumnChangedEvent(this.eventSvc, eventName, [...changes.keys()], source);
  }
  updateColList(keys = [], masterList, actionIsAdd, autoGroupsNeedBuilding, columnCallback, eventType, source) {
    if (!keys || keys.length === 0) {
      return;
    }
    let atLeastOne = false;
    const updatedCols = /* @__PURE__ */ new Set();
    keys.forEach((key) => {
      if (!key) {
        return;
      }
      const columnToAdd = this.colModel.getColDefCol(key);
      if (!columnToAdd) {
        return;
      }
      updatedCols.add(columnToAdd);
      if (actionIsAdd) {
        if (masterList.indexOf(columnToAdd) >= 0) {
          return;
        }
        masterList.push(columnToAdd);
      } else {
        const currentIndex = masterList.indexOf(columnToAdd);
        if (currentIndex < 0) {
          return;
        }
        for (let i = currentIndex + 1; i < masterList.length; i++) {
          updatedCols.add(masterList[i]);
        }
        _removeFromArray(masterList, columnToAdd);
      }
      columnCallback(columnToAdd, actionIsAdd, source);
      atLeastOne = true;
    });
    if (!atLeastOne) {
      return;
    }
    this.updateIndexMap();
    if (autoGroupsNeedBuilding) {
      this.colModel.refreshCols(false);
    }
    this.visibleCols.refresh(source);
    const eventColumns = Array.from(updatedCols);
    this.eventSvc.dispatchEvent({
      type: eventType,
      columns: eventColumns,
      column: eventColumns.length === 1 ? eventColumns[0] : null,
      source
    });
  }
  extractCols(source, oldProvidedCols = []) {
    const previousCols = this.columns;
    const colsWithIndex = [];
    const colsWithValue = [];
    const { setFlagFunc, getIndexFunc, getInitialIndexFunc, getValueFunc, getInitialValueFunc } = this.columnExtractors;
    const primaryCols = this.colModel.getColDefCols() || [];
    primaryCols.forEach((col) => {
      const colIsNew = oldProvidedCols.indexOf(col) < 0;
      const colDef = col.getColDef();
      const value = getValueFunc(colDef);
      const initialValue = getInitialValueFunc(colDef);
      const index = getIndexFunc(colDef);
      const initialIndex = getInitialIndexFunc(colDef);
      let include;
      const valuePresent = value !== void 0;
      const indexPresent = index !== void 0;
      const initialValuePresent = initialValue !== void 0;
      const initialIndexPresent = initialIndex !== void 0;
      if (valuePresent) {
        include = value;
      } else if (indexPresent) {
        if (index === null) {
          include = false;
        } else {
          include = index >= 0;
        }
      } else {
        if (colIsNew) {
          if (initialValuePresent) {
            include = initialValue;
          } else if (initialIndexPresent) {
            include = initialIndex != null && initialIndex >= 0;
          } else {
            include = false;
          }
        } else {
          include = previousCols.indexOf(col) >= 0;
        }
      }
      if (include) {
        const useIndex = colIsNew ? index != null || initialIndex != null : index != null;
        useIndex ? colsWithIndex.push(col) : colsWithValue.push(col);
      }
    });
    const getIndexForCol = (col) => {
      const index = getIndexFunc(col.getColDef());
      const defaultIndex = getInitialIndexFunc(col.getColDef());
      return index != null ? index : defaultIndex;
    };
    colsWithIndex.sort((colA, colB) => {
      const indexA = getIndexForCol(colA);
      const indexB = getIndexForCol(colB);
      if (indexA === indexB) {
        return 0;
      }
      if (indexA < indexB) {
        return -1;
      }
      return 1;
    });
    const res = [].concat(colsWithIndex);
    previousCols.forEach((col) => {
      if (colsWithValue.indexOf(col) >= 0) {
        res.push(col);
      }
    });
    colsWithValue.forEach((col) => {
      if (res.indexOf(col) < 0) {
        res.push(col);
      }
    });
    previousCols.forEach((col) => {
      if (res.indexOf(col) < 0) {
        setFlagFunc(col, false, source);
      }
    });
    res.forEach((col) => {
      if (previousCols.indexOf(col) < 0) {
        setFlagFunc(col, true, source);
      }
    });
    this.columns = res;
    this.updateIndexMap();
    return this.columns;
  }
  restoreColumnOrder(columnStateAccumulator, incomingColumnState) {
    const colList = this.columns;
    const primaryCols = this.colModel.getColDefCols();
    if (!colList.length || !primaryCols) {
      return columnStateAccumulator;
    }
    const updatedColIdArray = Object.keys(incomingColumnState);
    const updatedColIds = new Set(updatedColIdArray);
    const newColIds = new Set(updatedColIdArray);
    const allColIds = new Set(
      colList.map((column) => {
        const colId = column.getColId();
        newColIds.delete(colId);
        return colId;
      }).concat(updatedColIdArray)
    );
    const colIdsInOriginalOrder = [];
    const originalOrderMap = {};
    let orderIndex = 0;
    for (let i = 0; i < primaryCols.length; i++) {
      const colId = primaryCols[i].getColId();
      if (allColIds.has(colId)) {
        colIdsInOriginalOrder.push(colId);
        originalOrderMap[colId] = orderIndex++;
      }
    }
    let index = 1e3;
    let hasAddedNewCols = false;
    let lastIndex = 0;
    const enableProp = this.columnOrdering.enableProp;
    const initialEnableProp = this.columnOrdering.initialEnableProp;
    const indexProp = this.columnOrdering.indexProp;
    const initialIndexProp = this.columnOrdering.initialIndexProp;
    const processPrecedingNewCols = (colId) => {
      const originalOrderIndex = originalOrderMap[colId];
      for (let i = lastIndex; i < originalOrderIndex; i++) {
        const newColId = colIdsInOriginalOrder[i];
        if (newColIds.has(newColId)) {
          incomingColumnState[newColId][indexProp] = index++;
          newColIds.delete(newColId);
        }
      }
      lastIndex = originalOrderIndex;
    };
    colList.forEach((column) => {
      const colId = column.getColId();
      if (updatedColIds.has(colId)) {
        processPrecedingNewCols(colId);
        incomingColumnState[colId][indexProp] = index++;
      } else {
        const colDef = column.getColDef();
        const missingIndex = colDef[indexProp] === null || colDef[indexProp] === void 0 && colDef[initialIndexProp] == null;
        if (missingIndex) {
          if (!hasAddedNewCols) {
            const propEnabled = colDef[enableProp] || colDef[enableProp] === void 0 && colDef[initialEnableProp];
            if (propEnabled) {
              processPrecedingNewCols(colId);
            } else {
              newColIds.forEach((newColId) => {
                incomingColumnState[newColId][indexProp] = index + originalOrderMap[newColId];
              });
              index += colIdsInOriginalOrder.length;
              hasAddedNewCols = true;
            }
          }
          if (!columnStateAccumulator[colId]) {
            columnStateAccumulator[colId] = { colId };
          }
          columnStateAccumulator[colId][indexProp] = index++;
        }
      }
    });
    return columnStateAccumulator;
  }
};

// packages/ag-grid-community/src/columns/groupInstanceIdCreator.ts
var GroupInstanceIdCreator = class {
  constructor() {
    // this map contains keys to numbers, so we remember what the last call was
    this.existingIds = {};
  }
  getInstanceIdForKey(key) {
    const lastResult = this.existingIds[key];
    let result;
    if (typeof lastResult !== "number") {
      result = 0;
    } else {
      result = lastResult + 1;
    }
    this.existingIds[key] = result;
    return result;
  }
};

// packages/ag-grid-community/src/components/emptyBean.ts
var EmptyBean = class extends BeanStub {
};
function setupCompBean(ctrl, ctx, compBean) {
  if (compBean) {
    ctrl.addDestroyFunc(() => ctx.destroyBean(compBean));
  }
  return compBean ?? ctrl;
}

// packages/ag-grid-community/src/rendering/cssClassManager.ts
var CssClassManager = class {
  constructor(getGui) {
    // to minimise DOM hits, we only apply CSS classes if they have changed. as adding a CSS class that is already
    // there, or removing one that wasn't present, all takes CPU.
    this.cssClassStates = {};
    this.getGui = getGui;
  }
  toggleCss(className, addOrRemove) {
    if (!className) {
      return;
    }
    if (className.indexOf(" ") >= 0) {
      const list = (className || "").split(" ");
      if (list.length > 1) {
        list.forEach((cls) => this.toggleCss(cls, addOrRemove));
        return;
      }
    }
    const updateNeeded = this.cssClassStates[className] !== addOrRemove;
    if (updateNeeded && className.length) {
      this.getGui()?.classList.toggle(className, addOrRemove);
      this.cssClassStates[className] = addOrRemove;
    }
  }
};

// packages/ag-grid-community/src/widgets/component.ts
var compIdSequence = 0;
var RefPlaceholder = null;
var Component = class extends BeanStub {
  constructor(templateOrParams, componentSelectors) {
    super();
    this.suppressDataRefValidation = false;
    // if false, then CSS class "ag-hidden" is applied, which sets "display: none"
    this.displayed = true;
    // if false, then CSS class "ag-invisible" is applied, which sets "visibility: hidden"
    this.visible = true;
    // unique id for this row component. this is used for getting a reference to the HTML dom.
    // we cannot use the RowNode id as this is not unique (due to animation, old rows can be lying
    // around as we create a new rowComp instance for the same row node).
    this.compId = compIdSequence++;
    this.cssManager = new CssClassManager(() => this.eGui);
    this.componentSelectors = new Map((componentSelectors ?? []).map((comp) => [comp.selector, comp]));
    if (templateOrParams) {
      this.setTemplate(templateOrParams);
    }
  }
  preConstruct() {
    this.wireTemplate(this.getGui());
    const debugId = "component-" + Object.getPrototypeOf(this)?.constructor?.name;
    this.css?.forEach((css) => this.beans.environment.addGlobalCSS(css, debugId));
  }
  wireTemplate(element, paramsMap) {
    if (element && this.gos) {
      this.applyElementsToComponent(element);
      this.createChildComponentsFromTags(element, paramsMap);
    }
  }
  getCompId() {
    return this.compId;
  }
  getDataRefAttribute(element) {
    if (element.getAttribute) {
      return element.getAttribute(DataRefAttribute);
    }
    return null;
  }
  applyElementsToComponent(element, elementRef, paramsMap, newComponent = null) {
    if (elementRef === void 0) {
      elementRef = this.getDataRefAttribute(element);
    }
    if (elementRef) {
      const current = this[elementRef];
      if (current === RefPlaceholder) {
        this[elementRef] = newComponent ?? element;
      } else {
        const usedAsParamRef = paramsMap && paramsMap[elementRef];
        if (!this.suppressDataRefValidation && !usedAsParamRef) {
          throw new Error(`data-ref: ${elementRef} on ${this.constructor.name} with ${current}`);
        }
      }
    }
  }
  // for registered components only, eg creates AgCheckbox instance from ag-checkbox HTML tag
  createChildComponentsFromTags(parentNode, paramsMap) {
    const childNodeList = [];
    for (const childNode of parentNode.childNodes ?? []) {
      childNodeList.push(childNode);
    }
    childNodeList.forEach((childNode) => {
      if (!(childNode instanceof HTMLElement)) {
        return;
      }
      const childComp = this.createComponentFromElement(
        childNode,
        (childComp2) => {
          const childGui = childComp2.getGui();
          if (childGui) {
            for (const attr of childNode.attributes ?? []) {
              childGui.setAttribute(attr.name, attr.value);
            }
          }
        },
        paramsMap
      );
      if (childComp) {
        if (childComp.addItems && childNode.children.length) {
          this.createChildComponentsFromTags(childNode, paramsMap);
          const items = Array.prototype.slice.call(childNode.children);
          childComp.addItems(items);
        }
        this.swapComponentForNode(childComp, parentNode, childNode);
      } else if (childNode.childNodes) {
        this.createChildComponentsFromTags(childNode, paramsMap);
      }
    });
  }
  createComponentFromElement(element, afterPreCreateCallback, paramsMap) {
    const key = element.nodeName;
    const elementRef = this.getDataRefAttribute(element);
    const isAgGridComponent = key.indexOf("AG-") === 0;
    const componentSelector = isAgGridComponent ? this.componentSelectors.get(key) : null;
    let newComponent = null;
    if (componentSelector) {
      const componentParams = paramsMap && elementRef ? paramsMap[elementRef] : void 0;
      newComponent = new componentSelector.component(componentParams);
      newComponent.setParentComponent(this);
      this.createBean(newComponent, null, afterPreCreateCallback);
    } else if (isAgGridComponent) {
      throw new Error(`selector: ${key}`);
    }
    this.applyElementsToComponent(element, elementRef, paramsMap, newComponent);
    return newComponent;
  }
  swapComponentForNode(newComponent, parentNode, childNode) {
    const eComponent = newComponent.getGui();
    parentNode.replaceChild(eComponent, childNode);
    parentNode.insertBefore(document.createComment(childNode.nodeName), eComponent);
    this.addDestroyFunc(this.destroyBean.bind(this, newComponent));
  }
  activateTabIndex(elements) {
    const tabIndex = this.gos.get("tabIndex");
    if (!elements) {
      elements = [];
    }
    if (!elements.length) {
      elements.push(this.getGui());
    }
    elements.forEach((el) => el.setAttribute("tabindex", tabIndex.toString()));
  }
  setTemplate(templateOrParams, componentSelectors, paramsMap) {
    let eGui;
    if (typeof templateOrParams === "string" || templateOrParams == null) {
      eGui = _loadTemplate(templateOrParams);
    } else {
      eGui = _createElement(templateOrParams);
    }
    this.setTemplateFromElement(eGui, componentSelectors, paramsMap);
  }
  setTemplateFromElement(element, components, paramsMap, suppressDataRefValidation = false) {
    this.eGui = element;
    this.suppressDataRefValidation = suppressDataRefValidation;
    if (components) {
      for (let i = 0; i < components.length; i++) {
        const component = components[i];
        this.componentSelectors.set(component.selector, component);
      }
    }
    this.wireTemplate(element, paramsMap);
  }
  getGui() {
    return this.eGui;
  }
  getFocusableElement() {
    return this.eGui;
  }
  getAriaElement() {
    return this.getFocusableElement();
  }
  setParentComponent(component) {
    this.parentComponent = component;
  }
  getParentComponent() {
    return this.parentComponent;
  }
  // this method is for older code, that wants to provide the gui element,
  // it is not intended for this to be in ag-Stack
  setGui(eGui) {
    this.eGui = eGui;
  }
  queryForHtmlElement(cssSelector) {
    return this.eGui.querySelector(cssSelector);
  }
  getContainerAndElement(newChild, container) {
    let parent = container;
    if (newChild == null) {
      return null;
    }
    if (!parent) {
      parent = this.eGui;
    }
    if (_isNodeOrElement(newChild)) {
      return {
        element: newChild,
        parent
      };
    }
    return {
      element: newChild.getGui(),
      parent
    };
  }
  prependChild(newChild, container) {
    const { element, parent } = this.getContainerAndElement(newChild, container) || {};
    if (!element || !parent) {
      return;
    }
    parent.insertAdjacentElement("afterbegin", element);
  }
  appendChild(newChild, container) {
    const { element, parent } = this.getContainerAndElement(newChild, container) || {};
    if (!element || !parent) {
      return;
    }
    parent.appendChild(element);
  }
  isDisplayed() {
    return this.displayed;
  }
  setVisible(visible, options = {}) {
    if (visible !== this.visible) {
      this.visible = visible;
      const { skipAriaHidden } = options;
      _setVisible(this.eGui, visible, { skipAriaHidden });
    }
  }
  setDisplayed(displayed, options = {}) {
    if (displayed !== this.displayed) {
      this.displayed = displayed;
      const { skipAriaHidden } = options;
      _setDisplayed(this.eGui, displayed, { skipAriaHidden });
      const event = {
        type: "displayChanged",
        visible: this.displayed
      };
      this.dispatchLocalEvent(event);
    }
  }
  destroy() {
    if (this.parentComponent) {
      this.parentComponent = void 0;
    }
    super.destroy();
  }
  addGuiEventListener(event, listener, options) {
    this.eGui.addEventListener(event, listener, options);
    this.addDestroyFunc(() => this.eGui.removeEventListener(event, listener));
  }
  addCss(className) {
    this.cssManager.toggleCss(className, true);
  }
  removeCss(className) {
    this.cssManager.toggleCss(className, false);
  }
  toggleCss(className, addOrRemove) {
    this.cssManager.toggleCss(className, addOrRemove);
  }
  registerCSS(css) {
    this.css || (this.css = []);
    this.css.push(css);
  }
};

// packages/ag-grid-community/src/interfaces/iFilter.ts
function isColumnFilterComp(filter) {
  return typeof filter === "object" && !!filter.component;
}

// packages/ag-grid-community/src/utils/promise.ts
function _isPromise(fn) {
  if (typeof fn.then === "function") {
    return true;
  }
  return false;
}
var AgPromise = class _AgPromise {
  constructor(callback) {
    this.status = 0 /* IN_PROGRESS */;
    this.resolution = null;
    this.waiters = [];
    callback(
      (value) => this.onDone(value),
      (params) => this.onReject(params)
    );
  }
  static all(promises) {
    return promises.length ? new _AgPromise((resolve) => {
      let remainingToResolve = promises.length;
      const combinedValues = new Array(remainingToResolve);
      promises.forEach((promise, index) => {
        promise.then((value) => {
          combinedValues[index] = value;
          remainingToResolve--;
          if (remainingToResolve === 0) {
            resolve(combinedValues);
          }
        });
      });
    }) : _AgPromise.resolve();
  }
  static resolve(value = null) {
    return new _AgPromise((resolve) => resolve(value));
  }
  then(func) {
    return new _AgPromise((resolve) => {
      if (this.status === 1 /* RESOLVED */) {
        resolve(func(this.resolution));
      } else {
        this.waiters.push((value) => resolve(func(value)));
      }
    });
  }
  onDone(value) {
    this.status = 1 /* RESOLVED */;
    this.resolution = value;
    this.waiters.forEach((waiter) => waiter(value));
  }
  onReject(_) {
  }
};

// packages/ag-grid-community/src/components/framework/userComponentFactory.ts
function doesImplementIComponent(candidate) {
  if (!candidate) {
    return false;
  }
  return candidate.prototype && "getGui" in candidate.prototype;
}
function _getUserCompKeys(frameworkOverrides, defObject, type, params) {
  const { name } = type;
  let compName;
  let jsComp;
  let fwComp;
  let paramsFromSelector;
  let popupFromSelector;
  let popupPositionFromSelector;
  if (defObject) {
    const defObjectAny = defObject;
    const selectorFunc = defObjectAny[name + "Selector"];
    const selectorRes = selectorFunc ? selectorFunc(params) : null;
    const assignComp = (providedJsComp) => {
      if (typeof providedJsComp === "string") {
        compName = providedJsComp;
      } else if (providedJsComp != null && providedJsComp !== true) {
        const isFwkComp = frameworkOverrides.isFrameworkComponent(providedJsComp);
        if (isFwkComp) {
          fwComp = providedJsComp;
        } else {
          jsComp = providedJsComp;
        }
      }
    };
    if (selectorRes) {
      assignComp(selectorRes.component);
      paramsFromSelector = selectorRes.params;
      popupFromSelector = selectorRes.popup;
      popupPositionFromSelector = selectorRes.popupPosition;
    } else {
      assignComp(defObjectAny[name]);
    }
  }
  return { compName, jsComp, fwComp, paramsFromSelector, popupFromSelector, popupPositionFromSelector };
}
var UserComponentFactory = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "userCompFactory";
  }
  wireBeans(beans) {
    this.agCompUtils = beans.agCompUtils;
    this.registry = beans.registry;
    this.frameworkCompWrapper = beans.frameworkCompWrapper;
    this.gridOptions = beans.gridOptions;
  }
  getCompDetailsFromGridOptions(type, defaultName, params, mandatory = false) {
    return this.getCompDetails(this.gridOptions, type, defaultName, params, mandatory);
  }
  getCompDetails(defObject, type, defaultName, params, mandatory = false) {
    const { name, cellRenderer } = type;
    let { compName, jsComp, fwComp, paramsFromSelector, popupFromSelector, popupPositionFromSelector } = _getUserCompKeys(this.beans.frameworkOverrides, defObject, type, params);
    let defaultCompParams;
    let defaultCompProcessParams;
    const lookupFromRegistry = (key) => {
      const item = this.registry.getUserComponent(name, key);
      if (item) {
        jsComp = !item.componentFromFramework ? item.component : void 0;
        fwComp = item.componentFromFramework ? item.component : void 0;
        defaultCompParams = item.params;
        defaultCompProcessParams = item.processParams;
      }
    };
    if (compName != null) {
      lookupFromRegistry(compName);
    }
    if (jsComp == null && fwComp == null && defaultName != null) {
      lookupFromRegistry(defaultName);
    }
    if (jsComp && cellRenderer && !doesImplementIComponent(jsComp)) {
      jsComp = this.agCompUtils?.adaptFunction(type, jsComp);
    }
    if (!jsComp && !fwComp) {
      const { validation: validation2 } = this.beans;
      if (mandatory && (compName !== defaultName || !defaultName)) {
        if (compName) {
          if (!validation2?.isProvidedUserComp(compName)) {
            _error(50, { compName });
          }
        } else {
          if (defaultName) {
            if (!validation2) {
              _error(260, {
                ...this.gos.getModuleErrorParams(),
                propName: name,
                compName: defaultName
              });
            }
          } else {
            _error(216, { name });
          }
        }
      } else if (defaultName && !validation2) {
        _error(146, { comp: defaultName });
      }
      return;
    }
    const paramsMerged = this.mergeParams(
      defObject,
      type,
      params,
      paramsFromSelector,
      defaultCompParams,
      defaultCompProcessParams
    );
    const componentFromFramework = jsComp == null;
    const componentClass = jsComp ?? fwComp;
    return {
      componentFromFramework,
      componentClass,
      params: paramsMerged,
      type,
      popupFromSelector,
      popupPositionFromSelector,
      newAgStackInstance: () => this.newAgStackInstance(componentClass, componentFromFramework, paramsMerged, type)
    };
  }
  newAgStackInstance(ComponentClass, componentFromFramework, params, type) {
    const jsComponent = !componentFromFramework;
    let instance;
    if (jsComponent) {
      instance = new ComponentClass();
    } else {
      instance = this.frameworkCompWrapper.wrap(
        ComponentClass,
        type.mandatoryMethods,
        type.optionalMethods,
        type
      );
    }
    this.createBean(instance);
    const deferredInit = instance.init?.(params);
    if (deferredInit == null) {
      return AgPromise.resolve(instance);
    }
    return deferredInit.then(() => instance);
  }
  /**
   * merges params with application provided params
   * used by Floating Filter
   */
  mergeParams(defObject, type, paramsFromGrid, paramsFromSelector = null, defaultCompParams, defaultCompProcessParams) {
    const params = { ...paramsFromGrid, ...defaultCompParams };
    const defObjectAny = defObject;
    const userParams = defObjectAny && defObjectAny[type.name + "Params"];
    if (typeof userParams === "function") {
      const userParamsFromFunc = userParams(paramsFromGrid);
      _mergeDeep(params, userParamsFromFunc);
    } else if (typeof userParams === "object") {
      _mergeDeep(params, userParams);
    }
    _mergeDeep(params, paramsFromSelector);
    return defaultCompProcessParams ? defaultCompProcessParams(params) : params;
  }
};

// packages/ag-grid-community/src/components/framework/userCompUtils.ts
var DateComponent = {
  name: "dateComponent",
  mandatoryMethods: ["getDate", "setDate"],
  optionalMethods: ["afterGuiAttached", "setInputPlaceholder", "setInputAriaLabel", "setDisabled", "refresh"]
};
var DragAndDropImageComponent = {
  name: "dragAndDropImageComponent",
  mandatoryMethods: ["setIcon", "setLabel"]
};
var HeaderComponent = { name: "headerComponent", optionalMethods: ["refresh"] };
var InnerHeaderComponent = { name: "innerHeaderComponent" };
var InnerHeaderGroupComponent = { name: "innerHeaderGroupComponent" };
var HeaderGroupComponent = { name: "headerGroupComponent" };
var InnerCellRendererComponent = {
  name: "innerRenderer",
  cellRenderer: true,
  optionalMethods: ["afterGuiAttached"]
};
var CellRendererComponent = {
  name: "cellRenderer",
  optionalMethods: ["refresh", "afterGuiAttached"],
  cellRenderer: true
};
var EditorRendererComponent = {
  name: "cellRenderer",
  optionalMethods: ["refresh", "afterGuiAttached"]
};
var LoadingCellRendererComponent = { name: "loadingCellRenderer", cellRenderer: true };
var CellEditorComponent = {
  name: "cellEditor",
  mandatoryMethods: ["getValue"],
  optionalMethods: [
    "isPopup",
    "isCancelBeforeStart",
    "isCancelAfterEnd",
    "getPopupPosition",
    "focusIn",
    "focusOut",
    "afterGuiAttached",
    "refresh"
  ]
};
var LoadingOverlayComponent = { name: "loadingOverlayComponent", optionalMethods: ["refresh"] };
var NoRowsOverlayComponent = { name: "noRowsOverlayComponent", optionalMethods: ["refresh"] };
var TooltipComponent = { name: "tooltipComponent" };
var FilterComponent = {
  name: "filter",
  mandatoryMethods: ["isFilterActive", "doesFilterPass", "getModel", "setModel"],
  optionalMethods: [
    "afterGuiAttached",
    "afterGuiDetached",
    "onNewRowsLoaded",
    "getModelAsString",
    "onFloatingFilterChanged",
    "onAnyFilterChanged",
    "refresh"
  ]
};
var FloatingFilterComponent = {
  name: "floatingFilterComponent",
  mandatoryMethods: ["onParentModelChanged"],
  optionalMethods: ["afterGuiAttached", "refresh"]
};
var FullWidth = {
  name: "fullWidthCellRenderer",
  optionalMethods: ["refresh", "afterGuiAttached"],
  cellRenderer: true
};
var FullWidthLoading = { name: "loadingCellRenderer", cellRenderer: true };
var FullWidthGroup = {
  name: "groupRowRenderer",
  optionalMethods: ["afterGuiAttached"],
  cellRenderer: true
};
var FullWidthDetail = { name: "detailCellRenderer", optionalMethods: ["refresh"], cellRenderer: true };
function _getDragAndDropImageCompDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(DragAndDropImageComponent, "agDragAndDropImage", params, true);
}
function _getInnerCellRendererDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(def, InnerCellRendererComponent, void 0, params);
}
function _getHeaderCompDetails(userCompFactory, colDef, params) {
  return userCompFactory.getCompDetails(colDef, HeaderComponent, "agColumnHeader", params);
}
function _getInnerHeaderCompDetails(userCompFactory, headerCompParams, params) {
  return userCompFactory.getCompDetails(headerCompParams, InnerHeaderComponent, void 0, params);
}
function _getHeaderGroupCompDetails(userCompFactory, params) {
  const colGroupDef = params.columnGroup.getColGroupDef();
  return userCompFactory.getCompDetails(colGroupDef, HeaderGroupComponent, "agColumnGroupHeader", params);
}
function _getInnerHeaderGroupCompDetails(userCompFactory, headerGroupCompParams, params) {
  return userCompFactory.getCompDetails(headerGroupCompParams, InnerHeaderGroupComponent, void 0, params);
}
function _getFullWidthCellRendererDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(FullWidth, void 0, params, true);
}
function _getFullWidthLoadingCellRendererDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(FullWidthLoading, "agLoadingCellRenderer", params, true);
}
function _getFullWidthGroupCellRendererDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(FullWidthGroup, "agGroupRowRenderer", params, true);
}
function _getFullWidthDetailCellRendererDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(FullWidthDetail, "agDetailCellRenderer", params, true);
}
function _getCellRendererDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(def, CellRendererComponent, void 0, params);
}
function _getEditorRendererDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(
    def,
    EditorRendererComponent,
    void 0,
    params
  );
}
function _getLoadingCellRendererDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(def, LoadingCellRendererComponent, "agSkeletonCellRenderer", params, true);
}
function _getCellEditorDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(def, CellEditorComponent, "agCellEditor", params, true);
}
function _getFilterDetails(userCompFactory, def, params, defaultFilter) {
  const filter = def.filter;
  if (isColumnFilterComp(filter)) {
    def = {
      filter: filter.component,
      filterParams: def.filterParams
    };
  }
  return userCompFactory.getCompDetails(def, FilterComponent, defaultFilter, params, true);
}
function _getDateCompDetails(userCompFactory, def, params) {
  return userCompFactory.getCompDetails(def, DateComponent, "agDateInput", params, true);
}
function _getLoadingOverlayCompDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(LoadingOverlayComponent, "agLoadingOverlay", params, true);
}
function _getNoRowsOverlayCompDetails(userCompFactory, params) {
  return userCompFactory.getCompDetailsFromGridOptions(NoRowsOverlayComponent, "agNoRowsOverlay", params, true);
}
function _getTooltipCompDetails(userCompFactory, params) {
  return userCompFactory.getCompDetails(params.colDef, TooltipComponent, "agTooltipComponent", params, true);
}
function _getFloatingFilterCompDetails(userCompFactory, def, params, defaultFloatingFilter) {
  return userCompFactory.getCompDetails(def, FloatingFilterComponent, defaultFloatingFilter, params);
}
function _getFilterCompKeys(frameworkOverrides, def) {
  return _getUserCompKeys(frameworkOverrides, def, FilterComponent);
}
function _mergeFilterParamsWithApplicationProvidedParams(userCompFactory, defObject, paramsFromGrid) {
  return userCompFactory.mergeParams(defObject, FilterComponent, paramsFromGrid);
}

// packages/ag-grid-community/src/components/framework/unwrapUserComp.ts
function _unwrapUserComp(comp) {
  const compAsAny = comp;
  const isProxy = compAsAny != null && compAsAny.getFrameworkComponentInstance != null;
  return isProxy ? compAsAny.getFrameworkComponentInstance() : comp;
}

// packages/ag-grid-community/src/modules/moduleRegistry.ts
var allRegisteredModules = /* @__PURE__ */ new Set();
var globalModulesMap = {};
var gridModulesMap = {};
var currentModuleVersion;
var userHasRegistered = false;
var areGridScopedModules = false;
var isUmd = false;
function isValidModuleVersion(module) {
  const [moduleMajor, moduleMinor] = module.version.split(".") || [];
  const [currentModuleMajor, currentModuleMinor] = currentModuleVersion.split(".") || [];
  return moduleMajor === currentModuleMajor && moduleMinor === currentModuleMinor;
}
function runVersionChecks(module) {
  if (!currentModuleVersion) {
    currentModuleVersion = module.version;
  }
  const errorMsg = (details) => `You are using incompatible versions of AG Grid modules. Major and minor versions should always match across modules. ${details} Please update all modules to the same version.`;
  if (!module.version) {
    _errorOnce(errorMsg(`'${module.moduleName}' is incompatible.`));
  } else if (!isValidModuleVersion(module)) {
    _errorOnce(
      errorMsg(
        `'${module.moduleName}' is version ${module.version} but the other modules are version ${currentModuleVersion}.`
      )
    );
  }
  if (module.validate) {
    const result = module.validate();
    if (!result.isValid) {
      const errorResult = result;
      _errorOnce(`${errorResult.message}`);
    }
  }
}
function _registerModule(module, gridId, isInternalRegistration = false) {
  if (!isInternalRegistration) {
    userHasRegistered = true;
  }
  runVersionChecks(module);
  const rowModels = module.rowModels ?? ["all"];
  allRegisteredModules.add(module);
  let moduleStore;
  if (gridId !== void 0) {
    areGridScopedModules = true;
    if (gridModulesMap[gridId] === void 0) {
      gridModulesMap[gridId] = {};
    }
    moduleStore = gridModulesMap[gridId];
  } else {
    moduleStore = globalModulesMap;
  }
  rowModels.forEach((rowModel) => {
    if (moduleStore[rowModel] === void 0) {
      moduleStore[rowModel] = {};
    }
    moduleStore[rowModel][module.moduleName] = module;
  });
  if (module.dependsOn) {
    module.dependsOn.forEach((dependency) => _registerModule(dependency, gridId, isInternalRegistration));
  }
}
function _unRegisterGridModules(gridId) {
  delete gridModulesMap[gridId];
}
function _isModuleRegistered(moduleName, gridId, rowModel) {
  const isRegisteredForRowModel = (model) => !!globalModulesMap[model]?.[moduleName] || !!gridModulesMap[gridId]?.[model]?.[moduleName];
  return isRegisteredForRowModel(rowModel) || isRegisteredForRowModel("all");
}
function _areModulesGridScoped() {
  return areGridScopedModules;
}
function _getRegisteredModules(gridId, rowModel) {
  const gridModules = gridModulesMap[gridId] ?? {};
  return [
    ...Object.values(globalModulesMap["all"] ?? {}),
    ...Object.values(gridModules["all"] ?? {}),
    ...Object.values(globalModulesMap[rowModel] ?? {}),
    ...Object.values(gridModules[rowModel] ?? {})
  ];
}
function _getAllRegisteredModules() {
  return new Set(allRegisteredModules);
}
function _getGridRegisteredModules(gridId, rowModel) {
  const gridModules = gridModulesMap[gridId] ?? {};
  return [...Object.values(gridModules["all"] ?? {}), ...Object.values(gridModules[rowModel] ?? {})];
}
function _hasUserRegistered() {
  return userHasRegistered;
}
function _isUmd() {
  return isUmd;
}
function _setUmd() {
  isUmd = true;
}
var ModuleRegistry = class {
  /**
   * @deprecated v33 Use `registerModules([module])` instead.
   */
  static register(module) {
    _registerModule(module, void 0);
  }
  /**
   * Globally register the given modules for all grids.
   * @param modules - modules to register
   */
  static registerModules(modules) {
    modules.forEach((module) => _registerModule(module, void 0));
  }
};

// packages/ag-grid-community/src/context/genericContext.ts
var GenericContext = class {
  constructor(params) {
    this.beans = {};
    this.createdBeans = [];
    this.destroyed = false;
    if (!params || !params.beanClasses) {
      return;
    }
    this.beanDestroyComparator = params.beanDestroyComparator;
    this.init(params);
  }
  init(params) {
    for (const beanName of Object.keys(params.providedBeanInstances)) {
      this.beans[beanName] = params.providedBeanInstances[beanName];
    }
    params.beanClasses.forEach((BeanClass) => {
      const instance = new BeanClass();
      if (instance.beanName) {
        this.beans[instance.beanName] = instance;
      } else {
        console.error(`Bean ${BeanClass.name} is missing beanName`);
      }
      this.createdBeans.push(instance);
    });
    params.derivedBeans?.forEach((beanFunc) => {
      const { beanName, bean } = beanFunc(this);
      this.beans[beanName] = bean;
      this.createdBeans.push(bean);
    });
    if (params.beanInitComparator) {
      this.createdBeans.sort(params.beanInitComparator);
    }
    this.initBeans(this.createdBeans);
  }
  getBeanInstances() {
    return Object.values(this.beans);
  }
  createBean(bean, afterPreCreateCallback) {
    this.initBeans([bean], afterPreCreateCallback);
    return bean;
  }
  initBeans(beanInstances, afterPreCreateCallback) {
    beanInstances.forEach((instance) => {
      instance.preWireBeans?.(this.beans);
      instance.wireBeans?.(this.beans);
    });
    beanInstances.forEach((instance) => instance.preConstruct?.());
    if (afterPreCreateCallback) {
      beanInstances.forEach(afterPreCreateCallback);
    }
    beanInstances.forEach((instance) => instance.postConstruct?.());
  }
  getBeans() {
    return this.beans;
  }
  getBean(name) {
    return this.beans[name];
  }
  destroy() {
    if (this.destroyed) {
      return;
    }
    this.destroyed = true;
    const beanInstances = this.getBeanInstances();
    if (this.beanDestroyComparator) {
      beanInstances.sort(this.beanDestroyComparator);
    }
    this.destroyBeans(beanInstances);
    this.beans = {};
    this.createdBeans = [];
  }
  /**
   * Destroys a bean and returns undefined to support destruction and clean up in a single line.
   * this.dateComp = this.context.destroyBean(this.dateComp);
   */
  destroyBean(bean) {
    bean?.destroy?.();
  }
  /**
   * Destroys an array of beans and returns an empty array to support destruction and clean up in a single line.
   * this.dateComps = this.context.destroyBeans(this.dateComps);
   */
  destroyBeans(beans) {
    if (beans) {
      for (let i = 0; i < beans.length; i++) {
        this.destroyBean(beans[i]);
      }
    }
    return [];
  }
  isDestroyed() {
    return this.destroyed;
  }
};

// packages/ag-grid-community/src/context/context.ts
function isComponentMetaFunc(componentMeta) {
  return typeof componentMeta === "object" && !!componentMeta.getComp;
}
var Context = class extends GenericContext {
  init(params) {
    this.gridId = params.gridId;
    this.beans.context = this;
    this.destroyCallback = params.destroyCallback;
    super.init(params);
  }
  destroy() {
    super.destroy();
    _unRegisterGridModules(this.gridId);
    this.destroyCallback?.();
  }
  getGridId() {
    return this.gridId;
  }
};

// packages/ag-grid-community/src/edit/editModelService.ts
var EditModelService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "editModelSvc";
    this.edits = /* @__PURE__ */ new Map();
    this.cellValidations = new EditCellValidationModel();
    this.rowValidations = new EditRowValidationModel();
    // during some operations, we want to always return false from `hasEdits`
    this.suspendEdits = false;
  }
  suspend(suspend) {
    this.suspendEdits = suspend;
  }
  removeEdits({ rowNode, column }) {
    if (!this.hasEdits({ rowNode }) || !rowNode) {
      return;
    }
    const editRow = this.getEditRow(rowNode);
    if (column) {
      editRow.delete(column);
    } else {
      editRow.clear();
    }
    if (editRow.size === 0) {
      this.edits.delete(rowNode);
    }
  }
  getEditRow(rowNode, params = {}) {
    if (this.suspendEdits) {
      return void 0;
    }
    if (this.edits.size === 0) {
      return void 0;
    }
    const edits = rowNode && this.edits.get(rowNode);
    if (edits) {
      return edits;
    }
    if (params.checkSiblings) {
      const pinnedSibling = rowNode.pinnedSibling;
      if (pinnedSibling) {
        return this.getEditRow(pinnedSibling);
      }
    }
    return void 0;
  }
  getEditRowDataValue(rowNode, { checkSiblings } = {}) {
    if (this.edits.size === 0) {
      return rowNode.data;
    }
    const editRow = this.getEditRow(rowNode);
    const pinnedSibling = rowNode.pinnedSibling;
    const siblingRow = checkSiblings && pinnedSibling && this.getEditRow(pinnedSibling);
    if (!editRow && !siblingRow) {
      return rowNode.data;
    }
    const data = Object.assign({}, rowNode.data);
    const applyEdits = (edits, data2) => edits.forEach(({ pendingValue }, column) => {
      if (pendingValue !== UNEDITED) {
        data2[column.getColId()] = pendingValue;
      }
    });
    if (editRow) {
      applyEdits(editRow, data);
    }
    if (siblingRow) {
      applyEdits(siblingRow, data);
    }
    return data;
  }
  getEdit(position, copy) {
    const edit = this._getEdit(position);
    return copy && edit ? { ...edit } : edit;
  }
  _getEdit(position) {
    if (this.suspendEdits) {
      return void 0;
    }
    if (this.edits.size === 0) {
      return void 0;
    }
    return position.rowNode && position.column && this.getEditRow(position.rowNode)?.get(position.column);
  }
  getEditMap(copy = true) {
    if (this.suspendEdits || this.edits.size === 0) {
      return /* @__PURE__ */ new Map();
    }
    if (!copy) {
      return this.edits;
    }
    const map = /* @__PURE__ */ new Map();
    this.edits.forEach((editRow, rowNode) => map.set(rowNode, new Map(editRow)));
    return map;
  }
  setEditMap(newEdits) {
    this.edits.clear();
    newEdits.forEach((editRow, rowNode) => {
      const newRow = /* @__PURE__ */ new Map();
      editRow.forEach(
        (cellData, column) => (
          // Ensure we copy the cell data to avoid reference issues
          newRow.set(column, { ...cellData })
        )
      );
      this.edits.set(rowNode, newRow);
    });
  }
  setEdit(position, edit) {
    (this.edits.size === 0 || !this.edits.has(position.rowNode)) && this.edits.set(position.rowNode, /* @__PURE__ */ new Map());
    const currentEdit = { ...this._getEdit(position), ...edit };
    this.getEditRow(position.rowNode).set(position.column, currentEdit);
    return currentEdit;
  }
  clearEditValue(position) {
    const { rowNode, column } = position;
    if (rowNode) {
      if (column) {
        const edit = this._getEdit(position);
        if (edit) {
          edit.editorValue = void 0;
          edit.pendingValue = edit.sourceValue;
          edit.state = "changed";
        }
      } else {
        this.getEditRow(rowNode)?.forEach((cellData) => {
          cellData.editorValue = void 0;
          cellData.pendingValue = cellData.sourceValue;
          cellData.state = "changed";
        });
      }
    }
  }
  getState(position) {
    if (this.suspendEdits) {
      return void 0;
    }
    return this.getEdit(position)?.state;
  }
  getEditPositions(editMap) {
    if (this.suspendEdits || (editMap ?? this.edits).size === 0) {
      return [];
    }
    const positions = [];
    (editMap ?? this.edits).forEach((editRow, rowNode) => {
      for (const column of editRow.keys()) {
        positions.push({
          rowNode,
          column,
          ...editRow.get(column)
        });
      }
    });
    return positions;
  }
  hasRowEdits(rowNode, params) {
    if (this.suspendEdits) {
      return false;
    }
    if (this.edits.size === 0) {
      return false;
    }
    const rowEdits = this.getEditRow(rowNode, params);
    return !!rowEdits;
  }
  hasEdits(position = {}, params = {}) {
    if (this.suspendEdits) {
      return false;
    }
    if (this.edits.size === 0) {
      return false;
    }
    const { rowNode, column } = position;
    const { withOpenEditor } = params;
    if (rowNode) {
      const rowEdits = this.getEditRow(rowNode, params);
      if (!rowEdits) {
        return false;
      }
      if (column) {
        if (withOpenEditor) {
          return this.getEdit(position)?.state === "editing";
        }
        return rowEdits.has(column) ?? false;
      }
      if (rowEdits.size !== 0) {
        if (withOpenEditor) {
          return Array.from(rowEdits.values()).some(({ state }) => state === "editing");
        }
        return true;
      }
      return false;
    }
    if (withOpenEditor) {
      return this.getEditPositions().some(({ state }) => state === "editing");
    }
    return this.edits.size > 0;
  }
  start(position) {
    const map = this.getEditRow(position.rowNode) ?? /* @__PURE__ */ new Map();
    const { rowNode, column } = position;
    if (column && !map.has(column)) {
      map.set(column, {
        editorValue: void 0,
        pendingValue: UNEDITED,
        sourceValue: this.beans.valueSvc.getValue(column, rowNode, true, "api"),
        state: "editing"
      });
    }
    this.edits.set(rowNode, map);
  }
  stop(position) {
    if (!this.hasEdits(position)) {
      return;
    }
    if (position) {
      this.removeEdits(position);
    } else {
      this.clear();
    }
    return;
  }
  clear() {
    for (const pendingRowEdits of this.edits.values()) {
      pendingRowEdits.clear();
    }
    this.edits.clear();
  }
  getCellValidationModel() {
    return this.cellValidations;
  }
  getRowValidationModel() {
    return this.rowValidations;
  }
  setCellValidationModel(model) {
    this.cellValidations = model;
  }
  setRowValidationModel(model) {
    this.rowValidations = model;
  }
  destroy() {
    super.destroy();
    this.clear();
  }
};
var EditCellValidationModel = class {
  constructor() {
    this.cellValidations = /* @__PURE__ */ new Map();
  }
  getCellValidation(position) {
    const { rowNode, column } = position || {};
    return this.cellValidations?.get(rowNode)?.get(column);
  }
  hasCellValidation(position) {
    if (!position || !position.rowNode || !position.column) {
      return this.cellValidations.size > 0;
    }
    return !!this.getCellValidation(position);
  }
  setCellValidation(position, validation2) {
    const { rowNode, column } = position;
    if (!this.cellValidations.has(rowNode)) {
      this.cellValidations.set(rowNode, /* @__PURE__ */ new Map());
    }
    this.cellValidations.get(rowNode).set(column, validation2);
  }
  clearCellValidation(position) {
    const { rowNode, column } = position;
    this.cellValidations.get(rowNode)?.delete(column);
  }
  setCellValidationMap(validationMap) {
    this.cellValidations = validationMap;
  }
  getCellValidationMap() {
    return this.cellValidations;
  }
  clearCellValidationMap() {
    this.cellValidations.clear();
  }
};
var EditRowValidationModel = class {
  constructor() {
    this.rowValidations = /* @__PURE__ */ new Map();
  }
  getRowValidation(position) {
    const { rowNode } = position || {};
    return this.rowValidations.get(rowNode);
  }
  hasRowValidation(position) {
    if (!position || !position.rowNode) {
      return this.rowValidations.size > 0;
    }
    return !!this.getRowValidation(position);
  }
  setRowValidation({ rowNode }, rowValidation) {
    this.rowValidations.set(rowNode, rowValidation);
  }
  clearRowValidation({ rowNode }) {
    this.rowValidations.delete(rowNode);
  }
  setRowValidationMap(validationMap) {
    this.rowValidations = validationMap;
  }
  getRowValidationMap() {
    return this.rowValidations;
  }
  clearRowValidationMap() {
    this.rowValidations.clear();
  }
};

// packages/ag-grid-community/src/entities/positionUtils.ts
function _createCellId(cellPosition) {
  const { rowIndex, rowPinned, column } = cellPosition;
  return `${rowIndex}.${rowPinned == null ? "null" : rowPinned}.${column.getId()}`;
}
function _areCellsEqual(cellA, cellB) {
  const colsMatch = cellA.column === cellB.column;
  const floatingMatch = cellA.rowPinned === cellB.rowPinned;
  const indexMatch = cellA.rowIndex === cellB.rowIndex;
  return colsMatch && floatingMatch && indexMatch;
}
function _isRowBefore(rowA, rowB) {
  switch (rowA.rowPinned) {
    case "top":
      if (rowB.rowPinned !== "top") {
        return true;
      }
      break;
    case "bottom":
      if (rowB.rowPinned !== "bottom") {
        return false;
      }
      break;
    default:
      if (_exists(rowB.rowPinned)) {
        return rowB.rowPinned !== "top";
      }
      break;
  }
  return rowA.rowIndex < rowB.rowIndex;
}
function _isSameRow(rowA, rowB) {
  if (!rowA && !rowB) {
    return true;
  }
  if (rowA && !rowB || !rowA && rowB) {
    return false;
  }
  return rowA.rowIndex === rowB.rowIndex && rowA.rowPinned == rowB.rowPinned;
}
function _getFirstRow(beans) {
  let rowIndex = 0;
  let rowPinned;
  const { pinnedRowModel, rowModel, pageBounds } = beans;
  if (pinnedRowModel?.getPinnedTopRowCount()) {
    rowPinned = "top";
  } else if (rowModel.getRowCount()) {
    rowPinned = null;
    rowIndex = pageBounds.getFirstRow();
  } else if (pinnedRowModel?.getPinnedBottomRowCount()) {
    rowPinned = "bottom";
  }
  return rowPinned === void 0 ? null : { rowIndex, rowPinned };
}
function _getLastRow(beans) {
  let rowIndex;
  let rowPinned = null;
  const { pinnedRowModel, pageBounds } = beans;
  const pinnedBottomCount = pinnedRowModel?.getPinnedBottomRowCount();
  const pinnedTopCount = pinnedRowModel?.getPinnedTopRowCount();
  if (pinnedBottomCount) {
    rowPinned = "bottom";
    rowIndex = pinnedBottomCount - 1;
  } else if (beans.rowModel.getRowCount()) {
    rowPinned = null;
    rowIndex = pageBounds.getLastRow();
  } else if (pinnedTopCount) {
    rowPinned = "top";
    rowIndex = pinnedTopCount - 1;
  }
  return rowIndex === void 0 ? null : { rowIndex, rowPinned };
}
function _getRowNode(beans, gridRow) {
  switch (gridRow.rowPinned) {
    case "top":
      return beans.pinnedRowModel?.getPinnedTopRow(gridRow.rowIndex);
    case "bottom":
      return beans.pinnedRowModel?.getPinnedBottomRow(gridRow.rowIndex);
    default:
      return beans.rowModel.getRow(gridRow.rowIndex);
  }
}
function _getCellByPosition(beans, cellPosition) {
  const spannedCellCtrl = beans.spannedRowRenderer?.getCellByPosition(cellPosition);
  if (spannedCellCtrl) {
    return spannedCellCtrl;
  }
  const rowCtrl = beans.rowRenderer.getRowByPosition(cellPosition);
  if (!rowCtrl) {
    return null;
  }
  return rowCtrl.getCellCtrl(cellPosition.column);
}
function _getRowById(beans, rowId, rowPinned) {
  const { rowModel: rm, pinnedRowModel: prm } = beans;
  let node;
  node ?? (node = rm?.getRowNode(rowId));
  if (rowPinned) {
    node ?? (node = prm?.getPinnedRowById(rowId, rowPinned));
  } else {
    node ?? (node = prm?.getPinnedRowById(rowId, "top"));
    node ?? (node = prm?.getPinnedRowById(rowId, "bottom"));
  }
  return node;
}
function _getRowAbove(beans, rowPosition) {
  const { rowIndex: index, rowPinned: pinned } = rowPosition;
  const { pageBounds, pinnedRowModel, rowModel } = beans;
  if (index === 0) {
    if (pinned === "top") {
      return null;
    }
    if (pinned === "bottom" && rowModel.isRowsToRender()) {
      return { rowIndex: pageBounds.getLastRow(), rowPinned: null };
    }
    return pinnedRowModel?.isRowsToRender("top") ? { rowIndex: pinnedRowModel.getPinnedTopRowCount() - 1, rowPinned: "top" } : null;
  }
  const rowNode = pinned ? void 0 : rowModel.getRow(index);
  return getNextStickyPosition(beans, rowNode, true) ?? { rowIndex: index - 1, rowPinned: pinned };
}
function _getRowBelow(beans, rowPosition) {
  const { rowIndex: index, rowPinned: pinned } = rowPosition;
  const { pageBounds, pinnedRowModel, rowModel } = beans;
  if (isLastRowInContainer(beans, rowPosition)) {
    if (pinned === "bottom") {
      return null;
    }
    if (pinned === "top" && rowModel.isRowsToRender()) {
      return { rowIndex: pageBounds.getFirstRow(), rowPinned: null };
    }
    return pinnedRowModel?.isRowsToRender("bottom") ? { rowIndex: 0, rowPinned: "bottom" } : null;
  }
  const rowNode = pinned ? void 0 : rowModel.getRow(index);
  return getNextStickyPosition(beans, rowNode) ?? { rowIndex: index + 1, rowPinned: pinned };
}
function getNextStickyPosition(beans, rowNode, up = false) {
  const { gos, rowRenderer } = beans;
  if (!rowNode?.sticky || !_isGroupRowsSticky(gos)) {
    return;
  }
  const stickyTopCtrls = rowRenderer.getStickyTopRowCtrls();
  const stickyBottomCtrls = rowRenderer.getStickyBottomRowCtrls();
  const isStickyTop = !stickyBottomCtrls.some((ctrl) => ctrl.rowNode.rowIndex === rowNode.rowIndex);
  const stickyRowCtrls = isStickyTop ? stickyTopCtrls : stickyBottomCtrls;
  const increment = (up ? -1 : 1) * (isStickyTop ? -1 : 1);
  let nextCtrl;
  for (let i = 0; i < stickyRowCtrls.length; i++) {
    if (stickyRowCtrls[i].rowNode.rowIndex === rowNode.rowIndex) {
      nextCtrl = stickyRowCtrls[i + increment];
      break;
    }
  }
  return nextCtrl ? { rowIndex: nextCtrl.rowNode.rowIndex, rowPinned: null } : void 0;
}
function isLastRowInContainer(beans, rowPosition) {
  const { rowPinned, rowIndex } = rowPosition;
  const { pinnedRowModel, pageBounds } = beans;
  if (rowPinned === "top") {
    const lastTopIndex = (pinnedRowModel?.getPinnedTopRowCount() ?? 0) - 1;
    return lastTopIndex <= rowIndex;
  }
  if (rowPinned === "bottom") {
    const lastBottomIndex = (pinnedRowModel?.getPinnedBottomRowCount() ?? 0) - 1;
    return lastBottomIndex <= rowIndex;
  }
  const lastBodyIndex = pageBounds.getLastRow();
  return lastBodyIndex <= rowIndex;
}

// packages/ag-grid-community/src/edit/utils/controllers.ts
function _getRowCtrl(beans, inputs = {}) {
  const { rowIndex, rowId, rowCtrl, rowPinned } = inputs;
  if (rowCtrl) {
    return rowCtrl;
  }
  const { rowModel, rowRenderer } = beans;
  let { rowNode } = inputs;
  if (!rowNode) {
    if (rowId) {
      rowNode = _getRowById(beans, rowId, rowPinned);
    } else if (rowIndex != null) {
      rowNode = rowModel.getRow(rowIndex);
    }
  }
  return rowRenderer.getRowCtrls(rowNode ? [rowNode] : [])?.[0];
}
function _getCellCtrl(beans, inputs = {}) {
  const { cellCtrl, colId, columnId, column } = inputs;
  if (cellCtrl) {
    return cellCtrl;
  }
  const actualColumn = beans.colModel.getCol(colId ?? columnId ?? _getColId(column));
  const rowCtrl = inputs.rowCtrl ?? _getRowCtrl(beans, inputs);
  const result = rowCtrl?.getCellCtrl(actualColumn) ?? void 0;
  if (result) {
    return result;
  }
  const rowNode = inputs.rowNode ?? rowCtrl?.rowNode;
  if (rowNode) {
    return beans.rowRenderer.getCellCtrls([rowNode], [actualColumn])?.[0];
  }
  return void 0;
}
function _stopEditing(beans) {
  const { editSvc } = beans;
  if (editSvc?.isBatchEditing()) {
    _destroyEditors(beans);
  } else {
    editSvc?.stopEditing(void 0, { source: "api" });
  }
}
function _addStopEditingWhenGridLosesFocus(bean, beans, viewports) {
  const { gos, popupSvc } = beans;
  if (!gos.get("stopEditingWhenCellsLoseFocus")) {
    return;
  }
  const focusOutListener = (event) => {
    const elementWithFocus = event.relatedTarget;
    if (_getTabIndex(elementWithFocus) === null) {
      _stopEditing(beans);
      return;
    }
    let clickInsideGrid = (
      // see if click came from inside the viewports
      viewports.some((viewport) => viewport.contains(elementWithFocus)) && // and also that it's not from a detail grid
      _isElementInThisGrid(gos, elementWithFocus)
    );
    if (!clickInsideGrid) {
      clickInsideGrid = !!popupSvc && (popupSvc.getActivePopups().some((popup) => popup.contains(elementWithFocus)) || popupSvc.isElementWithinCustomPopup(elementWithFocus));
    }
    if (!clickInsideGrid) {
      _stopEditing(beans);
    }
  };
  viewports.forEach((viewport) => bean.addManagedElementListeners(viewport, { focusout: focusOutListener }));
}
function _getColId(column) {
  if (!column) {
    return void 0;
  }
  if (typeof column === "string") {
    return column;
  }
  return column.getColId();
}

// packages/ag-grid-community/src/edit/utils/editors.ts
var UNEDITED = Symbol("unedited");
function getCellEditorInstanceMap(beans, params = {}) {
  const res = [];
  const ctrls = beans.rowRenderer.getCellCtrls(params.rowNodes, params.columns);
  for (const ctrl of ctrls) {
    const cellEditor = ctrl.comp?.getCellEditor();
    if (cellEditor) {
      res.push({
        ctrl,
        editor: _unwrapUserComp(cellEditor)
      });
    }
  }
  return res;
}
var getCellEditorInstances = (beans, params = {}) => getCellEditorInstanceMap(beans, params).map((res) => res.editor);
function _setupEditors(beans, editingCells, position, key, event, cellStartedEdit) {
  if (editingCells.length === 0 && position?.rowNode && position?.column) {
    _setupEditor(beans, position, { key, event, cellStartedEdit });
  }
  const { valueSvc, editSvc, editModelSvc } = beans;
  const { rowNode, column } = position ?? {};
  for (const cellPosition of editingCells) {
    const { rowNode: cellRowNode, column: cellColumn } = cellPosition;
    const curCellCtrl = _getCellCtrl(beans, cellPosition);
    if (!curCellCtrl) {
      if (cellRowNode && cellColumn) {
        const oldValue = valueSvc.getValue(cellColumn, cellRowNode, void 0, "api");
        const isNewValueCell = position?.rowNode === cellRowNode && position?.column === cellColumn;
        const cellStartValue = isNewValueCell && key || void 0;
        const newValue = cellStartValue ?? editSvc?.getCellDataValue(cellPosition, false) ?? valueSvc.getValueForDisplay(cellColumn, cellRowNode)?.value ?? oldValue ?? UNEDITED;
        editModelSvc?.setEdit(cellPosition, {
          pendingValue: newValue,
          sourceValue: oldValue,
          state: "editing"
        });
      }
      continue;
    }
    const shouldStartEditing = cellStartedEdit && rowNode === curCellCtrl.rowNode && curCellCtrl.column === column;
    _setupEditor(
      beans,
      { rowNode, column: curCellCtrl.column },
      {
        key: shouldStartEditing ? key : null,
        event: shouldStartEditing ? event : null,
        cellStartedEdit: shouldStartEditing
      }
    );
  }
  return;
}
function _sourceAndPendingDiffer({
  pendingValue,
  sourceValue
}) {
  if (pendingValue === UNEDITED) {
    pendingValue = sourceValue;
  }
  return pendingValue !== sourceValue;
}
function _setupEditor(beans, position, params) {
  const { key, event, cellStartedEdit, silent } = params ?? {};
  const cellCtrl = _getCellCtrl(beans, position);
  const editorComp = cellCtrl?.comp?.getCellEditor();
  const editorParams = _createEditorParams(beans, position, key, cellStartedEdit);
  const previousEdit = beans.editModelSvc?.getEdit(position);
  let newValue = key?.length === 1 ? key : editorParams.value;
  if (newValue === void 0) {
    newValue = previousEdit?.sourceValue;
  }
  beans.editModelSvc?.setEdit(position, {
    editorValue: newValue,
    state: "editing"
  });
  if (editorComp) {
    editorComp.refresh?.(editorParams);
    return;
  }
  const colDef = position.column.getColDef();
  const compDetails = _getCellEditorDetails(beans.userCompFactory, colDef, editorParams);
  const popup = compDetails?.popupFromSelector != null ? compDetails.popupFromSelector : !!colDef.cellEditorPopup;
  const popupLocation = compDetails?.popupPositionFromSelector != null ? compDetails.popupPositionFromSelector : colDef.cellEditorPopupPosition;
  checkAndPreventDefault(compDetails.params, event);
  if (cellCtrl) {
    cellCtrl.editCompDetails = compDetails;
    cellCtrl.comp?.setEditDetails(compDetails, popup, popupLocation, beans.gos.get("reactiveCustomComponents"));
    cellCtrl?.rowCtrl?.refreshRow({ suppressFlash: true });
    if (!silent) {
      beans.editSvc?.dispatchCellEvent(position, event, "cellEditingStarted");
    }
  }
  return;
}
function _valueFromEditor(cellEditor) {
  const noValueResult = { editorValueExists: false };
  const validationErrors = cellEditor.getValidationErrors?.();
  if ((validationErrors?.length ?? 0) > 0) {
    return noValueResult;
  }
  const editorValue = cellEditor.getValue();
  return {
    editorValue,
    editorValueExists: true
  };
}
function _createEditorParams(beans, position, key, cellStartedEdit) {
  const { valueSvc, gos, editSvc } = beans;
  const cellCtrl = _getCellCtrl(beans, position);
  const rowIndex = position.rowNode?.rowIndex ?? void 0;
  const batchEdit = editSvc?.isBatchEditing();
  const agColumn = beans.colModel.getCol(position.column.getId());
  const { rowNode, column } = position;
  const editor = cellCtrl.comp?.getCellEditor();
  const initialNewValue = editSvc?.getCellDataValue(position, false) ?? (editor ? _valueFromEditor(editor)?.editorValue : void 0);
  const value = initialNewValue === UNEDITED ? valueSvc.getValueForDisplay(agColumn, rowNode)?.value : initialNewValue;
  return _addGridCommonParams(gos, {
    value,
    eventKey: key ?? null,
    column,
    colDef: column.getColDef(),
    rowIndex,
    node: rowNode,
    data: rowNode.data,
    cellStartedEdit: cellStartedEdit ?? false,
    onKeyDown: cellCtrl?.onKeyDown.bind(cellCtrl),
    stopEditing: (suppressNavigateAfterEdit) => {
      editSvc.stopEditing(position, { source: batchEdit ? "ui" : "api", suppressNavigateAfterEdit });
      _destroyEditor(beans, position);
    },
    eGridCell: cellCtrl?.eGui,
    parseValue: (newValue) => valueSvc.parseValue(agColumn, rowNode, newValue, cellCtrl?.value),
    formatValue: cellCtrl?.formatValue.bind(cellCtrl),
    validate: () => {
      editSvc?.validateEdit();
    }
  });
}
function _purgeUnchangedEdits(beans, includeEditing) {
  const { editModelSvc } = beans;
  editModelSvc?.getEditMap().forEach((editRow, rowNode) => {
    editRow.forEach((edit, column) => {
      if (!includeEditing && (edit.state === "editing" || edit.pendingValue === UNEDITED)) {
        return;
      }
      if (!_sourceAndPendingDiffer(edit) && (edit.state !== "editing" || includeEditing)) {
        editModelSvc?.removeEdits({ rowNode, column });
      }
    });
  });
}
function _refreshEditorOnColDefChanged(beans, cellCtrl) {
  const editor = cellCtrl.comp?.getCellEditor();
  if (!editor?.refresh) {
    return;
  }
  const { eventKey, cellStartedEdit } = cellCtrl.editCompDetails.params;
  const { column } = cellCtrl;
  const editorParams = _createEditorParams(beans, cellCtrl, eventKey, cellStartedEdit);
  const colDef = column.getColDef();
  const compDetails = _getCellEditorDetails(beans.userCompFactory, colDef, editorParams);
  editor.refresh(checkAndPreventDefault(compDetails.params, eventKey));
}
function checkAndPreventDefault(params, event) {
  if (event instanceof KeyboardEvent && params.column.getColDef().cellEditor === "agNumberCellEditor") {
    params.suppressPreventDefault = ["-", "+", ".", "e"].includes(event?.key ?? "") || params.suppressPreventDefault;
  } else {
    event?.preventDefault?.();
  }
  return params;
}
function _syncFromEditors(beans, persist) {
  beans.editModelSvc?.getEditPositions().forEach((cellId) => {
    const cellCtrl = _getCellCtrl(beans, cellId);
    if (!cellCtrl) {
      return;
    }
    const editor = cellCtrl.comp.getCellEditor();
    if (!editor) {
      return;
    }
    const { editorValue, editorValueExists } = _valueFromEditor(editor);
    _syncFromEditor(beans, cellId, persist, editorValue, void 0, !editorValueExists);
  });
}
function _syncFromEditor(beans, position, persist, editorValue, _source, valueSameAsSource) {
  const { editModelSvc, valueSvc } = beans;
  if (!editModelSvc) {
    return;
  }
  const { rowNode, column } = position;
  if (!(rowNode && column)) {
    return;
  }
  const cellCtrl = _getCellCtrl(beans, position);
  const hasEditor = !!cellCtrl?.comp?.getCellEditor();
  let edit = editModelSvc.getEdit(position, true);
  if (!edit?.sourceValue) {
    edit = editModelSvc.setEdit(position, {
      sourceValue: valueSvc.getValue(column, rowNode, void 0, "api"),
      pendingValue: UNEDITED,
      state: hasEditor ? "editing" : "changed"
    });
  }
  editModelSvc.setEdit(position, {
    editorValue: valueSameAsSource ? edit.sourceValue : editorValue,
    state: hasEditor ? "editing" : "changed"
  });
  if (persist) {
    _persistEditorValue(beans, position);
  }
}
function _persistEditorValue(beans, position) {
  const { editModelSvc } = beans;
  const edit = editModelSvc?.getEdit(position, true);
  editModelSvc?.setEdit(position, {
    pendingValue: edit?.editorValue
  });
}
function _destroyEditors(beans, edits, params) {
  if (!edits) {
    edits = beans.editModelSvc?.getEditPositions();
  }
  edits.forEach((cellPosition) => _destroyEditor(beans, cellPosition, params));
}
function _destroyEditor(beans, position, params) {
  const { editSvc, editModelSvc } = beans;
  const { rowNode, column } = position;
  const cellCtrl = _getCellCtrl(beans, position);
  if (!cellCtrl) {
    if (editModelSvc?.hasEdits(position) && rowNode && column) {
      editModelSvc?.setEdit(position, { state: "changed" });
    }
    return;
  }
  const { comp } = cellCtrl;
  if (comp && !comp.getCellEditor()) {
    return;
  }
  const errorMessages = comp?.getCellEditor()?.getValidationErrors?.();
  const cellValidationModel = editModelSvc?.getCellValidationModel();
  if (errorMessages?.length) {
    cellValidationModel?.setCellValidation(position, { errorMessages });
  } else {
    cellValidationModel?.clearCellValidation(position);
  }
  if (editModelSvc?.getEdit(position)) {
    editModelSvc?.setEdit(position, { state: "changed" });
  }
  comp?.setEditDetails();
  comp?.refreshEditStyles(false, false);
  cellCtrl?.refreshCell({ force: true, suppressFlash: true });
  const latest = editModelSvc?.getEdit(position);
  if (latest?.state === "changed" && !params?.silent) {
    editSvc?.dispatchCellEvent(position, params?.event, "cellEditingStopped", {
      valueChanged: _sourceAndPendingDiffer(latest),
      newValue: latest?.pendingValue,
      oldValue: latest?.sourceValue
    });
  }
}
function _populateModelValidationErrors(beans) {
  const mappedEditors = getCellEditorInstanceMap(beans);
  const cellValidationModel = new EditCellValidationModel();
  const { ariaAnnounce, localeSvc, editModelSvc, gos } = beans;
  const includeRows = gos.get("editType") === "fullRow";
  const translate = _getLocaleTextFunc(localeSvc);
  const ariaValidationErrorPrefix = translate("ariaValidationErrorPrefix", "Cell Editor Validation");
  for (const mappedEditor of mappedEditors) {
    const { ctrl, editor } = mappedEditor;
    const { rowNode, column } = ctrl;
    const errorMessages = editor.getValidationErrors?.() ?? [];
    const el = editor.getValidationElement?.(false) || !editor.isPopup?.() && ctrl.eGui;
    if (el) {
      const isInvalid = errorMessages != null && errorMessages.length > 0;
      const invalidMessage = isInvalid ? errorMessages.join(". ") : "";
      _setAriaInvalid(el, isInvalid);
      if (isInvalid) {
        ariaAnnounce.announceValue(`${ariaValidationErrorPrefix} ${errorMessages}`, "editorValidation");
      }
      if (el instanceof HTMLInputElement) {
        el.setCustomValidity(invalidMessage);
      } else {
        el.classList.toggle("invalid", isInvalid);
      }
    }
    if (errorMessages?.length > 0) {
      cellValidationModel.setCellValidation(
        {
          rowNode,
          column
        },
        {
          errorMessages
        }
      );
    }
  }
  _syncFromEditors(beans, false);
  editModelSvc?.setCellValidationModel(cellValidationModel);
  const rowCtrlSet = /* @__PURE__ */ new Set();
  for (const { ctrl } of mappedEditors) {
    rowCtrlSet.add(ctrl.rowCtrl);
  }
  if (includeRows) {
    const rowValidations = _generateRowValidationErrors(beans);
    editModelSvc?.setRowValidationModel(rowValidations);
  }
  for (const rowCtrl of rowCtrlSet.values()) {
    rowCtrl.rowEditStyleFeature?.applyRowStyles();
    for (const cellCtrl of rowCtrl.getAllCellCtrls()) {
      cellCtrl.tooltipFeature?.refreshTooltip(true);
      cellCtrl.editorTooltipFeature?.refreshTooltip(true);
      cellCtrl.editStyleFeature?.applyCellStyles?.();
    }
  }
}
var _generateRowValidationErrors = (beans) => {
  const rowValidationModel = new EditRowValidationModel();
  const getFullRowEditValidationErrors = beans.gos.get("getFullRowEditValidationErrors");
  const editMap = beans.editModelSvc?.getEditMap();
  if (!editMap) {
    return rowValidationModel;
  }
  for (const rowNode of editMap.keys()) {
    const rowEditMap = editMap.get(rowNode);
    if (!rowEditMap) {
      continue;
    }
    const editorsState = [];
    const { rowIndex, rowPinned } = rowNode;
    for (const column of rowEditMap.keys()) {
      const editValue = rowEditMap.get(column);
      if (!editValue) {
        continue;
      }
      const { editorValue, pendingValue, sourceValue } = editValue;
      const newValue = editorValue ?? (pendingValue === UNEDITED ? void 0 : pendingValue) ?? sourceValue;
      editorsState.push({
        column,
        colId: column.getColId(),
        rowIndex,
        rowPinned,
        oldValue: sourceValue,
        newValue
      });
    }
    const errorMessages = getFullRowEditValidationErrors?.({ editorsState }) ?? [];
    if (errorMessages.length > 0) {
      rowValidationModel.setRowValidation(
        {
          rowNode
        },
        { errorMessages }
      );
    }
  }
  return rowValidationModel;
};
function _validateEdit(beans) {
  _populateModelValidationErrors(beans);
  const map = beans.editModelSvc?.getCellValidationModel().getCellValidationMap();
  if (!map) {
    return null;
  }
  const validations = [];
  map.forEach((rowValidations, rowNode) => {
    rowValidations.forEach(({ errorMessages }, column) => {
      validations.push({
        column,
        rowIndex: rowNode.rowIndex,
        rowPinned: rowNode.rowPinned,
        messages: errorMessages ?? null
      });
    });
  });
  return validations;
}

// packages/ag-grid-community/src/headerRendering/cells/cssClassApplier.ts
var CSS_FIRST_COLUMN = "ag-column-first";
var CSS_LAST_COLUMN = "ag-column-last";
function _getHeaderClassesFromColDef(abstractColDef, gos, column, columnGroup) {
  if (_missing(abstractColDef)) {
    return [];
  }
  return getColumnClassesFromCollDef(abstractColDef.headerClass, abstractColDef, gos, column, columnGroup);
}
function _getToolPanelClassesFromColDef(abstractColDef, gos, column, columnGroup) {
  if (_missing(abstractColDef)) {
    return [];
  }
  return getColumnClassesFromCollDef(abstractColDef.toolPanelClass, abstractColDef, gos, column, columnGroup);
}
function refreshFirstAndLastStyles(comp, column, presentedColsService) {
  comp.toggleCss(CSS_FIRST_COLUMN, presentedColsService.isColAtEdge(column, "first"));
  comp.toggleCss(CSS_LAST_COLUMN, presentedColsService.isColAtEdge(column, "last"));
}
function getClassParams(abstractColDef, gos, column, columnGroup) {
  return _addGridCommonParams(gos, {
    // bad naming, as colDef here can be a group or a column,
    // however most people won't appreciate the difference,
    // so keeping it as colDef to avoid confusion.
    colDef: abstractColDef,
    column,
    columnGroup
  });
}
function getColumnClassesFromCollDef(classesOrFunc, abstractColDef, gos, column, columnGroup) {
  if (_missing(classesOrFunc)) {
    return [];
  }
  let classToUse;
  if (typeof classesOrFunc === "function") {
    const params = getClassParams(abstractColDef, gos, column, columnGroup);
    classToUse = classesOrFunc(params);
  } else {
    classToUse = classesOrFunc;
  }
  if (typeof classToUse === "string") {
    return [classToUse];
  }
  if (Array.isArray(classToUse)) {
    return [...classToUse];
  }
  return [];
}

// packages/ag-grid-community/src/pinnedRowModel/pinnedRowUtils.ts
function _isManualPinnedRow(rowNode) {
  return !!(rowNode.rowPinned && rowNode.pinnedSibling);
}
function _getNodesInRangeForSelection(rowModel, float, start, end) {
  const isTop = float === "top";
  if (!start) {
    return _getNodesInRangeForSelection(
      rowModel,
      float,
      isTop ? rowModel.getPinnedTopRow(0) : rowModel.getPinnedBottomRow(0),
      end
    );
  }
  if (!end) {
    const count = isTop ? rowModel.getPinnedTopRowCount() : rowModel.getPinnedBottomRowCount();
    return _getNodesInRangeForSelection(
      rowModel,
      float,
      start,
      isTop ? rowModel.getPinnedTopRow(count - 1) : rowModel.getPinnedBottomRow(count - 1)
    );
  }
  let started = false;
  let finished = false;
  const range = [];
  rowModel.forEachPinnedRow(float, (node) => {
    if (node === start && !started) {
      started = true;
      range.push(node);
      return;
    }
    if (started && node === end) {
      finished = true;
      range.push(node);
      return;
    }
    if (started && !finished) {
      range.push(node);
    }
  });
  return range;
}

// packages/ag-grid-community/src/constants/keyCode.ts
var KeyCode = {
  BACKSPACE: "Backspace",
  TAB: "Tab",
  ENTER: "Enter",
  ESCAPE: "Escape",
  SPACE: " ",
  LEFT: "ArrowLeft",
  UP: "ArrowUp",
  RIGHT: "ArrowRight",
  DOWN: "ArrowDown",
  DELETE: "Delete",
  F2: "F2",
  PAGE_UP: "PageUp",
  PAGE_DOWN: "PageDown",
  PAGE_HOME: "Home",
  PAGE_END: "End",
  // these should be used with `event.code` instead of `event.key`
  // as `event.key` changes when non-latin keyboards are used
  A: "KeyA",
  C: "KeyC",
  D: "KeyD",
  V: "KeyV",
  X: "KeyX",
  Y: "KeyY",
  Z: "KeyZ"
};

// packages/ag-grid-community/src/utils/focus.ts
var keyboardModeActive = false;
var instanceCount = 0;
function addKeyboardModeEvents(doc) {
  if (instanceCount > 0) {
    return;
  }
  doc.addEventListener("keydown", toggleKeyboardMode);
  doc.addEventListener("mousedown", toggleKeyboardMode);
}
function removeKeyboardModeEvents(doc) {
  if (instanceCount > 0)
    return;
  doc.removeEventListener("keydown", toggleKeyboardMode);
  doc.removeEventListener("mousedown", toggleKeyboardMode);
}
function toggleKeyboardMode(event) {
  const isKeyboardActive = keyboardModeActive;
  const isKeyboardEvent = event.type === "keydown";
  if (isKeyboardEvent) {
    if (event.ctrlKey || event.metaKey || event.altKey) {
      return;
    }
  }
  if (isKeyboardActive === isKeyboardEvent) {
    return;
  }
  keyboardModeActive = isKeyboardEvent;
}
function _registerKeyboardFocusEvents(beans) {
  const eDocument = _getDocument(beans);
  addKeyboardModeEvents(eDocument);
  instanceCount++;
  return () => {
    instanceCount--;
    removeKeyboardModeEvents(eDocument);
  };
}
function _isKeyboardMode() {
  return keyboardModeActive;
}
function _addFocusableContainerListener(beans, comp, eGui) {
  comp.addManagedElementListeners(eGui, {
    keydown: (e) => {
      if (!e.defaultPrevented && e.key === KeyCode.TAB) {
        const backwards = e.shiftKey;
        if (!_findNextFocusableElement(beans, eGui, false, backwards)) {
          if (_focusNextGridCoreContainer(beans, backwards)) {
            e.preventDefault();
          }
        }
      }
    }
  });
}
function _findFocusableElements(rootNode, exclude, onlyUnmanaged = false) {
  const focusableString = FOCUSABLE_SELECTOR;
  let excludeString = FOCUSABLE_EXCLUDE;
  if (exclude) {
    excludeString += ", " + exclude;
  }
  if (onlyUnmanaged) {
    excludeString += ', [tabindex="-1"]';
  }
  const nodes = Array.prototype.slice.apply(rootNode.querySelectorAll(focusableString)).filter((node) => {
    return _isVisible(node);
  });
  const excludeNodes = Array.prototype.slice.apply(rootNode.querySelectorAll(excludeString));
  if (!excludeNodes.length) {
    return nodes;
  }
  const diff = (a, b) => a.filter((element) => b.indexOf(element) === -1);
  return diff(nodes, excludeNodes);
}
function _focusInto(rootNode, up = false, onlyUnmanaged = false, excludeTabGuards = false) {
  const focusableElements = _findFocusableElements(
    rootNode,
    excludeTabGuards ? ".ag-tab-guard" : null,
    onlyUnmanaged
  );
  const toFocus = up ? _last(focusableElements) : focusableElements[0];
  if (toFocus) {
    toFocus.focus({ preventScroll: true });
    return true;
  }
  return false;
}
function _findNextFocusableElement(beans, rootNode, onlyManaged, backwards) {
  const focusable = _findFocusableElements(rootNode, onlyManaged ? ':not([tabindex="-1"])' : null);
  const activeEl = _getActiveDomElement(beans);
  let currentIndex;
  if (onlyManaged) {
    currentIndex = focusable.findIndex((el) => el.contains(activeEl));
  } else {
    currentIndex = focusable.indexOf(activeEl);
  }
  const nextIndex = currentIndex + (backwards ? -1 : 1);
  if (nextIndex < 0 || nextIndex >= focusable.length) {
    return null;
  }
  return focusable[nextIndex];
}
function _findTabbableParent(node, limit = 5) {
  let counter = 0;
  while (node && _getTabIndex(node) === null && ++counter <= limit) {
    node = node.parentElement;
  }
  if (_getTabIndex(node) === null) {
    return null;
  }
  return node;
}
function _focusGridInnerElement(beans, fromBottom) {
  return beans.ctrlsSvc.get("gridCtrl").focusInnerElement(fromBottom);
}
function _isHeaderFocusSuppressed(beans) {
  return beans.gos.get("suppressHeaderFocus") || !!beans.overlays?.isExclusive();
}
function _isCellFocusSuppressed(beans) {
  return beans.gos.get("suppressCellFocus") || !!beans.overlays?.isExclusive();
}
function _focusNextGridCoreContainer(beans, backwards, forceOut = false) {
  const gridCtrl = beans.ctrlsSvc.get("gridCtrl");
  if (!forceOut && gridCtrl.focusNextInnerContainer(backwards)) {
    return true;
  }
  if (forceOut || !backwards && !gridCtrl.isDetailGrid()) {
    gridCtrl.forceFocusOutOfContainer(backwards);
  }
  return false;
}

// packages/ag-grid-community/src/rendering/cell/cellEvent.ts
function _createCellEvent(beans, domEvent, eventType, { rowNode, column }, value) {
  const event = _addGridCommonParams(beans.gos, {
    type: eventType,
    node: rowNode,
    data: rowNode.data,
    value,
    column,
    colDef: column.getColDef(),
    rowPinned: rowNode.rowPinned,
    event: domEvent,
    rowIndex: rowNode.rowIndex
  });
  return event;
}

// packages/ag-grid-community/src/rendering/cell/cellKeyboardListenerFeature.ts
function _isDeleteKey(key, alwaysReturnFalseOnBackspace = false) {
  if (key === KeyCode.DELETE) {
    return true;
  }
  if (!alwaysReturnFalseOnBackspace && key === KeyCode.BACKSPACE) {
    return _isMacOsUserAgent();
  }
  return false;
}
var CellKeyboardListenerFeature = class extends BeanStub {
  constructor(cellCtrl, beans, rowNode, rowCtrl) {
    super();
    this.cellCtrl = cellCtrl;
    this.rowNode = rowNode;
    this.rowCtrl = rowCtrl;
    this.beans = beans;
  }
  init() {
    this.eGui = this.cellCtrl.eGui;
  }
  onKeyDown(event) {
    const key = event.key;
    switch (key) {
      case KeyCode.ENTER:
        this.onEnterKeyDown(event);
        break;
      case KeyCode.F2:
        this.onF2KeyDown(event);
        break;
      case KeyCode.ESCAPE:
        this.onEscapeKeyDown(event);
        break;
      case KeyCode.TAB:
        this.onTabKeyDown(event);
        break;
      case KeyCode.BACKSPACE:
      case KeyCode.DELETE:
        this.onBackspaceOrDeleteKeyDown(key, event);
        break;
      case KeyCode.DOWN:
      case KeyCode.UP:
      case KeyCode.RIGHT:
      case KeyCode.LEFT:
        this.onNavigationKeyDown(event, key);
        break;
    }
  }
  onNavigationKeyDown(event, key) {
    const { cellCtrl, beans } = this;
    if (beans.editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
      return;
    }
    if (event.shiftKey && cellCtrl.isRangeSelectionEnabled()) {
      this.onShiftRangeSelect(event);
    } else {
      const currentCellPosition = cellCtrl.getFocusedCellPosition();
      beans.navigation?.navigateToNextCell(event, key, currentCellPosition, true);
    }
    event.preventDefault();
  }
  onShiftRangeSelect(event) {
    const { rangeSvc, navigation } = this.beans;
    if (!rangeSvc) {
      return;
    }
    const endCell = rangeSvc.extendLatestRangeInDirection(event);
    if (!endCell) {
      return;
    }
    if (event.key === KeyCode.LEFT || event.key === KeyCode.RIGHT) {
      navigation?.ensureColumnVisible(endCell.column);
    } else {
      navigation?.ensureRowVisible(endCell.rowIndex);
    }
  }
  onTabKeyDown(event) {
    this.beans.navigation?.onTabKeyDown(this.cellCtrl, event);
  }
  onBackspaceOrDeleteKeyDown(key, event) {
    const { cellCtrl, beans, rowNode } = this;
    const { gos, rangeSvc, eventSvc, editSvc } = beans;
    eventSvc.dispatchEvent({ type: "keyShortcutChangedCellStart" });
    if (_isDeleteKey(key, gos.get("enableCellEditingOnBackspace")) && !editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
      if (rangeSvc && _isCellSelectionEnabled(gos)) {
        rangeSvc.clearCellRangeCellValues({ dispatchWrapperEvents: true, wrapperEventSource: "deleteKey" });
      } else if (cellCtrl.isCellEditable()) {
        const { column } = cellCtrl;
        const emptyValue = this.beans.valueSvc.getDeleteValue(column, rowNode);
        rowNode.setDataValue(column, emptyValue, "cellClear");
      }
    } else if (!editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
      beans.editSvc?.startEditing(cellCtrl, { startedEdit: true, event });
    }
    eventSvc.dispatchEvent({ type: "keyShortcutChangedCellEnd" });
  }
  onEnterKeyDown(event) {
    const { cellCtrl, beans } = this;
    const { editSvc, navigation } = beans;
    const cellEditing = editSvc?.isEditing(cellCtrl);
    const rowNode = cellCtrl.rowNode;
    const rowEditing = editSvc?.isRowEditing(rowNode);
    const startEditingAction = (cellCtrl2) => {
      const started = editSvc?.startEditing(cellCtrl2, {
        startedEdit: true,
        event
      });
      if (started) {
        event.preventDefault();
      }
    };
    if (cellEditing || rowEditing) {
      if (this.isCtrlEnter(event)) {
        editSvc?.applyBulkEdit(cellCtrl, beans?.rangeSvc?.getCellRanges() || []);
        return;
      }
      _populateModelValidationErrors(beans);
      if (editSvc?.checkNavWithValidation(void 0, event) === "block-stop") {
        return;
      }
      if (editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
        editSvc?.stopEditing(cellCtrl, {
          event
        });
      } else if (rowEditing && !cellCtrl.isCellEditable()) {
        editSvc?.stopEditing({ rowNode }, { event });
      } else {
        startEditingAction(cellCtrl);
      }
    } else {
      if (beans.gos.get("enterNavigatesVertically")) {
        const key = event.shiftKey ? KeyCode.UP : KeyCode.DOWN;
        navigation?.navigateToNextCell(null, key, cellCtrl.cellPosition, false);
      } else {
        if (editSvc?.hasValidationErrors()) {
          return;
        }
        if (editSvc?.hasValidationErrors(cellCtrl)) {
          editSvc.revertSingleCellEdit(cellCtrl, true);
        }
        startEditingAction(cellCtrl);
      }
    }
  }
  isCtrlEnter(e) {
    return (e.ctrlKey || e.metaKey) && e.key === KeyCode.ENTER;
  }
  onF2KeyDown(event) {
    const {
      cellCtrl,
      beans: { editSvc }
    } = this;
    const editing = editSvc?.isEditing();
    if (editing) {
      _populateModelValidationErrors(this.beans);
      if (editSvc?.checkNavWithValidation(void 0, event) === "block-stop") {
        return;
      }
    }
    editSvc?.startEditing(cellCtrl, { startedEdit: true, event });
  }
  onEscapeKeyDown(event) {
    const {
      cellCtrl,
      beans: { editSvc }
    } = this;
    if (editSvc?.checkNavWithValidation(cellCtrl, event) === "block-stop") {
      editSvc.revertSingleCellEdit(cellCtrl);
    }
    editSvc?.stopEditing(cellCtrl, {
      event,
      cancel: true
    });
  }
  processCharacter(event) {
    const eventTarget = event.target;
    const eventOnChildComponent = eventTarget !== this.eGui;
    const {
      beans: { editSvc },
      cellCtrl
    } = this;
    if (eventOnChildComponent) {
      return;
    }
    if (editSvc?.isEditing(cellCtrl, { withOpenEditor: true })) {
      return;
    }
    const key = event.key;
    if (key === KeyCode.SPACE) {
      this.onSpaceKeyDown(event);
    } else if (editSvc?.isCellEditable(cellCtrl, "ui")) {
      if (editSvc?.hasValidationErrors() && !editSvc?.hasValidationErrors(cellCtrl)) {
        return;
      }
      editSvc?.startEditing(cellCtrl, { startedEdit: true, event, source: "api" });
      const compDetails = cellCtrl.editCompDetails;
      const shouldPreventDefault = !compDetails?.params?.suppressPreventDefault;
      if (shouldPreventDefault) {
        event.preventDefault();
      }
    }
  }
  onSpaceKeyDown(event) {
    const { gos, editSvc } = this.beans;
    const { rowNode } = this.cellCtrl;
    if (!editSvc?.isEditing(this.cellCtrl, { withOpenEditor: true }) && _isRowSelection(gos)) {
      this.beans.selectionSvc?.handleSelectionEvent(event, rowNode, "spaceKey");
    }
    event.preventDefault();
  }
};

// packages/ag-grid-community/src/utils/mouse.ts
function _areEventsNear(e1, e2, pixelCount) {
  if (pixelCount === 0) {
    return false;
  }
  const diffX = Math.abs(e1.clientX - e2.clientX);
  const diffY = Math.abs(e1.clientY - e2.clientY);
  return Math.max(diffX, diffY) <= pixelCount;
}
function _interpretAsRightClick({ gos }, event) {
  return event.button === 2 || event.ctrlKey && gos.get("allowContextMenuWithControlKey");
}

// packages/ag-grid-community/src/rendering/cell/cellMouseListenerFeature.ts
var CellMouseListenerFeature = class extends BeanStub {
  constructor(cellCtrl, beans, column) {
    super();
    this.cellCtrl = cellCtrl;
    this.column = column;
    this.beans = beans;
  }
  onMouseEvent(eventName, mouseEvent) {
    if (_isStopPropagationForAgGrid(mouseEvent)) {
      return;
    }
    switch (eventName) {
      case "click":
        this.onCellClicked(mouseEvent);
        break;
      case "mousedown":
      case "touchstart":
        this.onMouseDown(mouseEvent);
        break;
      case "dblclick":
        this.onCellDoubleClicked(mouseEvent);
        break;
      case "mouseout":
        this.onMouseOut(mouseEvent);
        break;
      case "mouseover":
        this.onMouseOver(mouseEvent);
        break;
    }
  }
  onCellClicked(event) {
    if (this.beans.touchSvc?.handleCellDoubleClick(this, event)) {
      return;
    }
    const { eventSvc, rangeSvc, editSvc, editModelSvc, frameworkOverrides } = this.beans;
    const isMultiKey = event.ctrlKey || event.metaKey;
    const { cellCtrl } = this;
    const { column, cellPosition } = cellCtrl;
    if (rangeSvc && isMultiKey) {
      if (rangeSvc.getCellRangeCount(cellPosition) > 1) {
        rangeSvc.intersectLastRange(true);
      }
    }
    const cellClickedEvent = cellCtrl.createEvent(event, "cellClicked");
    eventSvc.dispatchEvent(cellClickedEvent);
    const colDef = column.getColDef();
    if (colDef.onCellClicked) {
      window.setTimeout(() => {
        frameworkOverrides.wrapOutgoing(() => {
          colDef.onCellClicked(cellClickedEvent);
        });
      }, 0);
    }
    if (editModelSvc?.getState(cellCtrl) !== "editing") {
      const editing = editSvc?.isEditing();
      const cellValidations = editModelSvc?.getCellValidationModel().getCellValidationMap().size ?? 0;
      const rowValidations = editModelSvc?.getRowValidationModel().getRowValidationMap().size ?? 0;
      if (editing && (cellValidations > 0 || rowValidations > 0)) {
        return;
      }
      if (editSvc?.shouldStartEditing(cellCtrl, event)) {
        editSvc?.startEditing(cellCtrl, { event });
      } else if (editSvc?.shouldStopEditing(cellCtrl, event)) {
        editSvc?.stopEditing(cellCtrl);
      }
    }
  }
  onCellDoubleClicked(event) {
    const { column, beans, cellCtrl } = this;
    const { eventSvc, frameworkOverrides, editSvc, editModelSvc } = beans;
    const colDef = column.getColDef();
    const cellDoubleClickedEvent = cellCtrl.createEvent(event, "cellDoubleClicked");
    eventSvc.dispatchEvent(cellDoubleClickedEvent);
    if (typeof colDef.onCellDoubleClicked === "function") {
      window.setTimeout(() => {
        frameworkOverrides.wrapOutgoing(() => {
          colDef.onCellDoubleClicked(cellDoubleClickedEvent);
        });
      }, 0);
    }
    if (editSvc?.shouldStartEditing(this.cellCtrl, event) && this.beans.editModelSvc?.getState(this.cellCtrl) !== "editing") {
      const editing = editSvc?.isEditing();
      const cellValidations = editModelSvc?.getCellValidationModel().getCellValidationMap().size ?? 0;
      const rowValidations = editModelSvc?.getRowValidationModel().getRowValidationMap().size ?? 0;
      if (editing && (cellValidations > 0 || rowValidations > 0)) {
        return;
      }
      editSvc?.startEditing(cellCtrl, { event });
    }
  }
  onMouseDown(mouseEvent) {
    const { ctrlKey, metaKey, shiftKey } = mouseEvent;
    const target = mouseEvent.target;
    const { cellCtrl, beans } = this;
    const { eventSvc, rangeSvc, rowNumbersSvc, focusSvc, gos, editSvc } = beans;
    if (this.isRightClickInExistingRange(mouseEvent)) {
      return;
    }
    const hasRanges = rangeSvc && !rangeSvc.isEmpty();
    const containsWidget = this.containsWidget(target);
    const { cellPosition, column } = cellCtrl;
    const isRowNumberColumn = isRowNumberCol(column);
    if (rowNumbersSvc && isRowNumberColumn && !rowNumbersSvc.handleMouseDownOnCell(cellPosition, mouseEvent)) {
      if (rangeSvc) {
        mouseEvent.preventDefault();
      }
      mouseEvent.stopImmediatePropagation();
      return;
    }
    if (!shiftKey || !hasRanges) {
      const editing = editSvc?.isEditing(cellCtrl);
      const isEnableCellTextSelection = gos.get("enableCellTextSelection");
      const shouldFocus = isEnableCellTextSelection && mouseEvent.defaultPrevented;
      const forceBrowserFocus = (_isBrowserSafari() || shouldFocus) && !editing && !_isFocusableFormField(target) && !containsWidget;
      cellCtrl.focusCell(forceBrowserFocus, mouseEvent);
    }
    if (shiftKey && hasRanges && !focusSvc.isCellFocused(cellPosition)) {
      mouseEvent.preventDefault();
      const focusedCell = focusSvc.getFocusedCell();
      if (focusedCell) {
        const { column: column2, rowIndex, rowPinned } = focusedCell;
        if (editSvc?.isEditing(focusedCell)) {
          editSvc?.stopEditing(focusedCell);
        }
        focusSvc.setFocusedCell({
          column: column2,
          rowIndex,
          rowPinned,
          forceBrowserFocus: true,
          preventScrollOnBrowserFocus: true,
          sourceEvent: mouseEvent
        });
      }
    }
    if (containsWidget) {
      return;
    }
    if (rangeSvc) {
      if (isRowNumberColumn) {
        mouseEvent.preventDefault();
      }
      const hasRightClickedOnRowNumber = _interpretAsRightClick(this.beans, mouseEvent) && isRowNumberColumn;
      if (shiftKey) {
        rangeSvc.extendLatestRangeToCell(cellPosition);
      } else if (!hasRightClickedOnRowNumber) {
        const isMultiKey = ctrlKey || metaKey;
        rangeSvc.setRangeToCell(cellPosition, isMultiKey);
      }
    }
    eventSvc.dispatchEvent(this.cellCtrl.createEvent(mouseEvent, "cellMouseDown"));
  }
  isRightClickInExistingRange(mouseEvent) {
    const { rangeSvc } = this.beans;
    if (rangeSvc) {
      const cellInRange = rangeSvc.isCellInAnyRange(this.cellCtrl.cellPosition);
      const isRightClick = _interpretAsRightClick(this.beans, mouseEvent);
      if (cellInRange && isRightClick) {
        return true;
      }
    }
    return false;
  }
  containsWidget(target) {
    return _isElementChildOfClass(target, "ag-selection-checkbox", 3) || _isElementChildOfClass(target, "ag-drag-handle", 3);
  }
  onMouseOut(mouseEvent) {
    if (this.mouseStayingInsideCell(mouseEvent)) {
      return;
    }
    const { eventSvc, colHover } = this.beans;
    eventSvc.dispatchEvent(this.cellCtrl.createEvent(mouseEvent, "cellMouseOut"));
    colHover?.clearMouseOver();
  }
  onMouseOver(mouseEvent) {
    if (this.mouseStayingInsideCell(mouseEvent)) {
      return;
    }
    const { eventSvc, colHover } = this.beans;
    eventSvc.dispatchEvent(this.cellCtrl.createEvent(mouseEvent, "cellMouseOver"));
    colHover?.setMouseOver([this.column]);
  }
  mouseStayingInsideCell(e) {
    if (!e.target || !e.relatedTarget) {
      return false;
    }
    const eCell = this.cellCtrl.eGui;
    const cellContainsTarget = eCell.contains(e.target);
    const cellContainsRelatedTarget = eCell.contains(e.relatedTarget);
    return cellContainsTarget && cellContainsRelatedTarget;
  }
};

// packages/ag-grid-community/src/rendering/cell/cellPositionFeature.ts
var CellPositionFeature = class extends BeanStub {
  constructor(cellCtrl, beans) {
    super();
    this.cellCtrl = cellCtrl;
    this.beans = beans;
    this.column = cellCtrl.column;
    this.rowNode = cellCtrl.rowNode;
  }
  setupRowSpan() {
    this.rowSpan = this.column.getRowSpan(this.rowNode);
    this.addManagedListeners(this.beans.eventSvc, { newColumnsLoaded: () => this.onNewColumnsLoaded() });
  }
  init() {
    this.eSetLeft = this.cellCtrl.getRootElement();
    this.eContent = this.cellCtrl.eGui;
    const cellSpan = this.cellCtrl.getCellSpan();
    if (!cellSpan) {
      this.setupColSpan();
      this.setupRowSpan();
    }
    this.onLeftChanged();
    this.onWidthChanged();
    if (!cellSpan) {
      this._legacyApplyRowSpan();
    }
    if (cellSpan) {
      const refreshSpanHeight = this.refreshSpanHeight.bind(this, cellSpan);
      refreshSpanHeight();
      this.addManagedListeners(this.beans.eventSvc, {
        paginationChanged: refreshSpanHeight,
        recalculateRowBounds: refreshSpanHeight,
        pinnedHeightChanged: refreshSpanHeight
      });
    }
  }
  refreshSpanHeight(cellSpan) {
    const spanHeight = cellSpan.getCellHeight();
    if (spanHeight != null) {
      this.eContent.style.height = `${spanHeight}px`;
    }
  }
  onNewColumnsLoaded() {
    const rowSpan = this.column.getRowSpan(this.rowNode);
    if (this.rowSpan === rowSpan) {
      return;
    }
    this.rowSpan = rowSpan;
    this._legacyApplyRowSpan(true);
  }
  onDisplayColumnsChanged() {
    const colsSpanning = this.getColSpanningList();
    if (!_areEqual(this.colsSpanning, colsSpanning)) {
      this.colsSpanning = colsSpanning;
      this.onWidthChanged();
      this.onLeftChanged();
    }
  }
  setupColSpan() {
    if (this.column.getColDef().colSpan == null) {
      return;
    }
    this.colsSpanning = this.getColSpanningList();
    this.addManagedListeners(this.beans.eventSvc, {
      // because we are col spanning, a reorder of the cols can change what cols we are spanning over
      displayedColumnsChanged: this.onDisplayColumnsChanged.bind(this),
      // because we are spanning over multiple cols, we check for width any time any cols width changes.
      // this is expensive - really we should be explicitly checking only the cols we are spanning over
      // instead of every col, however it would be tricky code to track the cols we are spanning over, so
      // because hardly anyone will be using colSpan, am favouring this easier way for more maintainable code.
      displayedColumnsWidthChanged: this.onWidthChanged.bind(this)
    });
  }
  onWidthChanged() {
    if (!this.eContent) {
      return;
    }
    const width = this.getCellWidth();
    this.eContent.style.width = `${width}px`;
  }
  getCellWidth() {
    if (!this.colsSpanning) {
      return this.column.getActualWidth();
    }
    return this.colsSpanning.reduce((width, col) => width + col.getActualWidth(), 0);
  }
  getColSpanningList() {
    const { column, rowNode } = this;
    const colSpan = column.getColSpan(rowNode);
    const colsSpanning = [];
    if (colSpan === 1) {
      colsSpanning.push(column);
    } else {
      let pointer = column;
      const pinned = column.getPinned();
      for (let i = 0; pointer && i < colSpan; i++) {
        colsSpanning.push(pointer);
        pointer = this.beans.visibleCols.getColAfter(pointer);
        if (!pointer || _missing(pointer)) {
          break;
        }
        if (pinned !== pointer.getPinned()) {
          break;
        }
      }
    }
    return colsSpanning;
  }
  onLeftChanged() {
    if (!this.eSetLeft) {
      return;
    }
    const left = this.modifyLeftForPrintLayout(this.getCellLeft());
    this.eSetLeft.style.left = left + "px";
  }
  getCellLeft() {
    let mostLeftCol;
    if (this.beans.gos.get("enableRtl") && this.colsSpanning) {
      mostLeftCol = _last(this.colsSpanning);
    } else {
      mostLeftCol = this.column;
    }
    return mostLeftCol.getLeft();
  }
  modifyLeftForPrintLayout(leftPosition) {
    if (!this.cellCtrl.printLayout || this.column.getPinned() === "left") {
      return leftPosition;
    }
    const { visibleCols } = this.beans;
    const leftWidth = visibleCols.getColsLeftWidth();
    if (this.column.getPinned() === "right") {
      const bodyWidth = visibleCols.bodyWidth;
      return leftWidth + bodyWidth + (leftPosition || 0);
    }
    return leftWidth + (leftPosition || 0);
  }
  _legacyApplyRowSpan(force) {
    if (this.rowSpan === 1 && !force) {
      return;
    }
    const singleRowHeight = _getRowHeightAsNumber(this.beans);
    const totalRowHeight = singleRowHeight * this.rowSpan;
    this.eContent.style.height = `${totalRowHeight}px`;
    this.eContent.style.zIndex = "1";
  }
  // overriding to make public, as we don't dispose this bean via context
  destroy() {
    super.destroy();
  }
};

// packages/ag-grid-community/src/rendering/cell/cellCtrl.ts
var CSS_CELL = "ag-cell";
var CSS_AUTO_HEIGHT = "ag-cell-auto-height";
var CSS_NORMAL_HEIGHT = "ag-cell-normal-height";
var CSS_CELL_FOCUS = "ag-cell-focus";
var CSS_CELL_FIRST_RIGHT_PINNED = "ag-cell-first-right-pinned";
var CSS_CELL_LAST_LEFT_PINNED = "ag-cell-last-left-pinned";
var CSS_CELL_NOT_INLINE_EDITING = "ag-cell-not-inline-editing";
var CSS_CELL_WRAP_TEXT = "ag-cell-wrap-text";
var DOM_DATA_KEY_CELL_CTRL = "cellCtrl";
function _getCellCtrlForEventTarget(gos, eventTarget) {
  return _getCtrlForEventTarget(gos, eventTarget, DOM_DATA_KEY_CELL_CTRL);
}
var instanceIdSequence2 = 0;
var CellCtrl = class extends BeanStub {
  constructor(column, rowNode, beans, rowCtrl) {
    super();
    this.column = column;
    this.rowNode = rowNode;
    this.rowCtrl = rowCtrl;
    this.rangeFeature = void 0;
    this.rowResizeFeature = void 0;
    this.positionFeature = void 0;
    this.customStyleFeature = void 0;
    this.editStyleFeature = void 0;
    this.mouseListener = void 0;
    this.keyboardListener = void 0;
    this.suppressRefreshCell = false;
    this.onCompAttachedFuncs = [];
    this.onEditorAttachedFuncs = [];
    this.focusEventWhileNotReady = null;
    // if cell has been focused, check if it's focused when destroyed
    this.hasBeenFocused = false;
    this.hasEdit = false;
    this.tooltipFeature = void 0;
    this.editorTooltipFeature = void 0;
    this.beans = beans;
    this.gos = beans.gos;
    this.editSvc = beans.editSvc;
    this.hasEdit = !!beans.editSvc;
    const { colId } = column;
    this.instanceId = colId + "-" + instanceIdSequence2++;
    this.createCellPosition();
    this.updateAndFormatValue(false);
  }
  addFeatures() {
    const { beans } = this;
    this.positionFeature = new CellPositionFeature(this, beans);
    this.customStyleFeature = beans.cellStyles?.createCellCustomStyleFeature(this, beans);
    this.editStyleFeature = beans.editSvc?.createCellStyleFeature(this, beans);
    this.mouseListener = new CellMouseListenerFeature(this, beans, this.column);
    this.keyboardListener = new CellKeyboardListenerFeature(this, beans, this.rowNode, this.rowCtrl);
    this.enableTooltipFeature();
    const { rangeSvc } = beans;
    const cellSelectionEnabled = rangeSvc && _isCellSelectionEnabled(beans.gos);
    if (cellSelectionEnabled) {
      this.rangeFeature = rangeSvc.createCellRangeFeature(beans, this);
    }
    if (isRowNumberCol(this.column)) {
      this.rowResizeFeature = this.beans.rowNumbersSvc.createRowNumbersRowResizerFeature(beans, this);
    }
  }
  isCellSpanning() {
    return false;
  }
  getCellSpan() {
    return void 0;
  }
  removeFeatures() {
    const context = this.beans.context;
    this.positionFeature = context.destroyBean(this.positionFeature);
    this.editorTooltipFeature = context.destroyBean(this.editorTooltipFeature);
    this.customStyleFeature = context.destroyBean(this.customStyleFeature);
    this.editStyleFeature = context.destroyBean(this.editStyleFeature);
    this.mouseListener = context.destroyBean(this.mouseListener);
    this.keyboardListener = context.destroyBean(this.keyboardListener);
    this.rangeFeature = context.destroyBean(this.rangeFeature);
    this.rowResizeFeature = context.destroyBean(this.rowResizeFeature);
    this.disableTooltipFeature();
  }
  enableTooltipFeature(value, shouldDisplayTooltip) {
    this.tooltipFeature = this.beans.tooltipSvc?.enableCellTooltipFeature(this, value, shouldDisplayTooltip);
  }
  disableTooltipFeature() {
    this.tooltipFeature = this.beans.context.destroyBean(this.tooltipFeature);
  }
  enableEditorTooltipFeature(editor) {
    if (this.editorTooltipFeature) {
      this.disableEditorTooltipFeature();
    }
    this.editorTooltipFeature = this.beans.tooltipSvc?.setupCellEditorTooltip(this, editor);
    _populateModelValidationErrors(this.beans);
  }
  disableEditorTooltipFeature() {
    this.editorTooltipFeature = this.beans.context.destroyBean(this.editorTooltipFeature);
  }
  setComp(comp, eCell, _eWrapper, eCellWrapper, printLayout, startEditing, compBean) {
    this.comp = comp;
    this.eGui = eCell;
    this.printLayout = printLayout;
    compBean ?? (compBean = this);
    this.addDomData(compBean);
    this.addFeatures();
    compBean.addDestroyFunc(() => this.removeFeatures());
    this.onSuppressCellFocusChanged(this.beans.gos.get("suppressCellFocus"));
    this.setupFocus();
    this.applyStaticCssClasses();
    this.setWrapText();
    this.onFirstRightPinnedChanged();
    this.onLastLeftPinnedChanged();
    this.onColumnHover();
    this.setupControlComps();
    this.setupAutoHeight(eCellWrapper, compBean);
    this.refreshFirstAndLastStyles();
    this.refreshAriaColIndex();
    this.positionFeature?.init();
    this.customStyleFeature?.setComp(comp);
    this.editStyleFeature?.setComp(comp);
    this.tooltipFeature?.refreshTooltip();
    this.keyboardListener?.init();
    this.rangeFeature?.setComp(comp);
    this.rowResizeFeature?.refreshRowResizer();
    if (startEditing && this.isCellEditable()) {
      this.editSvc?.startEditing(this, { startedEdit: true, source: "api" });
    } else {
      this.showValue(false, true);
    }
    if (this.onCompAttachedFuncs.length) {
      this.onCompAttachedFuncs.forEach((func) => func());
      this.onCompAttachedFuncs = [];
    }
  }
  setupAutoHeight(eCellWrapper, compBean) {
    this.isAutoHeight = this.beans.rowAutoHeight?.setupCellAutoHeight(this, eCellWrapper, compBean) ?? false;
  }
  getCellAriaRole() {
    return this.column.getColDef().cellAriaRole ?? "gridcell";
  }
  isCellRenderer() {
    const colDef = this.column.getColDef();
    return colDef.cellRenderer != null || colDef.cellRendererSelector != null;
  }
  getValueToDisplay() {
    return this.valueFormatted ?? this.value;
  }
  getDeferLoadingCellRenderer() {
    const { beans, column } = this;
    const { userCompFactory, ctrlsSvc, eventSvc } = beans;
    const colDef = column.getColDef();
    const params = this.createCellRendererParams();
    params.deferRender = true;
    const loadingDetails = _getLoadingCellRendererDetails(userCompFactory, colDef, params);
    if (ctrlsSvc.getGridBodyCtrl()?.scrollFeature?.isScrolling()) {
      let resolver;
      const onReady = new AgPromise((resolve) => {
        resolver = resolve;
      });
      this.addManagedListeners(eventSvc, {
        bodyScrollEnd: () => resolver()
      });
      return { loadingComp: loadingDetails, onReady };
    }
    return { loadingComp: loadingDetails, onReady: AgPromise.resolve() };
  }
  showValue(forceNewCellRendererInstance, skipRangeHandleRefresh) {
    const { beans, column, rowNode, rangeFeature } = this;
    const { userCompFactory } = beans;
    let valueToDisplay = this.getValueToDisplay();
    let compDetails;
    const isSsrmLoading = rowNode.stub && rowNode.groupData?.[column.getId()] == null;
    const colDef = column.getColDef();
    if (isSsrmLoading || this.isCellRenderer()) {
      const params = this.createCellRendererParams();
      if (!isSsrmLoading || isRowNumberCol(column)) {
        compDetails = _getCellRendererDetails(userCompFactory, colDef, params);
      } else {
        compDetails = _getLoadingCellRendererDetails(userCompFactory, colDef, params);
      }
    }
    if (!compDetails && !isSsrmLoading && beans.findSvc?.isMatch(rowNode, column)) {
      const params = this.createCellRendererParams();
      compDetails = _getCellRendererDetails(
        userCompFactory,
        { ...column.getColDef(), cellRenderer: "agFindCellRenderer" },
        params
      );
    }
    if (this.hasEdit && this.editSvc.isBatchEditing() && this.editSvc.isRowEditing(rowNode, { checkSiblings: true })) {
      const result = this.editSvc.prepDetailsDuringBatch(this, { compDetails, valueToDisplay });
      if (result) {
        if (result.compDetails) {
          compDetails = result.compDetails;
        } else if (result.valueToDisplay) {
          valueToDisplay = result.valueToDisplay;
        }
      }
    }
    this.comp.setRenderDetails(compDetails, valueToDisplay, forceNewCellRendererInstance);
    if (!skipRangeHandleRefresh && rangeFeature) {
      _requestAnimationFrame(beans, () => rangeFeature?.refreshHandle());
    }
    this.rowResizeFeature?.refreshRowResizer();
  }
  setupControlComps() {
    const colDef = this.column.getColDef();
    this.includeSelection = this.isIncludeControl(this.isCheckboxSelection(colDef), true);
    this.includeRowDrag = this.isIncludeControl(colDef.rowDrag);
    this.includeDndSource = this.isIncludeControl(colDef.dndSource);
    this.comp.setIncludeSelection(this.includeSelection);
    this.comp.setIncludeDndSource(this.includeDndSource);
    this.comp.setIncludeRowDrag(this.includeRowDrag);
  }
  isForceWrapper() {
    return this.beans.gos.get("enableCellTextSelection") || this.column.isAutoHeight();
  }
  /**
   * Wrapper providing general conditions under which control elements (e.g. checkboxes and drag handles)
   * are rendered for a particular cell.
   * @param value Whether to render the control in the specific context of the caller
   * @param allowManuallyPinned Whether manually pinned rows are permitted this form of control element
   */
  // eslint-disable-next-line @typescript-eslint/ban-types
  isIncludeControl(value, allowManuallyPinned = false) {
    const rowUnpinned = this.rowNode.rowPinned == null;
    return (rowUnpinned || allowManuallyPinned && _isManualPinnedRow(this.rowNode)) && !!value;
  }
  isCheckboxSelection(colDef) {
    const { rowSelection, groupDisplayType } = this.beans.gridOptions;
    const checkboxLocation = _getCheckboxLocation(rowSelection);
    const isSelectionColumn = isColumnSelectionCol(this.column);
    if (groupDisplayType === "custom" && checkboxLocation !== "selectionColumn" && isSelectionColumn) {
      return false;
    }
    return colDef.checkboxSelection || isSelectionColumn && typeof rowSelection === "object" && _getCheckboxes(rowSelection);
  }
  refreshShouldDestroy() {
    const colDef = this.column.getColDef();
    const selectionChanged = this.includeSelection != this.isIncludeControl(this.isCheckboxSelection(colDef), true);
    const rowDragChanged = this.includeRowDrag != this.isIncludeControl(colDef.rowDrag);
    const dndSourceChanged = this.includeDndSource != this.isIncludeControl(colDef.dndSource);
    const autoHeightChanged = this.isAutoHeight != this.column.isAutoHeight();
    return selectionChanged || rowDragChanged || dndSourceChanged || autoHeightChanged;
  }
  onPopupEditorClosed() {
    const { editSvc } = this.beans;
    if (!editSvc?.isEditing(this, { withOpenEditor: true })) {
      return;
    }
    editSvc?.stopEditing(this, { source: editSvc?.isBatchEditing() ? "ui" : "api" });
  }
  /**
   * Ends the Cell Editing
   * @param cancel `True` if the edit process is being canceled.
   * @returns `True` if the value of the `GridCell` has been updated, otherwise `False`.
   */
  stopEditing(cancel = false) {
    const { editSvc } = this.beans;
    return editSvc?.stopEditing(this, { cancel, source: editSvc?.isBatchEditing() ? "ui" : "api" }) ?? false;
  }
  createCellRendererParams() {
    const {
      value,
      valueFormatted,
      column,
      rowNode,
      comp,
      eGui,
      beans: { valueSvc, gos, editSvc }
    } = this;
    const res = _addGridCommonParams(gos, {
      value,
      valueFormatted,
      getValue: () => valueSvc.getValueForDisplay(column, rowNode).value,
      setValue: (value2) => editSvc?.setDataValue({ rowNode, column }, value2) || valueSvc.setValue(rowNode, column, value2),
      formatValue: this.formatValue.bind(this),
      data: rowNode.data,
      node: rowNode,
      pinned: column.getPinned(),
      colDef: column.getColDef(),
      column,
      refreshCell: this.refreshCell.bind(this),
      eGridCell: eGui,
      eParentOfValue: comp.getParentOfValue(),
      registerRowDragger: (rowDraggerElement, dragStartPixels, value2, suppressVisibilityChange) => this.registerRowDragger(rowDraggerElement, dragStartPixels, suppressVisibilityChange),
      setTooltip: (value2, shouldDisplayTooltip) => {
        gos.assertModuleRegistered("Tooltip", 3);
        if (this.tooltipFeature) {
          this.disableTooltipFeature();
        }
        this.enableTooltipFeature(value2, shouldDisplayTooltip);
        this.tooltipFeature?.refreshTooltip();
      }
    });
    return res;
  }
  onCellChanged(event) {
    const eventImpactsThisCell = event.column === this.column;
    if (eventImpactsThisCell) {
      this.refreshCell({});
    }
  }
  refreshOrDestroyCell(params) {
    if (this.refreshShouldDestroy()) {
      this.rowCtrl?.recreateCell(this);
    } else {
      this.refreshCell(params);
    }
  }
  // + stop editing {force: true, suppressFlash: true}
  // + event cellChanged {}
  // + cellRenderer.params.refresh() {} -> method passes 'as is' to the cellRenderer, so params could be anything
  // + rowCtrl: event dataChanged {suppressFlash: !update, newData: !update}
  // + rowCtrl: api refreshCells() {animate: true/false}
  // + rowRenderer: api softRefreshView() {}
  refreshCell({ force, suppressFlash, newData } = {}) {
    if (this.suppressRefreshCell) {
      return;
    }
    const colDef = this.column.getColDef();
    const noValueProvided = colDef.field == null && colDef.valueGetter == null && colDef.showRowGroup == null;
    const forceRefresh = force || noValueProvided || newData;
    const isCellCompReady = !!this.comp;
    const valuesDifferent = this.updateAndFormatValue(isCellCompReady);
    const dataNeedsUpdating = forceRefresh || valuesDifferent;
    if (!isCellCompReady) {
      return;
    }
    if (dataNeedsUpdating) {
      this.showValue(!!newData, false);
      const processingFilterChange = this.beans.filterManager?.isSuppressFlashingCellsBecauseFiltering();
      const flashCell = !suppressFlash && !processingFilterChange && colDef.enableCellChangeFlash;
      if (flashCell) {
        this.beans.cellFlashSvc?.flashCell(this);
      }
      this.editStyleFeature?.applyCellStyles?.();
      this.customStyleFeature?.applyUserStyles();
      this.customStyleFeature?.applyClassesFromColDef();
    }
    this.tooltipFeature?.refreshTooltip();
    this.customStyleFeature?.applyCellClassRules();
  }
  isCellEditable() {
    return this.column.isCellEditable(this.rowNode);
  }
  formatValue(value) {
    return this.callValueFormatter(value) ?? value;
  }
  callValueFormatter(value) {
    return this.beans.valueSvc.formatValue(this.column, this.rowNode, value);
  }
  updateAndFormatValue(compareValues) {
    const oldValue = this.value;
    const oldValueFormatted = this.valueFormatted;
    const { value, valueFormatted } = this.beans.valueSvc.getValueForDisplay(this.column, this.rowNode, true);
    this.value = value;
    this.valueFormatted = valueFormatted;
    if (compareValues) {
      return !this.valuesAreEqual(oldValue, this.value) || this.valueFormatted != oldValueFormatted;
    }
    return true;
  }
  valuesAreEqual(val1, val2) {
    const colDef = this.column.getColDef();
    return colDef.equals ? colDef.equals(val1, val2) : val1 === val2;
  }
  addDomData(compBean) {
    const element = this.eGui;
    _setDomData(this.beans.gos, element, DOM_DATA_KEY_CELL_CTRL, this);
    compBean.addDestroyFunc(() => _setDomData(this.beans.gos, element, DOM_DATA_KEY_CELL_CTRL, null));
  }
  createEvent(domEvent, eventType) {
    const { rowNode, column, value, beans } = this;
    return _createCellEvent(beans, domEvent, eventType, { rowNode, column }, value);
  }
  processCharacter(event) {
    this.keyboardListener?.processCharacter(event);
  }
  onKeyDown(event) {
    this.keyboardListener?.onKeyDown(event);
  }
  onMouseEvent(eventName, mouseEvent) {
    this.mouseListener?.onMouseEvent(eventName, mouseEvent);
  }
  getColSpanningList() {
    return this.positionFeature?.getColSpanningList() ?? [];
  }
  onLeftChanged() {
    if (!this.comp) {
      return;
    }
    this.positionFeature?.onLeftChanged();
  }
  onDisplayedColumnsChanged() {
    if (!this.eGui) {
      return;
    }
    this.refreshAriaColIndex();
    this.refreshFirstAndLastStyles();
  }
  refreshFirstAndLastStyles() {
    const { comp, column, beans } = this;
    refreshFirstAndLastStyles(comp, column, beans.visibleCols);
  }
  refreshAriaColIndex() {
    const colIdx = this.beans.visibleCols.getAriaColIndex(this.column);
    _setAriaColIndex(this.eGui, colIdx);
  }
  onWidthChanged() {
    return this.positionFeature?.onWidthChanged();
  }
  getRowPosition() {
    const { rowIndex, rowPinned } = this.cellPosition;
    return {
      rowIndex,
      rowPinned
    };
  }
  updateRangeBordersIfRangeCount() {
    if (!this.comp) {
      return;
    }
    this.rangeFeature?.updateRangeBordersIfRangeCount();
  }
  onCellSelectionChanged() {
    if (!this.comp) {
      return;
    }
    this.rangeFeature?.onCellSelectionChanged();
  }
  isRangeSelectionEnabled() {
    return this.rangeFeature != null;
  }
  focusCell(forceBrowserFocus = false, sourceEvent) {
    const allowedTarget = this.editSvc?.allowedFocusTargetOnValidation(this);
    if (allowedTarget && allowedTarget !== this) {
      return;
    }
    this.beans.focusSvc.setFocusedCell({
      ...this.getFocusedCellPosition(),
      forceBrowserFocus,
      sourceEvent
    });
  }
  /**
   * Restores focus to the cell, if it should have it
   * @param waitForRender if the cell has just setComp, it may not be rendered yet, so we wait for the next render
   */
  restoreFocus(waitForRender = false) {
    const {
      beans: { editSvc, focusSvc },
      comp
    } = this;
    if (!comp || editSvc?.isEditing(this) || !this.isCellFocused() || !focusSvc.shouldTakeFocus()) {
      return;
    }
    const focus = () => {
      if (!this.isAlive()) {
        return;
      }
      const focusableElement = comp.getFocusableElement();
      if (this.isCellFocused()) {
        focusableElement.focus({ preventScroll: true });
      }
    };
    if (waitForRender) {
      setTimeout(focus, 0);
      return;
    }
    focus();
  }
  onRowIndexChanged() {
    this.createCellPosition();
    this.onCellFocused();
    this.restoreFocus();
    this.rangeFeature?.onCellSelectionChanged();
    this.rowResizeFeature?.refreshRowResizer();
  }
  onSuppressCellFocusChanged(suppressCellFocus) {
    const element = this.eGui;
    if (!element) {
      return;
    }
    if (isRowNumberCol(this.column)) {
      suppressCellFocus = true;
    }
    _addOrRemoveAttribute(element, "tabindex", suppressCellFocus ? void 0 : -1);
  }
  onFirstRightPinnedChanged() {
    if (!this.comp) {
      return;
    }
    const firstRightPinned = this.column.isFirstRightPinned();
    this.comp.toggleCss(CSS_CELL_FIRST_RIGHT_PINNED, firstRightPinned);
  }
  onLastLeftPinnedChanged() {
    if (!this.comp) {
      return;
    }
    const lastLeftPinned = this.column.isLastLeftPinned();
    this.comp.toggleCss(CSS_CELL_LAST_LEFT_PINNED, lastLeftPinned);
  }
  /**
   * Returns whether cell is focused by the focusSvc, overridden by spannedCellCtrl
   */
  checkCellFocused() {
    return this.beans.focusSvc.isCellFocused(this.cellPosition);
  }
  isCellFocused() {
    const isFocused = this.checkCellFocused();
    this.hasBeenFocused || (this.hasBeenFocused = isFocused);
    return isFocused;
  }
  setupFocus() {
    this.restoreFocus(true);
    this.onCellFocused(this.focusEventWhileNotReady ?? void 0);
  }
  onCellFocused(event) {
    const { beans } = this;
    if (_isCellFocusSuppressed(beans)) {
      return;
    }
    if (!this.comp) {
      if (event) {
        this.focusEventWhileNotReady = event;
      }
      return;
    }
    const cellFocused = this.isCellFocused();
    const editing = beans.editSvc?.isEditing(this) ?? false;
    this.comp.toggleCss(CSS_CELL_FOCUS, cellFocused);
    if (cellFocused && event && event.forceBrowserFocus) {
      let focusEl = this.comp.getFocusableElement();
      if (editing) {
        const focusableEls = _findFocusableElements(focusEl, null, true);
        if (focusableEls.length) {
          focusEl = focusableEls[0];
        }
      }
      focusEl.focus({ preventScroll: !!event.preventScrollOnBrowserFocus });
    }
    if (cellFocused) {
      this.rowCtrl.announceDescription();
    }
  }
  createCellPosition() {
    const { rowIndex, rowPinned } = this.rowNode;
    this.cellPosition = {
      rowIndex,
      rowPinned: _makeNull(rowPinned),
      column: this.column
    };
  }
  // CSS Classes that only get applied once, they never change
  applyStaticCssClasses() {
    const { comp } = this;
    comp.toggleCss(CSS_CELL, true);
    comp.toggleCss(CSS_CELL_NOT_INLINE_EDITING, true);
    const autoHeight = this.column.isAutoHeight() == true;
    comp.toggleCss(CSS_AUTO_HEIGHT, autoHeight);
    comp.toggleCss(CSS_NORMAL_HEIGHT, !autoHeight);
  }
  onColumnHover() {
    this.beans.colHover?.onCellColumnHover(this.column, this.comp);
  }
  onColDefChanged() {
    if (!this.comp) {
      return;
    }
    if (this.column.isTooltipEnabled()) {
      this.disableTooltipFeature();
      this.enableTooltipFeature();
    } else {
      this.disableTooltipFeature();
    }
    this.setWrapText();
    if (this.editSvc?.isEditing(this)) {
      this.editSvc?.handleColDefChanged(this);
    } else {
      this.refreshOrDestroyCell({ force: true, suppressFlash: true });
    }
  }
  setWrapText() {
    const value = this.column.getColDef().wrapText == true;
    this.comp.toggleCss(CSS_CELL_WRAP_TEXT, value);
  }
  dispatchCellContextMenuEvent(event) {
    const colDef = this.column.getColDef();
    const cellContextMenuEvent = this.createEvent(event, "cellContextMenu");
    const { beans } = this;
    beans.eventSvc.dispatchEvent(cellContextMenuEvent);
    if (colDef.onCellContextMenu) {
      window.setTimeout(() => {
        beans.frameworkOverrides.wrapOutgoing(() => {
          colDef.onCellContextMenu(cellContextMenuEvent);
        });
      }, 0);
    }
  }
  getCellRenderer() {
    return this.comp?.getCellRenderer() ?? null;
  }
  destroy() {
    this.onCompAttachedFuncs = [];
    this.onEditorAttachedFuncs = [];
    if (this.isCellFocused() && this.hasBrowserFocus()) {
      this.beans.focusSvc.attemptToRecoverFocus();
    }
    super.destroy();
  }
  hasBrowserFocus() {
    return this.eGui?.contains(_getActiveDomElement(this.beans)) ?? false;
  }
  createSelectionCheckbox() {
    const cbSelectionComponent = this.beans.selectionSvc?.createCheckboxSelectionComponent();
    if (!cbSelectionComponent) {
      return void 0;
    }
    this.beans.context.createBean(cbSelectionComponent);
    cbSelectionComponent.init({ rowNode: this.rowNode, column: this.column });
    return cbSelectionComponent;
  }
  createDndSource() {
    const dndSourceComp = this.beans.registry.createDynamicBean(
      "dndSourceComp",
      false,
      this.rowNode,
      this.column,
      this.eGui
    );
    if (dndSourceComp) {
      this.beans.context.createBean(dndSourceComp);
    }
    return dndSourceComp;
  }
  registerRowDragger(customElement, dragStartPixels, suppressVisibilityChange) {
    if (this.customRowDragComp) {
      this.customRowDragComp.setDragElement(customElement, dragStartPixels);
      return;
    }
    const newComp = this.createRowDragComp(customElement, dragStartPixels, suppressVisibilityChange);
    if (newComp) {
      this.customRowDragComp = newComp;
      this.addDestroyFunc(() => {
        this.beans.context.destroyBean(newComp);
        this.customRowDragComp = null;
      });
    }
  }
  createRowDragComp(customElement, dragStartPixels, suppressVisibilityChange) {
    const rowDragComp = this.beans.rowDragSvc?.createRowDragCompForCell(
      this.rowNode,
      this.column,
      () => this.value,
      customElement,
      dragStartPixels,
      suppressVisibilityChange
    );
    if (!rowDragComp) {
      return void 0;
    }
    this.beans.context.createBean(rowDragComp);
    return rowDragComp;
  }
  cellEditorAttached() {
    this.onEditorAttachedFuncs.forEach((func) => func());
    this.onEditorAttachedFuncs = [];
  }
  setFocusedCellPosition(_cellPosition) {
  }
  getFocusedCellPosition() {
    return this.cellPosition;
  }
  // used by spannedCellCtrl
  refreshAriaRowIndex() {
  }
  /**
   * Returns the root element of the cell, could be a span container rather than the cell element.
   * @returns The root element of the cell.
   */
  getRootElement() {
    return this.eGui;
  }
};

// packages/ag-grid-community/src/gridBodyComp/mouseEventUtils.ts
var GRID_DOM_KEY = "__ag_grid_instance";
function _stampTopLevelGridCompWithGridInstance(gos, eGridDiv) {
  eGridDiv[GRID_DOM_KEY] = gos.gridInstanceId;
}
function _isEventFromThisGrid(gos, event) {
  const res = _isElementInThisGrid(gos, event.target);
  return res;
}
function _isElementInThisGrid(gos, element) {
  let pointer = element;
  while (pointer) {
    const instanceId = pointer[GRID_DOM_KEY];
    if (_exists(instanceId)) {
      const eventFromThisGrid = instanceId === gos.gridInstanceId;
      return eventFromThisGrid;
    }
    pointer = pointer.parentElement;
  }
  return false;
}
function _getCellPositionForEvent(gos, event) {
  return _getCellCtrlForEventTarget(gos, event.target)?.getFocusedCellPosition() ?? null;
}
function _getNormalisedMousePosition(beans, event) {
  const gridPanelHasScrolls = _isDomLayout(beans.gos, "normal");
  const e = event;
  let x;
  let y;
  if (e.clientX != null || e.clientY != null) {
    x = e.clientX;
    y = e.clientY;
  } else {
    x = e.x;
    y = e.y;
  }
  const { pageFirstPixel } = beans.pageBounds.getCurrentPagePixelRange();
  y += pageFirstPixel;
  if (gridPanelHasScrolls) {
    const scrollFeature = beans.ctrlsSvc.getScrollFeature();
    const vRange = scrollFeature.getVScrollPosition();
    const hRange = scrollFeature.getHScrollPosition();
    x += hRange.left;
    y += vRange.top;
  }
  return { x, y };
}

// packages/ag-grid-community/src/dragAndDrop/dragAndDropService.ts
var DragSourceType = /* @__PURE__ */ ((DragSourceType2) => {
  DragSourceType2[DragSourceType2["ToolPanel"] = 0] = "ToolPanel";
  DragSourceType2[DragSourceType2["HeaderCell"] = 1] = "HeaderCell";
  DragSourceType2[DragSourceType2["RowDrag"] = 2] = "RowDrag";
  DragSourceType2[DragSourceType2["ChartPanel"] = 3] = "ChartPanel";
  DragSourceType2[DragSourceType2["AdvancedFilterBuilder"] = 4] = "AdvancedFilterBuilder";
  return DragSourceType2;
})(DragSourceType || {});
var DragAndDropService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "dragAndDrop";
    this.dragSourceAndParamsList = [];
    this.dropTargets = [];
  }
  wireBeans(beans) {
    this.ctrlsSvc = beans.ctrlsSvc;
    this.dragSvc = beans.dragSvc;
    this.environment = beans.environment;
    this.userCompFactory = beans.userCompFactory;
  }
  addDragSource(dragSource, allowTouch = false) {
    const params = {
      eElement: dragSource.eElement,
      dragStartPixels: dragSource.dragStartPixels,
      onDragStart: this.onDragStart.bind(this, dragSource),
      onDragStop: this.onDragStop.bind(this),
      onDragging: this.onDragging.bind(this),
      onDragCancel: this.onDragCancel.bind(this),
      includeTouch: allowTouch
    };
    this.dragSourceAndParamsList.push({ params, dragSource });
    this.dragSvc.addDragSource(params);
  }
  getDragAndDropImageComponent() {
    const { dragAndDropImageComp } = this;
    if (!dragAndDropImageComp || !dragAndDropImageComp.comp) {
      return null;
    }
    return dragAndDropImageComp.comp;
  }
  removeDragSource(dragSource) {
    const { dragSourceAndParamsList, dragSvc } = this;
    const sourceAndParams = dragSourceAndParamsList.find((item) => item.dragSource === dragSource);
    if (sourceAndParams) {
      dragSvc.removeDragSource(sourceAndParams.params);
      _removeFromArray(dragSourceAndParamsList, sourceAndParams);
    }
  }
  destroy() {
    const { dragSourceAndParamsList, dragSvc, dropTargets } = this;
    dragSourceAndParamsList.forEach((sourceAndParams) => dragSvc.removeDragSource(sourceAndParams.params));
    dragSourceAndParamsList.length = 0;
    dropTargets.length = 0;
    this.clearDragAndDropProperties();
    super.destroy();
  }
  nudge() {
    if (this.dragging) {
      this.onDragging(this.eventLastTime, true);
    }
  }
  onDragStart(dragSource, mouseEvent) {
    this.dragging = true;
    this.dragSource = dragSource;
    this.eventLastTime = mouseEvent;
    this.dragItem = dragSource.getDragItem();
    dragSource.onDragStarted?.();
    this.createDragAndDropImageComponent();
  }
  onDragStop(mouseEvent) {
    this.dragSource?.onDragStopped?.();
    const { lastDropTarget } = this;
    if (lastDropTarget?.onDragStop) {
      const draggingEvent = this.createDropTargetEvent(lastDropTarget, mouseEvent, null, null, false);
      lastDropTarget.onDragStop(draggingEvent);
    }
    this.clearDragAndDropProperties();
  }
  onDragCancel() {
    const { dragSource, lastDropTarget } = this;
    dragSource?.onDragCancelled?.();
    if (lastDropTarget?.onDragCancel) {
      lastDropTarget.onDragCancel(
        this.createDropTargetEvent(lastDropTarget, this.eventLastTime, null, null, false)
      );
    }
    this.clearDragAndDropProperties();
  }
  clearDragAndDropProperties() {
    this.eventLastTime = null;
    this.dragging = false;
    this.lastDropTarget = void 0;
    this.dragItem = null;
    this.dragSource = null;
    this.removeDragAndDropImageComponent();
  }
  onDragging(mouseEvent, fromNudge = false) {
    const hDirection = this.getHorizontalDirection(mouseEvent);
    const vDirection = this.getVerticalDirection(mouseEvent);
    this.eventLastTime = mouseEvent;
    this.positionDragAndDropImageComp(mouseEvent);
    const validDropTargets = this.dropTargets.filter((target) => this.isMouseOnDropTarget(mouseEvent, target));
    const dropTarget = this.findCurrentDropTarget(mouseEvent, validDropTargets);
    const { lastDropTarget, dragSource, dragAndDropImageComp, dragItem } = this;
    if (dropTarget !== lastDropTarget) {
      this.leaveLastTargetIfExists(mouseEvent, hDirection, vDirection, fromNudge);
      if (lastDropTarget !== null && dropTarget === null) {
        dragSource?.onGridExit?.(dragItem);
      }
      if (lastDropTarget === null && dropTarget !== null) {
        dragSource?.onGridEnter?.(dragItem);
      }
      this.enterDragTargetIfExists(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
      if (dropTarget && dragAndDropImageComp) {
        const { comp, promise } = dragAndDropImageComp;
        if (comp) {
          comp.setIcon(dropTarget.getIconName ? dropTarget.getIconName() : null, false);
        } else {
          promise.then((resolvedComponent) => {
            if (resolvedComponent) {
              resolvedComponent.setIcon(dropTarget.getIconName ? dropTarget.getIconName() : null, false);
            }
          });
        }
      }
      this.lastDropTarget = dropTarget;
    } else if (dropTarget && dropTarget.onDragging) {
      const draggingEvent = this.createDropTargetEvent(dropTarget, mouseEvent, hDirection, vDirection, fromNudge);
      dropTarget.onDragging(draggingEvent);
    }
  }
  getAllContainersFromDropTarget(dropTarget) {
    const secondaryContainers = dropTarget.getSecondaryContainers ? dropTarget.getSecondaryContainers() : null;
    const containers = [[dropTarget.getContainer()]];
    return secondaryContainers ? containers.concat(secondaryContainers) : containers;
  }
  // checks if the mouse is on the drop target. it checks eContainer and eSecondaryContainers
  isMouseOnDropTarget(mouseEvent, dropTarget) {
    const allContainersFromDropTarget = this.getAllContainersFromDropTarget(dropTarget);
    let mouseOverTarget = false;
    const allContainersIntersect = (mouseEvent2, containers) => {
      for (const container of containers) {
        const { width, height, left, right, top, bottom } = container.getBoundingClientRect();
        if (width === 0 || height === 0) {
          return false;
        }
        const horizontalFit = mouseEvent2.clientX >= left && mouseEvent2.clientX < right;
        const verticalFit = mouseEvent2.clientY >= top && mouseEvent2.clientY < bottom;
        if (!horizontalFit || !verticalFit) {
          return false;
        }
      }
      return true;
    };
    for (const currentContainers of allContainersFromDropTarget) {
      if (allContainersIntersect(mouseEvent, currentContainers)) {
        mouseOverTarget = true;
        break;
      }
    }
    const { eElement, type } = this.dragSource;
    if (dropTarget.targetContainsSource && !dropTarget.getContainer().contains(eElement)) {
      return false;
    }
    return mouseOverTarget && dropTarget.isInterestedIn(type, eElement);
  }
  findCurrentDropTarget(mouseEvent, validDropTargets) {
    const len = validDropTargets.length;
    if (len === 0) {
      return null;
    }
    if (len === 1) {
      return validDropTargets[0];
    }
    const rootNode = _getRootNode(this.beans);
    const elementStack = rootNode.elementsFromPoint(mouseEvent.clientX, mouseEvent.clientY);
    for (const el of elementStack) {
      for (const dropTarget of validDropTargets) {
        const containers = this.getAllContainersFromDropTarget(dropTarget).flatMap((a) => a);
        if (containers.indexOf(el) !== -1) {
          return dropTarget;
        }
      }
    }
    return null;
  }
  enterDragTargetIfExists(dropTarget, mouseEvent, hDirection, vDirection, fromNudge) {
    if (!dropTarget) {
      return;
    }
    if (dropTarget.onDragEnter) {
      const dragEnterEvent = this.createDropTargetEvent(
        dropTarget,
        mouseEvent,
        hDirection,
        vDirection,
        fromNudge
      );
      dropTarget.onDragEnter(dragEnterEvent);
    }
  }
  leaveLastTargetIfExists(mouseEvent, hDirection, vDirection, fromNudge) {
    const { lastDropTarget } = this;
    if (!lastDropTarget) {
      return;
    }
    if (lastDropTarget.onDragLeave) {
      const dragLeaveEvent = this.createDropTargetEvent(
        lastDropTarget,
        mouseEvent,
        hDirection,
        vDirection,
        fromNudge
      );
      lastDropTarget.onDragLeave(dragLeaveEvent);
    }
    const dragAndDropImageComponent = this.getDragAndDropImageComponent();
    if (dragAndDropImageComponent) {
      dragAndDropImageComponent.setIcon(null, false);
    }
  }
  addDropTarget(dropTarget) {
    this.dropTargets.push(dropTarget);
  }
  removeDropTarget(dropTarget) {
    this.dropTargets = this.dropTargets.filter((target) => target.getContainer() !== dropTarget.getContainer());
  }
  hasExternalDropZones() {
    return this.dropTargets.some((zones) => zones.external);
  }
  findExternalZone(params) {
    const externalTargets = this.dropTargets.filter((target) => target.external);
    return externalTargets.find((zone) => zone.getContainer() === params.getContainer()) || null;
  }
  isDropZoneWithinThisGrid(draggingEvent) {
    const gridBodyCon = this.ctrlsSvc.getGridBodyCtrl();
    const gridGui = gridBodyCon.eGridBody;
    const { dropZoneTarget } = draggingEvent;
    return gridGui.contains(dropZoneTarget);
  }
  getHorizontalDirection(event) {
    const clientX = this.eventLastTime?.clientX;
    const eClientX = event.clientX;
    if (clientX === eClientX) {
      return null;
    }
    return clientX > eClientX ? "left" : "right";
  }
  getVerticalDirection(event) {
    const clientY = this.eventLastTime?.clientY;
    const eClientY = event.clientY;
    if (clientY === eClientY) {
      return null;
    }
    return clientY > eClientY ? "up" : "down";
  }
  createDropTargetEvent(dropTarget, event, hDirection, vDirection, fromNudge) {
    const dropZoneTarget = dropTarget.getContainer();
    const rect = dropZoneTarget.getBoundingClientRect();
    const { dragItem, dragSource, gos } = this;
    const x = event.clientX - rect.left;
    const y = event.clientY - rect.top;
    return _addGridCommonParams(gos, {
      event,
      x,
      y,
      vDirection,
      hDirection,
      dragSource,
      fromNudge,
      dragItem,
      dropZoneTarget
    });
  }
  positionDragAndDropImageComp(event) {
    const dragAndDropImageComponent = this.getDragAndDropImageComponent();
    if (!dragAndDropImageComponent) {
      return;
    }
    _anchorElementToMouseMoveEvent(dragAndDropImageComponent.getGui(), event, this.beans);
  }
  removeDragAndDropImageComponent() {
    const { dragAndDropImageComp } = this;
    if (dragAndDropImageComp) {
      const { comp } = dragAndDropImageComp;
      if (comp) {
        const eGui = comp.getGui();
        this.dragAndDropImageParent?.removeChild(eGui);
        this.destroyBean(comp);
      }
    }
    this.dragAndDropImageComp = null;
  }
  createDragAndDropImageComponent() {
    const { dragSource, gos, userCompFactory } = this;
    if (!dragSource) {
      return;
    }
    const userCompDetails = _getDragAndDropImageCompDetails(
      userCompFactory,
      _addGridCommonParams(gos, {
        dragSource
      })
    );
    if (!userCompDetails) {
      return;
    }
    const promise = userCompDetails.newAgStackInstance();
    this.dragAndDropImageComp = {
      promise
    };
    promise.then((comp) => {
      if (!comp || !this.isAlive()) {
        return;
      }
      this.processDragAndDropImageComponent(comp);
      this.dragAndDropImageComp.comp = comp;
    });
  }
  processDragAndDropImageComponent(dragAndDropImageComponent) {
    const { dragSource, environment } = this;
    if (!dragSource) {
      return;
    }
    const eGui = dragAndDropImageComponent.getGui();
    eGui.style.setProperty("position", "absolute");
    eGui.style.setProperty("z-index", "9999");
    _stampTopLevelGridCompWithGridInstance(this.gos, eGui);
    environment.applyThemeClasses(eGui);
    dragAndDropImageComponent.setIcon(null, false);
    let { dragItemName } = dragSource;
    if (typeof dragItemName === "function") {
      dragItemName = dragItemName();
    }
    dragAndDropImageComponent.setLabel(dragItemName || "");
    eGui.style.top = "20px";
    eGui.style.left = "20px";
    const targetEl = _getPageBody(this.beans);
    this.dragAndDropImageParent = targetEl;
    if (!targetEl) {
      _warn(54);
    } else {
      targetEl.appendChild(eGui);
    }
  }
  registerGridDropTarget(elementFn, ctrl) {
    const dropTarget = {
      getContainer: elementFn,
      isInterestedIn: (type) => type === 1 /* HeaderCell */ || type === 0 /* ToolPanel */,
      getIconName: () => "notAllowed"
    };
    this.addDropTarget(dropTarget);
    ctrl.addDestroyFunc(() => this.removeDropTarget(dropTarget));
  }
};

// packages/ag-grid-community/src/dragAndDrop/dragService.ts
var DragService = class extends BeanStub {
  constructor() {
    super(...arguments);
    this.beanName = "dragSvc";
    this.dragEndFunctions = [];
    this.dragSources = [];
  }
  destroy() {
    const { dragSources } = this;
    dragSources.forEach(this.removeListener.bind(this));
    dragSources.length = 0;
    super.destroy();
  }
  removeListener(dragSourceAndListener) {
    const element = dragSourceAndListener.dragSource.eElement;
    const mouseDownListener = dragSourceAndListener.mouseDownListener;
    element.removeEventListener("mousedown", mouseDownListener);
    if (dragSourceAndListener.touchEnabled) {
      const touchStartListener = dragSourceAndListener.touchStartListener;
      element.removeEventListener("touchstart", touchStartListener, { passive: true });
    }
  }
  removeDragSource(params) {
    const { dragSources } = this;
    const dragSourceAndListener = dragSources.find((item) => item.dragSource === params);
    if (!dragSourceAndListener) {
      return;
    }
    this.removeListener(dragSourceAndListener);
    _removeFromArray(dragSources, dragSourceAndListener);
  }
  addDragSource(params) {
    const mouseListener = this.onMouseDown.bind(this, params);
    const { eElement, includeTouch, stopPropagationForTouch } = params;
    eElement.addEventListener("mousedown", mouseListener);
    let touchListener = null;
    const suppressTouch = this.gos.get("suppressTouch");
    if (includeTouch && !suppressTouch) {
      touchListener = (touchEvent) => {
        if (_isFocusableFormField(touchEvent.target)) {
          return;
        }
        if (stopPropagationForTouch) {
          touchEvent.stopPropagation();
        }
        this.onTouchStart(params, touchEvent);
      };
      eElement.addEventListener("touchstart", touchListener, { passive: false });
    }
    this.dragSources.push({
      dragSource: params,
      mouseDownListener: mouseListener,
      touchStartListener: touchListener,
      touchEnabled: !!includeTouch
    });
  }
  // gets called whenever mouse down on any drag source
  onTouchStart(params, touchEvent) {
    this.currentDragParams = params;
    this.dragging = false;
    const touch = touchEvent.touches[0];
    this.touchLastTime = touch;
    this.touchStart = touch;
    const touchMoveEvent = (e) => this.onTouchMove(e, params.eElement);
    const touchEndEvent = (e) => this.onTouchUp(e, params.eElement);
    const documentTouchMove = (e) => {
      if (e.cancelable) {
        e.preventDefault();
      }
    };
    const target = touchEvent.target;
    const events = [
      // Prevents the page document from moving while we are dragging items around.
      // preventDefault needs to be called in the touchmove listener and never inside the
      // touchstart, because using touchstart causes the click event to be cancelled on touch devices.
      {
        target: _getRootNode(this.beans),
        type: "touchmove",
        listener: documentTouchMove,
        options: { passive: false }
      },
      { target, type: "touchmove", listener: touchMoveEvent, options: { passive: true } },
      { target, type: "touchend", listener: touchEndEvent, options: { passive: true } },
      { target, type: "touchcancel", listener: touchEndEvent, options: { passive: true } }
    ];
    this.addTemporaryEvents(events);
    if (params.dragStartPixels === 0) {
      this.onCommonMove(touch, this.touchStart, params.eElement);
    }
  }
  // gets called whenever mouse down on any drag source
  onMouseDown(params, mouseEvent) {
    const e = mouseEvent;
    if (params.skipMouseEvent && params.skipMouseEvent(mouseEvent)) {
      return;
    }
    if (e._alreadyProcessedByDragService) {
      return;
    }
    e._alreadyProcessedByDragService = true;
    if (mouseEvent.button !== 0) {
      return;
    }
    if (this.shouldPreventMouseEvent(mouseEvent)) {
      mouseEvent.preventDefault();
    }
    this.currentDragParams = params;
    this.dragging = false;
    this.mouseStartEvent = mouseEvent;
    this.startTarget = mouseEvent.target;
    const mouseMoveEvent = (event) => this.onMouseMove(event, params.eElement);
    const mouseUpEvent = (event) => this.onMouseUp(event, params.eElement);
    const contextEvent = (event) => event.preventDefault();
    const keydownEvent = (event) => {
      if (event.key === KeyCode.ESCAPE) {
        this.cancelDrag(params.eElement);
      }
    };
    const target = _getRootNode(this.beans);
    const events = [
      { target, type: "mousemove", listener: mouseMoveEvent },
      { target, type: "mouseup", listener: mouseUpEvent },
      { target, type: "contextmenu", listener: contextEvent },
      { target, type: "keydown", listener: keydownEvent }
    ];
    this.addTemporaryEvents(events);
    if (params.dragStartPixels === 0) {
      this.onMouseMove(mouseEvent, params.eElement);
    }
  }
  addTemporaryEvents(events) {
    events.forEach((currentEvent) => {
      const { target, type, listener, options } = currentEvent;
      target.addEventListener(type, listener, options);
    });
    this.dragEndFunctions.push(() => {
      events.forEach((currentEvent) => {
        const { target, type, listener, options } = currentEvent;
        target.removeEventListener(type, listener, options);
      });
    });
  }
  // returns true if the event is close to the original event by X pixels either vertically or horizontally.
  // we only start dragging after X pixels so this allows us to know if we should start dragging yet.
  isEventNearStartEvent(currentEvent, startEvent) {
    const { dragStartPixels } = this.currentDragParams;
    const requiredPixelDiff = _exists(dragStartPixels) ? dragStartPixels : 4;
    return _areEventsNear(currentEvent, startEvent, requiredPixelDiff);
  }
  getFirstActiveTouch(touchList) {
    for (let i = 0; i < touchList.length; i++) {
      if (touchList[i].identifier === this.touchStart.identifier) {
        return touchList[i];
      }
    }
    return null;
  }
  onCommonMove(currentEvent, startEvent, el) {
    if (!this.dragging) {
      if (this.isEventNearStartEvent(currentEvent, startEvent)) {
        return;
      }
      this.dragging = true;
      this.eventSvc.dispatchEvent({
        type: "dragStarted",
        target: el
      });
      this.currentDragParams.onDragStart(startEvent);
      if (!this.currentDragParams) {
        this.dragging = false;
        return;
      }
      this.currentDragParams.onDragging(startEvent);
    }
    this.currentDragParams?.onDragging(currentEvent);
  }
  onTouchMove(touchEvent, el) {
    const touch = this.getFirstActiveTouch(touchEvent.touches);
    if (!touch) {
      return;
    }
    this.onCommonMove(touch, this.touchStart, el);
  }
  // only gets called after a mouse down - as this is only added after mouseDown
  // and is removed when mouseUp happens
  onMouseMove(mouseEvent, el) {
    if (_isBrowserSafari()) {
      const eDocument = _getDocument(this.beans);
      eDocument.getSelection()?.removeAllRanges();
    }
    if (this.shouldPreventMouseEvent(mouseEvent)) {
      mouseEvent.preventDefault();
    }
    this.onCommonMove(mouseEvent, this.mouseStartEvent, el);
  }
  shouldPreventMouseEvent(mouseEvent) {
    const { gos } = this;
    const isEnableCellTextSelect = gos.get("enableCellTextSelection");
    const isMouseMove = mouseEvent.type === "mousemove";
    const isOverFormFieldElement = (mouseEvent2) => {
      const el = mouseEvent2.target;
      const tagName = el?.tagName.toLocaleLowerCase();
      return !!tagName?.match("^a$|textarea|input|select|button");
    };
    return (
      // when `isEnableCellTextSelect` is `true`, we need to preventDefault on mouseMove
      // to avoid the grid text being selected while dragging components.
      isEnableCellTextSelect && isMouseMove && mouseEvent.cancelable && _isEventFromThisGrid(gos, mouseEvent) && !isOverFormFieldElement(mouseEvent)
    );
  }
  onTouchUp(touchEvent, el) {
    let touch = this.getFirstActiveTouch(touchEvent.changedTouches);
    if (!touch) {
      touch = this.touchLastTime;
    }
    this.onUpCommon(touch, el);
  }
  onMouseUp(mouseEvent, el) {
    this.onUpCommon(mouseEvent, el);
  }
  onUpCommon(eventOrTouch, el) {
    if (this.dragging) {
      this.dragging = false;
      this.currentDragParams.onDragStop(eventOrTouch);
      this.eventSvc.dispatchEvent({
        type: "dragStopped",
        target: el
      });
    }
    this.resetDragProperties();
  }
  cancelDrag(el) {
    this.eventSvc.dispatchEvent({
      type: "dragCancelled",
      target: el
    });
    this.currentDragParams?.onDragCancel?.();
    this.resetDragProperties();
  }
  resetDragProperties() {
    this.mouseStartEvent = null;
    this.startTarget = null;
    this.touchStart = null;
    this.touchLastTime = null;
    this.currentDragParams = null;
    const { dragEndFunctions } = this;
    dragEndFunctions.forEach((func) => func());
    dragEndFunctions.length = 0;
  }
};

// packages/ag-grid-community/src/entities/agColumnGroup.ts
function createUniqueColumnGroupId(groupId, instanceId) {
  return groupId + "_" + instanceId;
}
function isColumnGroup(col) {
  return col instanceof AgColumnGroup;
}
var AgColumnGroup = class extends BeanStub {
  constructor(providedColumnGroup, groupId, partId, pinned) {
    super();
    this.providedColumnGroup = providedColumnGroup;
    this.groupId = groupId;
    this.partId = partId;
    this.pinned = pinned;
    this.isColumn = false;
    // depends on the open/closed state of the group, only displaying columns are stored here
    this.displayedChildren = [];
    // The measured height of this column's header when autoHeaderHeight is enabled
    this.autoHeaderHeight = null;
    this.parent = null;
  }
  // as the user is adding and removing columns, the groups are recalculated.
  // this reset clears out all children, ready for children to be added again
  reset() {
    this.parent = null;
    this.children = null;
    this.displayedChildren = null;
  }
  getParent() {
    return this.parent;
  }
  getUniqueId() {
    return createUniqueColumnGroupId(this.groupId, this.partId);
  }
  isEmptyGroup() {
    return this.displayedChildren.length === 0;
  }
  isMoving() {
    const allLeafColumns = this.getProvidedColumnGroup().getLeafColumns();
    if (!allLeafColumns || allLeafColumns.length === 0) {
      return false;
    }
    return allLeafColumns.every((col) => col.isMoving());
  }
  checkLeft() {
    this.displayedChildren.forEach((child) => {
      if (isColumnGroup(child)) {
        child.checkLeft();
      }
    });
    if (this.displayedChildren.length > 0) {
      if (this.gos.get("enableRtl")) {
        const lastChild = _last(this.displayedChildren);
        const lastChildLeft = lastChild.getLeft();
        this.setLeft(lastChildLeft);
      } else {
        const firstChildLeft = this.displayedChildren[0].getLeft();
        this.setLeft(firstChildLeft);
      }
    } else {
      this.setLeft(null);
    }
  }
  getLeft() {
    return this.left;
  }
  getOldLeft() {
    return this.oldLeft;
  }
  setLeft(left) {
    this.oldLeft = this.left;
    if (this.left !== left) {
      this.left = left;
      this.dispatchLocalEvent({ type: "leftChanged" });
    }
  }
  getPinned() {
    return this.pinned;
  }
  getGroupId() {
    return this.groupId;
  }
  getPartId() {
    return this.partId;
  }
  getActualWidth() {
    let groupActualWidth = 0;
    this.displayedChildren?.forEach((child) => {
      groupActualWidth += child.getActualWidth();
    });
    return groupActualWidth;
  }
  isResizable() {
    if (!this.displayedChildren) {
      return false;
    }
    let result = false;
    this.displayedChildren.forEach((child) => {
      if (child.isResizable()) {
        result = true;
      }
    });
    return result;
  }
  getMinWidth() {
    let result = 0;
    this.displayedChildren.forEach((groupChild) => {
      result += groupChild.getMinWidth();
    });
    return result;
  }
  addChild(child) {
    if (!this.children) {
      this.children = [];
    }
    this.children.push(child);
  }
  getDisplayedChildren() {
    return this.displayedChildren;
  }
  getLeafColumns() {
    const result = [];
    this.addLeafColumns(result);
    return result;
  }
  getDisplayedLeafColumns() {
    const result = [];
    this.addDisplayedLeafColumns(result);
    return result;
  }
  getDefinition() {
    return this.providedColumnGroup.getColGroupDef();
  }
  getColGroupDef() {
    return this.providedColumnGroup.getColGroupDef();
  }
  isPadding() {
    return this.providedColumnGroup.isPadding();
  }
  isExpandable() {
    return this.providedColumnGroup.isExpandable();
  }
  isExpanded() {
    return this.providedColumnGroup.isExpanded();
  }
  setExpanded(expanded) {
    this.providedColumnGroup.setExpanded(expanded);
  }
  isAutoHeaderHeight() {
    return !!this.getColGroupDef()?.autoHeaderHeight;
  }
  getAutoHeaderHeight() {
    return this.autoHeaderHeight;
  }
  /** Returns true if the header height has changed */
  setAutoHeaderHeight(height) {
    const changed = height !== this.autoHeaderHeight;
    this.autoHeaderHeight = height;
    return changed;
  }
  addDisplayedLeafColumns(leafColumns) {
    this.displayedChildren.forEach((child) => {
      if (isColumn(child)) {
        leafColumns.push(child);
      } else if (isColumnGroup(child)) {
        child.addDisplayedLeafColumns(leafColumns);
      }
    });
  }
  addLeafColumns(leafColumns) {
    this.children.forEach((child) => {
      if (isColumn(child)) {
        leafColumns.push(child);
      } else if (isColumnGroup(child)) {
        child.addLeafColumns(leafColumns);
      }
    });
  }
  getChildren() {
    return this.children;
  }
  getColumnGroupShow() {
    return this.providedColumnGroup.getColumnGroupShow();
  }
  getProvidedColumnGroup() {
    return this.providedColumnGroup;
  }
  getPaddingLevel() {
    const parent = this.getParent();
    if (!this.isPadding() || !parent || !parent.isPadding()) {
      return 0;
    }
    return 1 + parent.getPaddingLevel();
  }
  calculateDisplayedColumns() {
    this.displayedChildren = [];
    let parentWithExpansion = this;
    while (parentWithExpansion != null && parentWithExpansion.isPadding()) {
      parentWithExpansion = parentWithExpansion.getParent();
    }
    const isExpandable = parentWithExpansion ? parentWithExpansion.getProvidedColumnGroup().isExpandable() : false;
    if (!isExpandable) {
      this.displayedChildren = this.children;
      this.dispatchLocalEvent({ type: "displayedChildrenChanged" });
      return;
    }
    this.children.forEach((child) => {
      const emptyGroup = isColumnGroup(child) && !child.displayedChildren?.length;
      if (emptyGroup) {
        return;
      }
      const headerGroupShow = child.getColumnGroupShow();
      switch (headerGroupShow) {
        case "open":
          if (parentWithExpansion.getProvidedColumnGroup().isExpanded()) {
            this.displayedChildren.push(child);
          }
          break;
        case "closed":
          if (!parentWithExpansion.getProvidedColumnGroup().isExpanded()) {
            this.displayedChildren.push(child);
          }
          break;
        default:
          this.displayedChildren.push(child);
          break;
      }
    });
    this.dispatchLocalEvent({ type: "displayedChildrenChanged" });
  }
};

// packages/ag-grid-community/src/entities/rowNode.ts
var ROW_ID_PREFIX_ROW_GROUP = "row-group-";
var ROW_ID_PREFIX_TOP_PINNED = "t-";
var ROW_ID_PREFIX_BOTTOM_PINNED = "b-";
var OBJECT_ID_SEQUENCE = 0;
var RowNode = class {
  constructor(beans) {
    /** `true` if this row is a master row, part of master / detail (ie row can be expanded to show detail) */
    this.master = false;
    /** `true` if this row is a detail row, part of master / detail (ie child row of an expanded master row)*/
    this.detail = void 0;
    /** The current row index. If the row is filtered out or in a collapsed group, this value is set to `null`. */
    this.rowIndex = null;
    /** The key for the group eg Ireland, UK, USA */
    this.key = null;
    /**
     * The index of the row in the source rowData array including any updates via transactions.
     * It does not change when sorting, filtering, grouping, pivoting or any other UI related operations.
     * If this is a filler node (a visual row created by AG Grid in tree data or grouping) the value is set to `-1`.
     *
     * Generally readonly. It is modified only by:
     * - ClientSideNodeManager, cast to ClientSideNodeManagerRowNode
     * - ClientSideRowModel, cast to ClientSideRowModelRowNode
     */
    this.sourceRowIndex = -1;
    /** Children mapped by the pivot columns or group key */
    this.childrenMapped = null;
    /**
     * Parent RowNode for tree data.
     * When set, the parent node in the hierarchy is updated during Client-Side Row Model (CSRM) grouping.
     * Used by the ClientSideChildrenTreeNodeManager, TreeGroupStrategy, RowDragFeature
     */
    this.treeParent = null;
    /** The flags associated to this node. Used only internally within TreeGroupStrategy. */
    this.treeNodeFlags = 0;
    /**
     * This is `true` if the row has a rowIndex assigned, otherwise `false`.
     */
    this.displayed = false;
    /** The row top position in pixels. */
    this.rowTop = null;
    /** The top pixel for this row last time, makes sense if data set was ordered or filtered,
     * it is used so new rows can animate in from their old position. */
    this.oldRowTop = null;
    /** `true` by default - can be overridden via gridOptions.isRowSelectable(rowNode) */
    this.selectable = true;
    /**
     * Used by sorting service - to give deterministic sort to groups. Previously we
     * just id for this, however id is a string and had slower sorting compared to numbers.
     * If re-naming this property, you must also update `IGNORED_SIBLING_PROPERTIES`
     */
    this.__objectId = OBJECT_ID_SEQUENCE++;
    /** `true` when nodes with the same id are being removed and added as part of the same batch transaction */
    this.alreadyRendered = false;
    this.hovered = false;
    this.__selected = false;
    this.beans = beans;
  }
  /**
   * Replaces the data on the `rowNode`. When this method is called, the grid refreshes the entire rendered row if it is displayed.
   */
  setData(data) {
    this.setDataCommon(data, false);
  }
  // similar to setRowData, however it is expected that the data is the same data item. this
  // is intended to be used with Redux type stores, where the whole data can be changed. we are
  // guaranteed that the data is the same entity (so grid doesn't need to worry about the id of the
  // underlying data changing, hence doesn't need to worry about selection). the grid, upon receiving
  // dataChanged event, refreshes the cells rather than rip them all out (so user can show transitions).
  /**
   * Updates the data on the `rowNode`. When this method is called, the grid refreshes the entire rendered row if it is displayed.
   */
  updateData(data) {
    this.setDataCommon(data, true);
  }
  setDataCommon(data, update) {
    const { valueCache, eventSvc } = this.beans;
    const oldData = this.data;
    this.data = data;
    valueCache?.onDataChanged();
    this.updateDataOnDetailNode();
    this.resetQuickFilterAggregateText();
    const event = this.createDataChangedEvent(data, oldData, update);
    this.__localEventService?.dispatchEvent(event);
    if (this.sibling) {
      this.sibling.data = data;
      const event2 = this.sibling.createDataChangedEvent(data, oldData, update);
      this.sibling.__localEventService?.dispatchEvent(event2);
    }
    eventSvc.dispatchEvent({ type: "rowNodeDataChanged", node: this });
    const pinnedSibling = this.pinnedSibling;
    if (pinnedSibling) {
      pinnedSibling.data = data;
      pinnedSibling.__localEventService?.dispatchEvent(
        pinnedSibling.createDataChangedEvent(data, oldData, update)
      );
      eventSvc.dispatchEvent({ type: "rowNodeDataChanged", node: pinnedSibling });
    }
  }
  // when we are doing master / detail, the detail node is lazy created, but then kept around.
  // so if we show / hide the detail, the same detail rowNode is used. so we need to keep the data
  // in sync, otherwise expand/collapse of the detail would still show the old values.
  updateDataOnDetailNode() {
    if (this.detailNode) {
      this.detailNode.data = this.data;
    }
  }
  createDataChangedEvent(newData, oldData, update) {
    return {
      type: "dataChanged",
      node: this,
      oldData,
      newData,
      update
    };
  }
  getRowIndexString() {
    if (this.rowIndex == null) {
      _error(13);
      return null;
    }
    if (this.rowPinned === "top") {
      return ROW_ID_PREFIX_TOP_PINNED + this.rowIndex;
    }
    if (this.rowPinned === "bottom") {
      return ROW_ID_PREFIX_BOTTOM_PINNED + this.rowIndex;
    }
    return this.rowIndex.toString();
  }
  setDataAndId(data, id) {
    const { selectionSvc } = this.beans;
    const oldNode = selectionSvc?.createDaemonNode?.(this);
    const oldData = this.data;
    this.data = data;
    this.updateDataOnDetailNode();
    this.setId(id);
    if (selectionSvc) {
      selectionSvc.updateRowSelectable(this);
      selectionSvc.syncInRowNode(this, oldNode);
    }
    const event = this.createDataChangedEvent(data, oldData, false);
    this.__localEventService?.dispatchEvent(event);
  }
  setId(id) {
    const getRowIdFunc = _getRowIdCallback(this.beans.gos);
    if (getRowIdFunc) {
      if (this.data) {
        const parentKeys = this.parent?.getRoute() ?? [];
        this.id = getRowIdFunc({
          data: this.data,
          parentKeys: parentKeys.length > 0 ? parentKeys : void 0,
          level: this.level,
          rowPinned: this.rowPinned
        });
        if (this.id.startsWith(ROW_ID_PREFIX_ROW_GROUP)) {
          _error(14, {
            groupPrefix: ROW_ID_PREFIX_ROW_GROUP
          });
        }
      } else {
        this.id = void 0;
      }
    } else {
      this.id = id;
    }
  }
  setRowTop(rowTop) {
    this.oldRowTop = this.rowTop;
    if (this.rowTop === rowTop) {
      return;
    }
    this.rowTop = rowTop;
    this.dispatchRowEvent("topChanged");
    this.setDisplayed(rowTop !== null);
  }
  clearRowTopAndRowIndex() {
    this.oldRowTop = null;
    this.setRowTop(null);
    this.setRowIndex(null);
  }
  setHovered(hovered) {
    this.hovered = hovered;
  }
  isHovered() {
    return this.hovered;
  }
  /**
   * Sets the row height.
   * Call if you want to change the height initially assigned to the row.
   * After calling, you must call `api.onRowHeightChanged()` so the grid knows it needs to work out the placement of the rows. */
  setRowHeight(rowHeight, estimated = false) {
    this.rowHeight = rowHeight;
    this.rowHeightEstimated = estimated;
    this.dispatchRowEvent("heightChanged");
  }
  setExpanded(expanded, e, forceSync) {
    this.beans.expansionSvc?.setExpanded(this, expanded, e, forceSync);
  }
  /**
   * Replaces the value on the `rowNode` for the specified column. When complete,
   * the grid refreshes the rendered cell on the required row only.
   * **Note**: This method only fires `onCellEditRequest` when the Grid is in **Read Only** mode.
   * **Note**: This method defers to EditModule if available and batches the edit when `fullRow` or `batchEdit` is enabled.
   *
   * @param colKey The column where the value should be updated
   * @param newValue The new value
   * @param eventSource The source of the event
   * @returns `true` if the value was changed, otherwise `false`.
   */
  setDataValue(colKey, newValue, eventSource) {
    const { colModel, valueSvc, gos, editSvc } = this.beans;
    const column = typeof colKey !== "string" ? colKey : colModel.getCol(colKey) ?? colModel.getColDefCol(colKey);
    if (!column) {
      return false;
    }
    const oldValue = valueSvc.getValueForDisplay(column, this, void 0, void 0, "api").value;
    if (gos.get("readOnlyEdit")) {
      const {
        beans: { eventSvc },
        data,
        rowIndex,
        rowPinned
      } = this;
      eventSvc.dispatchEvent({
        type: "cellEditRequest",
        event: null,
        rowIndex,
        rowPinned,
        column,
        colDef: column.colDef,
        data,
        node: this,
        oldValue,
        newValue,
        value: newValue,
        source: eventSource
      });
      return false;
    }
    if (editSvc) {
      const result = editSvc.setDataValue({ rowNode: this, column }, newValue, eventSource);
      if (result != null) {
        return result;
      }
    }
    const valueChanged = valueSvc.setValue(this, column, newValue, eventSource);
    this.dispatchCellChangedEvent(column, newValue, oldValue);
    const pinnedSibling = this.pinnedSibling;
    if (pinnedSibling) {
      if (valueChanged) {
        pinnedSibling.dispatchCellChangedEvent(column, newValue, oldValue);
      }
    }
    return valueChanged;
  }
  updateHasChildren() {
    let newValue = this.group && !this.footer || this.childrenAfterGroup && this.childrenAfterGroup.length > 0;
    const { rowChildrenSvc } = this.beans;
    if (rowChildrenSvc) {
      newValue = rowChildrenSvc.getHasChildrenValue(this);
    }
    if (newValue !== this.__hasChildren) {
      this.__hasChildren = !!newValue;
      this.dispatchRowEvent("hasChildrenChanged");
    }
  }
  hasChildren() {
    if (this.__hasChildren == null) {
      this.updateHasChildren();
    }
    return this.__hasChildren;
  }
  dispatchCellChangedEvent(column, newValue, oldValue) {
    const cellChangedEvent = {
      type: "cellChanged",
      node: this,
      column,
      newValue,
      oldValue
    };
    this.__localEventService?.dispatchEvent(cellChangedEvent);
  }
  /**
   * The first time `quickFilter` runs, the grid creates a one-off string representation of the row.
   * This string is then used for the quick filter instead of hitting each column separately.
   * When you edit, using grid editing, this string gets cleared down.
   * However, if you edit without using grid editing, you need to clear this string down for the row to be updated with the new values.
   * Otherwise, new values would not work with the `quickFilter`. */
  resetQuickFilterAggregateText() {
    this.quickFilterAggregateText = null;
  }
  /** Returns:
   * - `true` if the node can be expanded, i.e it is a group or master row.
   * - `false` if the node cannot be expanded
   */
  isExpandable() {
    return this.beans.expansionSvc?.isExpandable(this) ?? false;
  }
  /** Returns:
   * - `true` if node is selected,
   * - `false` if the node isn't selected
   * - `undefined` if it's partially selected (group where not all children are selected). */
  isSelected() {
    if (this.footer) {
      return this.sibling.isSelected();
    }
    if (this.rowPinned && this.pinnedSibling) {
      return this.pinnedSibling.isSelected();
    }
    return this.__selected;
  }
  /** Perform a depth-first search of this node and its children. */
  depthFirstSearch(callback) {
    this.childrenAfterGroup?.forEach((child) => child.depthFirstSearch(callback));
    callback(this);
  }
  dispatchRowEvent(type) {
    this.__localEventService?.dispatchEvent({
      type,
      node: this
    });
  }
  /**
   * Select (or deselect) the node.
   * @param newValue -`true` for selection, `false` for deselection.
   * @param clearSelection - If selecting, then passing `true` selects the node exclusively (i.e. NOT do multi select). If doing deselection, `clearSelection` has no impact.
   * @param source - Source property that appears in the `selectionChanged` event.
   */
  setSelected(newValue, clearSelection = false, source = "api") {
    this.beans.selectionSvc?.setNodesSelected({
      nodes: [this],
      newValue,
      clearSelection,
      source
    });
  }
  /**
   * Returns:
   * - `true` if node is either pinned to the `top` or `bottom`
   * - `false` if the node isn't pinned
   */
  isRowPinned() {
    return !!this.rowPinned;
  }
  __addEventListener(eventType, listener) {
    if (!this.__localEventService) {
      this.__localEventService = new LocalEventService();
    }
    this.__localEventService.addEventListener(eventType, listener);
  }
  __removeEventListener(eventType, listener) {
    this.removeLocalListener(eventType, listener);
  }
  /**
   * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
   */
  addEventListener(eventType, userListener) {
    this.beans.validation?.checkRowEvents(eventType);
    if (!this.__localEventService) {
      this.__localEventService = new LocalEventService();
    }
    this.frameworkEventListenerService = this.beans.frameworkOverrides.createLocalEventListenerWrapper?.(
      this.frameworkEventListenerService,
      this.__localEventService
    );
    const listener = this.frameworkEventListenerService?.wrap(eventType, userListener) ?? userListener;
    this.__localEventService.addEventListener(eventType, listener);
  }
  /**
   * PUBLIC USE ONLY: for internal use within AG Grid use the `__addEventListener` and `__removeEventListener` methods.
   */
  removeEventListener(eventType, userListener) {
    const listener = this.frameworkEventListenerService?.unwrap(eventType, userListener) ?? userListener;
    this.removeLocalListener(eventType, listener);
  }
  removeLocalListener(eventType, listener) {
    this.__localEventService?.removeEventListener(eventType, listener);
    if (this.__localEventService?.noRegisteredListenersExist()) {
      this.__localEventService = null;
    }
  }
  /**
   * @deprecated v32.2.0 Check `node.detail` then user provided callback `isFullWidthRow` instead.
   *
   * Returns:
   * - `true` if the node is a full width cell
   * - `false` if the node is not a full width cell
   */
  isFullWidthCell() {
    _warn(61);
    if (this.detail) {
      return true;
    }
    const isFullWidthCellFunc = this.beans.gos.getCallback("isFullWidthRow");
    return isFullWidthCellFunc ? isFullWidthCellFunc({ rowNode: this }) : false;
  }
  /**
   * Returns the route of keys to the row node. Returns undefined if the node has no key.
   */
  getRoute() {
    if (this.level === -1) {
      return [];
    }
    if (this.key == null) {
      return void 0;
    }
    const res = [];
    let pointer = this;
    while (pointer && pointer.key != null) {
      res.push(pointer.key);
      pointer = pointer.parent;
    }
    return res.reverse();
  }
  setFirstChild(firstChild) {
    if (this.firstChild !== firstChild) {
      this.firstChild = firstChild;
      this.dispatchRowEvent("firstChildChanged");
    }
  }
  setDisplayed(displayed) {
    if (this.displayed !== displayed) {
      this.displayed = displayed;
      this.dispatchRowEvent("displayedChanged");
    }
  }
  setRowIndex(rowIndex) {
    if (this.rowIndex !== rowIndex) {
      this.rowIndex = rowIndex;
      this.dispatchRowEvent("rowIndexChanged");
    }
  }
  setAllChildrenCount(allChildrenCount) {
    if (this.allChildrenCount !== allChildrenCount) {
      this.allChildrenCount = allChildrenCount;
      this.dispatchRowEvent("allChildrenCountChanged");
    }
  }
  setUiLevel(uiLevel) {
    if (this.uiLevel !== uiLevel) {
      this.uiLevel = uiLevel;
      this.dispatchRowEvent("uiLevelChanged");
    }
  }
  getFirstChild() {
    if (this.childStore) {
      return this.childStore.getFirstNode();
    }
    return this.childrenAfterSort?.[0] ?? null;
  }
};

// packages/ag-grid-community/src/entities/rowNodeUtils.ts
function _createGlobalRowEvent(rowNode, gos, type) {
  return _addGridCommonParams(gos, {
    type,
    node: rowNode,
    data: rowNode.data,
    rowIndex: rowNode.rowIndex,
    rowPinned: rowNode.rowPinned
  });
}
var IGNORED_SIBLING_PROPERTIES = /* @__PURE__ */ new Set(["__localEventService", "__objectId", "sticky", "__autoHeights", "__checkAutoHeightsDebounced", "childStore"]);
function _createRowNodeSibling(rowNode, beans) {
  const sibling = new RowNode(beans);
  Object.keys(rowNode).forEach((key) => {
    if (IGNORED_SIBLING_PROPERTIES.has(key)) {
      return;
    }
    sibling[key] = rowNode[key];
  });
  sibling.oldRowTop = null;
  return sibling;
}

// packages/ag-grid-community/src/filter/columnFilterUtils.ts
var FILTER_HANDLER_MAP = {
  agSetColumnFilter: "agSetColumnFilterHandler",
  agMultiColumnFilter: "agMultiColumnFilterHandler",
  agGroupColumnFilter: "agGroupColumnFilterHandler",
  agNumberColumnFilter: "agNumberColumnFilterHandler",
  agDateColumnFilter: "agDateColumnFilterHandler",
  agTextColumnFilter: "agTextColumnFilterHandler"
};
var FILTER_HANDLERS = new Set(Object.values(FILTER_HANDLER_MAP));
function getFilterUiFromWrapper(filterWrapper, skipCreate) {
  const filterUi = filterWrapper.filterUi;
  if (!filterUi) {
    return null;
  }
  if (filterUi.created) {
    return filterUi.promise;
  }
  if (skipCreate) {
    return null;
  }
  const promise = filterUi.create(filterUi.refreshed);
  const createdFilterUi = filterUi;
  createdFilterUi.created = true;
  createdFilterUi.promise = promise;
  return promise;
}
function _refreshHandlerAndUi(getFilterUi, handler, handlerParams, model, state, source) {
  handler.refresh?.({ ...handlerParams, model, source });
  return getFilterUi().then((filterUi) => {
    if (filterUi) {
      const { filter, filterParams } = filterUi;
      _refreshFilterUi(filter, filterParams, model, state, source);
    }
  });
}
function _refreshFilterUi(filter, filterParams, model, state, source) {
  filter?.refresh?.({
    ...filterParams,
    model,
    state,
    source
  });
}
function getAndRefreshFilterUi(getFilterUi, getModel, getState2) {
  const filterUi = getFilterUi();
  if (filterUi?.created) {
    filterUi.promise.then((filter) => {
      const model = getModel();
      _refreshFilterUi(filter, filterUi.filterParams, model, getState2() ?? { model }, "ui");
    });
  }
}
function _updateFilterModel(action, getFilterUi, getModel, getState2, updateState, updateModel) {
  let state;
  let shouldUpdateModel = false;
  let model;
  switch (action) {
    case "apply": {
      const oldState = getState2();
      model = oldState?.model ?? null;
      state = {
        // keep the other UI state
        state: oldState?.state,
        model
      };
      shouldUpdateModel = true;
      break;
    }
    case "clear": {
      state = {
        // wipe other UI state
        model: null
      };
      break;
    }
    case "reset": {
      state = {
        // wipe other UI state
        model: null
      };
      shouldUpdateModel = true;
      model = null;
      break;
    }
    case "cancel": {
      state = {
        // wipe other UI state
        model: getModel()
      };
      break;
    }
  }
  updateState(state);
  if (shouldUpdateModel) {
    updateModel(model);
  } else {
    getAndRefreshFilterUi(getFilterUi, getModel, getState2);
  }
}
function _getFilterModel(model, colId) {
  return model[colId] ?? null;
}

// packages/ag-grid-community/src/filter/filterButtonComp.ts
function getElement(className) {
  return {
    tag: "div",
    cls: className
  };
}
var FilterButtonComp = class extends Component {
  constructor(config) {
    const { className = "ag-filter-apply-panel" } = config ?? {};
    super(getElement(className));
    this.listeners = [];
    this.validationMessage = null;
    this.className = className;
  }
  updateButtons(buttons, useForm) {
    const oldButtons = this.buttons;
    this.buttons = buttons;
    if (oldButtons === buttons) {
      return;
    }
    const eGui = this.getGui();
    _clearElement(eGui);
    let eApplyButton;
    this.destroyListeners();
    const fragment = document.createDocumentFragment();
    const className = this.className;
    const addButton = ({ type, label }) => {
      const clickListener = (event) => {
        this.dispatchLocalEvent({
          type,
          event
        });
      };
      if (!["apply", "clear", "reset", "cancel"].includes(type)) {
        _warn(75);
      }
      const isApply = type === "apply";
      const buttonType = isApply && useForm ? "submit" : "button";
      const button = _createElement({
        tag: "button",
        attrs: { type: buttonType },
        ref: `${type}FilterButton`,
        cls: `ag-button ag-standard-button ${className}-button${isApply ? " " + className + "-apply-button" : ""}`,
        children: label
      });
      this.activateTabIndex([button]);
      if (isApply) {
        eApplyButton = button;
      }
      const keydownListener = (event) => {
        if (event.key === KeyCode.ENTER) {
          event.preventDefault();
          clickListener(event);
        }
      };
      const listeners = this.listeners;
      button.addEventListener("click", clickListener);
      listeners.push(() => button.removeEventListener("click", clickListener));
      button.addEventListener("keydown", keydownListener);
      listeners.push(() => button.removeEventListener("keydown", keydownListener));
      fragment.append(button);
    };
    buttons.forEach((button) => addButton(button));
    this.eApply = eApplyButton;
    const tooltip = this.validationTooltipFeature;
    if (eApplyButton && !tooltip) {
      this.validationTooltipFeature = this.createOptionalManagedBean(
        this.beans.registry.createDynamicBean("tooltipFeature", false, {
          getGui: () => this.eApply,
          getLocation: () => "advancedFilter",
          getTooltipShowDelayOverride: () => 1e3
        })
      );
    } else if (!eApplyButton && tooltip) {
      this.validationTooltipFeature = this.destroyBean(tooltip);
    }
    eGui.append(fragment);
  }
  getApplyButton() {
    return this.eApply;
  }
  updateValidity(valid, message = null) {
    const eApplyButton = this.eApply;
    if (!eApplyButton) {
      return;
    }
    _setDisabled(eApplyButton, valid === false);
    this.validationMessage = message ?? null;
    this.validationTooltipFeature?.setTooltipAndRefresh(this.validationMessage);
  }
  destroyListeners() {
    this.listeners.forEach((destroyFunc) => destroyFunc());
    this.listeners = [];
  }
  destroy() {
    this.destroyListeners();
    super.destroy();
  }
};
var AgFilterButtonSelector = {
  selector: "AG-FILTER-BUTTON",
  component: FilterButtonComp
};

// packages/ag-grid-community/src/filter/filterLocaleText.ts
var FILTER_LOCALE_TEXT = {
  applyFilter: "Apply",
  clearFilter: "Clear",
  resetFilter: "Reset",
  cancelFilter: "Cancel",
  textFilter: "Text Filter",
  numberFilter: "Number Filter",
  dateFilter: "Date Filter",
  setFilter: "Set Filter",
  filterOoo: "Filter...",
  empty: "Choose one",
  equals: "Equals",
  notEqual: "Does not equal",
  lessThan: "Less than",
  greaterThan: "Greater than",
  inRange: "Between",
  inRangeStart: "From",
  inRangeEnd: "To",
  lessThanOrEqual: "Less than or equal to",
  greaterThanOrEqual: "Greater than or equal to",
  contains: "Contains",
  notContains: "Does not contain",
  startsWith: "Begins with",
  endsWith: "Ends with",
  blank: "Blank",
  notBlank: "Not blank",
  before: "Before",
  after: "After",
  andCondition: "AND",
  orCondition: "OR",
  dateFormatOoo: "yyyy-mm-dd",
  filterSummaryInactive: "is (All)",
  filterSummaryContains: "contains",
  filterSummaryNotContains: "does not contain",
  filterSummaryTextEquals: "equals",
  filterSummaryTextNotEqual: "does not equal",
  filterSummaryStartsWith: "begins with",
  filterSummaryEndsWith: "ends with",
  filterSummaryBlank: "is blank",
  filterSummaryNotBlank: "is not blank",
  filterSummaryEquals: "=",
  filterSummaryNotEqual: "!=",
  filterSummaryGreaterThan: ">",
  filterSummaryGreaterThanOrEqual: ">=",
  filterSummaryLessThan: "<",
  filterSummaryLessThanOrEqual: "<=",
  filterSummaryInRange: "between",
  filterSummaryInRangeValues: (variableValues) => `(${variableValues[0]}, ${variableValues[1]})`,
  filterSummaryTextQuote: (variableValues) => `"${variableValues[0]}"`
};
function translateForFilter(bean, key, variableValues) {
  return _translate(bean, FILTER_LOCALE_TEXT, key, variableValues);
}

// packages/ag-grid-community/src/filter/provided/providedFilterUtils.ts
function getDebounceMs(params, debounceDefault) {
  const { debounceMs } = params;
  if (_isUseApplyButton(params)) {
    if (debounceMs != null) {
      _warn(71);
    }
    return 0;
  }
  return debounceMs ?? debounceDefault;
}
function _isUseApplyButton(params) {
  return (params.buttons?.indexOf("apply") ?? -1) >= 0;
}

// packages/ag-grid-community/src/filter/filterWrapperComp.ts
var FilterWrapperComp = class extends Component {
  constructor(column, wrapper, eventParent, updateModel, isGlobalButtons, enableGlobalButtonCheck) {
    super();
    this.column = column;
    this.wrapper = wrapper;
    this.eventParent = eventParent;
    this.updateModel = updateModel;
    this.isGlobalButtons = isGlobalButtons;
    this.enableGlobalButtonCheck = enableGlobalButtonCheck;
    this.hidePopup = null;
    this.applyActive = false;
  }
  postConstruct() {
    const { comp, params: originalParams } = this.wrapper;
    const params = originalParams;
    const useForm = params.useForm;
    const tag = useForm ? "form" : "div";
    this.setTemplate({
      tag,
      cls: "ag-filter-wrapper"
    });
    if (useForm) {
      this.addManagedElementListeners(this.getGui(), {
        submit: (e) => {
          e?.preventDefault();
        },
        keydown: this.handleKeyDown.bind(this)
      });
    }
    this.appendChild(comp.getGui());
    this.params = params;
    this.resetButtonsPanel(params);
    this.addManagedListeners(this.eventParent, {
      filterParamsChanged: ({ column, params: eventParams }) => {
        if (column === this.column) {
          this.resetButtonsPanel(eventParams, this.params);
        }
      },
      filterStateChanged: ({ column, state }) => {
        if (column === this.column) {
          this.eButtons?.updateValidity(state.valid !== false);
        }
      },
      filterAction: ({ column, action, event: keyboardEvent }) => {
        if (column === this.column) {
          this.afterAction(action, keyboardEvent);
        }
      },
      ...this.enableGlobalButtonCheck ? {
        filterGlobalButtons: ({ isGlobal }) => {
          if (isGlobal !== this.isGlobalButtons) {
            this.isGlobalButtons = isGlobal;
            const currentParams = this.params;
            this.resetButtonsPanel(currentParams, currentParams, true);
          }
        }
      } : void 0
    });
  }
  afterGuiAttached(params) {
    if (params) {
      this.hidePopup = params.hidePopup;
    }
  }
  resetButtonsPanel(newParams, oldParams, forceUpdate) {
    const { buttons: oldButtons, readOnly: oldReadOnly } = oldParams ?? {};
    const { buttons: newButtons, readOnly, useForm } = newParams;
    if (!forceUpdate && oldReadOnly === readOnly && _jsonEquals(oldButtons, newButtons)) {
      return;
    }
    const hasButtons = newButtons && newButtons.length > 0 && !newParams.readOnly && !this.isGlobalButtons;
    let eButtonsPanel = this.eButtons;
    if (hasButtons) {
      const buttons = newButtons.map((type) => {
        const localeKey = `${type}Filter`;
        return { type, label: translateForFilter(this, localeKey) };
      });
      this.applyActive = _isUseApplyButton(this.params);
      if (!eButtonsPanel) {
        eButtonsPanel = this.createBean(new FilterButtonComp());
        this.appendChild(eButtonsPanel.getGui());
        const column = this.column;
        const getListener = (action) => ({ event }) => {
          this.updateModel(column, action);
          this.afterAction(action, event);
        };
        eButtonsPanel?.addManagedListeners(eButtonsPanel, {
          apply: getListener("apply"),
          clear: getListener("clear"),
          reset: getListener("reset"),
          cancel: getListener("cancel")
        });
        this.eButtons = eButtonsPanel;
      }
      eButtonsPanel.updateButtons(buttons, useForm);
    } else {
      this.applyActive = false;
      if (eButtonsPanel) {
        _removeFromParent(eButtonsPanel.getGui());
        this.eButtons = this.destroyBean(eButtonsPanel);
      }
    }
  }
  close(e) {
    const hidePopup = this.hidePopup;
    if (!hidePopup) {
      return;
    }
    const keyboardEvent = e;
    const key = keyboardEvent && keyboardEvent.key;
    let params;
    if (key === KeyCode.ENTER || key === KeyCode.SPACE) {
      params = { keyboardEvent };
    }
    hidePopup(params);
    this.hidePopup = null;
  }
  afterAction(action, event) {
    const { params, applyActive } = this;
    const closeOnApply = params?.closeOnApply;
    switch (action) {
      case "apply": {
        event?.preventDefault();
        if (closeOnApply && applyActive) {
          this.close(event);
        }
        break;
      }
      case "reset": {
        if (closeOnApply && applyActive) {
          this.close();
        }
        break;
      }
      case "cancel": {
        if (closeOnApply) {
          this.close(event);
        }
        break;
      }
    }
  }
  handleKeyDown(event) {
    if (!event.defaultPrevented && event.key === KeyCode.ENTER && this.applyActive) {
      this.updateModel(this.column, "apply");
      this.afterAction("apply", event);
    }
  }
  destroy() {
    this.hidePopup = null;
    this.eButtons = this.destroyBean(this.eButtons);
  }
};

// packages/ag-grid-community/src/filter/filterComp.ts
var FilterElement = { tag: "div", cls: "ag-filter" };
var FilterComp = class extends Component {
  constructor(column, source, enableGlobalButtonCheck) {
    super(FilterElement);
    this.column = column;
    this.source = source;
    this.enableGlobalButtonCheck = enableGlobalButtonCheck;
    this.wrapper = null;
  }
  postConstruct() {
    this.beans.colFilter?.activeFilterComps.add(this);
    this.createFilter(true);
    this.addManagedEventListeners({ filterDestroyed: this.onFilterDestroyed.bind(this) });
  }
  hasFilter() {
    return this.wrapper != null;
  }
  getFilter() {
    return this.wrapper?.then((wrapper) => wrapper.comp) ?? null;
  }
  afterInit() {
    return this.wrapper?.then(() => {
    }) ?? AgPromise.resolve();
  }
  afterGuiAttached(params) {
    this.afterGuiAttachedParams = params;
    this.wrapper?.then((wrapper) => {
      this.comp?.afterGuiAttached(params);
      wrapper?.comp?.afterGuiAttached?.(params);
    });
  }
  afterGuiDetached() {
    this.wrapper?.then((wrapper) => {
      wrapper?.comp?.afterGuiDetached?.();
    });
  }
  createFilter(init) {
    const {
      column,
      source,
      beans: { colFilter }
    } = this;
    const filterPromise = colFilter.getFilterUiForDisplay(column) ?? null;
    this.wrapper = filterPromise;
    filterPromise?.then((wrapper) => {
      if (!wrapper) {
        return;
      }
      const { isHandler, comp } = wrapper;
      let filterGui;
      if (isHandler) {
        const enableGlobalButtonCheck = !!this.enableGlobalButtonCheck;
        const displayComp = this.createBean(
          new FilterWrapperComp(
            column,
            wrapper,
            colFilter,
            colFilter.updateModel.bind(colFilter),
            enableGlobalButtonCheck && colFilter.isGlobalButtons,
            enableGlobalButtonCheck
          )
        );
        this.comp = displayComp;
        filterGui = displayComp.getGui();
      } else {
        filterGui = comp.getGui();
        if (!_exists(filterGui)) {
          _warn(69, { guiFromFilter: filterGui });
        }
      }
      this.appendChild(filterGui);
      if (init) {
        this.eventSvc.dispatchEvent({
          type: "filterOpened",
          column,
          source,
          eGui: this.getGui()
        });
      } else {
        comp.afterGuiAttached?.(this.afterGuiAttachedParams);
      }
    });
  }
  onFilterDestroyed(event) {
    const { source, column } = event;
    if ((source === "api" || source === "paramsUpdated") && column.getId() === this.column.getId() && this.beans.colModel.getColDefCol(this.column)) {
      _clearElement(this.getGui());
      this.comp = this.destroyBean(this.comp);
      this.createFilter();
    }
  }
  destroy() {
    this.beans.colFilter?.activeFilterComps.delete(this);
    this.eventSvc.dispatchEvent({
      type: "filterClosed",
      column: this.column
    });
    this.wrapper = null;
    this.comp = this.destroyBean(this.comp);
    this.afterGuiAttachedParams = void 0;
    super.destroy();
  }
};

// packages/ag-grid-community/src/utils/date.ts
var DATE_TIME_SEPARATOR = "T";
var DATE_TIME_REGEXP = new RegExp(`^\\d{4}-\\d{2}-\\d{2}(${DATE_TIME_SEPARATOR}\\d{2}:\\d{2}:\\d{2}\\D?)?`);
function _padStartWidthZeros(value, totalStringSize) {
  return value.toString().padStart(totalStringSize, "0");
}
function _serialiseDate(date, includeTime = true, separator = "-") {
  if (!date) {
    return null;
  }
  let serialised = [date.getFullYear(), date.getMonth() + 1, date.getDate()].map((part) => _padStartWidthZeros(part, 2)).join(separator);
  if (includeTime) {
    serialised += DATE_TIME_SEPARATOR + [date.getHours(), date.getMinutes(), date.getSeconds()].map((part) => _padStartWidthZeros(part, 2)).join(":");
  }
  return serialised;
}
function _getDateParts(d, includeTime = true) {
  if (!d) {
    return null;
  }
  if (includeTime) {
    return [
      String(d.getFullYear()),
      String(d.getMonth() + 1),
      _padStartWidthZeros(d.getDate(), 2),
      _padStartWidthZeros(d.getHours(), 2),
      `:${_padStartWidthZeros(d.getMinutes(), 2)}`,
      `:${_padStartWidthZeros(d.getSeconds(), 2)}`
    ];
  }
  return [d.getFullYear(), d.getMonth() + 1, _padStartWidthZeros(d.getDate(), 2)].map(String);
}
var calculateOrdinal = (value) => {
  if (value > 3 && value < 21) {
    return "th";
  }
  const remainder = value % 10;
  switch (remainder) {
    case 1:
      return "st";
    case 2:
      return "nd";
    case 3:
      return "rd";
  }
  return "th";
};
function _dateToFormattedString(date, format) {
  if (format == null) {
    return _serialiseDate(date, false);
  }
  const fullYear = _padStartWidthZeros(date.getFullYear(), 4);
  const months = [
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December"
  ];
  const days = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
  const replace = {
    YYYY: () => fullYear.slice(fullYear.length - 4, fullYear.length),
    YY: () => fullYear.slice(fullYear.length - 2, fullYear.length),
    Y: () => `${date.getFullYear()}`,
    MMMM: () => months[date.getMonth()],
    MMM: () => months[date.getMonth()].slice(0, 3),
    MM: () => _padStartWidthZeros(date.getMonth() + 1, 2),
    Mo: () => `${date.getMonth() + 1}${calculateOrdinal(date.getMonth() + 1)}`,
    M: () => `${date.getMonth() + 1}`,
    Do: () => `${date.getDate()}${calculateOrdinal(date.getDate())}`,
    DD: () => _padStartWidthZeros(date.getDate(), 2),
    D: () => `${date.getDate()}`,
    dddd: () => days[date.getDay()],
    ddd: () => days[date.getDay()].slice(0, 3),
    dd: () => days[date.getDay()].slice(0, 2),
    do: () => `${date.getDay()}${calculateOrdinal(date.getDay())}`,
    d: () => `${date.getDay()}`
  };
  const regexp = new RegExp(Object.keys(replace).join("|"), "g");
  return format.replace(regexp, (match) => {
    if (match in replace) {
      return replace[match]();
    }
    return match;
  });
}
function _isValidDate(value, bailIfInvalidTime = false) {
  return !!_parseDateTimeFromString(value, bailIfInvalidTime);
}
function _isValidDateTime(value) {
  return _isValidDate(value, true);
}
function _parseDateTimeFromString(value, bailIfInvalidTime = false) {
  if (!value) {
    return null;
  }
  if (!DATE_TIME_REGEXP.test(value)) {
    return null;
  }
  const [dateStr, timeStr] = value.split(DATE_TIME_SEPARATOR);
  if (!dateStr) {
    return null;
  }
  const fields = dateStr.split("-").map((f) => parseInt(f, 10));
  if (fields.filter((f) => !isNaN(f)).length !== 3) {
    return null;
  }
  const [year, month, day] = fields;
  const date = new Date(year, month - 1, day);
  if (date.getFullYear() !== year || date.getMonth() !== month - 1 || date.getDate() !== day) {
    return null;
  }
  if (!timeStr && bailIfInvalidTime) {
    return null;
  }
  if (!timeStr || timeStr === "00:00:00") {
    return date;
  }
  const [hours, minutes, seconds] = timeStr.split(":").map((part) => parseInt(part, 10));
  if (hours >= 0 && hours < 24) {
    date.setHours(hours);
  } else if (bailIfInvalidTime) {
    return null;
  }
  if (minutes >= 0 && minutes < 60) {
    date.setMinutes(minutes);
  } else if (bailIfInvalidTime) {
    return null;
  }
  if (seconds >= 0 && seconds < 60) {
    date.setSeconds(seconds);
  } else if (bailIfInvalidTime) {
    return null;
  }
  return date;
}

// packages/ag-grid-community/src/filter/filterDataTypeUtils.ts
var MONTH_LOCALE_TEXT = {
  january: "January",
  february: "February",
  march: "March",
  april: "April",
  may: "May",
  june: "June",
  july: "July",
  august: "August",
  september: "September",
  october: "October",
  november: "November",
  december: "December"
};
var MONTH_KEYS = [
  "january",
  "february",
  "march",
  "april",
  "may",
  "june",
  "july",
  "august",
  "september",
  "october",
  "november",
  "december"
];
function setFilterNumberComparator(a, b) {
  if (a == null) {
    return -1;
  }
  if (b == null) {
    return 1;
  }
  return parseFloat(a) - parseFloat(b);
}
function isValidDate(value) {
  return value instanceof Date && !isNaN(value.getTime());
}
var filterParamsForEachDataType = {
  number: () => void 0,
  boolean: () => ({
    maxNumConditions: 1,
    debounceMs: 0,
    filterOptions: [
      "empty",
      {
        displayKey: "true",
        displayName: "True",
        predicate: (_filterValues, cellValue) => cellValue,
        numberOfInputs: 0
      },
      {
        displayKey: "false",
        displayName: "False",
        predicate: (_filterValues, cellValue) => cellValue === false,
        numberOfInputs: 0
      }
    ]
  }),
  date: () => ({ isValidDate }),
  dateString: ({ dataTypeDefinition }) => ({
    comparator: (filterDate, cellValue) => {
      const cellAsDate = dataTypeDefinition.dateParser(cellValue);
      if (cellValue == null || cellAsDate < filterDate) {
        return -1;
      }
      if (cellAsDate > filterDate) {
        return 1;
      }
      return 0;
    },
    isValidDate: (value) => typeof value === "string" && isValidDate(dataTypeDefinition.dateParser(value))
  }),
  dateTime: (args) => filterParamsForEachDataType.date(args),
  dateTimeString: (args) => filterParamsForEachDataType.dateString(args),
  object: () => void 0,
  text: () => void 0
};
var setFilterParamsForEachDataType = {
  number: () => ({ comparator: setFilterNumberComparator }),
  boolean: ({ t }) => ({
    valueFormatter: (params) => _exists(params.value) ? t(String(params.value), params.value ? "True" : "False") : t("blanks", "(Blanks)")
  }),
  date: ({ formatValue, t }) => ({
    valueFormatter: (params) => {
      const valueFormatted = formatValue(params);
      return _exists(valueFormatted) ? valueFormatted : t("blanks", "(Blanks)");
    },
    treeList: true,
    treeListFormatter: (pathKey, level) => {
      if (pathKey === "NaN") {
        return t("invalidDate", "Invalid Date");
      }
      if (level === 1 && pathKey != null) {
        const monthKey = MONTH_KEYS[Number(pathKey) - 1];
        return t(monthKey, MONTH_LOCALE_TEXT[monthKey]);
      }
      return pathKey ?? t("blanks", "(Blanks)");
    },
    treeListPathGetter: (date) => _getDateParts(date, false)
  }),
  dateString: ({ formatValue, dataTypeDefinition, t }) => ({
    valueFormatter: (params) => {
      const valueFormatted = formatValue(params);
      return _exists(valueFormatted) ? valueFormatted : t("blanks", "(Blanks)");
    },
    treeList: true,
    treeListPathGetter: (value) => _getDateParts(dataTypeDefinition.dateParser(value ?? void 0), false),
    treeListFormatter: (pathKey, level) => {
      if (level === 1 && pathKey != null) {
        const monthKey = MONTH_KEYS[Number(pathKey) - 1];
        return t(monthKey, MONTH_LOCALE_TEXT[monthKey]);
      }
      return pathKey ?? t("blanks", "(Blanks)");
    }
  }),
  dateTime: (args) => {
    const params = setFilterParamsForEachDataType.date(args);
    params.treeListPathGetter = _getDateParts;
    return params;
  },
  dateTimeString(args) {
    const convertToDate = args.dataTypeDefinition.dateParser;
    const params = setFilterParamsForEachDataType.dateString(args);
    params.treeListPathGetter = (value) => _getDateParts(convertToDate(value ?? void 0));
    return params;
  },
  object: ({ formatValue, t }) => ({
    valueFormatter: (params) => {
      const valueFormatted = formatValue(params);
      return _exists(valueFormatted) ? valueFormatted : t("blanks", "(Blanks)");
    }
  }),
  text: () => void 0
};
function _getFilterParamsForDataType(filter, existingFilterParams, existingFilterValueGetter, dataTypeDefinition, formatValue, beans, translate) {
  let filterParams = existingFilterParams;
  let filterValueGetter = existingFilterValueGetter;
  const usingSetFilter = filter === "agSetColumnFilter";
  if (!filterValueGetter && dataTypeDefinition.baseDataType === "object" && !usingSetFilter) {
    filterValueGetter = ({ column, node }) => formatValue({ column, node, value: beans.valueSvc.getValue(column, node) });
  }
  const filterParamsMap = usingSetFilter ? setFilterParamsForEachDataType : filterParamsForEachDataType;
  const filterParamsGetter = filterParamsMap[dataTypeDefinition.baseDataType];
  const newFilterParams = filterParamsGetter({ dataTypeDefinition, formatValue, t: translate });
  filterParams = typeof existingFilterParams === "object" ? {
    ...newFilterParams,
    ...existingFilterParams
  } : newFilterParams;
  return { filterParams, filterValueGetter };
}
var defaultFilters = {
  boolean: "agTextColumnFilter",
  date: "agDateColumnFilter",
  dateString: "agDateColumnFilter",
  dateTime: "agDateColumnFilter",
  dateTimeString: "agDateColumnFilter",
  number: "agNumberColumnFilter",
  object: "agTextColumnFilter",
  text: "agTextColumnFilter"
};
var defaultFloatingFilters = {
  boolean: "agTextColumnFloatingFilter",
  date: "agDateColumnFloatingFilter",
  dateString: "agDateColumnFloatingFilter",
  dateTime: "agDateColumnFloatingFilter",
  dateTimeString: "agDateColumnFloatingFilter",
  number: "agNumberColumnFloatingFilter",
  object: "agTextColumnFloatingFilter",
  text: "agTextColumnFloatingFilter"
};
function _getDefaultSimpleFilter(cellDataType, isFloating = false) {
  const filterSet = isFloating ? defaultFloatingFilters : defaultFilters;
  return filterSet[cellDataType ?? "text"];
}

// packages/ag-grid-community/src/rendering/features/positionableFeature.ts
var RESIZE_CONTAINER_STYLE = "ag-resizer-wrapper";
var makeDiv = (dataRefPrefix, classSuffix) => ({
  tag: "div",
  ref: `${dataRefPrefix}Resizer`,
  cls: `ag-resizer ag-resizer-${classSuffix}`
});
var RESIZE_TEMPLATE = {
  tag: "div",
  cls: RESIZE_CONTAINER_STYLE,
  children: [
    makeDiv("eTopLeft", "topLeft"),
    makeDiv("eTop", "top"),
    makeDiv("eTopRight", "topRight"),
    makeDiv("eRight", "right"),
    makeDiv("eBottomRight", "bottomRight"),
    makeDiv("eBottom", "bottom"),
    makeDiv("eBottomLeft", "bottomLeft"),
    makeDiv("eLeft", "left")
  ]
};
var PositionableFeature = class extends BeanStub {
  constructor(element, config) {
    super();
    this.element = element;
    this.dragStartPosition = {
      x: 0,
      y: 0
    };
    this.position = {
      x: 0,
      y: 0
    };
    this.lastSize = {
      width: -1,
      height: -1
    };
    this.positioned = false;
    this.resizersAdded = false;
    this.resizeListeners = [];
    this.boundaryEl = null;
    this.isResizing = false;
    this.isMoving = false;
    this.resizable = {};
    this.movable = false;
    this.currentResizer = null;
    this.config = Object.assign({}, { popup: false }, config);
  }
  wireBeans(beans) {
    this.popupSvc = beans.popupSvc;
    this.dragSvc = beans.dragSvc;
  }
  center(postProcessCallback) {
    const { clientHeight, clientWidth } = this.offsetParent;
    const x = clientWidth / 2 - this.getWidth() / 2;
    const y = clientHeight / 2 - this.getHeight() / 2;
    this.offsetElement(x, y, postProcessCallback);
  }
  initialisePosition(postProcessCallback) {
    if (this.positioned) {
      return;
    }
    const { centered, forcePopupParentAsOffsetParent, minWidth, width, minHeight, height, x, y } = this.config;
    if (!this.offsetParent) {
      this.setOffsetParent();
    }
    let computedMinHeight = 0;
    let computedMinWidth = 0;
    const isElementVisible = _isVisible(this.element);
    if (isElementVisible) {
      const boundaryEl = this.findBoundaryElement();
      const offsetParentComputedStyles = window.getComputedStyle(boundaryEl);
      if (offsetParentComputedStyles.minWidth != null) {
        const paddingWidth = boundaryEl.offsetWidth - this.element.offsetWidth;
        computedMinWidth = parseInt(offsetParentComputedStyles.minWidth, 10) - paddingWidth;
      }
      if (offsetParentComputedStyles.minHeight != null) {
        const paddingHeight = boundaryEl.offsetHeight - this.element.offsetHeight;
        computedMinHeight = parseInt(offsetParentComputedStyles.minHeight, 10) - paddingHeight;
      }
    }
    this.minHeight = minHeight || computedMinHeight;
    this.minWidth = minWidth || computedMinWidth;
    if (width) {
      this.setWidth(width);
    }
    if (height) {
      this.setHeight(height);
    }
    if (!width || !height) {
      this.refreshSize();
    }
    if (centered) {
      this.center(postProcessCallback);
    } else if (x || y) {
      this.offsetElement(x, y, postProcessCallback);
    } else if (isElementVisible && forcePopupParentAsOffsetParent) {
      let boundaryEl = this.boundaryEl;
      let initialisedDuringPositioning = true;
      if (!boundaryEl) {
        boundaryEl = this.findBoundaryElement();
        initialisedDuringPositioning = false;
      }
      if (boundaryEl) {
        const top = parseFloat(boundaryEl.style.top);
        const left = parseFloat(boundaryEl.style.left);
        if (initialisedDuringPositioning) {
          this.offsetElement(isNaN(left) ? 0 : left, isNaN(top) ? 0 : top, postProcessCallback);
        } else {
          this.setPosition(left, top);
        }
      }
    }
    this.positioned = !!this.offsetParent;
  }
  isPositioned() {
    return this.positioned;
  }
  getPosition() {
    return this.position;
  }
  setMovable(movable, moveElement) {
    if (!this.config.popup || movable === this.movable) {
      return;
    }
    this.movable = movable;
    const params = this.moveElementDragListener || {
      eElement: moveElement,
      onDragStart: this.onMoveStart.bind(this),
      onDragging: this.onMove.bind(this),
      onDragStop: this.onMoveEnd.bind(this)
    };
    if (movable) {
      this.dragSvc?.addDragSource(params);
      this.moveElementDragListener = params;
    } else {
      this.dragSvc?.removeDragSource(params);
      this.moveElementDragListener = void 0;
    }
  }
  setResizable(resizable) {
    this.clearResizeListeners();
    if (resizable) {
      this.addResizers();
    } else {
      this.removeResizers();
    }
    if (typeof resizable === "boolean") {
      if (resizable === false) {
        return;
      }
      resizable = {
        topLeft: resizable,
        top: resizable,
        topRight: resizable,
        right: resizable,
        bottomRight: resizable,
        bottom: resizable,
        bottomLeft: resizable,
        left: resizable
      };
    }
    Object.keys(resizable).forEach((side) => {
      const resizableStructure = resizable;
      const isSideResizable = !!resizableStructure[side];
      const resizerEl = this.getResizerElement(side);
      const params = {
        dragStartPixels: 0,
        eElement: resizerEl,
        onDragStart: (e) => this.onResizeStart(e, side),
        onDragging: this.onResize.bind(this),
        onDragStop: (e) => this.onResizeEnd(e, side)
      };
      if (isSideResizable || !this.isAlive() && !isSideResizable) {
        if (isSideResizable) {
          this.dragSvc?.addDragSource(params);
          this.resizeListeners.push(params);
          resizerEl.style.pointerEvents = "all";
        } else {
          resizerEl.style.pointerEvents = "none";
        }
        this.resizable[side] = isSideResizable;
      }
    });
  }
  removeSizeFromEl() {
    this.element.style.removeProperty("height");
    this.element.style.removeProperty("width");
    this.element.style.removeProperty("flex");
  }
  restoreLastSize() {
    this.element.style.flex = "0 0 auto";
    const { height, width } = this.lastSize;
    if (width !== -1) {
      this.element.style.width = `${width}px`;
    }
    if (height !== -1) {
      this.element.style.height = `${height}px`;
    }
  }
  getHeight() {
    return this.element.offsetHeight;
  }
  setHeight(height) {
    const { popup } = this.config;
    const eGui = this.element;
    let isPercent = false;
    if (typeof height === "string" && height.indexOf("%") !== -1) {
      _setFixedHeight(eGui, height);
      height = _getAbsoluteHeight(eGui);
      isPercent = true;
    } else {
      height = Math.max(this.minHeight, height);
      if (this.positioned) {
        const availableHeight = this.getAvailableHeight();
        if (availableHeight && height > availableHeight) {
          height = availableHeight;
        }
      }
    }
    if (this.getHeight() === height) {
      return;
    }
    if (!isPercent) {
      if (popup) {
        _setFixedHeight(eGui, height);
      } else {
        eGui.style.height = `${height}px`;
        eGui.style.flex = "0 0 auto";
        this.lastSize.height = typeof height === "number" ? height : parseFloat(height);
      }
    } else {
      eGui.style.maxHeight = "unset";
      eGui.style.minHeight = "unset";
    }
  }
  getAvailableHeight() {
    const { popup, forcePopupParentAsOffsetParent } = this.config;
    if (!this.positioned) {
      this.initialisePosition();
    }
    const { clientHeight } = this.offsetParent;
    if (!clientHeight) {
      return null;
    }
    const elRect = this.element.getBoundingClientRect();
    const offsetParentRect = this.offsetParent.getBoundingClientRect();
    const yPosition = popup ? this.position.y : elRect.top;
    const parentTop = popup ? 0 : offsetParentRect.top;
    let additionalHeight = 0;
    if (forcePopupParentAsOffsetParent) {
      const parentEl = this.element.parentElement;
      if (parentEl) {
        const { bottom } = parentEl.getBoundingClientRect();
        additionalHeight = bottom - elRect.bottom;
      }
    }
    const availableHeight = clientHeight + parentTop - yPosition - additionalHeight;
    return availableHeight;
  }
  getWidth() {
    return this.element.offsetWidth;
  }
  setWidth(width) {
    const eGui = this.element;
    const { popup } = this.config;
    let isPercent = false;
    if (typeof width === "string" && width.indexOf("%") !== -1) {
      _setFixedWidth(eGui, width);
      width = _getAbsoluteWidth(eGui);
      isPercent = true;
    } else if (this.positioned) {
      width = Math.max(this.minWidth, width);
      const { clientWidth } = this.offsetParent;
      const xPosition = popup ? this.position.x : this.element.getBoundingClientRect().left;
      if (clientWidth && width + xPosition > clientWidth) {
        width = clientWidth - xPosition;
      }
    }
    if (this.getWidth() === width) {
      return;
    }
    if (!isPercent) {
      if (this.config.popup) {
        _setFixedWidth(eGui, width);
      } else {
        eGui.style.width = `${width}px`;
        eGui.style.flex = " unset";
        this.lastSize.width = typeof width === "number" ? width : parseFloat(width);
      }
    } else {
      eGui.style.maxWidth = "unset";
      eGui.style.minWidth = "unset";
    }
  }
  offsetElement(x = 0, y = 0, postProcessCallback) {
    const { forcePopupParentAsOffsetParent } = this.config;
    const ePopup = forcePopupParentAsOffsetParent ? this.boundaryEl : this.element;
    if (!ePopup) {
      return;
    }
    this.popupSvc?.positionPopup({
      ePopup,
      keepWithinBounds: true,
      skipObserver: this.movable || this.isResizable(),
      updatePosition: () => ({ x, y }),
      postProcessCallback
    });
    this.setPosition(parseFloat(ePopup.style.left), parseFloat(ePopup.style.top));
  }
  constrainSizeToAvailableHeight(constrain) {
    if (!this.config.forcePopupParentAsOffsetParent) {
      return;
    }
    const applyMaxHeightToElement = () => {
      const availableHeight = this.getAvailableHeight();
      this.element.style.setProperty("max-height", `${availableHeight}px`);
    };
    if (constrain && this.popupSvc) {
      this.resizeObserverSubscriber?.();
      this.resizeObserverSubscriber = _observeResize(
        this.beans,
        this.popupSvc?.getPopupParent(),
        applyMaxHeightToElement
      );
    } else {
      this.element.style.removeProperty("max-height");
      if (this.resizeObserverSubscriber) {
        this.resizeObserverSubscriber();
        this.resizeObserverSubscriber = void 0;
      }
    }
  }
  setPosition(x, y) {
    this.position.x = x;
    this.position.y = y;
  }
  updateDragStartPosition(x, y) {
    this.dragStartPosition = { x, y };
  }
  calculateMouseMovement(params) {
    const { e, isLeft, isTop, anywhereWithin, topBuffer } = params;
    const xDiff = e.clientX - this.dragStartPosition.x;
    const yDiff = e.clientY - this.dragStartPosition.y;
    const movementX = this.shouldSkipX(e, !!isLeft, !!anywhereWithin, xDiff) ? 0 : xDiff;
    const movementY = this.shouldSkipY(e, !!isTop, topBuffer, yDiff) ? 0 : yDiff;
    return { movementX, movementY };
  }
  shouldSkipX(e, isLeft, anywhereWithin, diff) {
    const elRect = this.element.getBoundingClientRect();
    const parentRect = this.offsetParent.getBoundingClientRect();
    const boundaryElRect = this.boundaryEl.getBoundingClientRect();
    const xPosition = this.config.popup ? this.position.x : elRect.left;
    let skipX = xPosition <= 0 && parentRect.left >= e.clientX || parentRect.right <= e.clientX && parentRect.right <= boundaryElRect.right;
    if (skipX) {
      return true;
    }
    if (isLeft) {
      skipX = // skip if we are moving to the left and the cursor
      // is positioned to the right of the left side anchor
      diff < 0 && e.clientX > xPosition + parentRect.left || // skip if we are moving to the right and the cursor
      // is positioned to the left of the dialog
      diff > 0 && e.clientX < xPosition + parentRect.left;
    } else {
      if (anywhereWithin) {
        skipX = diff < 0 && e.clientX > boundaryElRect.right || diff > 0 && e.clientX < xPosition + parentRect.left;
      } else {
        skipX = // if the movement is bound to the right side of the dialog
        // we skip if we are moving to the left and the cursor
        // is to the right of the dialog
        diff < 0 && e.clientX > boundaryElRect.right || // or skip if we are moving to the right and the cursor
        // is to the left of the right side anchor
        diff > 0 && e.clientX < boundaryElRect.right;
      }
    }
    return skipX;
  }
  shouldSkipY(e, isTop, topBuffer = 0, diff) {
    const elRect = this.element.getBoundingClientRect();
    const parentRect = this.offsetParent.getBoundingClientRect();
    const boundaryElRect = this.boundaryEl.getBoundingClientRect();
    const yPosition = this.config.popup ? this.position.y : elRect.top;
    let skipY = yPosition <= 0 && parentRect.top >= e.clientY || parentRect.bottom <= e.clientY && parentRect.bottom <= boundaryElRect.bottom;
    if (skipY) {
      return true;
    }
    if (isTop) {
      skipY = // skip if we are moving to towards top and the cursor is
      // below the top anchor + topBuffer
      // note: topBuffer is used when moving the dialog using the title bar
      diff < 0 && e.clientY > yPosition + parentRect.top + topBuffer || // skip if we are moving to the bottom and the cursor is
      // above the top anchor
      diff > 0 && e.clientY < yPosition + parentRect.top;
    } else {
      skipY = // skip if we are moving towards the top and the cursor
      // is below the bottom anchor
      diff < 0 && e.clientY > boundaryElRect.bottom || // skip if we are moving towards the bottom and the cursor
      // is above the bottom anchor
      diff > 0 && e.clientY < boundaryElRect.bottom;
    }
    return skipY;
  }
  createResizeMap() {
    const getElement2 = (ref) => ({
      element: this.element.querySelector(`[data-ref=${ref}Resizer]`)
    });
    this.resizerMap = {
      topLeft: getElement2("eTopLeft"),
      top: getElement2("eTop"),
      topRight: getElement2("eTopRight"),
      right: getElement2("eRight"),
      bottomRight: getElement2("eBottomRight"),
      bottom: getElement2("eBottom"),
      bottomLeft: getElement2("eBottomLeft"),
      left: getElement2("eLeft")
    };
  }
  addResizers() {
    if (this.resizersAdded) {
      return;
    }
    const eGui = this.element;
    if (!eGui) {
      return;
    }
    eGui.appendChild(_createElement(RESIZE_TEMPLATE));
    this.createResizeMap();
    this.resizersAdded = true;
  }
  removeResizers() {
    this.resizerMap = void 0;
    const resizerEl = this.element.querySelector(`.${RESIZE_CONTAINER_STYLE}`);
    if (resizerEl) {
      this.element.removeChild(resizerEl);
    }
    this.resizersAdded = false;
  }
  getResizerElement(side) {
    return this.resizerMap[side].element;
  }
  onResizeStart(e, side) {
    this.boundaryEl = this.findBoundaryElement();
    if (!this.positioned) {
      this.initialisePosition();
    }
    this.currentResizer = {
      isTop: !!side.match(/top/i),
      isRight: !!side.match(/right/i),
      isBottom: !!side.match(/bottom/i),
      isLeft: !!side.match(/left/i)
    };
    this.element.classList.add("ag-resizing");
    this.resizerMap[side].element.classList.add("ag-active");
    const { popup, forcePopupParentAsOffsetParent } = this.config;
    if (!popup && !forcePopupParentAsOffsetParent) {
      this.applySizeToSiblings(this.currentResizer.isBottom || this.currentResizer.isTop);
    }
    this.isResizing = true;
    this.updateDragStartPosition(e.clientX, e.clientY);
  }
  getSiblings() {
    const element = this.element;
    const parent = element.parentElement;
    if (!parent) {
      return null;
    }
    return Array.prototype.slice.call(parent.children).filter((el) => !el.classList.contains("ag-hidden"));
  }
  getMinSizeOfSiblings() {
    const siblings = this.getSiblings() || [];
    let height = 0;
    let width = 0;
    for (let i = 0; i < siblings.length; i++) {
      const currentEl = siblings[i];
      const isFlex = !!currentEl.style.flex && currentEl.style.flex !== "0 0 auto";
      if (currentEl === this.element) {
        continue;
      }
      let nextHeight = this.minHeight || 0;
      let nextWidth = this.minWidth || 0;
      if (isFlex) {
        const computedStyle = window.getComputedStyle(currentEl);
        if (computedStyle.minHeight) {
          nextHeight = parseInt(computedStyle.minHeight, 10);
        }
        if (computedStyle.minWidth) {
          nextWidth = parseInt(computedStyle.minWidth, 10);
        }
      } else {
        nextHeight = currentEl.offsetHeight;
        nextWidth = currentEl.offsetWidth;
      }
      height += nextHeight;
      width += nextWidth;
    }
    return { height, width };
  }
  applySizeToSiblings(vertical) {
    let containerToFlex = null;
    const siblings = this.getSiblings();
    if (!siblings) {
      return;
    }
    for (let i = 0; i < siblings.length; i++) {
      const el = siblings[i];
      if (el === containerToFlex) {
        continue;
      }
      if (vertical) {
        el.style.height = `${el.offsetHeight}px`;
      } else {
        el.style.width = `${el.offsetWidth}px`;
      }
      el.style.flex = "0 0 auto";
      if (el === this.element) {
        containerToFlex = siblings[i + 1];
      }
    }
    if (containerToFlex) {
      containerToFlex.style.removeProperty("height");
      containerToFlex.style.removeProperty("min-height");
      containerToFlex.style.removeProperty("max-height");
      containerToFlex.style.flex = "1 1 auto";
    }
  }
  isResizable() {
    return Object.values(this.resizable).some((value) => value);
  }
  onResize(e) {
    if (!this.isResizing || !this.currentResizer) {
      return;
    }
    const { popup, forcePopupParentAsOffsetParent } = this.config;
    const { isTop, isRight, isBottom, isLeft } = this.currentResizer;
    const isHorizontal = isRight || isLeft;
    const isVertical = isBottom || isTop;
    const { movementX, movementY } = this.calculateMouseMovement({ e, isLeft, isTop });
    const xPosition = this.position.x;
    const yPosition = this.position.y;
    let offsetLeft = 0;
    let offsetTop = 0;
    if (isHorizontal && movementX) {
      const direction = isLeft ? -1 : 1;
      const oldWidth = this.getWidth();
      const newWidth = oldWidth + movementX * direction;
      let skipWidth = false;
      if (isLeft) {
        offsetLeft = oldWidth - newWidth;
        if (xPosition + offsetLeft <= 0 || newWidth <= this.minWidth) {
          skipWidth = true;
          offsetLeft = 0;
        }
      }
      if (!skipWidth) {
        this.setWidth(newWidth);
      }
    }
    if (isVertical && movementY) {
      const direction = isTop ? -1 : 1;
      const oldHeight = this.getHeight();
      const newHeight = oldHeight + movementY * direction;
      let skipHeight = false;
      if (isTop) {
        offsetTop = oldHeight - newHeight;
        if (yPosition + offsetTop <= 0 || newHeight <= this.minHeight) {
          skipHeight = true;
          offsetTop = 0;
        }
      } else {
        if (!this.config.popup && !this.config.forcePopupParentAsOffsetParent && oldHeight < newHeight && this.getMinSizeOfSiblings().height + newHeight > this.element.parentElement.offsetHeight) {
          skipHeight = true;
        }
      }
      if (!skipHeight) {
        this.setHeight(newHeight);
      }
    }
    this.updateDragStartPosition(e.clientX, e.clientY);
    if ((popup || forcePopupParentAsOffsetParent) && offsetLeft || offsetTop) {
      this.offsetElement(xPosition + offsetLeft, yPosition + offsetTop);
    }
  }
  onResizeEnd(e, side) {
    this.isResizing = false;
    this.currentResizer = null;
    this.boundaryEl = null;
    this.element.classList.remove("ag-resizing");
    this.resizerMap[side].element.classList.remove("ag-active");
    this.dispatchLocalEvent({ type: "resize" });
  }
  refreshSize() {
    const eGui = this.element;
    if (this.config.popup) {
      if (!this.config.width) {
        this.setWidth(eGui.offsetWidth);
      }
      if (!this.config.height) {
        this.setHeight(eGui.offsetHeight);
      }
    }
  }
  onMoveStart(e) {
    this.boundaryEl = this.findBoundaryElement();
    if (!this.positioned) {
      this.initialisePosition();
    }
    this.isMoving = true;
    this.element.classList.add("ag-moving");
    this.updateDragStartPosition(e.clientX, e.clientY);
  }
  onMove(e) {
    if (!this.isMoving) {
      return;
    }
    const { x, y } = this.position;
    let topBuffer;
    if (this.config.calculateTopBuffer) {
      topBuffer = this.config.calculateTopBuffer();
    }
    const { movementX, movementY } = this.calculateMouseMovement({
      e,
      isTop: true,
      anywhereWithin: true,
      topBuffer
    });
    this.offsetElement(x + movementX, y + movementY);
    this.updateDragStartPosition(e.clientX, e.clientY);
  }
  onMoveEnd() {
    this.isMoving = false;
    this.boundaryEl = null;
    this.element.classList.remove("ag-moving");
  }
  setOffsetParent() {
    if (this.config.forcePopupParentAsOffsetParent && this.popupSvc) {
      this.offsetParent = this.popupSvc.getPopupParent();
    } else {
      this.offsetParent = this.element.offsetParent;
    }
  }
  findBoundaryElement() {
    let el = this.element;
    while (el) {
      if (window.getComputedStyle(el).position !== "static") {
        return el;
      }
      el = el.parentElement;
    }
    return this.element;
  }
  clearResizeListeners() {
    while (this.resizeListeners.length) {
      const params = this.resizeListeners.pop();
      this.dragSvc?.removeDragSource(params);
    }
  }
  destroy() {
    super.destroy();
    if (this.moveElementDragListener) {
      this.dragSvc?.removeDragSource(this.moveElementDragListener);
    }
    this.constrainSizeToAvailableHeight(false);
    this.clearResizeListeners();
    this.removeResizers();
  }
};

// packages/ag-grid-community/src/widgets/managedFocusFeature.ts
var FOCUS_MANAGED_CLASS = "ag-focus-managed";
var ManagedFocusFeature = class extends BeanStub {
  constructor(eFocusable, callbacks = {}) {
    super();
    this.eFocusable = eFocusable;
    this.callbacks = callbacks;
    this.callbacks = {
      shouldStopEventPropagation: () => false,
      onTabKeyDown: (e) => {
        if (e.defaultPrevented) {
          return;
        }
        const nextRoot = _findNextFocusableElement(this.beans, this.eFocusable, false, e.shiftKey);
        if (!nextRoot) {
          return;
        }
        nextRoot.focus();
        e.preventDefault();
      },
      ...callbacks
    };
  }
  postConstruct() {
    const {
      eFocusable,
      callbacks: { onFocusIn, onFocusOut }
    } = this;
    eFocusable.classList.add(FOCUS_MANAGED_CLASS);
    this.addKeyDownListeners(eFocusable);
    if (onFocusIn) {
      this.addManagedElementListeners(eFocusable, { focusin: onFocusIn });
    }
    if (onFocusOut) {
      this.addManagedElementListeners(eFocusable, { focusout: onFocusOut });
    }
  }
  addKeyDownListeners(eGui) {
    this.addManagedElementListeners(eGui, {
      keydown: (e) => {
        if (e.defaultPrevented || _isStopPropagationForAgGrid(e)) {
          return;
        }
        const { callbacks } = this;
        if (callbacks.shouldStopEventPropagation(e)) {
          _stopPropagationForAgGrid(e);
          return;
        }
        if (e.key === KeyCode.TAB) {
          callbacks.onTabKeyDown(e);
        } else if (callbacks.handleKeyDown) {
          callbacks.handleKeyDown(e);
        }
      }
    });
  }
};

// packages/ag-grid-community/src/filter/provided/providedFilter.ts
var ProvidedFilter = class extends Component {
  constructor(filterNameKey, cssIdentifier) {
    super();
    this.filterNameKey = filterNameKey;
    this.cssIdentifier = cssIdentifier;
    this.applyActive = false;
    this.debouncePending = false;
    // subclasses can override this to provide alternative debounce defaults
    this.defaultDebounceMs = 0;
  }
  postConstruct() {
    const element = {
      tag: "div",
      cls: `ag-filter-body-wrapper ag-${this.cssIdentifier}-body-wrapper`,
      children: [this.createBodyTemplate()]
    };
    this.setTemplate(element, this.getAgComponents());
    this.createManagedBean(
      new ManagedFocusFeature(this.getFocusableElement(), {
        handleKeyDown: this.handleKeyDown.bind(this)
      })
    );
    this.positionableFeature = this.createBean(
      new PositionableFeature(this.getPositionableElement(), {
        forcePopupParentAsOffsetParent: true
      })
    );
  }
  handleKeyDown(_e) {
  }
  init(legacyParams) {
    const params = legacyParams;
    this.setParams(params);
    this.setModelIntoUi(params.state.model, true).then(() => this.updateUiVisibility());
  }
  refresh(legacyNewParams) {
    const newParams = legacyNewParams;
    const oldParams = this.params;
    this.params = newParams;
    const source = newParams.source;
    if (source === "colDef") {
      this.updateParams(newParams, oldParams);
    }
    const newState = newParams.state;
    const oldState = this.state;
    this.state = newState;
    if (newState.model !== oldState.model || newState.state !== oldState.state) {
      this.setModelIntoUi(newState.model);
    }
    return true;
  }
  /** Called on init only. Override in subclasses */
  setParams(params) {
    this.params = params;
    this.state = params.state;
    this.commonUpdateParams(params);
  }
  /** Called on refresh only. Override in subclasses */
  updateParams(newParams, oldParams) {
    this.commonUpdateParams(newParams, oldParams);
  }
  commonUpdateParams(newParams, _oldParams) {
    this.applyActive = _isUseApplyButton(newParams);
    this.setupApplyDebounced();
  }
  /**
   * @deprecated v34 Use the same method on the filter handler (`api.getColumnFilterHandler()`) instead.
   */
  doesFilterPass(params) {
    _warn(283);
    const { getHandler, model, column } = this.params;
    return getHandler().doesFilterPass({
      ...params,
      model,
      handlerParams: this.beans.colFilter.getHandlerParams(column)
    });
  }
  getFilterTitle() {
    return this.translate(this.filterNameKey);
  }
  /**
   * @deprecated v34 Filters are active when they have a model. Use `api.getColumnFilterModel()` instead.
   */
  isFilterActive() {
    _warn(284);
    return this.params.model != null;
  }
  setupApplyDebounced() {
    const debounceMs = getDebounceMs(this.params, this.defaultDebounceMs);
    const debounceFunc = _debounce(this, this.checkApplyDebounce.bind(this), debounceMs);
    this.applyDebounced = () => {
      this.debouncePending = true;
      debounceFunc();
    };
  }
  checkApplyDebounce() {
    if (this.debouncePending) {
      this.debouncePending = false;
      this.doApplyModel();
    }
  }
  /**
   * @deprecated v34 Use (`api.getColumnFilterModel()`) instead.
   */
  getModel() {
    _warn(285);
    return this.params.model;
  }
  /**
   * @deprecated v34 Use (`api.setColumnFilterModel()`) instead.
   */
  setModel(model) {
    _warn(286);
    const { beans, params } = this;
    return beans.colFilter.setModelForColumnLegacy(params.column, model);
  }
  /**
   * Applies changes made in the UI to the filter, and returns true if the model has changed.
   */
  applyModel(_source = "api") {
    return this.doApplyModel();
  }
  canApply(_model) {
    return true;
  }
  doApplyModel(additionalEventAttributes) {
    const { params, state } = this;
    const changed = !this.areModelsEqual(params.model, state.model);
    if (changed) {
      params.onAction("apply", additionalEventAttributes);
    }
    return changed;
  }
  /**
   * @deprecated v34 Internal method - should only be called by the grid.
   */
  onNewRowsLoaded() {
  }
  /**
   * By default, if the change came from a floating filter it will be applied immediately, otherwise if there is no
   * apply button it will be applied after a debounce, otherwise it will not be applied at all. This behaviour can
   * be adjusted by using the apply parameter.
   */
  onUiChanged(apply, afterFloatingFilter = false) {
    this.updateUiVisibility();
    const model = this.getModelFromUi();
    const state = {
      model,
      state: this.getState(),
      valid: this.canApply(model)
    };
    this.state = state;
    const params = this.params;
    params.onStateChange(state);
    params.onUiChange(this.getUiChangeEventParams());
    if (!this.gos.get("enableFilterHandlers")) {
      this.eventSvc.dispatchEvent({
        type: "filterModified",
        column: params.column,
        filterInstance: this
      });
    }
    apply ?? (apply = this.applyActive ? void 0 : "debounce");
    if (apply === "immediately") {
      this.doApplyModel({ afterFloatingFilter, afterDataChange: false });
    } else if (apply === "debounce") {
      this.applyDebounced();
    }
  }
  getState() {
    return void 0;
  }
  getUiChangeEventParams() {
    return void 0;
  }
  afterGuiAttached(params) {
    this.lastContainerType = params?.container;
    this.refreshFilterResizer(params?.container);
  }
  refreshFilterResizer(containerType) {
    const { positionableFeature, gos } = this;
    if (!positionableFeature) {
      return;
    }
    const isResizable = containerType === "floatingFilter" || containerType === "columnFilter";
    if (isResizable) {
      positionableFeature.restoreLastSize();
      positionableFeature.setResizable(
        gos.get("enableRtl") ? { bottom: true, bottomLeft: true, left: true } : { bottom: true, bottomRight: true, right: true }
      );
    } else {
      positionableFeature.removeSizeFromEl();
      positionableFeature.setResizable(false);
    }
    positionableFeature.constrainSizeToAvailableHeight(isResizable);
  }
  afterGuiDetached() {
    this.checkApplyDebounce();
    this.positionableFeature?.constrainSizeToAvailableHeight(false);
  }
  destroy() {
    this.positionableFeature = this.destroyBean(this.positionableFeature);
    super.destroy();
  }
  translate(key) {
    return translateForFilter(this, key);
  }
  // override to control positionable feature
  getPositionableElement() {
    return this.getGui();
  }
  areModelsEqual(a, b) {
    if (a === b || a == null && b == null) {
      return true;
    }
    if (a == null || b == null) {
      return false;
    }
    return this.areNonNullModelsEqual(a, b);
  }
};

// packages/ag-grid-community/src/filter/provided/iSimpleFilter.ts
function isCombinedFilterModel(model) {
  return !!model.operator;
}

// packages/ag-grid-community/src/filter/floating/floatingFilterMapper.ts
function _getDefaultFloatingFilterType(frameworkOverrides, def, getFromDefault) {
  if (def == null) {
    return null;
  }
  let defaultFloatingFilterType = null;
  const { compName, jsComp, fwComp } = _getFilterCompKeys(frameworkOverrides, def);
  if (compName) {
    const floatingFilterTypeMap = {
      agSetColumnFilter: "agSetColumnFloatingFilter",
      agMultiColumnFilter: "agMultiColumnFloatingFilter",
      agGroupColumnFilter: "agGroupColumnFloatingFilter",
      agNumberColumnFilter: "agNumberColumnFloatingFilter",
      agDateColumnFilter: "agDateColumnFloatingFilter",
      agTextColumnFilter: "agTextColumnFloatingFilter"
    };
    defaultFloatingFilterType = floatingFilterTypeMap[compName];
  } else {
    const usingDefaultFilter = jsComp == null && fwComp == null && def.filter === true;
    if (usingDefaultFilter) {
      defaultFloatingFilterType = getFromDefault();
    }
  }
  return defaultFloatingFilterType;
}

// packages/ag-grid-community/src/styling/layoutFeature.ts
var LayoutCssClasses = {
  AUTO_HEIGHT: "ag-layout-auto-height",
  NORMAL: "ag-layout-normal",
  PRINT: "ag-layout-print"
};
var LayoutFeature = class extends BeanStub {
  constructor(view) {
    super();
    this.view = view;
  }
  postConstruct() {
    this.addManagedPropertyListener("domLayout", this.updateLayoutClasses.bind(this));
    this.updateLayoutClasses();
  }
  updateLayoutClasses() {
    const domLayout = this.gos.get("domLayout");
    const params = {
      autoHeight: domLayout === "autoHeight",
      normal: domLayout === "normal",
      print: domLayout === "print"
    };
    const cssClass = params.autoHeight ? LayoutCssClasses.AUTO_HEIGHT : params.print ? LayoutCssClasses.PRINT : LayoutCssClasses.NORMAL;
    this.view.updateLayoutClasses(cssClass, params);
  }
};

// packages/ag-grid-community/src/constants/direction.ts
var Direction = /* @__PURE__ */ ((Direction2) => {
  Direction2[Direction2["Vertical"] = 0] = "Vertical";
  Direction2[Direction2["Horizontal"] = 1] = "Horizontal";
  return Direction2;
})(Direction || {});

// packages/ag-grid-community/src/gridBodyComp/gridBodyScrollFeature.ts
var VIEWPORT = "Viewport";
var FAKE_V_SCROLLBAR = "fakeVScrollComp";
var HORIZONTAL_SOURCES = [
  "fakeHScrollComp",
  "centerHeader",
  "topCenter",
  "bottomCenter",
  "stickyTopCenter",
  "stickyBottomCenter"
];
var SCROLL_DEBOUNCE_TIMEOUT = 100;
var SCROLL_END_TIMEOUT = 150;
var GridBodyScrollFeature = class extends BeanStub {
  constructor(eBodyViewport) {
    super();
    // listeners for when ensureIndexVisible is waiting for SSRM data to load
    this.clearRetryListenerFncs = [];
    this.lastScrollSource = [null, null];
    this.scrollLeft = -1;
    this.nextScrollTop = -1;
    this.scrollTop = -1;
    // Used to provide approximate values of scrollTop and offsetHeight
    // without forcing the browser to recalculate styles.
    this.lastOffsetHeight = -1;
    this.lastScrollTop = -1;
    this.lastIsHorizontalScrollShowing = false;
    this.scrollTimer = 0;
    this.isScrollActive = false;
    this.isVerticalPositionInvalidated = true;
    this.isHorizontalPositionInvalidated = true;
    this.eBodyViewport = eBodyViewport;
    this.resetLastHScrollDebounced = _debounce(
      this,
      () => this.lastScrollSource[1 /* Horizontal */] = null,
      SCROLL_END_TIMEOUT
    );
    this.resetLastVScrollDebounced = _debounce(
      this,
      () => this.lastScrollSource[0 /* Vertical */] = null,
      SCROLL_END_TIMEOUT
    );
  }
  wireBeans(beans) {
    this.ctrlsSvc = beans.ctrlsSvc;
    this.animationFrameSvc = beans.animationFrameSvc;
    this.visibleCols = beans.visibleCols;
  }
  destroy() {
    super.destroy();
    this.clearRetryListenerFncs = [];
    window.clearTimeout(this.scrollTimer);
  }
  postConstruct() {
    this.enableRtl = this.gos.get("enableRtl");
    const invalidateVerticalScroll = this.invalidateVerticalScroll.bind(this);
    const invalidateHorizontalScroll = this.invalidateHorizontalScroll.bind(this);
    this.addManagedEventListeners({
      displayedColumnsWidthChanged: this.onDisplayedColumnsWidthChanged.bind(this),
      gridSizeChanged: invalidateVerticalScroll,
      // We only invalidate horizontal scrolling when the viewport switches
      // between scrollable and non-scrollable, avoiding unnecessary
      // invalidation on every gridSizeChanged event. If more properties
      // require invalidation, read/write DOM cycles may be needed.
      scrollGapChanged: invalidateHorizontalScroll
    });
    this.addManagedElementListeners(this.eBodyViewport, {
      scroll: invalidateVerticalScroll
    });
    this.ctrlsSvc.whenReady(this, (p) => {
      this.centerRowsCtrl = p.center;
      this.onDisplayedColumnsWidthChanged();
      this.addScrollListener();
    });
  }
  invalidateHorizontalScroll() {
    this.isHorizontalPositionInvalidated = true;
  }
  invalidateVerticalScroll() {
    this.isVerticalPositionInvalidated = true;
  }
  addScrollListener() {
    this.addHorizontalScrollListeners();
    this.addVerticalScrollListeners();
  }
  addHorizontalScrollListeners() {
    this.addManagedElementListeners(this.centerRowsCtrl.eViewport, {
      scroll: this.onHScroll.bind(this, VIEWPORT)
    });
    for (const source of HORIZONTAL_SOURCES) {
      const scrollPartner = this.ctrlsSvc.get(source);
      this.registerScrollPartner(scrollPartner, this.onHScroll.bind(this, source));
    }
  }
  addVerticalScrollListeners() {
    const fakeVScrollComp = this.ctrlsSvc.get("fakeVScrollComp");
    const isDebounce = this.gos.get("debounceVerticalScrollbar");
    const onVScroll = isDebounce ? _debounce(this, this.onVScroll.bind(this, VIEWPORT), SCROLL_DEBOUNCE_TIMEOUT) : this.onVScroll.bind(this, VIEWPORT);
    const onFakeVScroll = isDebounce ? _debounce(this, this.onVScroll.bind(this, FAKE_V_SCROLLBAR), SCROLL_DEBOUNCE_TIMEOUT) : this.onVScroll.bind(this, FAKE_V_SCROLLBAR);
    this.addManagedElementListeners(this.eBodyViewport, { scroll: onVScroll });
    this.registerScrollPartner(fakeVScrollComp, onFakeVScroll);
  }
  registerScrollPartner(comp, callback) {
    comp.onScrollCallback(callback);
  }
  onDisplayedColumnsWidthChanged() {
    if (this.enableRtl) {
      this.horizontallyScrollHeaderCenterAndFloatingCenter();
    }
  }
  horizontallyScrollHeaderCenterAndFloatingCenter(scrollLeft) {
    const notYetInitialised = this.centerRowsCtrl == null;
    if (notYetInitialised) {
      return;
    }
    if (scrollLeft === void 0) {
      scrollLeft = this.centerRowsCtrl.getCenterViewportScrollLeft();
    }
    this.setScrollLeftForAllContainersExceptCurrent(Math.abs(scrollLeft));
  }
  setScrollLeftForAllContainersExceptCurrent(scrollLeft) {
    for (const container of [...HORIZONTAL_SOURCES, VIEWPORT]) {
      if (this.lastScrollSource[1 /* Horizontal */] === container) {
        continue;
      }
      const viewport = this.getViewportForSource(container);
      _setScrollLeft(viewport, scrollLeft, this.enableRtl);
    }
  }
  getViewportForSource(source) {
    if (source === VIEWPORT) {
      return this.centerRowsCtrl.eViewport;
    }
    return this.ctrlsSvc.get(source).eViewport;
  }
  isControllingScroll(source, direction) {
    if (this.lastScrollSource[direction] == null) {
      if (direction === 0 /* Vertical */) {
        this.lastScrollSource[0] = source;
      } else {
        this.lastScrollSource[1] = source;
      }
      return true;
    }
    return this.lastScrollSource[direction] === source;
  }
  onHScroll(source) {
    if (!this.isControllingScroll(source, 1 /* Horizontal */)) {
      return;
    }
    const centerContainerViewport = this.centerRowsCtrl.eViewport;
    const { scrollLeft } = centerContainerViewport;
    if (this.shouldBlockScrollUpdate(1 /* Horizontal */, scrollLeft, true)) {
      return;
    }
    const newScrollLeft = _getScrollLeft(this.getViewportForSource(source), this.enableRtl);
    this.doHorizontalScroll(newScrollLeft);
    this.resetLastHScrollDebounced();
  }
  onVScroll(source) {
    if (!this.isControllingScroll(source, 0 /* Vertical */)) {
      return;
    }
    let scrollTop;
    if (source === VIEWPORT) {
      scrollTop = this.eBodyViewport.scrollTop;
    } else {
      scrollTop = this.ctrlsSvc.get("fakeVScrollComp").getScrollPosition();
    }
    if (this.shouldBlockScrollUpdate(0 /* Vertical */, scrollTop, true)) {
      return;
    }
    const { animationFrameSvc } = this;
    animationFrameSvc?.setScrollTop(scrollTop);
    this.nextScrollTop = scrollTop;
    if (source === VIEWPORT) {
      this.ctrlsSvc.get("fakeVScrollComp").setScrollPosition(scrollTop);
    } else {
      this.eBodyViewport.scrollTop = scrollTop;
    }
    if (animationFrameSvc?.active) {
      animationFrameSvc.schedule();
    } else {
      this.scrollGridIfNeeded(true);
    }
    this.resetLastVScrollDebounced();
  }
  doHorizontalScroll(scrollLeft) {
    const fakeScrollLeft = this.ctrlsSvc.get("fakeHScrollComp").getScrollPosition();
    if (this.scrollLeft === scrollLeft && scrollLeft === fakeScrollLeft) {
      return;
    }
    this.scrollLeft = scrollLeft;
    this.fireScrollEvent(1 /* Horizontal */);
    this.horizontallyScrollHeaderCenterAndFloatingCenter(scrollLeft);
    this.centerRowsCtrl.onHorizontalViewportChanged(true);
  }
  isScrolling() {
    return this.isScrollActive;
  }
  fireScrollEvent(direction) {
    const bodyScrollEvent = {
      type: "bodyScroll",
      direction: direction === 1 /* Horizontal */ ? "horizontal" : "vertical",
      left: this.scrollLeft,
      top: this.scrollTop
    };
    this.isScrollActive = true;
    this.eventSvc.dispatchEvent(bodyScrollEvent);
    window.clearTimeout(this.scrollTimer);
    this.scrollTimer = window.setTimeout(() => {
      this.scrollTimer = 0;
      this.isScrollActive = false;
      this.eventSvc.dispatchEvent({
        ...bodyScrollEvent,
        type: "bodyScrollEnd"
      });
    }, SCROLL_END_TIMEOUT);
  }
  shouldBlockScrollUpdate(direction, scrollTo, touchOnly = false) {
    if (touchOnly && !_isIOSUserAgent()) {
      return false;
    }
    if (direction === 0 /* Vertical */) {
      return this.shouldBlockVerticalScroll(scrollTo);
    }
    return this.shouldBlockHorizontalScroll(scrollTo);
  }
  shouldBlockVerticalScroll(scrollTo) {
    const clientHeight = _getInnerHeight(this.eBodyViewport);
    const { scrollHeight } = this.eBodyViewport;
    if (scrollTo < 0 || scrollTo + clientHeight > scrollHeight) {
      return true;
    }
    retur