import os
from enum import Enum

from aext_shared.config import SHARED_CONFIG

config = SHARED_CONFIG


class Environment(str, Enum):
    LOCAL = "local"
    STAGING = "staging"
    PRODUCTION = "production"


class MS_API_Version(str, Enum):
    V1 = "v1"
    V2 = "v2"


# FEATURE FLAGS

# PYTHONANYWHERE
PYTHONANYWHERE_PRODUCTION_SITE = f"nb.{config['api']['domain']}"
PANELS_PRODUCTION_DOMAIN = "anacondaapps.cloud"

# PYTHONANYWHERE RESPONSES
WEBAPP_DOMAIN_ALREADY_EXISTS = "domain with this domain name already exists."

# GENERAL
MAX_NUM_WEB_APP_CREATION_ATTEMPTS = 3
MAX_NUM_WEB_APPS = 4

PROJECT_ROOT_PATH = "/var/www/panels/"
PROJECT_LOG_PATH = "/var/log"
ACCESS_LOG = "access_log"
ERROR_LOG = "error_log"
SERVER_LOG = "server_log"

DEFAULT_HTTPX_TIMEOUT_SEC = 3

PANEL_CONDA_EXE = "/opt/conda/condabin/conda"
PANEL_APP_TEMP_DIR = "/var/www/panels/temp"
PANEL_BASE_COMMAND = "/bin/bash -c 'CONDA_EXE={PANEL_CONDA_EXE} {PANEL_CONDA_EXE} project run --project-archive {ARCHIVE_PATH} --directory {PANEL_APP_TEMP_DIR} --external-env {ENVIRONMENT} serve --unix-socket ${{DOMAIN_SOCKET}} --allow-websocket-origin {DOMAIN}  --liveness --log-level trace'"

# KERNELS
PANEL_VALID_KERNELS_PATTERN = "anaconda-panel"  # currently used in production
PANEL_PACKAGE_NAME = "panel"
NBCONVERT_PACKAGE_NAME = "nbconvert"
PANEL_PACKAGE_MINIMUM_VERSION = "1.0.4"

DEV_USE_STAGING_MICROSERVICE = "DEV_USE_STAGING_MICROSERVICE"

# NOTEBOOK METADATA
ALLOWED_CELL_METADATA = ["panel-layout"]
ALLOWED_NB_METADATA = ["panel-cell-order"]


class AppStatus(Enum):
    @classmethod
    def list(cls):
        return list(map(lambda c: c.value, cls))

    RUNNING = "running"
    INACTIVE = "inactive"
    FAILED = "failed"
    PUBLISHED = "published"
    PUBLISHING = "publishing"
