from pathlib import Path

import tornado

PAYLOAD_1 = {
    "filename": [
        tornado.httputil.HTTPFile(
            {"filename": "conda-project.yaml", "body": (b"name: test\n"), "content_type": "text/plain"},
        ),
        tornado.httputil.HTTPFile({"filename": "file.ipynb", "body": (b"name: test\n"), "content_type": "text/plain"}),
    ]
}

PAYLOAD_2 = {
    "filename": [
        tornado.httputil.HTTPFile(
            {"filename": "file.ipynb", "body": (b"name: test new upload\n"), "content_type": "text/plain"}
        ),
    ]
}

with open(Path(__file__).parent / "notebook-readonly-1.ipynb", "rb") as f:
    notebook_readonly1_contents = f.read()

NOTEBOOK1_PAYLOAD = [
    tornado.httputil.HTTPFile(
        {"filename": "notebook1.ipynb", "body": notebook_readonly1_contents, "content_type": "text/plain"}
    ),
]

with open(Path(__file__).parent / "notebook-readonly-2.ipynb", "rb") as f:
    notebook_readonly2_contents = f.read()

NOTEBOOK2_PAYLOAD = [
    tornado.httputil.HTTPFile(
        {"filename": "notebook2.ipynb", "body": notebook_readonly2_contents, "content_type": "text/plain"}
    ),
]

with open(Path(__file__).parent / "notebook-custom.ipynb", "rb") as f:
    notebook_custom_contents = f.read()

NOTEBOOK3_PAYLOAD = [
    tornado.httputil.HTTPFile(
        {"filename": "notebook3.ipynb", "body": notebook_custom_contents, "content_type": "text/plain"}
    ),
]

EXPECTED_RESPONSE_1 = {
    "name": "subfolder/",
    "key": "subfolder/",
    "type": "directory",
    "status": "unstaged",
    "contents": [
        {
            "name": "conda-project.yaml",
            "key": "subfolder/conda-project.yaml",
            "type": "file",
            "status": "unstaged",
            "contents": [],
            "details": None,
            "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
        },
        {
            "name": "file.ipynb",
            "key": "subfolder/file.ipynb",
            "type": "file",
            "status": "unstaged",
            "contents": [],
            "details": None,
            "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
        },
    ],
    "details": None,
    "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
}

EXPECTED_LIST_PROJECTS = [
    {
        "id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
        "name": "my-project",
        "title": "my projeeectttt",
        "created_at": "2024-04-25 09:07:43.571224",
        "updated_at": "2024-04-25 09:07:43.571224",
        "metadata": {"user_client": "foo", "hidden": False, "tags": []},
        "owner": {"id": "62e920db-1a14-41ca-93a2-98b36dd695c1", "type": "-", "name": "Romulo"},
        "status": "unstaged",
        "contents": [
            {
                "key": "tmp",
                "name": "tmp",
                "type": "directory",
                "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
                "status": "unstaged",
                "contents": [
                    {
                        "key": "tmp/project",
                        "name": "project",
                        "type": "directory",
                        "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
                        "status": "unstaged",
                        "contents": [
                            {
                                "key": "tmp/project/bar.txt",
                                "name": "bar.txt",
                                "type": "file",
                                "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
                                "status": "unstaged",
                                "contents": [],
                                "details": {
                                    "file_version_id": "uuid",
                                },
                            },
                            {
                                "key": "tmp/project/foo.txt",
                                "name": "foo.txt",
                                "type": "file",
                                "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
                                "status": "unstaged",
                                "contents": [],
                                "details": {
                                    "file_version_id": "uuid",
                                },
                            },
                        ],
                        "details": None,
                    }
                ],
                "details": None,
            }
        ],
        "default_environment": "anaconda-panel-2023.05-py310",
    }
]
