import tornado

PAYLOAD_1 = {
    "filenames": [
        tornado.httputil.HTTPFile(
            {"filename": "conda-project.yaml", "body": (b"name: test\n"), "content_type": "text/plain"},
        ),
        tornado.httputil.HTTPFile({"filename": "file.ipynb", "body": (b"name: test\n"), "content_type": "text/plain"}),
    ]
}

PAYLOAD_2 = {
    "filenames": [
        tornado.httputil.HTTPFile(
            {"filename": "file.ipynb", "body": (b"name: test new upload\n"), "content_type": "text/plain"}
        ),
    ]
}


EXPECTED_RESPONSE_1 = {
    "key": "subfolder",
    "name": "subfolder",
    "type": "directory",
    "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
    "contents": [
        {
            "name": "conda-project.yaml",
            "key": "subfolder/conda-project.yaml",
            "type": "file",
            "status": "unstaged",
            "contents": [],
            "details": None,
            "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
            "metadata": {},
        },
        {
            "name": "file.ipynb",
            "key": "subfolder/file.ipynb",
            "type": "file",
            "status": "unstaged",
            "contents": [],
            "details": None,
            "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
            "metadata": {},
        },
    ],
    "details": None,
    "status": "unstaged",
    "metadata": {},
}

EXPECTED_LIST_PROJECTS = [
    {
        "id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
        "name": "my-project",
        "title": "my projeeectttt",
        "created_at": "2024-04-25 09:07:43.571224",
        "updated_at": "2024-04-25 09:07:43.571224",
        "metadata": {"user_client": "foo", "hidden": False, "tags": []},
        "owner": {"id": "62e920db-1a14-41ca-93a2-98b36dd695c1", "type": "-", "name": "Romulo"},
        "contents": [
            {
                "key": "tmp",
                "name": "tmp",
                "type": "directory",
                "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
                "status": "unstaged",
                "contents": [
                    {
                        "key": "tmp/project",
                        "name": "project",
                        "type": "directory",
                        "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
                        "status": "unstaged",
                        "contents": [
                            {
                                "key": "tmp/project/bar.txt",
                                "name": "bar.txt",
                                "type": "file",
                                "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
                                "status": "unstaged",
                                "contents": [],
                                "details": {"file_version_id": "uuid", "metadata": {}},
                                "metadata": {},
                            },
                            {
                                "key": "tmp/project/foo.txt",
                                "name": "foo.txt",
                                "type": "file",
                                "project_id": "fd090b04-a847-4c5b-bc54-ab75025e77a9",
                                "status": "unstaged",
                                "contents": [],
                                "details": {"file_version_id": "uuid", "metadata": {}},
                                "metadata": {},
                            },
                        ],
                        "details": None,
                        "metadata": {},
                    }
                ],
                "details": None,
                "metadata": {},
            }
        ],
        "default_environment": "anaconda-panel-2023.05-py310",
        "status": "unstaged",
    }
]
