import os
from unittest import mock

import pytest
from aext_project_filebrowser_server import consts
from aext_project_filebrowser_server.consts import (
    FILEBROWSER_CLOUD_ENVIRONMENT_BASE_DIR,
)


@pytest.mark.parametrize(
    "_is_local, expected",
    [(True, consts.FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR), (False, FILEBROWSER_CLOUD_ENVIRONMENT_BASE_DIR)],
)
def test_get_projects_default_base_dir(_is_local, expected):
    with mock.patch("aext_project_filebrowser_server.consts.IS_LOCAL_ENVIRONMENT", new=_is_local):
        assert consts.get_projects_default_base_dir() == expected
