"""add_owner_proj_name_to_projects_table

Revision ID: a4d46f4a8a45
Revises: 5bf343fa9dab
Create Date: 2024-04-11 07:20:57.004176

"""

from typing import Sequence, Union

import sqlalchemy as sa
from alembic import op

# revision identifiers, used by Alembic.
revision: str = "a4d46f4a8a45"
down_revision: Union[str, None] = "5bf343fa9dab"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # SQLite does not accept altering tables to add constraints, therefore a multiple step migration approach is necessary.

    # 1st step is to create a new table with the desired schema and constraints
    op.create_table(
        "projects_new",
        sa.Column("id", sa.Integer, primary_key=True),
        sa.Column("data", sa.TEXT(), nullable=True),
        sa.Column("owner", sa.TEXT(), nullable=True),
        sa.Column("name", sa.TEXT(), nullable=True),
        sa.UniqueConstraint("owner", "name", name="uq_owner_name_new"),
    )

    # 2nd step is to copy data from the old table to the new one
    op.execute("INSERT INTO projects_new (id, data) SELECT id, data FROM projects")

    # 3rd step is to drop the old table
    op.drop_table("projects")

    # 4th step is to rename the new table to match the original table"s name
    op.rename_table("projects_new", "projects")


def downgrade() -> None:
    op.create_table(
        "projects_new",
        sa.Column("id", sa.Integer, primary_key=True),
        sa.Column("data", sa.TEXT(), nullable=True),
    )
    op.execute("INSERT INTO projects_new (id, data) SELECT id, data FROM projects")
    op.drop_table("projects")
    op.rename_table("projects_new", "projects")
