from datetime import datetime

from aext_project_filebrowser_server.consts import FileType
from aext_project_filebrowser_server.schemas.cloud_project import CloudProjectFile


def test_cloud_project_file_schema_should_not_fail_when_extra_kwargs_are_passed():
    data = {
        "name": "FileName",
        "description": "FileDescription",
        "writtenby": "User",
        "size": 12,
        "etag": "aaeerrrrr",
        "last_modified": datetime(2025, 2, 1),
        "file_version_id": "version-id",
        "url": "http://file.com",
        "signed_url": "http://file.com",
        "metadata": "111222333444555666777",
        "project_id": "project-id",
        "deleted": False,
        "pending": False,
        "type": FileType.FILE,
        "UNEXPECTED-KWARG": "UNEXPECTED FIELD",
    }
    cloud_project_file = CloudProjectFile(**data)
    assert cloud_project_file
