from aext_project_filebrowser_server.__about__ import __version__
from aext_project_filebrowser_server.data_migrations.projects_files_migration import (
    run_projects_files_migration,
)
from aext_project_filebrowser_server.handlers import get_routes
from aext_project_filebrowser_server.migrations import migration_upgrade
from aext_project_filebrowser_server.project_setup import project_configure
from aext_project_filebrowser_server.services.watchdog import watchdog_service
from aext_project_filebrowser_server.utils import (
    is_github_actions_runner,
    is_pytest_running,
    sphinx_running,
)

if not is_github_actions_runner() and not is_pytest_running() and not sphinx_running():
    # for simplicity the upgrade does not run when tests
    # or when the code is being executed in GH runners
    # there are different settings for those situations and they handle the migration by themselves
    migration_upgrade()
    project_configure()
    run_projects_files_migration()
    watchdog_service.watch()
