import os.path
import sys
from unittest import mock

import pytest
from aext_project_filebrowser_server.consts import (
    FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR,
    OSPlatformTypes,
    get_projects_default_base_dir,
)
from aext_project_filebrowser_server.migrations import AlembicConfig

from aext_shared import Environment


@pytest.mark.parametrize(
    "environment, is_local_environment, system, expected",
    [
        (
            Environment.cloud_production,
            False,
            OSPlatformTypes.LINUX,
            {
                "db_conn_url": "sqlite:////var/www/filebrowser/project_filebrowser.db",
                "db_path": "/var/www/filebrowser/project_filebrowser.db",
            },
        ),
        (
            Environment.cloud_development,
            False,
            OSPlatformTypes.LINUX,
            {
                "db_conn_url": "sqlite:////var/www/filebrowser/project_filebrowser.db",
                "db_path": "/var/www/filebrowser/project_filebrowser.db",
            },
        ),
        (
            Environment.local_development,
            True,
            OSPlatformTypes.LINUX,
            {
                "db_conn_url": f"sqlite:///{os.path.join(FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR, 'db', 'project_filebrowser.db')}",
                "db_path": os.path.join(FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR, "db", "project_filebrowser.db"),
            },
        ),
        (
            Environment.local_development,
            True,
            OSPlatformTypes.MACOS,
            {
                "db_conn_url": f"sqlite:///{os.path.join(FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR, 'db','project_filebrowser.db')}",
                "db_path": os.path.join(FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR, "db", "project_filebrowser.db"),
            },
        ),
        (
            Environment.local_development,
            True,
            OSPlatformTypes.WINDOWS,
            {
                "db_conn_url": f"sqlite:///{os.path.join(FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR, 'db','project_filebrowser.db')}",
                "db_path": os.path.join(FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR, "db", "project_filebrowser.db"),
            },
        ),
        (
            Environment.local_production,
            True,
            OSPlatformTypes.LINUX,
            {
                "db_conn_url": f"sqlite:///{os.path.join(FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR, 'db', 'project_filebrowser.db')}",
                "db_path": os.path.join(FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR, "db", "project_filebrowser.db"),
            },
        ),
        (
            Environment.local_production,
            True,
            OSPlatformTypes.MACOS,
            {
                "db_conn_url": f"sqlite:///{os.path.join(FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR, 'db','project_filebrowser.db')}",
                "db_path": os.path.join(FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR, "db", "project_filebrowser.db"),
            },
        ),
        (
            Environment.local_production,
            True,
            OSPlatformTypes.WINDOWS,
            {
                "db_conn_url": f"sqlite:///{os.path.join(FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR, 'db','project_filebrowser.db')}",
                "db_path": os.path.join(FILEBROWSER_LOCAL_ENVIRONMENT_BASE_DIR, "db", "project_filebrowser.db"),
            },
        ),
    ],
)
@pytest.mark.skipif(sys.platform.startswith("win"), reason="needs to be adapted")
def test_alembic_get_config_data(environment, is_local_environment, system, expected):
    with mock.patch("aext_project_filebrowser_server.consts.ENVIRONMENT", new=environment):
        with mock.patch("aext_project_filebrowser_server.consts.OS_PLATFORM", new=system):
            with mock.patch("aext_project_filebrowser_server.consts.IS_LOCAL_ENVIRONMENT", new=is_local_environment):
                base_dir = get_projects_default_base_dir()
                config = AlembicConfig(environment, system, base_dir)
                config_data = config.get_config_data()
                assert config_data == expected
