from urllib.parse import urlparse
from urllib.parse import urlunparse

import pytest
from conda.base import context  # noqa: E402
from conda.gateways.connection.session import CondaHttpAuth
from conda.gateways.connection.session import CondaSession
from requests import HTTPError

from anaconda_auth._conda.conda_api import Commands
from anaconda_auth._conda.conda_api import run_command
from anaconda_auth._conda.repo_config import CondaTokenError
from anaconda_auth._conda.repo_config import token_list
from anaconda_auth._conda.repo_config import validate_token


def test_add_token(set_dummy_token, repodata_url, repo_url):
    assert token_list()[repo_url] == "SECRET"

    base_url = (
        repodata_url  # 'https://repo.anaconda.cloud/repo/main/osx-64/repodata.json'
    )
    scheme, netloc, path, *rest = urlparse(base_url)
    path = "/t/SECRET" + path
    token_url = urlunparse((scheme, netloc, path, *rest))
    assert CondaHttpAuth.add_binstar_token(base_url) == token_url


def test_channeldata_403(remove_token, channeldata_url):
    session = CondaSession()
    r = session.get(channeldata_url)
    with pytest.raises(HTTPError):
        r.raise_for_status()
    assert r.status_code == 403


@pytest.mark.skip(reason="blocking release in CI but passing fine locally")
def test_repodata_200(set_secret_token_mock_server, repodata_url):
    token_url = CondaHttpAuth.add_binstar_token(repodata_url)

    session = CondaSession()
    r = session.head(token_url)
    assert r.status_code == 200


# repo_url fixture configures test server, patches REPO_URL
def test_validate_token_error(repo_url):
    with pytest.raises(CondaTokenError):
        validate_token("SECRET")


# repo_url fixture configures test server, patches REPO_URL
@pytest.mark.skip(reason="blocking release in CI but passing fine locally")
def test_validate_token_works(secret_token, repo_url):
    assert validate_token(secret_token) is None


def test_conda_context(condarc_path):
    run_command(
        Commands.CONFIG,
        "--set",
        "ssl_verify",
        "false",
        f"--file={condarc_path}",
        use_exception_handler=True,
    )
    context.reset_context()
    assert not context.context.ssl_verify
