"""Conda specific ssl-related utils."""

import typing
from pathlib import Path

SSL_OPTIONS: typing.Final[frozenset[str]] = frozenset({'truststore', ''})


def check_cert_option(certificate: str) -> bool:
    """Check if `ssl_verify` certificate value is valid."""
    certificate = certificate.strip()
    return certificate in SSL_OPTIONS or Path(certificate).is_file()
