# -*- coding: utf-8 -*-

# pylint: disable=too-few-public-methods

"""Common widgets with custom styles."""

from __future__ import annotations

from qtpy import QtGui

from anaconda_navigator import widgets


class AnacondaNavigatorSvgLogo(widgets.SvgWidget):
    """Custom :class:`~widgets.QSvgWidget` to set Navigator SVG logo via CSS."""


class AnacondaSvgLogo(widgets.SvgWidget):
    """Custom :class:`~widgets.QSvgWidget` to set Anaconda SVG logo via CSS."""


class PasswordVisibleIcon(QtGui.QIcon):
    """Custom :class:`~QtGui.QIcon` to set visible password icon via CSS."""


class PasswordHiddenIcon(QtGui.QIcon):
    """Custom :class:`~QtGui.QIcon` to set hidden password icon via CSS."""
