# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel

# -----------------------------------------------------------------------------
# Copyright (c) 2016-2017 Anaconda, Inc.
#
# May be copied and distributed freely only as part of an Anaconda or
# Miniconda installation.
# -----------------------------------------------------------------------------

"""Tests for valid urls in bundled content."""

from __future__ import annotations

__all__ = ()

import typing


def test_content_encoding():
    """Make sure the bundled content is ascii."""
    from anaconda_navigator.static import content

    # See: https://github.com/ContinuumIO/navigator/issues/1613
    stream: typing.TextIO
    with open(content.LINKS_INFO_PATH, 'r', encoding='utf8') as stream:
        stream.read()
