# -*- coding: utf-8 -*-

# pylint: disable=import-outside-toplevel

# -----------------------------------------------------------------------------
# Copyright (c) 2016-2017 Anaconda, Inc.
#
# May be copied and distributed freely only as part of an Anaconda or
# Miniconda installation.
# -----------------------------------------------------------------------------

"""Tests for bundled image content."""

from __future__ import annotations

__all__ = ()

import os


def test_bundled_images_exist():
    """Check that all image files actually exist."""
    from anaconda_navigator.static import images
    from anaconda_navigator.utils import styles

    styles.load_style_sheet()

    variables = [
        var
        for var in dir(images)
        if var.isupper()
    ]
    paths = [
        getattr(images, var)
        for var in variables
    ]
    for attr in dir(styles.SASS_VARIABLES):
        if attr.startswith('ICON_'):
            paths.append(getattr(styles.SASS_VARIABLES, attr))

    for path in paths:
        assert os.path.exists(path)
