# -*- coding: utf-8 -*-

"""
The most basic tests.

Used to check the behavior of small independent utilities or parts of the components.

Usually, such tests should not have huge testing scenarios, just a few calls with result/delta checks.

When you don't want a unit test
===============================

If test requires checking an external interface of a component - you should consider writing a component test instead of
a unit test. This also applies to checking anything that may change any project-related resources (e.g. configuration
files).

.. note::

    If test requires working with a file system - consider creating a temporary files or folders to run tests against.

    For such cases you can use :code:`temporary_file` or :code:`temporary_directory` test fixtures.

If unit test requires any component as a dependency (argument or whatever) - consider using mocks for such cases.
Ideally there should be no external communication involved (web api requests, external application calls). If you
require to check these - you should consider writing an integration test for such purpose.

Where to put tests
==================

These tests should be located according to their original testing target. E.g. if you check function
:code:`do_something` in `anaconda_navigator.api.external_apps.base` module, you should place the test in the file
:code:`tests/unit_tests/api/external_apps/test_base.py` and call the test something like :code:`test_do_something`. The
name of the test might be different, but it must contain a :code:`test_` prefix and contain a name of the component that
is tested.

Advises
=======

.. note::

    You could use parameterization to cover multiple cases with a single test.

    E.g. you may check that some directory is created. With parameterization - you could check multiple directory cases,
    like "directory name containing spaces", "non-latin letters", "unicode smiles" etc.

    Such approach allows extending coverage by possible use cases and detecting issues early.

.. note::

    Besides "positive" tests (we ask to do something and get the expected result) it is also advised to write some
    "negative" tests (ask to do something invalid and expect that component would process error as expected and
    won't break the whole application).
"""
