# -*- coding: utf-8 -*-

"""Shortcuts for shell (terminal/console) commands."""

from __future__ import annotations

__all__ = ['conda']

import json
import os
import subprocess  # nosec
import typing


def conda(*args: str) -> typing.Any:
    """Execute Conda command."""
    result = subprocess.check_output([os.environ.get('CONDA_EXE', 'conda'), *args])  # nosec
    if '--json' in args:
        return json.loads(result)
    return result
