# -*- coding: utf-8 -*-

"""
Tests used to validate the content of the Anaconda Navigator.

These are not the usual tests that generally check the behavior. Instead - they check the content shipped with and
accessed by the Navigator (e.g. bundled configuration files are in correct format, path to static images are valid,
images are not broken, URLs are available, some values in expected ranges, internal instances are valid, etc.).

.. warning::

    These tests do not use the separate HOME environments, and thus they should be used just for validations without
    running any application components, which may modify preferences or update local state.

.. note::

    In case of checking URLs - unavailable Internet connection, or occasional unrelated server failures (code 500)
    should not be considered as a test fail. Instead - such cases should be considered as an expected fails (look for
    xfail in pytest).

    If resource fails with 404 or any other user error - then it should be considered as an error.

Where to put tests
==================

All such tests should be placed directly in the :mod:`~tests.validations` package. There is no need to copy the existing
package structure of the project - just a flat list of validations.
"""
