"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import authzed.api.v1.core_pb2
import authzed.api.v1.debug_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import google.protobuf.struct_pb2
import google.protobuf.timestamp_pb2
import google.rpc.status_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _LookupPermissionship:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _LookupPermissionshipEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_LookupPermissionship.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    LOOKUP_PERMISSIONSHIP_UNSPECIFIED: _LookupPermissionship.ValueType  # 0
    LOOKUP_PERMISSIONSHIP_HAS_PERMISSION: _LookupPermissionship.ValueType  # 1
    LOOKUP_PERMISSIONSHIP_CONDITIONAL_PERMISSION: _LookupPermissionship.ValueType  # 2

class LookupPermissionship(_LookupPermissionship, metaclass=_LookupPermissionshipEnumTypeWrapper):
    """LookupPermissionship represents whether a Lookup response was partially evaluated or not"""

LOOKUP_PERMISSIONSHIP_UNSPECIFIED: LookupPermissionship.ValueType  # 0
LOOKUP_PERMISSIONSHIP_HAS_PERMISSION: LookupPermissionship.ValueType  # 1
LOOKUP_PERMISSIONSHIP_CONDITIONAL_PERMISSION: LookupPermissionship.ValueType  # 2
global___LookupPermissionship = LookupPermissionship

@typing.final
class Consistency(google.protobuf.message.Message):
    """Consistency will define how a request is handled by the backend.
    By defining a consistency requirement, and a token at which those
    requirements should be applied, where applicable.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MINIMIZE_LATENCY_FIELD_NUMBER: builtins.int
    AT_LEAST_AS_FRESH_FIELD_NUMBER: builtins.int
    AT_EXACT_SNAPSHOT_FIELD_NUMBER: builtins.int
    FULLY_CONSISTENT_FIELD_NUMBER: builtins.int
    minimize_latency: builtins.bool
    """minimize_latency indicates that the latency for the call should be
    minimized by having the system select the fastest snapshot available.
    """
    fully_consistent: builtins.bool
    """fully_consistent indicates that all data used in the API call *must* be
    at the most recent snapshot found.

    NOTE: using this method can be *quite slow*, so unless there is a need to
    do so, it is recommended to use `at_least_as_fresh` with a stored
    ZedToken.
    """
    @property
    def at_least_as_fresh(self) -> authzed.api.v1.core_pb2.ZedToken:
        """at_least_as_fresh indicates that all data used in the API call must be
        *at least as fresh* as that found in the ZedToken; more recent data might
        be used if available or faster.
        """

    @property
    def at_exact_snapshot(self) -> authzed.api.v1.core_pb2.ZedToken:
        """at_exact_snapshot indicates that all data used in the API call must be
        *at the given* snapshot in time; if the snapshot is no longer available,
        an error will be returned to the caller.
        """

    def __init__(
        self,
        *,
        minimize_latency: builtins.bool = ...,
        at_least_as_fresh: authzed.api.v1.core_pb2.ZedToken | None = ...,
        at_exact_snapshot: authzed.api.v1.core_pb2.ZedToken | None = ...,
        fully_consistent: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["at_exact_snapshot", b"at_exact_snapshot", "at_least_as_fresh", b"at_least_as_fresh", "fully_consistent", b"fully_consistent", "minimize_latency", b"minimize_latency", "requirement", b"requirement"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["at_exact_snapshot", b"at_exact_snapshot", "at_least_as_fresh", b"at_least_as_fresh", "fully_consistent", b"fully_consistent", "minimize_latency", b"minimize_latency", "requirement", b"requirement"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["requirement", b"requirement"]) -> typing.Literal["minimize_latency", "at_least_as_fresh", "at_exact_snapshot", "fully_consistent"] | None: ...

global___Consistency = Consistency

@typing.final
class RelationshipFilter(google.protobuf.message.Message):
    """RelationshipFilter is a collection of filters which when applied to a
    relationship will return relationships that have exactly matching fields.

    All fields are optional and if left unspecified will not filter relationships,
    but at least one field must be specified.

    NOTE: The performance of the API will be affected by the selection of fields
    on which to filter. If a field is not indexed, the performance of the API
    can be significantly slower.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_TYPE_FIELD_NUMBER: builtins.int
    OPTIONAL_RESOURCE_ID_FIELD_NUMBER: builtins.int
    OPTIONAL_RESOURCE_ID_PREFIX_FIELD_NUMBER: builtins.int
    OPTIONAL_RELATION_FIELD_NUMBER: builtins.int
    OPTIONAL_SUBJECT_FILTER_FIELD_NUMBER: builtins.int
    resource_type: builtins.str
    """resource_type is the *optional* resource type of the relationship.
    NOTE: It is not prefixed with "optional_" for legacy compatibility.
    """
    optional_resource_id: builtins.str
    """optional_resource_id is the *optional* resource ID of the relationship.
    If specified, optional_resource_id_prefix cannot be specified.
    """
    optional_resource_id_prefix: builtins.str
    """optional_resource_id_prefix is the *optional* prefix for the resource ID of the relationship.
    If specified, optional_resource_id cannot be specified.
    """
    optional_relation: builtins.str
    """relation is the *optional* relation of the relationship."""
    @property
    def optional_subject_filter(self) -> global___SubjectFilter:
        """optional_subject_filter is the optional filter for the subjects of the relationships."""

    def __init__(
        self,
        *,
        resource_type: builtins.str = ...,
        optional_resource_id: builtins.str = ...,
        optional_resource_id_prefix: builtins.str = ...,
        optional_relation: builtins.str = ...,
        optional_subject_filter: global___SubjectFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["optional_subject_filter", b"optional_subject_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["optional_relation", b"optional_relation", "optional_resource_id", b"optional_resource_id", "optional_resource_id_prefix", b"optional_resource_id_prefix", "optional_subject_filter", b"optional_subject_filter", "resource_type", b"resource_type"]) -> None: ...

global___RelationshipFilter = RelationshipFilter

@typing.final
class SubjectFilter(google.protobuf.message.Message):
    """SubjectFilter specifies a filter on the subject of a relationship.

    subject_type is required and all other fields are optional, and will not
    impose any additional requirements if left unspecified.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class RelationFilter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        RELATION_FIELD_NUMBER: builtins.int
        relation: builtins.str
        def __init__(
            self,
            *,
            relation: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing.Literal["relation", b"relation"]) -> None: ...

    SUBJECT_TYPE_FIELD_NUMBER: builtins.int
    OPTIONAL_SUBJECT_ID_FIELD_NUMBER: builtins.int
    OPTIONAL_RELATION_FIELD_NUMBER: builtins.int
    subject_type: builtins.str
    optional_subject_id: builtins.str
    @property
    def optional_relation(self) -> global___SubjectFilter.RelationFilter: ...
    def __init__(
        self,
        *,
        subject_type: builtins.str = ...,
        optional_subject_id: builtins.str = ...,
        optional_relation: global___SubjectFilter.RelationFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["optional_relation", b"optional_relation"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["optional_relation", b"optional_relation", "optional_subject_id", b"optional_subject_id", "subject_type", b"subject_type"]) -> None: ...

global___SubjectFilter = SubjectFilter

@typing.final
class ReadRelationshipsRequest(google.protobuf.message.Message):
    """ReadRelationshipsRequest specifies one or more filters used to read matching
    relationships within the system.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONSISTENCY_FIELD_NUMBER: builtins.int
    RELATIONSHIP_FILTER_FIELD_NUMBER: builtins.int
    OPTIONAL_LIMIT_FIELD_NUMBER: builtins.int
    OPTIONAL_CURSOR_FIELD_NUMBER: builtins.int
    optional_limit: builtins.int
    """optional_limit, if non-zero, specifies the limit on the number of relationships to return
    before the stream is closed on the server side. By default, the stream will continue
    resolving relationships until exhausted or the stream is closed due to the client or a
    network issue.
    """
    @property
    def consistency(self) -> global___Consistency: ...
    @property
    def relationship_filter(self) -> global___RelationshipFilter:
        """relationship_filter defines the filter to be applied to the relationships
        to be returned.
        """

    @property
    def optional_cursor(self) -> authzed.api.v1.core_pb2.Cursor:
        """optional_cursor, if specified, indicates the cursor after which results should resume being returned.
        The cursor can be found on the ReadRelationshipsResponse object.
        """

    def __init__(
        self,
        *,
        consistency: global___Consistency | None = ...,
        relationship_filter: global___RelationshipFilter | None = ...,
        optional_limit: builtins.int = ...,
        optional_cursor: authzed.api.v1.core_pb2.Cursor | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["consistency", b"consistency", "optional_cursor", b"optional_cursor", "relationship_filter", b"relationship_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["consistency", b"consistency", "optional_cursor", b"optional_cursor", "optional_limit", b"optional_limit", "relationship_filter", b"relationship_filter"]) -> None: ...

global___ReadRelationshipsRequest = ReadRelationshipsRequest

@typing.final
class ReadRelationshipsResponse(google.protobuf.message.Message):
    """ReadRelationshipsResponse contains a Relationship found that matches the
    specified relationship filter(s). A instance of this response message will
    be streamed to the client for each relationship found.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    READ_AT_FIELD_NUMBER: builtins.int
    RELATIONSHIP_FIELD_NUMBER: builtins.int
    AFTER_RESULT_CURSOR_FIELD_NUMBER: builtins.int
    @property
    def read_at(self) -> authzed.api.v1.core_pb2.ZedToken:
        """read_at is the ZedToken at which the relationship was found."""

    @property
    def relationship(self) -> authzed.api.v1.core_pb2.Relationship:
        """relationship is the found relationship."""

    @property
    def after_result_cursor(self) -> authzed.api.v1.core_pb2.Cursor:
        """after_result_cursor holds a cursor that can be used to resume the ReadRelationships stream after this
        result.
        """

    def __init__(
        self,
        *,
        read_at: authzed.api.v1.core_pb2.ZedToken | None = ...,
        relationship: authzed.api.v1.core_pb2.Relationship | None = ...,
        after_result_cursor: authzed.api.v1.core_pb2.Cursor | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["after_result_cursor", b"after_result_cursor", "read_at", b"read_at", "relationship", b"relationship"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["after_result_cursor", b"after_result_cursor", "read_at", b"read_at", "relationship", b"relationship"]) -> None: ...

global___ReadRelationshipsResponse = ReadRelationshipsResponse

@typing.final
class Precondition(google.protobuf.message.Message):
    """Precondition specifies how and the existence or absence of certain
    relationships as expressed through the accompanying filter should affect
    whether or not the operation proceeds.

    MUST_NOT_MATCH will fail the parent request if any relationships match the
    relationships filter.
    MUST_MATCH will fail the parent request if there are no
    relationships that match the filter.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Operation:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _OperationEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Precondition._Operation.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        OPERATION_UNSPECIFIED: Precondition._Operation.ValueType  # 0
        OPERATION_MUST_NOT_MATCH: Precondition._Operation.ValueType  # 1
        OPERATION_MUST_MATCH: Precondition._Operation.ValueType  # 2

    class Operation(_Operation, metaclass=_OperationEnumTypeWrapper): ...
    OPERATION_UNSPECIFIED: Precondition.Operation.ValueType  # 0
    OPERATION_MUST_NOT_MATCH: Precondition.Operation.ValueType  # 1
    OPERATION_MUST_MATCH: Precondition.Operation.ValueType  # 2

    OPERATION_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    operation: global___Precondition.Operation.ValueType
    @property
    def filter(self) -> global___RelationshipFilter: ...
    def __init__(
        self,
        *,
        operation: global___Precondition.Operation.ValueType = ...,
        filter: global___RelationshipFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "operation", b"operation"]) -> None: ...

global___Precondition = Precondition

@typing.final
class WriteRelationshipsRequest(google.protobuf.message.Message):
    """WriteRelationshipsRequest contains a list of Relationship mutations that
    should be applied to the service. If the optional_preconditions parameter
    is included, all of the specified preconditions must also be satisfied before
    the write will be committed. All updates will be applied transactionally,
    and if any preconditions fail, the entire transaction will be reverted.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UPDATES_FIELD_NUMBER: builtins.int
    OPTIONAL_PRECONDITIONS_FIELD_NUMBER: builtins.int
    OPTIONAL_TRANSACTION_METADATA_FIELD_NUMBER: builtins.int
    @property
    def updates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[authzed.api.v1.core_pb2.RelationshipUpdate]: ...
    @property
    def optional_preconditions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Precondition]:
        """To be bounded by configuration"""

    @property
    def optional_transaction_metadata(self) -> google.protobuf.struct_pb2.Struct:
        """optional_transaction_metadata is an optional field that can be used to store metadata about the transaction.
        If specified, this metadata will be supplied in the WatchResponse for the updates associated with this
        transaction.
        """

    def __init__(
        self,
        *,
        updates: collections.abc.Iterable[authzed.api.v1.core_pb2.RelationshipUpdate] | None = ...,
        optional_preconditions: collections.abc.Iterable[global___Precondition] | None = ...,
        optional_transaction_metadata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["optional_transaction_metadata", b"optional_transaction_metadata"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["optional_preconditions", b"optional_preconditions", "optional_transaction_metadata", b"optional_transaction_metadata", "updates", b"updates"]) -> None: ...

global___WriteRelationshipsRequest = WriteRelationshipsRequest

@typing.final
class WriteRelationshipsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WRITTEN_AT_FIELD_NUMBER: builtins.int
    @property
    def written_at(self) -> authzed.api.v1.core_pb2.ZedToken: ...
    def __init__(
        self,
        *,
        written_at: authzed.api.v1.core_pb2.ZedToken | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["written_at", b"written_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["written_at", b"written_at"]) -> None: ...

global___WriteRelationshipsResponse = WriteRelationshipsResponse

@typing.final
class DeleteRelationshipsRequest(google.protobuf.message.Message):
    """DeleteRelationshipsRequest specifies which Relationships should be deleted,
    requesting the delete of *ALL* relationships that match the specified
    filters. If the optional_preconditions parameter is included, all of the
    specified preconditions must also be satisfied before the delete will be
    executed.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELATIONSHIP_FILTER_FIELD_NUMBER: builtins.int
    OPTIONAL_PRECONDITIONS_FIELD_NUMBER: builtins.int
    OPTIONAL_LIMIT_FIELD_NUMBER: builtins.int
    OPTIONAL_ALLOW_PARTIAL_DELETIONS_FIELD_NUMBER: builtins.int
    OPTIONAL_TRANSACTION_METADATA_FIELD_NUMBER: builtins.int
    optional_limit: builtins.int
    """optional_limit, if non-zero, specifies the limit on the number of relationships to be deleted.
    If there are more matching relationships found to be deleted than the limit specified here,
    the deletion call will fail with an error to prevent partial deletion. If partial deletion
    is needed, specify below that partial deletion is allowed. Partial deletions can be used
    in a loop to delete large amounts of relationships in a *non-transactional* manner.
    """
    optional_allow_partial_deletions: builtins.bool
    """optional_allow_partial_deletions, if true and a limit is specified, will delete matching found
    relationships up to the count specified in optional_limit, and no more.
    """
    @property
    def relationship_filter(self) -> global___RelationshipFilter: ...
    @property
    def optional_preconditions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Precondition]:
        """To be bounded by configuration"""

    @property
    def optional_transaction_metadata(self) -> google.protobuf.struct_pb2.Struct:
        """optional_transaction_metadata is an optional field that can be used to store metadata about the transaction.
        If specified, this metadata will be supplied in the WatchResponse for the deletions associated with
        this transaction.
        """

    def __init__(
        self,
        *,
        relationship_filter: global___RelationshipFilter | None = ...,
        optional_preconditions: collections.abc.Iterable[global___Precondition] | None = ...,
        optional_limit: builtins.int = ...,
        optional_allow_partial_deletions: builtins.bool = ...,
        optional_transaction_metadata: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["optional_transaction_metadata", b"optional_transaction_metadata", "relationship_filter", b"relationship_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["optional_allow_partial_deletions", b"optional_allow_partial_deletions", "optional_limit", b"optional_limit", "optional_preconditions", b"optional_preconditions", "optional_transaction_metadata", b"optional_transaction_metadata", "relationship_filter", b"relationship_filter"]) -> None: ...

global___DeleteRelationshipsRequest = DeleteRelationshipsRequest

@typing.final
class DeleteRelationshipsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _DeletionProgress:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _DeletionProgressEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[DeleteRelationshipsResponse._DeletionProgress.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DELETION_PROGRESS_UNSPECIFIED: DeleteRelationshipsResponse._DeletionProgress.ValueType  # 0
        DELETION_PROGRESS_COMPLETE: DeleteRelationshipsResponse._DeletionProgress.ValueType  # 1
        """DELETION_PROGRESS_COMPLETE indicates that all remaining relationships matching the filter
        were deleted. Will be returned even if no relationships were deleted.
        """
        DELETION_PROGRESS_PARTIAL: DeleteRelationshipsResponse._DeletionProgress.ValueType  # 2
        """DELETION_PROGRESS_PARTIAL indicates that a subset of the relationships matching the filter
        were deleted. Only returned if optional_allow_partial_deletions was true, an optional_limit was
        specified, and there existed more relationships matching the filter than optional_limit would allow.
        Once all remaining relationships have been deleted, DELETION_PROGRESS_COMPLETE will be returned.
        """

    class DeletionProgress(_DeletionProgress, metaclass=_DeletionProgressEnumTypeWrapper): ...
    DELETION_PROGRESS_UNSPECIFIED: DeleteRelationshipsResponse.DeletionProgress.ValueType  # 0
    DELETION_PROGRESS_COMPLETE: DeleteRelationshipsResponse.DeletionProgress.ValueType  # 1
    """DELETION_PROGRESS_COMPLETE indicates that all remaining relationships matching the filter
    were deleted. Will be returned even if no relationships were deleted.
    """
    DELETION_PROGRESS_PARTIAL: DeleteRelationshipsResponse.DeletionProgress.ValueType  # 2
    """DELETION_PROGRESS_PARTIAL indicates that a subset of the relationships matching the filter
    were deleted. Only returned if optional_allow_partial_deletions was true, an optional_limit was
    specified, and there existed more relationships matching the filter than optional_limit would allow.
    Once all remaining relationships have been deleted, DELETION_PROGRESS_COMPLETE will be returned.
    """

    DELETED_AT_FIELD_NUMBER: builtins.int
    DELETION_PROGRESS_FIELD_NUMBER: builtins.int
    deletion_progress: global___DeleteRelationshipsResponse.DeletionProgress.ValueType
    """deletion_progress is an enumeration of the possible outcomes that occurred when attempting to delete the specified relationships."""
    @property
    def deleted_at(self) -> authzed.api.v1.core_pb2.ZedToken:
        """deleted_at is the revision at which the relationships were deleted."""

    def __init__(
        self,
        *,
        deleted_at: authzed.api.v1.core_pb2.ZedToken | None = ...,
        deletion_progress: global___DeleteRelationshipsResponse.DeletionProgress.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["deleted_at", b"deleted_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["deleted_at", b"deleted_at", "deletion_progress", b"deletion_progress"]) -> None: ...

global___DeleteRelationshipsResponse = DeleteRelationshipsResponse

@typing.final
class CheckPermissionRequest(google.protobuf.message.Message):
    """CheckPermissionRequest issues a check on whether a subject has a permission
    or is a member of a relation, on a specific resource.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONSISTENCY_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    PERMISSION_FIELD_NUMBER: builtins.int
    SUBJECT_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    WITH_TRACING_FIELD_NUMBER: builtins.int
    permission: builtins.str
    """permission is the name of the permission (or relation) on which to execute
    the check.
    """
    with_tracing: builtins.bool
    """with_tracing, if true, indicates that the response should include a debug trace.
    This can be useful for debugging and performance analysis, but adds a small amount
    of compute overhead to the request.
    """
    @property
    def consistency(self) -> global___Consistency: ...
    @property
    def resource(self) -> authzed.api.v1.core_pb2.ObjectReference:
        """resource is the resource on which to check the permission or relation."""

    @property
    def subject(self) -> authzed.api.v1.core_pb2.SubjectReference:
        """subject is the subject that will be checked for the permission or relation."""

    @property
    def context(self) -> google.protobuf.struct_pb2.Struct:
        """context consists of named values that are injected into the caveat evaluation context"""

    def __init__(
        self,
        *,
        consistency: global___Consistency | None = ...,
        resource: authzed.api.v1.core_pb2.ObjectReference | None = ...,
        permission: builtins.str = ...,
        subject: authzed.api.v1.core_pb2.SubjectReference | None = ...,
        context: google.protobuf.struct_pb2.Struct | None = ...,
        with_tracing: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["consistency", b"consistency", "context", b"context", "resource", b"resource", "subject", b"subject"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["consistency", b"consistency", "context", b"context", "permission", b"permission", "resource", b"resource", "subject", b"subject", "with_tracing", b"with_tracing"]) -> None: ...

global___CheckPermissionRequest = CheckPermissionRequest

@typing.final
class CheckPermissionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Permissionship:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PermissionshipEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[CheckPermissionResponse._Permissionship.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PERMISSIONSHIP_UNSPECIFIED: CheckPermissionResponse._Permissionship.ValueType  # 0
        PERMISSIONSHIP_NO_PERMISSION: CheckPermissionResponse._Permissionship.ValueType  # 1
        PERMISSIONSHIP_HAS_PERMISSION: CheckPermissionResponse._Permissionship.ValueType  # 2
        PERMISSIONSHIP_CONDITIONAL_PERMISSION: CheckPermissionResponse._Permissionship.ValueType  # 3

    class Permissionship(_Permissionship, metaclass=_PermissionshipEnumTypeWrapper): ...
    PERMISSIONSHIP_UNSPECIFIED: CheckPermissionResponse.Permissionship.ValueType  # 0
    PERMISSIONSHIP_NO_PERMISSION: CheckPermissionResponse.Permissionship.ValueType  # 1
    PERMISSIONSHIP_HAS_PERMISSION: CheckPermissionResponse.Permissionship.ValueType  # 2
    PERMISSIONSHIP_CONDITIONAL_PERMISSION: CheckPermissionResponse.Permissionship.ValueType  # 3

    CHECKED_AT_FIELD_NUMBER: builtins.int
    PERMISSIONSHIP_FIELD_NUMBER: builtins.int
    PARTIAL_CAVEAT_INFO_FIELD_NUMBER: builtins.int
    DEBUG_TRACE_FIELD_NUMBER: builtins.int
    OPTIONAL_EXPIRES_AT_FIELD_NUMBER: builtins.int
    permissionship: global___CheckPermissionResponse.Permissionship.ValueType
    """Permissionship communicates whether or not the subject has the requested
    permission or has a relationship with the given resource, over the given
    relation.

    This value will be authzed.api.v1.PERMISSIONSHIP_HAS_PERMISSION if the
    requested subject is a member of the computed permission set or there
    exists a relationship with the requested relation from the given resource
    to the given subject.
    """
    @property
    def checked_at(self) -> authzed.api.v1.core_pb2.ZedToken: ...
    @property
    def partial_caveat_info(self) -> authzed.api.v1.core_pb2.PartialCaveatInfo:
        """partial_caveat_info holds information of a partially-evaluated caveated response"""

    @property
    def debug_trace(self) -> authzed.api.v1.debug_pb2.DebugInformation:
        """debug_trace is the debugging trace of this check, if requested."""

    @property
    def optional_expires_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """optional_expires_at is the time at which at least one of the relationships used to
        compute this result, expires (if any). This is *not* related to the caching window.
        """

    def __init__(
        self,
        *,
        checked_at: authzed.api.v1.core_pb2.ZedToken | None = ...,
        permissionship: global___CheckPermissionResponse.Permissionship.ValueType = ...,
        partial_caveat_info: authzed.api.v1.core_pb2.PartialCaveatInfo | None = ...,
        debug_trace: authzed.api.v1.debug_pb2.DebugInformation | None = ...,
        optional_expires_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["checked_at", b"checked_at", "debug_trace", b"debug_trace", "optional_expires_at", b"optional_expires_at", "partial_caveat_info", b"partial_caveat_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["checked_at", b"checked_at", "debug_trace", b"debug_trace", "optional_expires_at", b"optional_expires_at", "partial_caveat_info", b"partial_caveat_info", "permissionship", b"permissionship"]) -> None: ...

global___CheckPermissionResponse = CheckPermissionResponse

@typing.final
class CheckBulkPermissionsRequest(google.protobuf.message.Message):
    """CheckBulkPermissionsRequest issues a check on whether a subject has permission 
    or is a member of a relation on a specific resource for each item in the list.

    The ordering of the items in the response is maintained in the response.
    Checks with the same subject/permission will automatically be batched for performance optimization.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONSISTENCY_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int
    WITH_TRACING_FIELD_NUMBER: builtins.int
    with_tracing: builtins.bool
    """with_tracing, if true, indicates that each response should include a debug trace.
    This can be useful for debugging and performance analysis, but adds a small amount
    of compute overhead to the request.
    """
    @property
    def consistency(self) -> global___Consistency: ...
    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CheckBulkPermissionsRequestItem]: ...
    def __init__(
        self,
        *,
        consistency: global___Consistency | None = ...,
        items: collections.abc.Iterable[global___CheckBulkPermissionsRequestItem] | None = ...,
        with_tracing: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["consistency", b"consistency"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["consistency", b"consistency", "items", b"items", "with_tracing", b"with_tracing"]) -> None: ...

global___CheckBulkPermissionsRequest = CheckBulkPermissionsRequest

@typing.final
class CheckBulkPermissionsRequestItem(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_FIELD_NUMBER: builtins.int
    PERMISSION_FIELD_NUMBER: builtins.int
    SUBJECT_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    permission: builtins.str
    @property
    def resource(self) -> authzed.api.v1.core_pb2.ObjectReference: ...
    @property
    def subject(self) -> authzed.api.v1.core_pb2.SubjectReference: ...
    @property
    def context(self) -> google.protobuf.struct_pb2.Struct: ...
    def __init__(
        self,
        *,
        resource: authzed.api.v1.core_pb2.ObjectReference | None = ...,
        permission: builtins.str = ...,
        subject: authzed.api.v1.core_pb2.SubjectReference | None = ...,
        context: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["context", b"context", "resource", b"resource", "subject", b"subject"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["context", b"context", "permission", b"permission", "resource", b"resource", "subject", b"subject"]) -> None: ...

global___CheckBulkPermissionsRequestItem = CheckBulkPermissionsRequestItem

@typing.final
class CheckBulkPermissionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHECKED_AT_FIELD_NUMBER: builtins.int
    PAIRS_FIELD_NUMBER: builtins.int
    @property
    def checked_at(self) -> authzed.api.v1.core_pb2.ZedToken: ...
    @property
    def pairs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___CheckBulkPermissionsPair]: ...
    def __init__(
        self,
        *,
        checked_at: authzed.api.v1.core_pb2.ZedToken | None = ...,
        pairs: collections.abc.Iterable[global___CheckBulkPermissionsPair] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["checked_at", b"checked_at"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["checked_at", b"checked_at", "pairs", b"pairs"]) -> None: ...

global___CheckBulkPermissionsResponse = CheckBulkPermissionsResponse

@typing.final
class CheckBulkPermissionsPair(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUEST_FIELD_NUMBER: builtins.int
    ITEM_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    @property
    def request(self) -> global___CheckBulkPermissionsRequestItem: ...
    @property
    def item(self) -> global___CheckBulkPermissionsResponseItem: ...
    @property
    def error(self) -> google.rpc.status_pb2.Status: ...
    def __init__(
        self,
        *,
        request: global___CheckBulkPermissionsRequestItem | None = ...,
        item: global___CheckBulkPermissionsResponseItem | None = ...,
        error: google.rpc.status_pb2.Status | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["error", b"error", "item", b"item", "request", b"request", "response", b"response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["error", b"error", "item", b"item", "request", b"request", "response", b"response"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["response", b"response"]) -> typing.Literal["item", "error"] | None: ...

global___CheckBulkPermissionsPair = CheckBulkPermissionsPair

@typing.final
class CheckBulkPermissionsResponseItem(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMISSIONSHIP_FIELD_NUMBER: builtins.int
    PARTIAL_CAVEAT_INFO_FIELD_NUMBER: builtins.int
    DEBUG_TRACE_FIELD_NUMBER: builtins.int
    permissionship: global___CheckPermissionResponse.Permissionship.ValueType
    @property
    def partial_caveat_info(self) -> authzed.api.v1.core_pb2.PartialCaveatInfo: ...
    @property
    def debug_trace(self) -> authzed.api.v1.debug_pb2.DebugInformation:
        """debug_trace is the debugging trace of this check, if requested."""

    def __init__(
        self,
        *,
        permissionship: global___CheckPermissionResponse.Permissionship.ValueType = ...,
        partial_caveat_info: authzed.api.v1.core_pb2.PartialCaveatInfo | None = ...,
        debug_trace: authzed.api.v1.debug_pb2.DebugInformation | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["debug_trace", b"debug_trace", "partial_caveat_info", b"partial_caveat_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["debug_trace", b"debug_trace", "partial_caveat_info", b"partial_caveat_info", "permissionship", b"permissionship"]) -> None: ...

global___CheckBulkPermissionsResponseItem = CheckBulkPermissionsResponseItem

@typing.final
class ExpandPermissionTreeRequest(google.protobuf.message.Message):
    """ExpandPermissionTreeRequest returns a tree representing the expansion of all
    relationships found accessible from a permission or relation on a particular
    resource.

    ExpandPermissionTreeRequest is typically used to determine the full set of
    subjects with a permission, along with the relationships that grant said
    access.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONSISTENCY_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    PERMISSION_FIELD_NUMBER: builtins.int
    permission: builtins.str
    """permission is the name of the permission or relation over which to run the
    expansion for the resource.
    """
    @property
    def consistency(self) -> global___Consistency: ...
    @property
    def resource(self) -> authzed.api.v1.core_pb2.ObjectReference:
        """resource is the resource over which to run the expansion."""

    def __init__(
        self,
        *,
        consistency: global___Consistency | None = ...,
        resource: authzed.api.v1.core_pb2.ObjectReference | None = ...,
        permission: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["consistency", b"consistency", "resource", b"resource"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["consistency", b"consistency", "permission", b"permission", "resource", b"resource"]) -> None: ...

global___ExpandPermissionTreeRequest = ExpandPermissionTreeRequest

@typing.final
class ExpandPermissionTreeResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    EXPANDED_AT_FIELD_NUMBER: builtins.int
    TREE_ROOT_FIELD_NUMBER: builtins.int
    @property
    def expanded_at(self) -> authzed.api.v1.core_pb2.ZedToken: ...
    @property
    def tree_root(self) -> authzed.api.v1.core_pb2.PermissionRelationshipTree:
        """tree_root is a tree structure whose leaf nodes are subjects, and
        intermediate nodes represent the various operations (union, intersection,
        exclusion) to reach those subjects.
        """

    def __init__(
        self,
        *,
        expanded_at: authzed.api.v1.core_pb2.ZedToken | None = ...,
        tree_root: authzed.api.v1.core_pb2.PermissionRelationshipTree | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["expanded_at", b"expanded_at", "tree_root", b"tree_root"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["expanded_at", b"expanded_at", "tree_root", b"tree_root"]) -> None: ...

global___ExpandPermissionTreeResponse = ExpandPermissionTreeResponse

@typing.final
class LookupResourcesRequest(google.protobuf.message.Message):
    """LookupResourcesRequest performs a lookup of all resources of a particular
    kind on which the subject has the specified permission or the relation in
    which the subject exists, streaming back the IDs of those resources.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONSISTENCY_FIELD_NUMBER: builtins.int
    RESOURCE_OBJECT_TYPE_FIELD_NUMBER: builtins.int
    PERMISSION_FIELD_NUMBER: builtins.int
    SUBJECT_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    OPTIONAL_LIMIT_FIELD_NUMBER: builtins.int
    OPTIONAL_CURSOR_FIELD_NUMBER: builtins.int
    resource_object_type: builtins.str
    """resource_object_type is the type of resource object for which the IDs will
    be returned.
    """
    permission: builtins.str
    """permission is the name of the permission or relation for which the subject
    must Check.
    """
    optional_limit: builtins.int
    """optional_limit, if non-zero, specifies the limit on the number of resources to return
    before the stream is closed on the server side. By default, the stream will continue
    resolving resources until exhausted or the stream is closed due to the client or a
    network issue.
    """
    @property
    def consistency(self) -> global___Consistency: ...
    @property
    def subject(self) -> authzed.api.v1.core_pb2.SubjectReference:
        """subject is the subject with access to the resources."""

    @property
    def context(self) -> google.protobuf.struct_pb2.Struct:
        """context consists of named values that are injected into the caveat evaluation context"""

    @property
    def optional_cursor(self) -> authzed.api.v1.core_pb2.Cursor:
        """optional_cursor, if specified, indicates the cursor after which results should resume being returned.
        The cursor can be found on the LookupResourcesResponse object.
        """

    def __init__(
        self,
        *,
        consistency: global___Consistency | None = ...,
        resource_object_type: builtins.str = ...,
        permission: builtins.str = ...,
        subject: authzed.api.v1.core_pb2.SubjectReference | None = ...,
        context: google.protobuf.struct_pb2.Struct | None = ...,
        optional_limit: builtins.int = ...,
        optional_cursor: authzed.api.v1.core_pb2.Cursor | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["consistency", b"consistency", "context", b"context", "optional_cursor", b"optional_cursor", "subject", b"subject"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["consistency", b"consistency", "context", b"context", "optional_cursor", b"optional_cursor", "optional_limit", b"optional_limit", "permission", b"permission", "resource_object_type", b"resource_object_type", "subject", b"subject"]) -> None: ...

global___LookupResourcesRequest = LookupResourcesRequest

@typing.final
class LookupResourcesResponse(google.protobuf.message.Message):
    """LookupResourcesResponse contains a single matching resource object ID for the
    requested object type, permission, and subject.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOOKED_UP_AT_FIELD_NUMBER: builtins.int
    RESOURCE_OBJECT_ID_FIELD_NUMBER: builtins.int
    PERMISSIONSHIP_FIELD_NUMBER: builtins.int
    PARTIAL_CAVEAT_INFO_FIELD_NUMBER: builtins.int
    AFTER_RESULT_CURSOR_FIELD_NUMBER: builtins.int
    resource_object_id: builtins.str
    """resource_object_id is the object ID of the found resource."""
    permissionship: global___LookupPermissionship.ValueType
    """permissionship indicates whether the response was partially evaluated or not"""
    @property
    def looked_up_at(self) -> authzed.api.v1.core_pb2.ZedToken:
        """looked_up_at is the ZedToken at which the resource was found."""

    @property
    def partial_caveat_info(self) -> authzed.api.v1.core_pb2.PartialCaveatInfo:
        """partial_caveat_info holds information of a partially-evaluated caveated response"""

    @property
    def after_result_cursor(self) -> authzed.api.v1.core_pb2.Cursor:
        """after_result_cursor holds a cursor that can be used to resume the LookupResources stream after this
        result.
        """

    def __init__(
        self,
        *,
        looked_up_at: authzed.api.v1.core_pb2.ZedToken | None = ...,
        resource_object_id: builtins.str = ...,
        permissionship: global___LookupPermissionship.ValueType = ...,
        partial_caveat_info: authzed.api.v1.core_pb2.PartialCaveatInfo | None = ...,
        after_result_cursor: authzed.api.v1.core_pb2.Cursor | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["after_result_cursor", b"after_result_cursor", "looked_up_at", b"looked_up_at", "partial_caveat_info", b"partial_caveat_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["after_result_cursor", b"after_result_cursor", "looked_up_at", b"looked_up_at", "partial_caveat_info", b"partial_caveat_info", "permissionship", b"permissionship", "resource_object_id", b"resource_object_id"]) -> None: ...

global___LookupResourcesResponse = LookupResourcesResponse

@typing.final
class LookupSubjectsRequest(google.protobuf.message.Message):
    """LookupSubjectsRequest performs a lookup of all subjects of a particular
    kind for which the subject has the specified permission or the relation in
    which the subject exists, streaming back the IDs of those subjects.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _WildcardOption:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _WildcardOptionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[LookupSubjectsRequest._WildcardOption.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        WILDCARD_OPTION_UNSPECIFIED: LookupSubjectsRequest._WildcardOption.ValueType  # 0
        WILDCARD_OPTION_INCLUDE_WILDCARDS: LookupSubjectsRequest._WildcardOption.ValueType  # 1
        WILDCARD_OPTION_EXCLUDE_WILDCARDS: LookupSubjectsRequest._WildcardOption.ValueType  # 2

    class WildcardOption(_WildcardOption, metaclass=_WildcardOptionEnumTypeWrapper): ...
    WILDCARD_OPTION_UNSPECIFIED: LookupSubjectsRequest.WildcardOption.ValueType  # 0
    WILDCARD_OPTION_INCLUDE_WILDCARDS: LookupSubjectsRequest.WildcardOption.ValueType  # 1
    WILDCARD_OPTION_EXCLUDE_WILDCARDS: LookupSubjectsRequest.WildcardOption.ValueType  # 2

    CONSISTENCY_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    PERMISSION_FIELD_NUMBER: builtins.int
    SUBJECT_OBJECT_TYPE_FIELD_NUMBER: builtins.int
    OPTIONAL_SUBJECT_RELATION_FIELD_NUMBER: builtins.int
    CONTEXT_FIELD_NUMBER: builtins.int
    OPTIONAL_CONCRETE_LIMIT_FIELD_NUMBER: builtins.int
    OPTIONAL_CURSOR_FIELD_NUMBER: builtins.int
    WILDCARD_OPTION_FIELD_NUMBER: builtins.int
    permission: builtins.str
    """permission is the name of the permission (or relation) for which to find
    the subjects.
    """
    subject_object_type: builtins.str
    """subject_object_type is the type of subject object for which the IDs will
    be returned.
    """
    optional_subject_relation: builtins.str
    """optional_subject_relation is the optional relation for the subject."""
    optional_concrete_limit: builtins.int
    """optional_concrete_limit, if non-zero, specifies the limit on the number of
    *concrete* (non-wildcard) subjects to return before the stream is closed on the
    server side. With the default value of zero, the stream will continue resolving
    concrete subjects until exhausted or the stream is closed due to the client or
    a network issue.

    NOTE: Wildcard subjects ("*") have special treatment when cursors and limits are used. Because
    wildcards can apply to *any* concrete subjects, if a wildcard subject is found within the dataset,
    a wildcard subject can be returned for *all* LookupSubjects calls, regardless of the cursor or
    limit.

    For example, if wildcards are requested, a wildcard subject exists, there is a specified limit
    of 10 concrete subjects, and at least 10 concrete subjects exist, the API will return 11 subjects
    in total: the 10 concrete + the wildcard

    Furthermore, if a wildcard has a set of exclusions generated by the dataset,
    the exclusions *will respect the cursor* and only a *partial* set of exclusions will be returned
    for each invocation of the API.

    ***IT IS UP TO THE CALLER IN THIS CASE TO COMBINE THE EXCLUSIONS IF DESIRED***
    """
    wildcard_option: global___LookupSubjectsRequest.WildcardOption.ValueType
    """wildcard_option specifies whether wildcards should be returned by LookupSubjects.
    For backwards compatibility, defaults to WILDCARD_OPTION_INCLUDE_WILDCARDS if unspecified.
    """
    @property
    def consistency(self) -> global___Consistency: ...
    @property
    def resource(self) -> authzed.api.v1.core_pb2.ObjectReference:
        """resource is the resource for which all matching subjects for the permission
        or relation will be returned.
        """

    @property
    def context(self) -> google.protobuf.struct_pb2.Struct:
        """context consists of named values that are injected into the caveat evaluation context"""

    @property
    def optional_cursor(self) -> authzed.api.v1.core_pb2.Cursor:
        """optional_cursor, if specified, indicates the cursor after which results should resume being returned.
        The cursor can be found on the LookupSubjectsResponse object.

        NOTE: See above for notes about how cursors interact with wildcard subjects.
        """

    def __init__(
        self,
        *,
        consistency: global___Consistency | None = ...,
        resource: authzed.api.v1.core_pb2.ObjectReference | None = ...,
        permission: builtins.str = ...,
        subject_object_type: builtins.str = ...,
        optional_subject_relation: builtins.str = ...,
        context: google.protobuf.struct_pb2.Struct | None = ...,
        optional_concrete_limit: builtins.int = ...,
        optional_cursor: authzed.api.v1.core_pb2.Cursor | None = ...,
        wildcard_option: global___LookupSubjectsRequest.WildcardOption.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["consistency", b"consistency", "context", b"context", "optional_cursor", b"optional_cursor", "resource", b"resource"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["consistency", b"consistency", "context", b"context", "optional_concrete_limit", b"optional_concrete_limit", "optional_cursor", b"optional_cursor", "optional_subject_relation", b"optional_subject_relation", "permission", b"permission", "resource", b"resource", "subject_object_type", b"subject_object_type", "wildcard_option", b"wildcard_option"]) -> None: ...

global___LookupSubjectsRequest = LookupSubjectsRequest

@typing.final
class LookupSubjectsResponse(google.protobuf.message.Message):
    """LookupSubjectsResponse contains a single matching subject object ID for the
    requested subject object type on the permission or relation.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    LOOKED_UP_AT_FIELD_NUMBER: builtins.int
    SUBJECT_OBJECT_ID_FIELD_NUMBER: builtins.int
    EXCLUDED_SUBJECT_IDS_FIELD_NUMBER: builtins.int
    PERMISSIONSHIP_FIELD_NUMBER: builtins.int
    PARTIAL_CAVEAT_INFO_FIELD_NUMBER: builtins.int
    SUBJECT_FIELD_NUMBER: builtins.int
    EXCLUDED_SUBJECTS_FIELD_NUMBER: builtins.int
    AFTER_RESULT_CURSOR_FIELD_NUMBER: builtins.int
    subject_object_id: builtins.str
    """subject_object_id is the Object ID of the subject found. May be a `*` if
    a wildcard was found.
    deprecated: use `subject`
    """
    permissionship: global___LookupPermissionship.ValueType
    """permissionship indicates whether the response was partially evaluated or not
    deprecated: use `subject.permissionship`
    """
    @property
    def looked_up_at(self) -> authzed.api.v1.core_pb2.ZedToken: ...
    @property
    def excluded_subject_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """excluded_subject_ids are the Object IDs of the subjects excluded. This list
        will only contain object IDs if `subject_object_id` is a wildcard (`*`) and
        will only be populated if exclusions exist from the wildcard.
        deprecated: use `excluded_subjects`
        """

    @property
    def partial_caveat_info(self) -> authzed.api.v1.core_pb2.PartialCaveatInfo:
        """partial_caveat_info holds information of a partially-evaluated caveated response
        deprecated: use `subject.partial_caveat_info`
        """

    @property
    def subject(self) -> global___ResolvedSubject:
        """subject is the subject found, along with its permissionship."""

    @property
    def excluded_subjects(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ResolvedSubject]:
        """excluded_subjects are the subjects excluded. This list
        will only contain subjects if `subject.subject_object_id` is a wildcard (`*`) and
        will only be populated if exclusions exist from the wildcard.
        """

    @property
    def after_result_cursor(self) -> authzed.api.v1.core_pb2.Cursor:
        """after_result_cursor holds a cursor that can be used to resume the LookupSubjects stream after this
        result.
        """

    def __init__(
        self,
        *,
        looked_up_at: authzed.api.v1.core_pb2.ZedToken | None = ...,
        subject_object_id: builtins.str = ...,
        excluded_subject_ids: collections.abc.Iterable[builtins.str] | None = ...,
        permissionship: global___LookupPermissionship.ValueType = ...,
        partial_caveat_info: authzed.api.v1.core_pb2.PartialCaveatInfo | None = ...,
        subject: global___ResolvedSubject | None = ...,
        excluded_subjects: collections.abc.Iterable[global___ResolvedSubject] | None = ...,
        after_result_cursor: authzed.api.v1.core_pb2.Cursor | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["after_result_cursor", b"after_result_cursor", "looked_up_at", b"looked_up_at", "partial_caveat_info", b"partial_caveat_info", "subject", b"subject"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["after_result_cursor", b"after_result_cursor", "excluded_subject_ids", b"excluded_subject_ids", "excluded_subjects", b"excluded_subjects", "looked_up_at", b"looked_up_at", "partial_caveat_info", b"partial_caveat_info", "permissionship", b"permissionship", "subject", b"subject", "subject_object_id", b"subject_object_id"]) -> None: ...

global___LookupSubjectsResponse = LookupSubjectsResponse

@typing.final
class ResolvedSubject(google.protobuf.message.Message):
    """ResolvedSubject is a single subject resolved within LookupSubjects."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUBJECT_OBJECT_ID_FIELD_NUMBER: builtins.int
    PERMISSIONSHIP_FIELD_NUMBER: builtins.int
    PARTIAL_CAVEAT_INFO_FIELD_NUMBER: builtins.int
    subject_object_id: builtins.str
    """subject_object_id is the Object ID of the subject found. May be a `*` if
    a wildcard was found.
    """
    permissionship: global___LookupPermissionship.ValueType
    """permissionship indicates whether the response was partially evaluated or not"""
    @property
    def partial_caveat_info(self) -> authzed.api.v1.core_pb2.PartialCaveatInfo:
        """partial_caveat_info holds information of a partially-evaluated caveated response"""

    def __init__(
        self,
        *,
        subject_object_id: builtins.str = ...,
        permissionship: global___LookupPermissionship.ValueType = ...,
        partial_caveat_info: authzed.api.v1.core_pb2.PartialCaveatInfo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["partial_caveat_info", b"partial_caveat_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["partial_caveat_info", b"partial_caveat_info", "permissionship", b"permissionship", "subject_object_id", b"subject_object_id"]) -> None: ...

global___ResolvedSubject = ResolvedSubject

@typing.final
class ImportBulkRelationshipsRequest(google.protobuf.message.Message):
    """ImportBulkRelationshipsRequest represents one batch of the streaming
    ImportBulkRelationships API. The maximum size is only limited by the backing
    datastore, and optimal size should be determined by the calling client
    experimentally. When ImportBulk is invoked and receives its first request message,
    a transaction is opened to import the relationships. All requests sent to the same
    invocation are executed under this single transaction. If a relationship already
    exists within the datastore, the entire transaction will fail with an error.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RELATIONSHIPS_FIELD_NUMBER: builtins.int
    @property
    def relationships(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[authzed.api.v1.core_pb2.Relationship]: ...
    def __init__(
        self,
        *,
        relationships: collections.abc.Iterable[authzed.api.v1.core_pb2.Relationship] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["relationships", b"relationships"]) -> None: ...

global___ImportBulkRelationshipsRequest = ImportBulkRelationshipsRequest

@typing.final
class ImportBulkRelationshipsResponse(google.protobuf.message.Message):
    """ImportBulkRelationshipsResponse is returned on successful completion of the
    bulk load stream, and contains the total number of relationships loaded.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NUM_LOADED_FIELD_NUMBER: builtins.int
    num_loaded: builtins.int
    def __init__(
        self,
        *,
        num_loaded: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["num_loaded", b"num_loaded"]) -> None: ...

global___ImportBulkRelationshipsResponse = ImportBulkRelationshipsResponse

@typing.final
class ExportBulkRelationshipsRequest(google.protobuf.message.Message):
    """ExportBulkRelationshipsRequest represents a resumable request for
    all relationships from the server.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONSISTENCY_FIELD_NUMBER: builtins.int
    OPTIONAL_LIMIT_FIELD_NUMBER: builtins.int
    OPTIONAL_CURSOR_FIELD_NUMBER: builtins.int
    OPTIONAL_RELATIONSHIP_FILTER_FIELD_NUMBER: builtins.int
    optional_limit: builtins.int
    """optional_limit, if non-zero, specifies the limit on the number of
    relationships the server can return in one page. By default, the server
    will pick a page size, and the server is free to choose a smaller size
    at will.
    """
    @property
    def consistency(self) -> global___Consistency: ...
    @property
    def optional_cursor(self) -> authzed.api.v1.core_pb2.Cursor:
        """optional_cursor, if specified, indicates the cursor after which results
        should resume being returned. The cursor can be found on the
        BulkExportRelationshipsResponse object.
        """

    @property
    def optional_relationship_filter(self) -> global___RelationshipFilter:
        """optional_relationship_filter, if specified, indicates the
        filter to apply to each relationship to be exported.
        """

    def __init__(
        self,
        *,
        consistency: global___Consistency | None = ...,
        optional_limit: builtins.int = ...,
        optional_cursor: authzed.api.v1.core_pb2.Cursor | None = ...,
        optional_relationship_filter: global___RelationshipFilter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["consistency", b"consistency", "optional_cursor", b"optional_cursor", "optional_relationship_filter", b"optional_relationship_filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["consistency", b"consistency", "optional_cursor", b"optional_cursor", "optional_limit", b"optional_limit", "optional_relationship_filter", b"optional_relationship_filter"]) -> None: ...

global___ExportBulkRelationshipsRequest = ExportBulkRelationshipsRequest

@typing.final
class ExportBulkRelationshipsResponse(google.protobuf.message.Message):
    """ExportBulkRelationshipsResponse is one page in a stream of relationship
    groups that meet the criteria specified by the originating request. The
    server will continue to stream back relationship groups as quickly as it can
    until all relationships have been transmitted back.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    AFTER_RESULT_CURSOR_FIELD_NUMBER: builtins.int
    RELATIONSHIPS_FIELD_NUMBER: builtins.int
    @property
    def after_result_cursor(self) -> authzed.api.v1.core_pb2.Cursor: ...
    @property
    def relationships(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[authzed.api.v1.core_pb2.Relationship]: ...
    def __init__(
        self,
        *,
        after_result_cursor: authzed.api.v1.core_pb2.Cursor | None = ...,
        relationships: collections.abc.Iterable[authzed.api.v1.core_pb2.Relationship] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["after_result_cursor", b"after_result_cursor"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["after_result_cursor", b"after_result_cursor", "relationships", b"relationships"]) -> None: ...

global___ExportBulkRelationshipsResponse = ExportBulkRelationshipsResponse
