"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import authzed.api.v1.core_pb2
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class WatchPermissionsRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PERMISSIONS_FIELD_NUMBER: builtins.int
    OPTIONAL_STARTING_AFTER_FIELD_NUMBER: builtins.int
    @property
    def permissions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___WatchedPermission]:
        """permissions is a list of permissions to watch for changes. At least one permission must be specified, and it must
        be a subset or equal to the permissions that were enabled for the service.
        """

    @property
    def optional_starting_after(self) -> authzed.api.v1.core_pb2.ZedToken:
        """optional_starting_after is the revision token to start watching from. If not provided, the stream
        will start from the current revision at the moment of the request.
        """

    def __init__(
        self,
        *,
        permissions: collections.abc.Iterable[global___WatchedPermission] | None = ...,
        optional_starting_after: authzed.api.v1.core_pb2.ZedToken | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["optional_starting_after", b"optional_starting_after"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["optional_starting_after", b"optional_starting_after", "permissions", b"permissions"]) -> None: ...

global___WatchPermissionsRequest = WatchPermissionsRequest

@typing.final
class WatchedPermission(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RESOURCE_TYPE_FIELD_NUMBER: builtins.int
    PERMISSION_FIELD_NUMBER: builtins.int
    SUBJECT_TYPE_FIELD_NUMBER: builtins.int
    OPTIONAL_SUBJECT_RELATION_FIELD_NUMBER: builtins.int
    resource_type: builtins.str
    """resource_type is the type of the resource to watch for changes."""
    permission: builtins.str
    """permission is the permission to watch for changes."""
    subject_type: builtins.str
    """subject_type is the type of the subject to watch for changes."""
    optional_subject_relation: builtins.str
    """optional_subject_relation is the relation on the subject to watch for changes."""
    def __init__(
        self,
        *,
        resource_type: builtins.str = ...,
        permission: builtins.str = ...,
        subject_type: builtins.str = ...,
        optional_subject_relation: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["optional_subject_relation", b"optional_subject_relation", "permission", b"permission", "resource_type", b"resource_type", "subject_type", b"subject_type"]) -> None: ...

global___WatchedPermission = WatchedPermission

@typing.final
class WatchPermissionsResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANGE_FIELD_NUMBER: builtins.int
    COMPLETED_REVISION_FIELD_NUMBER: builtins.int
    @property
    def change(self) -> global___PermissionChange:
        """change is the computed permission delta that has occurred as result of a mutation in origin SpiceDB.
        The consumer should apply this change to the current state of the computed permissions in their target system.
        Once an event arrives with completed_revision instead, the consumer shall consider there are not more changes
        originating from that revision.

        The consumer should keep track of the revision in order to resume streaming in the event of consumer restarts.
        """

    @property
    def completed_revision(self) -> authzed.api.v1.core_pb2.ZedToken:
        """completed_revision is the revision token that indicates all changes originating from a revision have been
        streamed and thus the revision should be considered completed. It may also be
        received without accompanying set of changes, indicating that a mutation in the origin SpiceDB cluster did
        not yield any effective changes in the computed permissions
        """

    def __init__(
        self,
        *,
        change: global___PermissionChange | None = ...,
        completed_revision: authzed.api.v1.core_pb2.ZedToken | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["change", b"change", "completed_revision", b"completed_revision", "response", b"response"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["change", b"change", "completed_revision", b"completed_revision", "response", b"response"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["response", b"response"]) -> typing.Literal["change", "completed_revision"] | None: ...

global___WatchPermissionsResponse = WatchPermissionsResponse

@typing.final
class PermissionChange(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Permissionship:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _PermissionshipEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[PermissionChange._Permissionship.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PERMISSIONSHIP_UNSPECIFIED: PermissionChange._Permissionship.ValueType  # 0
        PERMISSIONSHIP_NO_PERMISSION: PermissionChange._Permissionship.ValueType  # 1
        PERMISSIONSHIP_HAS_PERMISSION: PermissionChange._Permissionship.ValueType  # 2
        PERMISSIONSHIP_CONDITIONAL_PERMISSION: PermissionChange._Permissionship.ValueType  # 3

    class Permissionship(_Permissionship, metaclass=_PermissionshipEnumTypeWrapper): ...
    PERMISSIONSHIP_UNSPECIFIED: PermissionChange.Permissionship.ValueType  # 0
    PERMISSIONSHIP_NO_PERMISSION: PermissionChange.Permissionship.ValueType  # 1
    PERMISSIONSHIP_HAS_PERMISSION: PermissionChange.Permissionship.ValueType  # 2
    PERMISSIONSHIP_CONDITIONAL_PERMISSION: PermissionChange.Permissionship.ValueType  # 3

    REVISION_FIELD_NUMBER: builtins.int
    RESOURCE_FIELD_NUMBER: builtins.int
    PERMISSION_FIELD_NUMBER: builtins.int
    SUBJECT_FIELD_NUMBER: builtins.int
    PERMISSIONSHIP_FIELD_NUMBER: builtins.int
    permission: builtins.str
    """permission is the permission that has changed."""
    permissionship: global___PermissionChange.Permissionship.ValueType
    """permissionship is the new permissionship of the subject over the resource after the change."""
    @property
    def revision(self) -> authzed.api.v1.core_pb2.ZedToken:
        """revision represents the revision at which the change occurred."""

    @property
    def resource(self) -> authzed.api.v1.core_pb2.ObjectReference:
        """resource is the resource that the permission change is related to."""

    @property
    def subject(self) -> authzed.api.v1.core_pb2.SubjectReference:
        """subject is the subject that the permission change is related to."""

    def __init__(
        self,
        *,
        revision: authzed.api.v1.core_pb2.ZedToken | None = ...,
        resource: authzed.api.v1.core_pb2.ObjectReference | None = ...,
        permission: builtins.str = ...,
        subject: authzed.api.v1.core_pb2.SubjectReference | None = ...,
        permissionship: global___PermissionChange.Permissionship.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["resource", b"resource", "revision", b"revision", "subject", b"subject"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["permission", b"permission", "permissionship", b"permissionship", "resource", b"resource", "revision", b"revision", "subject", b"subject"]) -> None: ...

global___PermissionChange = PermissionChange
