"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import abc
import authzed.api.materialize.v0.watchpermissionsets_pb2
import collections.abc
import grpc
import grpc.aio
import typing

_T = typing.TypeVar("_T")

class _MaybeAsyncIterator(collections.abc.AsyncIterator[_T], collections.abc.Iterator[_T], metaclass=abc.ABCMeta): ...

class _ServicerContext(grpc.ServicerContext, grpc.aio.ServicerContext):  # type: ignore[misc, type-arg]
    ...

class WatchPermissionSetsServiceStub:
    def __init__(self, channel: typing.Union[grpc.Channel, grpc.aio.Channel]) -> None: ...
    WatchPermissionSets: grpc.UnaryStreamMultiCallable[
        authzed.api.materialize.v0.watchpermissionsets_pb2.WatchPermissionSetsRequest,
        authzed.api.materialize.v0.watchpermissionsets_pb2.WatchPermissionSetsResponse,
    ]
    """WatchPermissionSets returns a stream of changes to the sets which can be used to compute the watched permissions.

    WatchPermissionSets lets consumers achieve the same thing as WatchPermissions, but trades off a simpler usage model with
    significantly lower computational requirements. Unlike WatchPermissions, this method returns changes to the sets of permissions,
    rather than the individual permissions. Permission sets are a normalized form of the computed permissions, which
    means that the consumer must perform an extra computation over this representation to obtain the final computed
    permissions, typically by intersecting the provided sets.

    For example, this would look like a JOIN between the
    materialize permission sets table in a target relation database, the table with the resources to authorize access
    to, and the table with the subject (e.g. a user).

    In exchange, the number of changes issued by WatchPermissionSets will be several orders of magnitude less than those
    emitted by WatchPermissions, which has several implications:
    - significantly less resources to compute the sets
    - significantly less messages to stream over the network
    - significantly less events to ingest on the consumer side
    - less ingestion lag from the origin SpiceDB mutation

    The type of scenarios WatchPermissionSets is particularly well suited is when a single change
    in the origin SpiceDB can yield millions of changes. For example, in the GitHub authorization model, assigning a role
    to a top-level team of an organization with hundreds of thousands of employees can lead to an explosion of
    permission change events that would require a lot of computational resources to process, both on Materialize and
    the consumer side.

    WatchPermissionSets is thus recommended for any larger scale use case where the fan-out in permission changes that
    emerges from a specific schema and data shape is too large to handle effectively.

    The API does not offer a sharding mechanism and thus there should only be one consumer per target system.
    Implementing an active-active HA consumer setup over the same target system will require coordinating which
    revisions have been consumed in order to prevent transitioning to an inconsistent state.
    """

    LookupPermissionSets: grpc.UnaryStreamMultiCallable[
        authzed.api.materialize.v0.watchpermissionsets_pb2.LookupPermissionSetsRequest,
        authzed.api.materialize.v0.watchpermissionsets_pb2.LookupPermissionSetsResponse,
    ]
    """LookupPermissionSets returns the current state of the permission sets which can be used to derive the computed permissions.
    It's typically used to backfill the state of the permission sets in the consumer side.

    It's a cursored API and the consumer is responsible to keep track of the cursor and use it on each subsequent call.
    Each stream will return <N> permission sets defined by the specified request limit. The server will keep streaming until
    the sets per stream is hit, or the current state of the sets is reached,
    whatever happens first, and then close the stream. The server will indicate there are no more changes to stream
    through the `completed_members` in the cursor.

    There may be many elements to stream, and so the consumer should be prepared to resume the stream from the last
    cursor received. Once completed, the consumer may start streaming permission set changes using WatchPermissionSets
    and the revision token from the last LookupPermissionSets response.
    """

class WatchPermissionSetsServiceAsyncStub:
    WatchPermissionSets: grpc.aio.UnaryStreamMultiCallable[
        authzed.api.materialize.v0.watchpermissionsets_pb2.WatchPermissionSetsRequest,
        authzed.api.materialize.v0.watchpermissionsets_pb2.WatchPermissionSetsResponse,
    ]
    """WatchPermissionSets returns a stream of changes to the sets which can be used to compute the watched permissions.

    WatchPermissionSets lets consumers achieve the same thing as WatchPermissions, but trades off a simpler usage model with
    significantly lower computational requirements. Unlike WatchPermissions, this method returns changes to the sets of permissions,
    rather than the individual permissions. Permission sets are a normalized form of the computed permissions, which
    means that the consumer must perform an extra computation over this representation to obtain the final computed
    permissions, typically by intersecting the provided sets.

    For example, this would look like a JOIN between the
    materialize permission sets table in a target relation database, the table with the resources to authorize access
    to, and the table with the subject (e.g. a user).

    In exchange, the number of changes issued by WatchPermissionSets will be several orders of magnitude less than those
    emitted by WatchPermissions, which has several implications:
    - significantly less resources to compute the sets
    - significantly less messages to stream over the network
    - significantly less events to ingest on the consumer side
    - less ingestion lag from the origin SpiceDB mutation

    The type of scenarios WatchPermissionSets is particularly well suited is when a single change
    in the origin SpiceDB can yield millions of changes. For example, in the GitHub authorization model, assigning a role
    to a top-level team of an organization with hundreds of thousands of employees can lead to an explosion of
    permission change events that would require a lot of computational resources to process, both on Materialize and
    the consumer side.

    WatchPermissionSets is thus recommended for any larger scale use case where the fan-out in permission changes that
    emerges from a specific schema and data shape is too large to handle effectively.

    The API does not offer a sharding mechanism and thus there should only be one consumer per target system.
    Implementing an active-active HA consumer setup over the same target system will require coordinating which
    revisions have been consumed in order to prevent transitioning to an inconsistent state.
    """

    LookupPermissionSets: grpc.aio.UnaryStreamMultiCallable[
        authzed.api.materialize.v0.watchpermissionsets_pb2.LookupPermissionSetsRequest,
        authzed.api.materialize.v0.watchpermissionsets_pb2.LookupPermissionSetsResponse,
    ]
    """LookupPermissionSets returns the current state of the permission sets which can be used to derive the computed permissions.
    It's typically used to backfill the state of the permission sets in the consumer side.

    It's a cursored API and the consumer is responsible to keep track of the cursor and use it on each subsequent call.
    Each stream will return <N> permission sets defined by the specified request limit. The server will keep streaming until
    the sets per stream is hit, or the current state of the sets is reached,
    whatever happens first, and then close the stream. The server will indicate there are no more changes to stream
    through the `completed_members` in the cursor.

    There may be many elements to stream, and so the consumer should be prepared to resume the stream from the last
    cursor received. Once completed, the consumer may start streaming permission set changes using WatchPermissionSets
    and the revision token from the last LookupPermissionSets response.
    """

class WatchPermissionSetsServiceServicer(metaclass=abc.ABCMeta):
    @abc.abstractmethod
    def WatchPermissionSets(
        self,
        request: authzed.api.materialize.v0.watchpermissionsets_pb2.WatchPermissionSetsRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[authzed.api.materialize.v0.watchpermissionsets_pb2.WatchPermissionSetsResponse], collections.abc.AsyncIterator[authzed.api.materialize.v0.watchpermissionsets_pb2.WatchPermissionSetsResponse]]:
        """WatchPermissionSets returns a stream of changes to the sets which can be used to compute the watched permissions.

        WatchPermissionSets lets consumers achieve the same thing as WatchPermissions, but trades off a simpler usage model with
        significantly lower computational requirements. Unlike WatchPermissions, this method returns changes to the sets of permissions,
        rather than the individual permissions. Permission sets are a normalized form of the computed permissions, which
        means that the consumer must perform an extra computation over this representation to obtain the final computed
        permissions, typically by intersecting the provided sets.

        For example, this would look like a JOIN between the
        materialize permission sets table in a target relation database, the table with the resources to authorize access
        to, and the table with the subject (e.g. a user).

        In exchange, the number of changes issued by WatchPermissionSets will be several orders of magnitude less than those
        emitted by WatchPermissions, which has several implications:
        - significantly less resources to compute the sets
        - significantly less messages to stream over the network
        - significantly less events to ingest on the consumer side
        - less ingestion lag from the origin SpiceDB mutation

        The type of scenarios WatchPermissionSets is particularly well suited is when a single change
        in the origin SpiceDB can yield millions of changes. For example, in the GitHub authorization model, assigning a role
        to a top-level team of an organization with hundreds of thousands of employees can lead to an explosion of
        permission change events that would require a lot of computational resources to process, both on Materialize and
        the consumer side.

        WatchPermissionSets is thus recommended for any larger scale use case where the fan-out in permission changes that
        emerges from a specific schema and data shape is too large to handle effectively.

        The API does not offer a sharding mechanism and thus there should only be one consumer per target system.
        Implementing an active-active HA consumer setup over the same target system will require coordinating which
        revisions have been consumed in order to prevent transitioning to an inconsistent state.
        """

    @abc.abstractmethod
    def LookupPermissionSets(
        self,
        request: authzed.api.materialize.v0.watchpermissionsets_pb2.LookupPermissionSetsRequest,
        context: _ServicerContext,
    ) -> typing.Union[collections.abc.Iterator[authzed.api.materialize.v0.watchpermissionsets_pb2.LookupPermissionSetsResponse], collections.abc.AsyncIterator[authzed.api.materialize.v0.watchpermissionsets_pb2.LookupPermissionSetsResponse]]:
        """LookupPermissionSets returns the current state of the permission sets which can be used to derive the computed permissions.
        It's typically used to backfill the state of the permission sets in the consumer side.

        It's a cursored API and the consumer is responsible to keep track of the cursor and use it on each subsequent call.
        Each stream will return <N> permission sets defined by the specified request limit. The server will keep streaming until
        the sets per stream is hit, or the current state of the sets is reached,
        whatever happens first, and then close the stream. The server will indicate there are no more changes to stream
        through the `completed_members` in the cursor.

        There may be many elements to stream, and so the consumer should be prepared to resume the stream from the last
        cursor received. Once completed, the consumer may start streaming permission set changes using WatchPermissionSets
        and the revision token from the last LookupPermissionSets response.
        """

def add_WatchPermissionSetsServiceServicer_to_server(servicer: WatchPermissionSetsServiceServicer, server: typing.Union[grpc.Server, grpc.aio.Server]) -> None: ...
