"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copyright 2023-2025 Buf Technologies, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.descriptor_pb2
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.internal.extension_dict
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _Ignore:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _IgnoreEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_Ignore.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    IGNORE_UNSPECIFIED: _Ignore.ValueType  # 0
    """Ignore rules if the field tracks presence and is unset. This is the default
    behavior.

    In proto3, only message fields, members of a Protobuf `oneof`, and fields
    with the `optional` label track presence. Consequently, the following fields
    are always validated, whether a value is set or not:

    ```proto
    syntax="proto3";

    message RulesApply {
      string email = 1 [
        (buf.validate.field).string.email = true
      ];
      int32 age = 2 [
        (buf.validate.field).int32.gt = 0
      ];
      repeated string labels = 3 [
        (buf.validate.field).repeated.min_items = 1
      ];
    }
    ```

    In contrast, the following fields track presence, and are only validated if
    a value is set:

    ```proto
    syntax="proto3";

    message RulesApplyIfSet {
      optional string email = 1 [
        (buf.validate.field).string.email = true
      ];
      oneof ref {
        string reference = 2 [
          (buf.validate.field).string.uuid = true
        ];
        string name = 3 [
          (buf.validate.field).string.min_len = 4
        ];
      }
      SomeMessage msg = 4 [
        (buf.validate.field).cel = {/* ... */}
      ];
    }
    ```

    To ensure that such a field is set, add the `required` rule.

    To learn which fields track presence, see the
    [Field Presence cheat sheet](https://protobuf.dev/programming-guides/field_presence/#cheat).
    """
    IGNORE_IF_ZERO_VALUE: _Ignore.ValueType  # 1
    """Ignore rules if the field is unset, or set to the zero value.

    The zero value depends on the field type:
    - For strings, the zero value is the empty string.
    - For bytes, the zero value is empty bytes.
    - For bool, the zero value is false.
    - For numeric types, the zero value is zero.
    - For enums, the zero value is the first defined enum value.
    - For repeated fields, the zero is an empty list.
    - For map fields, the zero is an empty map.
    - For message fields, absence of the message (typically a null-value) is considered zero value.

    For fields that track presence (e.g. adding the `optional` label in proto3),
    this a no-op and behavior is the same as the default `IGNORE_UNSPECIFIED`.
    """
    IGNORE_ALWAYS: _Ignore.ValueType  # 3
    """Always ignore rules, including the `required` rule.

    This is useful for ignoring the rules of a referenced message, or to
    temporarily ignore rules during development.

    ```proto
    message MyMessage {
      // The field's rules will always be ignored, including any validations
      // on value's fields.
      MyOtherMessage value = 1 [
        (buf.validate.field).ignore = IGNORE_ALWAYS
      ];
    }
    ```
    """

class Ignore(_Ignore, metaclass=_IgnoreEnumTypeWrapper):
    """Specifies how `FieldRules.ignore` behaves, depending on the field's value, and
    whether the field tracks presence.
    """

IGNORE_UNSPECIFIED: Ignore.ValueType  # 0
"""Ignore rules if the field tracks presence and is unset. This is the default
behavior.

In proto3, only message fields, members of a Protobuf `oneof`, and fields
with the `optional` label track presence. Consequently, the following fields
are always validated, whether a value is set or not:

```proto
syntax="proto3";

message RulesApply {
  string email = 1 [
    (buf.validate.field).string.email = true
  ];
  int32 age = 2 [
    (buf.validate.field).int32.gt = 0
  ];
  repeated string labels = 3 [
    (buf.validate.field).repeated.min_items = 1
  ];
}
```

In contrast, the following fields track presence, and are only validated if
a value is set:

```proto
syntax="proto3";

message RulesApplyIfSet {
  optional string email = 1 [
    (buf.validate.field).string.email = true
  ];
  oneof ref {
    string reference = 2 [
      (buf.validate.field).string.uuid = true
    ];
    string name = 3 [
      (buf.validate.field).string.min_len = 4
    ];
  }
  SomeMessage msg = 4 [
    (buf.validate.field).cel = {/* ... */}
  ];
}
```

To ensure that such a field is set, add the `required` rule.

To learn which fields track presence, see the
[Field Presence cheat sheet](https://protobuf.dev/programming-guides/field_presence/#cheat).
"""
IGNORE_IF_ZERO_VALUE: Ignore.ValueType  # 1
"""Ignore rules if the field is unset, or set to the zero value.

The zero value depends on the field type:
- For strings, the zero value is the empty string.
- For bytes, the zero value is empty bytes.
- For bool, the zero value is false.
- For numeric types, the zero value is zero.
- For enums, the zero value is the first defined enum value.
- For repeated fields, the zero is an empty list.
- For map fields, the zero is an empty map.
- For message fields, absence of the message (typically a null-value) is considered zero value.

For fields that track presence (e.g. adding the `optional` label in proto3),
this a no-op and behavior is the same as the default `IGNORE_UNSPECIFIED`.
"""
IGNORE_ALWAYS: Ignore.ValueType  # 3
"""Always ignore rules, including the `required` rule.

This is useful for ignoring the rules of a referenced message, or to
temporarily ignore rules during development.

```proto
message MyMessage {
  // The field's rules will always be ignored, including any validations
  // on value's fields.
  MyOtherMessage value = 1 [
    (buf.validate.field).ignore = IGNORE_ALWAYS
  ];
}
```
"""
global___Ignore = Ignore

class _KnownRegex:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _KnownRegexEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_KnownRegex.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    KNOWN_REGEX_UNSPECIFIED: _KnownRegex.ValueType  # 0
    KNOWN_REGEX_HTTP_HEADER_NAME: _KnownRegex.ValueType  # 1
    """HTTP header name as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2)."""
    KNOWN_REGEX_HTTP_HEADER_VALUE: _KnownRegex.ValueType  # 2
    """HTTP header value as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.4)."""

class KnownRegex(_KnownRegex, metaclass=_KnownRegexEnumTypeWrapper):
    """KnownRegex contains some well-known patterns."""

KNOWN_REGEX_UNSPECIFIED: KnownRegex.ValueType  # 0
KNOWN_REGEX_HTTP_HEADER_NAME: KnownRegex.ValueType  # 1
"""HTTP header name as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2)."""
KNOWN_REGEX_HTTP_HEADER_VALUE: KnownRegex.ValueType  # 2
"""HTTP header value as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.4)."""
global___KnownRegex = KnownRegex

@typing.final
class Rule(google.protobuf.message.Message):
    """`Rule` represents a validation rule written in the Common Expression
    Language (CEL) syntax. Each Rule includes a unique identifier, an
    optional error message, and the CEL expression to evaluate. For more
    information, [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).

    ```proto
    message Foo {
      option (buf.validate.message).cel = {
        id: "foo.bar"
        message: "bar must be greater than 0"
        expression: "this.bar > 0"
      };
      int32 bar = 1;
    }
    ```
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    EXPRESSION_FIELD_NUMBER: builtins.int
    id: builtins.str
    """`id` is a string that serves as a machine-readable name for this Rule.
    It should be unique within its scope, which could be either a message or a field.
    """
    message: builtins.str
    """`message` is an optional field that provides a human-readable error message
    for this Rule when the CEL expression evaluates to false. If a
    non-empty message is provided, any strings resulting from the CEL
    expression evaluation are ignored.
    """
    expression: builtins.str
    """`expression` is the actual CEL expression that will be evaluated for
    validation. This string must resolve to either a boolean or a string
    value. If the expression evaluates to false or a non-empty string, the
    validation is considered failed, and the message is rejected.
    """
    def __init__(
        self,
        *,
        id: builtins.str | None = ...,
        message: builtins.str | None = ...,
        expression: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["expression", b"expression", "id", b"id", "message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["expression", b"expression", "id", b"id", "message", b"message"]) -> None: ...

global___Rule = Rule

@typing.final
class MessageRules(google.protobuf.message.Message):
    """MessageRules represents validation rules that are applied to the entire message.
    It includes disabling options and a list of Rule messages representing Common Expression Language (CEL) validation rules.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CEL_FIELD_NUMBER: builtins.int
    ONEOF_FIELD_NUMBER: builtins.int
    @property
    def cel(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Rule]:
        """`cel` is a repeated field of type Rule. Each Rule specifies a validation rule to be applied to this message.
        These rules are written in Common Expression Language (CEL) syntax. For more information,
        [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).


        ```proto
        message MyMessage {
          // The field `foo` must be greater than 42.
          option (buf.validate.message).cel = {
            id: "my_message.value",
            message: "value must be greater than 42",
            expression: "this.foo > 42",
          };
          optional int32 foo = 1;
        }
        ```
        """

    @property
    def oneof(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___MessageOneofRule]:
        """`oneof` is a repeated field of type MessageOneofRule that specifies a list of fields
        of which at most one can be present. If `required` is also specified, then exactly one
        of the specified fields _must_ be present.

        This will enforce oneof-like constraints with a few features not provided by
        actual Protobuf oneof declarations:
          1. Repeated and map fields are allowed in this validation. In a Protobuf oneof,
             only scalar fields are allowed.
          2. Fields with implicit presence are allowed. In a Protobuf oneof, all member
             fields have explicit presence. This means that, for the purpose of determining
             how many fields are set, explicitly setting such a field to its zero value is
             effectively the same as not setting it at all.
          3. This will always generate validation errors for a message unmarshalled from
             serialized data that sets more than one field. With a Protobuf oneof, when
             multiple fields are present in the serialized form, earlier values are usually
             silently ignored when unmarshalling, with only the last field being set when
             unmarshalling completes.

        Note that adding a field to a `oneof` will also set the IGNORE_IF_ZERO_VALUE on the fields. This means
        only the field that is set will be validated and the unset fields are not validated according to the field rules.
        This behavior can be overridden by setting `ignore` against a field.

        ```proto
        message MyMessage {
          // Only one of `field1` or `field2` _can_ be present in this message.
          option (buf.validate.message).oneof = { fields: ["field1", "field2"] };
          // Exactly one of `field3` or `field4` _must_ be present in this message.
          option (buf.validate.message).oneof = { fields: ["field3", "field4"], required: true };
          string field1 = 1;
          bytes field2 = 2;
          bool field3 = 3;
          int32 field4 = 4;
        }
        ```
        """

    def __init__(
        self,
        *,
        cel: collections.abc.Iterable[global___Rule] | None = ...,
        oneof: collections.abc.Iterable[global___MessageOneofRule] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cel", b"cel", "oneof", b"oneof"]) -> None: ...

global___MessageRules = MessageRules

@typing.final
class MessageOneofRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELDS_FIELD_NUMBER: builtins.int
    REQUIRED_FIELD_NUMBER: builtins.int
    required: builtins.bool
    """If true, one of the fields specified _must_ be set."""
    @property
    def fields(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A list of field names to include in the oneof. All field names must be
        defined in the message. At least one field must be specified, and
        duplicates are not permitted.
        """

    def __init__(
        self,
        *,
        fields: collections.abc.Iterable[builtins.str] | None = ...,
        required: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["required", b"required"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["fields", b"fields", "required", b"required"]) -> None: ...

global___MessageOneofRule = MessageOneofRule

@typing.final
class OneofRules(google.protobuf.message.Message):
    """The `OneofRules` message type enables you to manage rules for
    oneof fields in your protobuf messages.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REQUIRED_FIELD_NUMBER: builtins.int
    required: builtins.bool
    """If `required` is true, exactly one field of the oneof must be set. A
    validation error is returned if no fields in the oneof are set. Further rules
    should be placed on the fields themselves to ensure they are valid values,
    such as `min_len` or `gt`.

    ```proto
    message MyMessage {
      oneof value {
        // Either `a` or `b` must be set. If `a` is set, it must also be
        // non-empty; whereas if `b` is set, it can still be an empty string.
        option (buf.validate.oneof).required = true;
        string a = 1 [(buf.validate.field).string.min_len = 1];
        string b = 2;
      }
    }
    ```
    """
    def __init__(
        self,
        *,
        required: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["required", b"required"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["required", b"required"]) -> None: ...

global___OneofRules = OneofRules

@typing.final
class FieldRules(google.protobuf.message.Message):
    """FieldRules encapsulates the rules for each type of field. Depending on
    the field, the correct set should be used to ensure proper validations.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CEL_FIELD_NUMBER: builtins.int
    REQUIRED_FIELD_NUMBER: builtins.int
    IGNORE_FIELD_NUMBER: builtins.int
    FLOAT_FIELD_NUMBER: builtins.int
    DOUBLE_FIELD_NUMBER: builtins.int
    INT32_FIELD_NUMBER: builtins.int
    INT64_FIELD_NUMBER: builtins.int
    UINT32_FIELD_NUMBER: builtins.int
    UINT64_FIELD_NUMBER: builtins.int
    SINT32_FIELD_NUMBER: builtins.int
    SINT64_FIELD_NUMBER: builtins.int
    FIXED32_FIELD_NUMBER: builtins.int
    FIXED64_FIELD_NUMBER: builtins.int
    SFIXED32_FIELD_NUMBER: builtins.int
    SFIXED64_FIELD_NUMBER: builtins.int
    BOOL_FIELD_NUMBER: builtins.int
    STRING_FIELD_NUMBER: builtins.int
    BYTES_FIELD_NUMBER: builtins.int
    ENUM_FIELD_NUMBER: builtins.int
    REPEATED_FIELD_NUMBER: builtins.int
    MAP_FIELD_NUMBER: builtins.int
    ANY_FIELD_NUMBER: builtins.int
    DURATION_FIELD_NUMBER: builtins.int
    TIMESTAMP_FIELD_NUMBER: builtins.int
    required: builtins.bool
    """If `required` is true, the field must be set. A validation error is returned
    if the field is not set.

    ```proto
    syntax="proto3";

    message FieldsWithPresence {
      // Requires any string to be set, including the empty string.
      optional string link = 1 [
        (buf.validate.field).required = true
      ];
      // Requires true or false to be set.
      optional bool disabled = 2 [
        (buf.validate.field).required = true
      ];
      // Requires a message to be set, including the empty message.
      SomeMessage msg = 4 [
        (buf.validate.field).required = true
      ];
    }
    ```

    All fields in the example above track presence. By default, Protovalidate
    ignores rules on those fields if no value is set. `required` ensures that
    the fields are set and valid.

    Fields that don't track presence are always validated by Protovalidate,
    whether they are set or not. It is not necessary to add `required`. It
    can be added to indicate that the field cannot be the zero value.

    ```proto
    syntax="proto3";

    message FieldsWithoutPresence {
      // `string.email` always applies, even to an empty string.
      string link = 1 [
        (buf.validate.field).string.email = true
      ];
      // `repeated.min_items` always applies, even to an empty list.
      repeated string labels = 2 [
        (buf.validate.field).repeated.min_items = 1
      ];
      // `required`, for fields that don't track presence, indicates
      // the value of the field can't be the zero value.
      int32 zero_value_not_allowed = 3 [
        (buf.validate.field).required = true
      ];
    }
    ```

    To learn which fields track presence, see the
    [Field Presence cheat sheet](https://protobuf.dev/programming-guides/field_presence/#cheat).

    Note: While field rules can be applied to repeated items, map keys, and map
    values, the elements are always considered to be set. Consequently,
    specifying `repeated.items.required` is redundant.
    """
    ignore: global___Ignore.ValueType
    """Ignore validation rules on the field if its value matches the specified
    criteria. See the `Ignore` enum for details.

    ```proto
    message UpdateRequest {
      // The uri rule only applies if the field is not an empty string.
      string url = 1 [
        (buf.validate.field).ignore = IGNORE_IF_ZERO_VALUE,
        (buf.validate.field).string.uri = true
      ];
    }
    ```
    """
    @property
    def cel(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Rule]:
        """`cel` is a repeated field used to represent a textual expression
        in the Common Expression Language (CEL) syntax. For more information,
        [see our documentation](https://buf.build/docs/protovalidate/schemas/custom-rules/).

        ```proto
        message MyMessage {
          // The field `value` must be greater than 42.
          optional int32 value = 1 [(buf.validate.field).cel = {
            id: "my_message.value",
            message: "value must be greater than 42",
            expression: "this > 42",
          }];
        }
        ```
        """

    @property
    def float(self) -> global___FloatRules:
        """Scalar Field Types"""

    @property
    def double(self) -> global___DoubleRules: ...
    @property
    def int32(self) -> global___Int32Rules: ...
    @property
    def int64(self) -> global___Int64Rules: ...
    @property
    def uint32(self) -> global___UInt32Rules: ...
    @property
    def uint64(self) -> global___UInt64Rules: ...
    @property
    def sint32(self) -> global___SInt32Rules: ...
    @property
    def sint64(self) -> global___SInt64Rules: ...
    @property
    def fixed32(self) -> global___Fixed32Rules: ...
    @property
    def fixed64(self) -> global___Fixed64Rules: ...
    @property
    def sfixed32(self) -> global___SFixed32Rules: ...
    @property
    def sfixed64(self) -> global___SFixed64Rules: ...
    @property
    def bool(self) -> global___BoolRules: ...
    @property
    def string(self) -> global___StringRules: ...
    @property
    def bytes(self) -> global___BytesRules: ...
    @property
    def enum(self) -> global___EnumRules:
        """Complex Field Types"""

    @property
    def repeated(self) -> global___RepeatedRules: ...
    @property
    def map(self) -> global___MapRules: ...
    @property
    def any(self) -> global___AnyRules:
        """Well-Known Field Types"""

    @property
    def duration(self) -> global___DurationRules: ...
    @property
    def timestamp(self) -> global___TimestampRules: ...
    def __init__(
        self,
        *,
        cel: collections.abc.Iterable[global___Rule] | None = ...,
        required: builtins.bool | None = ...,
        ignore: global___Ignore.ValueType | None = ...,
        float: global___FloatRules | None = ...,
        double: global___DoubleRules | None = ...,
        int32: global___Int32Rules | None = ...,
        int64: global___Int64Rules | None = ...,
        uint32: global___UInt32Rules | None = ...,
        uint64: global___UInt64Rules | None = ...,
        sint32: global___SInt32Rules | None = ...,
        sint64: global___SInt64Rules | None = ...,
        fixed32: global___Fixed32Rules | None = ...,
        fixed64: global___Fixed64Rules | None = ...,
        sfixed32: global___SFixed32Rules | None = ...,
        sfixed64: global___SFixed64Rules | None = ...,
        bool: global___BoolRules | None = ...,
        string: global___StringRules | None = ...,
        bytes: global___BytesRules | None = ...,
        enum: global___EnumRules | None = ...,
        repeated: global___RepeatedRules | None = ...,
        map: global___MapRules | None = ...,
        any: global___AnyRules | None = ...,
        duration: global___DurationRules | None = ...,
        timestamp: global___TimestampRules | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["any", b"any", "bool", b"bool", "bytes", b"bytes", "double", b"double", "duration", b"duration", "enum", b"enum", "fixed32", b"fixed32", "fixed64", b"fixed64", "float", b"float", "ignore", b"ignore", "int32", b"int32", "int64", b"int64", "map", b"map", "repeated", b"repeated", "required", b"required", "sfixed32", b"sfixed32", "sfixed64", b"sfixed64", "sint32", b"sint32", "sint64", b"sint64", "string", b"string", "timestamp", b"timestamp", "type", b"type", "uint32", b"uint32", "uint64", b"uint64"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["any", b"any", "bool", b"bool", "bytes", b"bytes", "cel", b"cel", "double", b"double", "duration", b"duration", "enum", b"enum", "fixed32", b"fixed32", "fixed64", b"fixed64", "float", b"float", "ignore", b"ignore", "int32", b"int32", "int64", b"int64", "map", b"map", "repeated", b"repeated", "required", b"required", "sfixed32", b"sfixed32", "sfixed64", b"sfixed64", "sint32", b"sint32", "sint64", b"sint64", "string", b"string", "timestamp", b"timestamp", "type", b"type", "uint32", b"uint32", "uint64", b"uint64"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["type", b"type"]) -> typing.Literal["float", "double", "int32", "int64", "uint32", "uint64", "sint32", "sint64", "fixed32", "fixed64", "sfixed32", "sfixed64", "bool", "string", "bytes", "enum", "repeated", "map", "any", "duration", "timestamp"] | None: ...

global___FieldRules = FieldRules

@typing.final
class PredefinedRules(google.protobuf.message.Message):
    """PredefinedRules are custom rules that can be re-used with
    multiple fields.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CEL_FIELD_NUMBER: builtins.int
    @property
    def cel(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Rule]:
        """`cel` is a repeated field used to represent a textual expression
        in the Common Expression Language (CEL) syntax. For more information,
        [see our documentation](https://buf.build/docs/protovalidate/schemas/predefined-rules/).

        ```proto
        message MyMessage {
          // The field `value` must be greater than 42.
          optional int32 value = 1 [(buf.validate.predefined).cel = {
            id: "my_message.value",
            message: "value must be greater than 42",
            expression: "this > 42",
          }];
        }
        ```
        """

    def __init__(
        self,
        *,
        cel: collections.abc.Iterable[global___Rule] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["cel", b"cel"]) -> None: ...

global___PredefinedRules = PredefinedRules

@typing.final
class FloatRules(google.protobuf.message.Message):
    """FloatRules describes the rules applied to `float` values. These
    rules may also be applied to the `google.protobuf.FloatValue` Well-Known-Type.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    FINITE_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.float
    """`const` requires the field value to exactly match the specified value. If
    the field value doesn't match, an error message is generated.

    ```proto
    message MyFloat {
      // value must equal 42.0
      float value = 1 [(buf.validate.field).float.const = 42.0];
    }
    ```
    """
    lt: builtins.float
    """`lt` requires the field value to be less than the specified value (field <
    value). If the field value is equal to or greater than the specified value,
    an error message is generated.

    ```proto
    message MyFloat {
      // value must be less than 10.0
      float value = 1 [(buf.validate.field).float.lt = 10.0];
    }
    ```
    """
    lte: builtins.float
    """`lte` requires the field value to be less than or equal to the specified
    value (field <= value). If the field value is greater than the specified
    value, an error message is generated.

    ```proto
    message MyFloat {
      // value must be less than or equal to 10.0
      float value = 1 [(buf.validate.field).float.lte = 10.0];
    }
    ```
    """
    gt: builtins.float
    """`gt` requires the field value to be greater than the specified value
    (exclusive). If the value of `gt` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyFloat {
      // value must be greater than 5.0 [float.gt]
      float value = 1 [(buf.validate.field).float.gt = 5.0];

      // value must be greater than 5 and less than 10.0 [float.gt_lt]
      float other_value = 2 [(buf.validate.field).float = { gt: 5.0, lt: 10.0 }];

      // value must be greater than 10 or less than 5.0 [float.gt_lt_exclusive]
      float another_value = 3 [(buf.validate.field).float = { gt: 10.0, lt: 5.0 }];
    }
    ```
    """
    gte: builtins.float
    """`gte` requires the field value to be greater than or equal to the specified
    value (exclusive). If the value of `gte` is larger than a specified `lt`
    or `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyFloat {
      // value must be greater than or equal to 5.0 [float.gte]
      float value = 1 [(buf.validate.field).float.gte = 5.0];

      // value must be greater than or equal to 5.0 and less than 10.0 [float.gte_lt]
      float other_value = 2 [(buf.validate.field).float = { gte: 5.0, lt: 10.0 }];

      // value must be greater than or equal to 10.0 or less than 5.0 [float.gte_lt_exclusive]
      float another_value = 3 [(buf.validate.field).float = { gte: 10.0, lt: 5.0 }];
    }
    ```
    """
    finite: builtins.bool
    """`finite` requires the field value to be finite. If the field value is
    infinite or NaN, an error message is generated.
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """`in` requires the field value to not be equal to any of the specified
        values. If the field value is one of the specified values, an error
        message is generated.

        ```proto
        message MyFloat {
          // value must not be in list [1.0, 2.0, 3.0]
          float value = 1 [(buf.validate.field).float = { not_in: [1.0, 2.0, 3.0] }];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyFloat {
          float value = 1 [
            (buf.validate.field).float.example = 1.0,
            (buf.validate.field).float.example = inf
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.float | None = ...,
        lt: builtins.float | None = ...,
        lte: builtins.float | None = ...,
        gt: builtins.float | None = ...,
        gte: builtins.float | None = ...,
        not_in: collections.abc.Iterable[builtins.float] | None = ...,
        finite: builtins.bool | None = ...,
        example: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "finite", b"finite", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "finite", b"finite", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___FloatRules = FloatRules

@typing.final
class DoubleRules(google.protobuf.message.Message):
    """DoubleRules describes the rules applied to `double` values. These
    rules may also be applied to the `google.protobuf.DoubleValue` Well-Known-Type.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    FINITE_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.float
    """`const` requires the field value to exactly match the specified value. If
    the field value doesn't match, an error message is generated.

    ```proto
    message MyDouble {
      // value must equal 42.0
      double value = 1 [(buf.validate.field).double.const = 42.0];
    }
    ```
    """
    lt: builtins.float
    """`lt` requires the field value to be less than the specified value (field <
    value). If the field value is equal to or greater than the specified
    value, an error message is generated.

    ```proto
    message MyDouble {
      // value must be less than 10.0
      double value = 1 [(buf.validate.field).double.lt = 10.0];
    }
    ```
    """
    lte: builtins.float
    """`lte` requires the field value to be less than or equal to the specified value
    (field <= value). If the field value is greater than the specified value,
    an error message is generated.

    ```proto
    message MyDouble {
      // value must be less than or equal to 10.0
      double value = 1 [(buf.validate.field).double.lte = 10.0];
    }
    ```
    """
    gt: builtins.float
    """`gt` requires the field value to be greater than the specified value
    (exclusive). If the value of `gt` is larger than a specified `lt` or `lte`,
    the range is reversed, and the field value must be outside the specified
    range. If the field value doesn't meet the required conditions, an error
    message is generated.

    ```proto
    message MyDouble {
      // value must be greater than 5.0 [double.gt]
      double value = 1 [(buf.validate.field).double.gt = 5.0];

      // value must be greater than 5 and less than 10.0 [double.gt_lt]
      double other_value = 2 [(buf.validate.field).double = { gt: 5.0, lt: 10.0 }];

      // value must be greater than 10 or less than 5.0 [double.gt_lt_exclusive]
      double another_value = 3 [(buf.validate.field).double = { gt: 10.0, lt: 5.0 }];
    }
    ```
    """
    gte: builtins.float
    """`gte` requires the field value to be greater than or equal to the specified
    value (exclusive). If the value of `gte` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyDouble {
      // value must be greater than or equal to 5.0 [double.gte]
      double value = 1 [(buf.validate.field).double.gte = 5.0];

      // value must be greater than or equal to 5.0 and less than 10.0 [double.gte_lt]
      double other_value = 2 [(buf.validate.field).double = { gte: 5.0, lt: 10.0 }];

      // value must be greater than or equal to 10.0 or less than 5.0 [double.gte_lt_exclusive]
      double another_value = 3 [(buf.validate.field).double = { gte: 10.0, lt: 5.0 }];
    }
    ```
    """
    finite: builtins.bool
    """`finite` requires the field value to be finite. If the field value is
    infinite or NaN, an error message is generated.
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """`not_in` requires the field value to not be equal to any of the specified
        values. If the field value is one of the specified values, an error
        message is generated.

        ```proto
        message MyDouble {
          // value must not be in list [1.0, 2.0, 3.0]
          double value = 1 [(buf.validate.field).double = { not_in: [1.0, 2.0, 3.0] }];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.float]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyDouble {
          double value = 1 [
            (buf.validate.field).double.example = 1.0,
            (buf.validate.field).double.example = inf
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.float | None = ...,
        lt: builtins.float | None = ...,
        lte: builtins.float | None = ...,
        gt: builtins.float | None = ...,
        gte: builtins.float | None = ...,
        not_in: collections.abc.Iterable[builtins.float] | None = ...,
        finite: builtins.bool | None = ...,
        example: collections.abc.Iterable[builtins.float] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "finite", b"finite", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "finite", b"finite", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___DoubleRules = DoubleRules

@typing.final
class Int32Rules(google.protobuf.message.Message):
    """Int32Rules describes the rules applied to `int32` values. These
    rules may also be applied to the `google.protobuf.Int32Value` Well-Known-Type.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.int
    """`const` requires the field value to exactly match the specified value. If
    the field value doesn't match, an error message is generated.

    ```proto
    message MyInt32 {
      // value must equal 42
      int32 value = 1 [(buf.validate.field).int32.const = 42];
    }
    ```
    """
    lt: builtins.int
    """`lt` requires the field value to be less than the specified value (field
    < value). If the field value is equal to or greater than the specified
    value, an error message is generated.

    ```proto
    message MyInt32 {
      // value must be less than 10
      int32 value = 1 [(buf.validate.field).int32.lt = 10];
    }
    ```
    """
    lte: builtins.int
    """`lte` requires the field value to be less than or equal to the specified
    value (field <= value). If the field value is greater than the specified
    value, an error message is generated.

    ```proto
    message MyInt32 {
      // value must be less than or equal to 10
      int32 value = 1 [(buf.validate.field).int32.lte = 10];
    }
    ```
    """
    gt: builtins.int
    """`gt` requires the field value to be greater than the specified value
    (exclusive). If the value of `gt` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyInt32 {
      // value must be greater than 5 [int32.gt]
      int32 value = 1 [(buf.validate.field).int32.gt = 5];

      // value must be greater than 5 and less than 10 [int32.gt_lt]
      int32 other_value = 2 [(buf.validate.field).int32 = { gt: 5, lt: 10 }];

      // value must be greater than 10 or less than 5 [int32.gt_lt_exclusive]
      int32 another_value = 3 [(buf.validate.field).int32 = { gt: 10, lt: 5 }];
    }
    ```
    """
    gte: builtins.int
    """`gte` requires the field value to be greater than or equal to the specified value
    (exclusive). If the value of `gte` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyInt32 {
      // value must be greater than or equal to 5 [int32.gte]
      int32 value = 1 [(buf.validate.field).int32.gte = 5];

      // value must be greater than or equal to 5 and less than 10 [int32.gte_lt]
      int32 other_value = 2 [(buf.validate.field).int32 = { gte: 5, lt: 10 }];

      // value must be greater than or equal to 10 or less than 5 [int32.gte_lt_exclusive]
      int32 another_value = 3 [(buf.validate.field).int32 = { gte: 10, lt: 5 }];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`not_in` requires the field value to not be equal to any of the specified
        values. If the field value is one of the specified values, an error message
        is generated.

        ```proto
        message MyInt32 {
          // value must not be in list [1, 2, 3]
          int32 value = 1 [(buf.validate.field).int32 = { not_in: [1, 2, 3] }];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyInt32 {
          int32 value = 1 [
            (buf.validate.field).int32.example = 1,
            (buf.validate.field).int32.example = -10
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.int | None = ...,
        lt: builtins.int | None = ...,
        lte: builtins.int | None = ...,
        gt: builtins.int | None = ...,
        gte: builtins.int | None = ...,
        not_in: collections.abc.Iterable[builtins.int] | None = ...,
        example: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___Int32Rules = Int32Rules

@typing.final
class Int64Rules(google.protobuf.message.Message):
    """Int64Rules describes the rules applied to `int64` values. These
    rules may also be applied to the `google.protobuf.Int64Value` Well-Known-Type.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.int
    """`const` requires the field value to exactly match the specified value. If
    the field value doesn't match, an error message is generated.

    ```proto
    message MyInt64 {
      // value must equal 42
      int64 value = 1 [(buf.validate.field).int64.const = 42];
    }
    ```
    """
    lt: builtins.int
    """`lt` requires the field value to be less than the specified value (field <
    value). If the field value is equal to or greater than the specified value,
    an error message is generated.

    ```proto
    message MyInt64 {
      // value must be less than 10
      int64 value = 1 [(buf.validate.field).int64.lt = 10];
    }
    ```
    """
    lte: builtins.int
    """`lte` requires the field value to be less than or equal to the specified
    value (field <= value). If the field value is greater than the specified
    value, an error message is generated.

    ```proto
    message MyInt64 {
      // value must be less than or equal to 10
      int64 value = 1 [(buf.validate.field).int64.lte = 10];
    }
    ```
    """
    gt: builtins.int
    """`gt` requires the field value to be greater than the specified value
    (exclusive). If the value of `gt` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyInt64 {
      // value must be greater than 5 [int64.gt]
      int64 value = 1 [(buf.validate.field).int64.gt = 5];

      // value must be greater than 5 and less than 10 [int64.gt_lt]
      int64 other_value = 2 [(buf.validate.field).int64 = { gt: 5, lt: 10 }];

      // value must be greater than 10 or less than 5 [int64.gt_lt_exclusive]
      int64 another_value = 3 [(buf.validate.field).int64 = { gt: 10, lt: 5 }];
    }
    ```
    """
    gte: builtins.int
    """`gte` requires the field value to be greater than or equal to the specified
    value (exclusive). If the value of `gte` is larger than a specified `lt`
    or `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyInt64 {
      // value must be greater than or equal to 5 [int64.gte]
      int64 value = 1 [(buf.validate.field).int64.gte = 5];

      // value must be greater than or equal to 5 and less than 10 [int64.gte_lt]
      int64 other_value = 2 [(buf.validate.field).int64 = { gte: 5, lt: 10 }];

      // value must be greater than or equal to 10 or less than 5 [int64.gte_lt_exclusive]
      int64 another_value = 3 [(buf.validate.field).int64 = { gte: 10, lt: 5 }];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`not_in` requires the field value to not be equal to any of the specified
        values. If the field value is one of the specified values, an error
        message is generated.

        ```proto
        message MyInt64 {
          // value must not be in list [1, 2, 3]
          int64 value = 1 [(buf.validate.field).int64 = { not_in: [1, 2, 3] }];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyInt64 {
          int64 value = 1 [
            (buf.validate.field).int64.example = 1,
            (buf.validate.field).int64.example = -10
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.int | None = ...,
        lt: builtins.int | None = ...,
        lte: builtins.int | None = ...,
        gt: builtins.int | None = ...,
        gte: builtins.int | None = ...,
        not_in: collections.abc.Iterable[builtins.int] | None = ...,
        example: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___Int64Rules = Int64Rules

@typing.final
class UInt32Rules(google.protobuf.message.Message):
    """UInt32Rules describes the rules applied to `uint32` values. These
    rules may also be applied to the `google.protobuf.UInt32Value` Well-Known-Type.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.int
    """`const` requires the field value to exactly match the specified value. If
    the field value doesn't match, an error message is generated.

    ```proto
    message MyUInt32 {
      // value must equal 42
      uint32 value = 1 [(buf.validate.field).uint32.const = 42];
    }
    ```
    """
    lt: builtins.int
    """`lt` requires the field value to be less than the specified value (field <
    value). If the field value is equal to or greater than the specified value,
    an error message is generated.

    ```proto
    message MyUInt32 {
      // value must be less than 10
      uint32 value = 1 [(buf.validate.field).uint32.lt = 10];
    }
    ```
    """
    lte: builtins.int
    """`lte` requires the field value to be less than or equal to the specified
    value (field <= value). If the field value is greater than the specified
    value, an error message is generated.

    ```proto
    message MyUInt32 {
      // value must be less than or equal to 10
      uint32 value = 1 [(buf.validate.field).uint32.lte = 10];
    }
    ```
    """
    gt: builtins.int
    """`gt` requires the field value to be greater than the specified value
    (exclusive). If the value of `gt` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyUInt32 {
      // value must be greater than 5 [uint32.gt]
      uint32 value = 1 [(buf.validate.field).uint32.gt = 5];

      // value must be greater than 5 and less than 10 [uint32.gt_lt]
      uint32 other_value = 2 [(buf.validate.field).uint32 = { gt: 5, lt: 10 }];

      // value must be greater than 10 or less than 5 [uint32.gt_lt_exclusive]
      uint32 another_value = 3 [(buf.validate.field).uint32 = { gt: 10, lt: 5 }];
    }
    ```
    """
    gte: builtins.int
    """`gte` requires the field value to be greater than or equal to the specified
    value (exclusive). If the value of `gte` is larger than a specified `lt`
    or `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyUInt32 {
      // value must be greater than or equal to 5 [uint32.gte]
      uint32 value = 1 [(buf.validate.field).uint32.gte = 5];

      // value must be greater than or equal to 5 and less than 10 [uint32.gte_lt]
      uint32 other_value = 2 [(buf.validate.field).uint32 = { gte: 5, lt: 10 }];

      // value must be greater than or equal to 10 or less than 5 [uint32.gte_lt_exclusive]
      uint32 another_value = 3 [(buf.validate.field).uint32 = { gte: 10, lt: 5 }];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`not_in` requires the field value to not be equal to any of the specified
        values. If the field value is one of the specified values, an error
        message is generated.

        ```proto
        message MyUInt32 {
          // value must not be in list [1, 2, 3]
          uint32 value = 1 [(buf.validate.field).uint32 = { not_in: [1, 2, 3] }];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyUInt32 {
          uint32 value = 1 [
            (buf.validate.field).uint32.example = 1,
            (buf.validate.field).uint32.example = 10
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.int | None = ...,
        lt: builtins.int | None = ...,
        lte: builtins.int | None = ...,
        gt: builtins.int | None = ...,
        gte: builtins.int | None = ...,
        not_in: collections.abc.Iterable[builtins.int] | None = ...,
        example: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___UInt32Rules = UInt32Rules

@typing.final
class UInt64Rules(google.protobuf.message.Message):
    """UInt64Rules describes the rules applied to `uint64` values. These
    rules may also be applied to the `google.protobuf.UInt64Value` Well-Known-Type.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.int
    """`const` requires the field value to exactly match the specified value. If
    the field value doesn't match, an error message is generated.

    ```proto
    message MyUInt64 {
      // value must equal 42
      uint64 value = 1 [(buf.validate.field).uint64.const = 42];
    }
    ```
    """
    lt: builtins.int
    """`lt` requires the field value to be less than the specified value (field <
    value). If the field value is equal to or greater than the specified value,
    an error message is generated.

    ```proto
    message MyUInt64 {
      // value must be less than 10
      uint64 value = 1 [(buf.validate.field).uint64.lt = 10];
    }
    ```
    """
    lte: builtins.int
    """`lte` requires the field value to be less than or equal to the specified
    value (field <= value). If the field value is greater than the specified
    value, an error message is generated.

    ```proto
    message MyUInt64 {
      // value must be less than or equal to 10
      uint64 value = 1 [(buf.validate.field).uint64.lte = 10];
    }
    ```
    """
    gt: builtins.int
    """`gt` requires the field value to be greater than the specified value
    (exclusive). If the value of `gt` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyUInt64 {
      // value must be greater than 5 [uint64.gt]
      uint64 value = 1 [(buf.validate.field).uint64.gt = 5];

      // value must be greater than 5 and less than 10 [uint64.gt_lt]
      uint64 other_value = 2 [(buf.validate.field).uint64 = { gt: 5, lt: 10 }];

      // value must be greater than 10 or less than 5 [uint64.gt_lt_exclusive]
      uint64 another_value = 3 [(buf.validate.field).uint64 = { gt: 10, lt: 5 }];
    }
    ```
    """
    gte: builtins.int
    """`gte` requires the field value to be greater than or equal to the specified
    value (exclusive). If the value of `gte` is larger than a specified `lt`
    or `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyUInt64 {
      // value must be greater than or equal to 5 [uint64.gte]
      uint64 value = 1 [(buf.validate.field).uint64.gte = 5];

      // value must be greater than or equal to 5 and less than 10 [uint64.gte_lt]
      uint64 other_value = 2 [(buf.validate.field).uint64 = { gte: 5, lt: 10 }];

      // value must be greater than or equal to 10 or less than 5 [uint64.gte_lt_exclusive]
      uint64 another_value = 3 [(buf.validate.field).uint64 = { gte: 10, lt: 5 }];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`not_in` requires the field value to not be equal to any of the specified
        values. If the field value is one of the specified values, an error
        message is generated.

        ```proto
        message MyUInt64 {
          // value must not be in list [1, 2, 3]
          uint64 value = 1 [(buf.validate.field).uint64 = { not_in: [1, 2, 3] }];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyUInt64 {
          uint64 value = 1 [
            (buf.validate.field).uint64.example = 1,
            (buf.validate.field).uint64.example = -10
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.int | None = ...,
        lt: builtins.int | None = ...,
        lte: builtins.int | None = ...,
        gt: builtins.int | None = ...,
        gte: builtins.int | None = ...,
        not_in: collections.abc.Iterable[builtins.int] | None = ...,
        example: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___UInt64Rules = UInt64Rules

@typing.final
class SInt32Rules(google.protobuf.message.Message):
    """SInt32Rules describes the rules applied to `sint32` values."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.int
    """`const` requires the field value to exactly match the specified value. If
    the field value doesn't match, an error message is generated.

    ```proto
    message MySInt32 {
      // value must equal 42
      sint32 value = 1 [(buf.validate.field).sint32.const = 42];
    }
    ```
    """
    lt: builtins.int
    """`lt` requires the field value to be less than the specified value (field
    < value). If the field value is equal to or greater than the specified
    value, an error message is generated.

    ```proto
    message MySInt32 {
      // value must be less than 10
      sint32 value = 1 [(buf.validate.field).sint32.lt = 10];
    }
    ```
    """
    lte: builtins.int
    """`lte` requires the field value to be less than or equal to the specified
    value (field <= value). If the field value is greater than the specified
    value, an error message is generated.

    ```proto
    message MySInt32 {
      // value must be less than or equal to 10
      sint32 value = 1 [(buf.validate.field).sint32.lte = 10];
    }
    ```
    """
    gt: builtins.int
    """`gt` requires the field value to be greater than the specified value
    (exclusive). If the value of `gt` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MySInt32 {
      // value must be greater than 5 [sint32.gt]
      sint32 value = 1 [(buf.validate.field).sint32.gt = 5];

      // value must be greater than 5 and less than 10 [sint32.gt_lt]
      sint32 other_value = 2 [(buf.validate.field).sint32 = { gt: 5, lt: 10 }];

      // value must be greater than 10 or less than 5 [sint32.gt_lt_exclusive]
      sint32 another_value = 3 [(buf.validate.field).sint32 = { gt: 10, lt: 5 }];
    }
    ```
    """
    gte: builtins.int
    """`gte` requires the field value to be greater than or equal to the specified
    value (exclusive). If the value of `gte` is larger than a specified `lt`
    or `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MySInt32 {
     // value must be greater than or equal to 5 [sint32.gte]
     sint32 value = 1 [(buf.validate.field).sint32.gte = 5];

     // value must be greater than or equal to 5 and less than 10 [sint32.gte_lt]
     sint32 other_value = 2 [(buf.validate.field).sint32 = { gte: 5, lt: 10 }];

     // value must be greater than or equal to 10 or less than 5 [sint32.gte_lt_exclusive]
     sint32 another_value = 3 [(buf.validate.field).sint32 = { gte: 10, lt: 5 }];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`not_in` requires the field value to not be equal to any of the specified
        values. If the field value is one of the specified values, an error
        message is generated.

        ```proto
        message MySInt32 {
          // value must not be in list [1, 2, 3]
          sint32 value = 1 [(buf.validate.field).sint32 = { not_in: [1, 2, 3] }];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MySInt32 {
          sint32 value = 1 [
            (buf.validate.field).sint32.example = 1,
            (buf.validate.field).sint32.example = -10
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.int | None = ...,
        lt: builtins.int | None = ...,
        lte: builtins.int | None = ...,
        gt: builtins.int | None = ...,
        gte: builtins.int | None = ...,
        not_in: collections.abc.Iterable[builtins.int] | None = ...,
        example: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___SInt32Rules = SInt32Rules

@typing.final
class SInt64Rules(google.protobuf.message.Message):
    """SInt64Rules describes the rules applied to `sint64` values."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.int
    """`const` requires the field value to exactly match the specified value. If
    the field value doesn't match, an error message is generated.

    ```proto
    message MySInt64 {
      // value must equal 42
      sint64 value = 1 [(buf.validate.field).sint64.const = 42];
    }
    ```
    """
    lt: builtins.int
    """`lt` requires the field value to be less than the specified value (field
    < value). If the field value is equal to or greater than the specified
    value, an error message is generated.

    ```proto
    message MySInt64 {
      // value must be less than 10
      sint64 value = 1 [(buf.validate.field).sint64.lt = 10];
    }
    ```
    """
    lte: builtins.int
    """`lte` requires the field value to be less than or equal to the specified
    value (field <= value). If the field value is greater than the specified
    value, an error message is generated.

    ```proto
    message MySInt64 {
      // value must be less than or equal to 10
      sint64 value = 1 [(buf.validate.field).sint64.lte = 10];
    }
    ```
    """
    gt: builtins.int
    """`gt` requires the field value to be greater than the specified value
    (exclusive). If the value of `gt` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MySInt64 {
      // value must be greater than 5 [sint64.gt]
      sint64 value = 1 [(buf.validate.field).sint64.gt = 5];

      // value must be greater than 5 and less than 10 [sint64.gt_lt]
      sint64 other_value = 2 [(buf.validate.field).sint64 = { gt: 5, lt: 10 }];

      // value must be greater than 10 or less than 5 [sint64.gt_lt_exclusive]
      sint64 another_value = 3 [(buf.validate.field).sint64 = { gt: 10, lt: 5 }];
    }
    ```
    """
    gte: builtins.int
    """`gte` requires the field value to be greater than or equal to the specified
    value (exclusive). If the value of `gte` is larger than a specified `lt`
    or `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MySInt64 {
      // value must be greater than or equal to 5 [sint64.gte]
      sint64 value = 1 [(buf.validate.field).sint64.gte = 5];

      // value must be greater than or equal to 5 and less than 10 [sint64.gte_lt]
      sint64 other_value = 2 [(buf.validate.field).sint64 = { gte: 5, lt: 10 }];

      // value must be greater than or equal to 10 or less than 5 [sint64.gte_lt_exclusive]
      sint64 another_value = 3 [(buf.validate.field).sint64 = { gte: 10, lt: 5 }];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`not_in` requires the field value to not be equal to any of the specified
        values. If the field value is one of the specified values, an error
        message is generated.

        ```proto
        message MySInt64 {
          // value must not be in list [1, 2, 3]
          sint64 value = 1 [(buf.validate.field).sint64 = { not_in: [1, 2, 3] }];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MySInt64 {
          sint64 value = 1 [
            (buf.validate.field).sint64.example = 1,
            (buf.validate.field).sint64.example = -10
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.int | None = ...,
        lt: builtins.int | None = ...,
        lte: builtins.int | None = ...,
        gt: builtins.int | None = ...,
        gte: builtins.int | None = ...,
        not_in: collections.abc.Iterable[builtins.int] | None = ...,
        example: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___SInt64Rules = SInt64Rules

@typing.final
class Fixed32Rules(google.protobuf.message.Message):
    """Fixed32Rules describes the rules applied to `fixed32` values."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.int
    """`const` requires the field value to exactly match the specified value.
    If the field value doesn't match, an error message is generated.

    ```proto
    message MyFixed32 {
      // value must equal 42
      fixed32 value = 1 [(buf.validate.field).fixed32.const = 42];
    }
    ```
    """
    lt: builtins.int
    """`lt` requires the field value to be less than the specified value (field <
    value). If the field value is equal to or greater than the specified value,
    an error message is generated.

    ```proto
    message MyFixed32 {
      // value must be less than 10
      fixed32 value = 1 [(buf.validate.field).fixed32.lt = 10];
    }
    ```
    """
    lte: builtins.int
    """`lte` requires the field value to be less than or equal to the specified
    value (field <= value). If the field value is greater than the specified
    value, an error message is generated.

    ```proto
    message MyFixed32 {
      // value must be less than or equal to 10
      fixed32 value = 1 [(buf.validate.field).fixed32.lte = 10];
    }
    ```
    """
    gt: builtins.int
    """`gt` requires the field value to be greater than the specified value
    (exclusive). If the value of `gt` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyFixed32 {
      // value must be greater than 5 [fixed32.gt]
      fixed32 value = 1 [(buf.validate.field).fixed32.gt = 5];

      // value must be greater than 5 and less than 10 [fixed32.gt_lt]
      fixed32 other_value = 2 [(buf.validate.field).fixed32 = { gt: 5, lt: 10 }];

      // value must be greater than 10 or less than 5 [fixed32.gt_lt_exclusive]
      fixed32 another_value = 3 [(buf.validate.field).fixed32 = { gt: 10, lt: 5 }];
    }
    ```
    """
    gte: builtins.int
    """`gte` requires the field value to be greater than or equal to the specified
    value (exclusive). If the value of `gte` is larger than a specified `lt`
    or `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyFixed32 {
      // value must be greater than or equal to 5 [fixed32.gte]
      fixed32 value = 1 [(buf.validate.field).fixed32.gte = 5];

      // value must be greater than or equal to 5 and less than 10 [fixed32.gte_lt]
      fixed32 other_value = 2 [(buf.validate.field).fixed32 = { gte: 5, lt: 10 }];

      // value must be greater than or equal to 10 or less than 5 [fixed32.gte_lt_exclusive]
      fixed32 another_value = 3 [(buf.validate.field).fixed32 = { gte: 10, lt: 5 }];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`not_in` requires the field value to not be equal to any of the specified
        values. If the field value is one of the specified values, an error
        message is generated.

        ```proto
        message MyFixed32 {
          // value must not be in list [1, 2, 3]
          fixed32 value = 1 [(buf.validate.field).fixed32 = { not_in: [1, 2, 3] }];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyFixed32 {
          fixed32 value = 1 [
            (buf.validate.field).fixed32.example = 1,
            (buf.validate.field).fixed32.example = 2
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.int | None = ...,
        lt: builtins.int | None = ...,
        lte: builtins.int | None = ...,
        gt: builtins.int | None = ...,
        gte: builtins.int | None = ...,
        not_in: collections.abc.Iterable[builtins.int] | None = ...,
        example: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___Fixed32Rules = Fixed32Rules

@typing.final
class Fixed64Rules(google.protobuf.message.Message):
    """Fixed64Rules describes the rules applied to `fixed64` values."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.int
    """`const` requires the field value to exactly match the specified value. If
    the field value doesn't match, an error message is generated.

    ```proto
    message MyFixed64 {
      // value must equal 42
      fixed64 value = 1 [(buf.validate.field).fixed64.const = 42];
    }
    ```
    """
    lt: builtins.int
    """`lt` requires the field value to be less than the specified value (field <
    value). If the field value is equal to or greater than the specified value,
    an error message is generated.

    ```proto
    message MyFixed64 {
      // value must be less than 10
      fixed64 value = 1 [(buf.validate.field).fixed64.lt = 10];
    }
    ```
    """
    lte: builtins.int
    """`lte` requires the field value to be less than or equal to the specified
    value (field <= value). If the field value is greater than the specified
    value, an error message is generated.

    ```proto
    message MyFixed64 {
      // value must be less than or equal to 10
      fixed64 value = 1 [(buf.validate.field).fixed64.lte = 10];
    }
    ```
    """
    gt: builtins.int
    """`gt` requires the field value to be greater than the specified value
    (exclusive). If the value of `gt` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyFixed64 {
      // value must be greater than 5 [fixed64.gt]
      fixed64 value = 1 [(buf.validate.field).fixed64.gt = 5];

      // value must be greater than 5 and less than 10 [fixed64.gt_lt]
      fixed64 other_value = 2 [(buf.validate.field).fixed64 = { gt: 5, lt: 10 }];

      // value must be greater than 10 or less than 5 [fixed64.gt_lt_exclusive]
      fixed64 another_value = 3 [(buf.validate.field).fixed64 = { gt: 10, lt: 5 }];
    }
    ```
    """
    gte: builtins.int
    """`gte` requires the field value to be greater than or equal to the specified
    value (exclusive). If the value of `gte` is larger than a specified `lt`
    or `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MyFixed64 {
      // value must be greater than or equal to 5 [fixed64.gte]
      fixed64 value = 1 [(buf.validate.field).fixed64.gte = 5];

      // value must be greater than or equal to 5 and less than 10 [fixed64.gte_lt]
      fixed64 other_value = 2 [(buf.validate.field).fixed64 = { gte: 5, lt: 10 }];

      // value must be greater than or equal to 10 or less than 5 [fixed64.gte_lt_exclusive]
      fixed64 another_value = 3 [(buf.validate.field).fixed64 = { gte: 10, lt: 5 }];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`not_in` requires the field value to not be equal to any of the specified
        values. If the field value is one of the specified values, an error
        message is generated.

        ```proto
        message MyFixed64 {
          // value must not be in list [1, 2, 3]
          fixed64 value = 1 [(buf.validate.field).fixed64 = { not_in: [1, 2, 3] }];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyFixed64 {
          fixed64 value = 1 [
            (buf.validate.field).fixed64.example = 1,
            (buf.validate.field).fixed64.example = 2
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.int | None = ...,
        lt: builtins.int | None = ...,
        lte: builtins.int | None = ...,
        gt: builtins.int | None = ...,
        gte: builtins.int | None = ...,
        not_in: collections.abc.Iterable[builtins.int] | None = ...,
        example: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___Fixed64Rules = Fixed64Rules

@typing.final
class SFixed32Rules(google.protobuf.message.Message):
    """SFixed32Rules describes the rules applied to `fixed32` values."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.int
    """`const` requires the field value to exactly match the specified value. If
    the field value doesn't match, an error message is generated.

    ```proto
    message MySFixed32 {
      // value must equal 42
      sfixed32 value = 1 [(buf.validate.field).sfixed32.const = 42];
    }
    ```
    """
    lt: builtins.int
    """`lt` requires the field value to be less than the specified value (field <
    value). If the field value is equal to or greater than the specified value,
    an error message is generated.

    ```proto
    message MySFixed32 {
      // value must be less than 10
      sfixed32 value = 1 [(buf.validate.field).sfixed32.lt = 10];
    }
    ```
    """
    lte: builtins.int
    """`lte` requires the field value to be less than or equal to the specified
    value (field <= value). If the field value is greater than the specified
    value, an error message is generated.

    ```proto
    message MySFixed32 {
      // value must be less than or equal to 10
      sfixed32 value = 1 [(buf.validate.field).sfixed32.lte = 10];
    }
    ```
    """
    gt: builtins.int
    """`gt` requires the field value to be greater than the specified value
    (exclusive). If the value of `gt` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MySFixed32 {
      // value must be greater than 5 [sfixed32.gt]
      sfixed32 value = 1 [(buf.validate.field).sfixed32.gt = 5];

      // value must be greater than 5 and less than 10 [sfixed32.gt_lt]
      sfixed32 other_value = 2 [(buf.validate.field).sfixed32 = { gt: 5, lt: 10 }];

      // value must be greater than 10 or less than 5 [sfixed32.gt_lt_exclusive]
      sfixed32 another_value = 3 [(buf.validate.field).sfixed32 = { gt: 10, lt: 5 }];
    }
    ```
    """
    gte: builtins.int
    """`gte` requires the field value to be greater than or equal to the specified
    value (exclusive). If the value of `gte` is larger than a specified `lt`
    or `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MySFixed32 {
      // value must be greater than or equal to 5 [sfixed32.gte]
      sfixed32 value = 1 [(buf.validate.field).sfixed32.gte = 5];

      // value must be greater than or equal to 5 and less than 10 [sfixed32.gte_lt]
      sfixed32 other_value = 2 [(buf.validate.field).sfixed32 = { gte: 5, lt: 10 }];

      // value must be greater than or equal to 10 or less than 5 [sfixed32.gte_lt_exclusive]
      sfixed32 another_value = 3 [(buf.validate.field).sfixed32 = { gte: 10, lt: 5 }];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`not_in` requires the field value to not be equal to any of the specified
        values. If the field value is one of the specified values, an error
        message is generated.

        ```proto
        message MySFixed32 {
          // value must not be in list [1, 2, 3]
          sfixed32 value = 1 [(buf.validate.field).sfixed32 = { not_in: [1, 2, 3] }];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MySFixed32 {
          sfixed32 value = 1 [
            (buf.validate.field).sfixed32.example = 1,
            (buf.validate.field).sfixed32.example = 2
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.int | None = ...,
        lt: builtins.int | None = ...,
        lte: builtins.int | None = ...,
        gt: builtins.int | None = ...,
        gte: builtins.int | None = ...,
        not_in: collections.abc.Iterable[builtins.int] | None = ...,
        example: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___SFixed32Rules = SFixed32Rules

@typing.final
class SFixed64Rules(google.protobuf.message.Message):
    """SFixed64Rules describes the rules applied to `fixed64` values."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.int
    """`const` requires the field value to exactly match the specified value. If
    the field value doesn't match, an error message is generated.

    ```proto
    message MySFixed64 {
      // value must equal 42
      sfixed64 value = 1 [(buf.validate.field).sfixed64.const = 42];
    }
    ```
    """
    lt: builtins.int
    """`lt` requires the field value to be less than the specified value (field <
    value). If the field value is equal to or greater than the specified value,
    an error message is generated.

    ```proto
    message MySFixed64 {
      // value must be less than 10
      sfixed64 value = 1 [(buf.validate.field).sfixed64.lt = 10];
    }
    ```
    """
    lte: builtins.int
    """`lte` requires the field value to be less than or equal to the specified
    value (field <= value). If the field value is greater than the specified
    value, an error message is generated.

    ```proto
    message MySFixed64 {
      // value must be less than or equal to 10
      sfixed64 value = 1 [(buf.validate.field).sfixed64.lte = 10];
    }
    ```
    """
    gt: builtins.int
    """`gt` requires the field value to be greater than the specified value
    (exclusive). If the value of `gt` is larger than a specified `lt` or
    `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MySFixed64 {
      // value must be greater than 5 [sfixed64.gt]
      sfixed64 value = 1 [(buf.validate.field).sfixed64.gt = 5];

      // value must be greater than 5 and less than 10 [sfixed64.gt_lt]
      sfixed64 other_value = 2 [(buf.validate.field).sfixed64 = { gt: 5, lt: 10 }];

      // value must be greater than 10 or less than 5 [sfixed64.gt_lt_exclusive]
      sfixed64 another_value = 3 [(buf.validate.field).sfixed64 = { gt: 10, lt: 5 }];
    }
    ```
    """
    gte: builtins.int
    """`gte` requires the field value to be greater than or equal to the specified
    value (exclusive). If the value of `gte` is larger than a specified `lt`
    or `lte`, the range is reversed, and the field value must be outside the
    specified range. If the field value doesn't meet the required conditions,
    an error message is generated.

    ```proto
    message MySFixed64 {
      // value must be greater than or equal to 5 [sfixed64.gte]
      sfixed64 value = 1 [(buf.validate.field).sfixed64.gte = 5];

      // value must be greater than or equal to 5 and less than 10 [sfixed64.gte_lt]
      sfixed64 other_value = 2 [(buf.validate.field).sfixed64 = { gte: 5, lt: 10 }];

      // value must be greater than or equal to 10 or less than 5 [sfixed64.gte_lt_exclusive]
      sfixed64 another_value = 3 [(buf.validate.field).sfixed64 = { gte: 10, lt: 5 }];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`not_in` requires the field value to not be equal to any of the specified
        values. If the field value is one of the specified values, an error
        message is generated.

        ```proto
        message MySFixed64 {
          // value must not be in list [1, 2, 3]
          sfixed64 value = 1 [(buf.validate.field).sfixed64 = { not_in: [1, 2, 3] }];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MySFixed64 {
          sfixed64 value = 1 [
            (buf.validate.field).sfixed64.example = 1,
            (buf.validate.field).sfixed64.example = 2
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.int | None = ...,
        lt: builtins.int | None = ...,
        lte: builtins.int | None = ...,
        gt: builtins.int | None = ...,
        gte: builtins.int | None = ...,
        not_in: collections.abc.Iterable[builtins.int] | None = ...,
        example: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___SFixed64Rules = SFixed64Rules

@typing.final
class BoolRules(google.protobuf.message.Message):
    """BoolRules describes the rules applied to `bool` values. These rules
    may also be applied to the `google.protobuf.BoolValue` Well-Known-Type.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.bool
    """`const` requires the field value to exactly match the specified boolean value.
    If the field value doesn't match, an error message is generated.

    ```proto
    message MyBool {
      // value must equal true
      bool value = 1 [(buf.validate.field).bool.const = true];
    }
    ```
    """
    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bool]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyBool {
          bool value = 1 [
            (buf.validate.field).bool.example = 1,
            (buf.validate.field).bool.example = 2
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.bool | None = ...,
        example: collections.abc.Iterable[builtins.bool] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example"]) -> None: ...

global___BoolRules = BoolRules

@typing.final
class StringRules(google.protobuf.message.Message):
    """StringRules describes the rules applied to `string` values These
    rules may also be applied to the `google.protobuf.StringValue` Well-Known-Type.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LEN_FIELD_NUMBER: builtins.int
    MIN_LEN_FIELD_NUMBER: builtins.int
    MAX_LEN_FIELD_NUMBER: builtins.int
    LEN_BYTES_FIELD_NUMBER: builtins.int
    MIN_BYTES_FIELD_NUMBER: builtins.int
    MAX_BYTES_FIELD_NUMBER: builtins.int
    PATTERN_FIELD_NUMBER: builtins.int
    PREFIX_FIELD_NUMBER: builtins.int
    SUFFIX_FIELD_NUMBER: builtins.int
    CONTAINS_FIELD_NUMBER: builtins.int
    NOT_CONTAINS_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EMAIL_FIELD_NUMBER: builtins.int
    HOSTNAME_FIELD_NUMBER: builtins.int
    IP_FIELD_NUMBER: builtins.int
    IPV4_FIELD_NUMBER: builtins.int
    IPV6_FIELD_NUMBER: builtins.int
    URI_FIELD_NUMBER: builtins.int
    URI_REF_FIELD_NUMBER: builtins.int
    ADDRESS_FIELD_NUMBER: builtins.int
    UUID_FIELD_NUMBER: builtins.int
    TUUID_FIELD_NUMBER: builtins.int
    IP_WITH_PREFIXLEN_FIELD_NUMBER: builtins.int
    IPV4_WITH_PREFIXLEN_FIELD_NUMBER: builtins.int
    IPV6_WITH_PREFIXLEN_FIELD_NUMBER: builtins.int
    IP_PREFIX_FIELD_NUMBER: builtins.int
    IPV4_PREFIX_FIELD_NUMBER: builtins.int
    IPV6_PREFIX_FIELD_NUMBER: builtins.int
    HOST_AND_PORT_FIELD_NUMBER: builtins.int
    WELL_KNOWN_REGEX_FIELD_NUMBER: builtins.int
    STRICT_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.str
    """`const` requires the field value to exactly match the specified value. If
    the field value doesn't match, an error message is generated.

    ```proto
    message MyString {
      // value must equal `hello`
      string value = 1 [(buf.validate.field).string.const = "hello"];
    }
    ```
    """
    len: builtins.int
    """`len` dictates that the field value must have the specified
    number of characters (Unicode code points), which may differ from the number
    of bytes in the string. If the field value does not meet the specified
    length, an error message will be generated.

    ```proto
    message MyString {
      // value length must be 5 characters
      string value = 1 [(buf.validate.field).string.len = 5];
    }
    ```
    """
    min_len: builtins.int
    """`min_len` specifies that the field value must have at least the specified
    number of characters (Unicode code points), which may differ from the number
    of bytes in the string. If the field value contains fewer characters, an error
    message will be generated.

    ```proto
    message MyString {
      // value length must be at least 3 characters
      string value = 1 [(buf.validate.field).string.min_len = 3];
    }
    ```
    """
    max_len: builtins.int
    """`max_len` specifies that the field value must have no more than the specified
    number of characters (Unicode code points), which may differ from the
    number of bytes in the string. If the field value contains more characters,
    an error message will be generated.

    ```proto
    message MyString {
      // value length must be at most 10 characters
      string value = 1 [(buf.validate.field).string.max_len = 10];
    }
    ```
    """
    len_bytes: builtins.int
    """`len_bytes` dictates that the field value must have the specified number of
    bytes. If the field value does not match the specified length in bytes,
    an error message will be generated.

    ```proto
    message MyString {
      // value length must be 6 bytes
      string value = 1 [(buf.validate.field).string.len_bytes = 6];
    }
    ```
    """
    min_bytes: builtins.int
    """`min_bytes` specifies that the field value must have at least the specified
    number of bytes. If the field value contains fewer bytes, an error message
    will be generated.

    ```proto
    message MyString {
      // value length must be at least 4 bytes
      string value = 1 [(buf.validate.field).string.min_bytes = 4];
    }

    ```
    """
    max_bytes: builtins.int
    """`max_bytes` specifies that the field value must have no more than the
    specified number of bytes. If the field value contains more bytes, an
    error message will be generated.

    ```proto
    message MyString {
      // value length must be at most 8 bytes
      string value = 1 [(buf.validate.field).string.max_bytes = 8];
    }
    ```
    """
    pattern: builtins.str
    """`pattern` specifies that the field value must match the specified
    regular expression (RE2 syntax), with the expression provided without any
    delimiters. If the field value doesn't match the regular expression, an
    error message will be generated.

    ```proto
    message MyString {
      // value does not match regex pattern `^[a-zA-Z]//$`
      string value = 1 [(buf.validate.field).string.pattern = "^[a-zA-Z]//$"];
    }
    ```
    """
    prefix: builtins.str
    """`prefix` specifies that the field value must have the
    specified substring at the beginning of the string. If the field value
    doesn't start with the specified prefix, an error message will be
    generated.

    ```proto
    message MyString {
      // value does not have prefix `pre`
      string value = 1 [(buf.validate.field).string.prefix = "pre"];
    }
    ```
    """
    suffix: builtins.str
    """`suffix` specifies that the field value must have the
    specified substring at the end of the string. If the field value doesn't
    end with the specified suffix, an error message will be generated.

    ```proto
    message MyString {
      // value does not have suffix `post`
      string value = 1 [(buf.validate.field).string.suffix = "post"];
    }
    ```
    """
    contains: builtins.str
    """`contains` specifies that the field value must have the
    specified substring anywhere in the string. If the field value doesn't
    contain the specified substring, an error message will be generated.

    ```proto
    message MyString {
      // value does not contain substring `inside`.
      string value = 1 [(buf.validate.field).string.contains = "inside"];
    }
    ```
    """
    not_contains: builtins.str
    """`not_contains` specifies that the field value must not have the
    specified substring anywhere in the string. If the field value contains
    the specified substring, an error message will be generated.

    ```proto
    message MyString {
      // value contains substring `inside`.
      string value = 1 [(buf.validate.field).string.not_contains = "inside"];
    }
    ```
    """
    email: builtins.bool
    """`email` specifies that the field value must be a valid email address, for
    example "foo@example.com".

    Conforms to the definition for a valid email address from the [HTML standard](https://html.spec.whatwg.org/multipage/input.html#valid-e-mail-address).
    Note that this standard willfully deviates from [RFC 5322](https://datatracker.ietf.org/doc/html/rfc5322),
    which allows many unexpected forms of email addresses and will easily match
    a typographical error.

    If the field value isn't a valid email address, an error message will be generated.

    ```proto
    message MyString {
      // value must be a valid email address
      string value = 1 [(buf.validate.field).string.email = true];
    }
    ```
    """
    hostname: builtins.bool
    """`hostname` specifies that the field value must be a valid hostname, for
    example "foo.example.com".

    A valid hostname follows the rules below:
    - The name consists of one or more labels, separated by a dot (".").
    - Each label can be 1 to 63 alphanumeric characters.
    - A label can contain hyphens ("-"), but must not start or end with a hyphen.
    - The right-most label must not be digits only.
    - The name can have a trailing dot—for example, "foo.example.com.".
    - The name can be 253 characters at most, excluding the optional trailing dot.

    If the field value isn't a valid hostname, an error message will be generated.

    ```proto
    message MyString {
      // value must be a valid hostname
      string value = 1 [(buf.validate.field).string.hostname = true];
    }
    ```
    """
    ip: builtins.bool
    """`ip` specifies that the field value must be a valid IP (v4 or v6) address.

    IPv4 addresses are expected in the dotted decimal format—for example, "192.168.5.21".
    IPv6 addresses are expected in their text representation—for example, "::1",
    or "2001:0DB8:ABCD:0012::0".

    Both formats are well-defined in the internet standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986).
    Zone identifiers for IPv6 addresses (for example, "fe80::a%en1") are supported.

    If the field value isn't a valid IP address, an error message will be
    generated.

    ```proto
    message MyString {
      // value must be a valid IP address
      string value = 1 [(buf.validate.field).string.ip = true];
    }
    ```
    """
    ipv4: builtins.bool
    """`ipv4` specifies that the field value must be a valid IPv4 address—for
    example "192.168.5.21". If the field value isn't a valid IPv4 address, an
    error message will be generated.

    ```proto
    message MyString {
      // value must be a valid IPv4 address
      string value = 1 [(buf.validate.field).string.ipv4 = true];
    }
    ```
    """
    ipv6: builtins.bool
    """`ipv6` specifies that the field value must be a valid IPv6 address—for
    example "::1", or "d7a:115c:a1e0:ab12:4843:cd96:626b:430b". If the field
    value is not a valid IPv6 address, an error message will be generated.

    ```proto
    message MyString {
      // value must be a valid IPv6 address
      string value = 1 [(buf.validate.field).string.ipv6 = true];
    }
    ```
    """
    uri: builtins.bool
    """`uri` specifies that the field value must be a valid URI, for example
    "https://example.com/foo/bar?baz=quux#frag".

    URI is defined in the internet standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986).
    Zone Identifiers in IPv6 address literals are supported ([RFC 6874](https://datatracker.ietf.org/doc/html/rfc6874)).

    If the field value isn't a valid URI, an error message will be generated.

    ```proto
    message MyString {
      // value must be a valid URI
      string value = 1 [(buf.validate.field).string.uri = true];
    }
    ```
    """
    uri_ref: builtins.bool
    """`uri_ref` specifies that the field value must be a valid URI Reference—either
    a URI such as "https://example.com/foo/bar?baz=quux#frag", or a Relative
    Reference such as "./foo/bar?query".

    URI, URI Reference, and Relative Reference are defined in the internet
    standard [RFC 3986](https://datatracker.ietf.org/doc/html/rfc3986). Zone
    Identifiers in IPv6 address literals are supported ([RFC 6874](https://datatracker.ietf.org/doc/html/rfc6874)).

    If the field value isn't a valid URI Reference, an error message will be
    generated.

    ```proto
    message MyString {
      // value must be a valid URI Reference
      string value = 1 [(buf.validate.field).string.uri_ref = true];
    }
    ```
    """
    address: builtins.bool
    """`address` specifies that the field value must be either a valid hostname
    (for example, "example.com"), or a valid IP (v4 or v6) address (for example,
    "192.168.0.1", or "::1"). If the field value isn't a valid hostname or IP,
    an error message will be generated.

    ```proto
    message MyString {
      // value must be a valid hostname, or ip address
      string value = 1 [(buf.validate.field).string.address = true];
    }
    ```
    """
    uuid: builtins.bool
    """`uuid` specifies that the field value must be a valid UUID as defined by
    [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122#section-4.1.2). If the
    field value isn't a valid UUID, an error message will be generated.

    ```proto
    message MyString {
      // value must be a valid UUID
      string value = 1 [(buf.validate.field).string.uuid = true];
    }
    ```
    """
    tuuid: builtins.bool
    """`tuuid` (trimmed UUID) specifies that the field value must be a valid UUID as
    defined by [RFC 4122](https://datatracker.ietf.org/doc/html/rfc4122#section-4.1.2) with all dashes
    omitted. If the field value isn't a valid UUID without dashes, an error message
    will be generated.

    ```proto
    message MyString {
      // value must be a valid trimmed UUID
      string value = 1 [(buf.validate.field).string.tuuid = true];
    }
    ```
    """
    ip_with_prefixlen: builtins.bool
    """`ip_with_prefixlen` specifies that the field value must be a valid IP
    (v4 or v6) address with prefix length—for example, "192.168.5.21/16" or
    "2001:0DB8:ABCD:0012::F1/64". If the field value isn't a valid IP with
    prefix length, an error message will be generated.

    ```proto
    message MyString {
      // value must be a valid IP with prefix length
       string value = 1 [(buf.validate.field).string.ip_with_prefixlen = true];
    }
    ```
    """
    ipv4_with_prefixlen: builtins.bool
    """`ipv4_with_prefixlen` specifies that the field value must be a valid
    IPv4 address with prefix length—for example, "192.168.5.21/16". If the
    field value isn't a valid IPv4 address with prefix length, an error
    message will be generated.

    ```proto
    message MyString {
      // value must be a valid IPv4 address with prefix length
       string value = 1 [(buf.validate.field).string.ipv4_with_prefixlen = true];
    }
    ```
    """
    ipv6_with_prefixlen: builtins.bool
    """`ipv6_with_prefixlen` specifies that the field value must be a valid
    IPv6 address with prefix length—for example, "2001:0DB8:ABCD:0012::F1/64".
    If the field value is not a valid IPv6 address with prefix length,
    an error message will be generated.

    ```proto
    message MyString {
      // value must be a valid IPv6 address prefix length
       string value = 1 [(buf.validate.field).string.ipv6_with_prefixlen = true];
    }
    ```
    """
    ip_prefix: builtins.bool
    """`ip_prefix` specifies that the field value must be a valid IP (v4 or v6)
    prefix—for example, "192.168.0.0/16" or "2001:0DB8:ABCD:0012::0/64".

    The prefix must have all zeros for the unmasked bits. For example,
    "2001:0DB8:ABCD:0012::0/64" designates the left-most 64 bits for the
    prefix, and the remaining 64 bits must be zero.

    If the field value isn't a valid IP prefix, an error message will be
    generated.

    ```proto
    message MyString {
      // value must be a valid IP prefix
       string value = 1 [(buf.validate.field).string.ip_prefix = true];
    }
    ```
    """
    ipv4_prefix: builtins.bool
    """`ipv4_prefix` specifies that the field value must be a valid IPv4
    prefix, for example "192.168.0.0/16".

    The prefix must have all zeros for the unmasked bits. For example,
    "192.168.0.0/16" designates the left-most 16 bits for the prefix,
    and the remaining 16 bits must be zero.

    If the field value isn't a valid IPv4 prefix, an error message
    will be generated.

    ```proto
    message MyString {
      // value must be a valid IPv4 prefix
       string value = 1 [(buf.validate.field).string.ipv4_prefix = true];
    }
    ```
    """
    ipv6_prefix: builtins.bool
    """`ipv6_prefix` specifies that the field value must be a valid IPv6 prefix—for
    example, "2001:0DB8:ABCD:0012::0/64".

    The prefix must have all zeros for the unmasked bits. For example,
    "2001:0DB8:ABCD:0012::0/64" designates the left-most 64 bits for the
    prefix, and the remaining 64 bits must be zero.

    If the field value is not a valid IPv6 prefix, an error message will be
    generated.

    ```proto
    message MyString {
      // value must be a valid IPv6 prefix
       string value = 1 [(buf.validate.field).string.ipv6_prefix = true];
    }
    ```
    """
    host_and_port: builtins.bool
    """`host_and_port` specifies that the field value must be valid host/port
    pair—for example, "example.com:8080".

    The host can be one of:
    - An IPv4 address in dotted decimal format—for example, "192.168.5.21".
    - An IPv6 address enclosed in square brackets—for example, "[2001:0DB8:ABCD:0012::F1]".
    - A hostname—for example, "example.com".

    The port is separated by a colon. It must be non-empty, with a decimal number
    in the range of 0-65535, inclusive.
    """
    well_known_regex: global___KnownRegex.ValueType
    """`well_known_regex` specifies a common well-known pattern
    defined as a regex. If the field value doesn't match the well-known
    regex, an error message will be generated.

    ```proto
    message MyString {
      // value must be a valid HTTP header value
      string value = 1 [(buf.validate.field).string.well_known_regex = KNOWN_REGEX_HTTP_HEADER_VALUE];
    }
    ```

    #### KnownRegex

    `well_known_regex` contains some well-known patterns.

    | Name                          | Number | Description                               |
    |-------------------------------|--------|-------------------------------------------|
    | KNOWN_REGEX_UNSPECIFIED       | 0      |                                           |
    | KNOWN_REGEX_HTTP_HEADER_NAME  | 1      | HTTP header name as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2)  |
    | KNOWN_REGEX_HTTP_HEADER_VALUE | 2      | HTTP header value as defined by [RFC 7230](https://datatracker.ietf.org/doc/html/rfc7230#section-3.2.4) |
    """
    strict: builtins.bool
    """This applies to regexes `HTTP_HEADER_NAME` and `HTTP_HEADER_VALUE` to
    enable strict header validation. By default, this is true, and HTTP header
    validations are [RFC-compliant](https://datatracker.ietf.org/doc/html/rfc7230#section-3). Setting to false will enable looser
    validations that only disallow `\\r\\n\\0` characters, which can be used to
    bypass header matching rules.

    ```proto
    message MyString {
      // The field `value` must have be a valid HTTP headers, but not enforced with strict rules.
      string value = 1 [(buf.validate.field).string.strict = false];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """`not_in` specifies that the field value cannot be equal to any
        of the specified values. If the field value is one of the specified values,
        an error message will be generated.
        ```proto
        message MyString {
          // value must not be in list ["orange", "grape"]
          string value = 1 [(buf.validate.field).string.not_in = "orange", (buf.validate.field).string.not_in = "grape"];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyString {
          string value = 1 [
            (buf.validate.field).string.example = "hello",
            (buf.validate.field).string.example = "world"
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.str | None = ...,
        len: builtins.int | None = ...,
        min_len: builtins.int | None = ...,
        max_len: builtins.int | None = ...,
        len_bytes: builtins.int | None = ...,
        min_bytes: builtins.int | None = ...,
        max_bytes: builtins.int | None = ...,
        pattern: builtins.str | None = ...,
        prefix: builtins.str | None = ...,
        suffix: builtins.str | None = ...,
        contains: builtins.str | None = ...,
        not_contains: builtins.str | None = ...,
        not_in: collections.abc.Iterable[builtins.str] | None = ...,
        email: builtins.bool | None = ...,
        hostname: builtins.bool | None = ...,
        ip: builtins.bool | None = ...,
        ipv4: builtins.bool | None = ...,
        ipv6: builtins.bool | None = ...,
        uri: builtins.bool | None = ...,
        uri_ref: builtins.bool | None = ...,
        address: builtins.bool | None = ...,
        uuid: builtins.bool | None = ...,
        tuuid: builtins.bool | None = ...,
        ip_with_prefixlen: builtins.bool | None = ...,
        ipv4_with_prefixlen: builtins.bool | None = ...,
        ipv6_with_prefixlen: builtins.bool | None = ...,
        ip_prefix: builtins.bool | None = ...,
        ipv4_prefix: builtins.bool | None = ...,
        ipv6_prefix: builtins.bool | None = ...,
        host_and_port: builtins.bool | None = ...,
        well_known_regex: global___KnownRegex.ValueType | None = ...,
        strict: builtins.bool | None = ...,
        example: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["address", b"address", "const", b"const", "contains", b"contains", "email", b"email", "host_and_port", b"host_and_port", "hostname", b"hostname", "ip", b"ip", "ip_prefix", b"ip_prefix", "ip_with_prefixlen", b"ip_with_prefixlen", "ipv4", b"ipv4", "ipv4_prefix", b"ipv4_prefix", "ipv4_with_prefixlen", b"ipv4_with_prefixlen", "ipv6", b"ipv6", "ipv6_prefix", b"ipv6_prefix", "ipv6_with_prefixlen", b"ipv6_with_prefixlen", "len", b"len", "len_bytes", b"len_bytes", "max_bytes", b"max_bytes", "max_len", b"max_len", "min_bytes", b"min_bytes", "min_len", b"min_len", "not_contains", b"not_contains", "pattern", b"pattern", "prefix", b"prefix", "strict", b"strict", "suffix", b"suffix", "tuuid", b"tuuid", "uri", b"uri", "uri_ref", b"uri_ref", "uuid", b"uuid", "well_known", b"well_known", "well_known_regex", b"well_known_regex"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["address", b"address", "const", b"const", "contains", b"contains", "email", b"email", "example", b"example", "host_and_port", b"host_and_port", "hostname", b"hostname", "in", b"in", "ip", b"ip", "ip_prefix", b"ip_prefix", "ip_with_prefixlen", b"ip_with_prefixlen", "ipv4", b"ipv4", "ipv4_prefix", b"ipv4_prefix", "ipv4_with_prefixlen", b"ipv4_with_prefixlen", "ipv6", b"ipv6", "ipv6_prefix", b"ipv6_prefix", "ipv6_with_prefixlen", b"ipv6_with_prefixlen", "len", b"len", "len_bytes", b"len_bytes", "max_bytes", b"max_bytes", "max_len", b"max_len", "min_bytes", b"min_bytes", "min_len", b"min_len", "not_contains", b"not_contains", "not_in", b"not_in", "pattern", b"pattern", "prefix", b"prefix", "strict", b"strict", "suffix", b"suffix", "tuuid", b"tuuid", "uri", b"uri", "uri_ref", b"uri_ref", "uuid", b"uuid", "well_known", b"well_known", "well_known_regex", b"well_known_regex"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["well_known", b"well_known"]) -> typing.Literal["email", "hostname", "ip", "ipv4", "ipv6", "uri", "uri_ref", "address", "uuid", "tuuid", "ip_with_prefixlen", "ipv4_with_prefixlen", "ipv6_with_prefixlen", "ip_prefix", "ipv4_prefix", "ipv6_prefix", "host_and_port", "well_known_regex"] | None: ...

global___StringRules = StringRules

@typing.final
class BytesRules(google.protobuf.message.Message):
    """BytesRules describe the rules applied to `bytes` values. These rules
    may also be applied to the `google.protobuf.BytesValue` Well-Known-Type.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LEN_FIELD_NUMBER: builtins.int
    MIN_LEN_FIELD_NUMBER: builtins.int
    MAX_LEN_FIELD_NUMBER: builtins.int
    PATTERN_FIELD_NUMBER: builtins.int
    PREFIX_FIELD_NUMBER: builtins.int
    SUFFIX_FIELD_NUMBER: builtins.int
    CONTAINS_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    IP_FIELD_NUMBER: builtins.int
    IPV4_FIELD_NUMBER: builtins.int
    IPV6_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.bytes
    """`const` requires the field value to exactly match the specified bytes
    value. If the field value doesn't match, an error message is generated.

    ```proto
    message MyBytes {
      // value must be "\\x01\\x02\\x03\\x04"
      bytes value = 1 [(buf.validate.field).bytes.const = "\\x01\\x02\\x03\\x04"];
    }
    ```
    """
    len: builtins.int
    """`len` requires the field value to have the specified length in bytes.
    If the field value doesn't match, an error message is generated.

    ```proto
    message MyBytes {
      // value length must be 4 bytes.
      optional bytes value = 1 [(buf.validate.field).bytes.len = 4];
    }
    ```
    """
    min_len: builtins.int
    """`min_len` requires the field value to have at least the specified minimum
    length in bytes.
    If the field value doesn't meet the requirement, an error message is generated.

    ```proto
    message MyBytes {
      // value length must be at least 2 bytes.
      optional bytes value = 1 [(buf.validate.field).bytes.min_len = 2];
    }
    ```
    """
    max_len: builtins.int
    """`max_len` requires the field value to have at most the specified maximum
    length in bytes.
    If the field value exceeds the requirement, an error message is generated.

    ```proto
    message MyBytes {
      // value must be at most 6 bytes.
      optional bytes value = 1 [(buf.validate.field).bytes.max_len = 6];
    }
    ```
    """
    pattern: builtins.str
    """`pattern` requires the field value to match the specified regular
    expression ([RE2 syntax](https://github.com/google/re2/wiki/Syntax)).
    The value of the field must be valid UTF-8 or validation will fail with a
    runtime error.
    If the field value doesn't match the pattern, an error message is generated.

    ```proto
    message MyBytes {
      // value must match regex pattern "^[a-zA-Z0-9]+$".
      optional bytes value = 1 [(buf.validate.field).bytes.pattern = "^[a-zA-Z0-9]+$"];
    }
    ```
    """
    prefix: builtins.bytes
    """`prefix` requires the field value to have the specified bytes at the
    beginning of the string.
    If the field value doesn't meet the requirement, an error message is generated.

    ```proto
    message MyBytes {
      // value does not have prefix \\x01\\x02
      optional bytes value = 1 [(buf.validate.field).bytes.prefix = "\\x01\\x02"];
    }
    ```
    """
    suffix: builtins.bytes
    """`suffix` requires the field value to have the specified bytes at the end
    of the string.
    If the field value doesn't meet the requirement, an error message is generated.

    ```proto
    message MyBytes {
      // value does not have suffix \\x03\\x04
      optional bytes value = 1 [(buf.validate.field).bytes.suffix = "\\x03\\x04"];
    }
    ```
    """
    contains: builtins.bytes
    """`contains` requires the field value to have the specified bytes anywhere in
    the string.
    If the field value doesn't meet the requirement, an error message is generated.

    ```protobuf
    message MyBytes {
      // value does not contain \\x02\\x03
      optional bytes value = 1 [(buf.validate.field).bytes.contains = "\\x02\\x03"];
    }
    ```
    """
    ip: builtins.bool
    """`ip` ensures that the field `value` is a valid IP address (v4 or v6) in byte format.
    If the field value doesn't meet this rule, an error message is generated.

    ```proto
    message MyBytes {
      // value must be a valid IP address
      optional bytes value = 1 [(buf.validate.field).bytes.ip = true];
    }
    ```
    """
    ipv4: builtins.bool
    """`ipv4` ensures that the field `value` is a valid IPv4 address in byte format.
    If the field value doesn't meet this rule, an error message is generated.

    ```proto
    message MyBytes {
      // value must be a valid IPv4 address
      optional bytes value = 1 [(buf.validate.field).bytes.ipv4 = true];
    }
    ```
    """
    ipv6: builtins.bool
    """`ipv6` ensures that the field `value` is a valid IPv6 address in byte format.
    If the field value doesn't meet this rule, an error message is generated.
    ```proto
    message MyBytes {
      // value must be a valid IPv6 address
      optional bytes value = 1 [(buf.validate.field).bytes.ipv6 = true];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]:
        """`not_in` requires the field value to be not equal to any of the specified
        values.
        If the field value matches any of the specified values, an error message is
        generated.

        ```proto
        message MyBytes {
          // value must not in ["\\x01\\x02", "\\x02\\x03", "\\x03\\x04"]
          optional bytes value = 1 [(buf.validate.field).bytes.not_in = {"\\x01\\x02", "\\x02\\x03", "\\x03\\x04"}];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.bytes]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyBytes {
          bytes value = 1 [
            (buf.validate.field).bytes.example = "\\x01\\x02",
            (buf.validate.field).bytes.example = "\\x02\\x03"
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.bytes | None = ...,
        len: builtins.int | None = ...,
        min_len: builtins.int | None = ...,
        max_len: builtins.int | None = ...,
        pattern: builtins.str | None = ...,
        prefix: builtins.bytes | None = ...,
        suffix: builtins.bytes | None = ...,
        contains: builtins.bytes | None = ...,
        not_in: collections.abc.Iterable[builtins.bytes] | None = ...,
        ip: builtins.bool | None = ...,
        ipv4: builtins.bool | None = ...,
        ipv6: builtins.bool | None = ...,
        example: collections.abc.Iterable[builtins.bytes] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "contains", b"contains", "ip", b"ip", "ipv4", b"ipv4", "ipv6", b"ipv6", "len", b"len", "max_len", b"max_len", "min_len", b"min_len", "pattern", b"pattern", "prefix", b"prefix", "suffix", b"suffix", "well_known", b"well_known"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "contains", b"contains", "example", b"example", "in", b"in", "ip", b"ip", "ipv4", b"ipv4", "ipv6", b"ipv6", "len", b"len", "max_len", b"max_len", "min_len", b"min_len", "not_in", b"not_in", "pattern", b"pattern", "prefix", b"prefix", "suffix", b"suffix", "well_known", b"well_known"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["well_known", b"well_known"]) -> typing.Literal["ip", "ipv4", "ipv6"] | None: ...

global___BytesRules = BytesRules

@typing.final
class EnumRules(google.protobuf.message.Message):
    """EnumRules describe the rules applied to `enum` values."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    DEFINED_ONLY_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    const: builtins.int
    """`const` requires the field value to exactly match the specified enum value.
    If the field value doesn't match, an error message is generated.

    ```proto
    enum MyEnum {
      MY_ENUM_UNSPECIFIED = 0;
      MY_ENUM_VALUE1 = 1;
      MY_ENUM_VALUE2 = 2;
    }

    message MyMessage {
      // The field `value` must be exactly MY_ENUM_VALUE1.
      MyEnum value = 1 [(buf.validate.field).enum.const = 1];
    }
    ```
    """
    defined_only: builtins.bool
    """`defined_only` requires the field value to be one of the defined values for
    this enum, failing on any undefined value.

    ```proto
    enum MyEnum {
      MY_ENUM_UNSPECIFIED = 0;
      MY_ENUM_VALUE1 = 1;
      MY_ENUM_VALUE2 = 2;
    }

    message MyMessage {
      // The field `value` must be a defined value of MyEnum.
      MyEnum value = 1 [(buf.validate.field).enum.defined_only = true];
    }
    ```
    """
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`not_in` requires the field value to be not equal to any of the
        specified enum values. If the field value matches one of the specified
        values, an error message is generated.

        ```proto
        enum MyEnum {
          MY_ENUM_UNSPECIFIED = 0;
          MY_ENUM_VALUE1 = 1;
          MY_ENUM_VALUE2 = 2;
        }

        message MyMessage {
          // The field `value` must not be equal to any of the specified values.
          MyEnum value = 1 [(buf.validate.field).enum = { not_in: [1, 2]}];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        enum MyEnum {
          MY_ENUM_UNSPECIFIED = 0;
          MY_ENUM_VALUE1 = 1;
          MY_ENUM_VALUE2 = 2;
        }

        message MyMessage {
            (buf.validate.field).enum.example = 1,
            (buf.validate.field).enum.example = 2
        }
        ```
        """

    def __init__(
        self,
        *,
        const: builtins.int | None = ...,
        defined_only: builtins.bool | None = ...,
        not_in: collections.abc.Iterable[builtins.int] | None = ...,
        example: collections.abc.Iterable[builtins.int] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "defined_only", b"defined_only"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "defined_only", b"defined_only", "example", b"example", "in", b"in", "not_in", b"not_in"]) -> None: ...

global___EnumRules = EnumRules

@typing.final
class RepeatedRules(google.protobuf.message.Message):
    """RepeatedRules describe the rules applied to `repeated` values."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_ITEMS_FIELD_NUMBER: builtins.int
    MAX_ITEMS_FIELD_NUMBER: builtins.int
    UNIQUE_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int
    min_items: builtins.int
    """`min_items` requires that this field must contain at least the specified
    minimum number of items.

    Note that `min_items = 1` is equivalent to setting a field as `required`.

    ```proto
    message MyRepeated {
      // value must contain at least  2 items
      repeated string value = 1 [(buf.validate.field).repeated.min_items = 2];
    }
    ```
    """
    max_items: builtins.int
    """`max_items` denotes that this field must not exceed a
    certain number of items as the upper limit. If the field contains more
    items than specified, an error message will be generated, requiring the
    field to maintain no more than the specified number of items.

    ```proto
    message MyRepeated {
      // value must contain no more than 3 item(s)
      repeated string value = 1 [(buf.validate.field).repeated.max_items = 3];
    }
    ```
    """
    unique: builtins.bool
    """`unique` indicates that all elements in this field must
    be unique. This rule is strictly applicable to scalar and enum
    types, with message types not being supported.

    ```proto
    message MyRepeated {
      // repeated value must contain unique items
      repeated string value = 1 [(buf.validate.field).repeated.unique = true];
    }
    ```
    """
    @property
    def items(self) -> global___FieldRules:
        """`items` details the rules to be applied to each item
        in the field. Even for repeated message fields, validation is executed
        against each item unless `ignore` is specified.

        ```proto
        message MyRepeated {
          // The items in the field `value` must follow the specified rules.
          repeated string value = 1 [(buf.validate.field).repeated.items = {
            string: {
              min_len: 3
              max_len: 10
            }
          }];
        }
        ```

        Note that the `required` rule does not apply. Repeated items
        cannot be unset.
        """

    def __init__(
        self,
        *,
        min_items: builtins.int | None = ...,
        max_items: builtins.int | None = ...,
        unique: builtins.bool | None = ...,
        items: global___FieldRules | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["items", b"items", "max_items", b"max_items", "min_items", b"min_items", "unique", b"unique"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["items", b"items", "max_items", b"max_items", "min_items", b"min_items", "unique", b"unique"]) -> None: ...

global___RepeatedRules = RepeatedRules

@typing.final
class MapRules(google.protobuf.message.Message):
    """MapRules describe the rules applied to `map` values."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MIN_PAIRS_FIELD_NUMBER: builtins.int
    MAX_PAIRS_FIELD_NUMBER: builtins.int
    KEYS_FIELD_NUMBER: builtins.int
    VALUES_FIELD_NUMBER: builtins.int
    min_pairs: builtins.int
    """Specifies the minimum number of key-value pairs allowed. If the field has
    fewer key-value pairs than specified, an error message is generated.

    ```proto
    message MyMap {
      // The field `value` must have at least 2 key-value pairs.
      map<string, string> value = 1 [(buf.validate.field).map.min_pairs = 2];
    }
    ```
    """
    max_pairs: builtins.int
    """Specifies the maximum number of key-value pairs allowed. If the field has
    more key-value pairs than specified, an error message is generated.

    ```proto
    message MyMap {
      // The field `value` must have at most 3 key-value pairs.
      map<string, string> value = 1 [(buf.validate.field).map.max_pairs = 3];
    }
    ```
    """
    @property
    def keys(self) -> global___FieldRules:
        """Specifies the rules to be applied to each key in the field.

        ```proto
        message MyMap {
          // The keys in the field `value` must follow the specified rules.
          map<string, string> value = 1 [(buf.validate.field).map.keys = {
            string: {
              min_len: 3
              max_len: 10
            }
          }];
        }
        ```

        Note that the `required` rule does not apply. Map keys cannot be unset.
        """

    @property
    def values(self) -> global___FieldRules:
        """Specifies the rules to be applied to the value of each key in the
        field. Message values will still have their validations evaluated unless
        `ignore` is specified.

        ```proto
        message MyMap {
          // The values in the field `value` must follow the specified rules.
          map<string, string> value = 1 [(buf.validate.field).map.values = {
            string: {
              min_len: 5
              max_len: 20
            }
          }];
        }
        ```
        Note that the `required` rule does not apply. Map values cannot be unset.
        """

    def __init__(
        self,
        *,
        min_pairs: builtins.int | None = ...,
        max_pairs: builtins.int | None = ...,
        keys: global___FieldRules | None = ...,
        values: global___FieldRules | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["keys", b"keys", "max_pairs", b"max_pairs", "min_pairs", b"min_pairs", "values", b"values"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["keys", b"keys", "max_pairs", b"max_pairs", "min_pairs", b"min_pairs", "values", b"values"]) -> None: ...

global___MapRules = MapRules

@typing.final
class AnyRules(google.protobuf.message.Message):
    """AnyRules describe rules applied exclusively to the `google.protobuf.Any` well-known type."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """requires the field's type_url to be not equal to any of the specified values. If it matches any of the specified values, an error message is generated.

        ```proto
        message MyAny {
          //  The `value` field must not have a `type_url` equal to any of the specified values.
          google.protobuf.Any value = 1 [(buf.validate.field).any = {
              not_in: ["type.googleapis.com/ForbiddenType1", "type.googleapis.com/ForbiddenType2"]
          }];
        }
        ```
        """

    def __init__(
        self,
        *,
        not_in: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["in", b"in", "not_in", b"not_in"]) -> None: ...

global___AnyRules = AnyRules

@typing.final
class DurationRules(google.protobuf.message.Message):
    """DurationRules describe the rules applied exclusively to the `google.protobuf.Duration` well-known type."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    IN_FIELD_NUMBER: builtins.int
    NOT_IN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    @property
    def const(self) -> google.protobuf.duration_pb2.Duration:
        """`const` dictates that the field must match the specified value of the `google.protobuf.Duration` type exactly.
        If the field's value deviates from the specified value, an error message
        will be generated.

        ```proto
        message MyDuration {
          // value must equal 5s
          google.protobuf.Duration value = 1 [(buf.validate.field).duration.const = "5s"];
        }
        ```
        """

    @property
    def lt(self) -> google.protobuf.duration_pb2.Duration:
        """`lt` stipulates that the field must be less than the specified value of the `google.protobuf.Duration` type,
        exclusive. If the field's value is greater than or equal to the specified
        value, an error message will be generated.

        ```proto
        message MyDuration {
          // value must be less than 5s
          google.protobuf.Duration value = 1 [(buf.validate.field).duration.lt = "5s"];
        }
        ```
        """

    @property
    def lte(self) -> google.protobuf.duration_pb2.Duration:
        """`lte` indicates that the field must be less than or equal to the specified
        value of the `google.protobuf.Duration` type, inclusive. If the field's value is greater than the specified value,
        an error message will be generated.

        ```proto
        message MyDuration {
          // value must be less than or equal to 10s
          google.protobuf.Duration value = 1 [(buf.validate.field).duration.lte = "10s"];
        }
        ```
        """

    @property
    def gt(self) -> google.protobuf.duration_pb2.Duration:
        """`gt` requires the duration field value to be greater than the specified
        value (exclusive). If the value of `gt` is larger than a specified `lt`
        or `lte`, the range is reversed, and the field value must be outside the
        specified range. If the field value doesn't meet the required conditions,
        an error message is generated.

        ```proto
        message MyDuration {
          // duration must be greater than 5s [duration.gt]
          google.protobuf.Duration value = 1 [(buf.validate.field).duration.gt = { seconds: 5 }];

          // duration must be greater than 5s and less than 10s [duration.gt_lt]
          google.protobuf.Duration another_value = 2 [(buf.validate.field).duration = { gt: { seconds: 5 }, lt: { seconds: 10 } }];

          // duration must be greater than 10s or less than 5s [duration.gt_lt_exclusive]
          google.protobuf.Duration other_value = 3 [(buf.validate.field).duration = { gt: { seconds: 10 }, lt: { seconds: 5 } }];
        }
        ```
        """

    @property
    def gte(self) -> google.protobuf.duration_pb2.Duration:
        """`gte` requires the duration field value to be greater than or equal to the
        specified value (exclusive). If the value of `gte` is larger than a
        specified `lt` or `lte`, the range is reversed, and the field value must
        be outside the specified range. If the field value doesn't meet the
        required conditions, an error message is generated.

        ```proto
        message MyDuration {
         // duration must be greater than or equal to 5s [duration.gte]
         google.protobuf.Duration value = 1 [(buf.validate.field).duration.gte = { seconds: 5 }];

         // duration must be greater than or equal to 5s and less than 10s [duration.gte_lt]
         google.protobuf.Duration another_value = 2 [(buf.validate.field).duration = { gte: { seconds: 5 }, lt: { seconds: 10 } }];

         // duration must be greater than or equal to 10s or less than 5s [duration.gte_lt_exclusive]
         google.protobuf.Duration other_value = 3 [(buf.validate.field).duration = { gte: { seconds: 10 }, lt: { seconds: 5 } }];
        }
        ```
        """

    @property
    def not_in(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.duration_pb2.Duration]:
        """`not_in` denotes that the field must not be equal to
        any of the specified values of the `google.protobuf.Duration` type.
        If the field's value matches any of these values, an error message will be
        generated.

        ```proto
        message MyDuration {
          // value must not be in list [1s, 2s, 3s]
          google.protobuf.Duration value = 1 [(buf.validate.field).duration.not_in = ["1s", "2s", "3s"]];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.duration_pb2.Duration]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyDuration {
          google.protobuf.Duration value = 1 [
            (buf.validate.field).duration.example = { seconds: 1 },
            (buf.validate.field).duration.example = { seconds: 2 },
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: google.protobuf.duration_pb2.Duration | None = ...,
        lt: google.protobuf.duration_pb2.Duration | None = ...,
        lte: google.protobuf.duration_pb2.Duration | None = ...,
        gt: google.protobuf.duration_pb2.Duration | None = ...,
        gte: google.protobuf.duration_pb2.Duration | None = ...,
        not_in: collections.abc.Iterable[google.protobuf.duration_pb2.Duration] | None = ...,
        example: collections.abc.Iterable[google.protobuf.duration_pb2.Duration] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lte", b"lte"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "greater_than", b"greater_than", "gt", b"gt", "gte", b"gte", "in", b"in", "less_than", b"less_than", "lt", b"lt", "lte", b"lte", "not_in", b"not_in"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte"] | None: ...

global___DurationRules = DurationRules

@typing.final
class TimestampRules(google.protobuf.message.Message):
    """TimestampRules describe the rules applied exclusively to the `google.protobuf.Timestamp` well-known type."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONST_FIELD_NUMBER: builtins.int
    LT_FIELD_NUMBER: builtins.int
    LTE_FIELD_NUMBER: builtins.int
    LT_NOW_FIELD_NUMBER: builtins.int
    GT_FIELD_NUMBER: builtins.int
    GTE_FIELD_NUMBER: builtins.int
    GT_NOW_FIELD_NUMBER: builtins.int
    WITHIN_FIELD_NUMBER: builtins.int
    EXAMPLE_FIELD_NUMBER: builtins.int
    lt_now: builtins.bool
    """`lt_now` specifies that this field, of the `google.protobuf.Timestamp` type, must be less than the current time. `lt_now` can only be used with the `within` rule.

    ```proto
    message MyTimestamp {
     // value must be less than now
      google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.lt_now = true];
    }
    ```
    """
    gt_now: builtins.bool
    """`gt_now` specifies that this field, of the `google.protobuf.Timestamp` type, must be greater than the current time. `gt_now` can only be used with the `within` rule.

    ```proto
    message MyTimestamp {
      // value must be greater than now
      google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.gt_now = true];
    }
    ```
    """
    @property
    def const(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """`const` dictates that this field, of the `google.protobuf.Timestamp` type, must exactly match the specified value. If the field value doesn't correspond to the specified timestamp, an error message will be generated.

        ```proto
        message MyTimestamp {
          // value must equal 2023-05-03T10:00:00Z
          google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.const = {seconds: 1727998800}];
        }
        ```
        """

    @property
    def lt(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """requires the duration field value to be less than the specified value (field < value). If the field value doesn't meet the required conditions, an error message is generated.

        ```proto
        message MyDuration {
          // duration must be less than 'P3D' [duration.lt]
          google.protobuf.Duration value = 1 [(buf.validate.field).duration.lt = { seconds: 259200 }];
        }
        ```
        """

    @property
    def lte(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """requires the timestamp field value to be less than or equal to the specified value (field <= value). If the field value doesn't meet the required conditions, an error message is generated.

        ```proto
        message MyTimestamp {
          // timestamp must be less than or equal to '2023-05-14T00:00:00Z' [timestamp.lte]
          google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.lte = { seconds: 1678867200 }];
        }
        ```
        """

    @property
    def gt(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """`gt` requires the timestamp field value to be greater than the specified
        value (exclusive). If the value of `gt` is larger than a specified `lt`
        or `lte`, the range is reversed, and the field value must be outside the
        specified range. If the field value doesn't meet the required conditions,
        an error message is generated.

        ```proto
        message MyTimestamp {
          // timestamp must be greater than '2023-01-01T00:00:00Z' [timestamp.gt]
          google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.gt = { seconds: 1672444800 }];

          // timestamp must be greater than '2023-01-01T00:00:00Z' and less than '2023-01-02T00:00:00Z' [timestamp.gt_lt]
          google.protobuf.Timestamp another_value = 2 [(buf.validate.field).timestamp = { gt: { seconds: 1672444800 }, lt: { seconds: 1672531200 } }];

          // timestamp must be greater than '2023-01-02T00:00:00Z' or less than '2023-01-01T00:00:00Z' [timestamp.gt_lt_exclusive]
          google.protobuf.Timestamp other_value = 3 [(buf.validate.field).timestamp = { gt: { seconds: 1672531200 }, lt: { seconds: 1672444800 } }];
        }
        ```
        """

    @property
    def gte(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """`gte` requires the timestamp field value to be greater than or equal to the
        specified value (exclusive). If the value of `gte` is larger than a
        specified `lt` or `lte`, the range is reversed, and the field value
        must be outside the specified range. If the field value doesn't meet
        the required conditions, an error message is generated.

        ```proto
        message MyTimestamp {
          // timestamp must be greater than or equal to '2023-01-01T00:00:00Z' [timestamp.gte]
          google.protobuf.Timestamp value = 1 [(buf.validate.field).timestamp.gte = { seconds: 1672444800 }];

          // timestamp must be greater than or equal to '2023-01-01T00:00:00Z' and less than '2023-01-02T00:00:00Z' [timestamp.gte_lt]
          google.protobuf.Timestamp another_value = 2 [(buf.validate.field).timestamp = { gte: { seconds: 1672444800 }, lt: { seconds: 1672531200 } }];

          // timestamp must be greater than or equal to '2023-01-02T00:00:00Z' or less than '2023-01-01T00:00:00Z' [timestamp.gte_lt_exclusive]
          google.protobuf.Timestamp other_value = 3 [(buf.validate.field).timestamp = { gte: { seconds: 1672531200 }, lt: { seconds: 1672444800 } }];
        }
        ```
        """

    @property
    def within(self) -> google.protobuf.duration_pb2.Duration:
        """`within` specifies that this field, of the `google.protobuf.Timestamp` type, must be within the specified duration of the current time. If the field value isn't within the duration, an error message is generated.

        ```proto
        message MyTimestamp {
          // value must be within 1 hour of now
          google.protobuf.Timestamp created_at = 1 [(buf.validate.field).timestamp.within = {seconds: 3600}];
        }
        ```
        """

    @property
    def example(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[google.protobuf.timestamp_pb2.Timestamp]:
        """`example` specifies values that the field may have. These values SHOULD
        conform to other rules. `example` values will not impact validation
        but may be used as helpful guidance on how to populate the given field.

        ```proto
        message MyTimestamp {
          google.protobuf.Timestamp value = 1 [
            (buf.validate.field).timestamp.example = { seconds: 1672444800 },
            (buf.validate.field).timestamp.example = { seconds: 1672531200 },
          ];
        }
        ```
        """

    def __init__(
        self,
        *,
        const: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        lt: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        lte: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        lt_now: builtins.bool | None = ...,
        gt: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        gte: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        gt_now: builtins.bool | None = ...,
        within: google.protobuf.duration_pb2.Duration | None = ...,
        example: collections.abc.Iterable[google.protobuf.timestamp_pb2.Timestamp] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["const", b"const", "greater_than", b"greater_than", "gt", b"gt", "gt_now", b"gt_now", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lt_now", b"lt_now", "lte", b"lte", "within", b"within"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["const", b"const", "example", b"example", "greater_than", b"greater_than", "gt", b"gt", "gt_now", b"gt_now", "gte", b"gte", "less_than", b"less_than", "lt", b"lt", "lt_now", b"lt_now", "lte", b"lte", "within", b"within"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["greater_than", b"greater_than"]) -> typing.Literal["gt", "gte", "gt_now"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["less_than", b"less_than"]) -> typing.Literal["lt", "lte", "lt_now"] | None: ...

global___TimestampRules = TimestampRules

@typing.final
class Violations(google.protobuf.message.Message):
    """`Violations` is a collection of `Violation` messages. This message type is returned by
    Protovalidate when a proto message fails to meet the requirements set by the `Rule` validation rules.
    Each individual violation is represented by a `Violation` message.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VIOLATIONS_FIELD_NUMBER: builtins.int
    @property
    def violations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___Violation]:
        """`violations` is a repeated field that contains all the `Violation` messages corresponding to the violations detected."""

    def __init__(
        self,
        *,
        violations: collections.abc.Iterable[global___Violation] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["violations", b"violations"]) -> None: ...

global___Violations = Violations

@typing.final
class Violation(google.protobuf.message.Message):
    """`Violation` represents a single instance where a validation rule, expressed
    as a `Rule`, was not met. It provides information about the field that
    caused the violation, the specific rule that wasn't fulfilled, and a
    human-readable error message.

    For example, consider the following message:

    ```proto
    message User {
        int32 age = 1 [(buf.validate.field).cel = {
            id: "user.age",
            expression: "this < 18 ? 'User must be at least 18 years old' : ''",
        }];
    }
    ```

    It could produce the following violation:

    ```json
    {
      "ruleId": "user.age",
      "message": "User must be at least 18 years old",
      "field": {
        "elements": [
          {
            "fieldNumber": 1,
            "fieldName": "age",
            "fieldType": "TYPE_INT32"
          }
        ]
      },
      "rule": {
        "elements": [
          {
            "fieldNumber": 23,
            "fieldName": "cel",
            "fieldType": "TYPE_MESSAGE",
            "index": "0"
          }
        ]
      }
    }
    ```
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELD_FIELD_NUMBER: builtins.int
    RULE_FIELD_NUMBER: builtins.int
    RULE_ID_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    FOR_KEY_FIELD_NUMBER: builtins.int
    rule_id: builtins.str
    """`rule_id` is the unique identifier of the `Rule` that was not fulfilled.
    This is the same `id` that was specified in the `Rule` message, allowing easy tracing of which rule was violated.
    """
    message: builtins.str
    """`message` is a human-readable error message that describes the nature of the violation.
    This can be the default error message from the violated `Rule`, or it can be a custom message that gives more context about the violation.
    """
    for_key: builtins.bool
    """`for_key` indicates whether the violation was caused by a map key, rather than a value."""
    @property
    def field(self) -> global___FieldPath:
        """`field` is a machine-readable path to the field that failed validation.
        This could be a nested field, in which case the path will include all the parent fields leading to the actual field that caused the violation.

        For example, consider the following message:

        ```proto
        message Message {
          bool a = 1 [(buf.validate.field).required = true];
        }
        ```

        It could produce the following violation:

        ```textproto
        violation {
          field { element { field_number: 1, field_name: "a", field_type: 8 } }
          ...
        }
        ```
        """

    @property
    def rule(self) -> global___FieldPath:
        """`rule` is a machine-readable path that points to the specific rule that failed validation.
        This will be a nested field starting from the FieldRules of the field that failed validation.
        For custom rules, this will provide the path of the rule, e.g. `cel[0]`.

        For example, consider the following message:

        ```proto
        message Message {
          bool a = 1 [(buf.validate.field).required = true];
          bool b = 2 [(buf.validate.field).cel = {
            id: "custom_rule",
            expression: "!this ? 'b must be true': ''"
          }]
        }
        ```

        It could produce the following violations:

        ```textproto
        violation {
          rule { element { field_number: 25, field_name: "required", field_type: 8 } }
          ...
        }
        violation {
          rule { element { field_number: 23, field_name: "cel", field_type: 11, index: 0 } }
          ...
        }
        ```
        """

    def __init__(
        self,
        *,
        field: global___FieldPath | None = ...,
        rule: global___FieldPath | None = ...,
        rule_id: builtins.str | None = ...,
        message: builtins.str | None = ...,
        for_key: builtins.bool | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["field", b"field", "for_key", b"for_key", "message", b"message", "rule", b"rule", "rule_id", b"rule_id"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["field", b"field", "for_key", b"for_key", "message", b"message", "rule", b"rule", "rule_id", b"rule_id"]) -> None: ...

global___Violation = Violation

@typing.final
class FieldPath(google.protobuf.message.Message):
    """`FieldPath` provides a path to a nested protobuf field.

    This message provides enough information to render a dotted field path even without protobuf descriptors.
    It also provides enough information to resolve a nested field through unknown wire data.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ELEMENTS_FIELD_NUMBER: builtins.int
    @property
    def elements(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___FieldPathElement]:
        """`elements` contains each element of the path, starting from the root and recursing downward."""

    def __init__(
        self,
        *,
        elements: collections.abc.Iterable[global___FieldPathElement] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["elements", b"elements"]) -> None: ...

global___FieldPath = FieldPath

@typing.final
class FieldPathElement(google.protobuf.message.Message):
    """`FieldPathElement` provides enough information to nest through a single protobuf field.

    If the selected field is a map or repeated field, the `subscript` value selects a specific element from it.
    A path that refers to a value nested under a map key or repeated field index will have a `subscript` value.
    The `field_type` field allows unambiguous resolution of a field even if descriptors are not available.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FIELD_NUMBER_FIELD_NUMBER: builtins.int
    FIELD_NAME_FIELD_NUMBER: builtins.int
    FIELD_TYPE_FIELD_NUMBER: builtins.int
    KEY_TYPE_FIELD_NUMBER: builtins.int
    VALUE_TYPE_FIELD_NUMBER: builtins.int
    INDEX_FIELD_NUMBER: builtins.int
    BOOL_KEY_FIELD_NUMBER: builtins.int
    INT_KEY_FIELD_NUMBER: builtins.int
    UINT_KEY_FIELD_NUMBER: builtins.int
    STRING_KEY_FIELD_NUMBER: builtins.int
    field_number: builtins.int
    """`field_number` is the field number this path element refers to."""
    field_name: builtins.str
    """`field_name` contains the field name this path element refers to.
    This can be used to display a human-readable path even if the field number is unknown.
    """
    field_type: google.protobuf.descriptor_pb2.FieldDescriptorProto.Type.ValueType
    """`field_type` specifies the type of this field. When using reflection, this value is not needed.

    This value is provided to make it possible to traverse unknown fields through wire data.
    When traversing wire data, be mindful of both packed[1] and delimited[2] encoding schemes.

    [1]: https://protobuf.dev/programming-guides/encoding/#packed
    [2]: https://protobuf.dev/programming-guides/encoding/#groups

    N.B.: Although groups are deprecated, the corresponding delimited encoding scheme is not, and
    can be explicitly used in Protocol Buffers 2023 Edition.
    """
    key_type: google.protobuf.descriptor_pb2.FieldDescriptorProto.Type.ValueType
    """`key_type` specifies the map key type of this field. This value is useful when traversing
    unknown fields through wire data: specifically, it allows handling the differences between
    different integer encodings.
    """
    value_type: google.protobuf.descriptor_pb2.FieldDescriptorProto.Type.ValueType
    """`value_type` specifies map value type of this field. This is useful if you want to display a
    value inside unknown fields through wire data.
    """
    index: builtins.int
    """`index` specifies a 0-based index into a repeated field."""
    bool_key: builtins.bool
    """`bool_key` specifies a map key of type bool."""
    int_key: builtins.int
    """`int_key` specifies a map key of type int32, int64, sint32, sint64, sfixed32 or sfixed64."""
    uint_key: builtins.int
    """`uint_key` specifies a map key of type uint32, uint64, fixed32 or fixed64."""
    string_key: builtins.str
    """`string_key` specifies a map key of type string."""
    def __init__(
        self,
        *,
        field_number: builtins.int | None = ...,
        field_name: builtins.str | None = ...,
        field_type: google.protobuf.descriptor_pb2.FieldDescriptorProto.Type.ValueType | None = ...,
        key_type: google.protobuf.descriptor_pb2.FieldDescriptorProto.Type.ValueType | None = ...,
        value_type: google.protobuf.descriptor_pb2.FieldDescriptorProto.Type.ValueType | None = ...,
        index: builtins.int | None = ...,
        bool_key: builtins.bool | None = ...,
        int_key: builtins.int | None = ...,
        uint_key: builtins.int | None = ...,
        string_key: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["bool_key", b"bool_key", "field_name", b"field_name", "field_number", b"field_number", "field_type", b"field_type", "index", b"index", "int_key", b"int_key", "key_type", b"key_type", "string_key", b"string_key", "subscript", b"subscript", "uint_key", b"uint_key", "value_type", b"value_type"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["bool_key", b"bool_key", "field_name", b"field_name", "field_number", b"field_number", "field_type", b"field_type", "index", b"index", "int_key", b"int_key", "key_type", b"key_type", "string_key", b"string_key", "subscript", b"subscript", "uint_key", b"uint_key", "value_type", b"value_type"]) -> None: ...
    def WhichOneof(self, oneof_group: typing.Literal["subscript", b"subscript"]) -> typing.Literal["index", "bool_key", "int_key", "uint_key", "string_key"] | None: ...

global___FieldPathElement = FieldPathElement

MESSAGE_FIELD_NUMBER: builtins.int
ONEOF_FIELD_NUMBER: builtins.int
FIELD_FIELD_NUMBER: builtins.int
PREDEFINED_FIELD_NUMBER: builtins.int
message: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.MessageOptions, global___MessageRules]
"""Rules specify the validations to be performed on this message. By default,
no validation is performed against a message.
"""
oneof: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.OneofOptions, global___OneofRules]
"""Rules specify the validations to be performed on this oneof. By default,
no validation is performed against a oneof.
"""
field: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.FieldOptions, global___FieldRules]
"""Rules specify the validations to be performed on this field. By default,
no validation is performed against a field.
"""
predefined: google.protobuf.internal.extension_dict._ExtensionFieldDescriptor[google.protobuf.descriptor_pb2.FieldOptions, global___PredefinedRules]
"""Specifies predefined rules. When extending a standard rule message,
this adds additional CEL expressions that apply when the extension is used.

```proto
extend buf.validate.Int32Rules {
  bool is_zero [(buf.validate.predefined).cel = {
    id: "int32.is_zero",
    message: "value must be zero",
    expression: "!rule || this == 0",
  }];
}

message Foo {
  int32 reserved = 1 [(buf.validate.field).int32.(is_zero) = true];
}
```
"""
