"""Metaclasses"""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/05_meta.ipynb.

# %% auto #0
__all__ = ['test_sig', 'FixSigMeta', 'PrePostInitMeta', 'AutoInit', 'NewChkMeta', 'BypassNewMeta', 'empty2none', 'anno_dict',
           'use_kwargs_dict', 'use_kwargs', 'delegates', 'method', 'funcs_kwargs', 'splice_sig']

# %% ../nbs/05_meta.ipynb #d26e95dd
from .imports import *
from .basics import *
from contextlib import contextmanager
from functools import wraps
from inspect import signature, Parameter
from copy import copy

import inspect

# %% ../nbs/05_meta.ipynb #8f330096
def test_sig(f, b):
    "Test the signature of an object"
    from fastcore.test import test_eq
    test_eq(str(inspect.signature(f)), b)

# %% ../nbs/05_meta.ipynb #8f2b433f
def _rm_self(sig):
    sigd = dict(sig.parameters)
    sigd.pop('self')
    return sig.replace(parameters=sigd.values())

# %% ../nbs/05_meta.ipynb #fc72078d
class FixSigMeta(type):
    "A metaclass that fixes the signature on classes that override `__new__`"
    def __new__(cls, name, bases, dict):
        res = super().__new__(cls, name, bases, dict)
        if res.__init__ is not object.__init__: res.__signature__ = _rm_self(inspect.signature(res.__init__))
        return res

# %% ../nbs/05_meta.ipynb #6a52de3f
class PrePostInitMeta(FixSigMeta):
    "A metaclass that calls optional `__pre_init__` and `__post_init__` methods"
    def __call__(cls, *args, **kwargs):
        res = cls.__new__(cls)
        if type(res)==cls:
            if hasattr(res,'__pre_init__'): res.__pre_init__(*args,**kwargs)
            res.__init__(*args,**kwargs)
            if hasattr(res,'__post_init__'): res.__post_init__(*args,**kwargs)
        return res

# %% ../nbs/05_meta.ipynb #b5521274
class AutoInit(metaclass=PrePostInitMeta):
    "Same as `object`, but no need for subclasses to call `super().__init__`"
    def __pre_init__(self, *args, **kwargs): super().__init__(*args, **kwargs)

# %% ../nbs/05_meta.ipynb #d6101df5
class NewChkMeta(FixSigMeta):
    "Metaclass to avoid recreating object passed to constructor"
    def __call__(cls, x=None, *args, **kwargs):
        if not args and not kwargs and x is not None and isinstance(x,cls): return x
        res = super().__call__(*((x,) + args), **kwargs)
        return res

# %% ../nbs/05_meta.ipynb #4948f511
class BypassNewMeta(FixSigMeta):
    "Metaclass: casts `x` to this class if it's of type `cls._bypass_type`"
    def __call__(cls, x=None, *args, **kwargs):
        if hasattr(cls, '_new_meta'): x = cls._new_meta(x, *args, **kwargs)
        elif not isinstance(x,getattr(cls,'_bypass_type',object)) or len(args) or len(kwargs):
            x = super().__call__(*((x,)+args), **kwargs)
        if cls!=x.__class__: x.__class__ = cls
        return x

# %% ../nbs/05_meta.ipynb #c4249cea
def empty2none(p):
    "Replace `Parameter.empty` with `None`"
    return None if p==inspect.Parameter.empty else p

# %% ../nbs/05_meta.ipynb #dbdb8fb6
def anno_dict(f):
    "`__annotation__ dictionary with `empty` cast to `None`, returning empty if doesn't exist"
    return {k:empty2none(v) for k,v in getattr(f, '__annotations__', {}).items()}

# %% ../nbs/05_meta.ipynb #3329b204
def _mk_param(n,d=None): return inspect.Parameter(n, inspect.Parameter.KEYWORD_ONLY, default=d)

# %% ../nbs/05_meta.ipynb #96f39b59
def use_kwargs_dict(keep=False, **kwargs):
    "Decorator: replace `**kwargs` in signature with `names` params"
    def _f(f):
        sig = inspect.signature(f)
        sigd = dict(sig.parameters)
        k = sigd.pop('kwargs')
        s2 = {n:_mk_param(n,d) for n,d in kwargs.items() if n not in sigd}
        sigd.update(s2)
        if keep: sigd['kwargs'] = k
        f.__signature__ = sig.replace(parameters=sigd.values())
        return f
    return _f

# %% ../nbs/05_meta.ipynb #54c888f3
def use_kwargs(names, keep=False):
    "Decorator: replace `**kwargs` in signature with `names` params"
    def _f(f):
        sig = inspect.signature(f)
        sigd = dict(sig.parameters)
        k = sigd.pop('kwargs')
        s2 = {n:_mk_param(n) for n in names if n not in sigd}
        sigd.update(s2)
        if keep: sigd['kwargs'] = k
        f.__signature__ = sig.replace(parameters=sigd.values())
        return f
    return _f

# %% ../nbs/05_meta.ipynb #11583391
def delegates(to:FunctionType=None, # Delegatee
              keep=False, # Keep `kwargs` in decorated function?
              but:list=None, # Exclude these parameters from signature
              sort_args=False): # Sort arguments alphabetically, doesn't work with call_parse
    "Decorator: replace `**kwargs` in signature with params from `to`"
    if but is None: but = []
    def _f(f):
        if to is None: to_f,from_f = f.__base__.__init__,f.__init__
        else:          to_f,from_f = to.__init__ if isinstance(to,type) else to,f
        from_f = getattr(from_f,'__func__',from_f)
        to_f = getattr(to_f,'__func__',to_f)
        if hasattr(from_f,'__delwrap__'): return f
        sig = inspect.signature(from_f)
        s2 = {k:v.replace(kind=inspect.Parameter.KEYWORD_ONLY) for k,v in inspect.signature(to_f).parameters.items()
              if v.default != inspect.Parameter.empty and k not in sig.parameters and k not in but}
        if sort_args: s2 = dict(sorted(s2.items()))
        anno = {k:v for k,v in getattr(to_f, "__annotations__", {}).items() if k not in sig.parameters and k not in but}
        from_f.__signature__ = sig_with_params(sig, remove=None if keep else 'kwargs', keep='kwargs' if keep else None, **s2)
        if not keep: from_f.__delwrap__ = to_f
        if hasattr(from_f, '__annotations__'): from_f.__annotations__.update(anno)
        return f
    return _f

# %% ../nbs/05_meta.ipynb #e77203dd
def method(f):
    "Mark `f` as a method"
    # `1` is a dummy instance since Py3 doesn't allow `None` any more
    return MethodType(f, 1)

# %% ../nbs/05_meta.ipynb #0d934a51
def _funcs_kwargs(cls, as_method):
    old_init = cls.__init__
    def _init(self, *args, **kwargs):
        for k in cls._methods:
            arg = kwargs.pop(k,None)
            if arg is not None:
                if as_method: arg = method(arg)
                if isinstance(arg,MethodType): arg = MethodType(arg.__func__, self)
                setattr(self, k, arg)
        old_init(self, *args, **kwargs)
    functools.update_wrapper(_init, old_init)
    cls.__init__ = use_kwargs(cls._methods)(_init)
    if hasattr(cls, '__signature__'): cls.__signature__ = _rm_self(inspect.signature(cls.__init__))
    return cls

# %% ../nbs/05_meta.ipynb #569a450d
def funcs_kwargs(as_method=False):
    "Replace methods in `cls._methods` with those from `kwargs`"
    if callable(as_method): return _funcs_kwargs(as_method, False)
    return partial(_funcs_kwargs, as_method=as_method)

# %% ../nbs/05_meta.ipynb #b69b0276
def splice_sig(wrapper, fn, *skips):
    "Replace *args/**kwargs in wrapper's sig with fn's params (minus skips)"
    w_ps = list(signature(wrapper).parameters.values())
    f_ps = [p for p in signature(fn).parameters.values() if p.name not in skips]
    split = next((i for i, p in enumerate(w_ps) if p.kind==Parameter.VAR_POSITIONAL), len(w_ps))
    pre = w_ps[:split]
    post = [p for p in w_ps[split+1:] if p.kind != Parameter.VAR_KEYWORD]
    wrapper.__signature__ = signature(wrapper).replace(parameters=[*pre, *f_ps, *post])
    return wraps(fn)(wrapper)
