

set -ex



$PREFIX/bin/glpsol --version
$PREFIX/bin/glpsol --mps plan.mps
echo "Editable install via pip (no build isolation) ..."
python -m pip install -e . --no-build-isolation
echo "Run pytest ..."
pytest -vv test_spam.py
echo "Checking shared and static libraries in ${PREFIX}/lib ..."
test -f ${PREFIX}/lib/libglpk${SHLIB_EXT}
test -s ${PREFIX}/lib/libglpk${SHLIB_EXT}
echo "Checking exported symbols for glp_version ..."
nm -D ${PREFIX}/lib/libglpk.so | grep glp_version
echo "Check C call GLPK lib ..."
export CFLAGS="${CFLAGS} -I${PREFIX}/include -L${PREFIX}/lib"
export LDFLAGS="${LDFLAGS} -Wl,-rpath,${PREFIX}/lib"
$CC $CFLAGS $LDFLAGS test.c -lglpk -o test.out
./test.out
echo "python test_ctypes.py ..."
python test_ctypes.py
exit 0
