# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing import Dict
from typing_extensions import Literal, Required, TypedDict

__all__ = ["FunctionCallContentParam"]


class FunctionCallContentParam(TypedDict, total=False):
    """A function tool call content block."""

    id: Required[str]
    """A unique ID for this specific tool call."""

    arguments: Required[Dict[str, object]]
    """The arguments to pass to the function."""

    name: Required[str]
    """The name of the tool to call."""

    type: Required[Literal["function_call"]]
