"""
installer-attribution-bootstrap
This package provides functionality to read and manage attribution data
that is embedded in Anaconda distribution installers on supported platforms.
"""

__version__ = "1.0.0"
__author__ = "Gabriel Bustamante"
__email__ = "gbustamante@anaconda.com"

from .installer_attribution_core import (
    read_installer_attribution,
    save_installer_attribution,
)
from .installer_attribution_io import (
    INSTALLER_ATTRIBUTION_READERS,
    read_installer_attribution_linux,
    read_installer_attribution_macos,
    read_installer_attribution_windows,
    write_installer_attribution_to_file,
)

__all__ = [
    "read_installer_attribution",
    "save_installer_attribution",
    "write_installer_attribution_to_file",
    "read_installer_attribution_windows",
    "read_installer_attribution_macos",
    "read_installer_attribution_linux",
    "INSTALLER_ATTRIBUTION_READERS",
]
