from traitlets.utils.bunch import Bunch

projections = Bunch(
    EPSG3857=dict(
        name="EPSG3857",
        custom=False,
    ),
    Earth=dict(name="Earth", custom=False),
    EPSG3395=dict(name="EPSG3395", custom=False),
    EPSG4326=dict(name="EPSG4326", custom=False),
    Base=dict(name="Base", custom=False),
    Simple=dict(name="Simple", custom=False),
    EPSG3413=Bunch(
        NASAGIBS=dict(
            name="EPSG:3413",
            custom=True,
            proj4def="""+proj=stere +lat_0=90 +lat_ts=70 +lon_0=-45 +k=1 +x_0=0 +y_0=0
                    +ellps=WGS84 +datum=WGS84 +units=m +no_defs""",
            origin=[-4194304, 4194304],
            resolutions=[16384.0, 8192.0, 4096.0, 2048.0, 1024.0, 512.0, 256.0],
            bounds=[[-4194304, -4194304], [4194304, 4194304]],
        )
    ),
    EPSG5936=Bunch(
        ESRIBasemap=dict(
            name="EPSG:5936",
            custom=True,
            proj4def="""+proj=stere +lat_0=90 +lat_ts=90 +lon_0=-150 +k=0.994
                +x_0=2000000 +y_0=2000000 +datum=WGS84 +units=m +no_defs""",
            origin=[-2.8567784109255e07, 3.2567784109255e07],
            resolutions=[
                238810.813354,
                119405.406677,
                59702.7033384999,
                29851.3516692501,
                14925.675834625,
                7462.83791731252,
                3731.41895865639,
                1865.70947932806,
                932.854739664032,
                466.427369832148,
                233.213684916074,
                116.60684245803701,
                58.30342122888621,
                29.151710614575396,
                14.5758553072877,
                7.28792765351156,
                3.64396382688807,
                1.82198191331174,
                0.910990956788164,
                0.45549547826179,
                0.227747739130895,
                0.113873869697739,
                0.05693693484887,
                0.028468467424435,
            ],
            bounds=[
                [-2623285.8808999992907047, -2623285.8808999992907047],
                [6623285.8803000003099442, 6623285.8803000003099442],
            ],
        )
    ),
    EPSG3031=Bunch(
        NASAGIBS=dict(
            name="EPSG:3031",
            custom=True,
            proj4def="""+proj=stere +lat_0=-90 +lat_ts=-71 +lon_0=0 +k=1
                +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs""",
            origin=[-4194304, 4194304],
            resolutions=[16384.0, 8192.0, 4096.0, 2048.0, 1024.0, 512.0, 256.0],
            bounds=[[-4194304, -4194304], [4194304, 4194304]],
        ),
        ESRIBasemap=dict(
            name="EPSG:3031",
            custom=True,
            proj4def="""+proj=stere +lat_0=-90 +lat_ts=-71 +lon_0=0 +k=1
                +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs""",
            origin=[-3.06361e7, 3.0636099999999993e7],
            resolutions=[
                67733.46880027094,
                33866.73440013547,
                16933.367200067736,
                8466.683600033868,
                4233.341800016934,
                2116.670900008467,
                1058.3354500042335,
                529.1677250021168,
                264.5838625010584,
            ],
            bounds=[
                [-4524583.19363305, -4524449.487765655],
                [4524449.4877656475, 4524583.193633042],
            ],
        ),
        ESRIImagery=dict(
            name="EPSG:3031",
            custom=True,
            proj4def="""+proj=stere +lat_0=-90 +lat_ts=-71 +lon_0=0 +k=1
                +x_0=0 +y_0=0 +datum=WGS84 +units=m +no_defs""",
            origin=[-3.369955099203e7, 3.369955101703e7],
            resolutions=[
                238810.81335399998,
                119405.40667699999,
                59702.70333849987,
                29851.351669250063,
                14925.675834625032,
                7462.837917312516,
                3731.4189586563907,
                1865.709479328063,
                932.8547396640315,
                466.42736983214803,
                233.21368491607402,
                116.60684245803701,
                58.30342122888621,
                29.151710614575396,
                14.5758553072877,
                7.28792765351156,
                3.64396382688807,
                1.82198191331174,
                0.910990956788164,
                0.45549547826179,
                0.227747739130895,
                0.113873869697739,
                0.05693693484887,
                0.028468467424435,
            ],
            bounds=[
                [-9913957.327914657, -5730886.461772691],
                [9913957.327914657, 5730886.461773157],
            ],
        ),
    ),
)
