from typing import Any, Callable, Dict, Optional, TypeVar, Union

from typing_extensions import Literal

from mashumaro.types import SerializationStrategy

__all__ = [
    "field_options",
    "pass_through",
]


NamedTupleDeserializationEngine = Literal["as_dict", "as_list"]
DateTimeDeserializationEngine = Literal["ciso8601", "pendulum"]
AnyDeserializationEngine = Literal[
    NamedTupleDeserializationEngine, DateTimeDeserializationEngine
]

NamedTupleSerializationEngine = Literal["as_dict", "as_list"]
OmitSerializationEngine = Literal["omit"]
AnySerializationEngine = Union[
    NamedTupleSerializationEngine, OmitSerializationEngine
]


T = TypeVar("T")


def field_options(
    serialize: Optional[
        Union[AnySerializationEngine, Callable[[Any], Any]]
    ] = None,
    deserialize: Optional[
        Union[AnyDeserializationEngine, Callable[[Any], Any]]
    ] = None,
    serialization_strategy: Optional[SerializationStrategy] = None,
    alias: Optional[str] = None,
) -> Dict[str, Any]:
    return {
        "serialize": serialize,
        "deserialize": deserialize,
        "serialization_strategy": serialization_strategy,
        "alias": alias,
    }


class _PassThrough(SerializationStrategy):
    def __call__(self, *args: Any, **kwargs: Any) -> Any:
        raise NotImplementedError

    def serialize(self, value: T) -> T:
        return value

    def deserialize(self, value: T) -> T:
        return value


pass_through = _PassThrough()
