# The abbreviated color names are understood by matplotlib,
# so we support them too.
SHORT = {
    "b": "#0000FF",  # blue
    "c": "#00BFBF",  # cyan
    "g": "#008000",  # green
    "k": "#000000",  # black
    "m": "#BF00BF",  # magenta
    "r": "#FF0000",  # red
    "w": "#FFFFFF",  # white
    "y": "#BFBF00",  # yellow
}

# https://drafts.csswg.org/css-color-4/#named-colors
CSS4 = {
    "aliceblue": "#F0F8FF",
    "antiquewhite": "#FAEBD7",
    "aqua": "#00FFFF",
    "aquamarine": "#7FFFD4",
    "azure": "#F0FFFF",
    "beige": "#F5F5DC",
    "bisque": "#FFE4C4",
    "black": "#000000",
    "blanchedalmond": "#FFEBCD",
    "blue": "#0000FF",
    "blueviolet": "#8A2BE2",
    "brown": "#A52A2A",
    "burlywood": "#DEB887",
    "cadetblue": "#5F9EA0",
    "chartreuse": "#7FFF00",
    "chocolate": "#D2691E",
    "coral": "#FF7F50",
    "cornflowerblue": "#6495ED",
    "cornsilk": "#FFF8DC",
    "crimson": "#DC143C",
    "cyan": "#00FFFF",
    "darkblue": "#00008B",
    "darkcyan": "#008B8B",
    "darkgoldenrod": "#B8860B",
    "darkgray": "#A9A9A9",
    "darkgreen": "#006400",
    "darkgrey": "#A9A9A9",
    "darkkhaki": "#BDB76B",
    "darkmagenta": "#8B008B",
    "darkolivegreen": "#556B2F",
    "darkorange": "#FF8C00",
    "darkorchid": "#9932CC",
    "darkred": "#8B0000",
    "darksalmon": "#E9967A",
    "darkseagreen": "#8FBC8F",
    "darkslateblue": "#483D8B",
    "darkslategray": "#2F4F4F",
    "darkslategrey": "#2F4F4F",
    "darkturquoise": "#00CED1",
    "darkviolet": "#9400D3",
    "deeppink": "#FF1493",
    "deepskyblue": "#00BFFF",
    "dimgray": "#696969",
    "dimgrey": "#696969",
    "dodgerblue": "#1E90FF",
    "firebrick": "#B22222",
    "floralwhite": "#FFFAF0",
    "forestgreen": "#228B22",
    "fuchsia": "#FF00FF",
    "gainsboro": "#DCDCDC",
    "ghostwhite": "#F8F8FF",
    "gold": "#FFD700",
    "goldenrod": "#DAA520",
    "gray": "#808080",
    "green": "#008000",
    "greenyellow": "#ADFF2F",
    "grey": "#808080",
    "honeydew": "#F0FFF0",
    "hotpink": "#FF69B4",
    "indianred": "#CD5C5C",
    "indigo": "#4B0082",
    "ivory": "#FFFFF0",
    "khaki": "#F0E68C",
    "lavender": "#E6E6FA",
    "lavenderblush": "#FFF0F5",
    "lawngreen": "#7CFC00",
    "lemonchiffon": "#FFFACD",
    "lightblue": "#ADD8E6",
    "lightcoral": "#F08080",
    "lightcyan": "#E0FFFF",
    "lightgoldenrodyellow": "#FAFAD2",
    "lightgray": "#D3D3D3",
    "lightgreen": "#90EE90",
    "lightgrey": "#D3D3D3",
    "lightpink": "#FFB6C1",
    "lightsalmon": "#FFA07A",
    "lightseagreen": "#20B2AA",
    "lightskyblue": "#87CEFA",
    "lightslategray": "#778899",
    "lightslategrey": "#778899",
    "lightsteelblue": "#B0C4DE",
    "lightyellow": "#FFFFE0",
    "lime": "#00FF00",
    "limegreen": "#32CD32",
    "linen": "#FAF0E6",
    "magenta": "#FF00FF",
    "maroon": "#800000",
    "mediumaquamarine": "#66CDAA",
    "mediumblue": "#0000CD",
    "mediumorchid": "#BA55D3",
    "mediumpurple": "#9370DB",
    "mediumseagreen": "#3CB371",
    "mediumslateblue": "#7B68EE",
    "mediumspringgreen": "#00FA9A",
    "mediumturquoise": "#48D1CC",
    "mediumvioletred": "#C71585",
    "midnightblue": "#191970",
    "mintcream": "#F5FFFA",
    "mistyrose": "#FFE4E1",
    "moccasin": "#FFE4B5",
    "navajowhite": "#FFDEAD",
    "navy": "#000080",
    "oldlace": "#FDF5E6",
    "olive": "#808000",
    "olivedrab": "#6B8E23",
    "orange": "#FFA500",
    "orangered": "#FF4500",
    "orchid": "#DA70D6",
    "palegoldenrod": "#EEE8AA",
    "palegreen": "#98FB98",
    "paleturquoise": "#AFEEEE",
    "palevioletred": "#DB7093",
    "papayawhip": "#FFEFD5",
    "peachpuff": "#FFDAB9",
    "peru": "#CD853F",
    "pink": "#FFC0CB",
    "plum": "#DDA0DD",
    "powderblue": "#B0E0E6",
    "purple": "#800080",
    "rebeccapurple": "#663399",
    "red": "#FF0000",
    "rosybrown": "#BC8F8F",
    "royalblue": "#4169E1",
    "saddlebrown": "#8B4513",
    "salmon": "#FA8072",
    "sandybrown": "#F4A460",
    "seagreen": "#2E8B57",
    "seashell": "#FFF5EE",
    "sienna": "#A0522D",
    "silver": "#C0C0C0",
    "skyblue": "#87CEEB",
    "slateblue": "#6A5ACD",
    "slategray": "#708090",
    "slategrey": "#708090",
    "snow": "#FFFAFA",
    "springgreen": "#00FF7F",
    "steelblue": "#4682B4",
    "tan": "#D2B48C",
    "teal": "#008080",
    "thistle": "#D8BFD8",
    "tomato": "#FF6347",
    "turquoise": "#40E0D0",
    "violet": "#EE82EE",
    "wheat": "#F5DEB3",
    "white": "#FFFFFF",
    "whitesmoke": "#F5F5F5",
    "yellow": "#FFFF00",
    "yellowgreen": "#9ACD32",
}

# The 954 most common RGB monitor colors, as defined by several
# hundred thousand participants in the xkcd color name survey.
#
# Source: https://xkcd.com/color/rgb/
#         https://xkcd.com/color/rgb.txt
# Ref: https://blog.xkcd.com/2010/05/03/color-survey-results/
# License: http://creativecommons.org/publicdomain/zero/1.0/

XKCD = {
    "acid green": "#8FFE09",
    "adobe": "#BD6C48",
    "algae": "#54AC68",
    "algae green": "#21C36F",
    "almost black": "#070D0D",
    "amber": "#FEB308",
    "amethyst": "#9B5FC0",
    "apple": "#6ECB3C",
    "apple green": "#76CD26",
    "apricot": "#FFB16D",
    "aqua": "#13EAC9",
    "aqua blue": "#02D8E9",
    "aqua green": "#12E193",
    "aqua marine": "#2EE8BB",
    "aquamarine": "#04D8B2",
    "army green": "#4B5D16",
    "asparagus": "#77AB56",
    "aubergine": "#3D0734",
    "auburn": "#9A3001",
    "avocado": "#90B134",
    "avocado green": "#87A922",
    "azul": "#1D5DEC",
    "azure": "#069AF3",
    "baby blue": "#A2CFFE",
    "baby green": "#8CFF9E",
    "baby pink": "#FFB7CE",
    "baby poo": "#AB9004",
    "baby poop": "#937C00",
    "baby poop green": "#8F9805",
    "baby puke green": "#B6C406",
    "baby purple": "#CA9BF7",
    "baby shit brown": "#AD900D",
    "baby shit green": "#889717",
    "banana": "#FFFF7E",
    "banana yellow": "#FAFE4B",
    "barbie pink": "#FE46A5",
    "barf green": "#94AC02",
    "barney": "#AC1DB8",
    "barney purple": "#A00498",
    "battleship grey": "#6B7C85",
    "beige": "#E6DAA6",
    "berry": "#990F4B",
    "bile": "#B5C306",
    "black": "#000000",
    "bland": "#AFA88B",
    "blood": "#770001",
    "blood orange": "#FE4B03",
    "blood red": "#980002",
    "blue": "#0343DF",
    "blue blue": "#2242C7",
    "blue green": "#137E6D",
    "blue grey": "#607C8E",
    "blue purple": "#5729CE",
    "blue violet": "#5D06E9",
    "blue with a hint of purple": "#533CC6",
    "blue/green": "#0F9B8E",
    "blue/grey": "#758DA3",
    "blue/purple": "#5A06EF",
    "blueberry": "#464196",
    "bluegreen": "#017A79",
    "bluegrey": "#85A3B2",
    "bluey green": "#2BB179",
    "bluey grey": "#89A0B0",
    "bluey purple": "#6241C7",
    "bluish": "#2976BB",
    "bluish green": "#10A674",
    "bluish grey": "#748B97",
    "bluish purple": "#703BE7",
    "blurple": "#5539CC",
    "blush": "#F29E8E",
    "blush pink": "#FE828C",
    "booger": "#9BB53C",
    "booger green": "#96B403",
    "bordeaux": "#7B002C",
    "boring green": "#63B365",
    "bottle green": "#044A05",
    "brick": "#A03623",
    "brick orange": "#C14A09",
    "brick red": "#8F1402",
    "bright aqua": "#0BF9EA",
    "bright blue": "#0165FC",
    "bright cyan": "#41FDFE",
    "bright green": "#01FF07",
    "bright lavender": "#C760FF",
    "bright light blue": "#26F7FD",
    "bright light green": "#2DFE54",
    "bright lilac": "#C95EFB",
    "bright lime": "#87FD05",
    "bright lime green": "#65FE08",
    "bright magenta": "#FF08E8",
    "bright olive": "#9CBB04",
    "bright orange": "#FF5B00",
    "bright pink": "#FE01B1",
    "bright purple": "#BE03FD",
    "bright red": "#FF000D",
    "bright sea green": "#05FFA6",
    "bright sky blue": "#02CCFE",
    "bright teal": "#01F9C6",
    "bright turquoise": "#0FFEF9",
    "bright violet": "#AD0AFD",
    "bright yellow": "#FFFD01",
    "bright yellow green": "#9DFF00",
    "british racing green": "#05480D",
    "bronze": "#A87900",
    "brown": "#653700",
    "brown green": "#706C11",
    "brown grey": "#8D8468",
    "brown orange": "#B96902",
    "brown red": "#922B05",
    "brown yellow": "#B29705",
    "brownish": "#9C6D57",
    "brownish green": "#6A6E09",
    "brownish grey": "#86775F",
    "brownish orange": "#CB7723",
    "brownish pink": "#C27E79",
    "brownish purple": "#76424E",
    "brownish red": "#9E3623",
    "brownish yellow": "#C9B003",
    "browny green": "#6F6C0A",
    "browny orange": "#CA6B02",
    "bruise": "#7E4071",
    "bubble gum pink": "#FF69AF",
    "bubblegum": "#FF6CB5",
    "bubblegum pink": "#FE83CC",
    "buff": "#FEF69E",
    "burgundy": "#610023",
    "burnt orange": "#C04E01",
    "burnt red": "#9F2305",
    "burnt siena": "#B75203",
    "burnt sienna": "#B04E0F",
    "burnt umber": "#A0450E",
    "burnt yellow": "#D5AB09",
    "burple": "#6832E3",
    "butter": "#FFFF81",
    "butter yellow": "#FFFD74",
    "butterscotch": "#FDB147",
    "cadet blue": "#4E7496",
    "camel": "#C69F59",
    "camo": "#7F8F4E",
    "camo green": "#526525",
    "camouflage green": "#4B6113",
    "canary": "#FDFF63",
    "canary yellow": "#FFFE40",
    "candy pink": "#FF63E9",
    "caramel": "#AF6F09",
    "carmine": "#9D0216",
    "carnation": "#FD798F",
    "carnation pink": "#FF7FA7",
    "carolina blue": "#8AB8FE",
    "celadon": "#BEFDB7",
    "celery": "#C1FD95",
    "cement": "#A5A391",
    "cerise": "#DE0C62",
    "cerulean": "#0485D1",
    "cerulean blue": "#056EEE",
    "charcoal": "#343837",
    "charcoal grey": "#3C4142",
    "chartreuse": "#C1F80A",
    "cherry": "#CF0234",
    "cherry red": "#F7022A",
    "chestnut": "#742802",
    "chocolate": "#3D1C02",
    "chocolate brown": "#411900",
    "cinnamon": "#AC4F06",
    "claret": "#680018",
    "clay": "#B66A50",
    "clay brown": "#B2713D",
    "clear blue": "#247AFD",
    "cloudy blue": "#ACC2D9",
    "cobalt": "#1E488F",
    "cobalt blue": "#030AA7",
    "cocoa": "#875F42",
    "coffee": "#A6814C",
    "cool blue": "#4984B8",
    "cool green": "#33B864",
    "cool grey": "#95A3A6",
    "copper": "#B66325",
    "coral": "#FC5A50",
    "coral pink": "#FF6163",
    "cornflower": "#6A79F7",
    "cornflower blue": "#5170D7",
    "cranberry": "#9E003A",
    "cream": "#FFFFC2",
    "creme": "#FFFFB6",
    "crimson": "#8C000F",
    "custard": "#FFFD78",
    "cyan": "#00FFFF",
    "dandelion": "#FEDF08",
    "dark": "#1B2431",
    "dark aqua": "#05696B",
    "dark aquamarine": "#017371",
    "dark beige": "#AC9362",
    "dark blue": "#00035B",
    "dark blue green": "#005249",
    "dark blue grey": "#1F3B4D",
    "dark brown": "#341C02",
    "dark coral": "#CF524E",
    "dark cream": "#FFF39A",
    "dark cyan": "#0A888A",
    "dark forest green": "#002D04",
    "dark fuchsia": "#9D0759",
    "dark gold": "#B59410",
    "dark grass green": "#388004",
    "dark green": "#033500",
    "dark green blue": "#1F6357",
    "dark grey": "#363737",
    "dark grey blue": "#29465B",
    "dark hot pink": "#D90166",
    "dark indigo": "#1F0954",
    "dark khaki": "#9B8F55",
    "dark lavender": "#856798",
    "dark lilac": "#9C6DA5",
    "dark lime": "#84B701",
    "dark lime green": "#7EBD01",
    "dark magenta": "#960056",
    "dark maroon": "#3C0008",
    "dark mauve": "#874C62",
    "dark mint": "#48C072",
    "dark mint green": "#20C073",
    "dark mustard": "#A88905",
    "dark navy": "#000435",
    "dark navy blue": "#00022E",
    "dark olive": "#373E02",
    "dark olive green": "#3C4D03",
    "dark orange": "#C65102",
    "dark pastel green": "#56AE57",
    "dark peach": "#DE7E5D",
    "dark periwinkle": "#665FD1",
    "dark pink": "#CB416B",
    "dark plum": "#3F012C",
    "dark purple": "#35063E",
    "dark red": "#840000",
    "dark rose": "#B5485D",
    "dark royal blue": "#02066F",
    "dark sage": "#598556",
    "dark salmon": "#C85A53",
    "dark sand": "#A88F59",
    "dark sea green": "#11875D",
    "dark seafoam": "#1FB57A",
    "dark seafoam green": "#3EAF76",
    "dark sky blue": "#448EE4",
    "dark slate blue": "#214761",
    "dark tan": "#AF884A",
    "dark taupe": "#7F684E",
    "dark teal": "#014D4E",
    "dark turquoise": "#045C5A",
    "dark violet": "#34013F",
    "dark yellow": "#D5B60A",
    "dark yellow green": "#728F02",
    "darkblue": "#030764",
    "darkgreen": "#054907",
    "darkish blue": "#014182",
    "darkish green": "#287C37",
    "darkish pink": "#DA467D",
    "darkish purple": "#751973",
    "darkish red": "#A90308",
    "deep aqua": "#08787F",
    "deep blue": "#040273",
    "deep brown": "#410200",
    "deep green": "#02590F",
    "deep lavender": "#8D5EB7",
    "deep lilac": "#966EBD",
    "deep magenta": "#A0025C",
    "deep orange": "#DC4D01",
    "deep pink": "#CB0162",
    "deep purple": "#36013F",
    "deep red": "#9A0200",
    "deep rose": "#C74767",
    "deep sea blue": "#015482",
    "deep sky blue": "#0D75F8",
    "deep teal": "#00555A",
    "deep turquoise": "#017374",
    "deep violet": "#490648",
    "denim": "#3B638C",
    "denim blue": "#3B5B92",
    "desert": "#CCAD60",
    "diarrhea": "#9F8303",
    "dirt": "#8A6E45",
    "dirt brown": "#836539",
    "dirty blue": "#3F829D",
    "dirty green": "#667E2C",
    "dirty orange": "#C87606",
    "dirty pink": "#CA7B80",
    "dirty purple": "#734A65",
    "dirty yellow": "#CDC50A",
    "dodger blue": "#3E82FC",
    "drab": "#828344",
    "drab green": "#749551",
    "dried blood": "#4B0101",
    "duck egg blue": "#C3FBF4",
    "dull blue": "#49759C",
    "dull brown": "#876E4B",
    "dull green": "#74A662",
    "dull orange": "#D8863B",
    "dull pink": "#D5869D",
    "dull purple": "#84597E",
    "dull red": "#BB3F3F",
    "dull teal": "#5F9E8F",
    "dull yellow": "#EEDC5B",
    "dusk": "#4E5481",
    "dusk blue": "#26538D",
    "dusky blue": "#475F94",
    "dusky pink": "#CC7A8B",
    "dusky purple": "#895B7B",
    "dusky rose": "#BA6873",
    "dust": "#B2996E",
    "dusty blue": "#5A86AD",
    "dusty green": "#76A973",
    "dusty lavender": "#AC86A8",
    "dusty orange": "#F0833A",
    "dusty pink": "#D58A94",
    "dusty purple": "#825F87",
    "dusty red": "#B9484E",
    "dusty rose": "#C0737A",
    "dusty teal": "#4C9085",
    "earth": "#A2653E",
    "easter green": "#8CFD7E",
    "easter purple": "#C071FE",
    "ecru": "#FEFFCA",
    "egg shell": "#FFFCC4",
    "eggplant": "#380835",
    "eggplant purple": "#430541",
    "eggshell": "#FFFFD4",
    "eggshell blue": "#C4FFF7",
    "electric blue": "#0652FF",
    "electric green": "#21FC0D",
    "electric lime": "#A8FF04",
    "electric pink": "#FF0490",
    "electric purple": "#AA23FF",
    "emerald": "#01A049",
    "emerald green": "#028F1E",
    "evergreen": "#05472A",
    "faded blue": "#658CBB",
    "faded green": "#7BB274",
    "faded orange": "#F0944D",
    "faded pink": "#DE9DAC",
    "faded purple": "#916E99",
    "faded red": "#D3494E",
    "faded yellow": "#FEFF7F",
    "fawn": "#CFAF7B",
    "fern": "#63A950",
    "fern green": "#548D44",
    "fire engine red": "#FE0002",
    "flat blue": "#3C73A8",
    "flat green": "#699D4C",
    "fluorescent green": "#08FF08",
    "fluro green": "#0AFF02",
    "foam green": "#90FDA9",
    "forest": "#0B5509",
    "forest green": "#06470C",
    "forrest green": "#154406",
    "french blue": "#436BAD",
    "fresh green": "#69D84F",
    "frog green": "#58BC08",
    "fuchsia": "#ED0DD9",
    "gold": "#DBB40C",
    "golden": "#F5BF03",
    "golden brown": "#B27A01",
    "golden rod": "#F9BC08",
    "golden yellow": "#FEC615",
    "goldenrod": "#FAC205",
    "grape": "#6C3461",
    "grape purple": "#5D1451",
    "grapefruit": "#FD5956",
    "grass": "#5CAC2D",
    "grass green": "#3F9B0B",
    "grassy green": "#419C03",
    "green": "#15B01A",
    "green apple": "#5EDC1F",
    "green blue": "#06B48B",
    "green brown": "#544E03",
    "green grey": "#77926F",
    "green teal": "#0CB577",
    "green yellow": "#C9FF27",
    "green/blue": "#01C08D",
    "green/yellow": "#B5CE08",
    "greenblue": "#23C48B",
    "greenish": "#40A368",
    "greenish beige": "#C9D179",
    "greenish blue": "#0B8B87",
    "greenish brown": "#696112",
    "greenish cyan": "#2AFEB7",
    "greenish grey": "#96AE8D",
    "greenish tan": "#BCCB7A",
    "greenish teal": "#32BF84",
    "greenish turquoise": "#00FBB0",
    "greenish yellow": "#CDFD02",
    "greeny blue": "#42B395",
    "greeny brown": "#696006",
    "greeny grey": "#7EA07A",
    "greeny yellow": "#C6F808",
    "grey": "#929591",
    "grey blue": "#6B8BA4",
    "grey brown": "#7F7053",
    "grey green": "#789B73",
    "grey pink": "#C3909B",
    "grey purple": "#826D8C",
    "grey teal": "#5E9B8A",
    "grey/blue": "#647D8E",
    "grey/green": "#86A17D",
    "greyblue": "#77A1B5",
    "greyish": "#A8A495",
    "greyish blue": "#5E819D",
    "greyish brown": "#7A6A4F",
    "greyish green": "#82A67D",
    "greyish pink": "#C88D94",
    "greyish purple": "#887191",
    "greyish teal": "#719F91",
    "gross green": "#A0BF16",
    "gunmetal": "#536267",
    "hazel": "#8E7618",
    "heather": "#A484AC",
    "heliotrope": "#D94FF5",
    "highlighter green": "#1BFC06",
    "hospital green": "#9BE5AA",
    "hot green": "#25FF29",
    "hot magenta": "#F504C9",
    "hot pink": "#FF028D",
    "hot purple": "#CB00F5",
    "hunter green": "#0B4008",
    "ice": "#D6FFFA",
    "ice blue": "#D7FFFE",
    "icky green": "#8FAE22",
    "indian red": "#850E04",
    "indigo": "#380282",
    "indigo blue": "#3A18B1",
    "iris": "#6258C4",
    "irish green": "#019529",
    "ivory": "#FFFFCB",
    "jade": "#1FA774",
    "jade green": "#2BAF6A",
    "jungle green": "#048243",
    "kelley green": "#009337",
    "kelly green": "#02AB2E",
    "kermit green": "#5CB200",
    "key lime": "#AEFF6E",
    "khaki": "#AAA662",
    "khaki green": "#728639",
    "kiwi": "#9CEF43",
    "kiwi green": "#8EE53F",
    "lavender": "#C79FEF",
    "lavender blue": "#8B88F8",
    "lavender pink": "#DD85D7",
    "lawn green": "#4DA409",
    "leaf": "#71AA34",
    "leaf green": "#5CA904",
    "leafy green": "#51B73B",
    "leather": "#AC7434",
    "lemon": "#FDFF52",
    "lemon green": "#ADF802",
    "lemon lime": "#BFFE28",
    "lemon yellow": "#FDFF38",
    "lichen": "#8FB67B",
    "light aqua": "#8CFFDB",
    "light aquamarine": "#7BFDC7",
    "light beige": "#FFFEB6",
    "light blue": "#95D0FC",
    "light blue green": "#7EFBB3",
    "light blue grey": "#B7C9E2",
    "light bluish green": "#76FDA8",
    "light bright green": "#53FE5C",
    "light brown": "#AD8150",
    "light burgundy": "#A8415B",
    "light cyan": "#ACFFFC",
    "light eggplant": "#894585",
    "light forest green": "#4F9153",
    "light gold": "#FDDC5C",
    "light grass green": "#9AF764",
    "light green": "#96F97B",
    "light green blue": "#56FCA2",
    "light greenish blue": "#63F7B4",
    "light grey": "#D8DCD6",
    "light grey blue": "#9DBCD4",
    "light grey green": "#B7E1A1",
    "light indigo": "#6D5ACF",
    "light khaki": "#E6F2A2",
    "light lavendar": "#EFC0FE",
    "light lavender": "#DFC5FE",
    "light light blue": "#CAFFFB",
    "light light green": "#C8FFB0",
    "light lilac": "#EDC8FF",
    "light lime": "#AEFD6C",
    "light lime green": "#B9FF66",
    "light magenta": "#FA5FF7",
    "light maroon": "#A24857",
    "light mauve": "#C292A1",
    "light mint": "#B6FFBB",
    "light mint green": "#A6FBB2",
    "light moss green": "#A6C875",
    "light mustard": "#F7D560",
    "light navy": "#155084",
    "light navy blue": "#2E5A88",
    "light neon green": "#4EFD54",
    "light olive": "#ACBF69",
    "light olive green": "#A4BE5C",
    "light orange": "#FDAA48",
    "light pastel green": "#B2FBA5",
    "light pea green": "#C4FE82",
    "light peach": "#FFD8B1",
    "light periwinkle": "#C1C6FC",
    "light pink": "#FFD1DF",
    "light plum": "#9D5783",
    "light purple": "#BF77F6",
    "light red": "#FF474C",
    "light rose": "#FFC5CB",
    "light royal blue": "#3A2EFE",
    "light sage": "#BCECAC",
    "light salmon": "#FEA993",
    "light sea green": "#98F6B0",
    "light seafoam": "#A0FEBF",
    "light seafoam green": "#A7FFB5",
    "light sky blue": "#C6FCFF",
    "light tan": "#FBEEAC",
    "light teal": "#90E4C1",
    "light turquoise": "#7EF4CC",
    "light urple": "#B36FF6",
    "light violet": "#D6B4FC",
    "light yellow": "#FFFE7A",
    "light yellow green": "#CCFD7F",
    "light yellowish green": "#C2FF89",
    "lightblue": "#7BC8F6",
    "lighter green": "#75FD63",
    "lighter purple": "#A55AF4",
    "lightgreen": "#76FF7B",
    "lightish blue": "#3D7AFD",
    "lightish green": "#61E160",
    "lightish purple": "#A552E6",
    "lightish red": "#FE2F4A",
    "lilac": "#CEA2FD",
    "liliac": "#C48EFD",
    "lime": "#AAFF32",
    "lime green": "#89FE05",
    "lime yellow": "#D0FE1D",
    "lipstick": "#D5174E",
    "lipstick red": "#C0022F",
    "macaroni and cheese": "#EFB435",
    "magenta": "#C20078",
    "mahogany": "#4A0100",
    "maize": "#F4D054",
    "mango": "#FFA62B",
    "manilla": "#FFFA86",
    "marigold": "#FCC006",
    "marine": "#042E60",
    "marine blue": "#01386A",
    "maroon": "#650021",
    "mauve": "#AE7181",
    "medium blue": "#2C6FBB",
    "medium brown": "#7F5112",
    "medium green": "#39AD48",
    "medium grey": "#7D7F7C",
    "medium pink": "#F36196",
    "medium purple": "#9E43A2",
    "melon": "#FF7855",
    "merlot": "#730039",
    "metallic blue": "#4F738E",
    "mid blue": "#276AB3",
    "mid green": "#50A747",
    "midnight": "#03012D",
    "midnight blue": "#020035",
    "midnight purple": "#280137",
    "military green": "#667C3E",
    "milk chocolate": "#7F4E1E",
    "mint": "#9FFEB0",
    "mint green": "#8FFF9F",
    "minty green": "#0BF77D",
    "mocha": "#9D7651",
    "moss": "#769958",
    "moss green": "#658B38",
    "mossy green": "#638B27",
    "mud": "#735C12",
    "mud brown": "#60460F",
    "mud green": "#606602",
    "muddy brown": "#886806",
    "muddy green": "#657432",
    "muddy yellow": "#BFAC05",
    "mulberry": "#920A4E",
    "murky green": "#6C7A0E",
    "mushroom": "#BA9E88",
    "mustard": "#CEB301",
    "mustard brown": "#AC7E04",
    "mustard green": "#A8B504",
    "mustard yellow": "#D2BD0A",
    "muted blue": "#3B719F",
    "muted green": "#5FA052",
    "muted pink": "#D1768F",
    "muted purple": "#805B87",
    "nasty green": "#70B23F",
    "navy": "#01153E",
    "navy blue": "#001146",
    "navy green": "#35530A",
    "neon blue": "#04D9FF",
    "neon green": "#0CFF0C",
    "neon pink": "#FE019A",
    "neon purple": "#BC13FE",
    "neon red": "#FF073A",
    "neon yellow": "#CFFF04",
    "nice blue": "#107AB0",
    "night blue": "#040348",
    "ocean": "#017B92",
    "ocean blue": "#03719C",
    "ocean green": "#3D9973",
    "ocher": "#BF9B0C",
    "ochre": "#BF9005",
    "ocre": "#C69C04",
    "off blue": "#5684AE",
    "off green": "#6BA353",
    "off white": "#FFFFE4",
    "off yellow": "#F1F33F",
    "old pink": "#C77986",
    "old rose": "#C87F89",
    "olive": "#6E750E",
    "olive brown": "#645403",
    "olive drab": "#6F7632",
    "olive green": "#677A04",
    "olive yellow": "#C2B709",
    "orange": "#F97306",
    "orange brown": "#BE6400",
    "orange pink": "#FF6F52",
    "orange red": "#FD411E",
    "orange yellow": "#FFAD01",
    "orangeish": "#FD8D49",
    "orangered": "#FE420F",
    "orangey brown": "#B16002",
    "orangey red": "#FA4224",
    "orangey yellow": "#FDB915",
    "orangish": "#FC824A",
    "orangish brown": "#B25F03",
    "orangish red": "#F43605",
    "orchid": "#C875C4",
    "pale": "#FFF9D0",
    "pale aqua": "#B8FFEB",
    "pale blue": "#D0FEFE",
    "pale brown": "#B1916E",
    "pale cyan": "#B7FFFA",
    "pale gold": "#FDDE6C",
    "pale green": "#C7FDB5",
    "pale grey": "#FDFDFE",
    "pale lavender": "#EECFFE",
    "pale light green": "#B1FC99",
    "pale lilac": "#E4CBFF",
    "pale lime": "#BEFD73",
    "pale lime green": "#B1FF65",
    "pale magenta": "#D767AD",
    "pale mauve": "#FED0FC",
    "pale olive": "#B9CC81",
    "pale olive green": "#B1D27B",
    "pale orange": "#FFA756",
    "pale peach": "#FFE5AD",
    "pale pink": "#FFCFDC",
    "pale purple": "#B790D4",
    "pale red": "#D9544D",
    "pale rose": "#FDC1C5",
    "pale salmon": "#FFB19A",
    "pale sky blue": "#BDF6FE",
    "pale teal": "#82CBB2",
    "pale turquoise": "#A5FBD5",
    "pale violet": "#CEAEFA",
    "pale yellow": "#FFFF84",
    "parchment": "#FEFCAF",
    "pastel blue": "#A2BFFE",
    "pastel green": "#B0FF9D",
    "pastel orange": "#FF964F",
    "pastel pink": "#FFBACD",
    "pastel purple": "#CAA0FF",
    "pastel red": "#DB5856",
    "pastel yellow": "#FFFE71",
    "pea": "#A4BF20",
    "pea green": "#8EAB12",
    "pea soup": "#929901",
    "pea soup green": "#94A617",
    "peach": "#FFB07C",
    "peachy pink": "#FF9A8A",
    "peacock blue": "#016795",
    "pear": "#CBF85F",
    "periwinkle": "#8E82FE",
    "periwinkle blue": "#8F99FB",
    "perrywinkle": "#8F8CE7",
    "petrol": "#005F6A",
    "pig pink": "#E78EA5",
    "pine": "#2B5D34",
    "pine green": "#0A481E",
    "pink": "#FF81C0",
    "pink purple": "#DB4BDA",
    "pink red": "#F5054F",
    "pink/purple": "#EF1DE7",
    "pinkish": "#D46A7E",
    "pinkish brown": "#B17261",
    "pinkish grey": "#C8ACA9",
    "pinkish orange": "#FF724C",
    "pinkish purple": "#D648D7",
    "pinkish red": "#F10C45",
    "pinkish tan": "#D99B82",
    "pinky": "#FC86AA",
    "pinky purple": "#C94CBE",
    "pinky red": "#FC2647",
    "piss yellow": "#DDD618",
    "pistachio": "#C0FA8B",
    "plum": "#580F41",
    "plum purple": "#4E0550",
    "poison green": "#40FD14",
    "poo": "#8F7303",
    "poo brown": "#885F01",
    "poop": "#7F5E00",
    "poop brown": "#7A5901",
    "poop green": "#6F7C00",
    "powder blue": "#B1D1FC",
    "powder pink": "#FFB2D0",
    "primary blue": "#0804F9",
    "prussian blue": "#004577",
    "puce": "#A57E52",
    "puke": "#A5A502",
    "puke brown": "#947706",
    "puke green": "#9AAE07",
    "puke yellow": "#C2BE0E",
    "pumpkin": "#E17701",
    "pumpkin orange": "#FB7D07",
    "pure blue": "#0203E2",
    "purple": "#7E1E9C",
    "purple blue": "#632DE9",
    "purple brown": "#673A3F",
    "purple grey": "#866F85",
    "purple pink": "#E03FD8",
    "purple red": "#990147",
    "purple/blue": "#5D21D0",
    "purple/pink": "#D725DE",
    "purpleish": "#98568D",
    "purpleish blue": "#6140EF",
    "purpleish pink": "#DF4EC8",
    "purpley": "#8756E4",
    "purpley blue": "#5F34E7",
    "purpley grey": "#947E94",
    "purpley pink": "#C83CB9",
    "purplish": "#94568C",
    "purplish blue": "#601EF9",
    "purplish brown": "#6B4247",
    "purplish grey": "#7A687F",
    "purplish pink": "#CE5DAE",
    "purplish red": "#B0054B",
    "purply": "#983FB2",
    "purply blue": "#661AEE",
    "purply pink": "#F075E6",
    "putty": "#BEAE8A",
    "racing green": "#014600",
    "radioactive green": "#2CFA1F",
    "raspberry": "#B00149",
    "raw sienna": "#9A6200",
    "raw umber": "#A75E09",
    "really light blue": "#D4FFFF",
    "red": "#E50000",
    "red brown": "#8B2E16",
    "red orange": "#FD3C06",
    "red pink": "#FA2A55",
    "red purple": "#820747",
    "red violet": "#9E0168",
    "red wine": "#8C0034",
    "reddish": "#C44240",
    "reddish brown": "#7F2B0A",
    "reddish grey": "#997570",
    "reddish orange": "#F8481C",
    "reddish pink": "#FE2C54",
    "reddish purple": "#910951",
    "reddy brown": "#6E1005",
    "rich blue": "#021BF9",
    "rich purple": "#720058",
    "robin egg blue": "#8AF1FE",
    "robin's egg": "#6DEDFD",
    "robin's egg blue": "#98EFF9",
    "rosa": "#FE86A4",
    "rose": "#CF6275",
    "rose pink": "#F7879A",
    "rose red": "#BE013C",
    "rosy pink": "#F6688E",
    "rouge": "#AB1239",
    "royal": "#0C1793",
    "royal blue": "#0504AA",
    "royal purple": "#4B006E",
    "ruby": "#CA0147",
    "russet": "#A13905",
    "rust": "#A83C09",
    "rust brown": "#8B3103",
    "rust orange": "#C45508",
    "rust red": "#AA2704",
    "rusty orange": "#CD5909",
    "rusty red": "#AF2F0D",
    "saffron": "#FEB209",
    "sage": "#87AE73",
    "sage green": "#88B378",
    "salmon": "#FF796C",
    "salmon pink": "#FE7B7C",
    "sand": "#E2CA76",
    "sand brown": "#CBA560",
    "sand yellow": "#FCE166",
    "sandstone": "#C9AE74",
    "sandy": "#F1DA7A",
    "sandy brown": "#C4A661",
    "sandy yellow": "#FDEE73",
    "sap green": "#5C8B15",
    "sapphire": "#2138AB",
    "scarlet": "#BE0119",
    "sea": "#3C9992",
    "sea blue": "#047495",
    "sea green": "#53FCA1",
    "seafoam": "#80F9AD",
    "seafoam blue": "#78D1B6",
    "seafoam green": "#7AF9AB",
    "seaweed": "#18D17B",
    "seaweed green": "#35AD6B",
    "sepia": "#985E2B",
    "shamrock": "#01B44C",
    "shamrock green": "#02C14D",
    "shit": "#7F5F00",
    "shit brown": "#7B5804",
    "shit green": "#758000",
    "shocking pink": "#FE02A2",
    "sick green": "#9DB92C",
    "sickly green": "#94B21C",
    "sickly yellow": "#D0E429",
    "sienna": "#A9561E",
    "silver": "#C5C9C7",
    "sky": "#82CAFC",
    "sky blue": "#75BBFD",
    "slate": "#516572",
    "slate blue": "#5B7C99",
    "slate green": "#658D6D",
    "slate grey": "#59656D",
    "slime green": "#99CC04",
    "snot": "#ACBB0D",
    "snot green": "#9DC100",
    "soft blue": "#6488EA",
    "soft green": "#6FC276",
    "soft pink": "#FDB0C0",
    "soft purple": "#A66FB5",
    "spearmint": "#1EF876",
    "spring green": "#A9F971",
    "spruce": "#0A5F38",
    "squash": "#F2AB15",
    "steel": "#738595",
    "steel blue": "#5A7D9A",
    "steel grey": "#6F828A",
    "stone": "#ADA587",
    "stormy blue": "#507B9C",
    "straw": "#FCF679",
    "strawberry": "#FB2943",
    "strong blue": "#0C06F7",
    "strong pink": "#FF0789",
    "sun yellow": "#FFDF22",
    "sunflower": "#FFC512",
    "sunflower yellow": "#FFDA03",
    "sunny yellow": "#FFF917",
    "sunshine yellow": "#FFFD37",
    "swamp": "#698339",
    "swamp green": "#748500",
    "tan": "#D1B26F",
    "tan brown": "#AB7E4C",
    "tan green": "#A9BE70",
    "tangerine": "#FF9408",
    "taupe": "#B9A281",
    "tea": "#65AB7C",
    "tea green": "#BDF8A3",
    "teal": "#029386",
    "teal blue": "#01889F",
    "teal green": "#25A36F",
    "tealish": "#24BCA8",
    "tealish green": "#0CDC73",
    "terra cotta": "#C9643B",
    "terracota": "#CB6843",
    "terracotta": "#CA6641",
    "tiffany blue": "#7BF2DA",
    "tomato": "#EF4026",
    "tomato red": "#EC2D01",
    "topaz": "#13BBAF",
    "toupe": "#C7AC7D",
    "toxic green": "#61DE2A",
    "tree green": "#2A7E19",
    "true blue": "#010FCC",
    "true green": "#089404",
    "turquoise": "#06C2AC",
    "turquoise blue": "#06B1C4",
    "turquoise green": "#04F489",
    "turtle green": "#75B84F",
    "twilight": "#4E518B",
    "twilight blue": "#0A437A",
    "ugly blue": "#31668A",
    "ugly brown": "#7D7103",
    "ugly green": "#7A9703",
    "ugly pink": "#CD7584",
    "ugly purple": "#A442A0",
    "ugly yellow": "#D0C101",
    "ultramarine": "#2000B1",
    "ultramarine blue": "#1805DB",
    "umber": "#B26400",
    "velvet": "#750851",
    "vermillion": "#F4320C",
    "very dark blue": "#000133",
    "very dark brown": "#1D0200",
    "very dark green": "#062E03",
    "very dark purple": "#2A0134",
    "very light blue": "#D5FFFF",
    "very light brown": "#D3B683",
    "very light green": "#D1FFBD",
    "very light pink": "#FFF4F2",
    "very light purple": "#F6CEFC",
    "very pale blue": "#D6FFFE",
    "very pale green": "#CFFDBC",
    "vibrant blue": "#0339F8",
    "vibrant green": "#0ADD08",
    "vibrant purple": "#AD03DE",
    "violet": "#9A0EEA",
    "violet blue": "#510AC9",
    "violet pink": "#FB5FFC",
    "violet red": "#A50055",
    "viridian": "#1E9167",
    "vivid blue": "#152EFF",
    "vivid green": "#2FEF10",
    "vivid purple": "#9900FA",
    "vomit": "#A2A415",
    "vomit green": "#89A203",
    "vomit yellow": "#C7C10C",
    "warm blue": "#4B57DB",
    "warm brown": "#964E02",
    "warm grey": "#978A84",
    "warm pink": "#FB5581",
    "warm purple": "#952E8F",
    "washed out green": "#BCF5A6",
    "water blue": "#0E87CC",
    "watermelon": "#FD4659",
    "weird green": "#3AE57F",
    "wheat": "#FBDD7E",
    "white": "#FFFFFF",
    "windows blue": "#3778BF",
    "wine": "#80013F",
    "wine red": "#7B0323",
    "wintergreen": "#20F986",
    "wisteria": "#A87DC2",
    "yellow": "#FFFF14",
    "yellow brown": "#B79400",
    "yellow green": "#C0FB2D",
    "yellow ochre": "#CB9D06",
    "yellow orange": "#FCB001",
    "yellow tan": "#FFE36E",
    "yellow/green": "#C8FD3D",
    "yellowgreen": "#BBF90F",
    "yellowish": "#FAEE66",
    "yellowish brown": "#9B7A01",
    "yellowish green": "#B0DD16",
    "yellowish orange": "#FFAB0F",
    "yellowish tan": "#FCFC81",
    "yellowy brown": "#AE8B0C",
    "yellowy green": "#BFF128",
}

XKCD = {f"xkcd:{k}": v for k, v in XKCD.items()}

# Standard colors found in regular Crayola assortments from 1903 to
# the present
#
# Source: https://en.wikipedia.org/wiki/List_of_Crayola_crayon_colors

CRAYON = {
    "almond": "#EED9C4",
    "antique brass": "#C88A65",
    "apricot": "#FDD5B1",
    "aquamarine": "#95E0E8",
    "asparagus": "#7BA05B",
    "banana mania": "#FBE7B2",
    "beaver": "#926F5B",
    "bittersweet": "#FE6F5E",
    "black": "#000000",
    "blue (i)": "#4997D0",
    "blue (ii)": "#4570E6",
    "blue (iii)": "#0066FF",
    "blue bell": "#9999CC",
    "blue-gray": "#C8C8CD",
    "blue-green": "#0095B7",
    "blue-violet": "#6456B7",
    "blush": "#DB5079",
    "brick red": "#C62D42",
    "brilliant rose": "#E667CE",
    "brown": "#AF593E",
    "burnt orange": "#FF7F49",
    "burnt sienna": "#E97451",
    "burnt umber": "#805533",
    "cadet blue": "#A9B2C3",
    "canary": "#FFFF99",
    "caribbean green": "#00CC99",
    "carmine": "#E62E6B",
    "carnation pink": "#FFA6C9",
    "celestial blue": "#7070CC",
    "cerise": "#DA3287",
    "cerulean": "#02A4D3",
    "cerulean blue": "#339ACC",
    "charcoal gray": "#736A62",
    "cobalt blue": "#8C90C8",
    "copper": "#DA8A67",
    "cornflower": "#93CCEA",
    "cotton candy": "#FFB7D5",
    "dandelion": "#FED85D",
    "dark venetian red": "#B33B24",
    "denim": "#1560BD",
    "desert sand": "#EDC9AF",
    "eggplant": "#614051",
    "english vermilion": "#CC474B",
    "fern": "#63B76C",
    "forest green": "#5FA777",
    "fuchsia": "#C154C1",
    "fuzzy wuzzy": "#87421F",
    "gold (i)": "#92926E",
    "gold (ii)": "#E6BE8A",
    "goldenrod": "#FCD667",
    "granny smith apple": "#9DE093",
    "gray": "#8B8680",
    "green": "#3AA655",
    "green-blue": "#2887C8",
    "green-yellow": "#F1E788",
    "inchworm": "#AFE313",
    "indian red": "#B94E48",
    "indigo": "#4F69C6",
    "jazzberry jam": "#A50B5E",
    "jungle green": "#29AB87",
    "lavender (i)": "#BF8FCC",
    "lavender (ii)": "#FBAED2",
    "lemon yellow": "#FFFF9F",
    "light blue": "#8FD8D8",
    "light chrome green": "#BEE64B",
    "light venetian red": "#E6735C",
    "macaroni and cheese": "#FFB97B",
    "madder lake": "#CC3336",
    "magenta": "#F653A6",
    "mahogany": "#CA3435",
    "maize": "#F2C649",
    "manatee": "#8D90A1",
    "mango tango": "#E77200",
    "maroon": "#C32148",
    "mauvelous": "#F091A9",
    "maximum blue": "#47ABCC",
    "maximum blue green": "#30BFBF",
    "maximum blue purple": "#ACACE6",
    "maximum green": "#5E8C31",
    "maximum green yellow": "#D9E650",
    "maximum purple": "#733380",
    "maximum red": "#D92121",
    "maximum red purple": "#A63A79",
    "maximum yellow": "#FAFA37",
    "maximum yellow red": "#F2BA49",
    "medium chrome green": "#6CA67C",
    "medium rose": "#D96CBE",
    "medium violet": "#8F47B3",
    "melon": "#FEBAAD",
    "middle blue": "#7ED4E6",
    "middle blue green": "#8DD9CC",
    "middle blue purple": "#8B72BE",
    "middle green": "#4D8C57",
    "middle green yellow": "#ACBF60",
    "middle purple": "#D982B5",
    "middle red": "#E58E73",
    "middle red purple": "#A55353",
    "middle yellow": "#FFEB00",
    "middle yellow red": "#ECB176",
    "midnight blue": "#00468C",
    "mountain meadow": "#1AB385",
    "mulberry": "#C8509B",
    "navy blue": "#0066CC",
    "olive green": "#B5B35C",
    "orange": "#FF8833",
    "orange-red": "#FF5349",
    "orange-yellow": "#F8D568",
    "orchid": "#E29CD2",
    "outer space": "#2D383A",
    "pacific blue": "#009DC4",
    "peach": "#FFCBA4",
    "periwinkle": "#C3CDE6",
    "permanent geranium lake": "#E12C2C",
    "pig pink": "#FDD7E4",
    "pine green": "#01786F",
    "pink flamingo": "#FC74FD",
    "pink sherbert": "#F7A38E",
    "plum": "#8E3179",
    "purple heart": "#652DC1",
    "purple mountains' majesty": "#D6AEDD",
    "raw sienna": "#D27D46",
    "raw sienna (i)": "#E6BC5C",
    "raw umber": "#665233",
    "razzmatazz": "#E30B5C",
    "red": "#ED0A3F",
    "red-orange": "#FF681F",
    "red-violet": "#BB3385",
    "robin's egg blue": "#00CCCC",
    "royal purple": "#6B3FA0",
    "salmon": "#FF91A4",
    "scarlet": "#FD0E35",
    "sea green": "#93DFB8",
    "sepia": "#9E5B40",
    "shadow": "#837050",
    "shamrock": "#33CC99",
    "silver": "#C9C0BB",
    "sky blue": "#76D7EA",
    "spring green": "#ECEBBD",
    "sunset orange": "#FE4C40",
    "tan": "#D99A6C",
    "teal blue": "#008080",
    "thistle": "#EBB0D7",
    "tickle me pink": "#FC80A5",
    "timberwolf": "#D9D6CF",
    "tropical rain forest": "#00755E",
    "tumbleweed": "#DEA681",
    "turquoise blue": "#6CDAE7",
    "ultramarine blue": "#3F26BF",
    "van dyke brown": "#664228",
    "venetian red": "#CC553D",
    "violet (i)": "#732E6C",
    "violet (ii)": "#8359A3",
    "violet-blue": "#766EC8",
    "violet-red": "#F7468A",
    "vivid tangerine": "#FF9980",
    "vivid violet": "#803790",
    "white": "#FFFFFF",
    "wild blue yonder": "#7A89B8",
    "wild strawberry": "#FF3399",
    "wisteria": "#C9A0DC",
    "yellow": "#FBE870",
    "yellow-green": "#C5E17A",
    "yellow-orange": "#FFAE42",
}

CRAYON = {f"crayon:{k}": v for k, v in CRAYON.items()}
