from .. import palette
from .._palette import PaletteKind as pk

__all__ = [
    "Accent",
    "Dark2",
    "Paired",
    "Pastel1",
    "Pastel2",
    "Set1",
    "Set2",
    "Set3",
]

Accent = palette(
    name="Accent",
    min_colors=3,
    max_colors=8,
    swatches=[
        [(127, 201, 127), (190, 174, 212), (253, 192, 134)],
        [(127, 201, 127), (190, 174, 212), (253, 192, 134), (255, 255, 153)],
        [
            (127, 201, 127),
            (190, 174, 212),
            (253, 192, 134),
            (255, 255, 153),
            (56, 108, 176),
        ],
        [
            (127, 201, 127),
            (190, 174, 212),
            (253, 192, 134),
            (255, 255, 153),
            (56, 108, 176),
            (240, 2, 127),
        ],
        [
            (127, 201, 127),
            (190, 174, 212),
            (253, 192, 134),
            (255, 255, 153),
            (56, 108, 176),
            (240, 2, 127),
            (191, 91, 23),
        ],
        [
            (127, 201, 127),
            (190, 174, 212),
            (253, 192, 134),
            (255, 255, 153),
            (56, 108, 176),
            (240, 2, 127),
            (191, 91, 23),
            (102, 102, 102),
        ],
    ],
    kind=pk.qualitative,
)

Dark2 = palette(
    name="Dark2",
    min_colors=3,
    max_colors=8,
    swatches=[
        [(27, 158, 119), (217, 95, 2), (117, 112, 179)],
        [(27, 158, 119), (217, 95, 2), (117, 112, 179), (231, 41, 138)],
        [
            (27, 158, 119),
            (217, 95, 2),
            (117, 112, 179),
            (231, 41, 138),
            (102, 166, 30),
        ],
        [
            (27, 158, 119),
            (217, 95, 2),
            (117, 112, 179),
            (231, 41, 138),
            (102, 166, 30),
            (230, 171, 2),
        ],
        [
            (27, 158, 119),
            (217, 95, 2),
            (117, 112, 179),
            (231, 41, 138),
            (102, 166, 30),
            (230, 171, 2),
            (166, 118, 29),
        ],
        [
            (27, 158, 119),
            (217, 95, 2),
            (117, 112, 179),
            (231, 41, 138),
            (102, 166, 30),
            (230, 171, 2),
            (166, 118, 29),
            (102, 102, 102),
        ],
    ],
    kind=pk.qualitative,
)

Paired = palette(
    name="Paired",
    min_colors=3,
    max_colors=12,
    swatches=[
        [(166, 206, 227), (31, 120, 180), (178, 223, 138)],
        [(166, 206, 227), (31, 120, 180), (178, 223, 138), (51, 160, 44)],
        [
            (166, 206, 227),
            (31, 120, 180),
            (178, 223, 138),
            (51, 160, 44),
            (251, 154, 153),
        ],
        [
            (166, 206, 227),
            (31, 120, 180),
            (178, 223, 138),
            (51, 160, 44),
            (251, 154, 153),
            (227, 26, 28),
        ],
        [
            (166, 206, 227),
            (31, 120, 180),
            (178, 223, 138),
            (51, 160, 44),
            (251, 154, 153),
            (227, 26, 28),
            (253, 191, 111),
        ],
        [
            (166, 206, 227),
            (31, 120, 180),
            (178, 223, 138),
            (51, 160, 44),
            (251, 154, 153),
            (227, 26, 28),
            (253, 191, 111),
            (255, 127, 0),
        ],
        [
            (166, 206, 227),
            (31, 120, 180),
            (178, 223, 138),
            (51, 160, 44),
            (251, 154, 153),
            (227, 26, 28),
            (253, 191, 111),
            (255, 127, 0),
            (202, 178, 214),
        ],
        [
            (166, 206, 227),
            (31, 120, 180),
            (178, 223, 138),
            (51, 160, 44),
            (251, 154, 153),
            (227, 26, 28),
            (253, 191, 111),
            (255, 127, 0),
            (202, 178, 214),
            (106, 61, 154),
        ],
        [
            (166, 206, 227),
            (31, 120, 180),
            (178, 223, 138),
            (51, 160, 44),
            (251, 154, 153),
            (227, 26, 28),
            (253, 191, 111),
            (255, 127, 0),
            (202, 178, 214),
            (106, 61, 154),
            (255, 255, 153),
        ],
        [
            (166, 206, 227),
            (31, 120, 180),
            (178, 223, 138),
            (51, 160, 44),
            (251, 154, 153),
            (227, 26, 28),
            (253, 191, 111),
            (255, 127, 0),
            (202, 178, 214),
            (106, 61, 154),
            (255, 255, 153),
            (177, 89, 40),
        ],
    ],
    kind=pk.qualitative,
)

Pastel1 = palette(
    name="Pastel1",
    min_colors=3,
    max_colors=9,
    swatches=[
        [(251, 180, 174), (179, 205, 227), (204, 235, 197)],
        [(251, 180, 174), (179, 205, 227), (204, 235, 197), (222, 203, 228)],
        [
            (251, 180, 174),
            (179, 205, 227),
            (204, 235, 197),
            (222, 203, 228),
            (254, 217, 166),
        ],
        [
            (251, 180, 174),
            (179, 205, 227),
            (204, 235, 197),
            (222, 203, 228),
            (254, 217, 166),
            (255, 255, 204),
        ],
        [
            (251, 180, 174),
            (179, 205, 227),
            (204, 235, 197),
            (222, 203, 228),
            (254, 217, 166),
            (255, 255, 204),
            (229, 216, 189),
        ],
        [
            (251, 180, 174),
            (179, 205, 227),
            (204, 235, 197),
            (222, 203, 228),
            (254, 217, 166),
            (255, 255, 204),
            (229, 216, 189),
            (253, 218, 236),
        ],
        [
            (251, 180, 174),
            (179, 205, 227),
            (204, 235, 197),
            (222, 203, 228),
            (254, 217, 166),
            (255, 255, 204),
            (229, 216, 189),
            (253, 218, 236),
            (242, 242, 242),
        ],
    ],
    kind=pk.qualitative,
)

Pastel2 = palette(
    name="Pastel2",
    min_colors=3,
    max_colors=8,
    swatches=[
        [(179, 226, 205), (253, 205, 172), (203, 213, 232)],
        [(179, 226, 205), (253, 205, 172), (203, 213, 232), (244, 202, 228)],
        [
            (179, 226, 205),
            (253, 205, 172),
            (203, 213, 232),
            (244, 202, 228),
            (230, 245, 201),
        ],
        [
            (179, 226, 205),
            (253, 205, 172),
            (203, 213, 232),
            (244, 202, 228),
            (230, 245, 201),
            (255, 242, 174),
        ],
        [
            (179, 226, 205),
            (253, 205, 172),
            (203, 213, 232),
            (244, 202, 228),
            (230, 245, 201),
            (255, 242, 174),
            (241, 226, 204),
        ],
        [
            (179, 226, 205),
            (253, 205, 172),
            (203, 213, 232),
            (244, 202, 228),
            (230, 245, 201),
            (255, 242, 174),
            (241, 226, 204),
            (204, 204, 204),
        ],
    ],
    kind=pk.qualitative,
)

Set1 = palette(
    name="Set1",
    min_colors=3,
    max_colors=9,
    swatches=[
        [(228, 26, 28), (55, 126, 184), (77, 175, 74)],
        [(228, 26, 28), (55, 126, 184), (77, 175, 74), (152, 78, 163)],
        [
            (228, 26, 28),
            (55, 126, 184),
            (77, 175, 74),
            (152, 78, 163),
            (255, 127, 0),
        ],
        [
            (228, 26, 28),
            (55, 126, 184),
            (77, 175, 74),
            (152, 78, 163),
            (255, 127, 0),
            (255, 255, 51),
        ],
        [
            (228, 26, 28),
            (55, 126, 184),
            (77, 175, 74),
            (152, 78, 163),
            (255, 127, 0),
            (255, 255, 51),
            (166, 86, 40),
        ],
        [
            (228, 26, 28),
            (55, 126, 184),
            (77, 175, 74),
            (152, 78, 163),
            (255, 127, 0),
            (255, 255, 51),
            (166, 86, 40),
            (247, 129, 191),
        ],
        [
            (228, 26, 28),
            (55, 126, 184),
            (77, 175, 74),
            (152, 78, 163),
            (255, 127, 0),
            (255, 255, 51),
            (166, 86, 40),
            (247, 129, 191),
            (153, 153, 153),
        ],
    ],
    kind=pk.qualitative,
)

Set2 = palette(
    name="Set2",
    min_colors=3,
    max_colors=8,
    swatches=[
        [(102, 194, 165), (252, 141, 98), (141, 160, 203)],
        [(102, 194, 165), (252, 141, 98), (141, 160, 203), (231, 138, 195)],
        [
            (102, 194, 165),
            (252, 141, 98),
            (141, 160, 203),
            (231, 138, 195),
            (166, 216, 84),
        ],
        [
            (102, 194, 165),
            (252, 141, 98),
            (141, 160, 203),
            (231, 138, 195),
            (166, 216, 84),
            (255, 217, 47),
        ],
        [
            (102, 194, 165),
            (252, 141, 98),
            (141, 160, 203),
            (231, 138, 195),
            (166, 216, 84),
            (255, 217, 47),
            (229, 196, 148),
        ],
        [
            (102, 194, 165),
            (252, 141, 98),
            (141, 160, 203),
            (231, 138, 195),
            (166, 216, 84),
            (255, 217, 47),
            (229, 196, 148),
            (179, 179, 179),
        ],
    ],
    kind=pk.qualitative,
)

Set3 = palette(
    name="Set3",
    min_colors=3,
    max_colors=12,
    swatches=[
        [(141, 211, 199), (255, 255, 179), (190, 186, 218)],
        [(141, 211, 199), (255, 255, 179), (190, 186, 218), (251, 128, 114)],
        [
            (141, 211, 199),
            (255, 255, 179),
            (190, 186, 218),
            (251, 128, 114),
            (128, 177, 211),
        ],
        [
            (141, 211, 199),
            (255, 255, 179),
            (190, 186, 218),
            (251, 128, 114),
            (128, 177, 211),
            (253, 180, 98),
        ],
        [
            (141, 211, 199),
            (255, 255, 179),
            (190, 186, 218),
            (251, 128, 114),
            (128, 177, 211),
            (253, 180, 98),
            (179, 222, 105),
        ],
        [
            (141, 211, 199),
            (255, 255, 179),
            (190, 186, 218),
            (251, 128, 114),
            (128, 177, 211),
            (253, 180, 98),
            (179, 222, 105),
            (252, 205, 229),
        ],
        [
            (141, 211, 199),
            (255, 255, 179),
            (190, 186, 218),
            (251, 128, 114),
            (128, 177, 211),
            (253, 180, 98),
            (179, 222, 105),
            (252, 205, 229),
            (217, 217, 217),
        ],
        [
            (141, 211, 199),
            (255, 255, 179),
            (190, 186, 218),
            (251, 128, 114),
            (128, 177, 211),
            (253, 180, 98),
            (179, 222, 105),
            (252, 205, 229),
            (217, 217, 217),
            (188, 128, 189),
        ],
        [
            (141, 211, 199),
            (255, 255, 179),
            (190, 186, 218),
            (251, 128, 114),
            (128, 177, 211),
            (253, 180, 98),
            (179, 222, 105),
            (252, 205, 229),
            (217, 217, 217),
            (188, 128, 189),
            (204, 235, 197),
        ],
        [
            (141, 211, 199),
            (255, 255, 179),
            (190, 186, 218),
            (251, 128, 114),
            (128, 177, 211),
            (253, 180, 98),
            (179, 222, 105),
            (252, 205, 229),
            (217, 217, 217),
            (188, 128, 189),
            (204, 235, 197),
            (255, 237, 111),
        ],
    ],
    kind=pk.qualitative,
)
