# Building MPFR on Windows

This guide outlines the steps to build MPFR on Windows using MSVC and `conda build`. It also provides instructions for
updating the build process for future versions of MPFR.

---

## Overview

The process used to produce this CMake build is as follows:

1. Using a GitHub repository as the base ([gx/mpfr](https://github.com/gx/mpfr)).
2. Updating the source code to the desired version of MPFR. This was done by deleting all existing source and then
pasting downloaded source for the new version into the project.
3. Updating CMake files to account for the additions and deletions that were made between versions. `git` is useful here.
4. Extracting the CMake files into this feedstock to enable a conda-based build process.

---

## Updating for Future Versions

When new versions of MPFR are released:

1. Check a diff between the last version we built and the latest release.
2. Update the CMake configuration:
   - Source file lists in the CMake are named LIB\<libname\>_SOURCES and are typically identical to the lists found in
   each Makefile.in. For instance, `libmpfr` is comprised of sources from the `LIBMPFR_SOURCES` list and that list was
   populated from the `libmpfr_la_SOURCES` list found in `src/Makefile.in`.
3. Update the `src/config.h.in`:
   - Check for new tests that need to be run. This project supplies a `config.h.in` which mirrors the one generated by
   an autotools build. A diff between the `config.h` generated by a `./configure` run and the one output by cmake can
   highlight header, library, and function call checks that need to be added or removed between versions. These checks
   can be found in the top-level `CMakeLists.txt`.

---

## Troubleshooting

- Missing Source Files: If the build fails due to missing files, ensure all new source files are included in
CMakeLists.txt.
- Test Failures: Check the test outputs against the updated source and adjust the CMake configuration as needed.
- Build Errors: Verify that all dependencies are correctly specified in meta.yaml and that the environment is properly
set up.
