# This file is generated by numpy's build process
# It contains system_info results at the time of building this package.
from enum import Enum
from numpy._core._multiarray_umath import (
    __cpu_features__,
    __cpu_baseline__,
    __cpu_dispatch__,
)

__all__ = ["show_config"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return {k: _cleanup(v) for k, v in d.items() if v and _cleanup(v)}
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "14.3.0",
                "commands": r"/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_build_env/bin/aarch64-conda-linux-gnu-cc",
                "args": r"-ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -pipe, -isystem, /home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/include, -fdebug-prefix-map=/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/work=/usr/local/src/conda/numpy-base-2.4.1, -fdebug-prefix-map=/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/include",
                "linker args": r"-Wl,-O2, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -Wl,-rpath,/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/lib, -Wl,-rpath-link,/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/lib, -L/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/lib, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -pipe, -isystem, /home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/include, -fdebug-prefix-map=/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/work=/usr/local/src/conda/numpy-base-2.4.1, -fdebug-prefix-map=/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/include",
            },
            "cython": {
                "name": "cython",
                "linker": r"cython",
                "version": "3.2.2",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "14.3.0",
                "commands": r"/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_build_env/bin/aarch64-conda-linux-gnu-c++",
                "args": r"-fvisibility-inlines-hidden, -fmessage-length=0, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -pipe, -isystem, /home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/include, -fdebug-prefix-map=/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/work=/usr/local/src/conda/numpy-base-2.4.1, -fdebug-prefix-map=/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/include",
                "linker args": r"-Wl,-O2, -Wl,--sort-common, -Wl,--as-needed, -Wl,-z,relro, -Wl,-z,now, -Wl,-rpath,/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/lib, -Wl,-rpath-link,/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/lib, -L/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/lib, -fvisibility-inlines-hidden, -fmessage-length=0, -ftree-vectorize, -fPIC, -fstack-protector-strong, -fno-plt, -O2, -pipe, -isystem, /home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/include, -fdebug-prefix-map=/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/work=/usr/local/src/conda/numpy-base-2.4.1, -fdebug-prefix-map=/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_=/usr/local/src/conda-prefix, -DNDEBUG, -D_FORTIFY_SOURCE=2, -O2, -isystem, /home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/include",
            },
        },
        "Machine Information": {
            "host": {
                "cpu": "aarch64",
                "family": "aarch64",
                "endian": "little",
                "system": "linux",
            },
            "build": {
                "cpu": "aarch64",
                "family": "aarch64",
                "endian": "little",
                "system": "linux",
            },
            "cross-compiled": bool("False".lower().replace("false", "")),
        },
        "Build Dependencies": {
            "blas": {
                "name": "openblas",
                "found": bool("True".lower().replace("false", "")),
                "version": "0.3.30",
                "detection method": "pkgconfig",
                "include directory": r"/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/include",
                "lib directory": r"/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/lib",
                "openblas configuration": r"USE_64BITINT=0 DYNAMIC_ARCH=1 DYNAMIC_OLDER= NO_CBLAS= NO_LAPACK=0 NO_LAPACKE= NO_AFFINITY=1 USE_OPENMP=0 ARMV8 MAX_THREADS=128",
                "pc file directory": r"/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/lib/pkgconfig",
            },
            "lapack": {
                "name": "openblas",
                "found": bool("True".lower().replace("false", "")),
                "version": "0.3.30",
                "detection method": "pkgconfig",
                "include directory": r"/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/include",
                "lib directory": r"/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/lib",
                "openblas configuration": r"USE_64BITINT=0 DYNAMIC_ARCH=1 DYNAMIC_OLDER= NO_CBLAS= NO_LAPACK=0 NO_LAPACKE= NO_AFFINITY=1 USE_OPENMP=0 ARMV8 MAX_THREADS=128",
                "pc file directory": r"/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/lib/pkgconfig",
            },
        },
        "Python Information": {
            "path": r"/home/task_176837629155484/croot/numpy_and_numpy_base_1768376363025/_h_env_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_placehold_/bin/python",
            "version": "3.13",
        },
        "SIMD Extensions": {
            "baseline": __cpu_baseline__,
            "found": [
                feature for feature in __cpu_dispatch__ if __cpu_features__[feature]
            ],
            "not found": [
                feature for feature in __cpu_dispatch__ if not __cpu_features__[feature]
            ],
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which NumPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    See Also
    --------
    get_include : Returns the directory containing NumPy C
                  header files.

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )


def show_config(mode=DisplayModes.stdout.value):
    return show(mode)


show_config.__doc__ = show.__doc__
show_config.__module__ = "numpy"
