

set -ex



export PKG_CONFIG_PATH=$PREFIX/lib/pkgconfig
pkg-config --cflags opencv4
export LD_LIBRARY_PATH="${PREFIX}/${BUILD/conda_cos7/conda}/sysroot/usr/lib64:${LD_LIBRARY_PATH}"
python run_import_test.py
OPENCV_FLAGS=`pkg-config --cflags opencv4`
$CXX -std=c++11 test.cpp ${OPENCV_FLAGS} -o test
if [[ $(./test) != $PKG_VERSION ]]; then exit 1 ; fi
echo Testing for presence of alphamat
test -f $PREFIX/lib/libopencv_alphamat${SHLIB_EXT}
echo Found                   alphamat
echo Testing for presence of aruco
test -f $PREFIX/lib/libopencv_aruco${SHLIB_EXT}
echo Found                   aruco
echo Testing for presence of bgsegm
test -f $PREFIX/lib/libopencv_bgsegm${SHLIB_EXT}
echo Found                   bgsegm
echo Testing for presence of calib3d
test -f $PREFIX/lib/libopencv_calib3d${SHLIB_EXT}
echo Found                   calib3d
echo Testing for presence of ccalib
test -f $PREFIX/lib/libopencv_ccalib${SHLIB_EXT}
echo Found                   ccalib
echo Testing for presence of core
test -f $PREFIX/lib/libopencv_core${SHLIB_EXT}
echo Found                   core
echo Testing for presence of datasets
test -f $PREFIX/lib/libopencv_datasets${SHLIB_EXT}
echo Found                   datasets
echo Testing for presence of dnn_objdetect
test -f $PREFIX/lib/libopencv_dnn_objdetect${SHLIB_EXT}
echo Found                   dnn_objdetect
echo Testing for presence of dnn_superres
test -f $PREFIX/lib/libopencv_dnn_superres${SHLIB_EXT}
echo Found                   dnn_superres
echo Testing for presence of dnn
test -f $PREFIX/lib/libopencv_dnn${SHLIB_EXT}
echo Found                   dnn
echo Testing for presence of dpm
test -f $PREFIX/lib/libopencv_dpm${SHLIB_EXT}
echo Found                   dpm
echo Testing for presence of face
test -f $PREFIX/lib/libopencv_face${SHLIB_EXT}
echo Found                   face
echo Testing for presence of features2d
test -f $PREFIX/lib/libopencv_features2d${SHLIB_EXT}
echo Found                   features2d
echo Testing for presence of flann
test -f $PREFIX/lib/libopencv_flann${SHLIB_EXT}
echo Found                   flann
echo Testing for presence of fuzzy
test -f $PREFIX/lib/libopencv_fuzzy${SHLIB_EXT}
echo Found                   fuzzy
echo Testing for presence of gapi
test -f $PREFIX/lib/libopencv_gapi${SHLIB_EXT}
echo Found                   gapi
echo Testing for presence of hfs
test -f $PREFIX/lib/libopencv_hfs${SHLIB_EXT}
echo Found                   hfs
echo Testing for presence of highgui
test -f $PREFIX/lib/libopencv_highgui${SHLIB_EXT}
echo Found                   highgui
echo Testing for presence of img_hash
test -f $PREFIX/lib/libopencv_img_hash${SHLIB_EXT}
echo Found                   img_hash
echo Testing for presence of imgcodecs
test -f $PREFIX/lib/libopencv_imgcodecs${SHLIB_EXT}
echo Found                   imgcodecs
echo Testing for presence of imgproc
test -f $PREFIX/lib/libopencv_imgproc${SHLIB_EXT}
echo Found                   imgproc
echo Testing for presence of intensity_transform
test -f $PREFIX/lib/libopencv_intensity_transform${SHLIB_EXT}
echo Found                   intensity_transform
echo Testing for presence of line_descriptor
test -f $PREFIX/lib/libopencv_line_descriptor${SHLIB_EXT}
echo Found                   line_descriptor
echo Testing for presence of mcc
test -f $PREFIX/lib/libopencv_mcc${SHLIB_EXT}
echo Found                   mcc
echo Testing for presence of ml
test -f $PREFIX/lib/libopencv_ml${SHLIB_EXT}
echo Found                   ml
echo Testing for presence of objdetect
test -f $PREFIX/lib/libopencv_objdetect${SHLIB_EXT}
echo Found                   objdetect
echo Testing for presence of optflow
test -f $PREFIX/lib/libopencv_optflow${SHLIB_EXT}
echo Found                   optflow
echo Testing for presence of phase_unwrapping
test -f $PREFIX/lib/libopencv_phase_unwrapping${SHLIB_EXT}
echo Found                   phase_unwrapping
echo Testing for presence of photo
test -f $PREFIX/lib/libopencv_photo${SHLIB_EXT}
echo Found                   photo
echo Testing for presence of plot
test -f $PREFIX/lib/libopencv_plot${SHLIB_EXT}
echo Found                   plot
echo Testing for presence of quality
test -f $PREFIX/lib/libopencv_quality${SHLIB_EXT}
echo Found                   quality
echo Testing for presence of rapid
test -f $PREFIX/lib/libopencv_rapid${SHLIB_EXT}
echo Found                   rapid
echo Testing for presence of reg
test -f $PREFIX/lib/libopencv_reg${SHLIB_EXT}
echo Found                   reg
echo Testing for presence of rgbd
test -f $PREFIX/lib/libopencv_rgbd${SHLIB_EXT}
echo Found                   rgbd
echo Testing for presence of saliency
test -f $PREFIX/lib/libopencv_saliency${SHLIB_EXT}
echo Found                   saliency
echo Testing for presence of shape
test -f $PREFIX/lib/libopencv_shape${SHLIB_EXT}
echo Found                   shape
echo Testing for presence of stereo
test -f $PREFIX/lib/libopencv_stereo${SHLIB_EXT}
echo Found                   stereo
echo Testing for presence of stitching
test -f $PREFIX/lib/libopencv_stitching${SHLIB_EXT}
echo Found                   stitching
echo Testing for presence of structured_light
test -f $PREFIX/lib/libopencv_structured_light${SHLIB_EXT}
echo Found                   structured_light
echo Testing for presence of superres
test -f $PREFIX/lib/libopencv_superres${SHLIB_EXT}
echo Found                   superres
echo Testing for presence of surface_matching
test -f $PREFIX/lib/libopencv_surface_matching${SHLIB_EXT}
echo Found                   surface_matching
echo Testing for presence of text
test -f $PREFIX/lib/libopencv_text${SHLIB_EXT}
echo Found                   text
echo Testing for presence of tracking
test -f $PREFIX/lib/libopencv_tracking${SHLIB_EXT}
echo Found                   tracking
echo Testing for presence of video
test -f $PREFIX/lib/libopencv_video${SHLIB_EXT}
echo Found                   video
echo Testing for presence of videoio
test -f $PREFIX/lib/libopencv_videoio${SHLIB_EXT}
echo Found                   videoio
echo Testing for presence of videostab
test -f $PREFIX/lib/libopencv_videostab${SHLIB_EXT}
echo Found                   videostab
echo Testing for presence of wechat_qrcode
test -f $PREFIX/lib/libopencv_wechat_qrcode${SHLIB_EXT}
echo Found                   wechat_qrcode
echo Testing for presence of xfeatures2d
test -f $PREFIX/lib/libopencv_xfeatures2d${SHLIB_EXT}
echo Found                   xfeatures2d
echo Testing for presence of ximgproc
test -f $PREFIX/lib/libopencv_ximgproc${SHLIB_EXT}
echo Found                   ximgproc
echo Testing for presence of xobjdetect
test -f $PREFIX/lib/libopencv_xobjdetect${SHLIB_EXT}
echo Found                   xobjdetect
echo Testing for presence of xphoto
test -f $PREFIX/lib/libopencv_xphoto${SHLIB_EXT}
echo Found                   xphoto
echo Testing for presence of freetype
test -f $PREFIX/lib/libopencv_freetype${SHLIB_EXT}
echo Found                   freetype
test -f $PREFIX/lib/libopencv_bioinspired${SHLIB_EXT}
test -f $PREFIX/lib/libopencv_hdf${SHLIB_EXT}
mkdir -p cmake_build_test && pushd cmake_build_test
cmake -G "Ninja" ..
cmake --build . --config Release
popd
python run_py_test.py
if [[ $(python -c 'import cv2; print(cv2.__version__)') != $PKG_VERSION ]]; then exit 1; fi
python -c "import cv2; assert 'Unknown' not in cv2.videoio_registry.getBackendName(cv2.CAP_V4L)"
pip check
pip list
test $(pip list | grep opencv-python | wc -l) -eq 2
test $(pip list | grep opencv-python-headless | wc -l) -eq 1
exit 0
