"""`ft_html` and `ft_hx` functions to add some conveniences to `ft`, along with a full set of basic HTML components, and functions to work with forms and `FT` conversion"""
__all__ = ['named', 'html_attrs', 'hx_attrs', 'hx_evts', 'js_evts', 'hx_attrs_annotations', 'hx_evt_attrs', 'js_evt_attrs', 'evt_attrs', 'attrmap_x', 'ft_html', 'ft_hx', 'File', 'show', 'fill_form', 'fill_dataclass', 'find_inputs', 'html2ft', 'sse_message', 'A', 'Abbr', 'Address', 'Area', 'Article', 'Aside', 'Audio', 'B', 'Base', 'Bdi', 'Bdo', 'Blockquote', 'Body', 'Br', 'Button', 'Canvas', 'Caption', 'Cite', 'Code', 'Col', 'Colgroup', 'Data', 'Datalist', 'Dd', 'Del', 'Details', 'Dfn', 'Dialog', 'Div', 'Dl', 'Dt', 'Em', 'Embed', 'Fencedframe', 'Fieldset', 'Figcaption', 'Figure', 'Footer', 'Form', 'H1', 'H2', 'H3', 'H4', 'H5', 'H6', 'Head', 'Header', 'Hgroup', 'Hr', 'I', 'Iframe', 'Img', 'Input', 'Ins', 'Kbd', 'Label', 'Legend', 'Li', 'Link', 'Main', 'Map', 'Mark', 'Menu', 'Meta', 'Meter', 'Nav', 'Noscript', 'Object', 'Ol', 'Optgroup', 'Option', 'Output', 'P', 'Picture', 'PortalExperimental', 'Pre', 'Progress', 'Q', 'Rp', 'Rt', 'Ruby', 'S', 'Samp', 'Script', 'Search', 'Section', 'Select', 'Slot', 'Small', 'Source', 'Span', 'Strong', 'Style', 'Sub', 'Summary', 'Sup', 'Table', 'Tbody', 'Td', 'Template', 'Textarea', 'Tfoot', 'Th', 'Thead', 'Time', 'Title', 'Tr', 'Track', 'U', 'Ul', 'Var', 'Video', 'Wbr']
from dataclasses import dataclass, asdict, is_dataclass, make_dataclass, replace, astuple, MISSING
from bs4 import BeautifulSoup, Comment
from typing import Literal, Mapping, Optional
from fastcore.utils import *
from fastcore.xml import *
from fastcore.meta import use_kwargs, delegates
from fastcore.test import *
from .core import fh_cfg, unqid
import types, json
try:
    from IPython import display
except ImportError:
    display = None

@patch
def __str__(self: FT):
    ...

@patch
def __radd__(self: FT, b):
    ...

@patch
def __add__(self: FT, b):
    ...
named = set('a button form frame iframe img input map meta object param select textarea'.split())
html_attrs = 'id cls title style accesskey contenteditable dir draggable enterkeyhint hidden inert inputmode lang popover spellcheck tabindex translate'.split()
hx_attrs = 'get post put delete patch trigger target swap swap_oob include select select_oob indicator push_url confirm disable replace_url vals disabled_elt ext headers history history_elt indicator inherit params preserve prompt replace_url request sync validate'
hx_evts = 'abort afterOnLoad afterProcessNode afterRequest afterSettle afterSwap beforeCleanupElement beforeOnLoad beforeProcessNode beforeRequest beforeSwap beforeSend beforeTransition configRequest confirm historyCacheError historyCacheMiss historyCacheMissError historyCacheMissLoad historyRestore beforeHistorySave load noSSESourceError onLoadError oobAfterSwap oobBeforeSwap oobErrorNoTarget prompt pushedIntoHistory replacedInHistory responseError sendAbort sendError sseError sseOpen swapError targetError timeout validation:validate validation:failed validation:halted xhr:abort xhr:loadend xhr:loadstart xhr:progress'
js_evts = 'blur change contextmenu focus input invalid reset select submit keydown keypress keyup click dblclick mousedown mouseenter mouseleave mousemove mouseout mouseover mouseup wheel'
hx_attrs = [f'hx_{o}' for o in hx_attrs.split()]
hx_attrs_annotations = {'hx_swap': Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'] | str, 'hx_swap_oob': Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'] | str, 'hx_push_url': Literal['true', 'false'] | str, 'hx_replace_url': Literal['true', 'false'] | str, 'hx_disabled_elt': Literal['this', 'next', 'previous'] | str, 'hx_history': Literal['false'] | str, 'hx_params': Literal['*', 'none'] | str, 'hx_validate': Literal['true', 'false']}
hx_attrs_annotations |= {o: str for o in set(hx_attrs) - set(hx_attrs_annotations.keys())}
hx_attrs_annotations = {k: Optional[v] for k, v in hx_attrs_annotations.items()}
hx_attrs = html_attrs + hx_attrs
hx_evt_attrs = ['hx_on__' + camel2snake(o).replace(':', '_') for o in hx_evts.split()]
js_evt_attrs = ['hx_on_' + o for o in js_evts.split()]
evt_attrs = js_evt_attrs + hx_evt_attrs

def attrmap_x(o):
    ...
fh_cfg['attrmap'] = attrmap_x
fh_cfg['valmap'] = valmap
fh_cfg['ft_cls'] = FT
fh_cfg['auto_id'] = False
fh_cfg['auto_name'] = True

def ft_html(tag: str, *c, id=None, cls=None, title=None, style=None, attrmap=None, valmap=None, ft_cls=None, **kwargs):
    ...

@use_kwargs(hx_attrs + evt_attrs, keep=True)
def ft_hx(tag: str, *c, target_id=None, hx_vals=None, hx_target=None, **kwargs):
    ...
_g = globals()
_all_ = ['A', 'Abbr', 'Address', 'Area', 'Article', 'Aside', 'Audio', 'B', 'Base', 'Bdi', 'Bdo', 'Blockquote', 'Body', 'Br', 'Button', 'Canvas', 'Caption', 'Cite', 'Code', 'Col', 'Colgroup', 'Data', 'Datalist', 'Dd', 'Del', 'Details', 'Dfn', 'Dialog', 'Div', 'Dl', 'Dt', 'Em', 'Embed', 'Fencedframe', 'Fieldset', 'Figcaption', 'Figure', 'Footer', 'Form', 'H1', 'H2', 'H3', 'H4', 'H5', 'H6', 'Head', 'Header', 'Hgroup', 'Hr', 'I', 'Iframe', 'Img', 'Input', 'Ins', 'Kbd', 'Label', 'Legend', 'Li', 'Link', 'Main', 'Map', 'Mark', 'Menu', 'Meta', 'Meter', 'Nav', 'Noscript', 'Object', 'Ol', 'Optgroup', 'Option', 'Output', 'P', 'Picture', 'PortalExperimental', 'Pre', 'Progress', 'Q', 'Rp', 'Rt', 'Ruby', 'S', 'Samp', 'Script', 'Search', 'Section', 'Select', 'Slot', 'Small', 'Source', 'Span', 'Strong', 'Style', 'Sub', 'Summary', 'Sup', 'Table', 'Tbody', 'Td', 'Template', 'Textarea', 'Tfoot', 'Th', 'Thead', 'Time', 'Title', 'Tr', 'Track', 'U', 'Ul', 'Var', 'Video', 'Wbr']
for o in _all_:
    _g[o] = partial(ft_hx, o.lower())

def File(fname):
    """Use the unescaped text in file `fname` directly"""
    ...

def show(ft, *rest, iframe=False, height='auto', style=None):
    """Renders FT Components into HTML within a Jupyter notebook."""
    ...

def _fill_item(item, obj):
    ...

def fill_form(form: FT, obj) -> FT:
    """Fills named items in `form` using attributes in `obj`"""
    ...

def fill_dataclass(src, dest):
    """Modifies dataclass in-place and returns it"""
    ...

def find_inputs(e, tags='input', **kw):
    """Recursively find all elements in `e` with `tags` and attrs matching `kw`"""
    ...

def __getattr__(tag):
    ...
_re_h2x_attr_key = re.compile('^[A-Za-z_-][\\w-]*$')

def html2ft(html, attr1st=False):
    """Convert HTML to an `ft` expression"""
    ...

def sse_message(elm, event='message'):
    """Convert element `elm` into a format suitable for SSE streaming"""
    ...
def ft_html(tag: str, *c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Any=None, hx_post:Any=None, hx_put:Any=None, hx_delete:Any=None, hx_patch:Any=None, hx_trigger:Any=None, hx_target:Any=None, hx_swap:Any=None, hx_swap_oob:Any=None, hx_include:Any=None, hx_select:Any=None, hx_select_oob:Any=None, hx_indicator:Any=None, hx_push_url:Any=None, hx_confirm:Any=None, hx_disable:Any=None, hx_replace_url:Any=None, hx_vals:Any=None, hx_disabled_elt:Any=None, hx_ext:Any=None, hx_headers:Any=None, hx_history:Any=None, hx_history_elt:Any=None, hx_indicator:Any=None, hx_inherit:Any=None, hx_params:Any=None, hx_preserve:Any=None, hx_prompt:Any=None, hx_replace_url:Any=None, hx_request:Any=None, hx_sync:Any=None, hx_validate:Any=None, **kwargs): ...
def ft_hx(tag: str, *c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Any=None, hx_post:Any=None, hx_put:Any=None, hx_delete:Any=None, hx_patch:Any=None, hx_trigger:Any=None, hx_target:Any=None, hx_swap:Any=None, hx_swap_oob:Any=None, hx_include:Any=None, hx_select:Any=None, hx_select_oob:Any=None, hx_indicator:Any=None, hx_push_url:Any=None, hx_confirm:Any=None, hx_disable:Any=None, hx_replace_url:Any=None, hx_vals:Any=None, hx_disabled_elt:Any=None, hx_ext:Any=None, hx_headers:Any=None, hx_history:Any=None, hx_history_elt:Any=None, hx_indicator:Any=None, hx_inherit:Any=None, hx_params:Any=None, hx_preserve:Any=None, hx_prompt:Any=None, hx_replace_url:Any=None, hx_request:Any=None, hx_sync:Any=None, hx_validate:Any=None, **kwargs): ...
def A(*c, name:Any=None, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Abbr(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Address(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Area(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Article(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Aside(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Audio(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def B(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Base(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Bdi(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Bdo(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Blockquote(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Body(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Br(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Button(*c, name:Any=None, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Canvas(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Caption(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Cite(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Code(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Col(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Colgroup(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Data(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Datalist(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Dd(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Del(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Details(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Dfn(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Dialog(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Div(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Dl(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Dt(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Em(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Embed(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Fencedframe(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Fieldset(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Figcaption(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Figure(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Footer(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Form(*c, name:Any=None, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def H1(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def H2(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def H3(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def H4(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def H5(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def H6(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Head(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Header(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Hgroup(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Hr(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def I(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Iframe(*c, name:Any=None, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Img(*c, name:Any=None, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Input(*c, name:Any=None, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Ins(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Kbd(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Label(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Legend(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Li(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Link(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Main(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Map(*c, name:Any=None, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Mark(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Menu(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Meta(*c, name:Any=None, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Meter(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Nav(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Noscript(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Object(*c, name:Any=None, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Ol(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Optgroup(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Option(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Output(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def P(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Picture(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def PortalExperimental(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Pre(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Progress(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Q(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Rp(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Rt(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Ruby(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def S(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Samp(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Script(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Search(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Section(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Select(*c, name:Any=None, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Slot(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Small(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Source(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Span(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Strong(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Style(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Sub(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Summary(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Sup(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Table(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Tbody(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Td(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Template(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Textarea(*c, name:Any=None, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Tfoot(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Th(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Thead(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Time(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Title(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Tr(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Track(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def U(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Ul(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Var(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Video(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
def Wbr(*c, id:Any=None, cls:Any=None, title:Any=None, style:Any=None, accesskey:Any=None, contenteditable:Any=None, dir:Any=None, draggable:Any=None, enterkeyhint:Any=None, hidden:Any=None, inert:Any=None, inputmode:Any=None, lang:Any=None, popover:Any=None, spellcheck:Any=None, tabindex:Any=None, translate:Any=None, hx_get:Optional[str]=None, hx_post:Optional[str]=None, hx_put:Optional[str]=None, hx_delete:Optional[str]=None, hx_patch:Optional[str]=None, hx_trigger:Optional[str]=None, hx_target:Optional[str]=None, hx_swap:Union[Literal['innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_swap_oob:Union[Literal['true', 'innerHTML', 'outerHTML', 'afterbegin', 'beforebegin', 'beforeend', 'afterend', 'delete', 'none'], str, NoneType]=None, hx_include:Optional[str]=None, hx_select:Optional[str]=None, hx_select_oob:Optional[str]=None, hx_indicator:Optional[str]=None, hx_push_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_confirm:Optional[str]=None, hx_disable:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_vals:Optional[str]=None, hx_disabled_elt:Union[Literal['this', 'next', 'previous'], str, NoneType]=None, hx_ext:Optional[str]=None, hx_headers:Optional[str]=None, hx_history:Union[Literal['false'], str, NoneType]=None, hx_history_elt:Optional[str]=None, hx_indicator:Optional[str]=None, hx_inherit:Optional[str]=None, hx_params:Union[Literal['*', 'none'], str, NoneType]=None, hx_preserve:Optional[str]=None, hx_prompt:Optional[str]=None, hx_replace_url:Union[Literal['true', 'false'], str, NoneType]=None, hx_request:Optional[str]=None, hx_sync:Optional[str]=None, hx_validate:Optional[Literal['true', 'false']]=None, hx_on_blur:Any=None, hx_on_change:Any=None, hx_on_contextmenu:Any=None, hx_on_focus:Any=None, hx_on_input:Any=None, hx_on_invalid:Any=None, hx_on_reset:Any=None, hx_on_select:Any=None, hx_on_submit:Any=None, hx_on_keydown:Any=None, hx_on_keypress:Any=None, hx_on_keyup:Any=None, hx_on_click:Any=None, hx_on_dblclick:Any=None, hx_on_mousedown:Any=None, hx_on_mouseenter:Any=None, hx_on_mouseleave:Any=None, hx_on_mousemove:Any=None, hx_on_mouseout:Any=None, hx_on_mouseover:Any=None, hx_on_mouseup:Any=None, hx_on_wheel:Any=None, hx_on__abort:Any=None, hx_on__after_on_load:Any=None, hx_on__after_process_node:Any=None, hx_on__after_request:Any=None, hx_on__after_settle:Any=None, hx_on__after_swap:Any=None, hx_on__before_cleanup_element:Any=None, hx_on__before_on_load:Any=None, hx_on__before_process_node:Any=None, hx_on__before_request:Any=None, hx_on__before_swap:Any=None, hx_on__before_send:Any=None, hx_on__before_transition:Any=None, hx_on__config_request:Any=None, hx_on__confirm:Any=None, hx_on__history_cache_error:Any=None, hx_on__history_cache_miss:Any=None, hx_on__history_cache_miss_error:Any=None, hx_on__history_cache_miss_load:Any=None, hx_on__history_restore:Any=None, hx_on__before_history_save:Any=None, hx_on__load:Any=None, hx_on__no_sse_source_error:Any=None, hx_on__on_load_error:Any=None, hx_on__oob_after_swap:Any=None, hx_on__oob_before_swap:Any=None, hx_on__oob_error_no_target:Any=None, hx_on__prompt:Any=None, hx_on__pushed_into_history:Any=None, hx_on__replaced_in_history:Any=None, hx_on__response_error:Any=None, hx_on__send_abort:Any=None, hx_on__send_error:Any=None, hx_on__sse_error:Any=None, hx_on__sse_open:Any=None, hx_on__swap_error:Any=None, hx_on__target_error:Any=None, hx_on__timeout:Any=None, hx_on__validation_validate:Any=None, hx_on__validation_failed:Any=None, hx_on__validation_halted:Any=None, hx_on__xhr_abort:Any=None, hx_on__xhr_loadend:Any=None, hx_on__xhr_loadstart:Any=None, hx_on__xhr_progress:Any=None, **kwargs): ...
