"""
Snowflake Account API.

The Snowflake Account API is a REST API that you can use to access, update, and perform certain actions on Account resource in Snowflake.  # noqa: E501

The version of the OpenAPI document: 0.0.1
Contact: support@snowflake.com
Generated by: https://openapi-generator.tech

Do not edit this file manually.
"""

from __future__ import annotations

import json
import pprint
import re

from datetime import datetime
from typing import Any, Optional

from pydantic import BaseModel, ConfigDict, Field, SecretStr, StrictBool, StrictInt, StrictStr, field_validator
from typing_extensions import Annotated


class Account(BaseModel):
    """A model object representing the Account resource.

    Constructs an object of type Account with the provided properties.

    Parameters
    __________
    name : str
        A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
    edition : str
        Snowflake Edition of the account. Possible values to use when creating an account include STANDARD, ENTERPRISE, and BUSINESS_CRITICAL.
    admin_name : str
        Name of the account administrator.
    email : str
        Email address of the account administrator.
    organization_name : str, optional
        Name of the organization — **Read-only:** *any user-provided value will be ignored.*
    region_group : str, optional
        Region group where the account is located. Note - This column is only displayed for organizations that span multiple region groups.
    region : str, optional
        Snowflake Region where the account is located. A Snowflake Region is a distinct location within a cloud platform region that is isolated from other Snowflake Regions. A Snowflake Region can be either multi-tenant or single-tenant (for a Virtual Private Snowflake account).
    created_on : datetime, optional
        Date and time the account was created — **Read-only:** *any user-provided value will be ignored.*
    account_url : str, optional
        Preferred Snowflake account URL that includes the values of organization_name and account_name — **Read-only:** *any user-provided value will be ignored.*
    account_locator : str, optional
        System-assigned identifier of the acccount — **Read-only:** *any user-provided value will be ignored.*
    account_locator_url : str, optional
        Legacy Snowflake account URL syntax that includes the region_name and account_locator — **Read-only:** *any user-provided value will be ignored.*
    managed_accounts : int, optional
        Indicates how many managed accounts have been created by the account — **Read-only:** *any user-provided value will be ignored.*
    consumption_billing_entity_name : str, optional
        Name of the consumption billing entity — **Read-only:** *any user-provided value will be ignored.*
    marketplace_consumer_billing_entity_name : str, optional
        Name of the marketplace consumer billing entity — **Read-only:** *any user-provided value will be ignored.*
    marketplace_provider_billing_entity_name : str, optional
        Name of the marketplace provider billing entity — **Read-only:** *any user-provided value will be ignored.*
    old_account_url : str, optional
        If the original account URL was saved when the account was renamed, provides the original URL. If the original account URL was dropped, the value is NULL even if the account was renamed — **Read-only:** *any user-provided value will be ignored.*
    comment : str, optional
        Optional comment in which to store information related to the account.
    is_org_admin : bool, optional
        Indicates whether the ORGADMIN role is enabled in an account. If TRUE, the role is enabled — **Read-only:** *any user-provided value will be ignored.*
    retention_time : int, optional
        Number of days that historical data is retained for Time Travel — **Read-only:** *any user-provided value will be ignored.*
    dropped_on : datetime, optional
        Date and time the account was dropped — **Read-only:** *any user-provided value will be ignored.*
    scheduled_deletion_time : datetime, optional
        Date and time when the account is scheduled to be permanently deleted. Accounts are deleted within one hour after the scheduled time — **Read-only:** *any user-provided value will be ignored.*
    restored_on : datetime, optional
        Date and time when the account was last restored — **Read-only:** *any user-provided value will be ignored.*
    account_old_url_saved_on : datetime, optional
        If the original account URL was saved when the account was renamed, provides the date and time when the original account URL was saved — **Read-only:** *any user-provided value will be ignored.*
    account_old_url_last_used : datetime, optional
        If the original account URL was saved when the account was renamed, indicates the last time the account was accessed using the original URL — **Read-only:** *any user-provided value will be ignored.*
    organization_old_url : str, optional
        If the account’s organization was changed in a way that created a new account URL and the original account URL was saved, provides the original account URL. If the original account URL was dropped, the value is NULL even if the organization changed — **Read-only:** *any user-provided value will be ignored.*
    organization_old_url_saved_on : datetime, optional
        If the account’s organization was changed in a way that created a new account URL and the original account URL was saved, provides the date and time when the original account URL was saved — **Read-only:** *any user-provided value will be ignored.*
    organization_old_url_last_used : datetime, optional
        If the account’s organization was changed in a way that created a new account URL and the original account URL was saved, indicates the last time the account was accessed using the original account URL — **Read-only:** *any user-provided value will be ignored.*
    organization_url_expiration_on : datetime, optional
        If the account’s organization was changed in a way that created a new account URL and the original account URL was saved, provides the date and time when the original account URL will be dropped. Dropped URLs cannot be used to access the account — **Read-only:** *any user-provided value will be ignored.*
    moved_on : datetime, optional
        Date and time when the account was moved to a different organization — **Read-only:** *any user-provided value will be ignored.*
    is_events_account : bool, optional
        Indicates whether an account is an events account. For more information, see Set up logging and event sharing for an application — **Read-only:** *any user-provided value will be ignored.*
    moved_to_organization : str, optional
        If the account was moved to a different organization, provides the name of that organization — **Read-only:** *any user-provided value will be ignored.*
    admin_password : str, optional
        Password for the account administrator.
    admin_rsa_public_key : str, optional
        RSA public key for the account administrator.
    admin_user_type : str, optional
        User type of the account administrator.
    first_name : str, optional
        First name of the account administrator.
    last_name : str, optional
        Last name of the account administrator.
    must_change_password : bool,  default False
        Indicates whether the account administrator must change the password at the next login.
    polaris : bool,  default False
        Indicates whether the account is a Polaris account.
    """

    organization_name: Optional[StrictStr] = None

    name: Annotated[str, Field(strict=True)]

    region_group: Optional[StrictStr] = None

    region: Optional[StrictStr] = None

    edition: StrictStr

    created_on: Optional[datetime] = None

    account_url: Optional[StrictStr] = None

    account_locator: Optional[StrictStr] = None

    account_locator_url: Optional[StrictStr] = None

    managed_accounts: Optional[StrictInt] = None

    consumption_billing_entity_name: Optional[StrictStr] = None

    marketplace_consumer_billing_entity_name: Optional[StrictStr] = None

    marketplace_provider_billing_entity_name: Optional[StrictStr] = None

    old_account_url: Optional[StrictStr] = None

    comment: Optional[StrictStr] = None

    is_org_admin: Optional[StrictBool] = None

    retention_time: Optional[StrictInt] = None

    dropped_on: Optional[datetime] = None

    scheduled_deletion_time: Optional[datetime] = None

    restored_on: Optional[datetime] = None

    account_old_url_saved_on: Optional[datetime] = None

    account_old_url_last_used: Optional[datetime] = None

    organization_old_url: Optional[StrictStr] = None

    organization_old_url_saved_on: Optional[datetime] = None

    organization_old_url_last_used: Optional[datetime] = None

    organization_url_expiration_on: Optional[datetime] = Field(default=None, alias="organization_URL_expiration_on")

    moved_on: Optional[datetime] = None

    is_events_account: Optional[StrictBool] = None

    moved_to_organization: Optional[StrictStr] = None

    admin_name: Optional[StrictStr]

    admin_password: Optional[SecretStr] = None

    admin_rsa_public_key: Optional[SecretStr] = None

    admin_user_type: Optional[StrictStr] = None

    first_name: Optional[StrictStr] = None

    last_name: Optional[StrictStr] = None

    email: Optional[StrictStr]

    must_change_password: Optional[StrictBool] = False

    polaris: Optional[StrictBool] = False

    __properties = [
        "organization_name",
        "name",
        "region_group",
        "region",
        "edition",
        "created_on",
        "account_url",
        "account_locator",
        "account_locator_url",
        "managed_accounts",
        "consumption_billing_entity_name",
        "marketplace_consumer_billing_entity_name",
        "marketplace_provider_billing_entity_name",
        "old_account_url",
        "comment",
        "is_org_admin",
        "retention_time",
        "dropped_on",
        "scheduled_deletion_time",
        "restored_on",
        "account_old_url_saved_on",
        "account_old_url_last_used",
        "organization_old_url",
        "organization_old_url_saved_on",
        "organization_old_url_last_used",
        "organization_URL_expiration_on",
        "moved_on",
        "is_events_account",
        "moved_to_organization",
        "admin_name",
        "admin_password",
        "admin_rsa_public_key",
        "admin_user_type",
        "first_name",
        "last_name",
        "email",
        "must_change_password",
        "polaris",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, v):
        if not re.match(r"""^\"([^\"]|\"\")+\"|[a-zA-Z_][a-zA-Z0-9_$]*$""", v):
            raise ValueError(r"""must validate the regular expression /^"([^"]|"")+"|[a-zA-Z_][a-zA-Z0-9_$]*$/""")
        return v

    model_config = ConfigDict(
        validate_by_name=True,
        validate_assignment=True,
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias."""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias."""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Account:
        """Create an instance of Account from a JSON string."""
        return cls.from_dict(json.loads(json_str))

    def to_dict(
        self,
        hide_readonly_properties: bool = False,
    ) -> dict[str, Any]:
        """Returns the dictionary representation of the model using alias."""
        exclude_properties = set()

        if hide_readonly_properties:
            exclude_properties.update(
                {
                    "organization_name",
                    "created_on",
                    "account_url",
                    "account_locator",
                    "account_locator_url",
                    "managed_accounts",
                    "consumption_billing_entity_name",
                    "marketplace_consumer_billing_entity_name",
                    "marketplace_provider_billing_entity_name",
                    "old_account_url",
                    "is_org_admin",
                    "retention_time",
                    "dropped_on",
                    "scheduled_deletion_time",
                    "restored_on",
                    "account_old_url_saved_on",
                    "account_old_url_last_used",
                    "organization_old_url",
                    "organization_old_url_saved_on",
                    "organization_old_url_last_used",
                    "organization_url_expiration_on",
                    "moved_on",
                    "is_events_account",
                    "moved_to_organization",
                }
            )

        _dict = self.model_dump(serialize_as_any=True, by_alias=True, exclude=exclude_properties, exclude_none=True)

        # set to None if dropped_on (nullable) is None
        if self.dropped_on is None:
            _dict["dropped_on"] = None

        # set to None if scheduled_deletion_time (nullable) is None
        if self.scheduled_deletion_time is None:
            _dict["scheduled_deletion_time"] = None

        # set to None if restored_on (nullable) is None
        if self.restored_on is None:
            _dict["restored_on"] = None

        # set to None if organization_url_expiration_on (nullable) is None
        if self.organization_url_expiration_on is None:
            _dict["organization_URL_expiration_on"] = None

        # set to None if moved_on (nullable) is None
        if self.moved_on is None:
            _dict["moved_on"] = None

        # set to None if admin_name (nullable) is None
        if self.admin_name is None:
            _dict["admin_name"] = None

        # set to None if email (nullable) is None
        if self.email is None:
            _dict["email"] = None

        return _dict

    def to_dict_without_readonly_properties(self) -> dict[str, Any]:
        """Return the dictionary representation of the model without readonly properties."""
        return self.to_dict(hide_readonly_properties=True)

    @classmethod
    def from_dict(cls, obj: dict) -> Account:
        """Create an instance of Account from a dict."""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Account.model_validate(obj)

        _obj = Account.model_validate(
            {
                "organization_name": obj.get("organization_name"),
                "name": obj.get("name"),
                "region_group": obj.get("region_group"),
                "region": obj.get("region"),
                "edition": obj.get("edition"),
                "created_on": obj.get("created_on"),
                "account_url": obj.get("account_url"),
                "account_locator": obj.get("account_locator"),
                "account_locator_url": obj.get("account_locator_url"),
                "managed_accounts": obj.get("managed_accounts"),
                "consumption_billing_entity_name": obj.get("consumption_billing_entity_name"),
                "marketplace_consumer_billing_entity_name": obj.get("marketplace_consumer_billing_entity_name"),
                "marketplace_provider_billing_entity_name": obj.get("marketplace_provider_billing_entity_name"),
                "old_account_url": obj.get("old_account_url"),
                "comment": obj.get("comment"),
                "is_org_admin": obj.get("is_org_admin"),
                "retention_time": obj.get("retention_time"),
                "dropped_on": obj.get("dropped_on"),
                "scheduled_deletion_time": obj.get("scheduled_deletion_time"),
                "restored_on": obj.get("restored_on"),
                "account_old_url_saved_on": obj.get("account_old_url_saved_on"),
                "account_old_url_last_used": obj.get("account_old_url_last_used"),
                "organization_old_url": obj.get("organization_old_url"),
                "organization_old_url_saved_on": obj.get("organization_old_url_saved_on"),
                "organization_old_url_last_used": obj.get("organization_old_url_last_used"),
                "organization_url_expiration_on": obj.get("organization_URL_expiration_on"),
                "moved_on": obj.get("moved_on"),
                "is_events_account": obj.get("is_events_account"),
                "moved_to_organization": obj.get("moved_to_organization"),
                "admin_name": obj.get("admin_name"),
                "admin_password": obj.get("admin_password"),
                "admin_rsa_public_key": obj.get("admin_rsa_public_key"),
                "admin_user_type": obj.get("admin_user_type"),
                "first_name": obj.get("first_name"),
                "last_name": obj.get("last_name"),
                "email": obj.get("email"),
                "must_change_password": obj.get("must_change_password")
                if obj.get("must_change_password") is not None
                else False,
                "polaris": obj.get("polaris") if obj.get("polaris") is not None else False,
            }
        )

        return _obj


class AccountModel:
    def __init__(
        self,
        name: str,
        edition: str,
        admin_name: str,
        email: str,
        # optional properties
        organization_name: Optional[str] = None,
        region_group: Optional[str] = None,
        region: Optional[str] = None,
        created_on: Optional[datetime] = None,
        account_url: Optional[str] = None,
        account_locator: Optional[str] = None,
        account_locator_url: Optional[str] = None,
        managed_accounts: Optional[int] = None,
        consumption_billing_entity_name: Optional[str] = None,
        marketplace_consumer_billing_entity_name: Optional[str] = None,
        marketplace_provider_billing_entity_name: Optional[str] = None,
        old_account_url: Optional[str] = None,
        comment: Optional[str] = None,
        is_org_admin: Optional[bool] = None,
        retention_time: Optional[int] = None,
        dropped_on: Optional[datetime] = None,
        scheduled_deletion_time: Optional[datetime] = None,
        restored_on: Optional[datetime] = None,
        account_old_url_saved_on: Optional[datetime] = None,
        account_old_url_last_used: Optional[datetime] = None,
        organization_old_url: Optional[str] = None,
        organization_old_url_saved_on: Optional[datetime] = None,
        organization_old_url_last_used: Optional[datetime] = None,
        organization_url_expiration_on: Optional[datetime] = None,
        moved_on: Optional[datetime] = None,
        is_events_account: Optional[bool] = None,
        moved_to_organization: Optional[str] = None,
        admin_password: Optional[str] = None,
        admin_rsa_public_key: Optional[str] = None,
        admin_user_type: Optional[str] = None,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        must_change_password: Optional[bool] = False,
        polaris: Optional[bool] = False,
    ):
        """A model object representing the Account resource.

        Constructs an object of type Account with the provided properties.

        Parameters
        __________
        name : str
            A Snowflake object identifier. If the identifier contains spaces or special characters, the entire string must be enclosed in double quotes. Identifiers enclosed in double quotes are also case-sensitive.
        edition : str
            Snowflake Edition of the account. Possible values to use when creating an account include STANDARD, ENTERPRISE, and BUSINESS_CRITICAL.
        admin_name : str
            Name of the account administrator.
        email : str
            Email address of the account administrator.
        organization_name : str, optional
            Name of the organization.
        region_group : str, optional
            Region group where the account is located. Note - This column is only displayed for organizations that span multiple region groups.
        region : str, optional
            Snowflake Region where the account is located. A Snowflake Region is a distinct location within a cloud platform region that is isolated from other Snowflake Regions. A Snowflake Region can be either multi-tenant or single-tenant (for a Virtual Private Snowflake account).
        created_on : datetime, optional
            Date and time the account was created.
        account_url : str, optional
            Preferred Snowflake account URL that includes the values of organization_name and account_name.
        account_locator : str, optional
            System-assigned identifier of the acccount.
        account_locator_url : str, optional
            Legacy Snowflake account URL syntax that includes the region_name and account_locator.
        managed_accounts : int, optional
            Indicates how many managed accounts have been created by the account.
        consumption_billing_entity_name : str, optional
            Name of the consumption billing entity.
        marketplace_consumer_billing_entity_name : str, optional
            Name of the marketplace consumer billing entity.
        marketplace_provider_billing_entity_name : str, optional
            Name of the marketplace provider billing entity.
        old_account_url : str, optional
            If the original account URL was saved when the account was renamed, provides the original URL. If the original account URL was dropped, the value is NULL even if the account was renamed
        comment : str, optional
            Optional comment in which to store information related to the account.
        is_org_admin : bool, optional
            Indicates whether the ORGADMIN role is enabled in an account. If TRUE, the role is enabled.
        retention_time : int, optional
            Number of days that historical data is retained for Time Travel.
        dropped_on : datetime, optional
            Date and time the account was dropped.
        scheduled_deletion_time : datetime, optional
            Date and time when the account is scheduled to be permanently deleted. Accounts are deleted within one hour after the scheduled time.
        restored_on : datetime, optional
            Date and time when the account was last restored.
        account_old_url_saved_on : datetime, optional
            If the original account URL was saved when the account was renamed, provides the date and time when the original account URL was saved.
        account_old_url_last_used : datetime, optional
            If the original account URL was saved when the account was renamed, indicates the last time the account was accessed using the original URL.
        organization_old_url : str, optional
            If the account’s organization was changed in a way that created a new account URL and the original account URL was saved, provides the original account URL. If the original account URL was dropped, the value is NULL even if the organization changed.
        organization_old_url_saved_on : datetime, optional
            If the account’s organization was changed in a way that created a new account URL and the original account URL was saved, provides the date and time when the original account URL was saved.
        organization_old_url_last_used : datetime, optional
            If the account’s organization was changed in a way that created a new account URL and the original account URL was saved, indicates the last time the account was accessed using the original account URL.
        organization_url_expiration_on : datetime, optional
            If the account’s organization was changed in a way that created a new account URL and the original account URL was saved, provides the date and time when the original account URL will be dropped. Dropped URLs cannot be used to access the account.
        moved_on : datetime, optional
            Date and time when the account was moved to a different organization.
        is_events_account : bool, optional
            Indicates whether an account is an events account. For more information, see Set up logging and event sharing for an application.
        moved_to_organization : str, optional
            If the account was moved to a different organization, provides the name of that organization.
        admin_password : str, optional
            Password for the account administrator.
        admin_rsa_public_key : str, optional
            RSA public key for the account administrator.
        admin_user_type : str, optional
            User type of the account administrator.
        first_name : str, optional
            First name of the account administrator.
        last_name : str, optional
            Last name of the account administrator.
        must_change_password : bool,  default False
            Indicates whether the account administrator must change the password at the next login.
        polaris : bool,  default False
            Indicates whether the account is a Polaris account.
        """
        self.organization_name = organization_name
        self.name = name
        self.region_group = region_group
        self.region = region
        self.edition = edition
        self.created_on = created_on
        self.account_url = account_url
        self.account_locator = account_locator
        self.account_locator_url = account_locator_url
        self.managed_accounts = managed_accounts
        self.consumption_billing_entity_name = consumption_billing_entity_name
        self.marketplace_consumer_billing_entity_name = marketplace_consumer_billing_entity_name
        self.marketplace_provider_billing_entity_name = marketplace_provider_billing_entity_name
        self.old_account_url = old_account_url
        self.comment = comment
        self.is_org_admin = is_org_admin
        self.retention_time = retention_time
        self.dropped_on = dropped_on
        self.scheduled_deletion_time = scheduled_deletion_time
        self.restored_on = restored_on
        self.account_old_url_saved_on = account_old_url_saved_on
        self.account_old_url_last_used = account_old_url_last_used
        self.organization_old_url = organization_old_url
        self.organization_old_url_saved_on = organization_old_url_saved_on
        self.organization_old_url_last_used = organization_old_url_last_used
        self.organization_url_expiration_on = organization_url_expiration_on
        self.moved_on = moved_on
        self.is_events_account = is_events_account
        self.moved_to_organization = moved_to_organization
        self.admin_name = admin_name
        self.admin_password = admin_password
        self.admin_rsa_public_key = admin_rsa_public_key
        self.admin_user_type = admin_user_type
        self.first_name = first_name
        self.last_name = last_name
        self.email = email
        self.must_change_password = must_change_password
        self.polaris = polaris

    __properties = [
        "organization_name",
        "name",
        "region_group",
        "region",
        "edition",
        "created_on",
        "account_url",
        "account_locator",
        "account_locator_url",
        "managed_accounts",
        "consumption_billing_entity_name",
        "marketplace_consumer_billing_entity_name",
        "marketplace_provider_billing_entity_name",
        "old_account_url",
        "comment",
        "is_org_admin",
        "retention_time",
        "dropped_on",
        "scheduled_deletion_time",
        "restored_on",
        "account_old_url_saved_on",
        "account_old_url_last_used",
        "organization_old_url",
        "organization_old_url_saved_on",
        "organization_old_url_last_used",
        "organization_URL_expiration_on",
        "moved_on",
        "is_events_account",
        "moved_to_organization",
        "admin_name",
        "admin_password",
        "admin_rsa_public_key",
        "admin_user_type",
        "first_name",
        "last_name",
        "email",
        "must_change_password",
        "polaris",
    ]

    def __repr__(self) -> str:
        return repr(self._to_model())

    def _to_model(self):
        return Account(
            organization_name=self.organization_name,
            name=self.name,
            region_group=self.region_group,
            region=self.region,
            edition=self.edition,
            created_on=self.created_on,
            account_url=self.account_url,
            account_locator=self.account_locator,
            account_locator_url=self.account_locator_url,
            managed_accounts=self.managed_accounts,
            consumption_billing_entity_name=self.consumption_billing_entity_name,
            marketplace_consumer_billing_entity_name=self.marketplace_consumer_billing_entity_name,
            marketplace_provider_billing_entity_name=self.marketplace_provider_billing_entity_name,
            old_account_url=self.old_account_url,
            comment=self.comment,
            is_org_admin=self.is_org_admin,
            retention_time=self.retention_time,
            dropped_on=self.dropped_on,
            scheduled_deletion_time=self.scheduled_deletion_time,
            restored_on=self.restored_on,
            account_old_url_saved_on=self.account_old_url_saved_on,
            account_old_url_last_used=self.account_old_url_last_used,
            organization_old_url=self.organization_old_url,
            organization_old_url_saved_on=self.organization_old_url_saved_on,
            organization_old_url_last_used=self.organization_old_url_last_used,
            organization_url_expiration_on=self.organization_url_expiration_on,
            moved_on=self.moved_on,
            is_events_account=self.is_events_account,
            moved_to_organization=self.moved_to_organization,
            admin_name=self.admin_name,
            admin_password=self.admin_password,
            admin_rsa_public_key=self.admin_rsa_public_key,
            admin_user_type=self.admin_user_type,
            first_name=self.first_name,
            last_name=self.last_name,
            email=self.email,
            must_change_password=self.must_change_password,
            polaris=self.polaris,
        )

    @classmethod
    def _from_model(cls, model) -> AccountModel:
        return AccountModel(
            organization_name=model.organization_name,
            name=model.name,
            region_group=model.region_group,
            region=model.region,
            edition=model.edition,
            created_on=model.created_on,
            account_url=model.account_url,
            account_locator=model.account_locator,
            account_locator_url=model.account_locator_url,
            managed_accounts=model.managed_accounts,
            consumption_billing_entity_name=model.consumption_billing_entity_name,
            marketplace_consumer_billing_entity_name=model.marketplace_consumer_billing_entity_name,
            marketplace_provider_billing_entity_name=model.marketplace_provider_billing_entity_name,
            old_account_url=model.old_account_url,
            comment=model.comment,
            is_org_admin=model.is_org_admin,
            retention_time=model.retention_time,
            dropped_on=model.dropped_on,
            scheduled_deletion_time=model.scheduled_deletion_time,
            restored_on=model.restored_on,
            account_old_url_saved_on=model.account_old_url_saved_on,
            account_old_url_last_used=model.account_old_url_last_used,
            organization_old_url=model.organization_old_url,
            organization_old_url_saved_on=model.organization_old_url_saved_on,
            organization_old_url_last_used=model.organization_old_url_last_used,
            organization_url_expiration_on=model.organization_url_expiration_on,
            moved_on=model.moved_on,
            is_events_account=model.is_events_account,
            moved_to_organization=model.moved_to_organization,
            admin_name=model.admin_name,
            admin_password=model.admin_password,
            admin_rsa_public_key=model.admin_rsa_public_key,
            admin_user_type=model.admin_user_type,
            first_name=model.first_name,
            last_name=model.last_name,
            email=model.email,
            must_change_password=model.must_change_password,
            polaris=model.polaris,
        )

    def to_dict(self):
        """Create a dictionary of the properties from a Account.

        This method constructs a dictionary with the key-value entries corresponding to the properties of the Account object.

        Returns
        _______
        dict
            A dictionary object created using the input model.
        """
        return self._to_model().to_dict()

    @classmethod
    def from_dict(cls, obj: dict) -> AccountModel:
        """Create an instance of Account from a dict.

        This method constructs a Account object from a dictionary with the key-value pairs of its properties.

        Parameters
        ----------
        obj : dict
            A dictionary whose keys and values correspond to the properties of the resource object.

        Returns
        _______
        Account
            A Account object created using the input dictionary; this will fail if the required properties are missing.
        """
        return cls._from_model(Account.from_dict(obj))


Account._model_class = AccountModel
